/*
 * parser.c - Memory iButton File Manager
 *
 *  Copyright (c) by 	Karl-Martin Skontorp <kms@users.sourceforge.net>
 *			Martin Dahl <iznogood@users.sourceforge.net>
 *
 *  			Anders Semb Hermansen <ahermans@users.sourceforge.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "mibfm.h"

void parse_args(int argc, char **argv);
void show_version(void);
void print_banner(void);
void show_params(void);

void parse_args(int argc, char **argv)
{

    char c;

    /* Parse the command line */
    while ((c = getopt(argc, argv, "vhqc:b:u:d:f:")) != EOF) {
	switch (c) {
	    case 'v':
		show_version();
		break;
	    case 'h':
		show_params();
		break;
	    case 'q':
		quiet = 1;
		break;
	    case 'c':
		switch (atol(optarg)) {
		    case 1:
			port = COM1;
			break;
		    case 2:
			port = COM2;
			break;
		    case 3:
			port = COM3;
			break;
		    case 4:
			port = COM4;
			break;
		    default:
			printf("%s: unkown com port specified\n", argv[0]);
			show_params();
			break;
		}
		break;
	    case 'b':
		switch (atol(optarg)) {
		    case 3:
			family = DS1993;
			break;
		    case 5:
			family = DS1995;
			break;
		    case 6:
			family = DS1996;
			break;
		    default:
			printf("%s: unkown button family specified\n", argv[0]);
			show_params();
			break;
		}
		break;
	    case 'u':
		filename = optarg;
		command = C_UPLOAD;
		break;
	    case 'd':
		filename = optarg;
		command = C_DOWNLOAD;
		break;
	    case 'f':
		ib_filename = optarg;
		break;
	    default:
		show_params();
		break;
	}
    }

    return;
}

void print_banner()
{
    printf("mibfm - version %s\n", VERSION);
    printf("http://mibfm.sourceforge.net\n");
    printf("\n");
}

void show_version()
{
    printf("mibfm - version %s\n", VERSION);
    printf("This is free software with ABSOLUTELY NO WARRANTY.\n");
    printf("See included file COPYING for more information.\n");
    exit(1);
}

void show_params() 
{
    printf("mibfm - 	version %s\n", VERSION);
    printf("		by Karl-Martin Skontorp,\n");
    printf("		http://mibfm.sourceforge.net\n");
    printf("\n");
    printf("This is free software with ABSOLUTELY NO WARRANTY.\n");
    printf("See included file COPYING for more information.\n");
    printf("\n");
    printf("options:	-v		Show version.\n");
    printf("		-h		Show this message.\n");
    printf("\n");
    printf("\n");
    printf("		-c <port>	Com port, 	1 (%s) Default\n", COM1);
    printf("					  	2 (%s)\n", COM2);
    printf("					  	3 (%s)\n", COM3);
    printf("					  	4 (%s)\n", COM4);
    printf("\n");
    printf("		-b <family>	Button family, 	3 (DS1993)\n");
    printf("						5 (DS1995)\n");
    printf("						6 (DS1996) Default\n");
    printf("\n");
    printf("		-u <filename>	Upload file\n");
    printf("		-d <filename> 	Download file\n");
    printf("		-f <filename> 	iButton filename\n");
    exit(1);
}
