/*
 * mibfm.h - Memory iButton File Manager
 *
 *  Copyright (c) by 	Karl-Martin Skontorp <kms@users.sourceforge.net>
 *			Martin Dahl <iznogood@users.sourceforge.net>
 *
 *  			Anders Semb Hermansen <ahermans@users.sourceforge.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _MIBFM_H_
#define _MIBFM_H_

#include "mlan.h"

#define VERSION		"0.1"

#define COM1		"/dev/ttyS0"
#define COM2		"/dev/ttyS1"
#define COM3		"/dev/ttyS2"
#define COM4		"/dev/ttyS3"
#define DEFAULT_PORT	COM1

#define DS1993		0x06
#define DS1995		0x0A
#define DS1996		0x0C

#define DEFAULT_FILE	"DEF"

#define MAX_FILESIZE	7084

#define C_UPLOAD 1
#define C_DOWNLOAD 2

int family;
char *port;

char *ib_filename;
char *filename;

int command;
int force;
int quiet;

FILE *local_file; // Local file, both when download and upload

#endif /* _MIBFM_H_ */
