.\"
.\"	$Id: md4sum.man,v 1.6 2007-04-11 21:28:27 solyga Exp $
.\"
.TH [%s PRG_NAME] [%d MANUAL_NUMBER] "[%s DATE_OF_LAST_MOD]" "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"
.SH NAME
[%s prg_name] \- generate or check MD4 message digests
.SH SYNOPSIS
.B [%s prg_name]
.RB [ -cehnvV ]
.RI [ file(s) ]

.SH DESCRIPTION
.B [%s Prg_name]
generates or checks MD4 checksums applying the algorithm specified in
.IR "RFC 1320" .
Its default behavior is to generate and print checksums for all
.I files
passed as arguments.

If, however,
.B -c
is specified, only the first file is read. It should contain
checksums and filenames to which these checksums refer to,
and the files listed in that file are checked against the
checksums listed there.

As usual, the special character '-' stands for standard input.

.SH OPTIONS
.TP
.B -c
Check the md4sum of all files listed in
.I file
against the checksums listed in the same
.IR file .
The format of that
.I file
is the same as the output of
.BR "[%s prg_name] -n" .
White spaces are allowed everywhere
(except within the checksums :-).
Lines starting with the character '#' are interpreted as comments.
.TP
.B -e
Print ed2k link instead of MD4 checksum.
.TP
.B -h
Display some helpful information on
.I [%s HELP_CHANNEL_STR]
and exit successfully.
.TP
.B -n
Print filenames along with the simple checksums.
.TP
.B -v
Increase verbosity level on
.I [%s VERBOSE_CHANNEL_STR]
by one (maximum [%d VERBOSE_LEVEL_MAX]).
.TP
.B -V
Display version and compilation info on
.I [%s VERSION_CHANNEL_STR]
and exit successfully.

.SH RETURN VALUE
On success, [%d RETVAL_OK] is returned. On error, a value >0 is returned.

.SH ERRORS
.TP
.B [%d RETVAL_FAILED]
at least one check failed
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH BUGS
The MD4 message digest algorithm was broken in October 1995.

.SH AUTHOR
The core routines are derived from the RSA Data Security, Inc.
MD4 Message-Digest Algorithm published with
.IR "RFC 1320" .
The interface was written by [%s MY_EMAIL_ADDRESS].

.SH SEE ALSO
.BR md5sum (1),
.BR openssl (1),
.BR ed2k_hash (1)

