/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#ifndef TEX_LIST_H
#define TEX_LIST_H

#include <gtk/gtkalignment.h>


#define TEXTLIST(obj)          GTK_CHECK_CAST (obj, text_list_get_type (), TextList)
#define TEXTLIST_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, text_list_get_type (), TextListClass)
#define IS_TEXTLIST(obj)       GTK_CHECK_TYPE (obj, text_list_get_type ())

#define TEXTLIST_FLAGS(tlist)             (TEXTLIST (tlist)->flags)
#define TEXTLIST_SET_FLAGS(tlist,flag)    (TEXTLIST_FLAGS (tlist) |= (flag))
#define TEXTLIST_UNSET_FLAGS(tlist,flag)  (TEXTLIST_FLAGS (tlist) &= ~(flag))

typedef struct _TextList TextList;
typedef struct _TextListClass TextListClass;
typedef struct _TextListRow TextListRow;

struct _TextList
{
  GtkContainer container;

  GtkWidget *child;
  guint8 flags;

  /* allocation rectangle after the conatiner_border_width
   * and the width of the shadow border */
  GdkRectangle internal_allocation;

  /* rows */
  gint rows;
  gint row_center_offset;
  gint row_height;
  TextListRow *row_array;
  
  /*the scrolling window and it's height and width to
   * make things a little speedier */
  GdkWindow *tlist_window;
  gint tlist_window_width;
  gint tlist_window_height;
  
  /* offsets for scrolling */
  gint voffset;
  
  /* border shadow style */
  GtkShadowType shadow_type;
  
  /* list of selected rows */
  GList *selection;

  /* active row */
  gint active_row;
  gint last_active_row;

  /* scrollbars */
  GtkWidget *vscrollbar;
  guint8 vscrollbar_policy;

  /* gc for drawing unselected cells */
  GdkGC *fg_gc;
  GdkGC *bg_gc;
 };

struct _TextListClass
{
  GtkContainerClass parent_class;

  void (*select_row) (TextList * tlist, gint row);
  void (*unselect_row) (TextList * tlist, gint row);
  void (*action) (TextList *tlist);
  void (*menu_popup) (TextList *tlist, guint button, guint32 time);
  void (*do_it) (TextList *tlist, GtkSignalFunc f);
  
  gint scrollbar_spacing;
};

struct _TextListRow
{
  GtkStateType state;

  gchar *text;

  GdkColor *foreground;
  GdkColor *background;
};

guint text_list_get_type();

/* create a new TextList */
GtkWidget *text_list_new ();

/* sets the size of the list */
extern void text_list_set_size(TextList * tlist, gint size);

/* sets a given cell's text, replacing it's current contents */
extern void text_list_set_text (TextList * tlist, gint row, gchar * text);

/* display the list (after text_list_set_size and text_list_set_text for example) */
extern void text_list_first_display(TextList * tlist);

/* sets the foreground color of a row, the colar must already
 * be allocated */
extern void text_list_set_foreground (TextList * tlist, gint row, GdkColor * color);

/* clear the entire list -- this is much faster than removing each item 
 * with text_list_remove */
extern void text_list_clear (TextList * tlist);

extern gboolean text_list_is_empty(TextList *tlist);

/*******************************************************************************/
/* functions for manipulating the active row and the selection */
/*******************************************************************************/
extern gboolean text_list_set_active_row(TextList *tlist, gint row);
extern void text_list_set_active_row_and_show(TextList *tlist, gint row, gfloat row_align);
extern void text_list_select_all(TextList *tlist);
extern void text_list_invert_selection(TextList *tlist);
extern void text_list_get_coords(TextList *tlist, gint row, gint column, gint *x, gint *y);
extern void text_list_select_all(TextList *tlist);




#endif				/* __TEXTLIST_H__ */
