/*
                ,,,
               (o o)
  ####=====oOO--(_)--OOO==========================================####
  ##                                                                ##
  ##  This file is part of NCD : a directory browser and selector   ##
  ##  Copyright (C) 1995,96 by Olivier Sirol                        ##
  ##                                                                ##
  ##  Original Copyright (C) 1995 Borja Etxebarria                  ##
  ##  E-mail : borja@bips.bi.ehu.es                                 ##
  ##                                                                ##
  ##  File            :  nodes.c                                    ##
  ##  Author          :  Olivier SIROL                              ##
  ##  Date            :  Nov 1995                                   ##
  ##                                                                ##
  ##  E-mail support  :  sirol@ecoledoc.ibp.fr                      ##
  ##                                                                ##
  ####============================================================####


*/


static char rcsid[] = "$Id: nodes.c,v 1.18 1996/05/13 21:33:16 olivier Exp $";


/*##==============================================================####
##                                                                  ##
##                          Include Files                           ##
##                                                                  ##
####==============================================================##*/


# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <unistd.h>
# include <sys/stat.h>
# include <ctype.h>

# include <dirent.h>
# include "ncd.h"


/*##==============================================================####
##                                                                  ##
##                            Constants                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                              Types                               ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Variables                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Functions                             ##
##                                                                  ##
####==============================================================##*/


/***********************************************************************/
void *
ncd_malloc (nbytes)
     unsigned int nbytes;
{
  void *pt;

  if (!(pt = malloc (nbytes)))
    {
      cleanUp ();
      (void) fflush (stdout);
      (void) fflush (stderr);
      (void) fprintf (stderr, "## ncd error ## : not enough memory for malloc\n");
      exit (11);
    }
  return pt;
}


/***********************************************************************/
void *
ncd_strdup (string)
     char *string;
{
  void *pt;

  if (!(pt = strdup (string)))
    {
      cleanUp ();
      (void) fflush (stdout);
      (void) fflush (stderr);
      (void) fprintf (stderr, "## ncd error ## : not enough memory for strdup\n");
      exit (12);
    }
  return pt;
}


/***********************************************************************/
void
ncd_exit (msg, fname)
     char *msg;
     char *fname;
{
  cleanUp ();
  (void) fflush (stdout);
  (void) fflush (stderr);
  fprintf (stderr, "## ncd error ## : ");
  fprintf (stderr, msg, fname);
  exit (13);
}


/*************************************************************************/
/* basename must end with a slash. If {baseNode} is NULL, it is also
   created based on {baseName} */

DirNode *
readDirsInNodes (baseName, baseNode)
     char *baseName;
     DirNode *baseNode;

{
  char fullName[PATH_MAX];
  DIR *dir;
  int testproc;
  DirNode *lastUp;
  static int i;
  static DirNode *newNode;
  static struct dirent *entry;
  static char linkName[PATH_MAX];
  static struct stat entryStat;

  if ((NCD_verbose) && (!NCD_cursesOn))
    fprintf (stderr, "%s\n", baseName);
  if (NCD_cursesOn)
    cursMsg ("Rebuilding directory structure", baseName, NO_BUTTON);

  if (baseNode == NULL)
    {
      baseNode = ncd_malloc (sizeof (DirNode));
      baseNode->left = baseNode->right = baseNode->up =
	baseNode->down = NULL;
      baseNode->lname = NULL;
      baseNode->name = getDirName (baseName);
    }

  dir = opendir (baseName);
  if (dir != NULL)
    {
      testproc = (strcmp (baseName, "/") == 0);
      lastUp = NULL;
      while ((entry = readdir (dir)) != NULL)
	{
	  if ((strcmp (entry->d_name, ".") != 0) &&
	      (strcmp (entry->d_name, "..") != 0)
	  /* && ((!testproc) || (strcmp(entry->d_name, "proc") != 0)) */ )
	    {
	      sprintf (fullName, "%s%s", baseName, entry->d_name);
	      i = stat (fullName, &entryStat);
	      if (S_ISDIR (entryStat.st_mode))
		{
		  newNode = ncd_malloc (sizeof (DirNode));
		  newNode->name = ncd_strdup (entry->d_name);
		  newNode->left = baseNode;
		  newNode->right = NULL;
		  newNode->up = lastUp;
		  newNode->down = NULL;
		  if (baseNode->right == NULL)
		    baseNode->right = newNode;
		  if (lastUp != NULL)
		    lastUp->down = newNode;
		  lastUp = newNode;
		  i = lstat (fullName, &entryStat);
		  if (S_ISLNK (entryStat.st_mode))
		    {
		      i = readlink (fullName, linkName, PATH_MAX);
		      linkName[(i < 0) ? 0 : i] = '\0';
		      if ((NCD_verbose) && (!NCD_cursesOn))
			fprintf (stderr, "%s -> %s\n", fullName, linkName);
		      newNode->lname = ncd_strdup (linkName);
		    }
		  else
		    {		/* not a link */
		      newNode->lname = NULL;
		      addSlash (fullName);
		      if ((!testproc) || (strcmp (entry->d_name, "proc") != 0))
			readDirsInNodes (fullName, newNode);
		    }
		}
	    }
	}
      closedir (dir);
    }

  return baseNode;
}
/*************************************************************************/

DirNode *readNodesFromFile(fname)
char *fname;

{
	char line[PATH_MAX + 3];
	DirNode *node, *first, *oldNode;
	FILE *f;
	size_t len;

	f = fopen(fname, "r");
	if (f == NULL) {
		if ((NCD_verbose)&&(!NCD_cursesOn))
			fprintf(stderr, "warning: can't read file %s\n", fname);
		return NULL;
	}
	node = first = oldNode = NULL;
	while (fgets(line, PATH_MAX + 3, f) != NULL) {
		len = strlen(line);
		if (len < 2)
			continue;
		line[len - 1] = 0;	/* strip \n */
		switch (line[0]) {
		case '>':	/* son */
			node = ncd_malloc(sizeof(DirNode));
			node->name = ncd_strdup(line + 2);
			node->lname = NULL;
			node->left = oldNode;
			node->right = node->up = node->down = NULL;
			if (oldNode == NULL)
				first = node;
			else
				oldNode->right = node;

			oldNode = node;
			break;
		case '<':	/* one up */
			if ((oldNode == NULL)) 
                             ncd_exit("invalid file %s\n", fname);
			oldNode = oldNode->left;
			break;
		case 'V':	/* brother */
			if ((oldNode == NULL) || (oldNode->left == NULL))
                             ncd_exit("invalid file %s\n", fname);
			node = ncd_malloc(sizeof(DirNode));
			node->name = ncd_strdup(line + 2);
			node->lname = NULL;
			node->left = oldNode->left;
			node->up = oldNode;
			node->down = node->right = NULL;
			oldNode->down = node;
			oldNode = node;
			break;
		case 'L':
			if (oldNode == NULL) 
                             ncd_exit("invalid file %s\n", fname);
			oldNode->lname = ncd_strdup(line + 2);
			break;
		default:
                        ncd_exit("invalid file %s\n", fname);
		}
	}
	if ((oldNode != NULL) && (oldNode->left != NULL) && ((NCD_verbose)&&(!NCD_cursesOn)))
		fprintf(stderr, "warning: possibly truncated file %s\n", fname);

	fclose(f);
	return first;
}

/*************************************************************************/

void writeSubNodeTreeToFile(f, node)
FILE * f;
DirNode * node;

{
	fprintf(f, "%s\n", node->name);
	if (node->lname != NULL)
		fprintf(f, "L %s\n", node->lname);
	if (node->right) {
		fprintf(f, "> ");
		writeSubNodeTreeToFile(f, node->right);
	}
	if (node->down) {
		fprintf(f, "V ");
		writeSubNodeTreeToFile(f, node->down);
	}
	else
		fprintf(f, "< \n");
}

/*************************************************************************/

void writeNodesToFile(fname, baseNode)
char *fname;
DirNode * baseNode;

{
	FILE *f;

	f = fopen(fname, "w");
	if (f == NULL) {
		if ((NCD_verbose)&&(!NCD_cursesOn))
			fprintf(stderr, "warning: can't write file %s\n", fname);
		return;
	}
	if (baseNode != NULL) {
		fprintf(f, "> ");
		writeSubNodeTreeToFile(f, baseNode);
	}
	fclose(f);
}

/*************************************************************************/

void delOneNodeFromMemory(baseNode)
DirNode * baseNode;

{
	if (baseNode == NULL)
		return;

	delNodesFromMemory(baseNode->right);
	if (baseNode->name)
		free(baseNode->name);
	if (baseNode->lname)
		free(baseNode->lname);
}
/*************************************************************************/

void delNodesFromMemory(baseNode)
DirNode * baseNode;

{
	if (baseNode == NULL)
		return;

	delNodesFromMemory(baseNode->right);
	delNodesFromMemory(baseNode->down);
	if (baseNode->name)
		free(baseNode->name);
	if (baseNode->lname)
		free(baseNode->lname);
}

/*************************************************************************/
/* showlink==0 no   ==1 ->link  ==-1 @ */

char *getNodeName(node, showlink)
DirNode * node;
int showlink;

{
	static char s[PATH_MAX * 2];

	s[0] = '\0';
	strcat(s, " ");
	strcat(s, node->name);
	if (node->lname != NULL) {
		if (showlink==1) {
			strcat(s, " -> ");
			strcat(s, node->lname);
			strcat(s, "/");
		}
		else if (showlink==-1)
			strcat(s, "@");
	}
	strcat(s, " ");
	return s;
}

/*************************************************************************/
/* withlink==0 no   ==1 ->link  ==-1 @ */

char *getNodeFullPath(node, withlink, relative, relNode, useNCD_xroot)
DirNode * node;
int withlink;
int relative;
DirNode * relNode;
int useNCD_xroot;

{
	char s[PATH_MAX * 2];
	char *sn;

	sn = getNodeName(node, withlink);
	if ((relative) || (node->left != NULL)) {
		strcpy(s, sn + 1);
		strcpy(sn, s);
		sn[strlen(sn) - 1] = '\0';
	}
	else
		sn[0] = 0;

	s[0] = 0;

	while (node->left != NULL) {
		if ((relative) && (node == relNode))
			break;

		node = node->left;

		if ((relative) || (node->left != NULL)) {
			strcpy(s, node->name);
			addSlash(s);
			strcat(s, sn);
			strcpy(sn, s);
		}
	}
	if (!relative) {
		if (useNCD_xroot)
			strcpy(s, NCD_xroot);
		else
			strcpy(s, NCD_root);
		addSlash(s);
		strcat(s, sn);
		strcpy(sn, s);
	}

	return sn;
}

/*************************************************************************/

int numerateNodeTree(rootNode, x, y)
DirNode * rootNode;
int x;
int y;

{
	int len;

	if (rootNode == NULL)
		return y;

	rootNode->x = x;
	rootNode->y = y;
	len = strlen(rootNode->name);
	if (rootNode->left)
	   if (len < NCD_dir_indent - 2 ) len = NCD_dir_indent - 2; 
	if (rootNode->lname != NULL)
		len++;

	if (rootNode->right)
		y = numerateNodeTree(rootNode->right, x + len + 2 + 3, y);
	if (rootNode->down)
		y = numerateNodeTree(rootNode->down, x, y + 1);

	return y;
}

/*************************************************************************/

DirNode *followLink(rootNode, node, isLast)
DirNode * rootNode;
DirNode * node;
int isLast;

{
	DirNode *dn;
	char s[PATH_MAX * 2];
	char * ss, * st;

	if (node == NULL)
		return NULL;
	if (node->lname == NULL)
		return NULL;
	NCD_nLinks++;
	if (NCD_nLinks>MAX_LINKS)
		return NULL;

	if (node->lname[0]=='/') {  /* absolute */
		stripSlash(NCD_root);
		if (strstr(node->lname,NCD_root)==node->lname) {
			strcpy(s,NCD_xroot);
			strcat(s,(node->lname)+strlen(NCD_root));
		}
		else
			strcpy(s,node->lname);
		addSlash(NCD_root);
	}
	else {  /* relative */
		strcpy(s,getNodeFullPath(node, 0, 0, NULL, 1));
		addSlash(s);
		strcat(s,"../");
		strcat(s,node->lname);
	}
	while (1) {
		compactAbsDir(s);
		dn = locatePathOrSo(s,&ss);

		if (dn->lname!=NULL) {
			if ((isLast)&&((ss[0]=='\0')||((ss[0]=='/')&&(ss[1]=='\0'))))
				return dn;
			dn = followLink(rootNode, dn, 0);
			if (dn==NULL) 
				return NULL;
			else  {
				st = getNodeFullPath(dn, 0, 0, NULL, 1);
				addSlash(st);
				strcat(st,ss);
				strcpy(s,st);
			}
		}
		else {
			if ((ss[0]=='\0')||((ss[0]=='/')&&(ss[1]=='\0'))) 
				return dn;
			else 
				return NULL;
		}
	}

	return NULL;
}

/*************************************************************************/

DirNode *getNodeFollowLink(rootNode, node)
DirNode * rootNode;
DirNode * node;

{
	DirNode *dn;

	if (node == NULL)
		return NULL;
	if (node->lname == NULL)
		return node;
		
	NCD_nLinks = 0;
	dn = followLink(rootNode, node, 1);
	
	if (dn==NULL) 
		return node;
	else 
		return dn;
}

/*************************************************************************
modified by Czo 
*************************************************************************/

char *
getTreeLine (node, lineart, marksel)
     DirNode *node;
     int lineart;
     int marksel;

{
#define MAXLEN (PATH_MAX*5)	/* (PATH_MAX/2)*6+PATH_MAX + some */

  static char line[MAXLEN];
  char tline[MAXLEN];
  size_t len, i, d;

  line[0] = '\0';

  if (node == NULL)
    return NULL;

  do
    {
      tline[0] = '\0';
      if (node->left != NULL)
	{
	  if (node->up == NULL)
	    {
	      if (node->down == NULL)
		{
		  if (lineart)
		    {
		      tline[0] = tline[1] = tline[2] = NCD__ACS_HL;
		      tline[3] = 0;

		    }
		  else
		    {
		      strcpy (tline, "");
		      strcat (tline, "---");
		    }
		}
	      else
		{
		  if (lineart)
		    {
		      tline[0] = tline[2] = NCD__ACS_HL;
		      tline[1] = NCD__ACS_TT;
		      tline[3] = 0;
		    }
		  else
		    {
		      strcpy (tline, "");
		      strcat (tline, "-+-");
		    }
		}
	    }
	  else
	    {
	      if (node->down == NULL)
		{
		  if (lineart)
		    {
		      tline[0] = ' ';
		      tline[1] = NCD__ACS_LLC;
		      tline[2] = NCD__ACS_HL;
		      tline[3] = 0;
		    }
		  else
		    {
		      strcpy (tline, "");
		      strcat (tline, " `-");
		    }
		}
	      else
		{
		  if (lineart)
		    {
		      tline[0] = ' ';
		      tline[1] = NCD__ACS_LT;
		      tline[2] = NCD__ACS_HL;
		      tline[3] = 0;
		    }
		  else
		    {
		      strcpy (tline, "");
		      strcat (tline, " |-");
		    }
		}
	    }
	}
      if (NCD_curNode == node)
	{
	  strcat (tline, " ");
	  tline[strlen (tline) - 1] = NCD__SEL_ON;
	}
      strcat (tline, getNodeName (node, (NCD_showlink ? 1 : -1)));
      if (NCD_curNode == node)
	{
	  strcat (tline, " ");
	  tline[strlen (tline) - 1] = NCD__SEL_OFF;
	}
/* ########### Czo was here */
      if ((node != NULL) && (node->left != NULL) && (node->right != NULL))
	for (d = strlen (getNodeName (node, (NCD_showlink ? 1 : -1))); d < NCD_dir_indent; d++)
	  if (lineart)
	    strcat (tline, NCD__ACS_HL_str);
	  else
	    strcat (tline, "-");
      /*        sprintf(xystr,"(%d;%d)",(node->x),(node->y)); 
         strcat(tline, xystr); */
      strcat (tline, line);
      strcpy (line, tline);

      if (node->up != NULL)
	{
	  node = node->left;
	  break;
	}

      node = node->left;
    }
  while (node != NULL);

  while (node != NULL)
    {
      tline[0] = '\0';
      if (node->left != NULL)
	{
	  if (node->down != NULL)
	    {
	      if (lineart)
		{
		  strcat (tline, "   ");
		  tline[strlen (tline) - 2] = NCD__ACS_VL;
		}
	      else
		{
		  strcpy (tline, "");
		  strcat (tline, " | ");
		}
/* ########### Czo was here */
	      if (node != NULL)
		for (d = strlen (getNodeName (node, (NCD_showlink ? 1 : -1))); d < NCD_dir_indent; d++)
		  strcat (tline, " ");
	    }
	  else
	    {
	      strcpy (tline, "");
	      strcat (tline, "   ");
/* ########### Czo was here */
	      if (node != NULL)
		for (d = strlen (getNodeName (node, (NCD_showlink ? 1 : -1))); d < NCD_dir_indent; d++)
		  strcat (tline, " ");
	    }
	}
      len = strlen (node->name);
      len = len + ((node->lname != NULL) ? 1 : 0) + 2;

      for (i = 0; i < len; i++)
	strcat (tline, " ");
      strcat (tline, line);
      strcpy (line, tline);
      node = node->left;
    }

  return line;
}

/*******************************************************************************
*  generic compaison function :                                                *
*  unlike strcmp, ensure that 10 > 2.                                          *
*  first, check strings, then check numerical values as numbers, not strings.  *
*******************************************************************************/
int natural_strcmp(s, t)
char *s, *t;
{
char buffer[1024]; 
char str[1024]; 

char *spt, *tpt , *st = s, *tt = t;
int u, ls, lt;

	spt = buffer, tpt = str;

	while ((!isdigit(*st)) && *st)
		*spt++ = *st++;
	*spt = '\0';

	while ((!isdigit(*tt)) && *tt)
		*tpt++ = *tt++;
	*tpt = '\0';

	if ((u = strcmp(buffer, str)) != 0)
		return u;

	if ((ls = strlen(s)) == (lt = strlen(t)))
		return strcmp(s, t);

	return ls - lt;
}


/*******************************************************************************
*  generic compaison function :                                                *
*  unlike strcmp, ensure that 10 > 2.                                          *
*  first, check strings, then check numerical values as numbers, not strings.  *
*******************************************************************************/
int natural_strcasecmp(s, t)
char *s, *t;
{
char buffer[1024]; 
char str[1024]; 

char *spt, *tpt , *st = s, *tt = t;
int u, ls, lt;

	spt = buffer, tpt = str;

	while ((!isdigit(*st)) && *st)
		*spt++ = *st++;
	*spt = '\0';

	while ((!isdigit(*tt)) && *tt)
		*tpt++ = *tt++;
	*tpt = '\0';

	if ((u = strcasecmp(buffer, str)) != 0)
		return u;

	if ((ls = strlen(s)) == (lt = strlen(t)))
		return strcasecmp(s, t);

	return ls - lt;
}



/*******************************************************************************
*  generic compaison function :                                                *
*  unlike strcmp, ensure that 10 > 2.                                          *
*  strip leading '.'                                                           *
*  first, check strings, then check numerical values as numbers, not strings.  *
*******************************************************************************/
int natural_strip_strcasecmp(s, t)
char *s, *t;
{
char buffer[1024]; 
char str[1024]; 

char *spt, *tpt , *st = s, *tt = t;
int u, ls, lt;

	spt = buffer, tpt = str;

/* strip leading '.' */
if ( (*st<='.') && (*st!='\0') ) st++;
if ( (*tt<='.') && (*tt!='\0') ) tt++;


	while ((!isdigit(*st)) && *st)
		*spt++ = *st++;
	*spt = '\0';

	while ((!isdigit(*tt)) && *tt)
		*tpt++ = *tt++;
	*tpt = '\0';

	if ((u = strcasecmp(buffer, str)) != 0)
		return u;

	if ((ls = strlen(s)) == (lt = strlen(t)))
		return strcasecmp(s, t);

	return ls - lt;
}



/***********************************************************************/
static int
	Rep_Name_cmp(flc, slc)
DirNode **flc, **slc;
{
	return natural_strcmp((*flc)->name, (*slc)->name);
}


/***********************************************************************/
static int
	Rep_Name_case_cmp(flc, slc)
DirNode **flc, **slc;
{
	return natural_strcasecmp((*flc)->name, (*slc)->name);
}


/***********************************************************************/
static int
	Rep_Name_case_strip_cmp(flc, slc)
DirNode **flc, **slc;
{
	return natural_strip_strcasecmp((*flc)->name, (*slc)->name);
}



/***********************************************************************/
void
	sortDirNode(node, sort_mode)
DirNode **node;
int sort_mode;
{
long n, i;
DirNode *lc, **tc;

	if (!node || !(*node)) 
		return;

	/* first :
	   count node. */
	for (n = 0, lc = *node; lc; lc = lc->down)
		n++;
	tc = ((DirNode **)ncd_malloc(n * sizeof(DirNode *)));

	for (n = 0, lc = *node; lc; lc = lc->down)
		tc[n++] = lc;
	/* second :
	   sort them. */
	   switch (sort_mode)
	   {
	   case 1 :
	qsort((void *)tc, n, sizeof(DirNode *), Rep_Name_case_strip_cmp);
	break;
	case 2:
	qsort((void *)tc, n, sizeof(DirNode *), Rep_Name_case_cmp);
	break;
	default:
	qsort((void *)tc, n, sizeof(DirNode *), Rep_Name_cmp);
	break;
	}
	/* tables :
	   the last element of the table is t[n - 1].
	   relink the list in the sorted order. */
	n--;
	*node = tc[0];
	for (i = 0; i < n; i++)
		tc[i]->down = tc[i + 1];
	tc[n]->down = (DirNode *)NULL;


	/* tc[0]->up = tc[0]->left; */
	tc[0]->up = (DirNode *)NULL;
	for (i = 1; i <= n; i++)
		tc[i]->up = tc[i - 1];



	free((void *)tc);
}



/*************************************************************************/

void
sortTree (node)
     DirNode *node;
{
  DirNode *dn;

  for (dn = node; dn; dn = dn->down)
    {
      if (dn->right != NULL)
	{
	  sortTree (dn->right);
	}
      if ((dn->down == NULL) /* && (dn->right == NULL) */  && (dn->left != NULL))
	{
	  /* if (NCD_cursesOn)
	     cursMsg ("Sorting directory structure",dn->left->right->name, NO_BUTTON); */
	  sortDirNode (&(dn->left->right), NCD_sort_mode);
	}
    }
}



/*************************************************************************/
void RemoveDir ()

   {
  static char path_str[PATH_MAX * 2];
  static char cmd_str[PATH_MAX * 2];
  DirNode *deletedNode;
  DirNode *dn;
  DirNode homeNode;



     strcpy (path_str, getNodeFullPath (NCD_curNode, 1, 0, NULL, 0));
     if (!cursMsg ("Do you really want to delete", path_str, OK_CANCEL_BUTTON))

       {
         cursMsg (" Deleting :                   ", path_str, NO_BUTTON);
         strcpy (cmd_str, "rm -fr ");
         strcat (cmd_str, path_str);
         strcat (cmd_str, " > /dev/null 2>&1");
         if (system (cmd_str))
           cursMsg (" Error deleting :             ", path_str, OK_BUTTON);
         else
           {
             deletedNode = NCD_curNode;
             dataRefresh (NCD_x0, NCD_y0, getNodeCursLeft (NCD_curNode));

             if (deletedNode->up && deletedNode->up->down)
               deletedNode->up->down = deletedNode->down;
             if (deletedNode->down && deletedNode->down->up)
               deletedNode->down->up = deletedNode->up;
             if (deletedNode->left->right == deletedNode)
               deletedNode->left->right = deletedNode->down;

             delOneNodeFromMemory (deletedNode);
             numerateNodeTree (NCD_rootNode, 0, 0);
             NCD_lastNode = getLastDescendant(NCD_rootNode);



             if (NCD_scope == 1)
               {
                 dn = searchNodeForDir (NCD_rootNode, NCD_root, NCD_xhome);
                 if (dn == NULL)
                     ncd_exit("invalid HOME directory\n",NULL);
                 homeNode = *dn;
                 homeNode.left = homeNode.up = homeNode.down = NULL;
                 homeNode.name = getDirName (NCD_home);
                 homeNode.lname = NULL;

                 writeNodesToFile (NCD_fullFile, NCD_rootNode);
                 writeNodesToFile (NCD_homeFile, &homeNode);
               }
             else
               {
                 writeNodesToFile (NCD_homeFile, NCD_rootNode);
               }

           }
       }
   }

/*************************************************************************/
void 
SortDir ()

{


  if (NCD_rootNode != NULL)
    {
      if (NCD_cursesOn)
	cursMsg ("Sorting directory structure", "please wait...", NO_BUTTON);

      NCD_sort_mode= (NCD_sort_mode + 1) % 3;
      sortTree (NCD_rootNode);

      numerateNodeTree (NCD_rootNode, 0, 0);
      NCD_lastNode = getLastDescendant (NCD_rootNode);
    }
}


