/*
                ,,,
               (o o)
  ####=====oOO--(_)--OOO==========================================####
  ##                                                                ##
  ##  This file is part of NCD : a directory browser and selector   ##
  ##  Copyright (C) 1995,96 by Olivier Sirol                        ##
  ##                                                                ##
  ##  Original Copyright (C) 1995 Borja Etxebarria                  ##
  ##  E-mail : borja@bips.bi.ehu.es                                 ##
  ##                                                                ##
  ##  File            :  nodeops.c                                  ##
  ##  Author          :  Olivier SIROL                              ##
  ##  Date            :  Nov 1995                                   ##
  ##                                                                ##
  ##  E-mail support  :  sirol@ecoledoc.ibp.fr                      ##
  ##                                                                ##
  ####============================================================####


*/


static char rcsid[] = "$Id: nodeops.c,v 1.11 1996/04/25 10:50:20 olivier Exp $";


/*##==============================================================####
##                                                                  ##
##                          Include Files                           ##
##                                                                  ##
####==============================================================##*/


# include <stdio.h>
# include <string.h>

# include <dirent.h>
# include "ncd.h"


/*##==============================================================####
##                                                                  ##
##                            Constants                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                              Types                               ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Variables                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Functions                             ##
##                                                                  ##
####==============================================================##*/


/*************************************************************************/
/* given a starting node in {baseNode}, a base directory in {baseDir},
   where {baseDir} corresponds to {baseNode}, and a directory {dir} to
   locate in the node tree, the function {returns} the node for {dir} or
   NULL if not found */

DirNode *searchNodeForDir(baseNode, baseDir, dir)
DirNode * baseNode;
char *baseDir;
char *dir;

{
	char *s;
	DirNode *dn, *son;

	if (baseNode == NULL)
		return NULL;

	if (strstr(dir, baseDir) != dir)
		return NULL;

	s = dir + strlen(baseDir);
	if (*s == '/')
		s++;
	if (*s == '\0')
		return baseNode;

	son = baseNode->right;
	
	while (son != NULL) {
		dn = searchNodeForDir(son, son->name, s);
		if (dn)
			return dn;
		son = son->down;
	}
	return NULL;
}

/*************************************************************************/

DirNode *getLastDescendant(node)
DirNode * node;

{
	if (node == NULL)
		return NULL;

	if (node->right == NULL)
		return node;
	node = node->right;

	while (1) {
		while (node->down != NULL)
			node = node->down;
		if (node->right == NULL)
			return node;
		node = node->right;
	}
}

/*************************************************************************/

DirNode *getLastNodeInSameLevel(node)
DirNode * node;

{
	if (node == NULL)
		return NULL;

	while (node->right != NULL)
		node = node->right;

	return node;
}

/*************************************************************************/

DirNode *getFirstNodeInSameLevel(node)
DirNode * node;

{
	if (node == NULL)
		return NULL;

	while ((node->left != NULL) && (node->left->right == node))
		node = node->left;

	return node;
}

/*************************************************************************/

DirNode *getAnyNodeInLevel(node,level)
DirNode * node;
int level;

{

	while (1) {
		if (node == NULL)
			return NULL;

		while ((node->down != NULL) && (node->down->y <= level))
			node = node->down;

		if (node->y == level)
			return node;

		node = node->right;
	}
}

/*************************************************************************/

DirNode *getLastNodeInLevel(node, level)
DirNode * node;
int level;

{
	return getLastNodeInSameLevel(getAnyNodeInLevel(node, level));
}

/*************************************************************************/

DirNode *getFirstNodeInLevel(node, level)
DirNode * node;
int level;
{
	return getFirstNodeInSameLevel(getAnyNodeInLevel(node, level));
}


/*************************************************************************/

DirNode *getNodeCursUp(curNode)
DirNode * curNode;

{
	if (curNode->up)
		return curNode->up;
	if (curNode->left)
		return curNode->left;

	return curNode;
}

/*************************************************************************/

DirNode *getNodeLnUp(curNode)
DirNode * curNode;

{
	DirNode * dn;
	
	if (curNode->y>0) 
		dn = getLastNodeInLevel(NCD_rootNode, curNode->y-1);
	else	
		dn = NULL;

	if (dn!=NULL)
		return dn;
	else
		return curNode;
}

/*************************************************************************/

DirNode *getNodeLnDn(curNode)
DirNode * curNode;

{
	DirNode * dn;
	
	dn = getFirstNodeInLevel(NCD_rootNode, curNode->y+1);

	if (dn!=NULL)
		return dn;
	else
		return curNode;
}

/*************************************************************************/

DirNode *getNodePrev(curNode)
DirNode * curNode;

{
	if (curNode==NULL)
		return NULL;

	if ((curNode->left!=NULL)&&(curNode->left->right==curNode))
		return curNode->left;
		
	return getNodeLnUp(curNode);
}


/*************************************************************************/

int 
getNodeDepth (curNode)
DirNode * curNode;

{
  DirNode *node;
  int thisdepth;


  thisdepth =0; 
  node = curNode;

  while (node->left != NULL)
    {
      node = node->left;
      thisdepth++;
    }

  return thisdepth;
}
/*************************************************************************/

DirNode *
getNodeCursDownNatural (curNode)
DirNode * curNode;

{
  DirNode *node;
  DirNode *oldnode;
  int thisdepth;

  if (curNode->down != NULL)
    return curNode->down;

  thisdepth = getNodeDepth (curNode);
  oldnode = curNode;
  node = getNodeCursRight (curNode);

  while ((node != NULL) && (node != oldnode) && (getNodeDepth (node) != thisdepth))
    {
      oldnode = node;
      node = getNodeCursRight (node);
    }

if (node != NULL)
  {
    if (oldnode != node)
      return node;
    else
      return getNodeCursRight (curNode);
  }
else
  return curNode;
}
/*************************************************************************/

DirNode *
getNodeCursUpNatural (curNode)
DirNode * curNode;

{
  DirNode *node;
  DirNode *oldnode;
  int thisdepth;

	if (curNode->up)
		return curNode->up;

  thisdepth = getNodeDepth (curNode);
  oldnode = curNode;
  node = getNodePrev (curNode);

  while ((node != NULL) && (node != oldnode) && (getNodeDepth (node) != thisdepth))
    {
      oldnode = node;
      node = getNodePrev (node);
    }

if (node != NULL)
  {
    if (oldnode != node)
      return node;
    else
      return getNodePrev(curNode);
  }
else
  return curNode;
}
/*************************************************************************/

DirNode *getNodeCursDown(curNode)
DirNode * curNode;

{
	DirNode *node;

	if (curNode->down != NULL)
		return curNode->down;
 	if (curNode->right != NULL)
		return curNode->right;

	node = getFirstNodeInLevel(NCD_rootNode, curNode->y + 1);

	if (node != NULL)
		return node;
	else
		return curNode;
}

/*************************************************************************/

DirNode *getNodeCursLeft(curNode)
DirNode * curNode;

{
	if (curNode->left != NULL)
		return curNode->left;
	else
		return curNode;
}

/*************************************************************************/

DirNode *getNodeCursRight(curNode)
DirNode * curNode;

{
	DirNode *node;

	if (curNode->right != NULL)
		return curNode->right;
	if (curNode->down != NULL)
		return curNode->down;

	node = curNode->left;

	while (node != NULL) {
		if (node->down != NULL)
			return node->down;
		else
			node = node->left;
	}

	return curNode;
}

/*************************************************************************/

DirNode *locatePathOrSo(path, rest)
char * path;
char **rest;

{
	char dir[PATH_MAX];
	char *s;
	DirNode *dn;

	strcpy(dir, path);
	s = dir+strlen(dir);

	while ((dn = searchNodeForDir(NCD_rootNode, NCD_xroot, dir)) == NULL) {
		s = strrchr(dir, '/');
		if (s != NULL)
			*s = '\0';
		else {
			if (rest!=NULL)
				*rest = path;
			return NCD_rootNode;
		}
	}
	if (rest!=NULL)
		*rest = path + (s-dir);
	return dn;
}

/*************************************************************************/

DirNode *prevNodeCiclic(rootNode, curNode)
DirNode * rootNode;
DirNode * curNode;

{
	if ((rootNode == NULL) || (curNode == NULL))
	  return rootNode;
	if (rootNode==curNode)
        return  getLastDescendant(curNode);
	return (getNodePrev(curNode));
}

/*************************************************************************/

DirNode *nextNodeCiclic(rootNode, curNode)
DirNode * rootNode;
DirNode * curNode;

{
	if ((rootNode == NULL) || (curNode == NULL))
		return rootNode;

	if (curNode->right != NULL)
		return curNode->right;

	if (curNode->down != NULL)
		return curNode->down;

	curNode = curNode->left;
	while (curNode != NULL) {
		if (curNode->down != NULL)
			return curNode->down;
		curNode = curNode->left;
	}

	if (curNode == NULL)
		return rootNode;
	else
		return curNode;
}

/*************************************************************************/

int validSearchDir(fullDir, fullDirLink, searchDir)
char * fullDir;
char * fullDirLink;
char * searchDir;

{
	char *s;
	int len;
	char *min;
	
	if (fullDir==NULL)
		return 0;
		
	if (searchDir[0]=='/') {
		if (searchDir[1]=='\0')
			return ((fullDir[0]=='/')&&(fullDir[1]=='\0'));
		min = fullDir;
	}
	else {
		stripSlash(fullDir);
		min = strrchr(fullDir, '/');
		if (min==NULL)
			min = fullDir;
		else
			min++;
	}
	if (fullDirLink!=NULL) {
		strcat(fullDir," -> ");
		strcat(fullDir,fullDirLink);
		strcat(fullDir,"/");
	} 
	else
		addSlash(fullDir);
	
	len = strlen(searchDir);
	if (len<strlen(min))
		s = min;
	else
		s = fullDir+(strlen(fullDir)-len);
	
	while ((s>=fullDir)&&(s+len>min)) {
		if ((strncmp(s,searchDir,len)==0)&&((s[0]=='/')||(s==fullDir)||(s[-1]=='/')))
			return 1;
		
		s--;
	}

	return 0;
}

/*************************************************************************/

DirNode *findDirInCiclePrev(rootNode, curNode, dir)
DirNode * rootNode;
DirNode * curNode;
char *dir;

{
	DirNode *node;
	char *s;
	int valid;

	node = curNode;
	do {
		s = getNodeFullPath(node, (NCD_showlink?0:-1), 1, NULL, 0);
		valid = validSearchDir(s,node->lname, dir);

		if (!valid) 
			node = prevNodeCiclic(rootNode, node);
	} while ((!valid) && (node != curNode));

	if (valid)
		return node;
	else
		return NULL;
}

/*************************************************************************/

DirNode *findDirInCicle(rootNode, curNode, dir)
DirNode * rootNode;
DirNode * curNode;
char *dir;

{
	DirNode *node;
	char *s;
	int valid;

	node = curNode;
	do {
		s = getNodeFullPath(node, (NCD_showlink?0:-1), 1, NULL, 0);
		valid = validSearchDir(s,node->lname, dir);

		if (!valid) 
			node = nextNodeCiclic(rootNode, node);
	} while ((!valid) && (node != curNode));

	if (valid)
		return node;
	else
		return NULL;
}

/*************************************************************************/

DirNode *findDirSegInCicle(rootNode, curNode, dir)
DirNode * rootNode;
DirNode * curNode;
char *dir;

{
	DirNode *dn;
	char s[PATH_MAX];

	strcpy(s, dir);
	dn = NULL;

	if (dir[0] != '\0') {
		addSlash(dir);
		dn = findDirInCicle(rootNode, curNode, dir);
		if (dn!=NULL)
			return dn;
	}

	strcpy(s,dir);

	while ((s[0] != '\0') && (dn == NULL)) {
		dn = findDirInCicle(rootNode, curNode, s);
		s[strlen(s) - 1] = '\0';
	}

	return dn;
}

/*************************************************************************/

DirNode *directSelectANode()
{
	DirNode * dn;

	NCD_curNode = locatePathOrSo(NCD_cwd, NULL);
	dn = findDirSegInCicle(NCD_rootNode, nextNodeCiclic(NCD_rootNode,NCD_curNode), NCD_argumentDir);
	return dn;
}

/*************************************************************************/

void showTree(rootNode)
DirNode * rootNode;

{
	if (rootNode->right != NULL)
		showTree(rootNode->right);
	else {
		fprintf(stdout, "%s\n", getTreeLine(rootNode, 0, 0));
	}
	if (rootNode->down != NULL)
		showTree(rootNode->down);
}

/*************************************************************************/
