/*
                ,,,
               (o o)
  ####=====oOO--(_)--OOO==========================================####
  ##                                                                ##
  ##  This file is part of NCD : a directory browser and selector   ##
  ##  Copyright (C) 1995,96 by Olivier Sirol                        ##
  ##                                                                ##
  ##  Original Copyright (C) 1995 Borja Etxebarria                  ##
  ##  E-mail : borja@bips.bi.ehu.es                                 ##
  ##                                                                ##
  ##  File            :  ncd.h                                      ##
  ##  Author          :  Olivier SIROL                              ##
  ##  Date            :  Nov 1995                                   ##
  ##                                                                ##
  ##  E-mail support  :  sirol@ecoledoc.ibp.fr                      ##
  ##                                                                ##
  ####============================================================####

  $Id: ncd.h,v 1.24 1996/05/16 19:44:49 olivier Exp $

*/


# ifndef NCD_MAIN_H
# define NCD_MAIN_H


/*##==============================================================####
##                                                                  ##
##                            Constants                             ##
##                                                                  ##
####==============================================================##*/

#ifndef PATH_MAX 
# define PATH_MAX 1024
#endif

/*************************************************************************/
/* special codes to format directory tree. Arbitrary way selected */

# define NCD__ACS_HL 1          /* line art codes */
# define NCD__ACS_HL_str "\1"          /* needed for strcat function */
# define NCD__ACS_VL 2
# define NCD__ACS_LT 3
# define NCD__ACS_LLC 4
# define NCD__ACS_TT 5

# define NCD__SEL_ON 6           /* selection on/off codes */
# define NCD__SEL_OFF 7


/* other constants */

# define MAX_LINKS   256   /* if more recursive links, error */
# define SEARCHWIN_LEN 30   /* max visible length for search window */
# define MIN_LINES 10        /* min. LINES in screen  */
# define MIN_COLS 40        /* min. COLS in screen */
# define HLP_LINES 14	/* lines used for help screen */
# define HLP_COLS 60     /* columns used for help screen */
 
# define NO_BUTTON        1 
# define OK_BUTTON        2 
# define OK_CANCEL_BUTTON 3 


# define STD_TEXT_COLOR        1
# define SEL_TEXT_COLOR        2
# define DIALOG_BOX_COLOR      3
# define CURRENT_PATH_COLOR    4
# define HELP_COLOR            5
# define TITLE_COLOR           6 
# define SEARCH_FIELD_COLOR    7 
# define BUTTON_COLOR          8



/*##==============================================================####
##                                                                  ##
##                              Macro                               ##
##                                                                  ##
####==============================================================##*/

/* i guess */

#define Key_ALT_CTRL(x)  (0x80 | ((x)& 31))
#define Key_CTRL(x)      ((x) & 31)
#define Key_ALT(x)       (0x80|(x))

/*##==============================================================####
##                                                                  ##
##                              Types                               ##
##                                                                  ##
####==============================================================##*/


typedef struct _DirNode
  {
    char *name;			/* dir name */
    char *lname;		/* NULL, or link name */
    int x, y;			/* x,y position origin = (0,0) */
    struct _DirNode *left, *right, *up, *down;	/* other node ptrs */
  }
DirNode;


typedef struct _key_def
  {
    int code;
    char *seq;
  }
key_def;


/*##==============================================================####
##                                                                  ##
##                            Variables                             ##
##                                                                  ##
####==============================================================##*/

extern int   NCD_rebuild;
extern int   NCD_scope;
extern int   NCD_rebauto;
extern int   NCD_verbose;
extern int   NCD_justdump;
extern int   NCD_lineart;
extern int   NCD_showlink;
extern int   NCD_sort_mode;
extern int   NCD_dir_indent;
extern char *NCD_term_name;
extern int   NCD_use_stdterm;
extern int   NCD_doResize;
extern int   NCD_canResize;

/*************************************************************************/
/* other global variables */

extern char NCD_Progname[PATH_MAX];
extern char NCD_home[PATH_MAX];
extern char NCD_xhome[PATH_MAX];
extern char NCD_cwd[PATH_MAX];
extern char NCD_root[PATH_MAX];
extern char NCD_xroot[PATH_MAX];
extern char NCD_finalDir[PATH_MAX];
extern char NCD_argumentDir[PATH_MAX];

extern char NCD_homeFile[PATH_MAX];
extern char NCD_fullFile[PATH_MAX];
extern char NCD_selDirFile[PATH_MAX];

extern DirNode *NCD_rootNode;
extern DirNode *NCD_lastNode;
extern int NCD_nLinks;  

extern char NCD_searchPath[PATH_MAX];
extern int NCD_searchPLen;
extern int NCD_searchPX;

extern int NCD_x0;
extern int NCD_y0;
extern DirNode *NCD_curNode;

extern int NCD_cols;
extern int NCD_lines;
extern int NCD_use_color;
extern int NCD_cursesOn;

extern int NCD_refCurrent;
extern int NCD_refRest;   
extern int NCD_refCurDir; 
extern int NCD_refSearch; 


/*##==============================================================####
##                                                                  ##
##                            Functions                             ##
##                                                                  ##
####==============================================================##*/


/*************************************************************************/
/* prototipes for dirs.c */

extern char *addSlash();
extern char *stripSlash();
extern char *compactAbsDir();
extern char *trueDir();
extern char *getDirName();

/*************************************************************************/
/* prototipes for nodes.c */

extern void *ncd_malloc();
extern void *ncd_strdup();
extern void  ncd_exit();
extern DirNode *readDirsInNodes();
extern DirNode *readNodesFromFile();
extern void writeSubNodeTreeToFile();
extern void writeNodesToFile();
extern void delNodesFromMemory();
extern void delOneNodeFromMemory();
extern char *getNodeName();
extern char *getNodeFullPath();
extern int numerateNodeTree();
extern DirNode *getNodeFollowLink();
extern char *getTreeLine();
extern void sortTree();
extern void sortDir();
extern void RemoveDir();

/*************************************************************************/
/* prototipes for nodeops.c */

extern DirNode *searchNodeForDir();
extern DirNode *getLastDescendant();
extern DirNode *getLastNodeInSameLevel();
extern DirNode *getFirstNodeInSameLevel();
extern DirNode *getAnyNodeInLevel();
extern DirNode *getLastNodeInLevel();
extern DirNode *getFirstNodeInLevel();
extern DirNode *getNodeCursUp();
extern DirNode *getNodeLnUp();
extern DirNode *getNodeLnDn();
extern DirNode *getNodePrev();
extern DirNode *getNodeCursDown();
extern DirNode *getNodeCursDownNatural();
extern DirNode *getNodeCursUpNatural();
extern int      getNodeDepth();
extern DirNode *getNodeCursLeft();
extern DirNode *getNodeCursRight();
extern DirNode *locatePathOrSo();
extern DirNode *nextNodeCiclic();
extern DirNode *prevNodeCiclic();
extern int validSearchDir();
extern DirNode *findDirInCicle();
extern DirNode *findDirInCiclePrev();
extern DirNode *findDirSegInCicle();
extern DirNode *directSelectANode();
extern void showTree();


/*************************************************************************/
/* prototipes for curs.c */

extern void ioResize();
extern void ioInitialize();
extern void ioTerminate();
extern void prepareColorModes();
extern int getColorMode();
extern int getKey();
extern void showHelp();
extern DirNode * selectANode();

/*************************************************************************/
/* prototipes for disp.c */

extern void paintLayout();
extern char *truncString();
extern void updateLine();
extern void dataRefresh();
extern void editSearch();
extern void showHelpScreen();
extern void showHelpNoSpace();
extern int cursMsg();

/************************************************************************ */
/* prototipes for ncd.c */

extern void cleanUp();
extern int parseOpts();
extern int parseArguments();
extern DirNode *rebuildTree();
extern DirNode *readTreeFiles();
extern int getFinalPath();
extern void initializeFinalDir();
extern void changeToFinalDir();
extern void getGlobals();

/*************************************************************************/


# endif /* NCD_MAIN_H */

