/*
                ,,,
               (o o)
  ####=====oOO--(_)--OOO==========================================####
  ##                                                                ##
  ##  This file is part of NCD : a directory browser and selector   ##
  ##  Copyright (C) 1995,96 by Olivier Sirol                        ##
  ##                                                                ##
  ##  Original Copyright (C) 1995 Borja Etxebarria                  ##
  ##  E-mail : borja@bips.bi.ehu.es                                 ##
  ##                                                                ##
  ##  File            :  ncd.c                                      ##
  ##  Author          :  Olivier SIROL                              ##
  ##  Date            :  Nov 1995                                   ##
  ##                                                                ##
  ##  E-mail support  :  sirol@ecoledoc.ibp.fr                      ##
  ##                                                                ##
  ####============================================================####


*/


static char rcsid[] = "$Id: ncd.c,v 1.31 1996/05/16 19:10:36 olivier Exp $";


/*##==============================================================####
##                                                                  ##
##                          Include Files                           ##
##                                                                  ##
####==============================================================##*/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <unistd.h>
# include <signal.h>



# ifdef HAVE_GETOPT_H
#   include <getopt.h>
# else
    extern char *optarg;
# endif

# include <dirent.h>
# include "ncd.h"


/*##==============================================================####
##                                                                  ##
##                            Constants                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                              Types                               ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Variables                             ##
##                                                                  ##
####==============================================================##*/

extern char * NCD_Version;
extern char * NCD_Date;
extern char * NCD_Compiled_by;


/*##==============================================================####
##                                                                  ##
##                            Functions                             ##
##                                                                  ##
####==============================================================##*/


                                                                      
/*************************************************************************/

void cleanUp()
{
 	if (NCD_cursesOn) 
		ioTerminate();
}

/*************************************************************************/


void signalCleanUp (sig)
int sig;
{
   cleanUp();
   (void)fflush(stdout);
   (void)fflush(stderr);
   fprintf(stderr, "## Signal caught. Exiting...\n");
   exit(10);
}

/*************************************************************************/

void 
signalSigwinch (sig)
     int sig;
{
  signal(SIGWINCH,signalSigwinch);
  if (NCD_canResize)
    {
     ioResize ();
     NCD_doResize = 0;
    }
  else
     NCD_doResize = 1;
}

/*************************************************************************/
/* returns !=0 if error */

int parseOpts(argc, argv)
int argc;
char *argv[];

{
int c;
char * Versionmsg = "\n\
NCD : a directory browser and selector\n\
Version %s (%s)\n\
\n\
%s\
\n\
Copyright (C) 1996 Olivier Sirol\n\
Institut Blaise Pascal\n\
Laboratoire MASI\n\
Universite Pierre et Marie Curie - France\n\
E-mail : sirol@ecoledoc.ibp.fr\n\
\n\
Original Copyright (C) 1995 Borja Etxebarria\n\
Basque Country University\n\
E-mail : borja@bips.bi.ehu.es\n\
         jtbecgob@s835cc.bi.ehu.es\n";

char * hlpmsg = "\n\
NCD : a directory browser and selector\n\
\n\
Usage : %s [-options] [dir]\n\
 -f -m -M  : scope area = full/home/auto(*)\n\
 -r -R     : force rebuild = yes/no(*)\n\
 -a -A     : rebuild mode = auto(*)/manual\n\
 -s        : alpha sort mode = ignore case and leading '.'\n\
 -S        : alpha sort mode = ignore case\n\
 -c        : alpha sort mode = case sensitive(*)\n\
 -v -q     : verbose mode = on/off(*)\n\
 -i <num>  : indent value = num (num=[0..99] default 12)\n\
 -d -D     : dump directory tree = yes/interactive(*)\n\
 -x -X     : forces 7 bits chars = yes/auto(*)\n\
 -l -L     : link format = (ldir -> dir)/(ldir@)(*)\n\
 -t <name> : forces terminal to <name>\n\
 -T        : uses $TERM as terminal name(*)\n\
 -h        : this help\n\
 -V        : Show Version info\n\
 dir       : direct jump to <dir>\n\
\n\
NCD needs a shell alias/funtion to run, see man pages for details.\n";

while ((c = getopt (argc, argv, "?rRfmMvqVaAdDXxlLcsSi:Tt:h")) != -1)
  {
    switch (c)
      {

      case 'r':
	NCD_rebuild = 1;
	break;
      case 'R':
	NCD_rebuild = 0;
	break;
      case 'f':
	NCD_scope = 1;
	break;
      case 'm':
	NCD_scope = -1;
	break;
      case 'M':
	NCD_scope = 0;
	break;
      case 'v':
	NCD_verbose = 1;
	break;
      case 'q':
	NCD_verbose = 0;
	break;
      case 'V':
	fprintf (stderr, Versionmsg, NCD_Version, NCD_Date, NCD_Compiled_by);
	return 1;
	break;
      case 'a':
	NCD_rebauto = 1;
	break;
      case 'A':
	NCD_rebauto = 0;
	break;
      case 'd':
	NCD_justdump = 1;
	break;
      case 'D':
	NCD_justdump = 0;
	break;
      case 'X':
	NCD_lineart = 1;
	break;
      case 'x':
	NCD_lineart = 0;
	break;
      case 'l':
	NCD_showlink = 1;
	break;
      case 'L':
	NCD_showlink = 0;
	break;
      case 'c':
	NCD_sort_mode = 0;
	break;
      case 's':
	NCD_sort_mode = 1;
	break;
      case 'S':
	NCD_sort_mode = 2;
	break;
      case 'i':
	if ((sscanf (optarg, "%d", &NCD_dir_indent) != 1)
	    || (NCD_dir_indent < 0)
	    || (NCD_dir_indent > 100))

	  {
	    fprintf (stderr, "%s: argument of -- i must be 0<= num < 100\n", NCD_Progname);
	    fprintf (stderr, hlpmsg, NCD_Progname);
	    return 1;
	  }
	break;
      case 'T':
	NCD_use_stdterm = 1;
	break;
      case 't':
	NCD_use_stdterm = 0;
	NCD_term_name = ncd_strdup (optarg);
	break;
      case 'h':
      default:
	fprintf (stderr, hlpmsg, NCD_Progname);
	return 1;
      }
  }
return 0;
}

/*************************************************************************/
/* returns !=0 if error. Parses NCD_OPTS environment switches, and then
   command line switches */

int parseArguments(argc,argv)
int argc;
char *argv[];
{
	extern int optind;
	int i, ret;
	char *ss[2];

	ss[1] = getenv("NCD_OPTS");
	if (ss[1]) {
		i = optind;
		optind = 0;
		if (parseOpts(2, ss))
			return 1;
		optind = i;
	}
	ret = parseOpts(argc, argv);
	
	if ((ret==0)&&(optind<argc)) {
		strcpy(NCD_argumentDir,argv[optind]);
		if (NCD_argumentDir[0]=='/')  {
			if (NCD_scope==0)
				NCD_scope = 1;
			if (NCD_argumentDir[1]!='\0')
				strcpy(NCD_argumentDir, NCD_argumentDir+1);
		}
		
		if (NCD_verbose) 
			fprintf(stderr,"command-line dir: %s\n",NCD_argumentDir);
	}	                   
	else
		NCD_argumentDir[0]='\0';
	                        
	return ret;
}


/*************************************************************************/

DirNode *
rebuildTree ()
{
  DirNode *rootNode;
  DirNode *dn;
  DirNode homeNode;
  

  if (!NCD_cursesOn)
    fprintf (stderr, "Rebuilding directory tree...");
    
  rootNode = readDirsInNodes (NCD_root, NULL);

  if ((NCD_verbose) && (!NCD_cursesOn))
    fprintf (stderr, "\n");

 if (NCD_cursesOn)
 cursMsg ("Sorting directory structure", "please wait...", NO_BUTTON);
 
  sortTree(rootNode);  

  if (NCD_scope == 1)
    {
      dn = searchNodeForDir (rootNode, NCD_root, NCD_xhome);
      if (dn == NULL)
	  ncd_exit("invalid HOME directory\n",NULL);
      homeNode = *dn;
      homeNode.left = homeNode.up = homeNode.down = NULL;
      homeNode.name = getDirName (NCD_home);
      homeNode.lname = NULL;

      writeNodesToFile (NCD_fullFile, rootNode);
      writeNodesToFile (NCD_homeFile, &homeNode);
    }
  else
    {
      writeNodesToFile (NCD_homeFile, rootNode);
    }
  if (!NCD_cursesOn)
    fprintf (stderr, " done!\n");

  return rootNode;
}

/*************************************************************************/

DirNode *readTreeFiles()
{
	DirNode *homeNode, *rootNode;
	DirNode *dn;

	if (NCD_rebuild) {
		NCD_rebuild = 0;
		return rebuildTree();
	}

	if ((NCD_verbose)&&(!NCD_cursesOn))
		fprintf(stderr, "reading %s...\n", NCD_homeFile);
	rootNode = readNodesFromFile(NCD_homeFile);

	if (NCD_scope == 1) {
		homeNode = rootNode;
		if ((NCD_verbose)&&(!NCD_cursesOn))
			fprintf(stderr, "reading %s...\n", NCD_fullFile);
		rootNode = readNodesFromFile(NCD_fullFile);
		dn = searchNodeForDir(rootNode, NCD_root, NCD_xhome);
		if (dn == NULL) {
			if (NCD_rebauto == 0)
				ncd_exit("%s unusable, please rebuild\n", NCD_fullFile);
			else {
				NCD_rebauto = 0;
				delNodesFromMemory(homeNode);
				delNodesFromMemory(rootNode);
				return rebuildTree();
			}
		}
		delNodesFromMemory(dn->right);
		dn->right = homeNode->right;
		free(homeNode->name);
		if (homeNode->lname)
			free(homeNode->lname);
		*homeNode = *dn;
		if (homeNode->down != NULL)
			(homeNode->down)->up = homeNode;
		if (homeNode->up != NULL)
			(homeNode->up)->down = homeNode;
		else if (homeNode->left != NULL)
			(homeNode->left)->right = homeNode;
		free(dn);
	}

	dn = searchNodeForDir(rootNode, NCD_xroot, NCD_cwd);
	if ((dn == NULL) && (NCD_rebauto != 0)) {
		delNodesFromMemory(rootNode);
		return rebuildTree();
	}

	return rootNode;
}

/*************************************************************************/
/* 1 if cancel */

int getFinalPath(node)
 DirNode * node;
{
	char * s;
	
	if (node==NULL) 
		return 1;

	s = getNodeFullPath(node, 0, 0, NULL, 0);
	if ((NCD_verbose)&&(!NCD_cursesOn))
		fprintf(stderr,"selected directory: %s\n",s);
	strcpy(NCD_finalDir, s);

	return 0;
}

/*************************************************************************/

void changeToFinalDir()
{
	FILE * f;
	int len;
	
	len = strlen(NCD_finalDir);

	f = fopen(NCD_selDirFile,"w");

	if (f==NULL)
		ncd_exit("can't open file %s\n",NCD_selDirFile);

	if (fprintf(f,"%s",NCD_finalDir)<len)
		ncd_exit("can't write file %s\n",NCD_selDirFile);

	if (fclose(f)!=0)
		ncd_exit("can't close file %s\n",NCD_selDirFile);
}

/*************************************************************************/

void 
initializeFinalDir ()
{
  FILE *f;

  strcpy (NCD_finalDir, ".");

  f = fopen (NCD_selDirFile, "w");

  if (f == NULL)
	ncd_exit("can't open file %s\n",NCD_selDirFile);

  fprintf (f, "%s", NCD_finalDir);

  if (fclose (f) != 0)
	ncd_exit("can't close file %s\n",NCD_selDirFile);
}

/*************************************************************************/

void 
getGlobals (initNCD_cwd)
     int initNCD_cwd;
{
  char *s;

  if (initNCD_cwd)
    NCD_cursesOn = 0;

  s = getenv ("HOME");
  if (s == NULL)
    ncd_exit ("can't get HOME directory\n", NULL);

  strcpy (NCD_home, s);
  addSlash (NCD_home);
  strcpy (NCD_xhome, NCD_home);

  if (trueDir (NCD_xhome) == NULL)
    ncd_exit ("invalid HOME directory\n", NULL);

  if ((NCD_verbose) && (!NCD_cursesOn))
    fprintf (stderr, "HOME=%s (%s)\n", NCD_home, NCD_xhome);

  if (initNCD_cwd)
    {
      s = getcwd (NCD_cwd, PATH_MAX);
      if (s == NULL)
	ncd_exit ("can't get current directory\n", NULL);

      addSlash (NCD_cwd);
      if ((NCD_verbose) && (!NCD_cursesOn))
	fprintf (stderr, "cwd=%s\n", NCD_cwd);

      if (NCD_scope == 0)
	{
	  if (strstr (NCD_cwd, NCD_xhome) == NCD_cwd)
	    NCD_scope = -1;
	  else
	    NCD_scope = 1;
	}
    }

  if (NCD_scope == -1)
    {
      strcpy (NCD_root, NCD_home);
      strcpy (NCD_xroot, NCD_xhome);
      if ((NCD_verbose) && (!NCD_cursesOn))
	fprintf (stderr, "scope area: HOME\n");
    }
  else
    {
      strcpy (NCD_root, "/");
      strcpy (NCD_xroot, NCD_root);
      if ((NCD_verbose) && (!NCD_cursesOn))
	fprintf (stderr, "scope area: FULL\n");
    }

  strcpy (NCD_homeFile, NCD_home);
  strcpy (NCD_fullFile, NCD_home);
  strcpy (NCD_selDirFile, NCD_home);
  strcat (NCD_homeFile, ".ncd_htree");
  strcat (NCD_fullFile, ".ncd_ftree");
  strcat (NCD_selDirFile, ".ncd_sdir");
  initializeFinalDir ();

}

/*************************************************************************/

int main(argc,argv)
int argc;
char *argv[];
{
	int quit;
	DirNode * dn;
	int ret;


  signal (SIGHUP, signalCleanUp);
  signal (SIGINT, signalCleanUp);
  signal (SIGQUIT, signalCleanUp);
  signal (SIGTERM, signalCleanUp);
  signal (SIGKILL, signalCleanUp);
  signal (SIGWINCH, signalSigwinch);


	ret = 1;

	fprintf(stderr, "NCD Version %s, (C) 1996 Borja Etxebarria & Olivier Sirol\n", NCD_Version);

	if (parseArguments(argc, argv))
		return 1;

	getGlobals(1);

	NCD_rootNode = readTreeFiles();

	if (NCD_rootNode != NULL) {
		numerateNodeTree(NCD_rootNode, 0 , 0);
		NCD_lastNode = getLastDescendant(NCD_rootNode);

		if (NCD_justdump) {
			showTree(NCD_rootNode);
			ret = 2;
		}
		else if (strlen(NCD_argumentDir)>0) {
			dn = directSelectANode();
			ret = getFinalPath(dn);
		}
		else { 
			do {
				dn = selectANode(&quit);
				switch (quit) {
				case 3:  /* rescan */
					NCD_rebuild = 1;
					NCD_scope = -NCD_scope;
				case 4:  /* scope toggle */
					NCD_scope = -NCD_scope;
					if (NCD_scope==-1)
						NCD_rebauto = 0;
					delNodesFromMemory(NCD_rootNode);
					getGlobals(0);
					NCD_rootNode = readTreeFiles();
					quit = 0;
					if (NCD_rootNode != NULL) {
						numerateNodeTree(NCD_rootNode, 0 , 0);
						NCD_lastNode = getLastDescendant(NCD_rootNode);
					}
					else
						quit = 1;
					break;
				case 1:
					if ((NCD_verbose)&&(!NCD_cursesOn))
						fprintf(stderr,"operation cancelled by the user!\n");
				case 2:
				default:
					ret = getFinalPath(dn);
					quit = 1;
					break;					
				}
			} while (!quit);
		}

		delNodesFromMemory(NCD_rootNode);
	}
	else
		ret = 1;
	
	changeToFinalDir();

	return ret;
}

/*************************************************************************/
