/*
                ,,,
               (o o)
  ####=====oOO--(_)--OOO==========================================####
  ##                                                                ##
  ##  This file is part of NCD : a directory browser and selector   ##
  ##  Copyright (C) 1995,96 by Olivier Sirol                        ##
  ##                                                                ##
  ##  Original Copyright (C) 1995 Borja Etxebarria                  ##
  ##  E-mail : borja@bips.bi.ehu.es                                 ##
  ##                                                                ##
  ##  File            :  glob.c                                     ##
  ##  Author          :  Olivier SIROL                              ##
  ##  Date            :  Nov 1995                                   ##
  ##                                                                ##
  ##  E-mail support  :  sirol@ecoledoc.ibp.fr                      ##
  ##                                                                ##
  ####============================================================####


*/


static char rcsid[] = "$Id: glob.c,v 1.14 1996/05/16 19:10:36 olivier Exp $";


/*##==============================================================####
##                                                                  ##
##                          Include Files                           ##
##                                                                  ##
####==============================================================##*/

# include <stdio.h> 

# include <dirent.h>
# include "ncd.h"
                                 

/*##==============================================================####
##                                                                  ##
##                            Constants                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                              Types                               ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Variables                             ##
##                                                                  ##
####==============================================================##*/


/*************************************************************************/
/* global configuration */

int NCD_rebuild = 0;	/* 0=no,  1=rebuild */
int NCD_scope = 0;		/* 0=by actual location, 1=full, -1=home */
int NCD_rebauto = 1;	/* 0=manual, 1=automatic */
int NCD_verbose = 0;	/* 0=quiet,  1=verbose */
int NCD_justdump = 0;	/* 0=norma, 1=just dump tree */
int NCD_lineart = 1;	/* 1=lineart (auto), 0=force 7 bits chars */
int NCD_showlink = 0;	/* 0=ldir@  1=ldir -> dir */
int NCD_sort_mode = 0;	/* 0=strcmp,  1=strcasecmp_strip, 2=strcasecmp*/
int NCD_dir_indent = 12;
char * NCD_term_name;
int NCD_use_stdterm=1;
int NCD_doResize = 0;
int NCD_canResize = 0;

/*************************************************************************/
/* other global variables */

char NCD_Progname[PATH_MAX];
char NCD_home[PATH_MAX];	/* home dir (perhaps is a soft link...) */
char NCD_xhome[PATH_MAX];	/* home dir (physical directory) */
char NCD_cwd[PATH_MAX];	/* current working directory */
char NCD_root[PATH_MAX];	/* 'root' directory: / or HOME */
char NCD_xroot[PATH_MAX];	/* 'xroot' directory: / or xhome */
char NCD_finalDir[PATH_MAX];  /* final selected path */
char NCD_argumentDir[PATH_MAX];  /* command line argument: dir */

char NCD_homeFile[PATH_MAX];	/* home tree file */
char NCD_fullFile[PATH_MAX];	/* full tree file */
char NCD_selDirFile[PATH_MAX];	/* file for selected dir */

DirNode *NCD_rootNode;		/* xroot node */
DirNode *NCD_lastNode;     /* last node in the tree */
int NCD_nLinks;            /* number of recursive links processed */

char NCD_searchPath[PATH_MAX];		/* direct scan path */
int NCD_searchPLen;   /* NCD_searchPath last length */
int NCD_searchPX;   /* line editor horizontal position */

int NCD_x0, NCD_y0;	/* top left corner coords. */
DirNode *NCD_curNode;	/* currently selected node */

int NCD_cols;	/* screen COLS */
int NCD_lines;		/* screen LINES */
int NCD_use_color;		/* != 0 to use colors */
int NCD_cursesOn;    /* != if curses has initialized display */

/*************************************************************************/
/* refresh flags, for optimized display */
/* != 0 if must be repainted */
int NCD_refCurrent;     /* current cursor line */
int NCD_refRest;        /* rest of lines */
int NCD_refCurDir;      /* current directory field */
int NCD_refSearch;      /* search editor line */


/*##==============================================================####
##                                                                  ##
##                            Functions                             ##
##                                                                  ##
####==============================================================##*/



