/*
                ,,,
               (o o)
  ####=====oOO--(_)--OOO==========================================####
  ##                                                                ##
  ##  This file is part of NCD : a directory browser and selector   ##
  ##  Copyright (C) 1995,96 by Olivier Sirol                        ##
  ##                                                                ##
  ##         (Small prog to test ncurses getch capabilities)        ##
  ##                                                                ##
  ##  File            :  getk.c                                     ##
  ##  Author          :  Olivier SIROL                              ##
  ##  Date            :  Nov 1995                                   ##
  ##                                                                ##
  ##  E-mail support  :  sirol@ecoledoc.ibp.fr                      ##
  ##                                                                ##
  ####============================================================####


*/


static char rcsid[] = "$Id: getk.c,v 1.2 1996/05/06 22:40:08 olivier Exp $";


/*##==============================================================####
##                                                                  ##
##                          Include Files                           ##
##                                                                  ##
####==============================================================##*/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>

# include <curses.h>

#define Key_ALT_CTRL(x)  (0x80 | ((x)& 31))
#define Key_CTRL(x)      ((x) & 31)
#define Key_ALT(x)       (0x80|(x))



/*##==============================================================####
##                                                                  ##
##                            Constants                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                              Types                               ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Variables                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Functions                             ##
##                                                                  ##
####==============================================================##*/


/***********************************************************************/
void *
ncd_malloc (nbytes)
     unsigned int nbytes;
{
  void *pt;

  if (!(pt = malloc (nbytes)))
    {
      endwin();
      (void) fflush (stdout);
      (void) fflush (stderr);
      (void) fprintf (stderr, "## ncd error ## : not enough memory for malloc\n");
      exit (11);
    }
  return pt;
}


/***********************************************************************/
void *
ncd_strdup (string)
     char *string;
{
  void *pt;

  if (!(pt = strdup (string)))
    {
      endwin();
      (void) fflush (stdout);
      (void) fflush (stderr);
      (void) fprintf (stderr, "## ncd error ## : not enough memory for strdup\n");
      exit (12);
    }
  return pt;
}

/***********************************************************************/
void
ncd_exit (msg, fname)
     char *msg;
     char *fname;
{
  endwin();
  (void) fflush (stdout);
  (void) fflush (stderr);
  fprintf (stderr, "## ncd error ## : ");
  fprintf (stderr, msg, fname);
  exit (13);
}




/*************************************************************************/

int main(argc,argv)
int argc;
char *argv[];

{
  int ch;
  int quit = 0;
int rawflag=0;

printf("getk - A small prog to see whats ncurses getkey gets  (C) 1996 Czo\n");

  if (!(initscr ()))
      ncd_exit("can't initialize screen\n",NULL);

  /* intrflush(stdscr,FALSE); */
  /*  halfdelay(100); */
  /* notimeout(stdscr, TRUE); */
  
  meta (stdscr, TRUE);
  keypad (stdscr, TRUE);
  cbreak ();
  nl();
  /* raw(); */
  noecho ();
  clear (); 
  
rawflag=0;


  do
    {
     
     
    refresh();

    ch=getch();

    switch (ch)
	{
        case ERR :
          break;


	case 'r':
          rawflag = !(rawflag); 
          if (rawflag)
	     raw();
          else
	     noraw();
  nl();
cbreak();
          printf("Raw mode is %s\n", (rawflag ? "ON" : "OFF"));
	  break;

	case 'c':
	  quit = 1;
	  break;


	default:
          printf("Key = %X %s alt_ctrl:%X ctrl:%X alt:%X\n",
                ch,keyname(ch),Key_ALT_CTRL(ch),Key_CTRL(ch),Key_ALT(ch));

	  break;

	}
    }
  while (!quit);


clear();
refresh();

endwin();


}
/*************************************************************************/
