/*
                ,,,
               (o o)
  ####=====oOO--(_)--OOO==========================================####
  ##                                                                ##
  ##  This file is part of NCD : a directory browser and selector   ##
  ##  Copyright (C) 1995,96 by Olivier Sirol                        ##
  ##                                                                ##
  ##  Original Copyright (C) 1995 Borja Etxebarria                  ##
  ##  E-mail : borja@bips.bi.ehu.es                                 ##
  ##                                                                ##
  ##  File            :  disp.c                                     ##
  ##  Author          :  Olivier SIROL                              ##
  ##  Date            :  Nov 1995                                   ##
  ##                                                                ##
  ##  E-mail support  :  sirol@ecoledoc.ibp.fr                      ##
  ##                                                                ##
  ####============================================================####


*/


static char rcsid[] = "$Id: disp.c,v 1.24 1996/05/16 19:10:36 olivier Exp $";


/*##==============================================================####
##                                                                  ##
##                          Include Files                           ##
##                                                                  ##
####==============================================================##*/


# include <stdio.h>
# include <stdlib.h>
# include <string.h>

# include <curses.h>

# include <dirent.h>
# include "ncd.h"


/*##==============================================================####
##                                                                  ##
##                            Constants                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                              Types                               ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Variables                             ##
##                                                                  ##
####==============================================================##*/

extern char * NCD_Version;

/*##==============================================================####
##                                                                  ##
##                            Functions                             ##
##                                                                  ##
####==============================================================##*/

/*************************************************************************/

void 
paintLayout ()
{
  char *title = "Ninux Czo Directory";
  size_t len;
  int i;

  NCD_refCurrent = NCD_refRest = NCD_refCurDir = NCD_refSearch = 1;

  attrset (getColorMode (STD_TEXT_COLOR));
  border (0, 0, 0, 0, 0, 0, 0, 0);
  
  for (i = 1; i < NCD_lines - 1; i++)
      {
       move (i, 1);
       hline (' ', NCD_cols - 2);
      }
					    

  mvaddch (NCD_lines - 4, 0, ACS_LTEE );
  hline (ACS_HLINE , NCD_cols - 2);
  mvaddch (NCD_lines - 4, NCD_cols - 1, ACS_RTEE );

  mvaddstr (NCD_lines - 2, 2, "Search:");
  mvaddstr (NCD_lines - 2, NCD_cols - 13, "HELP=Ctrl+k");

  attrset (getColorMode (TITLE_COLOR));
  len = strlen (title);
  if (len > NCD_cols - 4)
    len = NCD_cols - 4;
  mvaddch (0, (NCD_cols - len) / 2 - 1, ' ');
  waddnstr (stdscr, title, len);
  addch (' ');
  attrset (getColorMode (STD_TEXT_COLOR));


}

/*************************************************************************/

char *
centerString (str, maxlen)
char *str;
int maxlen;
{
  int len, i;
  char *res;

  res = str;
  if ((len = strlen (res)) < maxlen)
    {
      for (i = 1; i <= len; i++)
	res[maxlen - i] = res[len - i];
      for (i = 0; i <= ((maxlen - len) / 2); i++)
	res[i] = ' ';
      for (i = 0; i < len; i++)
	res[((maxlen - len) / 2) + i] = res[(maxlen - len + i)];
      for (i = (((maxlen - len) / 2) + len); i < maxlen; i++)
	res[i] = ' ';

      res[maxlen] = '\0';
    }
  else
    res=truncString (str, maxlen);
  return res;
}

/*************************************************************************/

char *
truncString (str, maxlen)
char *str;
int maxlen;
{
  int len, i;
  char *res;

  res = str;

  len = strlen (res);

  if (len > maxlen)
    {
      for (i = 0; i < maxlen; i++)
	res[i] = res[len - maxlen + i];
      res[maxlen] = '\0';
      res[0] = res[1] = res[2] = '.';
    }

  return res;
}

/*************************************************************************/

void 
updateLine (i)
int i;
{
  int j, len, n, sel;
  char *s;

  s = getTreeLine (getLastNodeInLevel (NCD_rootNode, NCD_y0 + i), NCD_lineart, 1);
  move (i + 1, 2);
  attrset (getColorMode (STD_TEXT_COLOR));
  hline (' ', NCD_cols - 3);
  sel = 0;

  if (s)
    {
      len = strlen (s);
      n = 2;
      for (j = NCD_x0; j < len; j++)
	{
	  if (n > NCD_cols - 3)
	    break;
	  switch (s[j])
	    {
	    case NCD__ACS_HL:
	      addch (ACS_HLINE);
	      break;
	    case NCD__ACS_VL:
	      addch (ACS_VLINE);
	      break;
	    case NCD__ACS_LT:
	      addch (ACS_LTEE);
	      break;
	    case NCD__ACS_LLC:
	      addch (ACS_LLCORNER);
	      break;
	    case NCD__ACS_TT:
	      addch (ACS_TTEE);
	      break;
	    case NCD__SEL_ON:
	      attrset (getColorMode (SEL_TEXT_COLOR));
	      sel = 1;
	      n--;
	      break;
	    case NCD__SEL_OFF:
	      attrset (getColorMode (STD_TEXT_COLOR));
	      sel = 0;
	      n--;
	      break;
	    default:
	      addch (s[j]);
	    }
	  n++;
	}
      if ((sel) && (s[j] != NCD__SEL_OFF))
	mvaddstr (i + 1, NCD_cols - 5, "...");
    }
  leaveok (stdscr, FALSE);
  attrset (getColorMode (STD_TEXT_COLOR));
}

/*************************************************************************/

void
dataRefresh (newx, newy, newNode)
int newx;
int newy;
DirNode * newNode;

{
  int i, len, y;
  char *s;
  DirNode *oNode;
  int oy;

  if (newNode == NULL)
    newNode = NCD_curNode;

  if (newy < 0)
    newy = 0;
  if (newy > newNode->y)
    newy = newNode->y;
  if (newNode->y - newy > NCD_lines - 6)
    newy = newNode->y - (NCD_lines - 6);

  if (newx >= newNode->x)
    newx = newNode->x - 2;
  if (newx < 0)
    newx = 0;
  len = strlen (getNodeName (newNode, (NCD_showlink ? 1 : -1)));
  if (len > NCD_cols - 4)
    len = NCD_cols - 4;
  if (newNode->x - newx + len > NCD_cols - 4)
    newx = newNode->x + len - (NCD_cols - 4);

  len = strlen (NCD_searchPath);
  y = newNode->y - newy;

  if ((newx != NCD_x0) || (newy != NCD_y0))
    {
      NCD_refCurrent = 1;
      NCD_refRest = 1;
    }
  if (NCD_searchPLen != len)
    NCD_refSearch = 1;
  if ((NCD_curNode != newNode) || (NCD_curNode->y - NCD_y0 != y))
    NCD_refCurrent = 1;
  if (NCD_curNode != newNode)
    NCD_refCurDir = 1;


  oNode = NCD_curNode;
  oy = oNode->y - NCD_y0;

  NCD_x0 = newx;
  NCD_y0 = newy;
  NCD_curNode = newNode;

  leaveok (stdscr, TRUE);

  if (NCD_refSearch)
    {
      NCD_refSearch = 0;
      NCD_searchPLen = len;
      move (NCD_lines - 2, 10);
      attrset (getColorMode (SEARCH_FIELD_COLOR));
      if (NCD_cols - 25 > SEARCHWIN_LEN)
	{
	  hline (' ', SEARCHWIN_LEN);
	  NCD_searchPX = SEARCHWIN_LEN;
	}
      else
	{
	  hline (' ', NCD_cols - 25);
	  NCD_searchPX = NCD_cols - 25;
	}
      if (len < NCD_searchPX)
	{
	  waddstr (stdscr, NCD_searchPath);
	  NCD_searchPX = len;
	}
      else
	{
	  NCD_searchPX--;
	  waddstr (stdscr, NCD_searchPath + len - NCD_searchPX);
	  mvaddstr (NCD_lines - 2, 10, "...");
	}
    }

  attrset (getColorMode (STD_TEXT_COLOR));

  if (NCD_refCurrent)
    {
      NCD_refCurrent = 0;
      updateLine (y);
    }

/*  if (kbHit ())
    { 
      if (y != oy)
	NCD_refRest = 1;
      return;
    } */
  if (y != oy)
    updateLine (oy);

  if (NCD_refCurDir)
    {
     /* if (kbHit ())
	return; */
      NCD_refCurDir = 0;
      s = truncString (getNodeFullPath (newNode, 1, (NCD_scope == -1), NULL, 0), NCD_cols - 4);
      attrset (getColorMode (CURRENT_PATH_COLOR));
      mvaddstr (NCD_lines - 3, 2, s);
      hline (' ', NCD_cols - 4 - strlen (s));
      attrset (getColorMode (STD_TEXT_COLOR));
    }

  if (NCD_refRest)
    {
      for (i = 0; i < NCD_lines - 5; i++)
	{
	/*  if (kbHit ())
	    return; */
	  if ((i != y) && (i != oy))
	    updateLine (i);

	}
      NCD_refRest = 0;
    }
  leaveok (stdscr, FALSE);
  move (NCD_lines - 2, 10 + NCD_searchPX);
}



/*************************************************************************/
void
editSearch (ch)
     int ch;
{
  DirNode *dn;
  int len;
  int be;

  if ((ch == -1) || (ch == -2))
    {
       if (strlen (NCD_searchPath) == 0)
            {
              if (NCD_curNode->name != NULL)
                strcpy (NCD_searchPath, NCD_curNode->name);
            }

    }

  be = 0;
  len = strlen (NCD_searchPath);
  dn = NCD_curNode;


  if ((ch == 8) || (ch == 127) || (ch == 4))
    {
      if (len)
	{
	  NCD_searchPath[len - 1] = 0;
	}
      ch = 0;
    }

  if ((ch > 0) && (ch < 32))
    {
      be = 1;
    }
  else
    {
      if (ch>0)
	{
	  if (ch)
	    {
	      NCD_searchPath[len] = ch;
	      NCD_searchPath[len + 1] = '\0';
	    }
	  dn = findDirInCicle (NCD_rootNode, NCD_curNode, NCD_searchPath);
	}
      else if (len)
	{
	  if (ch == -2)
	    dn = findDirInCiclePrev (NCD_rootNode, prevNodeCiclic (NCD_rootNode, NCD_curNode), NCD_searchPath);
	  else
	    dn = findDirInCicle (NCD_rootNode, nextNodeCiclic (NCD_rootNode, NCD_curNode), NCD_searchPath);
	}
      else
	dn = NULL;

      if (dn == NULL)
	{
	  NCD_searchPath[len] = '\0';
	  be = 1;
	  dn = NCD_curNode;
	}
    }

  dataRefresh (NCD_x0, NCD_y0, dn);
  /* if (be) beep(); */
}

/*************************************************************************/
void 
showHelpScreen ()
{
  char title[256];
  char *msg =
  "                                                            "
  "    ______________MOVE_______________   ____SEARCH_____     "
  "    ^P/Up.........Up  ^A/Home....Home   ^I/</F9....Next     "
  "    ^N/Down.....Down  ^E/End......End   >/F10......Prev     "
  "    ^B/Left.....Left  ^U/PgUp....PgUp   ^H/BSpc...DelCh     "
  "    ^F/Right...Right  ^V/PgDn....PgDn   _____LINKS_____     "
  "    ^T..........Prev  ^O/^J.LineUp/Dn   F5/^W....Follow     "
  "    ______________MISC_______________   F6/^G......View     "
  "    F1/^K.....Help  F4/^L.....Repaint   _____EXIT______     "
  "    F2/^R...Rescan  F8.....Remove dir   F12/^X/^C..Quit     "
  "    F3/^Y....Scope  ^S......Sort mode   Return/^M....OK     "
  "                                                            "
  "";

  WINDOW *w;
  int x, y;

  strcpy(title," NCD version ");
  strcat(title,NCD_Version);
  strcat(title," ");


  y = (NCD_lines - HLP_LINES) / 2;
  x = (NCD_cols - HLP_COLS) / 2;
  w = newwin (HLP_LINES, HLP_COLS, y, x);

  leaveok (w, TRUE);
  wattrset (w, getColorMode (HELP_COLOR));

  mvwprintw (w, 1, 0, "%s", msg);
  box (w, ACS_VLINE,  ACS_HLINE);
  mvwprintw (w, HLP_LINES - 1, HLP_COLS - 37, " (C) 1996 B. Etxebarria & O. Sirol ");
  mvwaddstr (w, 0, (HLP_COLS - strlen (title)) / 2, title);                
  wattrset (w, getColorMode (STD_TEXT_COLOR));

  wrefresh (w);

  delwin (w);

}

/*************************************************************************/

void 
showHelpNoSpace ()
{
 cursMsg( "This screen is too small", "to display help window", NO_BUTTON );
}


/*************************************************************************/

int
cursMsg (message1, message2, button)
     char *message1;
     char *message2;
     int button;
{


  char msg1[PATH_MAX];
  char msg2[PATH_MAX];

  WINDOW *w;
  int x, y, i, j;
  int largeur, hauteur;
  int ch;
  int quit;
  int result;
  int first_pass;



  largeur = 40;
  hauteur = 8;
  strncpy (msg1, message1, PATH_MAX-1);
  msg1[PATH_MAX-1] = '\0';
  strncpy (msg2, message2, PATH_MAX-1);
  msg2[PATH_MAX-1] = '\0';

  centerString (msg1, largeur - 2);
  centerString (msg2, largeur - 2);

  w = newwin (hauteur, 
              largeur, 
              ((NCD_lines - hauteur) / 2), 
              ((NCD_cols - largeur) / 2));

  leaveok (w, TRUE);
  wattrset (w, getColorMode (DIALOG_BOX_COLOR));
  box (w, ACS_VLINE, ACS_HLINE);

  for (i = 1; i < hauteur - 1; i++)
    {
      mvwaddstr (w, i, 1, " ");
      for (j = 1; j < largeur - 2; j++)
	waddstr (w, " ");
    }

  quit = 0;
  result = 0;
  first_pass = 1;

  switch (button)
    {
    case NO_BUTTON:
      ch = getKey (0);
      mvwaddstr (w, 2, 1, msg1);
      mvwaddstr (w, hauteur - 3, 1, msg2);
      wrefresh (w);
      break;

    case OK_CANCEL_BUTTON:
      mvwaddstr (w, 2, 1, msg1);
      mvwaddstr (w, hauteur - 4, 1, msg2);
      do
	{
	  if (first_pass)
	    {
	      first_pass = 0;
	      ch = KEY_LEFT;
	    }
	  else
	    ch = getKey (-1);

	  switch (ch)
	    {
	    case Key_CTRL ('n'):
	    case KEY_RIGHT:
	    case Key_CTRL ('p'):
	    case KEY_LEFT:
	      result = !result;
	      if (result)
		{
		  wattrset (w, getColorMode (DIALOG_BOX_COLOR));
		  mvwaddstr (w, hauteur - 2, 1, "           Ok         ");
		  wattrset (w, getColorMode (BUTTON_COLOR));
		  waddstr (w, "<Cancel>");
		  wattrset (w, getColorMode (DIALOG_BOX_COLOR));
		  waddstr (w, "       ");
		  wrefresh (w);
		}
	      else
		{
		  wattrset (w, getColorMode (DIALOG_BOX_COLOR));
		  mvwaddstr (w, hauteur - 2, 1, "         ");
		  wattrset (w, getColorMode (BUTTON_COLOR));
		  waddstr (w, "< Ok >");
		  wattrset (w, getColorMode (DIALOG_BOX_COLOR));
		  waddstr (w, "        Cancel       ");
		  wrefresh (w);
		}
	      break;

	    case KEY_ENTER:
	    case Key_CTRL ('m'):
	    case ' ':
	      quit = 2;
	      break;

	    default:
	      break;
	    }
	}
      while (!quit);
      break;

    case OK_BUTTON:
      mvwaddstr (w, 2, 1, msg1);
      mvwaddstr (w, hauteur - 4, 1, msg2);
      wattrset (w, getColorMode (BUTTON_COLOR));
      mvwaddstr (w, hauteur - 2, 18, "< Ok >");
      wrefresh (w);
      ch = getKey (-1);
      break;
    }

  delwin (w);
  return result;
}

/*************************************************************************/
