/*
                ,,,
               (o o)
  ####=====oOO--(_)--OOO==========================================####
  ##                                                                ##
  ##  This file is part of NCD : a directory browser and selector   ##
  ##  Copyright (C) 1995,96 by Olivier Sirol                        ##
  ##                                                                ##
  ##  Original Copyright (C) 1995 Borja Etxebarria                  ##
  ##  E-mail : borja@bips.bi.ehu.es                                 ##
  ##                                                                ##
  ##  File            :  curs.c                                     ##
  ##  Author          :  Olivier SIROL                              ##
  ##  Date            :  Nov 1995                                   ##
  ##                                                                ##
  ##  E-mail support  :  sirol@ecoledoc.ibp.fr                      ##
  ##                                                                ##
  ####============================================================####


*/


static char rcsid[] = "$Id: curs.c,v 1.29 1996/05/16 19:10:36 olivier Exp $";


/*##==============================================================####
##                                                                  ##
##                          Include Files                           ##
##                                                                  ##
####==============================================================##*/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>

# include <curses.h>

# include <dirent.h>
# include "ncd.h"


/*##==============================================================####
##                                                                  ##
##                            Constants                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                              Types                               ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Variables                             ##
##                                                                  ##
####==============================================================##*/

/*##==============================================================####
##                                                                  ##
##                            Functions                             ##
##                                                                  ##
####==============================================================##*/



/*************************************************************************/

void ioResize()
{
 endwin(); 
 ioInitialize ();
 paintLayout();
 dataRefresh(NCD_x0, NCD_y0, NCD_curNode); 
 refresh();
}

/*************************************************************************/

void 
ioInitialize ()

{
  
  
  if (NCD_use_stdterm)
    { 
     if (initscr ()==NULL)
       ncd_exit("can't initialize screen\n",NULL);
    }
  else
    { 
     if (newterm(NCD_term_name, stdout, stdin)==NULL)
      ncd_exit("can't initialize terminal : %s.\n", NCD_term_name);
    }

  NCD_cursesOn = 1;

  getmaxyx (stdscr, NCD_lines, NCD_cols);

  if (NCD_lines < MIN_LINES)
      ncd_exit("not enought screen lines\n",NULL);

  if (NCD_cols < MIN_COLS)
      ncd_exit("not enought screen columns\n",NULL);

  /* intrflush(stdscr,FALSE); */
  /*  halfdelay(100); */
  /* notimeout(stdscr, TRUE); */
  
  meta (stdscr, TRUE);
  keypad (stdscr, TRUE);
  nonl ();
  raw();
  cbreak ();
  noecho ();
  prepareColorModes ();
  attrset (getColorMode (STD_TEXT_COLOR));
  clear (); 
}

/*************************************************************************/

void ioTerminate()
{
/* 	nl();
	nocbreak();
	echo();
	standend(); */

	clear();
	refresh();

	endwin();
	NCD_cursesOn = 0;
}

/*************************************************************************/

void 
prepareColorModes ()
{
  start_color ();
/*
   fprintf(stderr,"Has color                   : %d\n", has_colors()); 
   fprintf(stderr,"Can change color            : %d\n", can_change_color()); 
   fprintf(stderr,"Max number of colors        : %d\n", COLORS); 
   fprintf(stderr,"Max number of colorsi_pairs : %d\n", COLOR_PAIRS); 
 */

  NCD_use_color = (has_colors () && (COLORS > 7) && (COLOR_PAIRS > 63));

  if (NCD_use_color)
    {
      /*
      init_pair (STD_TEXT_COLOR,       COLOR_WHITE  ,   COLOR_BLUE);
      init_pair (SEL_TEXT_COLOR,       COLOR_WHITE  ,   COLOR_BLACK);
      init_pair (DIALOG_BOX_COLOR,     COLOR_BLACK  ,   COLOR_WHITE);
      init_pair (BUTTON_COLOR,         COLOR_BLACK  ,   COLOR_YELLOW);
      init_pair (CURRENT_PATH_COLOR,   COLOR_CYAN  ,   COLOR_BLUE);
      init_pair (HELP_COLOR,           COLOR_BLACK  ,   COLOR_CYAN);
      init_pair (TITLE_COLOR,          COLOR_BLACK  ,   COLOR_CYAN);
      init_pair (SEARCH_FIELD_COLOR,   COLOR_WHITE  ,   COLOR_BLACK);
      */

      init_pair (STD_TEXT_COLOR,       COLOR_BLACK  ,   COLOR_CYAN);
      init_pair (SEL_TEXT_COLOR,       COLOR_WHITE  ,   COLOR_BLACK);
      init_pair (DIALOG_BOX_COLOR,     COLOR_BLACK  ,   COLOR_WHITE);
      init_pair (BUTTON_COLOR,         COLOR_WHITE  ,   COLOR_BLUE);
      init_pair (CURRENT_PATH_COLOR,   COLOR_BLUE  ,   COLOR_CYAN);
      init_pair (HELP_COLOR,           COLOR_WHITE  ,   COLOR_BLUE);
      init_pair (TITLE_COLOR,          COLOR_WHITE  ,   COLOR_BLUE);
      init_pair (SEARCH_FIELD_COLOR,   COLOR_WHITE  ,   COLOR_BLACK);
    }

}

/*************************************************************************/
int
getColorMode (c)
     int c;
{
  if (NCD_use_color)
    return COLOR_PAIR (c);
  else
    {
      switch (c)
	{
	case STD_TEXT_COLOR:
	case BUTTON_COLOR:
	case CURRENT_PATH_COLOR:
	  return A_NORMAL;
	default:
	  return A_STANDOUT;
	}
    }
}



/*************************************************************************/
/* getKey  */
/* delay=0 -> no delay. <0 -> block */


int 
getKey (delay)
     int delay;
{
  key_def x_key[] =
  {
    {KEY_F (1), "[aa"},
    {KEY_F (1), "[11~"},
    {KEY_F (2), "[12~"},
    {KEY_F (3), "[13~"},
    {KEY_F (4), "[14~"},
    {KEY_F (5), "[15~"},
    {KEY_F (6), "[17~"},
    {KEY_F (7), "[18~"},
    {KEY_F (8), "[19~"},
    {KEY_F (9), "[20~"},
    {KEY_F (10), "[21~"},
    {KEY_F (11), "[23~"},
    {KEY_F (12), "[24~"},
    {KEY_HOME, "[1~"},
    {KEY_END, "[4~"},
    {KEY_DC, "[3~"},
    {KEY_IC, "[2~"},
    {KEY_PPAGE, "[5~"},
    {KEY_NPAGE, "[6~"},
    {KEY_DOWN, "[B"},
    {KEY_UP, "[A"},
    {KEY_LEFT, "[D"},
    {KEY_RIGHT, "[C"},
    {KEY_DOWN, "OB"},
    {KEY_UP, "OA"},
    {KEY_LEFT, "OD"},
    {KEY_RIGHT, "OC"},
    {0, 0},
  };

  int esc_cmpt;
  int esc_sym;
  int esc_ch;

  char esc_str[4];
  /* char debug_str[256]; */
  int ch;

  timeout (delay);
  ch = getch ();

  if (ch == 27)
    {
      esc_cmpt = 0;
      esc_str[0] = '\0';
      timeout(100);  
      while ((esc_ch = getch()) != ERR)
	{
	  if (esc_cmpt < 4)
	    {
	      esc_str[esc_cmpt] = esc_ch;
	      esc_str[esc_cmpt + 1] = '\0';
	      esc_cmpt++;
	    }
	}

      for (esc_cmpt = 0; x_key[esc_cmpt].code; esc_cmpt++)
	{
	  if (strcmp (esc_str, x_key[esc_cmpt].seq) == 0)
	    {
	      esc_sym = x_key[esc_cmpt].code;
              ch = esc_sym;
	      break;
	    }
	}
    }

  return ch;
}


/*************************************************************************/

void showHelp()
{
	if ((NCD_lines<HLP_LINES)||(NCD_cols<HLP_COLS))
		showHelpNoSpace();
	else
		showHelpScreen(); 
		
	getKey(-1);
}

/*************************************************************************/
/* quit = 2 -> accept
   quit = 1 -> cancel
   quit = 3 -> rescan 
   quit = 4 -> toggle scope */


DirNode *
selectANode (quit)
     int *quit;
{
  int ch;
  *quit = 0;

  if (!NCD_cursesOn)
    ioInitialize ();

  NCD_curNode = locatePathOrSo (NCD_cwd, NULL);
  NCD_x0 = 0;
  if (NCD_lastNode->y < (NCD_lines - 5))
    NCD_y0 = 0;
  else
    {
      NCD_y0 = NCD_curNode->y - ((NCD_lines - 6) / 2);
      if (NCD_lastNode->y - NCD_y0 < NCD_lines - 6)
	NCD_y0 = NCD_lastNode->y - (NCD_lines - 6);
    }
  NCD_searchPath[0] = 0;

  paintLayout ();
  dataRefresh (NCD_x0, NCD_y0, NCD_curNode);

  do
    {
     
     NCD_canResize = 1;

     if (NCD_doResize == 1)
        {
         ioResize ();
         NCD_doResize = 0;
        }
     
     refresh();

        /* 0 : dont wait for a key (for resize) */
        /* but big system CPU load , getkey(100) dont work? */
        /* this getch (getKey) does the refresh why?*/

                   ch=getKey(-1);

    NCD_canResize = 0;
    switch (ch)
	{
        case ERR :
          break;

	case KEY_DOWN:
	case Key_CTRL ('n'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getNodeCursDownNatural (NCD_curNode));
	  break;

	case KEY_UP:
	case Key_CTRL ('p'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getNodeCursUpNatural (NCD_curNode));
	  break;

	case KEY_LEFT:
	case Key_CTRL ('b'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getNodeCursLeft (NCD_curNode));
	  break;

	case KEY_RIGHT:
	case Key_CTRL ('f'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getNodeCursRight (NCD_curNode));
	  break;

	case KEY_HOME:
	case Key_CTRL ('a'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, NCD_rootNode);
	  break;

	case KEY_END:
	case Key_CTRL ('e'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getLastDescendant (NCD_curNode));
	  break;

	case KEY_PPAGE:
	case Key_CTRL ('u'):
	  NCD_searchPath[0] = 0;
	  if (NCD_curNode->y < (NCD_lines - 6))
	    dataRefresh (0, 0, NCD_rootNode);
	  else
	    dataRefresh (NCD_x0, NCD_y0 - (NCD_lines - 6), getFirstNodeInLevel (NCD_rootNode, NCD_curNode->y - (NCD_lines - 6)));
	  break;

	case KEY_NPAGE:
	case Key_CTRL ('v'):
	  NCD_searchPath[0] = 0;
	  if (NCD_curNode->y + (NCD_lines - 6) >= NCD_lastNode->y)
	    dataRefresh (NCD_x0, NCD_y0, NCD_lastNode);
	  else
	    {
	      if (NCD_y0 + (NCD_lines - 6) * 2 < NCD_lastNode->y)
		dataRefresh (NCD_x0, NCD_y0 + (NCD_lines - 6), getFirstNodeInLevel (NCD_rootNode, NCD_curNode->y + (NCD_lines - 6)));
	      else
		dataRefresh (NCD_x0, NCD_lastNode->y - (NCD_lines - 6), getFirstNodeInLevel (NCD_rootNode, NCD_curNode->y + (NCD_lines - 6)));
	    }
	  break;

	case Key_CTRL ('o'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getNodeLnUp (NCD_curNode));
	  break;

	case Key_CTRL ('j'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getNodeLnDn (NCD_curNode));
	  break;

	case Key_CTRL ('s'):
	  SortDir();
	  /* clear (); */
	  paintLayout ();
	  dataRefresh (NCD_x0, NCD_y0, NCD_curNode);
	  break;

	case KEY_F (8):
	  if (NCD_curNode->left)
            RemoveDir();
	  NCD_searchPath[0] = 0;
	  /* clear (); */
	  paintLayout ();
	  dataRefresh (NCD_x0, NCD_y0, NCD_curNode);
	  break;

	case Key_CTRL ('t'):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getNodePrev (NCD_curNode));
	  break;

	case Key_CTRL ('x'):
	case Key_CTRL ('c'):
	case KEY_F (12):
	  *quit = 1;
	  break;

	case Key_CTRL ('i'):
	case KEY_F (9):
	case '<':
	  editSearch (-1);
	  break;

	case KEY_F (10):
	case '>':
	  editSearch (-2);
	  break;

	case KEY_BACKSPACE:
	  editSearch (8);
	  break;

	case Key_CTRL ('k'):
	case KEY_F (1):
	  showHelp ();
	  paintLayout ();
	  dataRefresh (NCD_x0, NCD_y0, NCD_curNode);
	  break;

	case KEY_F (2):
	case Key_CTRL ('r'):
	  *quit = 3;
	  break;

	case KEY_F (3):
	case Key_CTRL ('y'):
	  *quit = 4;
	  strcpy (NCD_cwd, getNodeFullPath (NCD_curNode, 0, 0, NULL, 1));
	  break;

	case Key_CTRL ('g'):
	case KEY_F (6):
	  NCD_showlink = !NCD_showlink;
	  paintLayout ();
	  dataRefresh (NCD_x0, NCD_y0, NCD_curNode);
	  break;

	case Key_CTRL ('w'):
	case KEY_F (5):
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, getNodeFollowLink (NCD_rootNode, NCD_curNode));
	  break;

	case KEY_DL:
	case KEY_EOL:
	case Key_CTRL ('d'):
	case KEY_DC:
	  NCD_searchPath[0] = 0;
	  dataRefresh (NCD_x0, NCD_y0, NCD_curNode);
	  break;

	case Key_CTRL ('l'):
	case KEY_F (4):
	  clear ();
	  paintLayout ();
	  dataRefresh (NCD_x0, NCD_y0, NCD_curNode);
	  break;

	case KEY_ENTER:
	case Key_CTRL ('m'):
	  *quit = 2;
	  break;

	default:
	  if ((ch > 0) && (ch <= 255))
	    editSearch (ch);
	  else
	    {
	      dataRefresh (NCD_x0, NCD_y0, NCD_curNode);
	      beep ();
	    }
	  break;

	}
    }
  while (!*quit);

  if (*quit <= 2)
    ioTerminate ();

  if (*quit == 2)
    return NCD_curNode;
  else
    return NULL;
}
/*************************************************************************/
