/* tty.h -- #defines, data structures & function prototypes for tty.c stuff. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifndef _GIT_TTY_H
#define _GIT_TTY_H


#include <sys/types.h>

#ifdef HAVE_POSIXTTY
#include <termios.h>
#else
#ifdef HAVE_SYSTEMVTTY
#include <termio.h>
#else
#include <sgtty.h>
#endif /* HAVE_SYSTEMVTTY */
#endif /* HAVE_POSIXTTY */

#include "window.h"


#ifndef _POSIX_VDISABLE
#define _POSIX_VDISABLE 0
#endif

#define MAX_TTY_COLUMNS         512
#define MAX_TTY_ROWS            512


#define MAX_CAPABILITY_LEN       64     /* If you have greater terminal
                                           capabilities change this */

#define OFF                     0
#define ON                      1

/* Color constants.  */
#define BLACK                   0
#define RED                     1
#define GREEN                   2
#define YELLOW                  3
#define BLUE                    4
#define MAGENTA                 5
#define CYAN                    6
#define WHITE                   7


/* Some key aliases.  */
#define key_CTRL_G              0007            /* Ctrl-G               */
#define key_CTRL_Z              0032            /* Ctrl-Z               */
#define key_ENTER               0012            /* Enter                */
#define key_BACKSPACE           0177            /* Backspace            */
#define key_TAB                 0011            /* Tab                  */


/* The interrupt character.  */
#define key_INTERRUPT           key_CTRL_G
#define key_SUSPEND             key_CTRL_Z


/* Terminal modes.  */
#define TTY_CANONIC     0
#define TTY_NONCANONIC  1


/* Terminal input modes.  */
#define TTY_RESTRICTED_INPUT    0
#define TTY_FULL_INPUT          1


#define is_print(c)             ((c) >= ' ' && (c) <= '~')


extern void (* tty_enter_idle_hook) __P(());
extern void (* tty_exit_idle_hook) __P(());


typedef struct tag_tty_key_t
{
    unsigned char *key_seq;
    struct tag_tty_key_t *next;
    void *aux_data;
} tty_key_t;


typedef struct 
{
    int fg_color;
    int bg_color;
    int br_status;
    int rv_status;
    int cursor_status;
    unsigned char attribute;
} tty_status_t;


extern void tty_startup __P(());
extern void tty_exit __P(());

extern void tty_get_capabilities __P(());
extern void tty_kbdinit __P((int));
extern void tty_set_mode __P((int));
extern void tty_set_interrupt_char __P((unsigned char));

extern void tty_clear __P(());
extern void tty_touch __P(());
extern void tty_cursormove __P((int, int));
extern void tty_cursormove_notify __P((int, int));
extern void tty_brightness __P((int));
extern void tty_foreground __P((int));
extern void tty_background __P((int));
extern void tty_colors __P((int, int, int));
extern void tty_cursor __P((int));
extern void tty_beep __P(());
extern void tty_defaults __P(());
extern void tty_save __P((tty_status_t *));
extern void tty_restore __P((tty_status_t *));
extern size_t tty_write __P((char *, size_t));
extern size_t tty_read __P((char *, size_t));
extern size_t tty_put_char __P((char));
extern int tty_get_char __P(());
extern void tty_get_size __P((int *, int *));
extern void tty_get_screen __P((char *));
extern void tty_put_screen __P((char *));
extern int tty_get_color_index __P((char *));
extern void tty_key_list_insert __P((unsigned char *, void *));
extern void tty_key_search_restart __P(());
extern char *tty_key_convert __P((unsigned char *));
extern char *tty_get_symbol_key_seq __P((char *));
extern void tty_get_exit_colors __P(());
extern int tty_set_optimization_level __P((int));
/*
extern void tty_key_list_delete __P(());
*/


extern tty_key_t *tty_key_search __P((char *));
extern tty_key_t *tty_get_key __P((int *));


#endif  /* _GIT_TTY_H */
