
#include <stddef.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <iostream.h>
#include <sys/stat.h>

const int TRUE = -1;
const int FALSE = 0;

void lsdfunc(char *);
int isdir(char *, char *);

int main (int argc, char *argv[])
{

	if ((argc == 2) && (strcmp(argv[1], "--help") == 0))
	{
		puts("LiSt Directory (lsd) - v0.01 stable - 21-June-1999");
		puts("by Paul Sullivan <paul.sullivan@acm.org>");
		puts("Distributed under the terms of the GNU GPL");
		puts(" ");
		puts("usage: lsd <directory-name>");
		puts("  where <directory-name> is optional and if empty,");
		puts("  lsd will list contents of current subdirectory");
		return 0;
	}

	if (argc == 2) 
		lsdfunc(argv[1]);
        else {
		char *temp;
		int tempbuff=255;
		lsdfunc(getcwd(NULL));
	}
	return 0;
}

int isdir(char *pathname, char *filename)
{
  int status = FALSE;
  struct stat statbuf;

  char tempname[255]; 
 

  if (strcmp(filename, ".") == 0) {
  
    return  FALSE;
  }
  if (strcmp(filename, "..") == 0) {
   
    return FALSE;
  }



  strcpy(tempname, pathname);
  strcat(tempname, "/");
  strcat(tempname, filename);

  
  lstat(tempname, &statbuf);
  if (S_ISDIR(statbuf.st_mode) != 0)
    status = TRUE;
  
 if (status != TRUE)
  puts(tempname);
  
return status;

}

void lsdfunc(char *pathname)
{
	char *filename;
	DIR *dp;
	struct dirent *ep;
	char newdir[255];

	dp = opendir(pathname);
	if (dp != NULL) {
		while (ep = readdir(dp)) {

			if ((isdir(pathname, ep->d_name)) == TRUE) {
				strcpy(newdir, pathname);
			        strcat(newdir, "/");
				strcat(newdir, ep->d_name);
				lsdfunc(newdir);
				}


		}
		(void) closedir (dp);
	}
	else
		cout << "Couldn't open directory: " << pathname << endl;
}
			
	
