
/* process_lists.c
   USAGE: process_lists	   inode_list_file	pair_list_file
   	inode list file is a file with one inode number on each line,
   		sorted numerically (ascending).  Should be run through uniq
   		also.
        pair_list_file is a file with an inode number followed by a space
        	and a file path on each line.  It is also sorted
        	numerically (ascending).

        For each inode number which appears in both files, print the
        	file path from the pair_list_file.

*/
/* (C) Copyright 1995 by Michael Coulter.  All rights reserved. */

#include <stdio.h>
#include <stdlib.h>

extern void print_usage();

#define FALSE		0
#define TRUE 		1
#define MAX_FILE_PATH	2000

main(int argc, char** argv)
{
   char		file_path[MAX_FILE_PATH];
   FILE* 	inode_list_fp;
   long int	inode1_nbr;
   long int	inode2_nbr;
   int		is_more_input;
   FILE* 	pair_list_fp;
   int		result;

   if (argc != 3) {
      print_usage();
      exit(1);
   }
   if ((inode_list_fp = fopen(argv[1], "r") ) == NULL) {
      print_usage();
      fprintf(stderr, "Unable to open %s\n", argv[1]);
      exit(1);
   }
   if ((pair_list_fp = fopen(argv[2], "r") ) == NULL) {
      print_usage();
      fprintf(stderr, "Unable to open %s\n", argv[2]);
      exit(1);
   }

   is_more_input = TRUE;
   inode1_nbr = inode2_nbr = 0;
   while (is_more_input) {
      if (   inode1_nbr <= inode2_nbr
          && (result = fscanf(inode_list_fp, "%ld", &inode1_nbr)) != 1) 
      {
         is_more_input = FALSE;
      } else {
	 if (   inode2_nbr < inode1_nbr 
	     && (result = fscanf(pair_list_fp, "%ld %s", &inode2_nbr, file_path)) 
	        != 2) 
         { 
	    is_more_input = FALSE;
         } else {
            if (inode1_nbr == inode2_nbr) {
               fprintf(stdout, "%ld		%s\n", inode2_nbr, file_path);
            }
         }
      }
   } /* while input on both files */

} /* end main */


void print_usage()
{
   fprintf(stderr, "USAGE: process_lists inode_list_file pair_list_file\n");
   fprintf(stderr, "One inode number per line in the first file.\n");
   fprintf(stderr, "An inode number and a file path per line in the second.\n");
} /* end print_usage */
