/** getoption.c -- interface to GNU getopt_long.
 *
 * Copyright (c) 1997 by Leith S. Young.  All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**/

/* Written by Leith S. Young  (leithy@ma.ultranet.com) */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>

#include "xproto.h"

#if HAVE_GETOPT_LONG
#include <getopt.h>
#else
#include "getopt.h"
#endif

int get_option __P ((int argc, char **argv, const char *short_options,
		     struct option const *long_opts, int (*setopt) ()));
char *xstrdup __P ((char *string));

int
get_option (argc, argv, short_options, long_options, setopt)
     int argc;
     char **argv;
     const char *short_options;
     const struct option *long_options;
     int (*setopt) ();
{
  int c;
#ifdef HAVE_SETENV
#ifdef HAVE_UNSETENV
  char *p;
  char *pc = NULL;

  p = getenv ("POSIXLY_CORRECT");
  if (p)
    {
/* Save value of POSIXLY_CORRECT for later restore */
      pc = xstrdup (p);
/* Unset POSIXLY_CORRECT, so that arguments will be permuted */
      unsetenv ("POSIXLY_CORRECT");
    }
#endif /* HAVE_UNSETENV */
#endif /* HAVE_SETENV */

  while ((c = getopt_long (argc, argv, short_options, long_options,
			   (int *) 0)) != EOF)
    {
      if (!(*setopt) (c, 1, 1))
	break;
    }
#ifdef HAVE_SETENV
  if (pc)
    {
/* Set POSIXLY_CORRECT environment variable to original value */
      setenv ("POSIXLY_CORRECT", pc, 0);
      free (pc);
    }
#endif
  return c;
}
