/* Linux 1.2.13 (Slackware 3.0) Includes */
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <string.h>

/* my includes */
#include "info.h"

/* functions */
void main(int argc, char *argv[])
{
   int fd=0;                  
   struct stat buf={0};      

   if(argc!=2) help(2,NULL); 
   if(argv[1][0]=='-') help(1,NULL);
   if(access(argv[1],R_OK)==0)
      fd=open(argv[1],O_RDONLY,0);
   else
      help(3,argv[1]);
   fstat(fd,&buf); 
   print(buf);    
   exit(0);
}

void print(struct stat buf)
{
   dev_t maj_dev=0,min_dev=0;
   mode_t operm=0;
   char perms[15]={0};
   char uname[9]={0};
   char gname[9]={0};
   struct tm *time=NULL;
   

   if (buf.st_rdev)
   {
	  maj_dev=major(buf.st_rdev);
      min_dev=minor(buf.st_rdev);
   }

   fprintf(stdout,"info, version "VERSION"\n"
                  "    Copyright (c) 1996 Peter M. Jones aka ToneDef, <1-9951@tnet.bluethun.com>\n"
                  "\n");
   if (buf.st_rdev)
      fprintf(stdout,
                  "Device:            Yes.\n"
                  "   Major:          %d\n"
                  "   Minor:          %d\n",maj_dev,min_dev);
   else
	  fprintf(stdout,
				  "Device:            No.\n");
   fprintf(stdout,"Inode:             %ld\n",buf.st_ino);
   set_perms(perms,buf);
   operm=set_octal(buf.st_mode);
   fprintf(stdout,"Mode:              (%s) (0%o)\n",perms, operm);
   if (perms[0]=='d')
	  fprintf(stdout,"Subdirectories:    %d\n",buf.st_nlink);
   else
	  fprintf(stdout,"Links to file:     %d\n",buf.st_nlink);
   getnames(buf.st_uid,buf.st_gid, uname,gname);
   fprintf(stdout,"Owner Name:        %s\n"
				  "Group Name:        %s\n",uname,gname);
   fprintf(stdout,"Size:              %ld\n",(long int)buf.st_size);
   time=localtime(&buf.st_atime);
   fprintf(stdout,"Last accessed:     %s",asctime(time));
   time=localtime(&buf.st_mtime);
   fprintf(stdout,"Last modified:     %s",asctime(time));
   time=localtime(&buf.st_ctime);
   fprintf(stdout,"Last inode change: %s",asctime(time));
}

void getnames(long int uid, long int gid, char *uname, char *gname)
{
   struct passwd *pw=NULL;
   struct group *gpw=NULL;

   pw=getpwuid(uid);
   strcpy(uname,pw->pw_name);
   gpw=getgrgid(gid);
   strcpy(gname,gpw->gr_name);
}

void set_perms(char *perms, struct stat buf)
{
   char *modes[] = {"---","--x","-w-","-wx","r--","r-x","rw-","rwx"};
   int i=0, j=0;
  
   *perms = '\0';
   strcat(perms,"\0\0\0\0\0\0\0\0\0\0\0\0\0");
   switch (buf.st_mode & S_IFMT)
   {
      case S_IFREG:
         perms[0]='-'; 
	 break;
      case S_IFDIR:
         perms[0]='d';
         break;
      case S_IFCHR:
	 perms[0]='c';
         break;
      case S_IFBLK:
         perms[0]='b';
         break;
      case S_IFLNK:
         perms[0]='l';
         break;
      case S_IFSOCK:
         perms[0]='s';
         break;
      case S_IFIFO:
         perms[0]='f';
         break;
      default:
         perms[0]='?';
         break;
   }
   for(i=2; i>=0; i--)
   {
      j = (buf.st_mode >> (i*3)) & 07;
      strcat(perms, modes[j]);
   }
   if (perms[3]=='x')
      perms[11]='x';

   if (perms[6]=='x')
      perms[12]='x';

   if (perms[9]=='x')
      perms[13]='x';

   if ((buf.st_mode & S_ISUID) != 0)
   {
     if(buf.st_uid==0)
        perms[3] = 'S';
     else
        perms[3] = 's';
   }
   if ((buf.st_mode & S_ISGID) != 0)
   {
     if(buf.st_uid==0)
        perms[6] = 'S';
     else
        perms[6] = 's';
   }
   if ((buf.st_mode & S_ISVTX) != 0)
	  perms[9] = 't';
}

mode_t set_octal(mode_t oct)
{
   oct&=(~S_IFMT);
   return(oct);
}

void help(int exitval, char *fname)
{
   FILE *fp=NULL;
   
   if(exitval<3)
   {
      fp=fdopen(exitval,"w");
      fprintf(fp,"info, version "VERSION"\n"
                 "    Copyright (c) 1996 Peter M. Jones aka ToneDef, <1-9951@tnet.bluethun.com>\n"
                 "\n"
                 "usage: info filename\n");
      exit(exitval-1);
   } else {
      fprintf(stderr,"info, version "VERSION"\n"
                     "    Copyright (c) 1996 Peter M. Jones aka ToneDef, <1-9951@tnet.bluethun.com>\n"
                     "\n"
                     "ERROR: file \"%s\" is not readable.\n"
                     "  Check to be sure that the +r permission is set, "
                     "and that the file exists.\n", 
                     fname);
      exit(1);
   }
}
