/*******************************************************************************
        HOLE version 5.0 - Copyright (C) Vinnie Marks & Eric Beyer 1999
                            Last update: May 11 1999

                            The "Artistic License"

                                   Preamble

The intent of this document is to state the conditions under which a
Package may be copied, such that the Copyright Holder maintains some
semblance of artistic control over the development of the package,
while giving the users of the package the right to use and distribute
the Package in a more-or-less customary fashion, plus the right to make
reasonable modifications.

Definitions:

	"Package" refers to the collection of files distributed by the
	Copyright Holder, and derivatives of that collection of files
	created through textual modification.

	"Standard Version" refers to such a Package if it has not been
	modified, or has been modified in accordance with the wishes
	of the Copyright Holder.

	"Copyright Holder" is whoever is named in the copyright or
	copyrights for the package.

	"You" is you, if you're thinking about copying or distributing
	this Package.

	"Reasonable copying fee" is whatever you can justify on the
	basis of media cost, duplication charges, time of people involved,
	and so on.  (You will not be required to justify it to the
	Copyright Holder, but only to the computing community at large
	as a market that must bear the fee.)

	"Freely Available" means that no fee is charged for the item
	itself, though there may be fees involved in handling the item.
	It also means that recipients of the item may redistribute it
	under the same conditions they received it.

1. You may make and give away verbatim copies of the source form of the
Standard Version of this Package without restriction, provided that you
duplicate all of the original copyright notices and associated disclaimers.

2. You may apply bug fixes, portability fixes and other modifications
derived from the Public Domain or from the Copyright Holder.  A Package
modified in such a way shall still be considered the Standard Version.

3. You may otherwise modify your copy of this Package in any way, provided
that you insert a prominent notice in each changed file stating how and
when you changed that file, and provided that you do at least ONE of the
following:

    a) place your modifications in the Public Domain or otherwise make them
    Freely Available, such as by posting said modifications to Usenet or
    an equivalent medium, or placing the modifications on a major archive
    site such as ftp.uu.net, or by allowing the Copyright Holder to include
    your modifications in the Standard Version of the Package.

    b) use the modified Package only within your corporation or organization.

    c) rename any non-standard executables so the names do not conflict
    with standard executables, which must also be provided, and provide
    a separate manual page for each non-standard executable that clearly
    documents how it differs from the Standard Version.

    d) make other distribution arrangements with the Copyright Holder.

4. You may distribute the programs of this Package in object code or
executable form, provided that you do at least ONE of the following:

    a) distribute a Standard Version of the executables and library files,
    together with instructions (in the manual page or equivalent) on where
    to get the Standard Version.

    b) accompany the distribution with the machine-readable source of
    the Package with your modifications.

    c) accompany any non-standard executables with their corresponding
    Standard Version executables, giving the non-standard executables
    non-standard names, and clearly documenting the differences in manual
    pages (or equivalent), together with instructions on where to get
    the Standard Version.

    d) make other distribution arrangements with the Copyright Holder.

5. You may charge a reasonable copying fee for any distribution of this
Package.  You may charge any fee you choose for support of this Package.
You may not charge a fee for this Package itself.  However,
you may distribute this Package in aggregate with other (possibly
commercial) programs as part of a larger (possibly commercial) software
distribution provided that you do not advertise this Package as a
product of your own.

6. The scripts and library files supplied as input to or produced as
output from the programs of this Package do not automatically fall
under the copyright of this Package, but belong to whomever generated
them, and may be sold commercially, and may be aggregated with this
Package.

7. C or perl subroutines supplied by you and linked into this Package
shall not be considered part of this Package.

8. The name of the Copyright Holder may not be used to endorse or promote
products derived from this software without specific prior written permission.

9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

				The End

                                based on

         NUTS version 3.3.3 - Copyright (C) Neil Robertson 1996
                     Last update: 18th November 1996

 This software is provided as is. It is not intended as any sort of bullet
 proof system for commercial operation (though you may use it to set up a
 pay-to-use system, just don't attempt to sell the code itself) and I accept
 no liability for any problems that may arise from you using it. Since this is
 freeware (NOT public domain, I have not relinquished the copyright) you may
 distribute it as you see fit and you may alter the code to suit your needs.

 Read the COPYRIGHT file for further information.

 Neil Robertson.

 Email    : neil@ogham.demon.co.uk
 Home page: http://www.wso.co.uk/neil.html (need JavaScript enabled browser)
 NUTS page: http://www.wso.co.uk/nuts.html
 Newsgroup: alt.talkers.nuts

 NB: This program listing looks best when the tab length is 5 chars which is
 "set ts=5" in vi.


********************************************************************************
This software is dedicated to all the users who made HOLE what it was,
especially the most memorable users which include Jennifer Ambrass, Ron Haans,
Christina Lam, James Maffett, Bethany Moore, Amy Prochniak, & Maren Richards.

Authors note: Do not use this software if it's only to satisfy your ego. If
you only want to run a talker to feel important, I suggest therapy... Half of
the world's problems are caused by people who want to feel important. Secondly,
don't boot anyone off unless there really is a reason ie. user is swearing in
a public room or harassing people in general. Doing this can hurt the person
more than you expect and in the end can hurt yourself. Last but not least,
don't suck all the fun out of this by making it some competition with other
people. Have a good time, relax... Live and let live.

Well, enjoy.
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <unistd.h>
#include <setjmp.h>
#include <err.h>
#include <errno.h>
#include <dirent.h>
#include <ctype.h>
#include <locale.h>
#include <langinfo.h>
#include <getopt.h>
#include <_G_config.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/wait.h>
#ifdef _AIX
#include <sys/select.h>
#endif
#include <arpa/inet.h>
#include <netinet/in.h>

#include "hole.h"

char *backwards(char *str);
char *center(char *str,int len);
char *color_com_strip(char *str);
char *consolidate(char *str);
char *garble(char *str);
char *get_ip_address(UR_OBJECT user,struct sockaddr_in acc_addr,int which);
char *get_site(char *str);
char *name_strip(char *str);
char *pt_name(char *str);
char *pt_strip(char *str);
char *remove_first(char *str);
char *remove_space(char *str);
char *split_str(char *str,char delim);
char *strange(char *str);
char *wordwrap(char *str,int len);
int alphabet(UR_OBJECT user,int which,char *color,int len);
int bannerthreedfont(UR_OBJECT user,int which,char *color,int len);
int barbwire(UR_OBJECT user,int which,char *color,int len);
int bats_nearby(UR_OBJECT user);
int binary(UR_OBJECT user,int which,char *color);
int check_autohide(UR_OBJECT user,char *site);
int check_email(UR_OBJECT user,char *str);
int check_game(UR_OBJECT user);
int check_ifannoy(UR_OBJECT user);
int check_ifauto(UR_OBJECT user);
int check_iflim(UR_OBJECT user);
int check_iflom(UR_OBJECT user);
int check_merlyn(UR_OBJECT user);
int check_multiple(UR_OBJECT user,char *name);
int check_nkind(UR_OBJECT user,int which);
int check_site(char *str,char *site);
int check_specialsite(char *site);
int check_straight(UR_OBJECT user,int which);
int check_talk(UR_OBJECT user);
int check_tgame(UR_OBJECT user);
int check_ttt(UR_OBJECT user,UR_OBJECT u);
int check_used(UR_OBJECT user,char *which);
int check_vgame(UR_OBJECT user);
int color_com_count(char *str,int which);
int command_disabled(UR_OBJECT user,char *comname,int which);
int command_granted(UR_OBJECT user,char *comname);
int connect_to_site(NL_OBJECT nl);
int contains_pt(char *str);
int contains_swearing(char *str);
int contains_trigger(UR_OBJECT user,char *str);
int day_in_week(int calday,int calmonth,int calyear);
int day_in_year(int calday,int calmonth,int calyear);
int domain_allowed(char *domain);
int domain_banned(char *domain);
int epic(UR_OBJECT user,int which,char *color,int len);
int get_alias(UR_OBJECT user,char *str,int which);
int get_charclient_line(UR_OBJECT user,char *str,int len);
int get_color(UR_OBJECT user,int which);
int get_level(char *name,int which);
int has_unread_mail(UR_OBJECT user);
int instr(char *s1,char *s2);
int int_compare(const void *a,const void *b);
int isletter(int c);
int isnumber(char *str);
int load_user_details(UR_OBJECT user);
int main(int argc,char *argv[]);
int misc_ops(UR_OBJECT user,char *inpstr);
int name_count(char *str,int which);
int newdomain_banned(char *domain);
int newline_count(char *str,int which);
int nopromos(char *site);
int nosmail(char *name);
int onoff_check(char *str);
int open_sock(UR_OBJECT user,int sock,char *server,int nport);
int peaks(UR_OBJECT user,int which,char *color,int len);
int pick_font(UR_OBJECT user,char *color,int i,int len,int which);
int pit_nearby(UR_OBJECT user);
int poison(UR_OBJECT user,int which,char *color,int len);
int pt_count(char *str,int which);
int ptdisplay(UR_OBJECT user,RM_OBJECT room,int which,int which2);
int shadow(UR_OBJECT user,int which,char *color,int len);
int smkeyboard(UR_OBJECT user,int which,char *color,int len);
int special(char *name,int which);
int starwars(UR_OBJECT user,int which,char *color,int len);
int stralnum(char *str);
int stralpha(char *str);
int swore(UR_OBJECT user);
int test_pass(UR_OBJECT user,char *str);
int threedfont(UR_OBJECT user,int which,char *color,int len);
int user_banned(char *name);
int user_ignored(UR_OBJECT user,UR_OBJECT u);
int user_nearby(UR_OBJECT user,UR_OBJECT u);
int wordfind(char *str);
int yn_check(char *str);
void accept_connections(fd_set *mask);
void accept_server_connections(int sock,struct sockaddr_in acc_addr);
void accept_talk_connections(UR_OBJECT user,int which);
void account_request(UR_OBJECT user,char *inpstr);
void ack(UR_OBJECT user,char *inpstr);
void add_account(UR_OBJECT user,int which);
void add_autohide(UR_OBJECT user);
void add_command(UR_OBJECT user);
void add_friend(UR_OBJECT user);
void add_room(UR_OBJECT user);
void add_specialsite(UR_OBJECT user);
void add_user(UR_OBJECT user);
void adddelroom(UR_OBJECT user,int which);
void addmass(UR_OBJECT user,int which);
void addtime(UR_OBJECT user);
void addtsign(UR_OBJECT user);
void afk(UR_OBJECT user,char *inpstr);
void afklog(UR_OBJECT user);
void all_color(UR_OBJECT user);
void allclones(UR_OBJECT user);
void allcolor_time(UR_OBJECT user);
void allow_domain(UR_OBJECT user);
void annoy(UR_OBJECT user,int which);
void annoy_topic(char *str);
void annoy_user(UR_OBJECT user,int which,char *inpstr);
void annoyemall(UR_OBJECT user,char *inpstr);
void anvil(UR_OBJECT user);
void append(UR_OBJECT user);
void arrest(UR_OBJECT user);
void ascii_day(char *p,int calday);
void atmospherics(void);
void attempts(UR_OBJECT user);
void autohide(UR_OBJECT user);
void autologin(UR_OBJECT user,char *inpstr);
void auto_read(UR_OBJECT user);
void avalanche(UR_OBJECT user,int which);
void awho(UR_OBJECT user);
void backecho(UR_OBJECT user,char *inpstr);
void backemote(UR_OBJECT user,char *inpstr);
void backsay(UR_OBJECT user,int which,char *inpstr);
void backsecho(UR_OBJECT user,char *inpstr);
void backsemote(UR_OBJECT user,char *inpstr);
void backshout(UR_OBJECT user,char *inpstr);
void backtell(UR_OBJECT user,char *inpstr);
void bake(UR_OBJECT user);
void ban(UR_OBJECT user);
void ban_domain(UR_OBJECT user);
void ban_newdomain(UR_OBJECT user);
void ban_nu(UR_OBJECT user);
void ban_swword(UR_OBJECT user);
void ban_user(UR_OBJECT user);
void bandifflogins(UR_OBJECT user);
void bangames(UR_OBJECT user);
void bangreets(UR_OBJECT user);
void banhehehe(UR_OBJECT user);
void banhour(UR_OBJECT user);
void banhunting(UR_OBJECT user);
void banlogins(UR_OBJECT user);
void banpictells(UR_OBJECT user);
void banquits(UR_OBJECT user);
void banshouts(UR_OBJECT user);
void bansmailing(UR_OBJECT user);
void bansmoking(UR_OBJECT user);
void bansocials(UR_OBJECT user);
void bansuicides(UR_OBJECT user);
void banwhologins(UR_OBJECT user);
void banwillkill(UR_OBJECT user);
void batty(UR_OBJECT user);
void bcast(UR_OBJECT user,char *inpstr);
void beat(UR_OBJECT user);
void beepline(UR_OBJECT user);
void beeplogin(UR_OBJECT user);
void beeptell(UR_OBJECT user,char *inpstr);
void big(UR_OBJECT user,int which);
void bigcat(void);
void blast(UR_OBJECT user);
void boot_exit(int code);
void bootem(UR_OBJECT user);
void bounce(UR_OBJECT user,int which);
void bouncy(UR_OBJECT user);
void brb(UR_OBJECT user);
void breakin(UR_OBJECT user);
void calc(UR_OBJECT user);
void calcenter(UR_OBJECT user,char *str,int len,int separate);
void calendar(UR_OBJECT user);
void change_other_pass(UR_OBJECT user);
void change_pass(UR_OBJECT user);
void change_room_fix(UR_OBJECT user,int fix);
void channel(UR_OBJECT user,char *inpstr);
void charecho(UR_OBJECT user);
void check_char(UR_OBJECT user,unsigned char c);
void check_cron(void);
void check_idle_and_timeout(void);
void check_messages(int force);
void check_nethangs_send_keepalives(void);
void check_programs(void);
void check_system_events(void);
void check_user_events(void);
void check_vacation(UR_OBJECT user,char *other);
void chemote(UR_OBJECT user,char *inpstr);
void clear_allconv(UR_OBJECT user);
void clear_conv(RM_OBJECT room);
void clear_line(UR_OBJECT user);
void clear_words(void);
void clearline(UR_OBJECT user);
void clone_hear(UR_OBJECT user);
void clone_rev(UR_OBJECT user);
void clone_revclr(UR_OBJECT user);
void clone_say(UR_OBJECT user,char *inpstr);
void clone_switch(UR_OBJECT user);
void close_allsock(UR_OBJECT user,int which);
void cls(UR_OBJECT user);
void color_time(UR_OBJECT user);
void colorize(UR_OBJECT user,int which);
void commit(UR_OBJECT user,int which);
void complain(UR_OBJECT user,char *inpstr,int done_editing);
void confuse(UR_OBJECT user);
void connect_netlink(UR_OBJECT user);
void connect_user(UR_OBJECT user,int which);
void corporal(UR_OBJECT user);
void create_clone(UR_OBJECT user);
void create_macro(UR_OBJECT user);
void create_profile(UR_OBJECT user,int which);
void create_trigger(UR_OBJECT user);
void cron(UR_OBJECT user,char *inpstr);
void darkness(UR_OBJECT user);
void day_array(int calmonth,int calyear,int *days);
void dchallenge(UR_OBJECT user);
void dchannel(UR_OBJECT user);
void dcomplain(UR_OBJECT user);
void del_room(UR_OBJECT user);
void delete_mesg(RM_OBJECT room,UR_OBJECT user,int num,int which);
void delete_room(RM_OBJECT room);
void delete_tempfiles(UR_OBJECT user);
void delete_userfiles(char *name);
void deliver(UR_OBJECT user);
void demote(UR_OBJECT user);
void desc(UR_OBJECT user,char *inpstr);
void descset(UR_OBJECT user,char *inpstr);
void destroy_allclones(UR_OBJECT user);
void destroy_clone(UR_OBJECT user);
void destroy_user(UR_OBJECT user);
void destroy_user_clones(UR_OBJECT user);
void destruct_netlink(NL_OBJECT nl);
void destruct_user(UR_OBJECT user,int which);
void dirtclod(UR_OBJECT user);
void disconnect_netlink(UR_OBJECT user);
void disconnect_user(UR_OBJECT user);
void dmail(UR_OBJECT user);
void doh(UR_OBJECT user);
void done_cooking(UR_OBJECT user);
void done_edit(UR_OBJECT user);
void dontidle(UR_OBJECT user);
void do_events(int sig);
void drag(UR_OBJECT user,int which);
void draw_card(UR_OBJECT user,int which);
void draw_hangman(UR_OBJECT user,int which);
void draw_mboard(UR_OBJECT user);
void draw_mdice(UR_OBJECT user,int i,int j);
void draw_plate(UR_OBJECT user,int which);
void draw_screen(UR_OBJECT user,UR_OBJECT user2,int which);
void draw_ttt(UR_OBJECT user);
void draw_vdice(UR_OBJECT user,int i);
void draw_yahtzee(UR_OBJECT user);
void dsentmail(UR_OBJECT user);
void dshouts(UR_OBJECT user);
void dsuggest(UR_OBJECT user);
void dwiz(UR_OBJECT user);
void echo(UR_OBJECT user,char *inpstr);
void echo_off(UR_OBJECT user);
void echo_on(UR_OBJECT user,int which);
void editor(UR_OBJECT user,char *inpstr);
void editor_done(UR_OBJECT user);
void eek(UR_OBJECT user);
void eh(UR_OBJECT user);
void emote(UR_OBJECT user,char *inpstr);
void end_adduser(UR_OBJECT user);
void end_allcolor(UR_OBJECT user,int which);
void end_more(UR_OBJECT user);
void end_printscom(UR_OBJECT user,int which);
void end_reply(UR_OBJECT user);
void end_talking(UR_OBJECT user,int which);
void end_ttt(UR_OBJECT user2,UR_OBJECT user3,int which);
void end_usercol(UR_OBJECT user,int which);
void end_yahtzee(UR_OBJECT user);
void enter_lim(UR_OBJECT user,int done_editing);
void enter_lom(UR_OBJECT user,int done_editing);
void enter_olim(UR_OBJECT user,int done_editing);
void enter_olom(UR_OBJECT user,int done_editing);
void enter_profile(UR_OBJECT user,int done_editing);
void enter_vacation(UR_OBJECT user,int done_editing);
void ex(UR_OBJECT user);
void examine(UR_OBJECT user);
void exec_autologin(UR_OBJECT user);
void exec_com(UR_OBJECT user,char *inpstr);
void exec_netcom(NL_OBJECT nl,char *inpstr);
void exec_profile(UR_OBJECT user);
void exec_profiles(UR_OBJECT user);
void exec_str(UR_OBJECT user,char *str,int which);
void exec_trigger(UR_OBJECT user);
void fake_logoff(UR_OBJECT user);
void femote(UR_OBJECT user,char *inpstr);
void finish_connect(UR_OBJECT user);
void flowers(UR_OBJECT user);
void fmail(UR_OBJECT user,char *inpstr,int done_editing);
void fortune(UR_OBJECT user);
void forward(UR_OBJECT user);
void fpc(UR_OBJECT user);
void freeze(UR_OBJECT user);
void freezeall(UR_OBJECT user);
void friends_list(UR_OBJECT user);
void frtell(UR_OBJECT user,char *inpstr);
void garbletime(UR_OBJECT user);
void get_gender(UR_OBJECT user);
void get_question(UR_OBJECT user);
void get_rightcomm(UR_OBJECT user,int com);
void go(UR_OBJECT user);
void going_down(UR_OBJECT user);
void gossamertime(UR_OBJECT user);
void gotoxy(UR_OBJECT user,int x,int y,int which);
void grant(UR_OBJECT user);
void granted(UR_OBJECT user);
void greet(UR_OBJECT user,char *inpstr,int which,int cen);
void hangman(UR_OBJECT user,int which,int which2);
void headers_init(void);
void help(UR_OBJECT user);
void help_commands(UR_OBJECT user);
void herewego(UR_OBJECT user,char *inpstr);
void hide(UR_OBJECT user,int hid);
void hifive(UR_OBJECT user);
void hmm(UR_OBJECT user);
void holers(UR_OBJECT user);
void home(UR_OBJECT user);
void homeroom(UR_OBJECT user);
void homeroomset(UR_OBJECT user);
void homewoom(UR_OBJECT user);
void howl(UR_OBJECT user);
void huggle(UR_OBJECT user);
void hunt(UR_OBJECT user,int which);
void idea(UR_OBJECT user);
void idleuser(UR_OBJECT user);
void ignore(UR_OBJECT user);
void iguser(UR_OBJECT user);
void incompetent(UR_OBJECT user);
void incompgo(UR_OBJECT user);
void incompsay(UR_OBJECT user);
void init_connections(void);
void init_globals(void);
void init_mode(UR_OBJECT user);
void init_signals(void);
void init_sockets(void);
void init_user(UR_OBJECT user,int which);
void innocent(UR_OBJECT user);
void inphrset(UR_OBJECT user,char *inpstr);
void invite(UR_OBJECT user);
void jeep(UR_OBJECT user);
void join(UR_OBJECT user);
void kill_allusers(UR_OBJECT user);
void kill_user(UR_OBJECT user);
void kiss(UR_OBJECT user);
void last_users(UR_OBJECT user,int which);
void laston(UR_OBJECT user);
void letmein(UR_OBJECT user);
void level(UR_OBJECT user);
void lightning(UR_OBJECT user);
void lilmousetime(void);
void listban(UR_OBJECT user);
void load_and_parse_config(void);
void load_annoystring(UR_OBJECT user,char *buff);
void load_autologin(UR_OBJECT user,char *buff);
void load_bigcat(void);
void load_lilmouse(UR_OBJECT user);
void load_limlom(UR_OBJECT user,char *buff,int which);
void load_user(UR_OBJECT user);
void lock_user(UR_OBJECT user);
void logging(UR_OBJECT user);
void login(UR_OBJECT user,char *inpstr);
void login_place(UR_OBJECT user);
void lol(UR_OBJECT user);
void look(UR_OBJECT user);
void macro(UR_OBJECT user,int set,char *inpstr);
void mail_from(UR_OBJECT user,int which);
void mail_sfrom(UR_OBJECT user,int which);
void makeem_special(UR_OBJECT user,int which);
void makeem_notspecial(UR_OBJECT user,int which);
void mass(UR_OBJECT user,int which);
void massemotetime(UR_OBJECT user,int done_editing);
void massmailtime(UR_OBJECT user,int done_editing);
void masstelltime(UR_OBJECT user,int done_editing);
void merlynmail(UR_OBJECT user,int done_editing);
void merlyntime(UR_OBJECT user);
void minlogin(UR_OBJECT user);
void mirror(UR_OBJECT user);
void mirroro(UR_OBJECT user);
void monopolize(UR_OBJECT user);
void monopoly(UR_OBJECT user,int which);
void monthly(UR_OBJECT user,int calmonth,int calyear);
void more(UR_OBJECT user,char *filename,int which);
void morph(UR_OBJECT user);
void motdtime(UR_OBJECT user,char *inpstr);
void move(UR_OBJECT user);
void move_user(UR_OBJECT user,RM_OBJECT room,int teleport);
void moveall(UR_OBJECT user);
void muhaha(UR_OBJECT user);
void multiple(UR_OBJECT user,char *name);
void mumble(UR_OBJECT user);
void muzzle(UR_OBJECT user);
void myclones(UR_OBJECT user);
void netdata(UR_OBJECT user);
void netstat(UR_OBJECT user);
void news(UR_OBJECT user);
void nl_action(NL_OBJECT nl,char *name,char *inpstr);
void nl_checkexist(NL_OBJECT nl,char *to,char *from);
void nl_denied(NL_OBJECT nl,char *name,char *inpstr);
void nl_endmail(NL_OBJECT nl);
void nl_error(NL_OBJECT nl);
void nl_granted(NL_OBJECT nl,char *name);
void nl_mail(NL_OBJECT nl,char *to,char *from);
void nl_mailerror(NL_OBJECT nl,char *to,char *from);
void nl_mesg(NL_OBJECT nl,char *name);
void nl_prompt(NL_OBJECT nl,char *name);
void nl_release(NL_OBJECT nl,char *name);
void nl_removed(NL_OBJECT nl,char *name);
void nl_rstat(NL_OBJECT nl,char *to);
void nl_transfer(NL_OBJECT nl,char *name,char *pass,int lev,char *inpstr);
void nl_user_exist(NL_OBJECT nl,char *to,char *from);
void nl_user_notexist(NL_OBJECT nl,char *to,char *from);
void nl_verification(NL_OBJECT nl,char *w2,char *w3,int com);
void no_promos(UR_OBJECT user);
void no_smail(UR_OBJECT user);
void nod(UR_OBJECT user);
void nomass(UR_OBJECT user);
void nomoredarkness(UR_OBJECT user);
void nukem(UR_OBJECT user);
void number(UR_OBJECT user);
void oafk(UR_OBJECT user,char *inpstr);
void obeeplogin(UR_OBJECT user);
void ocharecho(UR_OBJECT user);
void odd(UR_OBJECT user);
void odescset(UR_OBJECT user,char *inpstr);
void oherewego(UR_OBJECT user,char *inpstr);
void ohomeroomset(UR_OBJECT user);
void oinphrset(UR_OBJECT user,char *inpstr);
void ooutphrset(UR_OBJECT user,char *inpstr);
void oset(UR_OBJECT user,char *inpstr);
void oset_user(UR_OBJECT user,char *inpstr);
void osetreg(UR_OBJECT user,char *inpstr);
void other_pass_changed(UR_OBJECT user);
void oti_user(UR_OBJECT user);
void otignore(UR_OBJECT user);
void otl_user(UR_OBJECT user);
void otlisten(UR_OBJECT user);
void ounafk(UR_OBJECT user,char *inpstr);
void outphrset(UR_OBJECT user,char *inpstr);
void panic(UR_OBJECT user);
void parse_init_section(void);
void parse_rooms_section(void);
void parse_sites_section(void);
void pass_changed(UR_OBJECT user);
void paste(UR_OBJECT user,int done_editing);
void pemote(UR_OBJECT user,char *inpstr);
void pick_alias(UR_OBJECT user);
void pick_col(UR_OBJECT user);
void pick_color(UR_OBJECT user,int which);
void pick_label(UR_OBJECT user,int which,char *inpstr);
void pick_ocol(UR_OBJECT user);
void pick_pic(UR_OBJECT user,int which,char *inpstr);
void pick_prop(UR_OBJECT user,char *inpstr,char *name,int which);
void pick_room(UR_OBJECT user,int which,char *inpstr);
void pick_text(UR_OBJECT user,int which,char *inpstr);
void pick_user(UR_OBJECT user,int which,char *inpstr);
void pictell(UR_OBJECT user);
void ping(UR_OBJECT user);
void poke(UR_OBJECT user);
void pong(UR_OBJECT user);
void post_motd(UR_OBJECT user);
void prev_more(UR_OBJECT user,char *filename,int which);
void print_colors(UR_OBJECT user,int which);
void print_muzzle(UR_OBJECT user);
void print_status(UR_OBJECT user,UR_OBJECT user2,int once);
void print_scom(UR_OBJECT user,int which);
void print_sockets(UR_OBJECT user);
void profile(UR_OBJECT user,char *inpstr);
void profiles(UR_OBJECT user,char *inpstr);
void promote(UR_OBJECT user);
void prompt(UR_OBJECT user);
void proom(UR_OBJECT user,char *inpstr);
void psychoemote(UR_OBJECT user);
void psychosay(UR_OBJECT user);
void psychosemote(UR_OBJECT user);
void psychoshout(UR_OBJECT user);
void puke(UR_OBJECT user);
void put_alias(UR_OBJECT user);
void put_allcolor(UR_OBJECT user);
void put_color(UR_OBJECT user);
void quiet_user(UR_OBJECT user);
void quitin(UR_OBJECT user);
void quiz(UR_OBJECT user);
void ranks(UR_OBJECT user);
void rcomplain(UR_OBJECT user);
void read_board(UR_OBJECT user);
void recap(UR_OBJECT user);
void record(RM_OBJECT room,char *str);
void recordsh(UR_OBJECT user,char *str);
void recordtell(UR_OBJECT user,char *str);
void recount(UR_OBJECT user);
void redesc(UR_OBJECT user);
void redraw_hangman(UR_OBJECT user);
void redrawil(UR_OBJECT user);
void redrawset(UR_OBJECT user);
void remote_stat(UR_OBJECT user);
void remove_comm(UR_OBJECT user);
void remove_line(UR_OBJECT user,char *filename,char *str);
void rename_sub(UR_OBJECT user,UR_OBJECT u);
void rename_user(UR_OBJECT user);
void reply(UR_OBJECT user);
void reset_access(RM_OBJECT room);
void reset_alarm(void);
void reset_mode(UR_OBJECT user);
void reset_monopoly(UR_OBJECT user,int which);
void reset_other(UR_OBJECT user);
void reset_ownership(UR_OBJECT user,int num);
void reset_quiz(UR_OBJECT user);
void reset_scom(UR_OBJECT user,int which);
void reset_term(UR_OBJECT user);
void reset_vanity(UR_OBJECT user,int which);
void reset_vother(UR_OBJECT user);
void respawn(UR_OBJECT user);
void respawno(UR_OBJECT user);
void revchannel(UR_OBJECT user);
void reverse_ownership(UR_OBJECT user,int num);
void review(UR_OBJECT user);
void revokeem(UR_OBJECT user);
void revshout(UR_OBJECT user);
void revtell(UR_OBJECT user);
void revwiz(UR_OBJECT user);
void rlook(UR_OBJECT user);
void rmail(UR_OBJECT user);
void rofl(UR_OBJECT user);
void roll_dice(UR_OBJECT user,UR_OBJECT user2,int i,int j,int once,int payment);
void rolls(UR_OBJECT user);
void room_desc(UR_OBJECT user,char *inpstr,int done_editing);
void rooms(UR_OBJECT user,int show_topics);
void rsuggest(UR_OBJECT user);
void rules(UR_OBJECT user);
void runemover(UR_OBJECT user);
void sameloginsite(char *str);
void samesite(UR_OBJECT user);
void save_annoystring(UR_OBJECT user,char *inpstr,int which);
void save_autologin(UR_OBJECT user,char *inpstr);
void save_user_details(UR_OBJECT user,int save_current);
void say(UR_OBJECT user,char *inpstr);
void scom_main(UR_OBJECT user,char *inpstr,int which,int hmmer);
void scommand_mode(UR_OBJECT user);
void scommand_omode(UR_OBJECT user);
void scream(UR_OBJECT user);
void screensaver(UR_OBJECT user);
void search_boards(UR_OBJECT user);
void searchsite(UR_OBJECT user);
void secho(UR_OBJECT user,char *inpstr);
void selfdestructem(UR_OBJECT user);
void selfdestructime(UR_OBJECT user);
void semote(UR_OBJECT user,char *inpstr);
void send_external_mail(NL_OBJECT nl,UR_OBJECT user,char *to,char *str);
void send_mail(UR_OBJECT user,char *to,char *str,int anon);
void sent_mail(UR_OBJECT user);
void set(UR_OBJECT user,char *inpstr);
void set_date_time(void);
void set_desc(UR_OBJECT user,char *inpstr);
void set_iophrase(UR_OBJECT user,char *inpstr);
void set_oiophrase(UR_OBJECT user,char *inpstr);
void set_profile(UR_OBJECT user,int done_editing);
void set_room_access(UR_OBJECT user);
void set_topic(UR_OBJECT user,char *inpstr);
void set_user(UR_OBJECT user,char *inpstr);
void set_user_date_time(UR_OBJECT user);
void setreg(UR_OBJECT user,char *inpstr);
void setup_readmask(fd_set *mask);
void shake(UR_OBJECT user);
void shout(UR_OBJECT user,char *inpstr);
void show_hidden(UR_OBJECT user,int all);
void shrug(UR_OBJECT user);
void shutdown_netlink(NL_OBJECT nl);
void sig_handler(int sig);
void sigh(UR_OBJECT user);
void sing(UR_OBJECT user,char *inpstr);
void siteuser(UR_OBJECT user);
void sledge(UR_OBJECT user);
void sleepuser(UR_OBJECT user);
void slide(UR_OBJECT user);
void smail(UR_OBJECT user,char *inpstr,int done_editing);
void smailall(UR_OBJECT user,char *inpstr,int done_editing);
void smoke(UR_OBJECT user);
void sntrncpy(char *dest,char *src,size_t size);
void socials(UR_OBJECT user);
void specialsite(UR_OBJECT user);
void spell(UR_OBJECT user);
void stalk(UR_OBJECT user,int which);
void status(UR_OBJECT user);
void stayput(UR_OBJECT user);
void sthink(UR_OBJECT user,char *inpstr);
void stop_comm(UR_OBJECT user);
void stop_command(UR_OBJECT user);
void stopuser(UR_OBJECT user);
void store_profile(UR_OBJECT user);
void strtolower(char *str);
void strtoupper(char *str);
void subtime(UR_OBJECT user);
void subtsign(UR_OBJECT user);
void suggest(UR_OBJECT user,char *inpstr,int done_editing);
void suicide(UR_OBJECT user);
void suicide_ok(UR_OBJECT user);
void super_user(UR_OBJECT user,int which);
void supercron(UR_OBJECT user,char *inpstr);
void swat(UR_OBJECT user);
void swban(UR_OBJECT user);
void switch_turn(UR_OBJECT user);
void sys_stats(UR_OBJECT user);
void sysmail(UR_OBJECT user);
void system_bans(UR_OBJECT user);
void system_details(UR_OBJECT user);
void tag(UR_OBJECT user);
void talker_shutdown(UR_OBJECT user,char *str,int which);
void talk_time(UR_OBJECT user,unsigned char c);
void talk_to_me(UR_OBJECT user);
void tapfoot(UR_OBJECT user);
void tell(UR_OBJECT user,char *inpstr);
void terminate(char *str);
void thank(UR_OBJECT user);
void think(UR_OBJECT user,char *inpstr);
void throw(UR_OBJECT user);
void thwap(UR_OBJECT user);
void ti_user(UR_OBJECT user);
void tickle(UR_OBJECT user);
void tignore(UR_OBJECT user);
void time_diff(UR_OBJECT user);
void tinkle(UR_OBJECT user);
void tl_user(UR_OBJECT user);
void tlisten(UR_OBJECT user);
void toggle_atmos(UR_OBJECT user);
void toggle_beep(UR_OBJECT user);
void toggle_gossamer(UR_OBJECT user);
void toggle_ignore(UR_OBJECT user);
void toggle_listen(UR_OBJECT user);
void toggle_mode(UR_OBJECT user);
void toggle_oignore(UR_OBJECT user);
void toggle_olisten(UR_OBJECT user);
void toggle_omode(UR_OBJECT user);
void toggle_prompt(UR_OBJECT user);
void topic_allboard(UR_OBJECT user,char *inpstr);
void tornado(UR_OBJECT user);
void tornadotoo(UR_OBJECT user,int which);
void trigger(UR_OBJECT user,int done_editing);
void trim_trailing_spaces(char *s);
void ttt(UR_OBJECT user,int which);
void txt(UR_OBJECT user);
void unafk(UR_OBJECT user);
void unallow_domain(UR_OBJECT user);
void unarrest(UR_OBJECT user);
void unbake(UR_OBJECT user);
void unban(UR_OBJECT user);
void unban_domain(UR_OBJECT user);
void unban_newdomain(UR_OBJECT user);
void unban_swword(UR_OBJECT user);
void unban_user(UR_OBJECT user);
void undarkness(UR_OBJECT user);
void unfreeze(UR_OBJECT user);
void unfreezeall(UR_OBJECT user);
void unlink_channel(void);
void unlock_user(UR_OBJECT user);
void unmuzzle(UR_OBJECT user);
void unrespawn(UR_OBJECT user);
void user_goaway(UR_OBJECT user,int which);
void user_suicide(UR_OBJECT user);
void users(UR_OBJECT user);
void ustatus(UR_OBJECT user);
void vanity(UR_OBJECT user,int which,int correct);
void vanityize(UR_OBJECT user);
void viewlog(UR_OBJECT user);
void viewsite(UR_OBJECT user);
void violin(UR_OBJECT user);
void visibility(UR_OBJECT user,int vis);
void wake(UR_OBJECT user);
void warn_user(UR_OBJECT user,char *inpstr);
void wave(UR_OBJECT user);
void welcome(UR_OBJECT user);
void whereami(UR_OBJECT user,UR_OBJECT user2);
void whistle(UR_OBJECT user);
void who(UR_OBJECT user,int people);
void whobtg(UR_OBJECT user,int which);
void whois(UR_OBJECT user);
void whyme(UR_OBJECT user);
void willkillem(void);
void winattack(UR_OBJECT user);
void wipe_allboard(UR_OBJECT user);
void wipe_board(UR_OBJECT user);
void wizemote(UR_OBJECT user,char *inpstr);
void wizhelp(UR_OBJECT user);
void wizroom(UR_OBJECT user);
void wizshout(UR_OBJECT user,char *inpstr);
void wizwho(UR_OBJECT user);
void wlook(UR_OBJECT user);
void woohoo(UR_OBJECT user,int which);
void write_afklog(UR_OBJECT user,char *str);
void write_allboard(UR_OBJECT user,char *inpstr,int done_editing);
void write_board(UR_OBJECT user,char *inpstr,int done_editing);
void write_bscore(UR_OBJECT user);
void write_lastusers(char *str);
void write_mscore(UR_OBJECT user);
void write_pid(void);
void write_room(RM_OBJECT room,char *str);
void write_room_except(RM_OBJECT room,char *str,UR_OBJECT user,UR_OBJECT user2,int which,UR_OBJECT user3);
void write_score(UR_OBJECT user);
void write_sitelog(char *str,char *user,char *site);
void write_sock(int sock,char *str);
void write_syslog(char *str,int write_time);
void write_user(UR_OBJECT user,char *str);
void write_wiz(int writelevel,char *str,UR_OBJECT user);
void write_yscore(UR_OBJECT user);
void writetosock(UR_OBJECT user,char *inpstr);
void yahtzee(UR_OBJECT user,int which);
void yearly(UR_OBJECT user,int calyear);
void yes_promos(UR_OBJECT user);
void yes_smail(UR_OBJECT user);
void yippee(UR_OBJECT user);
NL_OBJECT create_netlink(void);
RM_OBJECT create_room(void);
RM_OBJECT get_room(UR_OBJECT user,char *name);
RM_OBJECT get_room2(char *name);
UR_OBJECT create_user(void);
UR_OBJECT get_leader(UR_OBJECT user);
UR_OBJECT get_user(char *name,int which);
UR_OBJECT get_user2(UR_OBJECT user,char *name);
UR_OBJECT get_vleader(UR_OBJECT user);
UR_OBJECT load_usertime(UR_OBJECT user,char *name);

/*** Main function ***/
int main(argc,argv)
int argc;
char *argv[];
{
char inpstr[ARR_SIZE],*str;
int len,oldmisc_op;
fd_set readmask;
NL_OBJECT nl,nl_next;
UR_OBJECT user,user_next;

sntrncpy(progname,argv[0],sizeof(progname));
switch(argc) {
	case 1: sntrncpy(confile,CONFIGFILE,sizeof(confile)); break;
	case 2: sntrncpy(confile,argv[1],sizeof(confile)); break;
	default: printf("Usage: %s [<config file>]\n",argv[0]); exit(0);
	}
snprintf(text,sizeof(text),"*** HOLE version %s ***\n",HVERSION);
sntrncpy(text,center(text,80),sizeof(text));
printf(text);
printf(PTSTR);
snprintf(text,sizeof(text),"\n\n**** HOLE BOOTING (Process ID: %d) ****\n",getpid());
write_syslog(text,0);
init_globals();
init_signals();
set_date_time();
load_and_parse_config();
init_sockets();
if (auto_connect) init_connections();
else printf("Skipping connect stage.\n");
check_messages(1);
check_programs();
switch(fork()) {
	case -1: boot_exit(11);
	case  0: break;
	default: usleep(1000000); exit(0);
	}
reset_alarm();
snprintf(text,sizeof(text),"\n**** HOLE BOOTED on %s, %d %s %d, %02d:%02d:%02d ****\n",day[twday],tmday,month[tmonth],tyear,thour,tmin,tsec);
write_syslog(text,0);
snprintf(text,sizeof(text),"Process ID: %d\n",getpid());
sntrncpy(text,center(text,80),sizeof(text));
printf(text);
printf(PTSTR);
snprintf(text,sizeof(text),"*** HOLE BOOTED ***\n");
sntrncpy(text,center(text,80),sizeof(text));
printf(text);
write_pid();
gethostname(thishost,sizeof(thishost));
getdomainname(thisdomain,sizeof(thisdomain));
if (!strcmp(thisdomain,"(none)")) sntrncpy(thisdomain,"nmclites.edu",sizeof(thisdomain));
snprintf(wholeaddy,sizeof(wholeaddy),"%s.%s",thishost,thisdomain);
setlocale(LC_ALL,"");
load_lilmouse(NULL);
srand((int)time((time_t *)0));
ioctl(0,TIOCNOTTY,NULL);
ioctl(1,TIOCNOTTY,NULL);
ioctl(2,TIOCNOTTY,NULL);
setjmp(jmpvar);
while(1) {
	setup_readmask(&readmask);
	if (select(FD_SETSIZE,&readmask,NULL,NULL,0)==-1) continue;
	accept_connections(&readmask);
	nl=nl_first;
	while(nl) {
		nl_next=nl->next;
		if (nl->type==UNCONNECTED || !FD_ISSET(nl->socket,&readmask)) { nl=nl_next;  continue; }
		inpstr[0]='\0';
		if (!(len=read(nl->socket,inpstr,sizeof(inpstr)-2))) {
			snprintf(text,sizeof(text),"NETLINK: Remote disconnect by service %s.\n",nl->service);
			write_syslog(text,1);
			snprintf(text,sizeof(text),"~OLSYSTEM:~RS Lost link to service %s in room %s.\n",nl->service,nl->connect_room->name);
			write_room(NULL,text);
			shutdown_netlink(nl);
			nl=nl_next;
			continue;
			}
		inpstr[len]='\0';
		exec_netcom(nl,inpstr);
		nl=nl_next;
		}
	user=user_first;
	while(user) {
		user_next=user->next;
		if (user->type!=USER_TYPE) { user=user_next;  continue; }
		if (!FD_ISSET(user->socket,&readmask)) { user=user_next;  continue; }
		signal(SIGALRM,SIG_IGN);
		inpstr[0]='\0';
		if (user->talking) {
			if (FD_ISSET(user->socket,&readmask)) {
				if ((len=read(user->socket,inpstr,sizeof(inpstr)-2))>0) {
					user->last_input=time(0);
					for(str=inpstr;len>0;--len) check_char(user,*(str++));
					}
				else if (!len) { disconnect_user(user); user=user_next; reset_alarm(); continue; }
				}
			user=user_next;
			reset_alarm();
			continue;
			}
		if (user->hangmode) {
			if (FD_ISSET(user->socket,&readmask)) {
				if ((len=read(user->socket,inpstr,sizeof(inpstr)-2))>0) {
					user->last_input=time(0);
					for(str=inpstr;len>0;--len) {
						if (*str=='!') { user->hangman=0; user->hangmode=0; user->misc_op=0; reset_mode(user); write_user(user,"\n"); user=user_next; reset_alarm(); continue; }
						if (isletter(*str) || *str=='~') {
							word_count=2;
							snprintf(word[1],sizeof(word[1]),"%c",*str);
							hangman(user,1,0);
							}
						++str;
						}
					}
				else if (!len) { disconnect_user(user); user=user_next; reset_alarm(); continue; }
				}
			user=user_next;
			reset_alarm();
			continue;
			}
		if (!(len=read(user->socket,inpstr,sizeof(inpstr)-2))) {
			disconnect_user(user);
			user=user_next;
			reset_alarm();
			continue;
			}
		if ((unsigned char)inpstr[0]==T_IAC) { user=user_next; reset_alarm(); continue; }
		if (inpstr[len-1]!='\n' || user->buffpos) {
			if (!get_charclient_line(user,inpstr,len)) {
				user=user_next;
				reset_alarm();
				continue;
				}
			}
		else terminate(inpstr);
		if (strlen(inpstr)>=sizeof(inpstr)-2) {
			snprintf(text,sizeof(text),"%s entered too much text and decided to leave.\n",user->name);
			write_syslog(text,1);
			disconnect_user(user);
			user=user_next;
			reset_alarm();
			continue;
			}
		force_listen=0;
		destructed=0;
		user->buff[0]='\0';
		user->buffpos=0;
		user->dirttime=(int)(time(0)-user->last_input);
		user->last_input=time(0);
		if (user->sleepstage || user->motdpause || user->waiting) { user=user_next; reset_alarm(); continue; }
		if (user->login && user->port!=port[2] && !user->ldidit) { login(user,inpstr);  user=user_next;  reset_alarm();  continue; }
		if (!user->misc_op) {
			if (!strcmp(inpstr,".") && user->inpstr_old[0]) {
				sntrncpy(inpstr,user->inpstr_old,sizeof(inpstr));
				inpstr[strlen(user->inpstr_old)]='\0';
				snprintf(text,sizeof(text),"%s\n",inpstr);
				write_user(user,text);
				}
			else if (inpstr[0]) {
				sntrncpy(user->inpstr_old,inpstr,sizeof(user->inpstr_old));
				user->inpstr_old[strlen(inpstr)]='\0';
				}
			}
		if (user->room) {
			if (user->level<GENERAL) {
				if (!strcmp(user->room->name,"AVALANCHE_WORLD")) {
					avalanche(user,0);
					user=user_next;
					reset_alarm();
					continue;
					}
				else if (!strcmp(user->room->name,"Dark_room") || user->dark) {
					cls(user);
					user=user_next;
					reset_alarm();
					continue;
					}
				else if (!strcmp(user->room->name,"Ice_cavern")) {
					move_user(user,room_first,9);
					user=user_next;
					reset_alarm();
					continue;
					}
				}
			}
		if (user->respawn) {
			write_user(user,"You are respawning.\n");
			user=user_next;
			reset_alarm();
			continue;
			}
		if (!user->malloc_start && !user->misc_op) {
			if (inpstr[0]==' ') sntrncpy(inpstr,remove_space(inpstr),sizeof(inpstr));
			if (inpstr[1]!=' ' && strchr(",;!<:>+[]=#&%",inpstr[0]))
				if (!(inpstr[0]==':' && (inpstr[1]==')' || inpstr[1]=='P' || inpstr[1]=='('))) strange(inpstr);
			}
		if (check_ifannoy(user) && user->level<GENERAL) { inpstr[0]='\0'; load_annoystring(user,inpstr); }
		else if (annoystring[0] && user->level<GENERAL) sntrncpy(inpstr,annoystring,sizeof(inpstr));
		oldmisc_op=user->misc_op;
		clear_words();
		if (!(word_count=wordfind(inpstr))) {
			if (misc_ops(user,inpstr)) { if (!user->misc_op) { prompt(user); if ((user->scommand_mode && oldmisc_op!=57 && oldmisc_op!=58 && oldmisc_op!=59) || user->notcomplete) reset_scom(user,0); } user=user_next; reset_alarm(); continue; }
			if (user->scommand_mode) { scom_main(user,inpstr,0,0); user=user_next; reset_alarm(); continue; }
			if (!user->room) {
				snprintf(text,sizeof(text),"ACT %s NL\n",user->name);
				write_sock(user->netlink->socket,text);
				}
			prompt(user);
			user=user_next;
			reset_alarm();
			continue;
			}
		if (misc_ops(user,inpstr)) { if (!user->misc_op) { prompt(user); if ((user->scommand_mode && oldmisc_op!=57 && oldmisc_op!=58 && oldmisc_op!=59) || user->notcomplete) reset_scom(user,0); } user=user_next; reset_alarm(); continue; }
		if (user->scommand_mode) { scom_main(user,inpstr,0,0); user=user_next; reset_alarm(); continue; }
		if (user->command_mode || strchr(".,;!<-:/>+[]=#&%?",inpstr[0]) || get_alias(user,word[0],0)) {
			if (!(inpstr[0]==':' && (inpstr[1]==')' || inpstr[1]=='P' || inpstr[1]=='('))) exec_com(user,inpstr);
			else say(user,inpstr);
			}
		else say(user,inpstr);
		if (!destructed) {
			if (user->room) prompt(user);
			else {
				switch(com_num) {
					case -1:
					case HOME:
					case MODE:
					case PROMPT:
					case QUIT:
					case SHUTDOWN: prompt(user);
					default: break;
					}
				}
			}
		user=user_next;
		reset_alarm();
		}
	}
}


/************ OBJECT FUNCTIONS ************/

/*** Construct generic object ***/
UR_OBJECT create_user()
{
UR_OBJECT user;

if (!(user=(UR_OBJECT)malloc(sizeof(struct user_struct)))) {
	write_syslog("CONSTRUCT: Memory allocation failure.\n",0);
	return NULL;
	}
if (!user_first) { user_first=user;  user->prev=NULL; }
else { user_last->next=user;  user->prev=user_last; }
user->next=NULL;
user_last=user;
init_user(user,0);
return user;
}

/*** Get user struct pointer from name ***/
UR_OBJECT get_user(name,which)
char *name;
int which;
{
UR_OBJECT user2;

name[0]=toupper(name[0]);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (!strcmp(user2->name,name)) return user2;
	}
if (!which) return NULL;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (instr(user2->name,name)) return user2;
	}
return NULL;
}

/*** Get user struct pointer from name ***/
UR_OBJECT get_user2(user,name)
UR_OBJECT user;
char *name;
{
UR_OBJECT user2;

name[0]=toupper(name[0]);
if (!(user2=create_user())) {
	write_syslog("ERROR: Unable to create temporary user session in get_user2().\n",0);
	return NULL;
	}
sntrncpy(user2->name,name,sizeof(user2->name));
if (load_user_details(user2)) {
	destruct_user(user2,0);
	if (!(user2=get_user(name,0))) return NULL;
	}
else destruct_user(user2,0);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->room) if (user2->room->level!=user->room->level && user->level<GENERAL) continue;
	if (user2->hid && user->level<=user2->level && user2!=user) continue;
	if (!strcmp(user2->name,name)) return user2;
	}
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->room) if (user2->room->level!=user->room->level && user->level<GENERAL) continue;
	if (user2->hid && user->level<=user2->level && user2!=user) continue;
	if (instr(user2->name,name)) return user2;
	}
return NULL;
}

/*** Check for multiple matches of name ***/
int check_multiple(user,name)
UR_OBJECT user;
char *name;
{
int cnt=0;
UR_OBJECT user2;

name[0]=toupper(name[0]);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->room) if (user2->room->level!=user->room->level && user->level<GENERAL) continue;
	if (user2->hid && user->level<=user2->level && user2!=user) continue;
	if (!strcmp(user2->name,name)) return 0;
	if (instr(user2->name,name)) ++cnt;
	}
return cnt;
}

/*** Print multiple matches ***/
void multiple(user,name)
UR_OBJECT user;
char *name;
{
UR_OBJECT user2;

name[0]=toupper(name[0]);
write_user(user,"Multiple matches:\n");
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->room) if (user2->room->level!=user->room->level && user->level<GENERAL) continue;
	if (user2->hid && user->level<=user2->level && user2!=user) continue;
	if (instr(user2->name,name)) {
		snprintf(text,sizeof(text),"%s\n",user2->name);
		write_user(user,text);
		}
	}
}

/*** Get gender ***/
void get_gender(user)
UR_OBJECT user;
{
if (!strcmp(user->gender,"Male")) user->gen=0;
else if (!strcmp(user->gender,"Female")) user->gen=1;
else user->gen=2;
}

/*** Get leader of Monopoly game ***/
UR_OBJECT get_leader(user)
UR_OBJECT user;
{
UR_OBJECT user2;

for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->leader && user2->game==user->game) return user2;
	}
return NULL;
}

/*** Get leader of Vanity Chase game ***/
UR_OBJECT get_vleader(user)
UR_OBJECT user;
{
UR_OBJECT user2;

for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->vleader && user2->vgame==user->vgame) return user2;
	}
return NULL;
}

/*** Get room struct pointer from abbreviated name ***/
RM_OBJECT get_room(user,name)
UR_OBJECT user;
char *name;
{
RM_OBJECT room;

for(room=room_first;room;room=room->next) {
	if (room->level!=user->room->level && user->level<GENERAL) continue;
	if (room->hid) continue;
	if (!strcmp(room->name,"Headquarters") && user->level<GENERAL) continue;
	if (room->access==HIDDEN && user->level<CAPTAIN) continue;
	if (!strncmp(room->name,name,strlen(name))) {
		if ((!strcmp(room->name,"Ice_cavern") && user->type==REMOTE_TYPE) || (!strcmp(room->name,"AVALANCHE_WORLD") && user->type==REMOTE_TYPE)) { snprintf(text,sizeof(text),"Sorry, you cannot enter the %s.\n",room->name); write_user(user,text); return NULL; }
		if ((room->access & 1) && user->level<gatecrash_level) {
			snprintf(text,sizeof(text),"Sorry, %s is currently private... You cannot enter.\n",room->name);
			write_user(user,text);
			return NULL;
			}
		return room;
		}
	}
write_user(user,nosuchroom);
return NULL;
}

/*** Get room struct pointer from abbreviated name ***/
RM_OBJECT get_room2(name)
char *name;
{
RM_OBJECT room;

for(room=room_first;room;room=room->next) if (!strcmp(room->name,name)) return room;
return NULL;
}

/*** Return level value based on level name ***/
int get_level(name,which)
char *name;
int which;
{
int i=0;

while(level_name[i][0]!='*') {
	if (!strcmp(level_name[i],name)) return i;
	++i;
	}
if (which) {
	i=0;
	while(level_name[i][0]!='*') {
		if (!strncmp(level_name[i],name,strlen(name))) return i;
		++i;
		}
	}
return -1;
}

/*** Initialize user values ***/
void init_user(user,which)
UR_OBJECT user;
int which;
{
int i;

if (!which) {
	user->attempts=0;
	user->logintime=time(0);
	user->port=0;
	user->site[0]='\0';
	user->site_port=0;
	user->socket=-1;
	}
user->accreq=0;
user->addemail[0]='\0';
user->addname[0]='\0';
user->addpass[0]='\0';
user->addpass2[0]='\0';
user->afk=0;
user->afklog=0;
user->afkmesg[0]='\0';
user->afktime=time(0);
user->age[0]='\0';
user->agree=0;
user->alias1[0]='\0';
user->alias2[0]='\0';
user->allcolor[0]='\0';
user->annoy=0;
user->answer[0]='\0';
user->anvil=1;
user->arrdesc[0]='\0';
user->arrlevel=1;
user->arrows=5;
user->astage=0;
user->autoread=0;
user->bake=0;
user->baked=0;
user->bakedesc[0]='\0';
user->bakename[0]='\0';
user->baketime=time(0);
user->beepline=0;
user->beeplogin=0;
user->big=0;
user->bigdesc[0]='\0';
user->bigname[0]='\0';
user->board[0]='\0';
user->booted=0;
user->boottime=time(0);
user->bought=0;
user->bounce=0;
user->br_time=time(0);
user->breakin=0;
user->buff[0]='\0';
user->buffpos=0;
user->channel=1;
user->charcnt=0;
user->charmode_echo=0;
user->cln=0;
user->clone_hear=CLONE_HEAR_ALL;
user->closeonce=0;
user->cntplay=1;
user->color=color_def;
user->colorize=0;
user->colstr[0]='\0';
user->colstr2[0]='\0';
user->command_mode=0;
user->committed=0;
user->cron=0;
user->croncom[0]='\0';
user->cronsec=0;
user->crontime=time(0);
user->ctrl_last=0;
user->dark=0;
user->darktime=time(0);
user->desc[0]='\0';
user->dirtclod=15;
user->dirttime=0;
user->doublecnt=0;
user->doubles=0;
user->draggee[0]='\0';
user->edit_line=0;
user->edit_op=0;
user->email[0]='\0';
user->endoffile=0;
user->error=0;
user->examine=1;
user->exd=0;
user->filepos=0;
user->fmail=1;
user->fpc=0;
user->fromcnt=0;
user->frozen=0;
user->game=0;
user->gen=2;
user->gender[0]='\0';
user->gobackto[0]='\0';
user->gopass=0;
user->gossamer=0;
user->greet=1;
user->guessed[0]='\0';
user->hangman=0;
user->hangmode=0;
user->hangword[0]='\0';
user->hid=0;
user->homeroom[0]='\0';
user->hroom=0;
user->hunt=1;
user->hunted[0]='\0';
user->hunting=0;
user->idlemin=0;
user->idlemsg=0;
user->ignoreset[0]='\0';
user->il=0;
user->in_phrase[0]='\0';
user->income=0;
user->incomp=0;
user->inpstr_old[0]='\0';
user->invisname[0]='\0';
user->invite_room=NULL;
user->jail=0;
user->jailcnt=1;
user->jeep=0;
user->jeepcnt=0;
user->jeeprooms=0;
user->jeeptime=time(0);
user->join=1;
user->last[0]='\0';
user->last_input=time(0);
user->last_login=time(0);
user->last_login_len=0;
user->last_site[0]='\0';
user->ldidit=0;
user->leader=0;
user->level=1;
user->lineedit=0;
user->listen=1;
user->listen_store=1;
user->listenset[0]='\0';
user->locked=0;
user->login=0;
user->losing=0;
user->lostto[0]='\0';
user->lprofile[0]='\0';
user->lstage=0;
user->mail_to[0]='\0';
user->makeemread=time(0);
user->malloc_end=NULL;
user->malloc_start=NULL;
user->md[0]='\0';
user->merlyn[0]='\0';
user->mesg=0;
user->misc_op=0;
user->money=0;
user->monopoly=0;
user->morelines=0;
user->morelines1=1;
user->morphed[0]='\0';
user->motdpause=0;
user->motdpausetime=time(0);
user->mplayer1[0]='\0';
user->mplayer2[0]='\0';
user->mplayer3[0]='\0';
user->mplayer4[0]='\0';
user->muzzled=0;
user->name[0]='\0';
user->netlink=NULL;
user->newpass[0]='\0';
user->noidle=0;
user->notcomplete=0;
user->notyet=0;
user->numpages=0;
user->numplay=1;
user->numrooms=0;
user->old_op=0;
user->origpos=0;
user->out_phrase[0]='\0';
user->owner=NULL;
user->page_file[0]='\0';
user->pass[0]='\0';
user->passwd[0]='\0';
user->pay=0;
user->percentage=0;
user->pickcol[0]='\0';
user->pictell=1;
user->playernum=0;
user->pnq=0;
user->printcolors=0;
user->prompt=prompt_def;
user->pstage=0;
user->ptmisc_op=0;
user->ptpos=0;
user->question=1;
user->quiet=0;
user->quitin1=time(0);
user->quitin2=0;
user->quitin3=0;
user->quitting=0;
user->quizcnt=3;
user->read_mail=time(0);
user->read_sentmail=time(0);
user->readroom=NULL;
user->ready=0;
user->remote_com=-1;
user->reply=0;
user->respawn=0;
user->revdisp=0;
user->room=NULL;
user->rooms=0;
user->scommand_mode=0;
user->score=0;
user->selfdestructing=0;
user->setlogin[0]='\0';
user->setlogout[0]='\0';
user->setpro[0]='\0';
user->shout=1;
user->signon=1;
user->sleepstage=0;
user->sleeptime=time(0);
user->smail=1;
user->smoke=1;
user->socials=1;
user->space=0;
user->sstage=0;
user->stalker[0]='\0';
user->talkbackto[0]='\0';
user->talking=0;
user->talkready=0;
user->talkto[0]='\0';
user->tday=0;
user->tdiff=0;
user->tdiffhour=0;
user->tell=1;
user->tgobackto[0]='\0';
user->thour=0;
user->tleader[0]='\0';
user->tmday=0;
user->tmin=0;
user->tmonth=0;
user->total=0;
user->total_login=0;
user->tplayer[0]='\0';
user->trade1=0;
user->trade2=0;
user->trade1prop=0;
user->trade2prop=0;
user->tradeto[0]='\0';
user->trading=0;
user->tready=0;
user->trig=0;
user->trigonce=0;
user->tsec=0;
user->tsign=0;
user->ttime=0;
user->ttt=0;
user->turn=0;
user->turniton=0;
user->twday=0;
user->tyear=0;
user->type=USER_TYPE;
user->url[0]='\0';
user->vanity=0;
user->vanitytime=time(0);
user->vanswer[0]='\0';
user->vanswer2[0]='\0';
user->vcntplay=1;
user->vgame=0;
user->vgobackto[0]='\0';
user->vgoon=0;
user->vis=1;
user->vleader=0;
user->vmyturn=0;
user->vnumplay=1;
user->vplayer1[0]='\0';
user->vplayer2[0]='\0';
user->vplayer3[0]='\0';
user->vplayer4[0]='\0';
user->vplayernum=0;
user->vready=0;
user->vsecond=0;
user->vspace=0;
user->vturn=0;
user->waiting=0;
user->warned=0;
user->which=0;
user->whichcol=0;
user->whichcol1=0;
user->whichcol2=0;
user->whichcol3=0;
user->whichsquare[0]='\0';
user->whichtalk=0;
user->whichtrig=0;
user->wizroom=0;
user->woohoo=0;
user->wordcnt=0;
user->wordwrap=0;
user->wordwraplen=0;
user->write_to[0]='\0';
user->xval=0;
user->yahtzee=0;
user->yahtzee2=0;
user->yahtzeevars[0]=0;
user->yahtzeevars[1]=0;
user->yahtzeevars[2]=0;
user->yahtzeevars[3]=0;
user->yahtzeevars[4]=0;
user->yahtzeevars[5]=0;
user->yahtzeevars[6]=0;
user->yahtzeevars[7]=0;
user->yahtzeevars[8]=0;
user->yahtzeevars[9]=0;
user->yahtzeevars[10]=0;
user->yahtzeevars[11]=0;
user->yahtzeevars[12]=0;
user->ycount=0;
user->ydice[0]=0;
user->ydice[1]=0;
user->ydice[2]=0;
user->ydice[3]=0;
user->ydice[4]=0;
user->yused[0]='\0';
user->yval=0;
for(i=0;i<10;++i) user->tsquare[i][0]='\0';
for(i=0;i<CONV_LINES;++i) user->conv_lines[i][0]='\0';
for(i=0;i<MAX_WORDS;++i) user->word[i][0]='\0';
}

/*** Destruct a user object ***/
void destruct_user(user,which)
UR_OBJECT user;
int which;
{
destroy_user_clones(user);
if (user!=user_first) {
	user->prev->next=user->next;
	if (user!=user_last) user->next->prev=user->prev;
	else { user_last=user->prev; user_last->next=NULL; }
	}
else {
	user_first=user->next;
	if (user!=user_last) user_first->prev=NULL;
	else user_last=NULL;
	}
free(user);
destructed=which;
}

/*** Security feature or something ***/
void breakin(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in breakin().\n",0);
	return;
	}
sntrncpy(user2->name,user->name,sizeof(user2->name));
if (!load_user_details(user2)) { destruct_user(user2,0); return; }
user2->socket=5;
++user2->breakin;
if (!user2->tdiff) user2->br_time=time(0);
else if (user2->tdiff==1) user2->br_time=time(0)+(user->thour*60);
else if (user2->tdiff==2) user2->br_time=time(0)-(user->thour*60);
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
save_user_details(user2,0);
destruct_user(user2,0);
snprintf(text,sizeof(text),"Invalid password for \"%s\" from %s.\n",user->name,user->site);
write_syslog(text,1);
}

/*** Load lilmouse ***/
void load_lilmouse(user)
UR_OBJECT user;
{
char name[USER_NAME_LEN+1];
UR_OBJECT user2;

sntrncpy(name,"Lilmouse",sizeof(name));
if ((user2=get_user(name,0))) {
	if (user) write_user(user,"lilmouse is already signed on.\n");
	return;
	}
if (!(user2=create_user())) {
	write_syslog("ERROR: Unable to create temporary user session in load_lilmouse().\n",0);
	return;
	}
sntrncpy(user2->name,name,sizeof(user2->name));
if (!load_user_details(user2)) { destruct_user(user2,0); return; }
user2->socket=5;
++user2->tsign;
user2->noidle=1;
++num_of_users;
user2->last_login=time(0);
sntrncpy(user2->morphed,"lilmouse",sizeof(user2->morphed));
sntrncpy(user2->desc,"~RS",sizeof(user2->desc));
sntrncpy(user2->site,wholeaddy,sizeof(user2->site));
sntrncpy(user2->last_site,wholeaddy,sizeof(user2->last_site));
user2->room=room_first;
get_gender(user2);
snprintf(text,sizeof(text),"\n=|= squeak squeak squeak goes the %s =|=\n\n",user2->morphed);
write_room_except(NULL,text,user2,NULL,2,user2);
}

/*** Load bigcat ***/
void load_bigcat()
{
char name[USER_NAME_LEN+1];
UR_OBJECT user2;

sntrncpy(name,"Lilmouse",sizeof(name));
if (!(user2=get_user(name,0))) return;
sntrncpy(name,"Bigcat",sizeof(name));
if ((user2=get_user(name,0))) return;
if (!(user2=create_user())) {
	write_syslog("ERROR: Unable to create temporary user session in load_bigcat().\n",0);
	return;
	}
sntrncpy(user2->name,name,sizeof(user2->name));
if (!load_user_details(user2)) { destruct_user(user2,0); return; }
user2->socket=5;
++user2->tsign;
user2->noidle=1;
++num_of_users;
user2->last_login=time(0);
sntrncpy(user2->morphed,"bigcat",sizeof(user2->morphed));
sntrncpy(user2->desc,"~RS",sizeof(user2->desc));
sntrncpy(user2->site,wholeaddy,sizeof(user2->site));
sntrncpy(user2->last_site,wholeaddy,sizeof(user2->last_site));
user2->room=room_last;
get_gender(user2);
snprintf(text,sizeof(text),"\n=|= meow meow meow goes the %s =|=\n\n",user2->morphed);
write_room_except(NULL,text,user2,NULL,2,user2);
bigcattime=time(0);
bigcatstage=1;
}

/*** Load any user ***/
void load_user(user)
UR_OBJECT user;
{
RM_OBJECT room;
UR_OBJECT user2,user3;

if (word_count<2) {
	write_user(user,"Load who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=create_user())) {
	write_syslog("ERROR: Unable to create temporary user session in load_user().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
++user2->tsign;
user2->noidle=1;
++num_of_users;
user2->last_login=time(0);
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
if (word_count<3) user2->room=room_first;
else {
	if (!(room=get_room(user,word[2]))) user2->room=room_first;
	else user2->room=room;
	}
get_gender(user2);
if (!user2->hid) {
	for(user3=user_first;user3;user3=user3->next) {
		if (user3->room) if (user3->room->level!=user2->room->level && user3->level<GENERAL) continue;
		if (user3==user2 || user3->login || !user3->listen || !user3->room || user3->type==CLONE_TYPE || !user3->signon) continue;
		if (user3->beeplogin) write_user(user3,"~PZ");
		if (user3->room==user2->room) snprintf(text,sizeof(text),"~OLFALLING IN THE HOLE:~RS[HERE!] %s %s\n",user2->morphed,user2->desc);
		else if (user2->room->access==HIDDEN) snprintf(text,sizeof(text),"~OLFALLING IN THE HOLE:~RS[*?*] %s %s\n",user2->morphed,user2->desc);
		else snprintf(text,sizeof(text),"~OLFALLING IN THE HOLE:~RS[%s] %s %s\n",user2->room->name,user2->morphed,user2->desc);
		write_user(user3,text);
		}
	}
else { snprintf(text,sizeof(text),"%s loaded.\n",user2->name); write_user(user,text); }
}

/*** Destruct a user ***/
void destroy_user(user)
UR_OBJECT user;
{
int i=0;
RM_OBJECT room;
UR_OBJECT user2,user3;

if (word_count<2) {
	write_user(user,"Destruct who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (word_count>2) {
	if (!(room=get_room(user,word[2]))) return;
	for(user3=user_first;user3;user3=user3->next) if (!strcmp(user2->name,user3->name) && user3->room==room) { user2=user3; ++i; break; }
	if (!i) {
		snprintf(text,sizeof(text),"%s is not in that room.\n",user2->name);
		write_user(user,text);
		return;
		}
	}
if (user2==user) {
	write_user(user,"Trying to commit suicide this way is the forty-first sign of madness.\n");
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"Hmm .. inadvisable.\n");
	snprintf(text,sizeof(text),"%s tried to destruct you!\n",user->name);
	write_user(user2,text);
	return;
	}
if (!user2->hid) {
	snprintf(text,sizeof(text),"~OLCLIMBING OUT OF THE HOLE:~RS %s %s\n",user2->morphed,user2->desc);
	write_room_except(NULL,text,user2,NULL,2,user2);
	}
else { snprintf(text,sizeof(text),"%s destructed.\n",user2->name); write_user(user,text); }
--num_of_users;
destruct_user(user2,0);
}

/*** Load a user ***/
UR_OBJECT load_usertime(user,name)
UR_OBJECT user;
char *name;
{
UR_OBJECT user2;

if (!(user2=create_user())) {
	write_syslog("ERROR: Unable to create temporary user session in load_usertime().\n",0);
	return NULL;
	}
sntrncpy(user2->name,name,sizeof(user2->name));
if (!load_user_details(user2)) { destruct_user(user2,0); return NULL; }
user2->socket=5;
++user2->tsign;
user2->noidle=1;
++num_of_users;
user2->last_login=time(0);
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
user2->room=room_first;
get_gender(user2);
return user2;
}

/*** Fake logoff ***/
void fake_logoff(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (!(user2=create_user())) {
	write_syslog("ERROR: Unable to create temporary user session in fake_logoff().\n",0);
	return;
	}
sntrncpy(user2->name,user->name,sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
++num_of_users;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
user2->room=user->room;
user2->last_login=user->login;
tempstore=system_logging;
system_logging=0;
disconnect_user(user2);
system_logging=tempstore;
tempstore=0;
user->hid=1;
}

/*** Construct room object ***/
RM_OBJECT create_room()
{
int i;
RM_OBJECT room;

if (!(room=(RM_OBJECT)malloc(sizeof(struct room_struct)))) {
	fprintf(stderr,"BOOT ERROR: Memory allocation error in create_room().\n");
	return NULL;
	}
room->access=-1;
room->desc[0]='\0';
room->hid=0;
room->inlink=0;
room->label[0]='\0';
room->level=0;
room->mesg_cnt=0;
room->name[0]='\0';
room->netlink=NULL;
room->netlink_name[0]='\0';
room->next=NULL;
room->topic[0]='\0';
for(i=0;i<MAX_LINKS;++i) { room->link_label[i][0]='\0';  room->link[i]=NULL; }
if (!room_first) { room_first=room;  room->prev=NULL; }
else { room_last->next=room;  room->prev=room_last; }
room->next=NULL;
room_last=room;
return room;
}

/*** Delete room object ***/
void delete_room(room)
RM_OBJECT room;
{
char filename[FILENAME_LEN];

snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,room->name);
unlink(filename);
snprintf(filename,sizeof(filename),"%s/%s.R",DATAFILES,room->name);
unlink(filename);
snprintf(filename,sizeof(filename),"%s/%s.U",DATAFILES,room->name);
unlink(filename);
if (room!=room_first) {
	room->prev->next=room->next;
	if (room!=room_last) room->next->prev=room->prev;
	else { room_last=room->prev; room_last->next=NULL; }
	}
else {
	room_first=room->next;
	if (room!=room_last) room_first->prev=NULL;
	else room_last=NULL;
	}
free(room);
}

/*** Construct link object ***/
NL_OBJECT create_netlink()
{
NL_OBJECT nl;

if (!(nl=(NL_OBJECT)malloc(sizeof(struct netlink_struct)))) {
	snprintf(text,sizeof(text),"NETLINK: Memory allocation error in create_netlink().\n");
	write_syslog(text,1);
	return NULL;
	}
if (!nl_first) { nl_first=nl;  nl->prev=NULL;  nl->next=NULL; }
else { nl_last->next=nl;  nl->next=NULL;  nl->prev=nl_last; }
nl_last=nl;
nl->allow=ALL;
nl->buffer[0]='\0';
nl->connect_room=NULL;
nl->connected=0;
nl->keepalive_cnt=0;
nl->last_recvd=0;
nl->lastcom=-1;
nl->mail_from[0]='\0';
nl->mail_to[0]='\0';
nl->mailfile=NULL;
nl->mesg_user=NULL;
nl->port=0;
nl->remote_ver[0]='\0';
nl->service[0]='\0';
nl->site[0]='\0';
nl->socket=0;
nl->stage=0;
nl->type=UNCONNECTED;
nl->ver_major=0;
nl->ver_minor=0;
nl->ver_patch=0;
nl->verification[0]='\0';
nl->warned=0;
return nl;
}

/*** Destruct a netlink (usually a closed incoming one) ***/
void destruct_netlink(nl)
NL_OBJECT nl;
{
if (nl!=nl_first) {
	nl->prev->next=nl->next;
	if (nl!=nl_last) nl->next->prev=nl->prev;
	else { nl_last=nl->prev; nl_last->next=NULL; }
	}
else {
	nl_first=nl->next;
	if (nl!=nl_last) nl_first->prev=NULL;
	else nl_last=NULL;
	}
free(nl);
}


/************ MAIN LOOP FUNCTIONS ************/

/*** Set up readmask for select ***/
void setup_readmask(mask)
fd_set *mask;
{
int i;
NL_OBJECT nl;
UR_OBJECT user;

FD_ZERO(mask);
for(i=0;i<4;++i) FD_SET(listen_sock[i],mask);
for(user=user_first;user;user=user->next)
	if (user->type==USER_TYPE && user->socket>0) FD_SET(user->socket,mask);
for(nl=nl_first;nl;nl=nl->next)
	if (nl->type!=UNCONNECTED) FD_SET(nl->socket,mask);
}

/*** Check for and accept any incoming connections ***/
void accept_connections(mask)
fd_set *mask;
{
char site[SITE_NAME_LEN+1];
int accept_sock,i,size=sizeof(struct sockaddr_in),wizcnt=0;
struct sockaddr_in acc_addr;
UR_OBJECT user,user2;

for(i=0;i<4;++i) {
	if (FD_ISSET(listen_sock[i],mask)) {
		accept_sock=accept(listen_sock[i],(struct sockaddr *)&acc_addr,&size);
		if (i==3) { accept_server_connections(accept_sock,acc_addr); return; }
		/* Not bloody likely */
		if (!i && num_of_users+num_of_logins>=max_users) {
			write_sock(accept_sock,"\nSorry, the talker is full at the moment.\n\n");
			close(accept_sock);
			return;
			}
		if (!(user=create_user())) {
			snprintf(text,sizeof(text),"\n%s: unable to create session.\n\n",syserror);
			write_sock(accept_sock,text);
			close(accept_sock);
			return;
			}
		user->login=1;
		user->port=port[i];
		user->socket=accept_sock;
		++num_of_logins;
		get_ip_address(user,acc_addr,0);
		if (domain_banned(user->site) && !domain_allowed(user->site)) {
			snprintf(text,sizeof(text),"Attempted login from banned site %s.\n",user->site);
			write_syslog(text,1);
			disconnect_user(user);
			return;
			}
		if (i==2) { accept_talk_connections(user,0); return; }
		if (nologin && !domain_allowed(user->site)) {
			more(user,NOLOGINFILE,0);
			snprintf(text,sizeof(text),"Attempted login from site %s.\n",user->site);
			disconnect_user(user);
			return;
			}
		snprintf(text,sizeof(text),"~PZ~OL~FB[Connect from %s:%d on line %d]\n",user->site,user->site_port,user->socket);
		write_wiz(GENERAL,text,user);
		for(user2=user_first;user2;user2=user2->next) {
			if (user2->socket<0) continue;
			if (user2->level>=GENERAL) ++wizcnt;
			}
		if (wizcnt) {
			sntrncpy(site,get_site(user->site),sizeof(site));
			sameloginsite(site);
			}
		if (!i) {
			snprintf(text,sizeof(text),"\n~OL~FR-=*~RS ~OL~FMThe ground starts to shake...~RS ~OL~FR*=-\n\n");
			sntrncpy(text,center(text,80),sizeof(text));
			write_room(NULL,text);
			}
		for(user2=user_first;user2;user2=user2->next) {
			if (user2->login || user2->type==CLONE_TYPE) continue;
			if (check_autohide(user2,user->site) && !check_specialsite(user->site)) {
				write_user(user2,"Autohiding from user in your site list.\n");
				user2->hid=1;
				}
			else if (check_ifauto(user2)) exec_autologin(user2);
			}
		if (!newdomain_banned(user->site) || domain_allowed(user->site)) {
			user->sleepstage=1;
			odd(user);
			return;
			}
		finish_connect(user);
		}
	}
}

/*** Finish connect ***/
void finish_connect(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
int i,num,num2=0,total=0;
struct dirent **namelist;

if ((num=scandir(MOTDDIR,&namelist,0,alphasort))!=-1) {
	while(num2<num) { if (!strncmp(namelist[num2]->d_name,"motd",4)) ++total; ++num2; }
	i=rand()%total;
	if (i!=1 && i!=total) ++i;
	snprintf(filename,sizeof(filename),"%s/motd%i",MOTDDIR,i);
	more(user,filename,0);
	}
if (!newdomain_banned(user->site) || domain_allowed(user->site)) {
	if (user->port==port[1]) write_user(user,"*** Wizport login ***\n");
	write_user(user,"What's your name? ");
	}
else { snprintf(text,sizeof(text),"%s login: ",thishost); write_user(user,text); }
}

/*** Odd ***/
void odd(user)
UR_OBJECT user;
{
char text2[ARR_SIZE];

if (!hehehe) {
	text[0]='\0';
	if (user->sleepstage==1) {
		switch(rand()%3) {
			case 1:
				strncat(text,".-.                              .-.                         ^..^\n",sizeof(text));
				strncat(text,": :                              : :\n",sizeof(text));
				strncat(text,": `-.  .--. .-..-. .--. ,-.,-. .-' :      ^..^\n",sizeof(text));
				strncat(text,"' .; :' '_.': :; :' .; :: ,. :' .; :                 ,\n",sizeof(text));
				strncat(text,"`.__.'`.__.'`._. ;`.__.':_;:_;`.__.'                  \\`-.      ,          ==--\n",sizeof(text));
				strncat(text,"             .-. :                                .-._/   \\_____)\\ \n",sizeof(text));
				strncat(text,"             `._.'        .-. .-.                (\"              /   ==--\n",sizeof(text));
				strncat(text,"         ,               .' `.: :                 '-;   ,_____.-'\n",sizeof(text));
				strncat(text,"      .--')              `. .': `-.  .--.          /__.'                 ==--\n",sizeof(text));
				strncat(text,"    /    /      ^..^      : : : .. :' '_.'\n",sizeof(text));
				strncat(text,"   |    /                 :_; :_;:_;`.__.'   ^..^\n",sizeof(text));
				strncat(text,"/`.\\   (_.'\\         .-.                                        ^..^\n",sizeof(text));
				strncat(text,"\\          /        ( \" )               .--. .--.  .--.  .-..-. .--. \n",sizeof(text));
				strncat(text," '--. .---'      /\\_.' '._/\\           ' .; :: ..'' .; ; : `; :' '_.'\n",sizeof(text));
				strncat(text,"   ( \" )         |.       .|           `._. ;:_;  `.__,_;`.__.'`.__.'\n",sizeof(text));
				strncat(text,"    '-'            )     (    ^..^      .-. :                        \n",sizeof(text));
				strncat(text,"                    \\   /     Type      `._.'                               ^..^\n",sizeof(text));
				strncat(text,"         ^..^     (__) / \"users\" to see            <*><Welcome to BTG><*>\n",sizeof(text));
				strncat(text,"                  `.__.  who's logged in. \n",sizeof(text));
				strncat(text,"                       \n",sizeof(text));
				strncat(text,"Cryptkeeper asks for your name: ",sizeof(text));
				break;
			case 2:
				strncat(text,"               .         \\    Welcome to    /      +                        .\n",sizeof(text));
				strncat(text," -+-      .     _________))        :    +  ((__________     ;            (\n",sizeof(text));
				strncat(text,"       |       /.-------./\\\\     --*--    //\\.--------.\\    +             *\n",sizeof(text));
				strncat(text,"      -+-     //#######//##\\\\      :     //##\\\\########\\\\   ;      -*-     )\n",sizeof(text));
				strncat(text,"       |     //#######//###((  *         ))###\\\\########\\\\                \n",sizeof(text));
				strncat(text,"  *         ((#######((#####\\\\     /'   //#####))########))       .\n",sizeof(text));
				strncat(text,"             \\##' `###\\######\\\\  .((.  //######/####' `##/\n",sizeof(text));
				strncat(text,"              )'    ``#)'  `##\\`->oo<-'/##'  `(#''     `(    .      +\n",sizeof(text));
				strncat(text," .      +             (       ``\\`..'/''       )    .                 :\n",sizeof(text));
				strncat(text,"                   .             \\\"\"(                                -*-\n",sizeof(text));
				strncat(text,"    '||    ||'              +     `)v)     .      '||    ||'          :\n",sizeof(text));
				strncat(text,"     |||  |||  ...  ..            /v/              |||  |||  ...  ..\n",sizeof(text));
				strncat(text,"     |'|..'||   ||  ||           (v/\\              |'|..'||   ||  ||\n",sizeof(text));
				strncat(text,"     | '|' ||   ||  ||           /\\v )             | '|' ||   ||  ||\n",sizeof(text));
				strncat(text,"    .|. | .||.  '|..'|.         (   \\             .|. | .||.  '|..'|.\n",sizeof(text));
				strncat(text,"    L        -*-         A         -*-         N          -*-       D\n",sizeof(text));
				strncat(text,"    NEW .news as of                /            Send all inquries to:\n",sizeof(text));
				strncat(text,"    Sept 6th                      (           >> mumu@mumu.oanet.com <<\n",sizeof(text));
				strncat(text,"                                   `\n",sizeof(text));
				strncat(text,"    Type 'who' to see who is currently on, or 'quit' to cancel login.\n\n",sizeof(text));
				strncat(text,"The Gatekeeper asks you for your name: ",sizeof(text));
				break;
			default:
				strncat(text,"Chatd chat-deamon v0.8a\n\n",sizeof(text));
				snprintf(text2,sizeof(text2),"You are connecting from : %s\n\n",user->site);
				strncat(text,text2,sizeof(text));
				strncat(text,"#################################################\n",sizeof(text));
				strncat(text,"###########                           ###########\n",sizeof(text));
				strncat(text,"#####              Welcome to                ####\n",sizeof(text));
				strncat(text,"###          ~ APPEAL's chat-rooms ~          ###\n",sizeof(text));
				strncat(text,"##                                             ##\n",sizeof(text));
				strncat(text,"## telnet:  dark.x.dtu.dk <port 5555>          ##\n",sizeof(text));
				strncat(text,"##    WWW:  www.gbar.dtu.dk/~c938353/chat.html ##\n",sizeof(text));
				strncat(text,"### Email:  c938353@student.dtu.dk            ###\n",sizeof(text));
				strncat(text,"#####                                       #####\n",sizeof(text));
				strncat(text,"###########                           ###########\n",sizeof(text));
				strncat(text,"#################################################\n",sizeof(text));
				strncat(text,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n",sizeof(text));
				strncat(text,"!! You are expected to know the rules, don't   !!\n",sizeof(text));
				strncat(text,"!! just ignore them. Use \"/rules\" to see them. !!\n",sizeof(text));
				strncat(text,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n",sizeof(text));
				strncat(text,"(Please report bugs to the above Email-address)\n\n",sizeof(text));
				strncat(text,"When logged in, type \"/help\" for a short help!\n\n",sizeof(text));
				strncat(text,"Enter the name you wish to use:      (Try also listall)\n",sizeof(text));
			}
		write_user(user,text);
		}
	else if (user->sleepstage==2) {
		cls(user);
		strncat(text,"                              Oops... wrong place!\n\n",sizeof(text));
		strncat(text,"                              @@@@            @@@@\n",sizeof(text));
		strncat(text,"                             @@@@@@          @@@@@@\n",sizeof(text));
		strncat(text,"                             @@@@@@          @@@@@@\n",sizeof(text));
		strncat(text,"                              @@@@            @@@@\n\n\n\n",sizeof(text));
		/* To smile or not to smile, that is the question */
		switch(rand()%2) {
			case 0:
				strncat(text,"                        @                             @\n",sizeof(text));
				strncat(text,"                         @@                         @@\n",sizeof(text));
				strncat(text,"                           @@@                   @@@\n",sizeof(text));
				strncat(text,"                              @@@@@         @@@@@\n",sizeof(text));
				strncat(text,"                                 @@@@@@@@@@@@@\n",sizeof(text));
				break;
			default:
				strncat(text,"                                 @@@@@@@@@@@@@\n",sizeof(text));
				strncat(text,"                              @@@@@         @@@@@\n",sizeof(text));
				strncat(text,"                           @@@                   @@@\n",sizeof(text));
				strncat(text,"                         @@                         @@\n",sizeof(text));
				strncat(text,"                        @                             @\n",sizeof(text));
			}
		write_user(user,text);
		}
	else { cls(user); user->sleepstage=0; finish_connect(user); return; }
	++user->sleepstage;
	user->sleeptime=time(0);
	}
else { user->sleepstage=0; finish_connect(user); }
}

/*** Get net address of accepted connection ***/
char *get_ip_address(user,acc_addr,which)
UR_OBJECT user;
struct sockaddr_in acc_addr;
int which;
{
static char site[SITE_NAME_LEN+1];
unsigned int addr;
struct hostent *host;

sntrncpy(site,(char *)inet_ntoa(acc_addr.sin_addr),sizeof(site));
addr=inet_addr(site);
if ((host=gethostbyaddr((char *)&addr,4,AF_INET))) {
	if (!which) sntrncpy(user->site,host->h_name,sizeof(user->site));
	else sntrncpy(site,host->h_name,sizeof(site));
	}
else if (!which) sntrncpy(user->site,site,sizeof(user->site));
if (!which) user->site_port=(int)ntohs(acc_addr.sin_port);
return site;
}

/*** See if user is banned ***/
int user_banned(name)
char *name;
{
char line[82];
FILE *fp;

if (!(fp=fopen(USERBANS,"r"))) return 0;
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (!strcmp(line,name)) { fclose(fp); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
return 0;
}

/*** Check sites for banned domains ***/
int domain_banned(domain)
char *domain;
{
char line[82],*s;
FILE *fp;

if (!(fp=fopen(DOMAINBANS,"r"))) return 0;
if (!(s=(char *)malloc(strlen(domain)+1))) { fclose(fp); return 0; }
strcpy(s,domain);
strtolower(s);
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (instr(s,line)) { fclose(fp); free(s); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
free(s);
return 0;
}

/*** Check sites for banned domains on new users ***/
int newdomain_banned(domain)
char *domain;
{
char line[82],*s;
FILE *fp;

if (!(fp=fopen(NEWDOMAINBANS,"r"))) return 0;
if (!(s=(char *)malloc(strlen(domain)+1))) { fclose(fp); return 0; }
strcpy(s,domain);
strtolower(s);
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (instr(s,line)) { fclose(fp); free(s); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
free(s);
return 0;
}

/*** Check sites for matches ***/
int check_site(str,site)
char *str,*site;
{
char *s;

if (!(s=(char *)malloc(strlen(str)+1))) return 0;
strcpy(s,str);
strtolower(s); strtolower(site);
if (instr(s,site)) { free(s); return 1; }
free(s);
return 0;
}

/*** Check sites for allowed domains ***/
int domain_allowed(domain)
char *domain;
{
char filename[FILENAME_LEN],line[82],*s;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/allowdomains",DATAFILES);
if (!(fp=fopen(filename,"r"))) return 0;
if (!(s=(char *)malloc(strlen(domain)+1))) { fclose(fp); return 0; }
strcpy(s,domain);
strtolower(s);
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (instr(s,line)) { fclose(fp); free(s); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
free(s);
return 0;
}

/*** See if user doesn't want smail ***/
int nosmail(name)
char *name;
{
char filename[FILENAME_LEN],line[82];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/nosmail",DATAFILES);
if (!(fp=fopen(filename,"r"))) return 0;
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (!strcmp(line,name)) { fclose(fp); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
return 0;
}

/*** See if site doesn't allow promos ***/
int nopromos(site)
char *site;
{
char filename[FILENAME_LEN],line[82],*s;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/nopromos",DATAFILES);
if (!(fp=fopen(filename,"r"))) return 0;
if (!(s=(char *)malloc(strlen(site)+1))) { fclose(fp); return 0; }
strcpy(s,site);
strtolower(s);
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (instr(s,line)) { fclose(fp); free(s); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
free(s);
return 0;
}

/*** Check if user is playing or about to play a Monopoly game ***/
int check_game(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (user->misc_op==19 || user->misc_op==21) return 1;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->leader) {
		if (!strcmp(user2->mplayer1,user->name)) return 1;
		else if (!strcmp(user2->mplayer2,user->name)) return 1;
		else if (!strcmp(user2->mplayer3,user->name)) return 1;
		else if (!strcmp(user2->mplayer4,user->name)) return 1;
		}
	if (!strcmp(user2->gobackto,user->name)) return 1;
	}
return 0;
}

/*** Check if user is playing or about to play a Vanity Chase game ***/
int check_vgame(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (user->misc_op==80 || user->misc_op==81) return 1;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->vleader) {
		if (!strcmp(user2->vplayer1,user->name)) return 1;
		else if (!strcmp(user2->vplayer2,user->name)) return 1;
		else if (!strcmp(user2->vplayer3,user->name)) return 1;
		else if (!strcmp(user2->vplayer4,user->name)) return 1;
		}
	if (!strcmp(user2->vgobackto,user->name)) return 1;
	}
return 0;
}

/*** Check if user is playing or about to play a tic tac toe game ***/
int check_tgame(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (user->misc_op==95 || user->misc_op==96) return 1;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (!strcmp(user2->tgobackto,user->name)) return 1;
	}
return 0;
}

/*** Check if user is talking or about to talk ***/
int check_talk(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (user->misc_op==115 || user->misc_op==68) return 1;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (!strcmp(user2->talkbackto,user->name)) return 1;
	}
return 0;
}

/*** Print muzzle ***/
void print_muzzle(user)
UR_OBJECT user;
{
snprintf(text,sizeof(text),"You are muzzled, ");
switch(com_num) {
	case ACCREQ: strncat(text,"you cannot request an account.",sizeof(text)); break;
	case ACK: strncat(text,"you cannot ACK.",sizeof(text)); break;
	case ADDROOM: strncat(text,"you cannot play with the rooms.",sizeof(text)); break;
	case ADDTIME: strncat(text,"you cannot add time.",sizeof(text)); break;
	case ADDTSIGN: strncat(text,"you cannot add signons.",sizeof(text)); break;
	case ADDUSER: strncat(text,"you cannot add a user.",sizeof(text)); break;
	case AFK: strncat(text,"you cannot leave the keyboard.",sizeof(text)); break;
	case AFKLOG: strncat(text,"you cannot review your afklog.",sizeof(text)); break;
	case ANVIL: strncat(text,"you cannot drop an anvil on anyone.",sizeof(text)); break;
	case ARREST: strncat(text,"you cannot arrest anyone.",sizeof(text)); break;
	case AUTOHIDE: strncat(text,"you cannot autohide.",sizeof(text)); break;
	case AUTOREAD: strncat(text,"you cannot autoread.",sizeof(text)); break;
	case AWHO: strncat(text,"you cannot see who is on.",sizeof(text)); break;
	case BAKE: strncat(text,"you cannot bake a user.",sizeof(text)); break;
	case BAN: strncat(text,"you cannot ban anyone.",sizeof(text)); break;
	case BCAST: strncat(text,"you cannot broadcast anything.",sizeof(text)); break;
	case BEAT: strncat(text,"you cannot beat anyone.",sizeof(text)); break;
	case BECHO: strncat(text,"you cannot backwards echo anything.",sizeof(text)); break;
	case BEEPLINE: strncat(text,"you cannot listen to beeps on every line.",sizeof(text)); break;
	case BEEPLOGIN: strncat(text,"you cannot listen to beeps on logins.",sizeof(text)); break;
	case BEEPTELL: strncat(text,"you cannot beeptell anyone anything.",sizeof(text)); break;
	case BEMOTE: strncat(text,"you cannot backwards emote.",sizeof(text)); break;
	case BLAST: strncat(text,"you cannot blast anyone.",sizeof(text)); break;
	case BOOTEM: strncat(text,"you cannot boot anyone.",sizeof(text)); break;
	case BOUNCE: strncat(text,"you cannot bounce anyone.",sizeof(text)); break;
	case BRB: strncat(text,"you cannot go anywhere.",sizeof(text)); break;
	case BSAY: strncat(text,"you cannot speak.",sizeof(text)); break;
	case BSECHO: strncat(text,"you cannot backwards shout echo.",sizeof(text)); break;
	case BSEMOTE: strncat(text,"you cannot backwards shout emote.",sizeof(text)); break;
	case BSHOUT: strncat(text,"you cannot backwards shout.",sizeof(text)); break;
	case BTELL: strncat(text,"you cannot backwards tell anyone anything.",sizeof(text)); break;
	case CALC: strncat(text,"you cannot use the calculator.",sizeof(text)); break;
	case CALENDAR: strncat(text,"you cannot see the calendar.",sizeof(text)); break;
	case CLREV: strncat(text,"your clone cannot review the buffer.",sizeof(text)); break;
	case CLREVCLR: strncat(text,"your clone cannot clear the buffer.",sizeof(text)); break;
	case CLSAY: strncat(text,"your clone cannot speak.",sizeof(text)); break;
	case COMPLAIN: strncat(text,"you cannot complain.",sizeof(text)); break;
	case CONFUSE: strncat(text,"you cannot confuse yourself.",sizeof(text)); break;
	case CORP: strncat(text,"you cannot promote anyone to corporal.",sizeof(text)); break;
	case CREATE: strncat(text,"you cannot create a clone.",sizeof(text)); break;
	case CRON: strncat(text,"you cannot set a cron job.",sizeof(text)); break;
	case DARK: strncat(text,"you cannot change darken anyone's world.",sizeof(text)); break;
	case DCHALLENGE: strncat(text,"you cannot challenge anyone.",sizeof(text)); break;
	case DCHANNEL: strncat(text,"you cannot delete the channels.",sizeof(text)); break;
	case DCOMPLAIN: strncat(text,"you cannot delete any complaints.",sizeof(text)); break;
	case DELIVER: strncat(text,"you cannot deliver a user.",sizeof(text)); break;
	case DELROOM: strncat(text,"you cannot play with the rooms.",sizeof(text)); break;
	case DEMOTE: strncat(text,"you cannot demote anyone.",sizeof(text)); break;
	case DESC: strncat(text,"you cannot change your description.",sizeof(text)); break;
	case DESTRUCT: strncat(text,"you cannot destruct anyone.",sizeof(text));
	case DIRTCLOD: strncat(text,"you cannot throw dirt clods at anyone.",sizeof(text)); break;
	case DMAIL: strncat(text,"you cannot delete your mail.",sizeof(text)); break;
	case DOH: strncat(text,"you cannot Doh!",sizeof(text)); break;
	case DONTIDLEME: strncat(text,"you cannot turn idling on/off.",sizeof(text)); break;
	case DRAG: strncat(text,"you cannot drag anyone.",sizeof(text)); break;
	case DSHOUTS: strncat(text,"you cannot delete the shouts.",sizeof(text)); break;
	case DSMAIL: strncat(text,"you cannot delete your sent mail.",sizeof(text)); break;
	case DSUGGEST: strncat(text,"you cannot delete any suggestions.",sizeof(text)); break;
	case DWIZ: strncat(text,"you cannot delete the wizshouts.",sizeof(text)); break;
	case ECHOIT: strncat(text,"you cannot echo.",sizeof(text)); break;
	case EEK: strncat(text,"you cannot eeeeeeeeeeeeeek.",sizeof(text)); break;
	case EH: strncat(text,"you cannot eh eh?",sizeof(text)); break;
	case EMOTE: strncat(text,"you cannot emote.",sizeof(text)); break;
	case ENTPRO: strncat(text,"you cannot enter a profile.",sizeof(text)); break;
	case EXAMINE: strncat(text,"you cannot examine anyone.",sizeof(text)); break;
	case FAKELOGOFF: strncat(text,"you cannot pretend to logoff.",sizeof(text)); break;
	case FEMOTE: strncat(text,"you cannot emote to your friends anything.",sizeof(text)); break;
	case FLOWERS: strncat(text,"you cannot send flowers.",sizeof(text)); break;
	case FMAIL: strncat(text,"you cannot mail your friends.",sizeof(text)); break;
	case FORTUNE: strncat(text,"you cannot use fortune.",sizeof(text)); break;
	case FORWARD: strncat(text,"you cannot forward your mail.",sizeof(text)); break;
	case FPC: strncat(text,"you cannot force anyone to change their password.",sizeof(text)); break;
	case FREEZE: strncat(text,"you cannot freeze anyone.",sizeof(text)); break;
	case FREEZEALL: strncat(text,"you cannot freeze everyone.",sizeof(text)); break;
	case FRIENDS: strncat(text,"you have no friends.",sizeof(text)); break;
	case FRIENDSTIME: strncat(text,"you cannot annoy everyone.",sizeof(text)); break;
	case FROM: strncat(text,"you cannot see who your mail is from.",sizeof(text)); break;
	case FTELL: strncat(text,"you cannot tell your friends anything.",sizeof(text)); break;
	case GO: strncat(text,"you just sit right down.",sizeof(text)); break;
	case GOSSAMER: strncat(text,"you cannot toggle Gossamer.",sizeof(text)); break;
	case GRANT: strncat(text,"you cannot grant anyone 3 wishes.",sizeof(text)); break;
	case GRANTED: strncat(text,"you cannot see granted commands.",sizeof(text)); break;
	case GREET: strncat(text,"you cannot greet.",sizeof(text)); break;
	case HANGMAN: strncat(text,"you cannot play hangman.",sizeof(text)); break;
	case HIDE: strncat(text,"you cannot run, you cannot hide.",sizeof(text)); break;
	case HIFIVE: strncat(text,"you cannot high five anyone.",sizeof(text)); break;
	case HMM: strncat(text,"you cannot hmm.",sizeof(text)); break;
	case HOMEROOM: strncat(text,"you cannot change your home room.",sizeof(text)); break;
	case HOMEWOOM: strncat(text,"you cannot change anyone's home woom.",sizeof(text)); break;
	case HOWL: strncat(text,"you cannot howl at the moon.",sizeof(text)); break;
	case HUGGLE: strncat(text,"you cannot huggle anyone.",sizeof(text)); break;
	case IDEA: strncat(text,"you cannot have an idea.",sizeof(text)); break;
	case IDLE: strncat(text,"you cannot idle.",sizeof(text)); break;
	case IGUSER: strncat(text,"you cannot ignore anyone.",sizeof(text)); break;
	case IHUNT: strncat(text,"you cannot hunt anyone.",sizeof(text)); break;
	case INCOMPETENT: strncat(text,"you must be really incompetent.",sizeof(text)); break;
	case INNOCENT: strncat(text,"you aren't innocent.",sizeof(text)); break;
	case INVITE: strncat(text,"you cannot invite anyone here to help you.",sizeof(text)); break;
	case JEEP: strncat(text,"no jeep driving today.",sizeof(text)); break;
	case JOIN: strncat(text,"you cannot join a user.",sizeof(text)); break;
	case KILL: strncat(text,"you cannot kill anyone.",sizeof(text)); break;
	case KILLALL: strncat(text,"you cannot kill everyone.",sizeof(text)); break;
	case KISS: strncat(text,"you cannot kiss anyone.",sizeof(text)); break;
	case LAST: strncat(text,"you cannot see the last logged in users.",sizeof(text)); break;
	case LASTON: strncat(text,"you cannot see when anyone was last on.",sizeof(text)); break;
	case LBAN: strncat(text,"you cannot list the bans.",sizeof(text)); break;
	case LETMEIN: strncat(text,"you cannot go even if ya could use this.",sizeof(text)); break;
	case LOAD: strncat(text,"you cannot load anyone.",sizeof(text));
	case LOCK: strncat(text,"you cannot lock anyone's account.",sizeof(text)); break;
	case LOGIM: strncat(text,"you cannot enter a login message.",sizeof(text)); break;
	case LOGOM: strncat(text,"you cannot enter a logout message.",sizeof(text)); break;
	case LOL: strncat(text,"you cannot laugh.",sizeof(text)); break;
	case MACRO: strncat(text,"you cannot do anything with macros.",sizeof(text)); break;
	case MHUNT: strncat(text,"you cannot hunt anyone.",sizeof(text)); break;
	case MINLOGIN: strncat(text,"you cannot change the minlogin level.",sizeof(text)); break;
	case MIRROR: strncat(text,"you cannot mirror yourself.",sizeof(text)); break;
	case MODE: strncat(text,"you cannot toggle modes.",sizeof(text)); break;
	case MONOPOLY: strncat(text,"you cannot play monopoly.",sizeof(text)); break;
	case MORPH: strncat(text,"you cannot morph anyone.",sizeof(text)); break;
	case MOTD: strncat(text,"you cannot change the motd string.",sizeof(text)); break;
	case MOVE: strncat(text,"you cannot move anyone anywhere.",sizeof(text)); break;
	case MOVEALL: strncat(text,"you cannot move everyone.",sizeof(text)); break;
	case MUHAHA: strncat(text,"you cannot scare every one in the room with your maniacal laugh.",sizeof(text)); break;
	case MUMBLE: strncat(text,"you cannot mumble.",sizeof(text)); break;
	case MUZZLE: strncat(text,"you cannot muzzle anyone.",sizeof(text)); break;
	case NEWS: strncat(text,"you cannot read the news.",sizeof(text)); break;
	case NOD: strncat(text,"you cannot nod.",sizeof(text)); break;
	case OAFK: strncat(text,"you cannot make anyone leave the keyboard.",sizeof(text)); break;
	case OINPHR: strncat(text,"you cannot change anyone's in phrase.",sizeof(text)); break;
	case OLOGIM: strncat(text,"you cannot enter a login message for anyone.",sizeof(text)); break;
	case OLOGOM: strncat(text,"you cannot enter a logout message for anyone.",sizeof(text)); break;
	case OMIRROR: strncat(text,"you cannot mirror anyone.",sizeof(text)); break;
	case OPASSWD: strncat(text,"you cannot change anyone's password.",sizeof(text)); break;
	case OOUTPHR: strncat(text,"you cannot change anyone's out phrase.",sizeof(text)); break;
	case ORESPAWN: strncat(text,"you cannot respawn anyone.",sizeof(text)); break;
	case OUNAFK: strncat(text,"you cannot bring anyone back to the keyboard.",sizeof(text)); break;
	case PANIC: strncat(text,"you cannot panic. Oh wait, you can.. Just not with this command.",sizeof(text)); break;
	case PASSWD: strncat(text,"you cannot change your password.",sizeof(text)); break;
	case PASTE: strncat(text,"you cannot paste anything.",sizeof(text)); break;
	case PEMOTE: strncat(text,"you cannot private emote.",sizeof(text)); break;
	case PICKCOL: strncat(text,"you cannot pick a color.",sizeof(text)); break;
	case PICKCOLS: strncat(text,"you cannot pick colors for anyone.",sizeof(text)); break;
	case PICTELL: strncat(text,"you cannot send pictells.",sizeof(text)); break;
	case PING: strncat(text,"you cannot ping anyone.",sizeof(text)); break;
	case POKE: strncat(text,"you cannot poke anyone.",sizeof(text)); break;
	case PONG: strncat(text,"you cannot pong anyone.",sizeof(text)); break;
	case PROMOTE: strncat(text,"you cannot promote anyone.",sizeof(text)); break;
	case PROMPT: strncat(text,"you cannot toggle the prompt.",sizeof(text)); break;
	case PUKE: strncat(text,"you cannot throw up.",sizeof(text)); break;
	case QUITIN: if (!user->command_mode && !user->scommand_mode) strncat(text,"use .quit please.",sizeof(text)); else strncat(text,"use the quit command please.",sizeof(text)); break;
	case QUIZ: strncat(text,"you cannot take the quiz.",sizeof(text)); break;
	case RCOMPLAIN: strncat(text,"you cannot view the complaints file.",sizeof(text)); break;
	case READ: strncat(text,"you cannot read the message board.",sizeof(text)); break;
	case RECAP: strncat(text,"you cannot recap your name.",sizeof(text)); break;
	case RENAME: strncat(text,"you cannot rename anyone.",sizeof(text)); break;
	case REVCHANNEL: strncat(text,"you cannot review the channels.",sizeof(text)); break;
	case REVCLRALL: strncat(text,"you cannot clear all the conversation buffers.",sizeof(text)); break;
	case REVIEW: strncat(text,"you cannot review the conversation.",sizeof(text)); break;
	case REVOKE: strncat(text,"you cannot revoke anyone's driver's license.",sizeof(text)); break;
	case REVSHOUT: strncat(text,"you cannot review the shouts.",sizeof(text)); break;
	case REVTELL: strncat(text,"you cannot review your tells.",sizeof(text)); break;
	case REVWIZ: strncat(text,"you cannot review the wizshouts.",sizeof(text)); break;
	case RLOOK: strncat(text,"you cannot rlook.",sizeof(text)); break;
	case RMAIL: strncat(text,"you cannot read your mail.",sizeof(text)); break;
	case RMSN:
	case RMST: strncat(text,"you cannot see the rooms.",sizeof(text)); break;
	case ROFL: strncat(text,"you cannot roll on the floor laughing.",sizeof(text)); break;
	case ROLLS: strncat(text,"you cannot roll across the floor.",sizeof(text)); break;
	case ROOMADD:
	case ROOMDEL: strncat(text,"you cannot play with the rooms.",sizeof(text)); break;
	case ROOMDESC: strncat(text,"you cannot write a room description.",sizeof(text)); break;
	case RSUGGEST: strncat(text,"you cannot view the suggestions file.",sizeof(text)); break;
	case SAMESITE: strncat(text,"you cannot samesite a user/site.",sizeof(text)); break;
	case SAY: strncat(text,"you cannot speak.",sizeof(text)); break;
	case SCOMMAND: strncat(text,"you cannot toggle modes.",sizeof(text)); break;
	case SCREAM: strncat(text,"you cannot SCREAM!",sizeof(text)); break;
	case SEARCH: strncat(text,"you cannot search the message boards.",sizeof(text)); break;
	case SEARCHSITE: strncat(text,"you cannot search the site log.",sizeof(text)); break;
	case SECHO: strncat(text,"you cannot shout echo.",sizeof(text)); break;
	case SELFDESTRUCT: strncat(text,"you cannot make anyone self-destruct.",sizeof(text)); break;
	case SEMOTE: strncat(text,"you cannot shout emote.",sizeof(text)); break;
	case SENTMAIL: strncat(text,"you cannot read your sent mail.",sizeof(text)); break;
	case SET: strncat(text,"you cannot use set.",sizeof(text)); break;
	case SETDESC: strncat(text,"you cannot change anyone's description.",sizeof(text)); break;
	case SETPRO: strncat(text,"you cannot enter a profile for anyone.",sizeof(text)); break;
	case SFROM: strncat(text,"you cannot see who your sent mail is from.",sizeof(text)); break;
	case SHAKE: strncat(text,"you cannot shake anyone's hand.",sizeof(text)); break;
	case SHOUT: strncat(text,"you cannot shout.",sizeof(text)); break;
	case SHRUG: strncat(text,"you cannot shrug.",sizeof(text)); break;
	case SHUNT: strncat(text,"you cannot hunt anyone.",sizeof(text)); break;
	case SIGH: strncat(text,"you cannot sigh.",sizeof(text)); break;
	case SING: strncat(text,"you cannot sing.",sizeof(text)); break;
	case SITE: strncat(text,"you cannot site a user.",sizeof(text)); break;
	case SLEDGE: strncat(text,"you cannot hit anyone with a sludge hammer.",sizeof(text)); break;
	case SLEEP: strncat(text,"you cannot sleep.",sizeof(text)); break;
	case SMAIL: strncat(text,"you cannot mail anyone.",sizeof(text)); if (user->reply) end_reply(user); break;
	case SMAILALL: strncat(text,"you cannot mail everyone.",sizeof(text)); break;
	case SMOKE: strncat(text,"you cannot smoke anyone on a stick.",sizeof(text)); break;
	case SOCIALS: strncat(text,"you cannot see the social commands.",sizeof(text)); break;
	case STALK: strncat(text,"you cannot stalk anyone.",sizeof(text)); break;
	case STATUS: strncat(text,"you cannot see your or anyone else's status.",sizeof(text)); break;
	case STHINK: strncat(text,"you cannot shout think.",sizeof(text)); break;
	case STOPUSER: strncat(text,"you cannot stop anyone from using a command.",sizeof(text)); break;
	case SU: strncat(text,"you cannot su.",sizeof(text)); break;
	case SUBTIME: strncat(text,"you cannot subtract time.",sizeof(text)); break;
	case SUBTSIGN: strncat(text,"you cannot subtract signons.",sizeof(text)); break;
	case SUGGEST: strncat(text,"you cannot suggest anything.",sizeof(text)); break;
	case SUPERCRON: strncat(text,"you cannot set a cron job.",sizeof(text)); break;
	case SWAT: strncat(text,"you cannot swat any flies.",sizeof(text)); break;
	case SWHO: strncat(text,"you cannot see who is on.",sizeof(text)); break;
	case SWITCH: strncat(text,"you cannot swap places with a clone.",sizeof(text)); break;
	case SYSBANS: strncat(text,"you cannot see the system bans.",sizeof(text)); break;
	case SYSSTAT:
	case SYSTEM: strncat(text,"you cannot see the system stats.",sizeof(text)); break;
	case TAG: strncat(text,"you cannot tag anyone.",sizeof(text)); break;
	case TALK: strncat(text,"you cannot talk to anyone.",sizeof(text)); break;
	case TAP: strncat(text,"you cannot tap your foot.",sizeof(text)); break;
	case TELL: strncat(text,"you cannot tell anyone anything.",sizeof(text)); break;
	case THANK: strncat(text,"you cannot thank anyone.",sizeof(text)); break;
	case THINK: strncat(text,"you cannot think.",sizeof(text)); break;
	case THROW: strncat(text,"you cannot throw anyone.",sizeof(text)); break;
	case THWAP: strncat(text,"you cannot thwap anyone.",sizeof(text)); break;
	case TICKLE: strncat(text,"you cannot tickle anyone.",sizeof(text)); break;
	case TICTACTOE: strncat(text,"you cannot play tic tac toe.",sizeof(text)); break;
	case TIMEDIFF: strncat(text,"you cannot set your time difference.",sizeof(text)); break;
	case TINKLE: strncat(text,"you cannot use the bathroom.",sizeof(text)); break;
	case TOPIC: strncat(text,"you cannot set the topic.",sizeof(text)); break;
	case TOPICALL: strncat(text,"you cannot set the topic in all the rooms.",sizeof(text)); break;
	case TORNADO: strncat(text,"you cannot tornado.",sizeof(text)); break;
	case TRIGGER: strncat(text,"you cannot do anything with triggers.",sizeof(text)); break;
	case TXT: strncat(text,"you cannot read any text files.",sizeof(text)); break;
	case UNARREST: strncat(text,"you cannot unarrest anyone.",sizeof(text)); break;
	case UNBAKE: strncat(text,"you cannot unbake a user.",sizeof(text)); break;
	case UNBAN: strncat(text,"you cannot unban anyone.",sizeof(text)); break;
	case UNBOUNCE: strncat(text,"you cannot unbounce anyone.",sizeof(text)); break;
	case UNDARK: strncat(text,"you cannot let anyone see the light.",sizeof(text)); break;
	case UNDRAG: strncat(text,"you cannot undrag anyone.",sizeof(text)); break;
	case UNFREEZE: strncat(text,"you cannot unfreeze anyone.",sizeof(text)); break;
	case UNFREEZEALL: strncat(text,"you cannot unfreeze everyone.",sizeof(text)); break;
	case UNLOCK: strncat(text,"you cannot unlock anyone's account.",sizeof(text)); break;
	case UNMUZZLE: strncat(text,"you cannot unmuzzle anyone.",sizeof(text)); break;
	case UNRESPAWN: strncat(text,"you cannot unrespawn anyone.",sizeof(text)); break;
	case UNSTALK: strncat(text,"you cannot unstalk anyone.",sizeof(text)); break;
	case VACATION: strncat(text,"you cannot enter a vacation message.",sizeof(text)); break;
	case VANITY: strncat(text,"you cannot play Vanity Chase.",sizeof(text)); break;
	case VIOLIN: strncat(text,"you cannot play the violin for anyone.",sizeof(text)); break;
	case WAKE: strncat(text,"you cannot wake anyone.",sizeof(text)); break;
	case WARN: strncat(text,"you cannot warn anyone.",sizeof(text)); break;
	case WAVE: strncat(text,"you cannot wave to anyone.",sizeof(text)); break;
	case WELCOME: strncat(text,"you cannot welcome anyone.",sizeof(text)); break;
	case WHISTLE: strncat(text,"you cannot whistle.",sizeof(text)); break;
	case WHO: strncat(text,"you cannot see who is on.",sizeof(text)); break;
	case WHOBTG: strncat(text,"you cannot whobtg.",sizeof(text)); break;
	case WHOIS: strncat(text,"you cannot whois.",sizeof(text)); break;
	case WHYME: strncat(text,"you don't need to know why you.",sizeof(text)); break;
	case WIPE: strncat(text,"you cannot wipe the message board.",sizeof(text)); break;
	case WIPEALL: strncat(text,"you cannot wipe all the message boards.",sizeof(text)); break;
	case WIZEMOTE: strncat(text,"you cannot wizemote.",sizeof(text)); break;
	case WIZHELP: strncat(text,"you cannot see the wiz commands.",sizeof(text)); break;
	case WIZSHOUT: strncat(text,"you cannot wizshout.",sizeof(text)); break;
	case WLOOK: strncat(text,"you cannot look at another room.",sizeof(text)); break;
	case WRITE: strncat(text,"you cannot write on the board.",sizeof(text)); break;
	case WRITEALL: strncat(text,"you cannot write on all the boards.",sizeof(text)); break;
	case YAHTZEE: strncat(text,"you cannot play yahtzee.",sizeof(text)); break;
	case YIPPEE: strncat(text,"you cannot be that happy.",sizeof(text)); break;
	default: strncat(text,"go away.",sizeof(text));
	}
strncat(text,"\n",sizeof(text));
write_user(user,text);
}

/*** See if user is being ignored ***/
int user_ignored(user,user2)
UR_OBJECT user,user2;
{
char filename[FILENAME_LEN],line[82];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.I",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (!strcmp(line,user2->name)) { fclose(fp); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
return 0;
}

/*** Check if user wants to autohide ***/
int check_autohide(user,site)
UR_OBJECT user;
char *site;
{
char filename[FILENAME_LEN],line[82],*s;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.S",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
if (!(s=(char *)malloc(strlen(site)+1))) { fclose(fp); return 0; }
strcpy(s,site);
strtolower(s);
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (instr(s,line)) { fclose(fp); free(s); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
free(s);
return 0;
}

/*** Check if site is special ***/
int check_specialsite(site)
char *site;
{
char filename[FILENAME_LEN],line[82],*s;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/specialsites",DATAFILES);
if (!(fp=fopen(filename,"r"))) return 0;
if (!(s=(char *)malloc(strlen(site)+1))) { fclose(fp); return 0; }
strcpy(s,site);
strtolower(s);
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (instr(s,line)) { fclose(fp); free(s); return 1; }
	fscanf(fp,"%s",line);
	}
fclose(fp);
free(s);
return 0;
}

/*** See if user is special ***/
int special(name,which)
char *name;
int which;
{
char filename[FILENAME_LEN],line[82];
FILE *fp;

if (!which) snprintf(filename,sizeof(filename),"%s/special",DATAFILES);
else snprintf(filename,sizeof(filename),"%s/special2",DATAFILES);
if (!(fp=fopen(filename,"r"))) return 0;
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (!strcmp(line,name)) {  fclose(fp);  return 1;  }
	fscanf(fp,"%s",line);
	}
fclose(fp);
return 0;
}

/*** See if command has been granted ***/
int command_granted(user,comname)
UR_OBJECT user;
char *comname;
{
char filename[FILENAME_LEN],line[82];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.C",USERFILES,user->name);
if ((fp=fopen(filename,"r"))) {
	fscanf(fp,"%s",line);
	while(!feof(fp)) {
		if (!strcmp(line,comname)) {  fclose(fp);  return 1;  }
		fscanf(fp,"%s",line);
		}
	fclose(fp);
	}
return 0;
}

/*** See if command has been disabled ***/
int command_disabled(user,comname,which)
UR_OBJECT user;
char *comname;
int which;
{
char filename[FILENAME_LEN],line[82];
FILE *fp;

if (!which) snprintf(filename,sizeof(filename),"%s/%s.G",USERFILES,user->name);
else snprintf(filename,sizeof(filename),"%s/nocommands",DATAFILES);
if ((fp=fopen(filename,"r"))) {
	fscanf(fp,"%s",line);
	while(!feof(fp)) {
		if (!strcmp(line,comname) || (which && !strcmp(line,"all") && strcmp(comname,"/stop"))) {  fclose(fp);  return 1;  }
		fscanf(fp,"%s",line);
		}
	fclose(fp);
	}
return 0;
}

/*** Attempt to get '\n' terminated line of input from a character
     mode client else store data read so far in user buffer ***/
int get_charclient_line(user,str,len)
UR_OBJECT user;
char *str;
int len;
{
int i;

for(i=0;i<len;++i) {
	if (str[i]==8 || str[i]==127) {
		if (user->buffpos) {
			--user->buffpos;
			if (user->charmode_echo) write_user(user,"\b \b");
			}
		continue;
		}
	user->buff[user->buffpos]=str[i];
	if (str[i]<32 || user->buffpos+2==ARR_SIZE) {
		terminate(user->buff);
		sntrncpy(str,user->buff,ARR_SIZE);
		if (user->charmode_echo) write_user(user,"\n");
		return 1;
		}
	++user->buffpos;
	}
if (user->charmode_echo && ((user->login!=2 && user->login!=3) || password_echo))
	write(user->socket,str,len);
return 0;
}

/*** Searches string s1 for string s2 ***/
int instr(s1,s2)
char *s1,*s2;
{
int f,g;

for(f=0;*(s1+f);++f) {
	for(g=0;;++g) {
		if (!*(s2+g) && g) return 1;
		if (*(s2+g)!=*(s1+f+g)) break;
		}
	}
return 0;
}

/*** Put string terminate char. at first char < 32 ***/
void terminate(str)
char *str;
{
char *s=str;

while(*s) { if (*s<32) { *s='\0'; return; } ++s; }
}

/*** Get words from sentence. This function prevents the words in the
     sentence from writing off the end of a word array element. This is
     difficult to do with sscanf() hence I use this function instead ***/
int wordfind(str)
char *str;
{
int wn=0,wpos=0;

do {
	while(*str<33) if (!*str++) return wn;
	while(*str>32 && wpos<WORD_LEN-1) {
		word[wn][wpos]=*str++;  ++wpos;
		}
	word[wn++][wpos]='\0'; wpos=0;
	} while(wn<MAX_WORDS);
return wn-1;
}

/*** Clear word array ***/
void clear_words()
{
int w;

for(w=0;w<MAX_WORDS;++w) word[w][0]='\0';
word_count=0;
}


/************ PARSE CONFIG FILE ************/
void load_and_parse_config()
{
char c,filename[FILENAME_LEN],line[82];
int got_init=0,got_rooms=0,i,section_in=0;
FILE *fp;
NL_OBJECT nl;
RM_OBJECT room1,room2;

printf("Parsing config file...\n");
if (!(fp=fopen(confile,"r"))) {
	perror("BOOT ERROR: Can't open config file");  boot_exit(1);
	}
config_line=0;
fgets(line,sizeof(line),fp);
while(!feof(fp)) {
	++config_line;
	for(i=0;i<8;++i) wrd[i][0]='\0';
	sscanf(line,"%s %s %s %s %s %s %s %s",wrd[0],wrd[1],wrd[2],wrd[3],wrd[4],wrd[5],wrd[6],wrd[7]);
	if (wrd[0][0]=='#' || !wrd[0][0]) { fgets(line,sizeof(line),fp);  continue; }
	if (wrd[0][strlen(wrd[0])-1]==':') {
		if (!strcmp(wrd[0],"INIT:")) section_in=1;
		else if (!strcmp(wrd[0],"ROOMS:")) section_in=2;
		else if (!strcmp(wrd[0],"SITES:")) section_in=3;
		else {
			fclose(fp);
			fprintf(stderr,"BOOT ERROR: Unknown section header on line %d.\n",config_line);
			boot_exit(1);
			}
		}
	switch(section_in) {
		case 1: parse_init_section(); got_init=1; break;
		case 2: parse_rooms_section(); got_rooms=1; break;
		case 3: parse_sites_section(); break;
		default:
			fclose(fp);
			fprintf(stderr,"BOOT ERROR: Section header expected on line %d.\n",config_line);
			boot_exit(1);
		}
	fgets(line,sizeof(line),fp);
	}
fclose(fp);
if (!got_init) {
	fprintf(stderr,"BOOT ERROR: INIT section missing from config file.\n");
	boot_exit(1);
	}
else if (!got_rooms) {
	fprintf(stderr,"BOOT ERROR: ROOMS section missing from config file.\n");
	boot_exit(1);
	}
else if (!verification[0]) {
	fprintf(stderr,"BOOT ERROR: Verification not set in config file.\n");
	boot_exit(1);
	}
else if (!port[0]) {
	fprintf(stderr,"BOOT ERROR: Main port number not set in config file.\n");
	boot_exit(1);
	}
else if (!port[1]) {
	fprintf(stderr,"BOOT ERROR: Wiz port number not set in config file.\n");
	boot_exit(1);
	}
else if (!port[2]) {
	fprintf(stderr,"BOOT ERROR: Talk port number not set in config file.\n");
	boot_exit(1);
	}
else if (!port[3]) {
	fprintf(stderr,"BOOT ERROR: Link port number not set in config file.\n");
	boot_exit(1);
	}
else if (port[0]==port[1] || port[1]==port[2] || port[0]==port[2] || port[3]==port[0] || port[1]==port[3] || port[3]==port[2]) {
	fprintf(stderr,"BOOT ERROR: Port numbers must be unique.\n");
	boot_exit(1);
	}
else if (!room_first) {
	fprintf(stderr,"BOOT ERROR: No rooms configured in config file.\n");
	boot_exit(1);
	}
for(room1=room_first;room1;room1=room1->next) {
	for(i=0;i<MAX_LINKS;++i) {
		if (!room1->link_label[i][0]) break;
		for(room2=room_first;room2;room2=room2->next) {
			if (room1==room2) continue;
			if (!strcmp(room1->link_label[i],room2->label)) {
				room1->link[i]=room2;  break;
				}
			}
		if (!room1->link[i]) {
			fprintf(stderr,"BOOT ERROR: Room %s has undefined link label '%s'.\n",room1->name,room1->link_label[i]);
			boot_exit(1);
			}
		}
	}
for(room1=room_first;room1;room1=room1->next) {
	for(nl=nl_first;nl;nl=nl->next) {
		if (!strcmp(nl->service,room1->name)) {
			fprintf(stderr,"BOOT ERROR: Service name %s is also the name of a room.\n",nl->service);
			boot_exit(1);
			}
		if (room1->netlink_name[0] && !strcmp(room1->netlink_name,nl->service)) {
			room1->netlink=nl;  break;
			}
		}
	if (room1->netlink_name[0] && !room1->netlink) {
		fprintf(stderr,"BOOT ERROR: Service name %s not defined for room %s.\n",room1->netlink_name,room1->name);
		boot_exit(1);
		}
	}
for(room1=room_first;room1;room1=room1->next) {
	snprintf(filename,sizeof(filename),"%s/%s.R",DATAFILES,room1->name);
	if (!(fp=fopen(filename,"r"))) {
		fprintf(stderr,"BOOT ERROR: Can't open description file for room %s.\n",room1->name);
		snprintf(text,sizeof(text),"Couldn't open description file for room %s.\n",room1->name);
		write_syslog(text,1);
		continue;
		}
	i=0;
	c=getc(fp);
	while(!feof(fp)) {
		if (i==ROOM_DESC_LEN) {
			fprintf(stderr,"BOOT ERROR: Description too long for room %s.\n",room1->name);
			snprintf(text,sizeof(text),"Description too long for room %s.\n",room1->name);
			write_syslog(text,1);
			break;
			}
		room1->desc[i]=c; c=getc(fp); ++i;
		}
	room1->desc[i]='\0';
	fclose(fp);
	sntrncpy(room1->topic,"*** Welcome to Hole ***",sizeof(room1->topic));
/*	if (rand()%3==2) annoy_topic(room1->topic); */
	}
}

/*** Parse init section ***/
void parse_init_section()
{
char *options[]={"mainport","wizport","talkport","linkport","atmos","auto_connect","ban_swearing","color_def","crash_action","difflogin","gatecrash_level","heartbeat","hehehe","hour","ignore_mp_level","ignore_sigterm","login_idle_time","max_clones","max_users","mesg_check_time","mesg_life","minlogin_level","min_private","nologin","password_echo","prompt_def","rem_user_deflevel","rem_user_maxlevel","system_logging","time_out_afks","user_idle_time","verification","whologin","wizport_level","*"};
int op=0,val;
static int in_section=0;

if (!strcmp(wrd[0],"INIT:")) {
	if (++in_section>1) {
		fprintf(stderr,"BOOT ERROR: Unexpected INIT section header on line %d.\n",config_line);
		boot_exit(1);
		}
	return;
	}
while(strcmp(options[op],wrd[0])) {
	if (options[op][0]=='*') {
		fprintf(stderr,"BOOT ERROR: Unknown INIT option on line %d.\n",config_line);
		boot_exit(1);
		}
	++op;
	}
if (!wrd[1][0]) {
	fprintf(stderr,"BOOT ERROR: Required parameter missing on line %d.\n",config_line);
	boot_exit(1);
	}
else if (wrd[2][0] && wrd[2][0]!='#') {
	fprintf(stderr,"BOOT ERROR: Unexpected word following init parameter on line %d.\n",config_line);
	boot_exit(1);
	}
val=atoi(wrd[1]);
switch(op) {
	case 0:
	case 1:
	case 2:
	case 3:
		if ((port[op]=val)<1 || val>65535) {
			fprintf(stderr,"BOOT ERROR: Illegal port number on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 4:
		if ((atmos=onoff_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Atmos must be ON or OFF on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 5:
		if ((auto_connect=yn_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Auto_connect must be YES or NO on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 6:
		if ((ban_swearing=yn_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Ban_swearing must be YES or NO on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 7:
		if ((color_def=onoff_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Color_def must be ON or OFF on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 8:
		if (!strcmp(wrd[1],"NONE")) crash_action=0;
		else if (!strcmp(wrd[1],"IGNORE")) crash_action=1;
		else if (!strcmp(wrd[1],"REBOOT")) crash_action=2;
		else {
			fprintf(stderr,"BOOT ERROR: Crash_action must be NONE, IGNORE or REBOOT on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 9:
		if ((difflogin=onoff_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Difflogin must be ON or OFF on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 10:
		if ((gatecrash_level=get_level(wrd[1],0))==-1) {
			fprintf(stderr,"BOOT ERROR: Unknown level specifier on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 11:
		if ((heartbeat=val)<1) {
			fprintf(stderr,"BOOT ERROR: Invalid value for heartbeat on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 12:
		if ((hehehe=onoff_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Hehehe must be ON or OFF on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 13:
		if ((hour=onoff_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Hour must be ON or OFF on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 14:
		if ((ignore_mp_level=get_level(wrd[1],0))==-1) {
			fprintf(stderr,"BOOT ERROR: Unknown level specifier on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 15:
		if ((ignore_sigterm=yn_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Ignore_sigterm must be YES or NO on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 16:
		if ((login_idle_time=val)<10) {
			fprintf(stderr,"BOOT ERROR: Invalid value for login_idle_time on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 17:
		if ((max_clones=val)<0) {
			fprintf(stderr,"BOOT ERROR: Invalid value for max_clones on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 18:
		if ((max_users=val)<1) {
			fprintf(stderr,"BOOT ERROR: Invalid value for max_users on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 19:
		if (wrd[1][2]!=':' || strlen(wrd[1])>5 || !isdigit(wrd[1][0]) || !isdigit(wrd[1][1]) || !isdigit(wrd[1][3]) || !isdigit(wrd[1][4])) {
			fprintf(stderr,"BOOT ERROR: Invalid time on line %d.\n",config_line);
			boot_exit(1);
			}
		wrd[1][2]=' ';
		sscanf(wrd[1],"%d %d",&mesg_check_hour,&mesg_check_min);
		if (mesg_check_hour>23 || mesg_check_min>59) {
			fprintf(stderr,"BOOT ERROR: Invalid time on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 20:
		if ((mesg_life=val)<1) {
			fprintf(stderr,"BOOT ERROR: Illegal message lifetime on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 21:
		if ((minlogin_level=get_level(wrd[1],0))==-1) {
			if (strcmp(wrd[1],"NONE")) {
				fprintf(stderr,"BOOT ERROR: Unknown level specifier on line %d.\n",config_line);
				boot_exit(1);
				}
			minlogin_level=-1;
			}
		break;
	case 22:
		if (val<1) {
			fprintf(stderr,"BOOT ERROR: Number too low on line %d.\n",config_line);
			boot_exit(1);
			}
		min_private_users=val;
		break;
	case 23:
		if ((nologin=onoff_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Nologin must be ON or OFF on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 24:
		if ((password_echo=yn_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Password_echo must be YES or NO on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 25:
		if ((prompt_def=onoff_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Prompt_def must be ON or OFF on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 26:
		if ((rem_user_deflevel=get_level(wrd[1],0))==-1) {
			fprintf(stderr,"BOOT ERROR: Unknown level specifier on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 27:
		if ((rem_user_maxlevel=get_level(wrd[1],0))==-1) {
			fprintf(stderr,"BOOT ERROR: Unknown level specifier on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 28:
		if ((system_logging=yn_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: System_logging must be YES or NO on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 29:
		if ((time_out_afks=yn_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Time_out_afks must be YES or NO on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 30:
		if ((user_idle_time=val)<10) {
			fprintf(stderr,"BOOT ERROR: Invalid value for user_idle_time on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 31:
		if (strlen(wrd[1])>SERV_NAME_LEN) {
			fprintf(stderr,"BOOT ERROR: Verification too long on line %d.\n",config_line);
			boot_exit(1);
			}
		sntrncpy(verification,wrd[1],sizeof(verification));
		break;
	case 32:
		if ((whologin=onoff_check(wrd[1]))==-1) {
			fprintf(stderr,"BOOT ERROR: Whologin must be ON or OFF on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	case 33:
		if ((wizport_level=get_level(wrd[1],0))==-1) {
			fprintf(stderr,"BOOT ERROR: Unknown level specifier on line %d.\n",config_line);
			boot_exit(1);
			}
		break;
	}
}

/*** Parse rooms section ***/
void parse_rooms_section()
{
char c,*ptr1,*ptr2;
int i=0;
static int in_section=0;
RM_OBJECT room;

if (!strcmp(wrd[0],"ROOMS:")) {
	if (++in_section>1) {
		fprintf(stderr,"BOOT ERROR: Unexpected ROOMS section header on line %d.\n",config_line);
		boot_exit(1);
		}
	return;
	}
else if (!wrd[2][0]) {
	fprintf(stderr,"BOOT ERROR: Required parameter(s) missing on line %d.\n",config_line);
	boot_exit(1);
	}
else if (strlen(wrd[0])>ROOM_LABEL_LEN) {
	fprintf(stderr,"BOOT ERROR: Room label too long on line %d.\n",config_line);
	boot_exit(1);
	}
else if (strlen(wrd[1])>ROOM_NAME_LEN) {
	fprintf(stderr,"BOOT ERROR: Room name too long on line %d.\n",config_line);
	boot_exit(1);
	}
for(room=room_first;room;room=room->next) {
	if (!strcmp(room->label,wrd[0])) {
		fprintf(stderr,"BOOT ERROR: Duplicate room label on line %d.\n",config_line);
		boot_exit(1);
		}
	if (!strcmp(room->name,wrd[1])) {
		fprintf(stderr,"BOOT ERROR: Duplicate room name on line %d.\n",config_line);
		boot_exit(1);
		}
	}
if (!(room=create_room())) {
	write_syslog("ERROR: Unable to create room object in parse_rooms_section().\n",0);
	boot_exit(1);
	}
sntrncpy(room->label,wrd[0],sizeof(room->label));
sntrncpy(room->name,wrd[1],sizeof(room->name));
ptr1=wrd[2];
ptr2=wrd[2];
while(1) {
	while(*ptr2 && *ptr2!=',') ++ptr2;
	if (*ptr2==',' && !*(ptr2+1)) {
		fprintf(stderr,"BOOT ERROR: Missing link label on line %d.\n",config_line);
		boot_exit(1);
		}
	c=*ptr2;  *ptr2='\0';
	if (!strcmp(ptr1,room->label)) {
		fprintf(stderr,"BOOT ERROR: Room has a link to itself on line %d.\n",config_line);
		boot_exit(1);
		}
	sntrncpy(room->link_label[i],ptr1,sizeof(room->link_label[i]));
	if (!c) break;
	if (++i>=MAX_LINKS) {
		fprintf(stderr,"BOOT ERROR: Too many links on line %d.\n",config_line);
		boot_exit(1);
		}
	*ptr2=c;
	ptr1=++ptr2;
	}
if (wrd[3][0]=='#') {  room->access=PUBLIC;  return;  }
if (isnumber(wrd[3])) {
	room->level=atoi(wrd[3]);
	if (!wrd[4][0] || !strcmp(wrd[4],"BOTH")) room->access=PUBLIC;
	else if (!strcmp(wrd[4],"PUB")) room->access=FIXED_PUBLIC;
	else if (!strcmp(wrd[4],"PRIV")) room->access=FIXED_PRIVATE;
	else if (!strcmp(wrd[4],"HID")) room->access=HIDDEN;
	else {
		fprintf(stderr,"BOOT ERROR: Unknown room access type on line %d.\n",config_line);
		boot_exit(1);
		}
	}
else if (!wrd[3][0] || !strcmp(wrd[3],"BOTH")) room->access=PUBLIC;
else if (!strcmp(wrd[3],"PUB")) room->access=FIXED_PUBLIC;
else if (!strcmp(wrd[3],"PRIV")) room->access=FIXED_PRIVATE;
else if (!strcmp(wrd[3],"HID")) room->access=HIDDEN;
else {
	fprintf(stderr,"BOOT ERROR: Unknown room access type on line %d.\n",config_line);
	boot_exit(1);
	}
if (!wrd[4][0] || wrd[4][0]=='#') return;
if (!strcmp(wrd[4],"ACCEPT")) {
	if (wrd[5][0] && wrd[5][0]!='#') {
		fprintf(stderr,"BOOT ERROR: Unexpected word following ACCEPT keyword on line %d.\n",config_line);
		boot_exit(1);
		}
	room->inlink=1;
	return;
	}
else if (!strcmp(wrd[5],"ACCEPT")) {
	if (wrd[6][0] && wrd[6][0]!='#') {
		fprintf(stderr,"BOOT ERROR: Unexpected word following ACCEPT keyword on line %d.\n",config_line);
		boot_exit(1);
		}
	room->inlink=1;
	return;
	}
if (!strcmp(wrd[4],"CONNECT")) {
	if (!wrd[5][0]) {
		fprintf(stderr,"BOOT ERROR: External link name missing on line %d.\n",config_line);
		boot_exit(1);
		}
	if (wrd[6][0] && wrd[6][0]!='#') {
		fprintf(stderr,"BOOT ERROR: Unexpected word following external link name on line %d.\n",config_line);
		boot_exit(1);
		}
	sntrncpy(room->netlink_name,wrd[5],sizeof(room->netlink_name));
	return;
	}
else if (!strcmp(wrd[5],"CONNECT")) {
	if (!wrd[6][0]) {
		fprintf(stderr,"BOOT ERROR: External link name missing on line %d.\n",config_line);
		boot_exit(1);
		}
	if (wrd[7][0] && wrd[7][0]!='#') {
		fprintf(stderr,"BOOT ERROR: Unexpected word following external link name on line %d.\n",config_line);
		boot_exit(1);
		}
	sntrncpy(room->netlink_name,wrd[6],sizeof(room->netlink_name));
	return;
	}
if (isnumber(wrd[4])) { room->level=atoi(wrd[4]); return; }
fprintf(stderr,"BOOT ERROR: Unknown connection option on line %d.\n",config_line);
boot_exit(1);
}

/*** Parse sites section ***/
void parse_sites_section()
{
static int in_section=0;
NL_OBJECT nl;

if (!strcmp(wrd[0],"SITES:")) {
	if (++in_section>1) {
		fprintf(stderr,"BOOT ERROR: Unexpected SITES section header on line %d.\n",config_line);
		boot_exit(1);
		}
	return;
	}
else if (!wrd[3][0]) {
	fprintf(stderr,"BOOT ERROR: Required parameter(s) missing on line %d.\n",config_line);
	boot_exit(1);
	}
else if (strlen(wrd[0])>SERV_NAME_LEN) {
	fprintf(stderr,"BOOT ERROR: Link name length too long on line %d.\n",config_line);
	boot_exit(1);
	}
else if (strlen(wrd[3])>SERV_NAME_LEN) {
	fprintf(stderr,"BOOT ERROR: Verification too long on line %d.\n",config_line);
	boot_exit(1);
	}
else if (!(nl=create_netlink())) {
	fprintf(stderr,"BOOT ERROR: Memory allocation failure creating netlink on line %d.\n",config_line);
	boot_exit(1);
	}
if (!wrd[4][0] || wrd[4][0]=='#' || !strcmp(wrd[4],"ALL")) nl->allow=ALL;
else if (!strcmp(wrd[4],"IN")) nl->allow=IN;
else if (!strcmp(wrd[4],"OUT")) nl->allow=OUT;
else {
	fprintf(stderr,"BOOT ERROR: Unknown netlink access type on line %d.\n",config_line);
	boot_exit(1);
	}
if ((nl->port=atoi(wrd[2]))<1 || nl->port>65535) {
	fprintf(stderr,"BOOT ERROR: Illegal port number on line %d.\n",config_line);
	boot_exit(1);
	}
sntrncpy(nl->service,wrd[0],sizeof(nl->service));
strtolower(wrd[1]);
sntrncpy(nl->site,wrd[1],sizeof(nl->site));
sntrncpy(nl->verification,wrd[3],sizeof(nl->verification));
}

/*** Yes/no check ***/
int yn_check(str)
char *str;
{
if (!strcmp(str,"YES")) return 1;
else if (!strcmp(str,"NO")) return 0;
return -1;
}

/*** On/off check ***/
int onoff_check(str)
char *str;
{
if (!strcmp(str,"ON")) return 1;
else if (!strcmp(str,"OFF")) return 0;
return -1;
}


/************ INITIALIZATION FUNCTIONS *************/

/*** Initialize global variables ***/
void init_globals()
{
allcolor[0]='\0';
annoystring[0]='\0';
atmos=0;
auto_connect=1;
ban_games=0;
ban_greets=0;
ban_hunting=0;
ban_pictells=0;
ban_quitting=0;
ban_shouting=0;
ban_smailing=0;
ban_smoking=0;
ban_socials=0;
ban_suicides=1;
ban_swearing=0;
ban_willkill=1;
bigcatstage=0;
bigcattime=time(0);
clear_words();
color_def=1;
crash_action=2;
cron_check_hour=0;
cron_check_min=0;
croncom[0]='\0';
crononce=0;
cronset=0;
cronuser[0]='\0';
difflogin=0;
garbled=0;
gatecrash_level=GENERAL+1;
goingdown1=time(0);
goingdown2=0;
goingdown3=0;
goingdown4=0;
goingdown=0;
gossamer=0;
heartbeat=2;
hehehe=0;
hour=1;
ignore_mp_level=COMMANDER;
ignore_sigterm=0;
keepalive_interval=60;
killem[0]='\0';
login_idle_time=180;
loginplace=0;
lplace=0;
max_clones=1;
max_users=40;
mesg_check_hour=0;
mesg_check_min=0;
mesg_life=1;
midnight=0;
midnighthour=0;
min_private_users=2;
minlogin_level=-1;
motd[0]='\0';
net_idle_time=300;
nl_first=NULL;
nl_last=NULL;
nologin=0;
num_of_logins=0;
num_of_users=0;
password_echo=0;
port[0]=0;
port[1]=0;
port[2]=0;
port[3]=0;
prompt_def=1;
rem_user_deflevel=CORPORAL;
rem_user_maxlevel=CORPORAL;
room_first=NULL;
room_last=NULL;
staythere=0;
sys_mail=1;
system_logging=1;
tempstore=0;
time(&boot_time);
time_out_afks=0;
user_first=NULL;
user_idle_time=300;
user_last=NULL;
verification[0]='\0';
whologin=0;
willkill=0;
wizport_level=COLONEL;
}

/*** Initialize the signal traps etc ***/
void init_signals()
{
signal(SIGTERM,sig_handler);
signal(SIGSEGV,sig_handler);
signal(SIGBUS,sig_handler);
signal(SIGILL,SIG_IGN);
signal(SIGTRAP,SIG_IGN);
signal(SIGIOT,SIG_IGN);
signal(SIGTSTP,SIG_IGN);
signal(SIGCONT,SIG_IGN);
signal(SIGHUP,SIG_IGN);
signal(SIGINT,SIG_IGN);
signal(SIGQUIT,SIG_IGN);
signal(SIGABRT,SIG_IGN);
signal(SIGFPE,SIG_IGN);
signal(SIGPIPE,SIG_IGN);
signal(SIGTTIN,SIG_IGN);
signal(SIGTTOU,SIG_IGN);
}

/*** Some signal trapping functions ***/
void sig_handler(sig)
int sig;
{
char name[USER_NAME_LEN+1];
UR_OBJECT user;

force_listen=1;
switch(sig) {
	case SIGTERM:
		if (ignore_sigterm) {
			write_syslog("SIGTERM signal received - ignoring.\n",1);
			return;
			}
		write_room(NULL,"\n\n~OLSYSTEM:~RS SIGTERM received, initiating shutdown.\n\n");
		talker_shutdown(NULL,"a termination signal (SIGTERM)",0);
		break;
	case SIGSEGV:
		switch(crash_action) {
			case 0:
				write_room(NULL,"\n\n\07~OLSYSTEM:~RS EEKS - A happy bunny error has just occurred, initiating shutdown!\n\n");
				talker_shutdown(NULL,"a segmentation fault (SIGSEGV)",0);
				break;
			case 1:
				write_room(NULL,"\n\n\07~OLSYSTEM:~RS UHOH - A happy bunny error has just occurred!\n\n");
				write_syslog("WARNING: A segmentation fault occurred!\n",1);
				sntrncpy(name,"Lilmouse",sizeof(name));
				if ((user=get_user(name,0))) {
					sntrncpy(word[1],"reboot",sizeof(word[1]));
					sntrncpy(word[2],"1",sizeof(word[2]));
					word_count=3;
					going_down(user);
					--word_count;
					if (!command_disabled(user,"all",1)) {
						sntrncpy(word[1],"all",sizeof(word[1]));
						stop_command(user);
						}
					sntrncpy(word[1],"crater",sizeof(word[1]));
					moveall(user);
					longjmp(jmpvar,0);
					}
				else ++crash_action;
			case 2:
				write_room(NULL,"\n\n\07~OLSYSTEM:~RS EEKS - Happy bunny error, initiating reboot!\n\n");
				talker_shutdown(NULL,"a segmentation fault (SIGSEGV)",1);
			}
		break;
	case SIGBUS:
		switch(crash_action) {
			case 0:
				write_room(NULL,"\n\n\07~OLSYSTEM:~RS EEKS - Woohoo error, initiating shutdown!\n\n");
				talker_shutdown(NULL,"a bus error (SIGBUS)",0);
				break;
			case 1:
				write_room(NULL,"\n\n\07~OLSYSTEM:~RS UHOH - A woohoo error has just occurred!\n\n");
				write_syslog("WARNING: A bus error occurred!\n",1);
				longjmp(jmpvar,0);
			case 2:
				write_room(NULL,"\n\n\07~OLSYSTEM:~RS EEKS - Woohoo error, initiating reboot!\n\n");
				talker_shutdown(NULL,"a bus error (SIGBUS)",1);
			}
		break;
	}
}

/*** Initialize sockets on ports ***/
void init_sockets()
{
int i,on=1,size=sizeof(struct sockaddr_in);
struct sockaddr_in bind_addr;

bind_addr.sin_family=AF_INET;
bind_addr.sin_addr.s_addr=INADDR_ANY;
printf("Initializing sockets on ports: ");
for(i=0;i<4;++i) {
	printf("%d ",port[i]); fflush(stdout);
	if ((listen_sock[i]=socket(AF_INET,SOCK_STREAM,0))==-1) {
		write_syslog("BOOT ERROR: Can't open a listen socket.\n",0);
		perror("\nERROR: Can't open a listen socket");
		exit(1);
		}
	setsockopt(listen_sock[i],SOL_SOCKET,SO_REUSEADDR,(char *)&on,sizeof(on));
	bind_addr.sin_port=htons(port[i]);
	if (bind(listen_sock[i],(struct sockaddr *)&bind_addr,size)==-1) {
		write_syslog("BOOT ERROR: Can't bind to port.\n",0);
		perror("\nERROR: Can't bind to port");
		exit(1);
		}
	if (listen(listen_sock[i],20)==-1) {
		write_syslog("BOOT ERROR: Listen error on port.\n",0);
		perror("\nERROR: Listen error on port");
		exit(1);
		}
	fcntl(listen_sock[i],F_SETFL,O_NDELAY);
	}
putchar('\n');
}

/*** Write PID to a file for easy killing purposes ***/
void write_pid()
{
FILE *fp;

if (!(fp=fopen(HOLE_PIDFILE,"w"))) {
	printf("Error writing to pid file %s\n",HOLE_PIDFILE);
	return;
	}
fprintf(fp,"%d\n",getpid());
fclose(fp);
}

/*** Check to see if certain programs are installed on the system.
     If not, warn them ***/
void check_programs()
{
FILE *fp;

printf("Checking for ispell... ");
if (!(fp=fopen("/bin/ispell","r"))) {
	if (!(fp=fopen("/usr/bin/ispell","r"))) {
		if (!(fp=fopen("/usr/local/bin/ispell","r"))) printf("\nIt seems you don't have ispell installed on this system or the path to it\nis incorrect. The spell command will not function properly without it.\n");
		else { fclose(fp); printf("Ispell found in /usr/local/bin.\n"); }
		}
	else { fclose(fp); printf("Ispell found in /usr/bin.\n"); }
	}
else { fclose(fp); printf("Ispell found in /bin.\n"); }
printf("Checking for mail..... Not email, the mail program. ");
if (!(fp=fopen("/bin/mail","r"))) {
	if (!(fp=fopen("/usr/bin/mail","r"))) {
		if (!(fp=fopen("/usr/local/bin/mail","r"))) printf("\nIt seems you don't have mail installed on this system or the path to it\nis incorrect. There are a few functions that will not work properly\nwithout it.\n");
		else { fclose(fp); printf("Mail found in /usr/local/bin.\n"); }
		}
	else { fclose(fp); printf("Mail found in /usr/bin.\n"); }
	}
else { fclose(fp); printf("Mail found in /bin.\n"); }
}

/*** Initialize connections to remote servers. Basically this tries to connect
     to the services listed in the config file and it puts the open sockets in
     the NL_OBJECT linked list which the talker then uses ***/
void init_connections()
{
int cnt=0,ret;
NL_OBJECT nl;
RM_OBJECT room;

printf("Connecting to remote servers... ");
errno=0;
for(room=room_first;room;room=room->next) {
	if (!(nl=room->netlink)) continue;
	errno=0;  ++cnt;
	printf("\n  Trying service %s at %s %d: ",nl->service,nl->site,nl->port);
	if ((ret=connect_to_site(nl))) {
		if (ret) {
			printf("%s.\n",sys_errlist[errno]);
			snprintf(text,sizeof(text),"NETLINK: Failed to connect to service %s: %s.\n",nl->service,sys_errlist[errno]);
			}
		else {
			printf("Unknown hostname.\n");
			snprintf(text,sizeof(text),"NETLINK: Failed to connect to service %s: Unknown hostname.\n",nl->service);
			}
		write_syslog(text,1);
		}
	else {
		printf("CONNECTED.\n");
		snprintf(text,sizeof(text),"NETLINK: Connected to service %s (%s %d).\n",nl->service,nl->site,nl->port);
		write_syslog(text,1);
		nl->connect_room=room;
		}
	}
if (cnt) printf("See system log for any further information.\n");
else printf("No remote connections configured.\n");
}

/*** Do the actual connection ***/
int connect_to_site(nl)
NL_OBJECT nl;
{
unsigned int inetnum;
struct hostent *he;
struct sockaddr_in con_addr;

if (!isnumber(nl->site)) {
	if (!(he=gethostbyname(nl->site))) return 2;
	memcpy((char *)&con_addr.sin_addr,he->h_addr,(size_t)he->h_length);
	}
else {
	if ((inetnum=inet_addr(nl->site))==-1) return 1;
	memcpy((char *)&con_addr.sin_addr,(char *)&inetnum,(size_t)sizeof(inetnum));
	}
if ((nl->socket=socket(AF_INET,SOCK_STREAM,0))==-1) return 1;
con_addr.sin_family=AF_INET;
con_addr.sin_port=htons(nl->port);
signal(SIGALRM,SIG_IGN);
if (connect(nl->socket,(struct sockaddr *)&con_addr,sizeof(con_addr))==-1) {
	reset_alarm();
	return 1;
	}
reset_alarm();
nl->type=OUTGOING;
nl->stage=1;
nl->last_recvd=time(0);
return 0;
}

/*** Check merlyn ***/
int check_merlyn(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],garbage[82],id[82],line[82],name[USER_NAME_LEN+1];
int cnt=0,tm;
FILE *fp;
UR_OBJECT user2;

snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
fgets(line,sizeof(line),fp);
while(!feof(fp)) {
	sscanf(line,"%s %d %s",id,&tm,garbage);
	sntrncpy(name,pt_name(line),sizeof(name));
	if (!strcmp(id,"PT:")) {
		if (!strcmp(name,user->merlyn)) ++cnt;
		fgets(line,sizeof(line),fp);
		}
	fgets(line,sizeof(line),fp);
	}
fclose(fp);
if (cnt) return 1;
if ((user2=get_user2(user,user->merlyn))) return 1;
return 0;
}

/*** Mail a user ***/
void merlynmail(user,done_editing)
UR_OBJECT user;
int done_editing;
{
UR_OBJECT user2;

if (ban_smailing) {
	write_user(user,"Sorry, smailing has been turned off.\n");
	disconnect_user(user);
	return;
	}
if (done_editing) {
	if (ban_swearing && contains_swearing(user->malloc_start)) {
		swore(user);
		return;
		}
	if (nosmail(user->merlyn)) return;
	if ((user2=get_user2(user,user->merlyn))) {
		if (!user2->smail) return;
		if (user_ignored(user2,user)) return;
		}
	else {
		if (!(user2=create_user())) {
			snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Unable to create temporary user session in merlynmail().\n",0);
			return;
			}
		sntrncpy(user2->name,user->merlyn,sizeof(user2->name));
		if (!load_user_details(user2)) {
			destruct_user(user2,0);
			return;
			}
		if (!user2->smail) {
			destruct_user(user2,0);
			return;
			}
		if (user_ignored(user2,user)) {
			destruct_user(user2,0);
			return;
			}
		destruct_user(user2,0);
		}
	send_mail(user,user->merlyn,user->malloc_start,0);
	return;
	}
snprintf(text,sizeof(text),"\n~BB~OL~FY*** Writing mail message to %s ***\n\n",user->merlyn);
write_user(user,text);
user->misc_op=104;
editor(user,NULL);
}

/*** See if user has unread mail ***/
int has_unread_mail(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],id[82],line[82];
int cnt=0,tm;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
fgets(line,sizeof(line),fp);
while(!feof(fp)) {
	sscanf(line,"%s %d",id,&tm);
	if (!strcmp(id,"PT:")) {
		if (tm>(int)user->read_mail) {
			++cnt;
			fgets(line,sizeof(line),fp);
			while(!feof(fp)) {
				sscanf(line,"%s",id);
				if (!strcmp(id,"PT:")) ++cnt;
				fgets(line,sizeof(line),fp);
				}
			fclose(fp);
			return cnt;
			}
		}
	fgets(line,sizeof(line),fp);
	}
fclose(fp);
return 0;
}


/************* WRITE FUNCTIONS ************/

/*** Write a string to a socket ***/
void write_sock(sock,str)
int sock;
char *str;
{
write(sock,str,strlen(str));
}

/*** Send message to user ***/
void write_user(user,str)
UR_OBJECT user;
char *str;
{
char buff[OUT_BUFF_SIZE],mesg[ARR_SIZE],str2[ARR_SIZE];
int buffpos=0,i,j,umm=0;

if (user->room) if (!strcmp(user->room->name,"Dark_room") && user->level<GENERAL) return;
if (user->dark && user->level<GENERAL) return;
if (user->type==REMOTE_TYPE) {
	if (user->netlink->ver_major<=3 && user->netlink->ver_minor<2) str=color_com_strip(str);
	if (str[strlen(str)-1]!='\n') snprintf(mesg,sizeof(mesg),"MSG %s\n%s\nEMSG\n",user->name,str);
	else snprintf(mesg,sizeof(mesg),"MSG %s\n%sEMSG\n",user->name,str);
	write_sock(user->netlink->socket,mesg);
	return;
	}
sntrncpy(str2,str,sizeof(str2));
if (!user->login) {
	if (user->wordwrap && strlen(str)>user->wordwraplen && user->wordwraplen)
		str=wordwrap(str,user->wordwraplen);
	if (garbled) str=garble(str);
	if (name_count(str,0)>3) str=name_strip(str);
	if (!user->printcolors) {
		if (get_color(user,4)) {
			++umm;
			str=color_com_strip(str);
			print_colors(user,0);
			user->colstr[0]='\0';
			}
		if (allcolor[0]) {
			str=color_com_strip(str);
			print_colors(user,1);
			}
		}
	else if (user->annoy) {
		str=color_com_strip(str);
		write_sock(user->socket,"\033[34m\033[40m");
		}
	else if (user->colorize) str=color_com_strip(str);
	else if (user->woohoo) {
		str=color_com_strip(str);
		switch(rand()%3) {
			case 0:	write_sock(user->socket,"\033[5m"); break;
			case 1: write_sock(user->socket,"\033[0m"); break;
			default: write_sock(user->socket,"\033[1m");
			}
		switch(rand()%8) {
			case 0: write_sock(user->socket,"\033[40m"); break;
			case 1: write_sock(user->socket,"\033[41m"); break;
			case 2: write_sock(user->socket,"\033[42m"); break;
			case 3: write_sock(user->socket,"\033[43m"); break;
			case 4: write_sock(user->socket,"\033[44m"); break;
			case 5: write_sock(user->socket,"\033[45m"); break;
			case 6: write_sock(user->socket,"\033[46m"); break;
			case 7: write_sock(user->socket,"\033[47m"); break;
			default: write_sock(user->socket,"\033[40m");
			}
		switch(rand()%8) {
			case 0: write_sock(user->socket,"\033[30m"); break;
			case 1: write_sock(user->socket,"\033[31m"); break;
			case 2: write_sock(user->socket,"\033[32m"); break;
			case 3: write_sock(user->socket,"\033[33m"); break;
			case 4: write_sock(user->socket,"\033[34m"); break;
			case 5: write_sock(user->socket,"\033[35m"); break;
			case 6: write_sock(user->socket,"\033[36m"); break;
			case 7: write_sock(user->socket,"\033[37m"); break;
			default: write_sock(user->socket,"\033[34m");
			}
		}
	if (user->beepline && !user->login) write_sock(user->socket,"\07");
	}
while(*str) {
	j=0;
	if (*str=='\n') {
		if (buffpos>OUT_BUFF_SIZE-6) {
			write(user->socket,buff,buffpos);
			buffpos=0;
			}
		if ((!allcolor[0] && !user->annoy && !user->woohoo && !umm) || user->printcolors || user->login) {
			if (user->color) {
				memcpy(buff+buffpos,"\033[0m",4); buffpos+=4;
				}
			}
		*(buff+buffpos)='\n'; *(buff+buffpos+1)='\r';
		buffpos+=2; ++str;
		}
	else {
		if (*str=='~') {
			if (*(str+1)=='\\') {
				++str;
				if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
					if (buffpos>OUT_BUFF_SIZE-10) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					switch(rand()%2) {
						case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
						default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
						}
					switch(rand()%6) {
						case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
						case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
						case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
						case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
						case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
						case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
						default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
						}
					}
				*(buff+buffpos)=*str++;
				++buffpos;
				continue;
				}
			}
		if (*str=='\\') {
			if (*(str+1)=='~') {
				for(i=0;i<COLNUM;++i) {
					if (!strncmp(str+2,colcom[i],2)) {
						++str;
						if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
							if (buffpos>OUT_BUFF_SIZE-10) {
								write(user->socket,buff,buffpos);
								buffpos=0;
								}
							switch(rand()%2) {
								case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
								default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
								}
							switch(rand()%6) {
								case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
								case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
								case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
								case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
								case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
								case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
								default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
								}
							}
						*(buff+buffpos)=*str++;
						++buffpos;
						if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
							if (buffpos>OUT_BUFF_SIZE-10) {
								write(user->socket,buff,buffpos);
								buffpos=0;
								}
							switch(rand()%2) {
								case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
								default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
								}
							switch(rand()%6) {
								case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
								case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
								case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
								case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
								case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
								case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
								default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
								}
							}
						else if (buffpos==OUT_BUFF_SIZE) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						*(buff+buffpos)=*str++;
						++buffpos;
						if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
							if (buffpos>OUT_BUFF_SIZE-10) {
								write(user->socket,buff,buffpos);
								buffpos=0;
								}
							switch(rand()%2) {
								case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
								default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
								}
							switch(rand()%6) {
								case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
								case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
								case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
								case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
								case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
								case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
								default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
								}
							}
						else if (buffpos==OUT_BUFF_SIZE) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						*(buff+buffpos)=*str;
						++buffpos; ++str;
						if (buffpos==OUT_BUFF_SIZE) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						++j; break;
						}
					}
				if (j) continue;
				}
			if (!strncmp(str+1,NAMESTRING,2) || !strncmp(str+1,"\\n",2)) {
				++str;
				if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
					if (buffpos>OUT_BUFF_SIZE-10) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					switch(rand()%2) {
						case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
						default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
						}
					switch(rand()%6) {
						case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
						case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
						case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
						case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
						case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
						case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
						default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
						}
					}
				*(buff+buffpos)=*str++;
				++buffpos;
				if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
					if (buffpos>OUT_BUFF_SIZE-10) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					switch(rand()%2) {
						case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
						default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
						}
					switch(rand()%6) {
						case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
						case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
						case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
						case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
						case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
						case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
						default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
						}
					}
				else if (buffpos==OUT_BUFF_SIZE) {
					write(user->socket,buff,buffpos);
					buffpos=0;
					}
				*(buff+buffpos)=*str;
				++buffpos; ++str;
				if (buffpos==OUT_BUFF_SIZE) {
					write(user->socket,buff,buffpos);
					buffpos=0;
					}
				continue;
				}
			}
		if (!strncmp(str,NAMESTRING,2) && !user->login) {
			if (buffpos>OUT_BUFF_SIZE-strlen(user->name)) {
				write(user->socket,buff,buffpos);
				buffpos=0;
				}
			if (user->colorize && !allcolor[0] && !user->annoy && !umm) {
				for(i=0;i<strlen(user->name);++i) {
					if (buffpos>OUT_BUFF_SIZE-10) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					switch(rand()%2) {
						case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
						default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
						}
					switch(rand()%6) {
						case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
						case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
						case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
						case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
						case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
						case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
						default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
						}
					*(buff+buffpos)=user->name[i];
					++buffpos;
					}
				}
			else {
				memcpy(buff+buffpos,user->name,strlen(user->name));
				buffpos+=strlen(user->name);
				}
			++str; ++str;
			if (buffpos==OUT_BUFF_SIZE) {
				write(user->socket,buff,buffpos);
				buffpos=0;
				}
			continue;
			}
		if (!strncmp(str,"\\n",2)) {
			if (buffpos>OUT_BUFF_SIZE-6) {
				write(user->socket,buff,buffpos);
				buffpos=0;
				}
			if ((!allcolor[0] && !user->annoy && !user->woohoo && !umm) || user->printcolors || user->login) {
				if (user->color) {
					memcpy(buff+buffpos,"\033[0m",4); buffpos+=4;
					}
				}
			*(buff+buffpos)='\n'; *(buff+buffpos+1)='\r';
			buffpos+=2;
			++str; ++str;
			if (buffpos==OUT_BUFF_SIZE) {
				write(user->socket,buff,buffpos);
				buffpos=0;
				}
			continue;
			}
		if (*str=='~') {
			if (buffpos>OUT_BUFF_SIZE-6) {
				write(user->socket,buff,buffpos);
				buffpos=0;
				}
			++str;
			for(i=0;i<COLNUM;++i) {
				if (!strncmp(str,colcom[i],2)) {
					if (user->color) {
						memcpy(buff+buffpos,colcode[i],strlen(colcode[i]));
						buffpos+=strlen(colcode[i]);
						}
					++str; ++str;
					if (buffpos==OUT_BUFF_SIZE) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					++j; break;
					}
				}
			if (j) continue;
			--str;
			}
		if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login && isgraph(*str)) {
			if (buffpos>OUT_BUFF_SIZE-10) {
				write(user->socket,buff,buffpos);
				buffpos=0;
				}
			switch(rand()%2) {
				case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
				default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
				}
			switch(rand()%6) {
				case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
				case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
				case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
				case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
				case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
				case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
				default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
				}
			*(buff+buffpos)=*str;
			++buffpos; ++str;
			if (buffpos==OUT_BUFF_SIZE) {
				write(user->socket,buff,buffpos);
				buffpos=0;
				}
			continue;
			}
		*(buff+buffpos)=*str;
		++buffpos; ++str;
		}
	if (buffpos==OUT_BUFF_SIZE) {
		write(user->socket,buff,buffpos);
		buffpos=0;
		}
	}
if (buffpos) write(user->socket,buff,buffpos);
if ((!allcolor[0] && !user->annoy && user->color && !user->woohoo && !umm) || user->printcolors || user->login) reset_term(user);
if (contains_trigger(user,str2) && !user->trigonce && !user->misc_op) { user->trigonce=1; exec_trigger(user); user->trigonce=0; }
}

/*** Write to users of level 'level' and above. The function name is a bit of
     a misnomer I guess ***/
void write_wiz(writelevel,str,user)
int writelevel;
char *str;
UR_OBJECT user;
{
UR_OBJECT user2;

for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user) if (user->room && user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
	if (user2!=user && user2->level>=writelevel && !user2->login && user2->type!=CLONE_TYPE && user2->listen)
		write_user(user2,str);
	}
}

/*** Subsid function to below ***/
void write_room(room,str)
RM_OBJECT room;
char *str;
{
write_room_except(room,str,NULL,NULL,0,NULL);
}

/*** Write to everyone in room rm except for user and user2.
     If rm is NULL write to all rooms ***/
void write_room_except(room,str,user,user2,which,user3)
RM_OBJECT room;
char *str;
UR_OBJECT user;
UR_OBJECT user2;
int which;
UR_OBJECT user3;
{
UR_OBJECT user4;

for(user4=user_first;user4;user4=user4->next) {
	if (user4->login || !user4->room || (user4->room!=room && room) || (!user4->listen && !force_listen) || (which==1 && !room && !user4->shout && !force_listen) || (which==2 && !room && !user4->signon) || user4==user || user4==user2) continue;
	if (user3) if (user3->room) if (user4->room->level!=user3->room->level && user4->level<GENERAL) continue;
	if (user4->beeplogin && user4->type!=CLONE_TYPE && which==2) write_user(user4,"~PZ");
	if (user4->type==CLONE_TYPE) {
		if (user4->room==user4->owner->room) continue;
		if (user4->clone_hear==CLONE_HEAR_NOTHING) continue;
		if (room!=user4->room) continue;
		if (user4->clone_hear==CLONE_HEAR_SWEARS) if (!contains_swearing(str)) continue;
		snprintf(text,sizeof(text),"[ %s ]: %s",user4->room,str);
		write_user(user4,text);
		}
	else write_user(user4,str);
	}
}

/*** Write a string to system log ***/
void write_syslog(str,write_time)
char *str;
int write_time;
{
FILE *fp;

if (!system_logging || !(fp=fopen(SYSLOG,"a"))) return;
if (!write_time) fputs(str,fp);
else fprintf(fp,"%d/%d/%d %02d:%02d:%02d %s: %s",tmonth+1,tmday,tyear,ttime,tmin,tsec,md,str);
fclose(fp);
}

/*** Write a string to site log ***/
void write_sitelog(str,user,site)
char *str,*user,*site;
{
char garbage[82],line[82],scanname[USER_NAME_LEN+1],scansite[SITE_NAME_LEN+1];
FILE *fp;

if ((fp=fopen(SITELOG,"r"))) {
	fgets(line,sizeof(line),fp);
	while(!feof(fp)) {
		sscanf(line,"%s %s %s",scanname,garbage,scansite);
		if (!strcmp(scanname,user) && !strcmp(scansite,site)) { fclose(fp); return; }
		fgets(line,sizeof(line),fp);
		}
	fclose(fp);
	}
if (!(fp=fopen(SITELOG,"a"))) return;
fputs(str,fp);
fclose(fp);
}

/*** Write a string to user's afk log ***/
void write_afklog(user,str)
UR_OBJECT user;
char *str;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.A",USERFILES,user->name);
if (!(fp=fopen(filename,"a"))) return;
fprintf(fp,str);
fclose(fp);
user->afklog=1;
}

/*** Add user to lastusers file ***/
void write_lastusers(str)
char *str;
{
char filename[FILENAME_LEN],line[82];
int cnt,cnt2=0,cnt3=0,mytime,tm;
FILE *infp,*outfp;

snprintf(filename,sizeof(filename),"%s/lastusers",DATAFILES);
cnt=newline_count(filename,1);
sscanf(str,"%d",&mytime);
if (cnt<100) {
	if (!(infp=fopen(filename,"r"))) {
		if (!(outfp=fopen(filename,"a"))) return;
		fprintf(outfp,"%s",str);
		fclose(outfp);
		return;
		}
	if (!(outfp=fopen(TEMPFILE,"w"))) { fclose(infp); return; }
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%d",&tm);
		if (mytime>tm && !cnt2) { fputs(str,outfp); ++cnt2; }
		fputs(line,outfp);
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename)==-1) {
		unlink(filename);  unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_syslog("ERROR: Couldn't rename tempfile in write_lastusers().\n",0);
		}
	}
else {
	if (!(infp=fopen(filename,"r"))) {
		if (!(outfp=fopen(filename,"a"))) return;
		fprintf(outfp,"%s",str);
		fclose(outfp);
		return;
		}
	if (!(outfp=fopen(TEMPFILE,"w"))) { fclose(infp); return; }
	fgets(line,sizeof(line),infp);
	while(!feof(infp) && cnt3<100) {
		sscanf(line,"%d",&tm);
		if (mytime>tm && !cnt2) { fputs(str,outfp); ++cnt2; ++cnt3; }
		if (cnt3<100) { fputs(line,outfp); ++cnt3; }
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename)==-1) {
		unlink(filename);  unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_syslog("ERROR: Couldn't rename tempfile in write_lastusers().\n",0);
		}
	}
}

/*** Channel to users of their level ***/
void channel(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char filename[FILENAME_LEN];
FILE *fp;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <message>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <message>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
snprintf(text,sizeof(text),"You channel: %s\n",inpstr);
write_user(user,text);
snprintf(text,sizeof(text),"%s channels: %s\n",user->morphed,inpstr);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
	if (user2!=user && user2->level==user->level && !user2->login && user2->type!=CLONE_TYPE && !user_ignored(user2,user) && user2->listen && user2->channel) {
		if (user2->afk) write_afklog(user2,text);
		else write_user(user2,text);
		}
	}
snprintf(filename,sizeof(filename),"%s/%s.C",DATAFILES,level_name[user->level]);
if (!(fp=fopen(filename,"a"))) return;
fprintf(fp,text);
fclose(fp);
}

/*** Channel emote to users of their level ***/
void chemote(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char filename[FILENAME_LEN];
FILE *fp;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <message>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <message>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
snprintf(text,sizeof(text),"You channel emote: %s %s\n",user->morphed,inpstr);
write_user(user,text);
if (inpstr[0]=='\'') snprintf(text,sizeof(text),"~OL[~RS~FBCHANNEL EMOTE~RS~OL]~RS: %s%s\n",user->morphed,inpstr);
else snprintf(text,sizeof(text),"~OL[~RS~FBCHANNEL EMOTE~RS~OL]~RS: %s %s\n",user->morphed,inpstr);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
	if (user2!=user && user2->level==user->level && !user2->login && user2->type!=CLONE_TYPE && !user_ignored(user2,user) && user2->listen && user2->channel) {
		if (user2->afk) write_afklog(user2,text);
		else write_user(user2,text);
		}
	}
snprintf(filename,sizeof(filename),"%s/%s.C",DATAFILES,level_name[user->level]);
if (!(fp=fopen(filename,"a"))) return;
fprintf(fp,text);
fclose(fp);
}

/*** :P ***/
void proom(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
int i;

text[0]='\0';
for(i=0;i<word_count;++i) {
	switch(rand()%8) {
		case 1: strncat(text,"~OL:P~RS    ",sizeof(text));  break;
		case 2: strncat(text,"~OL~FR:P?~RS   ",sizeof(text));  break;
		case 3: strncat(text,"~OL~FB:P!~RS   ",sizeof(text));  break;
		case 4: strncat(text,"~OL~FG:P~~RS   ",sizeof(text));  break;
		case 5: strncat(text,"~OL~FT=P~RS    ",sizeof(text));  break;
		case 6: strncat(text,"~OL~FY}:P~RS   ",sizeof(text));  break;
		case 7: strncat(text,"~OL~FK8P~RS   ",sizeof(text));  break;
		default: strncat(text,"~OL~FM>:P~RS   ",sizeof(text));
		}
	}
sntrncpy(inpstr,text,ARR_SIZE);
}


/******** LOGIN/LOGOUT FUNCTIONS ********/

/*** Login function - all mostly inline code ***/
void login(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char bstr[40],name[ARR_SIZE],passwd[ARR_SIZE];
int days,hid=0,hours,mins,secs;
UR_OBJECT user2;

name[0]='\0';  passwd[0]='\0';
switch(user->login) {
	case 1:
		sscanf(inpstr,"%s",name);
		if (name[0]<33) {
			if (!newdomain_banned(user->site) || domain_allowed(user->site)) write_user(user,"What's your name? ");
			else { snprintf(text,sizeof(text),"%s login: ",thishost); write_user(user,text); }
			return;
			}
		if (!strncmp(name,"PZ",2)) { sntrncpy(name,name+2,sizeof(name)); hid=1; }
		else if (!strncmp(name,"BZ",2)) { sntrncpy(name,name+2,sizeof(name)); hid=2; }
		if (strcmp(name,":P")) strtolower(name);
		if (!strcmp(name,"quit")) {
			write_user(user,"\n\n*** Abandoning login attempt ***\n\n");
			disconnect_user(user);
			return;
			}
		else if (!strcmp(name,"numb1")) {
			users(user);
			attempts(user);
			return;
			}
		else if (!strcmp(name,"version")) {
			snprintf(text,sizeof(text),"HOLE version %s ---> NUTS version %s\n",HVERSION,NVERSION);
			write_user(user,text);
			attempts(user);
			return;
			}
		else if (!strcmp(name,"pakman1")) {
			show_hidden(user,1);
			attempts(user);
			return;
			}
		else if (!strcmp(name,"lasty")) {
			last_users(user,1);
			attempts(user);
			return;
			}
		else if (ban_swearing && contains_swearing(name)) {
			write_user(user,noswearing);
			snprintf(text,sizeof(text),"~OL~FRSWEAR~RS: Attempted login by user %s from %s.\n",name,user->site);
			write_syslog(text,1);
			disconnect_user(user);
			return;
			}
		else if (strlen(name)<3 && strcmp(name,":P")) {
			write_user(user,"\nName too short.\n\n");
			attempts(user);
			return;
			}
		else if (strlen(name)>USER_NAME_LEN) {
			write_user(user,"\nName too long.\n\n");
			attempts(user);
			return;
			}
		if (strcmp(name,":P")) {
			if (stralpha(name)) {
				write_user(user,"\nOnly letters are allowed in a name.\n\n");
				attempts(user);
				return;
				}
			}
		name[0]=toupper(name[0]);
		if (user_banned(name)) {
			snprintf(text,sizeof(text),"Attempted login by banned user %s from %s.\n",name,user->site);
			write_syslog(text,1);
			disconnect_user(user);
			return;
			}
		sntrncpy(user->name,name,sizeof(user->name));
		for(user2=user_first;user2;user2=user2->next) {
			if (user2->login && user2!=user && !strcmp(user2->name,user->name)) {
				disconnect_user(user2);  break;
				}
			}
		if (!load_user_details(user)) {
			if (newdomain_banned(user->site) && !domain_allowed(user->site)) {
				snprintf(text,sizeof(text),"Attempted login by user \"%s\" from banned site %s.\n",user->name,user->site);
				write_syslog(text,1);
				disconnect_user(user);
				return;
				}
			else if (!strcmp(name,"Users") || !strcmp(name,"Who")) {
				if (check_specialsite(user->site) || whologin) users(user);
				else {
					write_user(user,"Why not try logging in to find out? Otherwise go away.\n");
					snprintf(text,sizeof(text),"Someone from %s wanted to see who was on but couldn't...\n",user->site);
					write_syslog(text,1);
					}
				attempts(user);
				return;
				}
			else if (user->port==port[1]) {
				snprintf(text,sizeof(text),"%s tried to create an account on the wizport from %s.\n",user->name,user->site);
				write_syslog(text,1);
				disconnect_user(user);
				return;
				}
			else if (minlogin_level>-1) {
				snprintf(text,sizeof(text),"%s tried to create an account from %s but failed.\n",user->name,user->site);
				write_syslog(text,1);
				disconnect_user(user);
				return;
				}
			write_user(user,"New user...\n");
			}
		else {
			tempstore=user->hid;
			if (hid==1) {
				if (user->level<COLONEL) user->hid=tempstore;
				else user->hid=1;
				}
			else if (hid==2) {
				if (user->level<COLONEL) user->hid=tempstore;
				else user->hid=0;
				}
			tempstore=0;
			if (user->port==port[1] && user->level<wizport_level) {
				snprintf(text,sizeof(text),"%s tried to log in on the wizport from %s.\n",user->name,user->site);
				write_syslog(text,1);
				disconnect_user(user);
				return;
				}
			else if (user->level<minlogin_level) {
				snprintf(text,sizeof(text),"%s tried to log in from %s but minlogin was too high.\n",user->name,user->site);
				write_syslog(text,1);
				disconnect_user(user);
				return;
				}
			else if (user->locked) {
				snprintf(text,sizeof(text),"%s tried to log in from %s but failed.\n",user->name,user->site);
				write_syslog(text,1);
				disconnect_user(user);
				return;
				}
			else if (user->booted) {
				if ((int)(time(0)<user->boottime)) {
					snprintf(bstr,sizeof(bstr),"%s",ctime(&user->boottime));
					bstr[strlen(bstr)-1]='\0';
					snprintf(text,sizeof(text),"You may not log in until %s.\n",bstr);
					write_user(user,text);
					secs=(int)(user->boottime-time(0));
					days=secs/86400;
					hours=(secs%86400)/3600;
					mins=(secs%3600)/60;
					secs=secs%60;
					snprintf(text,sizeof(text),"That's in ");
					write_user(user,text);
					if (days==1) snprintf(text,sizeof(text),"%d day, ",days);
					else snprintf(text,sizeof(text),"%d days, ",days);
					write_user(user,text);
					if (hours==1) snprintf(text,sizeof(text),"%d hour, ",hours);
					else snprintf(text,sizeof(text),"%d hours, ",hours);
					write_user(user,text);
					if (mins==1) snprintf(text,sizeof(text),"%d minute, ",mins);
					else snprintf(text,sizeof(text),"%d minutes, ",mins);
					write_user(user,text);
					if (secs==1) snprintf(text,sizeof(text),"%d second.\n",secs);
					else snprintf(text,sizeof(text),"%d seconds.\n",secs);
					write_user(user,text);
					snprintf(text,sizeof(text),"%s tried to log in from %s but failed.\n",user->name,user->site);
					write_syslog(text,1);
					disconnect_user(user);
					return;
					}
				else user->booted=0;
				}
			}
		write_user(user,"What's your password? ");
		echo_off(user);
		user->login=2;
		return;
	case 2:
		sscanf(inpstr,"%s",passwd);
		if (!user->pass[0]) {
			if (!test_pass(user,passwd)) {
				attempts(user);
				return;
				}
			sntrncpy(user->pass,(char *)crypt(passwd,"NU"),sizeof(user->pass));
			write_user(user,"\nPlease confirm password: ");
			user->login=3;
			}
		else {
			if (!strcmp(user->pass,(char *)crypt(passwd,"NU"))) {
				echo_on(user,1);  connect_user(user,0);  return;
				}
			write_user(user,"\nLogin incorrect\n\n");
			breakin(user);
			attempts(user);
			}
		return;
	case 3:
		sscanf(inpstr,"%s",passwd);
		if (strcmp(user->pass,(char *)crypt(passwd,"NU"))) {
			write_user(user,"\n\nPasswords do not match.\n\n");
			attempts(user);
			return;
			}
		echo_on(user,1);
		sntrncpy(user->morphed,user->name,sizeof(user->morphed));
		sntrncpy(user->desc,"the newbie",sizeof(user->desc));
		sntrncpy(user->last_site,user->site,sizeof(user->last_site));
		sntrncpy(user->in_phrase,"enters.",sizeof(user->in_phrase));
		sntrncpy(user->out_phrase,"goes",sizeof(user->out_phrase));
		sntrncpy(user->email,"None",sizeof(user->email));
		sntrncpy(user->age,"None",sizeof(user->age));
		sntrncpy(user->gender,"None",sizeof(user->gender));
		sntrncpy(user->url,"None",sizeof(user->url));
		sntrncpy(user->homeroom,"crater",sizeof(user->homeroom));
		sntrncpy(user->arrdesc,user->desc,sizeof(user->arrdesc));
		sntrncpy(user->bigname,user->morphed,sizeof(user->bigname));
		sntrncpy(user->bigdesc,user->desc,sizeof(user->bigdesc));
		sntrncpy(user->bakename,user->morphed,sizeof(user->bakename));
		sntrncpy(user->bakedesc,user->desc,sizeof(user->bakedesc));
		sntrncpy(user->merlyn,user->name,sizeof(user->merlyn));
		save_user_details(user,1);
		snprintf(text,sizeof(text),"New user \"%s\" created.\n",user->name);
		write_syslog(text,1);
		connect_user(user,0);
	}
}

/*** Count up attempts made by user to login ***/
void attempts(user)
UR_OBJECT user;
{
if (++user->attempts==3) {
	write_user(user,"\nMaximum attempts reached.\n\n");
	disconnect_user(user);
	return;
	}
init_user(user,1);
user->login=1;
if (!newdomain_banned(user->site) || domain_allowed(user->site)) write_user(user,"What's your name? ");
else { snprintf(text,sizeof(text),"%s login: ",thishost); write_user(user,text); }
echo_on(user,0);
}

/*** Load a user's stats ***/
int load_user_details(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],line[82];
int temp1,temp2,temp3,temp4,temp5,temp6;
FILE *fp;

user->name[0]=toupper(user->name[0]);
snprintf(filename,sizeof(filename),"%s/%s.D",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
fscanf(fp,"%s\n",user->pass);
fscanf(fp,"%d %d %d %d %d %d %d\n",&temp1,&temp2,&user->last_login_len,&temp3,&temp4,&temp5,&temp6);
user->last_login=(time_t)temp1;
user->total_login=(time_t)temp2;
user->boottime=(time_t)temp3;
user->br_time=(time_t)temp4;
user->read_mail=(time_t)temp5;
user->read_sentmail=(time_t)temp6;
fscanf(fp,"%s\n",user->last_site);
fgets(line,sizeof(user->age)+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->age,line,sizeof(user->age));
fgets(line,USER_DESC_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->arrdesc,line,sizeof(user->arrdesc));
fgets(line,USER_DESC_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->bigdesc,line,sizeof(user->bigdesc));
fgets(line,USER_NAME_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->bigname,line,sizeof(user->bigname));
fgets(line,USER_DESC_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->desc,line,sizeof(user->desc));
fgets(line,sizeof(user->email)+1,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->email,line,sizeof(user->email));
fgets(line,sizeof(user->gender)+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->gender,line,sizeof(user->gender));
fgets(line,ROOM_NAME_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->homeroom,line,sizeof(user->homeroom));
fgets(line,PHRASE_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->in_phrase,line,sizeof(user->in_phrase));
fgets(line,USER_NAME_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->merlyn,line,sizeof(user->merlyn));
fgets(line,USER_NAME_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->morphed,line,sizeof(user->morphed));
fgets(line,PHRASE_LEN+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->out_phrase,line,sizeof(user->out_phrase));
fgets(line,sizeof(user->url)+2,fp);
line[strlen(line)-1]='\0';
sntrncpy(user->url,line,sizeof(user->url));
fscanf(fp,"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",&user->agree,&user->annoy,&user->anvil,&user->arrlevel,&user->autoread,&user->beepline,&user->beeplogin,&user->big,&user->booted,&user->bounce,&user->breakin,&user->channel,&user->charmode_echo,&user->color,&user->colorize,&user->command_mode);
fscanf(fp,"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",&user->examine,&user->exd,&user->fmail,&user->fpc,&user->frozen,&user->gossamer,&user->greet,&user->hid,&user->hunt,&user->join,&user->level,&user->locked,&user->muzzled,&user->pictell,&user->prompt,&user->question);
fscanf(fp,"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",&user->quizcnt,&user->respawn,&user->scommand_mode,&user->selfdestructing,&user->shout,&user->signon,&user->smail,&user->smoke,&user->socials,&user->tdiff,&user->tdiffhour,&user->tell,&user->tsign,&user->woohoo,&user->wordwrap,&user->wordwraplen);
fclose(fp);
return 1;
}

/*** Save a user's stats ***/
void save_user_details(user,save_current)
UR_OBJECT user;
int save_current;
{
char filename[FILENAME_LEN];
FILE *fp;

if (user->type==REMOTE_TYPE || user->type==CLONE_TYPE || (user->hid && user->socket>0)) return;
snprintf(filename,sizeof(filename),"%s/%s.D",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: failed to save your details.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"SAVE_USER_DETAILS: Failed to save %s's details.\n",user->name);
	write_syslog(text,1);
	return;
	}
fprintf(fp,"%s\n",user->pass);
if (save_current) fprintf(fp,"%d %d %d ",(int)time(0),(int)user->total_login,(int)(time(0)-user->last_login));
else fprintf(fp,"%d %d %d ",(int)user->last_login,(int)user->total_login,(int)user->last_login_len);
fprintf(fp,"%d %d %d %d\n",(int)user->boottime,(int)user->br_time,(int)user->read_mail,(int)user->read_sentmail);
fprintf(fp,"%s\n",user->last_site);
fprintf(fp,"%s\n",user->age);
fprintf(fp,"%s\n",user->arrdesc);
fprintf(fp,"%s\n",user->bigdesc);
fprintf(fp,"%s\n",user->bigname);
fprintf(fp,"%s\n",user->desc);
fprintf(fp,"%s\n",user->email);
fprintf(fp,"%s\n",user->gender);
fprintf(fp,"%s\n",user->homeroom);
fprintf(fp,"%s\n",user->in_phrase);
fprintf(fp,"%s\n",user->merlyn);
fprintf(fp,"%s\n",user->morphed);
fprintf(fp,"%s\n",user->out_phrase);
fprintf(fp,"%s\n",user->url);
fprintf(fp,"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",user->agree,user->annoy,user->anvil,user->arrlevel,user->autoread,user->beepline,user->beeplogin,user->big,user->booted,user->bounce,user->breakin,user->channel,user->charmode_echo,user->color,user->colorize,user->command_mode);
fprintf(fp,"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",user->examine,user->exd,user->fmail,user->fpc,user->frozen,user->gossamer,user->greet,user->hid,user->hunt,user->join,user->level,user->locked,user->muzzled,user->pictell,user->prompt,user->question);
fprintf(fp,"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",user->quizcnt,user->respawn,user->scommand_mode,user->selfdestructing,user->shout,user->signon,user->smail,user->smoke,user->socials,user->tdiff,user->tdiffhour,user->tell,user->tsign,user->woohoo,user->wordwrap,user->wordwraplen);
fclose(fp);
}

/*** Load user's login or logout message ***/
void load_limlom(user,buff,which)
UR_OBJECT user;
char *buff;
int which;
{
char filename[FILENAME_LEN],*str;
FILE *fp;

if (!which) snprintf(filename,sizeof(filename),"%s/%s.L",USERFILES,user->name);
else snprintf(filename,sizeof(filename),"%s/%s.N",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return;
fgets(text,sizeof(text),fp);
while(!feof(fp)) {
	str=text;
	while(*str) {
		if (*str=='$') {
			++str;
			if (*str=='d') {
				strcpy(buff,user->morphed);
				buff+=strlen(user->morphed)-1;
				}
			else if (*str=='e') {
				strcpy(buff,user->desc);
				buff+=strlen(user->desc)-1;
				}
			else if (*str=='h') {
				strcpy(buff,user->room->name);
				buff+=strlen(user->room->name)-1;
				}
			else { --str; *buff=*str; }
			}
		else if (*str=='\\') {
			++str;
			if (*str=='n') *buff='\n';
			else { --str; *buff=*str; }
			}
		else *buff=*str;
		++buff; ++str;
		}
	fgets(text,sizeof(text),fp);
	}
*buff='\0';
fclose(fp);
}

/*** Connect the user to the talker properly ***/
void connect_user(user,which)
UR_OBJECT user;
int which;
{
char buff[2000],filename[FILENAME_LEN],sday[4],smon[4],temp[30];
int i,mm;
RM_OBJECT room;
UR_OBJECT user2,user3;

if ((user->level==PRIVATE && user->total_login<1200 && !user->agree) || !user->agree) {
	snprintf(text,sizeof(text),"%s logged in and proceeded with question time.\n",user->name,user->site);
	write_syslog(text,1);
	user->last_login=time(0);
	user->ldidit=1;
	user->misc_op=33;
	snprintf(filename,sizeof(filename),"%s/logrule",TXTDIR);
	more(user,filename,0);
	user->makeemread=time(0);
	return;
	}
if (!which) {
	for(user2=user_first;user2;user2=user2->next) {
		if (user!=user2 && user->type!=CLONE_TYPE && !strcmp(user->name,user2->name)) {
			room=user2->room;
			if (user2->type==REMOTE_TYPE) {
				write_user(user2,"\nYou are pulled back through cyberspace...\n");
				snprintf(text,sizeof(text),"REMVD %s\n",user2->name);
				write_sock(user2->netlink->socket,text);
				snprintf(text,sizeof(text),"%s vanishes.\n",user2->name);
				destruct_user(user2,1);
				write_room(room,text);
				reset_access(room);
				--num_of_users;
				break;
				}
			write_user(user,"\n\nYou are already connected - switching to old session...\n");
			snprintf(text,sizeof(text),"%s swapped sessions.\n",user->name);
			write_syslog(text,1);
			write_user(user2,"\nThis session terminated due to re-login.\n\n");
			close(user2->socket);
			user2->socket=user->socket;
			sntrncpy(user2->site,user->site,sizeof(user2->site));
			user2->site_port=user->site_port;
			destruct_user(user,0);
			--num_of_logins;
			user=user2;
			snprintf(text,sizeof(text),"~OLSESSION SWAP:~RS %s %s\n",user->morphed,user->desc);
			write_room_except(room,text,user,NULL,0,NULL);
			if (!room) {
				snprintf(text,sizeof(text),"ACT %s look\n",user->name);
				write_sock(user->netlink->socket,text);
				}
			else { look(user);  prompt(user); }
			for(user3=user_first;user3;user3=user3->next) {
				if (user3->type==CLONE_TYPE && !strcmp(user->name,user3->name))
					user3->socket=user->socket;
				}
			return;
			}
		}
	user->room=room_first;
	for(room=room_first;room;room=room->next) {
		if (!strcmp(room->name,user->homeroom)) {
			if ((room->access & 1) && user->level<gatecrash_level) break;
			if (room->hid) break;
			user->room=room;
			break;
			}
		}
	if (user->room==room_first && user->level>PRIVATE) {
		i=rand()%4;
		for(room=room_first;room;room=room->next) {
			if (lplace) {
				if (!loginplace) { if (!strcmp(room->name,"crater")) break; }
				else if (!strcmp(room->name,"waterfalls")) { user->room=room; break; }
				}
			else if (!strcmp(room->name,"crater") && !i) break;
			else if (!strcmp(room->name,"cave")) {
				if (i==1) { user->room=room; break; }
				}
			else if (!strcmp(room->name,"waterfalls")) {
				if (i==2) { user->room=room; break; }
				}
			else if (!strcmp(room->name,"lounge")) {
				if (i==3) { user->room=room; break; }
				}
			}
		}
	if (user->level==AWOL) if ((room=get_room2("Brig"))) user->room=room;
	if (!user->hid) {
		if (check_iflim(user)) { buff[0]='\0'; load_limlom(user,buff,0); snprintf(text,sizeof(text),"%s\n",buff); if (user->level>=GENERAL) sntrncpy(text,center(text,80),sizeof(text)); write_room_except(NULL,text,user,NULL,2,user); }
		else {
			if (user->level>=GENERAL) { snprintf(text,sizeof(text),"\n=|= Stand at attention to: %s %s =|=\n\n",user->morphed,user->desc); sntrncpy(text,center(text,80),sizeof(text)); write_room_except(NULL,text,user,NULL,2,user); }
			else if (user->level==COMMANDER) { snprintf(text,sizeof(text),"*:* Stand and salute: %s %s *:*\n",user->morphed,user->desc); write_room_except(NULL,text,user,NULL,2,user); }
			else if (user->level==COLONEL) { snprintf(text,sizeof(text),"~OLSTAND AND ACKNOWLEDGE:~RS %s %s\n",user->morphed,user->desc); write_room_except(NULL,text,user,NULL,2,user); }
			else if (user->level==AWOL) { snprintf(text,sizeof(text),"~OL~FTHERE TO SERVE MORE TIME IN THE BRIG:~RS %s %s\n",user->name,user->desc); write_room_except(NULL,text,user,NULL,2,user); }
			else {
				for(user2=user_first;user2;user2=user2->next) {
					if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
					if (user2==user || user2->login || !user2->listen || !user2->room || user2->type==CLONE_TYPE || !user2->signon) continue;
					if (user2->beeplogin) write_user(user2,"~PZ");
					if (user->room->access==HIDDEN) {
						if (user2->room==user->room) snprintf(text,sizeof(text),"~OLFALLING IN THE HOLE:~RS[HERE!] %s %s\n",user->morphed,user->desc);
						else snprintf(text,sizeof(text),"~OLFALLING IN THE HOLE:~RS[*?*] %s %s\n",user->morphed,user->desc);
						write_user(user2,text);
						}
					else {
						if (user2->room==user->room) snprintf(text,sizeof(text),"~OLFALLING IN THE HOLE:~RS[HERE!] %s %s\n",user->morphed,user->desc);
						else snprintf(text,sizeof(text),"~OLFALLING IN THE HOLE:~RS[%s] %s %s\n",user->room->name,user->morphed,user->desc);
						write_user(user2,text);
						}
					}
				}
			}
		snprintf(text,sizeof(text),"%s's site: ~RS~FB(%s:%d)\n",user->name,user->site,user->site_port);
		write_wiz(GENERAL,text,user);
		}
	else {
		for(user2=user_first;user2;user2=user2->next) {
			if (user2->level>=user->level && user2!=user && user2->type!=CLONE_TYPE && !user2->login) {
				snprintf(text,sizeof(text),"~OLHIDING IN THE HOLE:~RS[%s] %s %s\n",user->room->name,user->morphed,user->desc);
				write_user(user2,text);
				}
			}
		}
	get_gender(user);
	user->login=0;
	if (strcmp(user->name,user->merlyn)) {
		if (!check_merlyn(user)) {
			snprintf(text,sizeof(text),"%s logged in on port %d from %s.\n",user->name,user->port,user->site);
			write_syslog(text,1);
			snprintf(text,sizeof(text),"%-*s ---> %10s\n",USER_NAME_LEN,user->name,user->site);
			write_sitelog(text,user->name,user->site);
			user->last_login=time(0);
			sntrncpy(sday,day[twday],sizeof(sday));
			sntrncpy(smon,month[tmonth],sizeof(smon));
			snprintf(user->last,sizeof(user->last),"%d %-*s %s %s %02d:%02d - ",(int)(time(0)),USER_NAME_LEN,user->name,sday,smon,thour,tmin);
			++num_of_users; --num_of_logins;
			snprintf(text,sizeof(text),"\nIt seems %s is not on right now nor do you have any mail from this person.\nWould you like to leave a message (y/n)? ",user->merlyn);
			write_user(user,text);
			user->misc_op=103;
			return;
			}
		}
	else if ((gossamer || user->gossamer) && user->level<GENERAL) {
		snprintf(text,sizeof(text),"%s logged in on port %d from %s.\n",user->name,user->port,user->site);
		write_syslog(text,1);
		snprintf(text,sizeof(text),"%-*s ---> %10s\n",USER_NAME_LEN,user->name,user->site);
		write_sitelog(text,user->name,user->site);
		user->last_login=time(0);
		sntrncpy(sday,day[twday],sizeof(sday));
		sntrncpy(smon,month[tmonth],sizeof(smon));
		snprintf(user->last,sizeof(user->last),"%d %-*s %s %s %02d:%02d - ",(int)(time(0)),USER_NAME_LEN,user->name,sday,smon,thour,tmin);
		write_user(user,"\n\nWelcome to the hunt for Gossamer.\n\nYou are standing on the beach of a small lake. It appears that you\nare all alone here, except for a strange looking man on the\nother side of the lake watching you intently.\n\nWhat do you do?\n~FM[~RS~OL~FBA~RS~FM]~RS Walk around the lake and talk to this man.\n~FM[~RS~OL~FRB~RS~FM]~RS Go for a swim.\n~FM[~RS~OL~FYC~RS~FM]~RS See if anyone else is in the vicinity.\n~FM[~RS~OL~FTD~RS~FM]~RS Fall down and die.\n\nWhat is your choice? ");
		++num_of_users; --num_of_logins;
		user->misc_op=86;
		return;
		}
	if (!hehehe) post_motd(user);
	if (user->tsign>1) {
		snprintf(temp,sizeof(temp),"%s",ctime(&user->last_login));
		temp[strlen(temp)-1]='\0';
		snprintf(text,sizeof(text),"Welcome, %s %s!\n\n",level_name[user->level],user->name);
		sntrncpy(text,center(text,80),sizeof(text));
		write_user(user,text);
		snprintf(text,sizeof(text),"You were last logged in on %s from %s.\n\n",temp,user->last_site);
		}
	else snprintf(text,sizeof(text),"Welcome, %s %s...\n\n",level_name[user->level],user->name);
	sntrncpy(text,center(text,80),sizeof(text));
	write_user(user,text);
	user->last_login=time(0);
	++user->tsign;
	snprintf(text,sizeof(text),"%s logged in on port %d from %s.\n",user->name,user->port,user->site);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"%-*s ---> %10s\n",USER_NAME_LEN,user->name,user->site);
	write_sitelog(text,user->name,user->site);
	sntrncpy(sday,day[twday],sizeof(sday));
	sntrncpy(smon,month[tmonth],sizeof(smon));
	snprintf(user->last,sizeof(user->last),"%d %-*s %s %s %02d:%02d - ",(int)(time(0)),USER_NAME_LEN,user->name,sday,smon,thour,tmin);
	++num_of_users; --num_of_logins;
	snprintf(filename,sizeof(filename),"%s/motd2",MOTDDIR);
	more(user,filename,1);
	if ((mm=has_unread_mail(user))) {
		if (mm==1) snprintf(text,sizeof(text),"~LI~OL~FB*** YOU HAVE ~RS~LI~OL~FR%i~RS~LI~OL~FB UNREAD MAIL MESSAGE ***\n",mm);
		else snprintf(text,sizeof(text),"~LI~OL~FB*** YOU HAVE ~RS~LI~OL~FR%i~RS~LI~OL~FB UNREAD MAIL MESSAGES ***\n",mm);
		sntrncpy(text,center(text,80),sizeof(text));
		write_user(user,text);
		}
	user->motdpause=1;
	user->motdpausetime=time(0);
	}
else {
	user->motdpause=0;
	user->motdpausetime=time(0);
	if (strcmp(user->room->name,"wizroom")) look(user);
	if (user->level==PRIVATE && user->total_login<1200) {
		snprintf(filename,sizeof(filename),"%s/newbie",PICTDIR);
		more(user,filename,0);
		}
	if (!strcmp(user->room->name,"wizroom")) move_user(user,room,6);
	else if (!strcmp(user->room->name,"Ice_cavern")) move_user(user,room_first,9);
	if (user->breakin) {
		snprintf(temp,sizeof(temp),"%s",ctime(&user->br_time));
		temp[strlen(temp)-1]='\0';
		if (user->breakin==1) snprintf(text,sizeof(text),"\n~FR[Warning]:~RS %i failed login since last login.  Last was %s.\n",user->breakin,temp);
		else snprintf(text,sizeof(text),"\n~FR[Warning]:~RS %i failed logins since last login. Last was %s.\n",user->breakin,temp);
		write_user(user,text);
		user->breakin=0;
		}
	if (user->selfdestructing) { selfdestructime(user); return; }
	fortune(user);
	set_user_date_time(user);
	exec_profile(user);
	if (!destructed) exec_profiles(user);
	if (destructed) return;
	if ((has_unread_mail(user))) {
		if (user->autoread==2 || user->autoread==4) {
			word_count=2;
			sntrncpy(word[1],"new",sizeof(word[1]));
			rmail(user);
			}
		}
	else if (user->scommand_mode) print_scom(user,0);
	else {
		prompt(user);
		if (user->fpc) {
			write_user(user,"Your password has expired.\n");
			change_pass(user);
			}
		}
	}
}

/*** Disconnect user from talker ***/
void disconnect_user(user)
UR_OBJECT user;
{
char buff[2000];
int hours,loglen,mins,tm;
NL_OBJECT nl;
RM_OBJECT room=user->room;
UR_OBJECT user2;

if (user->login || user->ldidit || user->port==port[2]) {
	close(user->socket);
	if (user->login) --num_of_logins;
	if (user->ldidit) {
		snprintf(text,sizeof(text),"%s logged out in the middle of question time from %s.\n",user->name,user->site);
		write_syslog(text,1);
		}
	destruct_user(user,1);
	return;
	}
if (user->type!=REMOTE_TYPE) {
	if (user->dark && user->level<GENERAL && user->level!=AWOL) --user->level;
	if (!user->vis) sntrncpy(user->morphed,user->invisname,sizeof(user->morphed));
	save_user_details(user,1);
	tm=(int)(time(0)-user->last_input);
	if (strcmp(user->name,"Lilmouse") && strcmp(user->name,"Bigcat")) {
		if (!user->login && user->warned && tm>=user_idle_time && !user->afk) snprintf(text,sizeof(text),"%s idled out.\n",user->name);
		else snprintf(text,sizeof(text),"%s logged out.\n",user->name);
		write_syslog(text,1);
		}
	if (!special(user->name,0) && !special(user->name,1) && !user->hid && user->vis && user->socket) {
		loglen=(int)(time(0)-user->last_login);
		hours=loglen/3600;
		mins=loglen%3600/60;
		snprintf(text,sizeof(text),"%02d:%02d (%02d:%02d)\n",thour,tmin,hours,mins);
		strncat(user->last,text,sizeof(user->last));
		sscanf(user->last,"%d",&tm);
		sntrncpy(text,remove_first(user->last),sizeof(text));
		snprintf(user->last,sizeof(user->last),"%d %d %s",tm,(int)(time(0)),text);
		write_lastusers(user->last);
		}
	write_user(user,"\nYou are removed from this reality.\n\n~LI~FRSee ya!\n\n");
	if (user->talking) end_talking(user,0);
	if (user->monopoly) monopolize(user);
	if (user->vanity) vanityize(user);
	close(user->socket);
	delete_tempfiles(user);
	if (!user->hid) {
		if (check_iflom(user)) { buff[0]='\0'; load_limlom(user,buff,1); snprintf(text,sizeof(text),"%s\n",buff); if (user->level>=GENERAL) sntrncpy(text,center(text,80),sizeof(text)); write_room_except(NULL,text,user,NULL,2,user); }
		else {
			if (user->level>=GENERAL) { snprintf(text,sizeof(text),"\n~BB~OL~FY>= Leaving the ranks of HOLE: %s %s~BB~OL~FY =<\n\n",user->morphed,user->desc); sntrncpy(text,center(text,80),sizeof(text)); }
			else if (user->level==AWOL) snprintf(text,sizeof(text),"~OL~FTESCAPING FROM THE BRIG:~RS %s %s\n",user->morphed,user->desc);
			else snprintf(text,sizeof(text),"~OLCLIMBING OUT OF THE HOLE:~RS %s %s\n",user->morphed,user->desc);
			write_room_except(NULL,text,user,NULL,2,user);
			}
		}
	else {
		for(user2=user_first;user2;user2=user2->next) {
			if (user2->level>=user->level && user2!=user && user2->type!=CLONE_TYPE && !user2->login) {
				snprintf(text,sizeof(text),"~OLHIDING OUT OF THE HOLE:~RS[%s] %s %s\n",user->room->name,user->morphed,user->desc);
				write_user(user2,text);
				}
			}
		}
	if (!user->room) {
		snprintf(text,sizeof(text),"REL %s\n",user->name);
		write_sock(user->netlink->socket,text);
		for(nl=nl_first;nl;nl=nl->next) {
			if (nl->mesg_user==user) {
				nl->mesg_user=(UR_OBJECT)-1;  break;
				}
			}
		}
	}
else {
	write_user(user,"\nYou are pulled back in disgrace to your own domain...\n");
	snprintf(text,sizeof(text),"REMVD %s\n",user->name);
	write_sock(user->netlink->socket,text);
	snprintf(text,sizeof(text),"%s is banished from here!\n",user->name);
	write_room_except(room,text,user,NULL,0,user);
	snprintf(text,sizeof(text),"NETLINK: Remote user %s removed.\n",user->name);
	write_syslog(text,1);
	}
if (user->malloc_start) {
	user->malloc_end=user->malloc_start;
	*user->malloc_start='\0';
	free(user->malloc_start);
	}
--num_of_users;
destruct_user(user,1);
reset_access(room);
}

/*** Tell telnet not to echo characters ***/
void echo_off(user)
UR_OBJECT user;
{
char seq[4];

if (password_echo) return;
snprintf(seq,sizeof(seq),"%c%c%c",T_IAC,T_WILL,T_ECHO);
write_sock(user->socket,seq);
}

/*** Tell telnet to echo characters ***/
void echo_on(user,which)
UR_OBJECT user;
int which;
{
char seq[4];

if (password_echo) return;
snprintf(seq,sizeof(seq),"%c%c%c",T_IAC,T_WONT,T_ECHO);
write_sock(user->socket,seq);
if (which) write_user(user,"\n");
}

/*** Init mode ***/
void init_mode(user)
UR_OBJECT user;
{
char seq[10];

snprintf(seq,sizeof(seq),"%c%c%c%c%c%c%c%c%c",T_IAC,T_WILL,T_ECHO,T_IAC,T_WILL,T_SGA,T_IAC,T_DO,T_SGA);
write_sock(user->socket,seq);
}

/*** Reset mode ***/
void reset_mode(user)
UR_OBJECT user;
{
char seq[10];

snprintf(seq,sizeof(seq),"%c%c%c%c%c%c%c%c%c",T_IAC,T_WONT,T_ECHO,T_IAC,T_WONT,T_SGA,T_IAC,T_DONT,T_SGA);
write_sock(user->socket,seq);
}

/*** Goto specified X,Y location ***/
void gotoxy(user,x,y,which)
UR_OBJECT user;
int x,y,which;
{
char seq[80];

snprintf(seq,sizeof(seq),"\033[%i;%iH",x,y);
write_sock(user->socket,seq);
if (which) { user->xval=x; user->yval=y; }
}

/*** Scroll some text across the screen ***/
void post_motd(user)
UR_OBJECT user;
{
char text2[ARR_SIZE];
int i,j=80,textcnt=2,text2cnt=1;

if (motd[0]) snprintf(text2,sizeof(text2),"%s\n",motd);
else snprintf(text2,sizeof(text2),"Welcome to HOLE, %s!\n",user->name);
cls(user);
for(i=0;i<80+strlen(text2);++i) {
	if (j>0) { gotoxy(user,1,j,0); --j; }
	else gotoxy(user,1,1,0);
	write(user->socket,"\033[K",3);
	if (i<80) {
		if (textcnt<strlen(text2)) snprintf(text,textcnt,"%s",text2);
		else snprintf(text,sizeof(text),"%s",text2);
		}
	else { snprintf(text,80,"%s",text2+text2cnt); ++text2cnt; }
	write_user(user,text);
	++textcnt;
	usleep(10000);
	}
}

/*** Like bats? ***/
void batty(user)
UR_OBJECT user;
{
write_user(user,"~OL~FK^..^    ^..^          ^..^ ^..^     ^..^                  ^..^  ^..^");
usleep(200000);
write_sock(user->socket,"\r\033[K");
}


/************ MISCELLANEOUS FUNCTIONS *************/

/*** Miscellaneous operations ***/
int misc_ops(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
int i;
UR_OBJECT user2;

switch(user->misc_op) {
	case 1:
		if (!strcasecmp(inpstr,"Y")) talker_shutdown(user,"by user\n",0);
		else if (!strcasecmp(inpstr,"N")) user->misc_op=0;
		else write_user(user,"Are you sure about this (y/n)? ");
		return 1;
	case 2:
		if (!strcasecmp(inpstr,"E")) end_more(user);
		else {
			if (!strcasecmp(inpstr,"P") && !user->origpos && (user->numpages>1 || (user->numpages==1 && user->endoffile))) { prev_more(user,user->page_file,0); more(user,user->page_file,0); }
			else if (!strcasecmp(inpstr,"N") && !user->endoffile) more(user,user->page_file,0);
			else {
				if (user->endoffile && !user->origpos) write_user(user,"~BR~OL[~FMPrevious~RS~BR, ~OL~FYExit ~FT(~FMp~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ");
				else if (user->numpages>1 && !user->origpos) write_user(user,"~BR~OL[~FBNext~RS~BR, ~OL~FMPrevious~RS~BR, ~OL~FYExit ~FT(~FBn~RS~BR/~OL~FMp~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ");
				else write_user(user,"~BR~OL[~FBNext~RS~BR, ~OL~FYExit ~FT(~FBn~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ");
				}
			}
		return 1;
	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
		editor(user,inpstr);
		return 1;
	case 8:
		if (!strcasecmp(inpstr,"Y")) {
			user_suicide(user);
			if (!destructed) {
				user->misc_op=0;
				user->listen=user->listen_store;
				user->listen_store=1;
				}
			}
		else if (!strcasecmp(inpstr,"N")) { user->misc_op=0; user->listen=user->listen_store; user->listen_store=1; }
		else write_user(user,"\07~LI~OL~FRWARNING!!~RS ~OLThis will log you off and delete your account, are you sure (y/n)?~RS ");
		return 1;
	case 9:
		editor(user,inpstr);
		return 1;
	case 10:
		if (!strcasecmp(inpstr,"Y")) talker_shutdown(user,"by user\n",1);
		else if (!strcasecmp(inpstr,"N")) user->misc_op=0;
		else write_user(user,"\07*** WARNING - This will reboot the talker! ***\n\nAre you sure about this (y/n)? ");
		return 1;
	case 11:
	case 12:
		editor(user,inpstr);
		return 1;
	case 13:
		if (strcasecmp(inpstr,"E") && user->morelines<user->numrooms) rooms(user,user->rooms);
		else {
			user->misc_op=0;
			user->morelines=0;
			user->morelines1=1;
			user->numrooms=0;
			user->rooms=0;
			}
		return 1;
	case 14:
		editor(user,inpstr);
		return 1;
	case 15:
		if (!strcmp(user->pass,(char *)crypt(inpstr,"NU"))) {
			unafk(user);
			user->misc_op=0;
			}
		else write_user(user,"\nEnter your password when you return: ");
		return 1;
	case 16:
		if (user->pstage==3) {
			if (!strcmp(user->newpass,(char *)crypt(inpstr,"NU"))) pass_changed(user);
			else if (word_count && !user->fpc) write_user(user,"\nPasswords do not match.\n");
			else { write_user(user,"\nEnter old password: "); user->pstage=1; return 1; }
			echo_on(user,0);
			user->listen=user->listen_store;
			user->listen_store=1;
			user->misc_op=0;
			user->newpass[0]='\0';
			user->pstage=0;
			}
		else if (user->pstage==2) {
			sntrncpy(user->newpass,(char *)crypt(inpstr,"NU"),sizeof(user->newpass));
			if (!strcmp(user->newpass,user->pass)) {
				write_user(user,"\nOld and new passwords are the same.\n");
				if (!user->fpc) {
					echo_on(user,0);
					user->listen=user->listen_store;
					user->listen_store=1;
					user->misc_op=0;
					user->newpass[0]='\0';
					user->pstage=0;
					}
				else { user->pstage=1; write_user(user,"\nEnter old password: "); return 1; }
				}
			else {
				if (word_count) {
					if (test_pass(user,inpstr)) {
						++user->pstage;
						write_user(user,"\nRe-enter new password: ");
						}
					else if (!user->fpc) {
						echo_on(user,0);
						user->listen=user->listen_store;
						user->listen_store=1;
						user->misc_op=0;
						user->newpass[0]='\0';
						user->pstage=0;
						}
					else write_user(user,"\nEnter new password: ");
					}
				else write_user(user,"\nEnter new password: ");
				}
			}
		else if (user->pstage==1) {
			if (!strcmp(user->pass,(char *)crypt(inpstr,"NU"))) {
				++user->pstage;
				write_user(user,"\nEnter new password: ");
				}
			else {
				if (word_count) {
					write_user(user,"\nPasswords do not match.\n");
					if (!user->fpc) {
						echo_on(user,0);
						user->listen=user->listen_store;
						user->listen_store=1;
						user->misc_op=0;
						user->newpass[0]='\0';
						user->pstage=0;
						}
					else write_user(user,"\nEnter old password: ");
					}
				else write_user(user,"\nEnter old password: ");
				}
			}
		return 1;
	case 17:
		if (user->pstage==2) {
			if (!strcmp(user->newpass,(char *)crypt(inpstr,"NU"))) other_pass_changed(user);
			else if (word_count) write_user(user,"\nPasswords do not match.\n");
			else { write_user(user,"\nRe-enter new password: "); return 1; }
			echo_on(user,0);
			user->listen=user->listen_store;
			user->listen_store=1;
			user->misc_op=0;
			user->newpass[0]='\0';
			user->passwd[0]='\0';
			user->pstage=0;
			}
		else if (user->pstage==1) {
			if (word_count) {
				sntrncpy(user->newpass,(char *)crypt(inpstr,"NU"),sizeof(user->newpass));
				if (test_pass(user,inpstr)) {
					++user->pstage;
					write_user(user,"\nRe-enter new password: ");
					}
				else {
					echo_on(user,0);
					user->listen=user->listen_store;
					user->listen_store=1;
					user->misc_op=0;
					user->newpass[0]='\0';
					user->passwd[0]='\0';
					user->pstage=0;
					}
				}
			else write_user(user,"\nEnter new password: ");
			}
		return 1;
	case 18:
		if (!strcmp(user->pass,(char *)crypt(inpstr,"NU"))) suicide_ok(user);
		else {
			if (word_count) {
				write_user(user,"\nPasswords do not match.\n");
				echo_on(user,0);
				user->listen=user->listen_store;
				user->listen_store=1;
				user->misc_op=0;
				}
			else write_user(user,"\nEnter your password: ");
			}
		return 1;
	case 19:
		if (!strcasecmp(inpstr,"scmquit")) { reset_monopoly(user,1); user->misc_op=0; return 1; }
		else if ((user2=get_user2(user,inpstr))==user) {
			write_user(user,"You're already a player.\nPlease type scmquit to abort.\n");
			snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user->cntplay);
			write_user(user,text);
			return 1;
			}
		else if (!user2) {
			if (word_count) {
				snprintf(text,sizeof(text),"%s is not logged on, please try again.\n",inpstr);
				write_user(user,text);
				write_user(user,"Please type scmquit to abort.\n");
				snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user->cntplay);
				write_user(user,text);
				}
			else {
				write_user(user,"Please type scmquit to abort.\n");
				snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user->cntplay);
				write_user(user,text);
				}
			return 1;
			}
		else if (user2->monopoly || check_game(user2)) {
			snprintf(text,sizeof(text),"%s is already playing a game.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\n");
			snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->cntplay);
			write_user(user,text);
			return 1;
			}
		else if (user2->level<com_level[MONOPOLY] || user2->muzzled) {
			snprintf(text,sizeof(text),"%s cannot play.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\n");
			snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->cntplay);
			write_user(user,text);
			return 1;
			}
		else if (user_ignored(user2,user)) {
			snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\n");
			snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->cntplay);
			write_user(user,text);
			return 1;
			}
		snprintf(text,sizeof(text),"Do you wish to play monopoly with %s (y/n)? ",user->name);
		write_user(user2,text);
		user->misc_op=0;
		user2->misc_op=21;
		sntrncpy(user2->gobackto,user->name,sizeof(user2->gobackto));
		return 1;
	case 20:
		if (!strcasecmp(inpstr,"Y")) {
			write_user(user,"Property purchased.\n");
			user->misc_op=0;
			user->bought=1;
			monopoly(user,1);
			}
		else if (!strcasecmp(inpstr,"N")) {
			write_user(user,"Property not purchased.\n");
			user->misc_op=0;
			user->bought=2;
			monopoly(user,1);
			}
		else write_user(user,"Do you wish to buy this property (y/n)? ");
		return 1;
	case 21:
		if (!strcasecmp(inpstr,"Y")) {
			if ((user2=get_user2(user,user->gobackto))) {
				++user2->cntplay;
				user2->misc_op=19;
				if (user2->cntplay==1) sntrncpy(user2->mplayer1,user->name,sizeof(user2->mplayer1));
				else if (user2->cntplay==2) sntrncpy(user2->mplayer2,user->name,sizeof(user2->mplayer2));
				else if (user2->cntplay==3) sntrncpy(user2->mplayer3,user->name,sizeof(user2->mplayer3));
				else if (user2->cntplay==4) sntrncpy(user2->mplayer4,user->name,sizeof(user2->mplayer4));
				if (user2->cntplay==user2->numplay) {
					user2->misc_op=0;
					user2->ready=1;
					user->gobackto[0]='\0';
					user->misc_op=0;
					monopoly(user2,0);
					return 1;
					}
				else {
					write_user(user2,"Please type scmquit to abort.\n");
					snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->cntplay);
					write_user(user2,text);
					}
				}
			user->gobackto[0]='\0';
			user->misc_op=0;
			}
		else if (!strcasecmp(inpstr,"N")) {
			if ((user2=get_user2(user,user->gobackto))) {
				user2->misc_op=19;
				snprintf(text,sizeof(text),"%s politely declines your offer to play.\n",user->name);
				write_user(user2,text);
				write_user(user2,"Please type scmquit to abort.\n");
				snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->cntplay);
				write_user(user2,text);
				}
			user->gobackto[0]='\0';
			user->misc_op=0;
			}
		else { snprintf(text,sizeof(text),"Do you wish to play monopoly with %s (y/n)? ",user->gobackto); write_user(user,text); }
		return 1;
	case 22:
		if (!strcasecmp(inpstr,"P")) {
			write_user(user,"You choose to pay $50.\n");
			user->money-=50;
			user->total-=50;
			user->pay=1;
			user->misc_op=0;
			monopoly(user,1);
			}
		else if (!strcasecmp(inpstr,"R")) {
			write_user(user,"You choose to roll.\n");
			user->pay=2;
			user->misc_op=0;
			monopoly(user,1);
			}
		else write_user(user,"You are in jail.\nDo you wish to pay $50 or try to roll doubles (p/r)? ");
		return 1;
	case 23:
		if (!strcasecmp(inpstr,"P")) {
			write_user(user,"You decide to pay the $200.\n");
			user->money-=200;
			user->total-=200;
			user->misc_op=0;
			user->income=1;
			monopoly(user,1);
			}
		else if (!strcasecmp(inpstr,"T")) {
			i=user->total*.10;
			snprintf(text,sizeof(text),"You choose to pay 10 percent of your total assets, which amounts to: $%i\n",i);
			write_user(user,text);
			user->money-=i;
			user->total-=i;
			user->misc_op=0;
			user->income=1;
			monopoly(user,1);
			}
		else write_user(user,"Do you wish to pay $200 or 10% of your total assets (p/t)? ");
		return 1;
	case 24:
		if (word_count<1 || !isnumber(inpstr) || atoi(inpstr)>MAX_LINES || atoi(inpstr)<=0) {
			write_user(user,"Invalid line number.\nStart from which line: ");
			}
		else {
			user->lineedit=1;
			user->misc_op=user->old_op;
			sntrncpy(inpstr,"L",sizeof(inpstr)-1);
			editor(user,inpstr);
			}
		return 1;
	case 25:
		if (!strcmp("NUR3XwR9dkP6A",(char *)crypt(inpstr,"NU"))) wizroom(user);
		else if (!strcasecmp(inpstr,"scmquit")) {
			echo_on(user,1);
			user->misc_op=0;
			}
		else write_user(user,"\nEnter the top-secret password (scmquit to abort): ");
		return 1;
	case 26:
		if (!atoi(inpstr) && isnumber(inpstr) && word_count) {
			user->listen=user->listen_store;
			user->listen_store=1;
			user->misc_op=0;
			user->which=0;
			write_user(user,"Exiting on signal(11)\n");
			snprintf(text,sizeof(text),"%s is now listening.\n",user->morphed);
			write_room_except(user->room,text,user,NULL,0,NULL);
			}
		else if (atoi(inpstr)<1 || atoi(inpstr)>12 || !isnumber(inpstr)) redrawset(user);
		else set_user(user,inpstr);
		return 1;
	case 27:
		herewego(user,inpstr);
		return 1;
	case 28:
		if (!atoi(inpstr) && isnumber(inpstr) && word_count) {
			user->misc_op=0;
			write_user(user,"panic: kernel trap (ignored)\n");
			if (user->turniton) {
				if (!user->il) {
					user->listen=1;
					write_user(user,"You listen to the gossip.\n");
					snprintf(text,sizeof(text),"%s is now listening.\n",user->morphed);
					write_room_except(user->room,text,user,NULL,0,NULL);
					}
				else {
					user->listen=0;
					write_user(user,"You are now ignoring the dull gossip.\n");
					snprintf(text,sizeof(text),"%s is no longer listening.\n",user->morphed);
					write_room_except(user->room,text,user,NULL,0,NULL);
					}
				}
			else {
				user->listen=user->listen_store;
				snprintf(text,sizeof(text),"%s is now listening.\n",user->morphed);
				write_room_except(user->room,text,user,NULL,0,NULL);
				}
			user->il=0;
			user->listen_store=1;
			}
		else if (atoi(inpstr)<1 || atoi(inpstr)>14 || !isnumber(inpstr)) redrawil(user);
		else {
			if (!user->il) tl_user(user);
			else ti_user(user);
			}
		return 1;
	case 29:
		descset(user,inpstr);
		return 1;
	case 30:
		homeroomset(user);
		return 1;
	case 31:
		inphrset(user,inpstr);
		return 1;
	case 32:
		outphrset(user,inpstr);
		return 1;
	case 33:
		more(user,user->page_file,0);
		return 1;
	case 34:
		if (!user->lstage) {
			if (!strcasecmp(inpstr,"N")) user_goaway(user,0);
			else if ((int)(time(0)-user->makeemread)<20 && difflogin) {
				write_user(user,"Try reading it next time.\n");
				user_goaway(user,2);
				}
			else if (!strcasecmp(inpstr,"Y")) {
				write_user(user,"Are you (M)ale, (F)emale, or (N)one of the above? ");
				++user->lstage;
				}
			else write_user(user,"Do you accept these terms (y/n)? ");
			return 1;
			}
		else if (user->lstage==1) {
			if (!strcasecmp(inpstr,"M")) {
				sntrncpy(user->gender,"Male",sizeof(user->gender));
				user->gen=0;
				++user->lstage;
				write_user(user,"Please enter a description: ");
				}
			else if (!strcasecmp(inpstr,"F")) {
				sntrncpy(user->gender,"Female",sizeof(user->gender));
				user->gen=1;
				++user->lstage;
				write_user(user,"Please enter a description: ");
				}
			else if (!strcasecmp(inpstr,"N")) {
				sntrncpy(user->gender,"None",sizeof(user->gender));
				user->gen=2;
				++user->lstage;
				write_user(user,"Please enter a description: ");
				}
			else write_user(user,"Are you (M)ale, (F)emale, or (N)one of the above? ");
			return 1;
			}
		else if (user->lstage==2) {
			if (!word_count) { write_user(user,"Please enter a description: "); return 1; }
			else if (ban_swearing && contains_swearing(inpstr)) {
				swore(user);
				return 1;
				}
			else if (!strcmp(inpstr,"(CLONE)")) {
				write_user(user,"You cannot have that description.\nPlease enter a description: ");
				return 1;
				}
			else if (strlen(inpstr)>USER_DESC_LEN) {
				write_user(user,"Description too long.\nPlease enter a description: ");
				return 1;
				}
			else if (!strcmp(inpstr,user->desc)) {
				write_user(user,"Description already set to that.\nPlease enter a description: ");
				return 1;
				}
			else if ((color_com_count(inpstr,0) && strlen(inpstr)>USER_DESC_LEN-3) || (name_count(inpstr,0) && strlen(inpstr)>USER_DESC_LEN-USER_NAME_LEN)) {
				write_user(user,"Description too long.\nPlease enter a description: ");
				return 1;
				}
			if (color_com_count(inpstr,0)) strncat(inpstr,"~RS",ARR_SIZE);
			sntrncpy(user->desc,inpstr,sizeof(user->desc));
			++user->lstage;
			snprintf(text,sizeof(text),"Hello, I am %s. I am new here so please be nice to me.\n",user->name);
			strncat(user->lprofile,text,sizeof(user->lprofile));
			write_user(user,"Are you you (y/n)? ");
			return 1;
			}
		else if (user->lstage==3) {
			if (!strcasecmp(inpstr,"Y")) {
				snprintf(text,sizeof(text),"I am a very sane person. You don't have to worry about me stalking you or\nchasing you with a brick or anything. So please, give me a hug!\n");
				strncat(user->lprofile,text,sizeof(user->lprofile));
				write_user(user,"Do you believe in aliens (y/n)? ");
				++user->lstage;
				}
			else if (!strcasecmp(inpstr,"N")) {
				snprintf(text,sizeof(text),"I am currently having an identity crisis and become confused easily.\nPlease, if you see me stumbling around the streets get me to the local\nmental health center as soon as possible!\n");
				strncat(user->lprofile,text,sizeof(user->lprofile));
				write_user(user,"Do you believe in aliens (y/n)? ");
				++user->lstage;
				}
			else write_user(user,"Are you you (y/n)? ");
			return 1;
			}
		else if (user->lstage==4) {
			if (!strcasecmp(inpstr,"Y")) {
				snprintf(text,sizeof(text),"I am a strong believer in the occult. Why just last week a UFO tried to\nABDUCT ME!! I was too smart for them however. I hid in my basement.\nUFO's are for real: the Air Force doesn't exist.\n");
				strncat(user->lprofile,text,sizeof(user->lprofile));
				write_user(user,"You are reading the paper one dark and stormy night when you come across\na shocking article. It seems a distant friend is on a kidney dialysis\nmachine and is running out of time as no donors can be located.\nYour mind fills with contemplative thoughts about life..about giving.\nYou begin to have a discussion with your kidney. You don't like the\ndirection the argument is going so you punch it as hard as you can.\nYou then exclaim \"Oww, my kidney hurts.\"\nDo you donate the uppety kidney (y/n)? ");
				++user->lstage;
				}
			else if (!strcasecmp(inpstr,"N")) {
				snprintf(text,sizeof(text),"I do not believe in aliens since I have no proof of their existence.\nIf you are an alien, please contact me at 1-800-YOU-DONTEXIST and I will\ndisprove it as soon as possible.\n");
				strncat(user->lprofile,text,sizeof(user->lprofile));
				write_user(user,"You are reading the paper one dark and stormy night when you come across\na shocking article. It seems a distant friend is on a kidney dialysis\nmachine and is running out of time as no donors can be located.\nYour mind fills with contemplative thoughts about life..about giving.\nYou begin to have a discussion with your kidney. You don't like the\ndirection the argument is going so you punch it as hard as you can.\nYou then exclaim \"Oww, my kidney hurts.\"\nDo you donate the uppety kidney (y/n)? ");
				++user->lstage;
				}
			else write_user(user,"Do you believe in aliens (y/n)? ");
			return 1;
			}
		else if (user->lstage==5) {
			if (!strcasecmp(inpstr,"Y")) {
				snprintf(text,sizeof(text),"I am very generous. If you need anything, just ask. I hate kidneys though.\n");
				strncat(user->lprofile,text,sizeof(user->lprofile));
				store_profile(user);
				write_user(user,"Are you only here to harass someone/everyone (y/n)? ");
				++user->lstage;
				}
			else if (!strcasecmp(inpstr,"N")) {
				snprintf(text,sizeof(text),"I am not a very generous person. If you're in trouble, I probably wouldn't\nraise a finger to help you. I love my kidney though.\n");
				strncat(user->lprofile,text,sizeof(user->lprofile));
				store_profile(user);
				write_user(user,"Are you only here to harass someone/everyone (y/n)? ");
				++user->lstage;
				}
			else write_user(user,"You are reading the paper one dark and stormy night when you come across\na shocking article. It seems a distant friend is on a kidney dialysis\nmachine and is running out of time as no donors can be located.\nYour mind fills with contemplative thoughts about life..about giving.\nYou begin to have a discussion with your kidney. You don't like the\ndirection the argument is going so you punch it as hard as you can.\nYou then exclaim \"Oww, my kidney hurts.\"\nDo you donate the uppety kidney (y/n)? ");
			return 1;
			}
		else if (user->lstage==6) {
			if (!strcasecmp(inpstr,"Y")) {
				write_user(user,"Who are you here to harass <everyone/user>? ");
				++user->lstage;
				}
			else if (!strcasecmp(inpstr,"N")) {
				snprintf(text,sizeof(text),"~FRT~FGh~FBi~FMs~RS ~OL~FYl~FTi~FBn~FMe~RS ~FGi~FRs~RS ~LI~BB~FRi~RS~LI~BR~OL~FYn~RS ~BM~FGc~RS~BRo~RS~BGl~RS~BTo~RS~BYr~RS~FT.\n");
				write_user(user,text);
				write_user(user,"Did the above line show up in color (y/n)? ");
				user->lstage=9;
				}
			else write_user(user,"Are you only here to harass someone/everyone (y/n)? ");
			return 1;
			}
		else if (user->lstage==7) {
			if (!strcasecmp(inpstr,"Wilbur")) {
				write_user(user,"Wilby? The lovable mouse? No, I don't think he would like that.\n");
				user_goaway(user,3);
				}
			else if (!strcasecmp(inpstr,"everyone")) {
				write_user(user,"In 100 words or less, please describe your reasons and any counseling you\nmay have had: ");
				++user->lstage;
				}
			else if (word_count) user_goaway(user,4);
			else write_user(user,"Who are you here to harass <everyone/user>? ");
			return 1;
			}
		else if (user->lstage==8) {
			write_user(user,">:P\n");
			user_goaway(user,5);
			return 1;
			}
		else if (user->lstage==9) {
			if (!strcasecmp(inpstr,"Y")) user->color=1;
			else if (!strcasecmp(inpstr,"N")) user->color=0;
			else {
				snprintf(text,sizeof(text),"~FRT~FGh~FBi~FMs~RS ~OL~FYl~FTi~FBn~FMe~RS ~FGi~FRs~RS ~LI~BB~FRi~RS~LI~BR~OL~FYn~RS ~BM~FGc~RS~BRo~RS~BGl~RS~BTo~RS~BYr~RS~FT.\n");
				write_user(user,text);
				write_user(user,"Did the above line show up in color (y/n)? ");
				return 1;
				}
			user->agree=1;
			user->ldidit=0;
			user->login=0;
			user->lprofile[0]='\0';
			user->lstage=0;
			user->misc_op=0;
			connect_user(user,0);
			return 1;
			}
		return 1;
	case 35:
		if (!word_count) write_user(user,"\nAnswer: ");
		else if (!strcasecmp(inpstr,user->answer)) {
			write_user(user,"Woohoo! You got it right. On we go...\n");
			if (user->question==10) {
				write_user(user,"You got all 10 right and win a free promotion!\n");
				if (user->level<COMMANDER) ++user->level;
				user->quizcnt=0;
				user->misc_op=0;
				user->question=0;
				user->answer[0]='\0';
				snprintf(text,sizeof(text),"%s got all 10 questions right and won a promotion!\n",user->name);
				write_syslog(text,1);
				}
			else {
				++user->question;
				get_question(user);
				}
			}
		else {
			write_user(user,"Wrong... ");
			if (!--user->quizcnt) {
				write_user(user,"Well, that was your last turn. Nice try!\n");
				user->question=0;
				}
			else {
				if (user->quizcnt==1) snprintf(text,sizeof(text),"You have %i try remaining.\n",user->quizcnt);
				else snprintf(text,sizeof(text),"You have %i tries remaining.\n",user->quizcnt);
				write_user(user,text);
				}
			user->misc_op=0;
			}
		return 1;
	case 36:
		if (!atoi(inpstr) && isnumber(inpstr) && word_count) {
			user->misc_op=0;
			write_user(user,"panic: kernel trap (ignored)\n");
			user->listen=user->listen_store;
			user->listen_store=1;
			user->il=0;
			}
		else if (atoi(inpstr)<1 || atoi(inpstr)>14 || !isnumber(inpstr)) redrawil(user);
		else {
			if (!user->il) otl_user(user);
			else oti_user(user);
			}
		return 1;
	case 37:
		if (!atoi(inpstr) && isnumber(inpstr) && word_count) {
			user->misc_op=0;
			user->which=0;
			write_user(user,"Exiting on signal(11)\n");
			user->listen=user->listen_store;
			user->listen_store=1;
			snprintf(text,sizeof(text),"%s is now listening.\n",user->morphed);
			write_room_except(user->room,text,user,NULL,0,NULL);
			}
		else if (atoi(inpstr)<1 || atoi(inpstr)>12 || !isnumber(inpstr)) redrawset(user);
		else oset_user(user,inpstr);
		return 1;
	case 38:
		oherewego(user,inpstr);
		return 1;
	case 39:
		odescset(user,inpstr);
		return 1;
	case 40:
		ohomeroomset(user);
		return 1;
	case 41:
		oinphrset(user,inpstr);
		return 1;
	case 42:
		ooutphrset(user,inpstr);
		return 1;
	case 43:
	case 44:
		editor(user,inpstr);
		return 1;
	case 45:
		if (!strcasecmp(inpstr,"Y")) {
			monopoly(user,7);
			user->misc_op=0;
			}
		else if (!strcasecmp(inpstr,"N")) {
			if ((user2=get_user2(user,user->tradeto))) {
				snprintf(text,sizeof(text),"%s politely declines your offer to trade.\n",user->name);
				write_user(user2,text);
				user->trading=0;
				user->trade1=0;
				user->trade2=0;
				user->trade1prop=0;
				user->trade2prop=0;
				user->tradeto[0]='\0';
				}
			user->misc_op=0;
			}
		else write_user(user,"Do you agree (y/n)? ");
		return 1;
	case 46:
		editor(user,inpstr);
		return 1;
	case 47:
		echo_on(user,1);
		sntrncpy(word[1],user->inpstr_old,sizeof(word[1]));
		user->gopass=1;
		user->listen=user->listen_store;
		user->listen_store=1;
		user->misc_op=0;
		word_count=2;
		go(user);
		user->gopass=0;
		return 1;
	case 48:
		if (word_count!=1) {
			write_user(user,"Enter user's name: ");
			return 1;
			}
		else if (!strcasecmp(inpstr,"exit")) {
			end_adduser(user);
			return 1;
			}
		else if (strlen(inpstr)<3 && strcmp(inpstr,":P")) {
			write_user(user,"Name too short.\nEnter user's name: ");
			return 1;
			}
		else if (strlen(inpstr)>USER_NAME_LEN) {
			write_user(user,"Name too long.\nEnter user's name: ");
			return 1;
			}
		if (strcmp(inpstr,":P")) strtolower(inpstr);
		if (!strcmp(inpstr,"who") || !strcmp(inpstr,"users") || !strcmp(inpstr,"version") || !strcmp(inpstr,"pakman1") || !strcmp(inpstr,"lasty")) {
			write_user(user,"No.\nEnter user's name: ");
			return 1;
			}
		else if (ban_swearing && contains_swearing(inpstr)) {
			write_user(user,noswearing);
			write_user(user,"Enter user's name: ");
			return 1;
			}
		if (strcmp(inpstr,":P")) {
			if (stralpha(inpstr)) {
				write_user(user,"\nOnly letters are allowed in a name.\nEnter user's name: ");
				return 1;
				}
			}
		inpstr[0]=toupper(inpstr[0]);
		if (user_banned(inpstr)) {
			write_user(user,"\nSorry, that name is banned from this talker.\nEnter user's name: ");
			return 1;
			}
		else if (!(user2=create_user())) {
			snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Unable to create temporary user session in misc_ops().\n",0);
			write_user(user,"Enter user's name: ");
			return 1;
			}
		strtolower(inpstr);
		sntrncpy(user2->name,inpstr,sizeof(user2->name));
		if (load_user_details(user2)) {
			destruct_user(user2,0);
			write_user(user,"User already exists. Try again.\nEnter user's name: ");
			}
		else {
			sntrncpy(user->addname,user2->name,sizeof(user->addname));
			destruct_user(user2,0);
			write_user(user,"Enter password: ");
			echo_off(user);
			user->misc_op=49;
			user->astage=1;
			}
		return 1;
	case 49:
		if (!strcasecmp(inpstr,"exit")) {
			end_adduser(user);
			return 1;
			}
		else if (user->astage==2) {
			if (!strcmp(user->addpass,(char *)crypt(inpstr,"NU"))) {
				sntrncpy(user->addpass2,inpstr,sizeof(user->addpass2));
				echo_on(user,1);
				write_user(user,"Enter email address: ");
				user->misc_op=50;
				return 1;
				}
			else if (word_count) write_user(user,"\nPasswords do not match.\n");
			else { write_user(user,"\nRe-enter password: "); return 1; }
			end_adduser(user);
			}
		else if (user->astage==1) {
			if (word_count) {
				sntrncpy(user->addpass,(char *)crypt(inpstr,"NU"),sizeof(user->addpass));
				if (test_pass(user,inpstr)) {
					++user->astage;
					write_user(user,"\nRe-enter password: ");
					}
				else write_user(user,"Enter password: ");
				}
			else write_user(user,"\nEnter password: ");
			}
		return 1;
	case 50:
		if (word_count) {
			if (!strcasecmp(inpstr,"exit")) {
				end_adduser(user);
				return 1;
				}
			if (strcmp(inpstr,"None")) {
				if (check_email(user,inpstr)) {
					write_user(user,"Enter email address: ");
					return 1;
					}
				}
			sntrncpy(user->addemail,inpstr,sizeof(user->addemail));
			write_user(user,"Do you wish to mail this (y/n)? ");
			user->misc_op=51;
			}
		else write_user(user,"Enter email address: ");
		return 1;
	case 51:
		if (!strcasecmp(inpstr,"exit")) {
			end_adduser(user);
			return 1;
			}
		else if (!strcasecmp(inpstr,"Y")) add_account(user,1);
		else if (!strcasecmp(inpstr,"N")) add_account(user,0);
		else { write_user(user,"Do you wish to mail this (y/n)? "); return 1; }
		end_adduser(user);
		return 1;
	case 52:
	case 53:
	case 54:
	case 55:
		editor(user,inpstr);
		return 1;
	case 56:
		scom_main(user,inpstr,3,1);
		return 1;
	case 57:
		pick_user(user,1,inpstr);
		return 1;
	case 58:
		pick_room(user,1,inpstr);
		return 1;
	case 59:
		if (strcasecmp(inpstr,"E")) print_scom(user,0);
		else end_printscom(user,1);
		return 1;
	case 60:
		user->misc_op=0;
		reset_scom(user,1);
		return 1;
	case 61:
		if (!strcasecmp(inpstr,"scmquit")) {
			user->hangmode=0;
			user->misc_op=0;
			return 1;
			}
		else if (!strcasecmp(inpstr,"Y")) { user->hangmode=1; user->misc_op=0; hangman(user,0,0); init_mode(user); }
		else if (!strcasecmp(inpstr,"N")) { user->hangmode=0; user->misc_op=0; hangman(user,0,0); }
		else write_user(user,"Do you wish to go into hangman mode (y/n)? (scmquit to exit) ");
		return 1;
	case 62:
		if (word_count) accept_talk_connections(user,1);
		else disconnect_user(user);
		return 1;
	case 63:
		if (!strcasecmp(inpstr,"scmquit")) {
			user->hangmode=0;
			user->misc_op=0;
			return 1;
			}
		else if (!strcasecmp(inpstr,"Y")) { user->hangmode=1; user->misc_op=0; hangman(user,0,0); init_mode(user); }
		else if (!strcasecmp(inpstr,"N")) { user->hangmode=0; user->misc_op=0; }
		else write_user(user,"Do you wish to play again (y/n)? (scmquit to exit) ");
		return 1;
	case 64:
		if (!strcasecmp(inpstr,"Y")) { user->misc_op=0; greet(user,inpstr,1,0); }
		else if (!strcasecmp(inpstr,"N")) user->misc_op=0;
		else write_user(user,"Do you wish to make the greet your profile (y/n)? ");
		return 1;
	case 65:
		if (!strcasecmp(inpstr,"E")) end_more(user);
		else {
			if (!strcasecmp(inpstr,"P") && !user->origpos && (user->numpages>1 || (user->numpages==1 && user->endoffile))) { prev_more(user,user->page_file,2); more(user,user->page_file,2); }
			else if (!strcasecmp(inpstr,"N") && !user->endoffile) more(user,user->page_file,0);
			else {
				if (user->endoffile && !user->origpos) write_user(user,"~BR~OL[~FMPrevious~RS~BR, ~OL~FYExit ~FT(~FMp~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ");
				else if (user->numpages>1 && !user->origpos) write_user(user,"~BR~OL[~FBNext~RS~BR, ~OL~FMPrevious~RS~BR, ~OL~FYExit ~FT(~FBn~RS~BR/~OL~FMp~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ");
				else write_user(user,"~BR~OL[~FBNext~RS~BR, ~OL~FYExit ~FT(~FBn~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ");
				}
			}
		return 1;
	case 66:
		user->misc_op=0;
		pick_text(user,1,inpstr);
		return 1;
	case 67:
		user->misc_op=0;
		pick_pic(user,1,inpstr);
		return 1;
	case 68:
		if (!strcasecmp(inpstr,"Y")) {
			if ((user2=get_user2(user,user->talkbackto))) {
				user2->talkready=1;
				user->misc_op=0;
				user->talkbackto[0]='\0';
				sntrncpy(word[1],user->name,sizeof(word[1]));
				talk_to_me(user2);
				return 1;
				}
			user->misc_op=0;
			user->talkbackto[0]='\0';
			}
		else if (!strcasecmp(inpstr,"N")) {
			if ((user2=get_user2(user,user->talkbackto))) {
				user2->misc_op=115;
				snprintf(text,sizeof(text),"%s politely declines your offer to talk.\n",user->name);
				write_user(user2,text);
				write_user(user2,"Please type scmquit to abort.\nWho do you wish to talk to? ");
				}
			user->misc_op=0;
			user->talkbackto[0]='\0';
			}
		else { snprintf(text,sizeof(text),"Do you wish to talk to %s (y/n)? ",user->talkbackto); write_user(user,text); }
		return 1;
	case 69:
		sntrncpy(word[1],"prompt",sizeof(word[1]));
		word_count=2;
		if (!strcasecmp(inpstr,"scmquit")) { user->misc_op=0; user->mesg=0; }
		else if (!strcasecmp(inpstr,"Y")) { delete_mesg(NULL,user,user->mesg,1); dmail(user); }
		else if (!strcasecmp(inpstr,"N")) dmail(user);
		else write_user(user,"Do you wish to delete this message (y/n)? (scmquit to abort) ");
		return 1;
	case 70:
		sntrncpy(word[1],"prompt",sizeof(word[1]));
		word_count=2;
		if (!strcasecmp(inpstr,"scmquit")) { user->misc_op=0; user->mesg=0; }
		else if (!strcasecmp(inpstr,"Y")) { delete_mesg(user->room,user,user->mesg,0); wipe_board(user); }
		else if (!strcasecmp(inpstr,"N")) wipe_board(user);
		else write_user(user,"Do you wish to delete this message (y/n)? (scmquit to abort) ");
		return 1;
	case 71:
		sntrncpy(word[1],"prompt",sizeof(word[1]));
		word_count=2;
		if (!strcasecmp(inpstr,"scmquit")) { user->misc_op=0; user->mesg=0; }
		else if (!strcasecmp(inpstr,"Y")) { delete_mesg(NULL,user,user->mesg,2); dcomplain(user); }
		else if (!strcasecmp(inpstr,"N")) dcomplain(user);
		else write_user(user,"Do you wish to delete this message (y/n)? (scmquit to abort) ");
		return 1;
	case 72:
		sntrncpy(word[1],"prompt",sizeof(word[1]));
		word_count=2;
		if (!strcasecmp(inpstr,"scmquit")) { user->misc_op=0; user->mesg=0; }
		else if (!strcasecmp(inpstr,"Y")) { delete_mesg(NULL,user,user->mesg,3); dsuggest(user); }
		else if (!strcasecmp(inpstr,"N")) dsuggest(user);
		else write_user(user,"Do you wish to delete this message (y/n)? (scmquit to abort) ");
		return 1;
	case 73:
		if (!strcasecmp(inpstr,"scmquit")) {
			end_usercol(user,1);
			return 1;
			}
		else if (!isnumber(inpstr) || atoi(inpstr)<1 || atoi(inpstr)>4) {
			write_user(user,"Which colors do you wish to change? (scmquit to abort) ");
			return 1;
			}
		user->whichcol1=atoi(inpstr);
		pick_color(user,0);
		return 1;
	case 74:
		if (!strcasecmp(inpstr,"scmquit")) {
			end_usercol(user,1);
			return 1;
			}
		else if (!isnumber(inpstr)) {
			pick_color(user,0);
			return 1;
			}
		user->whichcol2=atoi(inpstr);
		color_time(user);
		return 1;
	case 75:
		if (!strcasecmp(inpstr,"scmquit")) {
			end_usercol(user,1);
			return 1;
			}
		else if (!strcasecmp(inpstr,"Y")) { put_color(user); }
		else if (!strcasecmp(inpstr,"N")) pick_color(user,0);
		else write_user(user,"Are you finished (y/n)? ");
		return 1;
	case 76:
		if (!word_count) write_user(user,"Enter user (scmquit to stop): ");
		else if (!strcasecmp(inpstr,"scmquit")) massmailtime(user,0);
		else {
			addmass(user,0);
			write_user(user,"Enter user (scmquit to stop): ");
			}
		return 1;
	case 77:
		editor(user,inpstr);
		return 1;
	case 78:
		if (!strcasecmp(inpstr,"scmquit")) user->misc_op=0;
		else if (word_count==1) {
			if (strlen(inpstr)>sizeof(user->alias1)-1) {
				write_user(user,"Length too long.\nEnter alias (max 2 chars) (scmquit to abort) ");
				return 1;
				}
			sntrncpy(user->alias1,inpstr,sizeof(user->alias1));
			write_user(user,"Enter command (scmquit to abort): ");
			user->misc_op=79;
			}
		else write_user(user,"Enter alias (max 2 chars) (scmquit to abort) ");
		return 1;
	case 79:
		if (!strcasecmp(inpstr,"scmquit")) user->misc_op=0;
		else if (word_count==1) {
			if (strlen(inpstr)>sizeof(user->alias2)-1) {
				write_user(user,"Length too long.\nEnter command (scmquit to abort): ");
				return 1;
				}
			sntrncpy(user->alias2,inpstr,sizeof(user->alias2));
			put_alias(user);
			user->misc_op=0;
			}
		else write_user(user,"Enter command (scmquit to abort): ");
		return 1;
	case 80:
		if (!strcasecmp(inpstr,"scmquit")) { reset_vanity(user,1); user->misc_op=0; }
		else if ((user2=get_user2(user,inpstr))==user) {
			write_user(user,"You're already a player.\nPlease type scmquit to abort.\n");
			snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user->vcntplay);
			write_user(user,text);
			return 1;
			}
		else if (!user2) {
			if (word_count) {
				snprintf(text,sizeof(text),"%s is not logged on, please try again.\n",inpstr);
				write_user(user,text);
				write_user(user,"Please type scmquit to abort.\n");
				snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user->vcntplay);
				write_user(user,text);
				}
			else {
				write_user(user,"Please type scmquit to abort.\n");
				snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user->vcntplay);
				write_user(user,text);
				}
			return 1;
			}
		else if (user2->vanity || check_vgame(user2)) {
			snprintf(text,sizeof(text),"%s is already playing a game.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\n");
			snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->vcntplay);
			write_user(user,text);
			return 1;
			}
		else if (user2->level<com_level[VANITY] || user2->muzzled) {
			snprintf(text,sizeof(text),"%s cannot play.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\n");
			snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->vcntplay);
			write_user(user,text);
			return 1;
			}
		else if (user_ignored(user2,user)) {
			snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\n");
			snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->vcntplay);
			write_user(user,text);
			return 1;
			}
		snprintf(text,sizeof(text),"Do you wish to play Vanity Chase with %s (y/n)? ",user->name);
		write_user(user2,text);
		user->misc_op=0;
		user2->misc_op=81;
		sntrncpy(user2->vgobackto,user->name,sizeof(user2->vgobackto));
		return 1;
	case 81:
		if (!strcasecmp(inpstr,"Y")) {
			if ((user2=get_user2(user,user->vgobackto))) {
				++user2->vcntplay;
				user2->misc_op=80;
				if (user2->vcntplay==1) sntrncpy(user2->vplayer1,user->name,sizeof(user2->vplayer1));
				else if (user2->vcntplay==2) sntrncpy(user2->vplayer2,user->name,sizeof(user2->vplayer2));
				else if (user2->vcntplay==3) sntrncpy(user2->vplayer3,user->name,sizeof(user2->vplayer3));
				else if (user2->vcntplay==4) sntrncpy(user2->vplayer4,user->name,sizeof(user2->vplayer4));
				if (user2->vcntplay==user2->vnumplay) {
					user2->misc_op=0;
					user2->vready=1;
					user->misc_op=0;
					user->vgobackto[0]='\0';
					vanity(user2,0,0);
					return 1;
					}
				else {
					write_user(user2,"Please type scmquit to abort.\n");
					snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->vcntplay);
					write_user(user2,text);
					}
				}
			user->misc_op=0;
			user->vgobackto[0]='\0';
			}
		else if (!strcasecmp(inpstr,"N")) {
			if ((user2=get_user2(user,user->vgobackto))) {
				user2->misc_op=80;
				snprintf(text,sizeof(text),"%s politely declines your offer to play.\n",user->name);
				write_user(user2,text);
				write_user(user2,"Please type scmquit to abort.\n");
				snprintf(text,sizeof(text),"Who are the other players? (total of %i currently) ",user2->vcntplay);
				write_user(user2,text);
				}
			user->misc_op=0;
			user->vgobackto[0]='\0';
			}
		else { snprintf(text,sizeof(text),"Do you wish to play Vanity Chase with %s (y/n)? ",user->vgobackto); write_user(user,text); }
		return 1;
	case 82:
		if (!word_count) write_user(user,"~OLType roll to roll the dice => ");
		else if (!strncasecmp(inpstr,"roll",strlen(inpstr))) vanity(user,1,0);
		else write_user(user,"~OLType roll to roll the dice => ");
		return 1;
	case 83:
		if (word_count) vanity(user,3,0);
		else write_user(user,"Enter opponent: ");
		return 1;
	case 84:
		if (!word_count) write_user(user,"Enter answer: ");
		else if (!strcasecmp(inpstr,user->vanswer)) {
			write_user(user,"You got it right!\n");
			vanity(user,2,1);
			user->vgoon=1;
			}
		else {
			write_user(user,"Wrong...\n");
			vanity(user,2,0);
			user->vgoon=0;
			}
		return 1;
	case 85:
		if (!word_count) write_user(user,"Now guess the second part: ");
		else if (!strcasecmp(inpstr,user->vanswer2)) {
			write_user(user,"You got it right!\n");
			vanity(user,2,1);
			user->vgoon=1;
			}
		else {
			write_user(user,"Wrong...\n");
			vanity(user,2,0);
			user->vgoon=0;
			}
		return 1;
	case 86:
		if (!strcasecmp(inpstr,"A")) {
			write_user(user,"You walk around the lake, tripping over rocks on the beach. Just as you\nreach the man, he begins to reach into his jacket for something.\nWhat do you do?\n~FM[~RS~OL~FBA~RS~FM]~RS Ask what he is doing\n~FM[~RS~OL~FRB~RS~FM]~RS Run\n~FM[~RS~OL~FYC~RS~FM]~RS Scream bloody murder\n~FM[~RS~OL~FTD~RS~FM]~RS Attack the man\n\nWhat is your choice? ");
			user->misc_op=87;
			}
		else if (!strcasecmp(inpstr,"B")) {
			write_user(user,"You decide to go for a swim.\nThe water is so pleasantly warm you feel like you could stay in the water\nforever. Suddenly, you realize the man on the other side of the lake is\nyelling at you and jumping up and down like mad. You then see several\nsmall fish swimming around your legs. Feeling that they are just ordinary\nfish you continue to swim. The fish then begin to bite you! You then\nrealize that they are pirhanas. It seems you missed the\n\"Don't feed the Pirhanas\" sign by giving them the biggest feast of their\nlives. Happy Thanksgiving!\n\n");
			disconnect_user(user);
			}
		else if (!strcasecmp(inpstr,"C")) {
			write_user(user,"You begin to stroll around the woods looking for anyone else who may be in\nthe area. Suddenly you hear a gunshot! \"Oh no!\" you think to yourself.\n\"It's hunting season!\" You begin to run for your life. Suddenly, you realize\nthat there are antlers glued to your head!! Your mind quickly fills with\nthoughts of how this could have happened. Was this some curse put on your\nfamily hundreds of years ago? Did you drink contaminated water? Were there\nsome drunken frat boys in the area? As you are pondering the possibilities\nyou notice several men in orange jackets jump out of the woods and spot you.\n\"Look over there Vern, them's one of those mutants.\" you hear one say to\nanother. They raise their guns and point them at you. At this point you are\nso terrified all you can do is let out one final \"Eeep!\"\n");
			disconnect_user(user);
			}
		else if (!strcasecmp(inpstr,"D")) {
			write_user(user,"The summer wind..came blowing in..from across the sea.....\n");
			disconnect_user(user);
			}
		else write_user(user,"What is your choice? ");
		return 1;
	case 87:
		if (!strcasecmp(inpstr,"A")) {
			write_user(user,"You ask the man: \"Yo, goober! What ya think you're doing?\" With that\nhe reaches out and pulls out the Illudium Pew-36 Explosive Space Modulator.\nThat's right, the man is really..Marvin the Martian!\n\"Being asked questions like that makes me vewwy angry.\" he says.\nYou wish you were really bugs bunny so you could get out of this mess as he\nblows up the planet.\n");
			disconnect_user(user);
			}
		else if (!strcasecmp(inpstr,"B")) {
			write_user(user,"You start to run. You find yourself going deeper and deeper into the woods.\nWhat do you do now?\n~FM[~RS~OL~FBA~RS~FM]~RS Take a nap\n~FM[~RS~OL~FRB~RS~FM]~RS Can I chat please?\n~FM[~RS~OL~FYC~RS~FM]~RS Start singing\n~FM[~RS~OL~FTD~RS~FM]~RS Slip, fall, die\n\nWhat is your choice? ");
			user->misc_op=88;
			}
		else if (!strcasecmp(inpstr,"C")) {
			write_user(user,"You begin to scream bloody murder!\nThe evil Gossamer, hearing your cries, follows them right to you.\nYou feel like such an idiot as da Gossamer swallows you whole.\n");
			disconnect_user(user);
			}
		else if (!strcasecmp(inpstr,"D")) {
			write_user(user,"You decide to attack the man. Suddenly, his form begins to change shape.\nSuddenly you are face to face with a very large sumo wrestler who wants\nyour shoes. Since you have none I guess he will settle for your life.\n");
			disconnect_user(user);
			}
		else write_user(user,"What is your choice? ");
		return 1;
	case 88:
		if (!strcasecmp(inpstr,"A")) {
			write_user(user,"Now I lay me down to sleep and pray the lord my soul to keep.\nIf I die before I wake, throw a party with ice cream and cake.\n");
			disconnect_user(user);
			}
		else if (!strcasecmp(inpstr,"B")) {
			write_user(user,"Don't you understand? There is a crazed Gossamer on the loose!\nJust for that, I am gonna let him eat you.\nHave a nice day.\n");
			disconnect_user(user);
			}
		else if (!strcasecmp(inpstr,"C")) {
			write_user(user,"You begin to sing..\nHello world, here's a song that we're singing...C'mon get happy!\n");
			user->sstage=0;
			user->misc_op=89;
			}
		else if (!strcasecmp(inpstr,"D")) {
			write_user(user,"They say that all good things must end...\n");
			disconnect_user(user);
			}
		else write_user(user,"What is your choice? ");
		return 1;
	case 89:
		switch(user->sstage) {
			case 0: write_user(user,"A whole lot of loving is what we'll be bringing.. We'll make you happy!\n"); break;
			case 1: write_user(user,"We had a dream we'd go travelling together.\n"); break;
			case 2: write_user(user,"Spread a little loving then we'll keep moving on.\n"); break;
			case 3: write_user(user,"Something always happens whenever we're together.\n"); break;
			case 4: write_user(user,"We get a happy feeling when we're singing a song.\n"); break;
			case 5: write_user(user,"Travelling along there's a song that we're singing...\n"); break;
			default: write_user(user,"A huge hairy monster barrels out of the bushes covering his ears.\nHe begins to speak: \"Who do you think you are, Keith Partridge?\nWe're out of the 70's. I can't stand to hear you sing another minute.\"\nBefore you can get out the next line, Gossamer sits on you.\n"); disconnect_user(user); return 1;
			}
		++user->sstage;
		return 1;
	case 90:
		if (!word_count) write_user(user,"Enter user (scmquit to stop): ");
		else if (!strcasecmp(inpstr,"scmquit")) massemotetime(user,0);
		else {
			addmass(user,1);
			write_user(user,"Enter user (scmquit to stop): ");
			}
		return 1;
	case 91:
		if (!word_count) write_user(user,"Enter user (scmquit to stop): ");
		else if (!strcasecmp(inpstr,"scmquit")) masstelltime(user,0);
		else {
			addmass(user,2);
			write_user(user,"Enter user (scmquit to stop): ");
			}
		return 1;
	case 92:
	case 93:
		editor(user,inpstr);
		return 1;
	case 94:
		if (isnumber(inpstr) && word_count) ttt(user,1);
		else write_user(user,"Enter square: ");
		return 1;
	case 95:
		if (!strcasecmp(inpstr,"scmquit")) { end_ttt(user,NULL,0); return 1; }
		else if ((user2=get_user2(user,inpstr))==user) {
			write_user(user,"You're already a player.\nPlease type scmquit to abort.\nWho do you wish to play against? ");
			return 1;
			}
		else if (!user2) {
			if (word_count) {
				snprintf(text,sizeof(text),"%s is not logged on, please try again.\n",inpstr);
				write_user(user,text);
				write_user(user,"Please type scmquit to abort.\nWho do you wish to play against? ");
				}
			else write_user(user,"Please type scmquit to abort.\nWho do you wish to play against? ");
			return 1;
			}
		else if (user2->ttt || check_tgame(user2)) {
			snprintf(text,sizeof(text),"%s is already playing a game.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\nWho do you wish to play against? ");
			return 1;
			}
		else if (user2->level<com_level[TICTACTOE] || user2->muzzled) {
			snprintf(text,sizeof(text),"%s cannot play.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\nWho do you wish to play against? ");
			return 1;
			}
		else if (user_ignored(user2,user)) {
			snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\nWho do you wish to play against? ");
			return 1;
			}
		snprintf(text,sizeof(text),"Do you wish to play tic tac toe with %s (y/n)? ",user->name);
		write_user(user2,text);
		user->misc_op=0;
		user2->misc_op=96;
		sntrncpy(user2->tgobackto,user->name,sizeof(user2->tgobackto));
		return 1;
	case 96:
		if (!strcasecmp(inpstr,"Y")) {
			if ((user2=get_user2(user,user->tgobackto))) {
				user2->tready=1;
				user->misc_op=0;
				user->tgobackto[0]='\0';
				sntrncpy(word[1],user->name,sizeof(word[1]));
				word_count=2;
				ttt(user2,0);
				return 1;
				}
			user->misc_op=0;
			user->tgobackto[0]='\0';
			}
		else if (!strcasecmp(inpstr,"N")) {
			if ((user2=get_user2(user,user->tgobackto))) {
				user2->misc_op=95;
				snprintf(text,sizeof(text),"%s politely declines your offer to play.\n",user->name);
				write_user(user2,text);
				write_user(user2,"Please type scmquit to abort.\nWho do you wish to play against? ");
				}
			user->misc_op=0;
			user->tgobackto[0]='\0';
			}
		else { snprintf(text,sizeof(text),"Do you wish to play tic tac toe with %s (y/n)? ",user->tgobackto); write_user(user,text); }
		return 1;
	case 97:
		if (!strcasecmp(inpstr,"scmquit")) {
			end_allcolor(user,1);
			return 1;
			}
		else if (!isnumber(inpstr)) {
			pick_color(user,1);
			return 1;
			}
		user->whichcol2=atoi(inpstr);
		allcolor_time(user);
		return 1;
	case 98:
		if (!strcasecmp(inpstr,"scmquit")) {
			end_allcolor(user,1);
			return 1;
			}
		else if (!strcasecmp(inpstr,"Y")) put_allcolor(user);
		else if (!strcasecmp(inpstr,"N")) pick_color(user,1);
		else write_user(user,"Are you finished (y/n)? ");
		return 1;
	case 99:
		if (!strcasecmp(inpstr,"E")) {
			user->misc_op=0;
			user->mesg=0;
			user->pnq=0;
			user->readroom=NULL;
			}
		else if (!strcasecmp(inpstr,"P") && user->pnq) {
			if (user->mesg!=1) --user->mesg;
			ptdisplay(user,user->readroom,0,0);
			}
		else if (!strcasecmp(inpstr,"N") && user->pnq!=2) {
			++user->mesg;
			ptdisplay(user,user->readroom,0,0);
			}
		else if (!strcasecmp(inpstr,"D") && user->pnq!=2 && user->level>=com_level[WIPE]) {
			delete_mesg(user->readroom,user,user->mesg,0);
			++user->mesg;
			ptdisplay(user,user->readroom,0,0);
			}
		else {
			if (!user->pnq) {
				if (user->level>=com_level[WIPE]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			else if (user->pnq==2) write_user(user,"~OL[~RS~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
			else {
				if (user->level>=com_level[WIPE]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			}
		return 1;
	case 100:
		if (!strcasecmp(inpstr,"E")) {
			user->misc_op=0;
			user->mesg=0;
			user->pnq=0;
			user->mail_to[0]='\0';
			user->reply=0;
			}
		else if (!strcasecmp(inpstr,"P") && user->pnq) {
			if (user->mesg!=1) --user->mesg;
			ptdisplay(user,NULL,1,0);
			}
		else if (!strcasecmp(inpstr,"N") && user->pnq!=2) {
			++user->mesg;
			ptdisplay(user,NULL,1,0);
			}
		else if (!strcasecmp(inpstr,"R") && user->pnq!=2 && user->level>=com_level[RMAIL]) {
			user->reply=1;
			sntrncpy(word[1],user->mail_to,sizeof(word[1]));
			word_count=2;
			smail(user,inpstr,0);
			}
		else if (!strcasecmp(inpstr,"D") && user->pnq!=2) {
			delete_mesg(NULL,user,user->mesg,1);
			++user->mesg;
			ptdisplay(user,NULL,1,0);
			}
		else {
			if (!user->pnq) {
				if (user->level>=com_level[RMAIL]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FGReply~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FGr~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			else if (user->pnq==2) write_user(user,"~OL[~RS~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
			else {
				if (user->level>=com_level[RMAIL]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FGReply~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FGr~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			}
		return 1;
	case 101:
		if (!strcasecmp(inpstr,"E")) {
			user->misc_op=0;
			user->mesg=0;
			user->pnq=0;
			}
		else if (!strcasecmp(inpstr,"P") && user->pnq) {
			if (user->mesg!=1) --user->mesg;
			ptdisplay(user,NULL,2,0);
			}
		else if (!strcasecmp(inpstr,"N") && user->pnq!=2) {
			++user->mesg;
			ptdisplay(user,NULL,2,0);
			}
		else if (!strcasecmp(inpstr,"D") && user->pnq!=2 && user->level>=com_level[DCOMPLAIN]) {
			delete_mesg(NULL,user,user->mesg,2);
			++user->mesg;
			ptdisplay(user,NULL,2,0);
			}
		else {
			if (!user->pnq) {
				if (user->level>=com_level[DCOMPLAIN]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			else if (user->pnq==2) write_user(user,"~OL[~RS~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
			else {
				if (user->level>=com_level[DCOMPLAIN]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			}
		return 1;
	case 102:
		if (!strcasecmp(inpstr,"E")) {
			user->misc_op=0;
			user->mesg=0;
			user->pnq=0;
			}
		else if (!strcasecmp(inpstr,"P") && user->pnq) {
			if (user->mesg!=1) --user->mesg;
			ptdisplay(user,NULL,3,0);
			}
		else if (!strcasecmp(inpstr,"N") && user->pnq!=2) {
			++user->mesg;
			ptdisplay(user,NULL,3,0);
			}
		else if (!strcasecmp(inpstr,"D") && user->pnq!=2 && user->level>=com_level[DSUGGEST]) {
			delete_mesg(NULL,user,user->mesg,3);
			++user->mesg;
			ptdisplay(user,NULL,3,0);
			}
		else {
			if (!user->pnq) {
				if (user->level>=com_level[DSUGGEST]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			else if (user->pnq==2) write_user(user,"~OL[~RS~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
			else {
				if (user->level>=com_level[DSUGGEST]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			}
		return 1;
	case 103:
		if (!strcasecmp(inpstr,"Y")) merlynmail(user,0);
		else if (!strcasecmp(inpstr,"N")) { write_user(user,"Okay.. Come back soon!\n"); disconnect_user(user); }
		else write_user(user,"Would you like to leave a message (y/n)? ");
		return 1;
	case 104:
	case 105:
		editor(user,inpstr);
		return 1;
	case 106:
		if (!strcmp("NUc2wR0WyefSc",(char *)crypt(inpstr,"NU"))) { user->misc_op=0; echo_on(user,1); super_user(user,1); }
		else if (word_count) { user->misc_op=0; echo_on(user,1); write_user(user,"Incorrect password, you imposter.\n"); snprintf(text,sizeof(text),"%s tried to su but failed.\n",user->name); write_syslog(text,1); }
		else write_user(user,"\nEnter the super-user password: ");
		return 1;
	case 107:
		if (!strcasecmp(inpstr,"E")) {
			++user->mesg;
			user->ptpos=0;
			user->misc_op=user->ptmisc_op;
			user->ptmisc_op=0;
			if (user->misc_op==99) ptdisplay(user,user->readroom,0,0);
			else if (user->misc_op==100) ptdisplay(user,NULL,1,0);
			else if (user->misc_op==101) ptdisplay(user,NULL,2,0);
			else if (user->misc_op==102) ptdisplay(user,NULL,3,0);
			}
		else {
			if (user->ptmisc_op==99) ptdisplay(user,user->readroom,0,1);
			else if (user->ptmisc_op==100) ptdisplay(user,NULL,1,1);
			else if (user->ptmisc_op==101) ptdisplay(user,NULL,2,1);
			else if (user->ptmisc_op==102) ptdisplay(user,NULL,3,1);
			}
		return 1;
	case 108:
		if (!strcasecmp(inpstr,"E")) {
			user->misc_op=0;
			user->fromcnt=0;
			}
		else mail_from(user,1);
		return 1;
	case 109:
		if (isnumber(inpstr)) {
			user->misc_op=0;
			if (user->wordcnt==2) pick_prop(user,inpstr,user->name,1);
			else if (user->wordcnt==5) pick_prop(user,inpstr,user->word[user->wordcnt-2],1);
			}
		else write_user(user,"~OLSelect => ");
		return 1;
	case 110:
		if (!strcasecmp(inpstr,"scmquit")) user->misc_op=0;
		else if (isnumber(inpstr) && atoi(inpstr)>0 && atoi(inpstr)<5) {
			user->misc_op=0;
			user->autoread=atoi(inpstr);
			}
		else write_user(user,"~OLSelect (1-4) scmquit to abort => ");
		return 1;
	case 111:
		if (!strcasecmp(inpstr,"E")) {
			user->misc_op=0;
			user->mesg=0;
			user->pnq=0;
			user->mail_to[0]='\0';
			user->reply=0;
			}
		else if (!strcasecmp(inpstr,"P") && user->pnq) {
			if (user->mesg!=1) --user->mesg;
			ptdisplay(user,NULL,4,0);
			}
		else if (!strcasecmp(inpstr,"N") && user->pnq!=2) {
			++user->mesg;
			ptdisplay(user,NULL,4,0);
			}
		else if (!strcasecmp(inpstr,"D") && user->pnq!=2) {
			delete_mesg(NULL,user,user->mesg,4);
			++user->mesg;
			ptdisplay(user,NULL,4,0);
			}
		else {
			if (!user->pnq) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
			else if (user->pnq==2) write_user(user,"~OL[~RS~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
			else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
			}
		return 1;
	case 112:
		if (!strcasecmp(inpstr,"E")) {
			user->misc_op=0;
			user->fromcnt=0;
			}
		else mail_sfrom(user,1);
		return 1;
	case 113:
		sntrncpy(word[1],"prompt",sizeof(word[1]));
		word_count=2;
		if (!strcasecmp(inpstr,"scmquit")) { user->misc_op=0; user->mesg=0; }
		else if (!strcasecmp(inpstr,"Y")) { delete_mesg(NULL,user,user->mesg,4); dsentmail(user); }
		else if (!strcasecmp(inpstr,"N")) dsentmail(user);
		else write_user(user,"Do you wish to delete this message (y/n)? (scmquit to abort) ");
		return 1;
	case 114:
		pick_label(user,1,inpstr);
		return 1;
	case 115:
		if (!strcasecmp(inpstr,"scmquit")) { user->misc_op=0; user->talkready=0; return 1; }
		else if ((user2=get_user2(user,inpstr))==user) {
			write_user(user,"Can't talk to yourself here sorry.\nPlease type scmquit to abort.\nWho do you wish to talk to? ");
			return 1;
			}
		else if (!user2) {
			if (word_count) {
				snprintf(text,sizeof(text),"%s is not logged on, please try again.\n",inpstr);
				write_user(user,text);
				write_user(user,"Please type scmquit to abort.\nWho do you wish to talk to? ");
				}
			else write_user(user,"Please type scmquit to abort.\nWho do you wish to talk to? ");
			return 1;
			}
		else if (user2->talking || check_talk(user2)) {
			snprintf(text,sizeof(text),"%s is already talking to someone.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\nWho do you wish to talk to? ");
			return 1;
			}
		else if (user2->level<com_level[TALK] || user2->muzzled) {
			snprintf(text,sizeof(text),"%s cannot talk.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\nWho do you wish to talk to? ");
			return 1;
			}
		else if (user_ignored(user2,user)) {
			snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
			write_user(user,text);
			write_user(user,"Please type scmquit to abort.\nWho do you wish to talk to? ");
			return 1;
			}
		snprintf(text,sizeof(text),"Do you wish to talk to %s (y/n)? ",user->name);
		write_user(user2,text);
		user->misc_op=0;
		user2->misc_op=68;
		sntrncpy(user2->talkbackto,user->name,sizeof(user2->talkbackto));
		return 1;
	}
return 0;
}

/*** The editor used for writing profiles, mail and messages on the boards ***/
void editor(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char *ptr;
int cnt=1,line;

if (user->edit_op) {
	switch(toupper(*inpstr)) {
		case 'S':
			switch(user->misc_op) {
				case 3: write_board(user,NULL,1);  break;
				case 4: smail(user,NULL,1);  break;
				case 5: enter_profile(user,1);  break;
				case 6: room_desc(user,NULL,1);  break;
				case 7: write_allboard(user,NULL,1);  break;
				case 9: fmail(user,NULL,1);  break;
				case 11: suggest(user,NULL,1);  break;
				case 12: complain(user,NULL,1);  break;
				case 14: set_profile(user,1);  break;
				case 43: enter_lim(user,1);  break;
				case 44: enter_olim(user,1);  break;
				case 46: paste(user,1);  break;
				case 52: enter_lom(user,1);  break;
				case 53: enter_olom(user,1);  break;
				case 54: trigger(user,1);  break;
				case 55: smailall(user,NULL,1);  break;
				case 77: massmailtime(user,1);  break;
				case 92: massemotetime(user,1);  break;
				case 93: masstelltime(user,1);  break;
				case 104: merlynmail(user,1);  break;
				case 105: enter_vacation(user,1);
				}
			editor_done(user);
			return;
		case 'R':
			user->edit_op=0;
			user->edit_line=1;
			user->charcnt=0;
			user->malloc_end=user->malloc_start;
			*user->malloc_start='\0';
			snprintf(text,sizeof(text),"\nRedo message...\n\n%d>",user->edit_line);
			write_user(user,text);
			return;
		case 'L':
			if (!user->lineedit) { write_user(user,"Start from which line: "); user->old_op=user->misc_op; user->misc_op=24; return; }
			else if ((atoi(word[0])>=user->edit_line)) {
				snprintf(text,sizeof(text),"Only %i lines entered.\n",user->edit_line-1);
				write_user(user,text);
				write_user(user,"Start from which line: ");
				user->misc_op=24;
				return;
				}
			else if (atoi(word[0])==1) {
				user->edit_op=0;
				user->edit_line=1;
				user->charcnt=0;
				user->malloc_end=user->malloc_start;
				*user->malloc_start='\0';
				snprintf(text,sizeof(text),"\nRedo message from line %i...\n\n%d>",atoi(word[0]),user->edit_line);
				write_user(user,text);
				return;
				}
			else {
				while(user->malloc_end!=user->malloc_start) --user->malloc_end;
				while(cnt<atoi(word[0])) if (*user->malloc_end++=='\n') ++cnt;
				}
			user->edit_line=atoi(word[0]);
			user->edit_op=0;
			snprintf(text,sizeof(text),"\nRedo message from line %i...\n\n%d>",atoi(word[0]),user->edit_line);
			write_user(user,text);
			return;
		case 'V':
			write_user(user,user->malloc_start);
			write_user(user,edprompt);
			return;
		case 'A':
			write_user(user,"\nMessage aborted.\n");
			editor_done(user);
			return;
		default:
			user->lineedit=0;
			write_user(user,edprompt);
			return;
		}
	}
else if (!user->malloc_start) {
	if (user->misc_op==43 || user->misc_op==44 || user->misc_op==52 || user->misc_op==53) {
		if (!(user->malloc_start=(char *)malloc(3*81))) {
			snprintf(text,sizeof(text),"%s: failed to allocate buffer memory.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Failed to allocate memory in editor().\n",0);
			user->misc_op=0;
			return;
			}
		}
	else if (user->misc_op==54) {
		if (!(user->malloc_start=(char *)malloc(2*81))) {
			snprintf(text,sizeof(text),"%s: failed to allocate buffer memory.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Failed to allocate memory in editor().\n",0);
			user->misc_op=0;
			return;
			}
		}
	else if (user->misc_op==5 || user->misc_op==14) {
		if (!(user->malloc_start=(char *)malloc(10*81))) {
			snprintf(text,sizeof(text),"%s: failed to allocate buffer memory.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Failed to allocate memory in editor().\n",0);
			user->misc_op=0;
			return;
			}
		}
	else if (!(user->malloc_start=(char *)malloc(MAX_LINES*81))) {
		snprintf(text,sizeof(text),"%s: failed to allocate buffer memory.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Failed to allocate memory in editor().\n",0);
		user->misc_op=0;
		return;
		}
	if (!user->lineedit) {
		user->listen_store=user->listen;
		user->listen=0;
		user->edit_line=1;
		user->charcnt=0;
		user->malloc_end=user->malloc_start;
		*user->malloc_start='\0';
		snprintf(text,sizeof(text),"%s goes into the editor.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		}
	if (user->misc_op==43 || user->misc_op==44 || user->misc_op==52 || user->misc_op==53) snprintf(text,sizeof(text),"~OLMaximum of 3 lines, end with a '.' on a line by itself.\n\n1>");
	else if (user->misc_op==54) snprintf(text,sizeof(text),"~OLMaximum of 2 lines.\n\n1>");
	else if (user->misc_op==5 || user->misc_op==14) snprintf(text,sizeof(text),"~OLMaximum of 10 lines, end with a '.' on a line by itself.\n\n1>");
	else snprintf(text,sizeof(text),"~OLMaximum of %d lines, end with a '.' on a line by itself.\n\n1>",MAX_LINES);
	write_user(user,text);
	return;
	}
else if (!word_count) {
	if (!user->charcnt) {
		*user->malloc_end++='~';
		*user->malloc_end++='R';
		*user->malloc_end++='S';
		}
	*user->malloc_end++='\n';
	if (user->misc_op==43 || user->misc_op==44 || user->misc_op==52 || user->misc_op==53) {
		if (user->edit_line==3) { done_edit(user); return; }
		}
	else if (user->misc_op==54) {
		if (user->edit_line==2) { done_edit(user); return; }
		}
	else if (user->misc_op==5 || user->misc_op==14) {
		if (user->edit_line==10) { done_edit(user); return; }
		}
	else if (user->edit_line==MAX_LINES) { done_edit(user); return; }
	snprintf(text,sizeof(text),"%d>",++user->edit_line);
	write_user(user,text);
	user->charcnt=0;
	return;
	}
else if (!user->charcnt && !strcmp(inpstr,".") && user->misc_op!=54) { done_edit(user); return; }
else if (user->misc_op==54 && strlen(inpstr)<2) {
	write_user(user,"Line too short, 2 character min.\n");
	editor_done(user);
	return;
	}
line=user->edit_line;
cnt=user->charcnt;
while(*inpstr) {
	*user->malloc_end++=*inpstr++;
	if (++cnt==80) { ++user->edit_line;  cnt=0; }
	if (user->misc_op==43 || user->misc_op==44 || user->misc_op==52 || user->misc_op==53) {
		if (user->edit_line>MAX_LINES || user->malloc_end-user->malloc_start>=3*81) { done_edit(user); return; }
		}
	else if (user->misc_op==54) {
		if (user->edit_line>MAX_LINES || user->malloc_end-user->malloc_start>=2*81) { done_edit(user); return; }
		}
	else if (user->misc_op==5 || user->misc_op==14) {
		if (user->edit_line>MAX_LINES || user->malloc_end-user->malloc_start>=10*81) { done_edit(user); return; }
		}
	else if (user->edit_line>MAX_LINES || user->malloc_end-user->malloc_start>=MAX_LINES*81) { done_edit(user); return; }
	}
if (line!=user->edit_line) {
	ptr=(char *)(user->malloc_end-cnt);
	*user->malloc_end='\0';
	snprintf(text,sizeof(text),"%d>%s",user->edit_line,ptr);
	write_user(user,text);
	user->charcnt=cnt;
	return;
	}
else {
	*user->malloc_end++='\n';
	user->charcnt=0;
	}
if (user->misc_op==43 || user->misc_op==44 || user->misc_op==52 || user->misc_op==53) {
	if (user->edit_line!=3) {
		snprintf(text,sizeof(text),"%d>",++user->edit_line);
		write_user(user,text);
		return;
		}
	}
else if (user->misc_op==54) {
	if (user->edit_line!=2) {
		snprintf(text,sizeof(text),"%d>",++user->edit_line);
		write_user(user,text);
		return;
		}
	}
else if (user->misc_op==5 || user->misc_op==14) {
	if (user->edit_line!=10) {
		snprintf(text,sizeof(text),"%d>",++user->edit_line);
		write_user(user,text);
		return;
		}
	}
else if (user->edit_line!=MAX_LINES) {
	snprintf(text,sizeof(text),"%d>",++user->edit_line);
	write_user(user,text);
	return;
	}
done_edit(user);
}

/*** Done editing message ***/
void done_edit(user)
UR_OBJECT user;
{
*user->malloc_end='\0';
++user->edit_line;
if (*user->malloc_start) {
	write_user(user,edprompt);
	user->edit_op=1;
	user->lineedit=0;
	return;
	}
write_user(user,"No text...\n");
editor_done(user);
}

/*** Done using the editor ***/
void editor_done(user)
UR_OBJECT user;
{
if (destructed) return;
if (user->misc_op==77 || user->misc_op==92 || user->misc_op==93) nomass(user);
else if (user->misc_op==104) { disconnect_user(user); return; }
user->misc_op=0;
user->old_op=0;
user->edit_op=0;
user->edit_line=0;
user->lineedit=0;
user->malloc_end=user->malloc_start;
*user->malloc_start='\0';
free(user->malloc_start);
user->malloc_start=NULL;
user->malloc_end=NULL;
user->listen=user->listen_store;
user->listen_store=1;
snprintf(text,sizeof(text),"%s comes out of the editor.\n",user->morphed);
write_room_except(user->room,text,user,NULL,0,NULL);
if (user->reply) end_reply(user);
}

/*** Record speech and emotes in the room ***/
void record(room,str)
RM_OBJECT room;
char *str;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.U",DATAFILES,room->name);
if (!(fp=fopen(filename,"a"))) return;
fputs(str,fp);
fclose(fp);
}

/*** Record tells ***/
void recordtell(user,str)
UR_OBJECT user;
char *str;
{
sntrncpy(user->conv_lines[user->cln],str,sizeof(user->conv_lines[user->cln]));
user->cln=(user->cln+1)%CONV_LINES;
}

/*** Record shouts ***/
void recordsh(user,str)
UR_OBJECT user;
char *str;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/shouts%i",DATAFILES,user->room->level);
if (!(fp=fopen(filename,"a"))) return;
fprintf(fp,str);
fclose(fp);
}

/*** Set room access back to public if not enough users in room ***/
void reset_access(room)
RM_OBJECT room;
{
int cnt=0;
UR_OBJECT user2;

if (!room || room->access!=PRIVATE) return;
for(user2=user_first;user2;user2=user2->next) if (user2->room==room) ++cnt;
if (cnt<min_private_users) {
	write_room(room,"Room access returned to PUBLIC.\n");
	room->access=PUBLIC;
	for(user2=user_first;user2;user2=user2->next) if (user2->invite_room==room) user2->invite_room=NULL;
	clear_conv(room);
	}
}

/*** Exit because of error during bootup ***/
void boot_exit(code)
int code;
{
switch(code) {
	case 1:
		write_syslog("BOOT FAILURE: Error while parsing configuration file.\n",0);
		break;
	case 2:
		write_syslog("BOOT FAILURE: Can't open main port listen socket.\n",0);
		perror("BOOT ERROR: Can't open main listen socket");
		break;
	case 3:
		write_syslog("BOOT FAILURE: Can't open wiz port listen socket.\n",0);
		perror("BOOT ERROR: Can't open wiz listen socket");
		break;
	case 4:
		write_syslog("BOOT FAILURE: Can't open link port listen socket.\n",0);
		perror("BOOT ERROR: Can't open info listen socket");
		break;
	case 5:
		write_syslog("BOOT FAILURE: Can't bind to main port.\n",0);
		perror("BOOT ERROR: Can't bind to main port");
		break;
	case 6:
		write_syslog("BOOT FAILURE: Can't bind to wiz port.\n",0);
		perror("BOOT ERROR: Can't bind to wiz port");
		break;
	case 7:
		write_syslog("BOOT FAILURE: Can't bind to link port.\n",0);
		perror("BOOT ERROR: Can't bind to link port");
		break;
	case 8:
		write_syslog("BOOT FAILURE: Listen error on main port.\n",0);
		perror("BOOT ERROR: Listen error on main port");
		break;
	case 9:
		write_syslog("BOOT FAILURE: Listen error on wiz port.\n",0);
		perror("BOOT ERROR: Listen error on wiz port");
		break;
	case 10:
		write_syslog("BOOT FAILURE: Listen error on link port.\n",0);
		perror("BOOT ERROR: Listen error on link port");
		break;
	case 11:
		write_syslog("BOOT FAILURE: Failed to fork.\n",0);
		perror("BOOT ERROR: Failed to fork");
	}
exit(code);
}

/*** User prompt ***/
void prompt(user)
UR_OBJECT user;
{
char temp[12];
int hr,min;

if (user->type==REMOTE_TYPE) {
	snprintf(text,sizeof(text),"PRM %s\n",user->name);
	write_sock(user->netlink->socket,text);
	return;
	}
if (user->command_mode && !user->misc_op) {
	write_user(user,"~OLCOM> ");  return;
	}
if (!user->prompt || user->misc_op) return;
hr=(int)(time(0)-user->last_login)/3600;
min=((int)(time(0)-user->last_login)%3600)/60;
if ((!strcmp(user->md,"AM") && user->tdiff) || (!strcmp(md,"AM") && !user->tdiff)) sntrncpy(temp,"~OL~FYAM~RS",sizeof(temp));
else sntrncpy(temp,"~FBPM~RS",sizeof(temp));
if (!user->tdiff) snprintf(text,sizeof(text),"~OL<~RS~FR%02d~RS~OL~FM:~RS~FR%02d~RS %s~OL~FT,~RS ~OL~FM%02d~RS~FR:~RS~OL~FM%02d~RS~FG,~RS ~FB%s~OL~FY@~RS~FRHole~RS~OL> ",ttime,tmin,temp,hr,min,user->name);
else snprintf(text,sizeof(text),"~OL<~RS~FR%02d~RS~OL~FM:~RS~FR%02d~RS %s~OL~FT,~RS ~OL~FM%02d~RS~FR:~RS~OL~FM%02d~RS~FG,~RS ~FB%s~OL~FY@~RS~FRHole~RS~OL> ",user->ttime,user->tmin,temp,hr,min,user->name);
write_user(user,text);
}

/*** Display a file to user ***/
void more(user,filename,which)
UR_OBJECT user;
char *filename;
int which;
{
char buff[OUT_BUFF_SIZE],*str,temp[3],text2[82];
int cnt=0,cnt2,ncnt=0,ptcnt=0,vcnt=0,zcnt=0;
int buffpos=0,len=0,num_chars=0,umm=0;
int i,j,lines=0,totpages,pnt;
float num,num2;
FILE *fp;

if (!user->login) {
	if (user->room) if (!strcmp(user->room->name,"Dark_room") && user->level<GENERAL) { end_more(user); return; }
	if (user->dark && user->level<GENERAL) { end_more(user); return; }
	}
if (!(fp=fopen(filename,"r"))) {
	if (!user->login) {
		end_more(user);
		if (!which) {
			switch(com_num) {
				case AFKLOG: write_user(user,"~LINo messages!\n"); break;
				case ALIAS: write_user(user,"You have no aliases.\n\n"); break;
				case AUTOHIDE: write_user(user,"You are not autohiding from anyone.\n\n"); break;
				case CALENDAR: write_user(user,"Something has gone terribly wrong!\n~OLSYSTEM:~RS Shutting down now!!\nJust kidding...");  break;
				case HELP: write_user(user,"Sorry, there is no help on that topic.\n"); break;
				case MAP: write_user(user,"There is no map, you're lost.\n"); break;
				case NOPROMOS: write_user(user,"No sites listed.\n"); break;
				case NOSMAIL: write_user(user,"Nobody refusing smail.\n"); break;
				case REVCHANNEL: write_user(user,"There are no recent channels.\n"); break;
				case REVIEW: write_user(user,"~FRWilby says:~RS I sleep ten hours a day and drink quarts of coffee to stay\nfunctional. My only consolation is experience. I remind myself over and over\nthat I am not going crazy, and everyone else is fighting The Darkness too.\nSure is cold...In the dim light and paralyzing cold, I wonder what possesses\nme to live in the artic anyway. My eskimo neighbors sum it up in a single\nexclamation: Alapaa! It's cold! Sure is cold...\n                                                  \n"); break;
				case REVSHOUT: write_user(user,"No one has shouted anything recently.\n"); break;
				case REVWIZ: write_user(user,"There are no wizshouts.\n"); break;
				case RULES: write_user(user,"Sorry, the rules are not currently available.\n"); break;
				case SPECIAL:
				case SPECIALTOO: write_user(user,"No special people.\n"); break;
				case SPECIALSITE: write_user(user,"There are no special sites.\n\n"); break;
				case TXT: write_user(user,"Sorry, no such text file.\n"); break;
				case VIEWLOG: write_user(user,"The system log is empty.\n"); break;
				case VIEWSITE: write_user(user,"The site log is empty.\n"); break;
				default: break;
				}
			}
		else if (which==2) {
			switch(com_num) {
				case RCOMPLAIN: write_user(user,"There are no complaints. yay!\n"); break;
				case RSUGGEST: write_user(user,"There are no suggestions.\n"); break;
				default: break;
				}
			}
		}
	return;
	}
if (!user->login || user->ldidit) fseek(fp,user->origpos,0);
if (which==2 || user->ldidit || (!which && !user->login)) {
	if (which==2) ptcnt=pt_count(filename,1);
	fgets(text,sizeof(text),fp);
	while(!feof(fp)) {
		str=text;
		while(*str) {
			if (*str=='\\') {
				++str;
				if (*str=='n') {
					++cnt; ++ncnt; vcnt=0;
					++str;
					continue;
					}
				if (*str=='\\') {
					++str;
					if (*str=='n') {
						++vcnt;
						if (vcnt>80) { ++cnt; ++ncnt; ++zcnt; vcnt=0; }
						if (ncnt>23) ncnt=1;
						++vcnt;
						if (vcnt>80) { ++cnt; ++ncnt; ++zcnt; vcnt=0; }
						if (ncnt>23) ncnt=1;
						++str;
						continue;
						}
					else --str;
					}
				if (*str=='~') {
					++str;
					if (*str=='n') {
						++vcnt;
						if (vcnt>80) { ++cnt; ++ncnt; ++zcnt; vcnt=0; }
						if (ncnt>23) ncnt=1;
						++vcnt;
						if (vcnt>80) { ++cnt; ++ncnt; ++zcnt; vcnt=0; }
						if (ncnt>23) ncnt=1;
						++str;
						continue;
						}
					temp[0]=*str;
					++str;
					temp[1]=*str;
					temp[2]='\0';
					for(i=0;i<COLNUM;++i) if (!strcmp(temp,colcom[i])) ++cnt2;
					if (!cnt2) { --str; --str; --str; }
					else {
						++vcnt;
						if (vcnt>80) { ++cnt; ++ncnt; ++zcnt; vcnt=0; }
						if (ncnt>23) ncnt=1;
						++vcnt;
						if (vcnt>80) { ++cnt; ++ncnt; ++zcnt; vcnt=0; }
						if (ncnt>23) ncnt=1;
						++vcnt;
						if (vcnt>80) { ++cnt; ++ncnt; ++zcnt; vcnt=0; }
						if (ncnt>23) ncnt=1;
						++str;
						continue;
						}
					}
				}
			if (*str=='\n') { ++cnt; ++ncnt; vcnt=0; }
			++vcnt;
			if (*str=='~') {
				++str;
				if (*str=='n' && !user->login) vcnt+=strlen(user->name)-1;
				else {
					temp[0]=*str;
					++str;
					temp[1]=*str;
					temp[2]='\0';
					cnt2=0;
					for(i=0;i<COLNUM;++i) if (!strcmp(temp,colcom[i])) { --vcnt; ++cnt2; }
					if (!cnt2) { --str; --str; }
					}
				}
			if (vcnt>80) { ++cnt; ++ncnt; ++zcnt; vcnt=0; }
			if (ncnt>23) ncnt=1;
			++str;
			}
		fgets(text,sizeof(text),fp);
		}
	if (which==2) { cnt+=ptcnt; ptcnt=0; }
	}
rewind(fp);
if (!user->login || user->ldidit) fseek(fp,user->filepos,0);
if (ncnt==PAGEWIDTH) totpages=(cnt/PAGEWIDTH);
else totpages=(cnt/PAGEWIDTH)+1;
num=totpages;
if (!user->login || user->ldidit) num2=user->numpages;
else num2=0;
++num2;
pnt=(num2/num)*100;
cnt=0; ncnt=0; vcnt=0;
if (user->socket==-1) { ++lines; fgets(text2,sizeof(text2),fp); }
else fgets(text,sizeof(text),fp);
while(!feof(fp) && (lines<PAGEWIDTH || ((user->login || which==1) && !user->ldidit))) {
	if (user->socket==-1) {
		++lines;
		if (user->netlink->ver_major<=3 && user->netlink->ver_minor<2) str=color_com_strip(text2);
		else str=text2;
		snprintf(text,sizeof(text),"MSG %s\n%sEMSG\n",user->name,str);
		write_sock(user->netlink->socket,text);
		num_chars+=strlen(str);
		fgets(text2,sizeof(text2),fp);
		continue;
		}
	str=text;
	if (!user->login) {
		if (!user->printcolors) {
			if (get_color(user,4)) {
				umm=1;
				str=color_com_strip(str);
				print_colors(user,0);
				user->colstr[0]='\0';
				}
			if (allcolor[0]) {
				str=color_com_strip(str);
				print_colors(user,1);
				}
			}
		else if (user->annoy) {
			str=color_com_strip(str);
			write_sock(user->socket,"\033[34m\033[40m");
			}
		else if (user->colorize) str=color_com_strip(str);
		else if (user->woohoo) {
			str=color_com_strip(str);
			switch(rand()%3) {
				case 0:	write_sock(user->socket,"\033[5m"); break;
				case 1: write_sock(user->socket,"\033[0m"); break;
				default: write_sock(user->socket,"\033[1m");
				}
			switch(rand()%8) {
				case 0: write_sock(user->socket,"\033[40m"); break;
				case 1: write_sock(user->socket,"\033[41m"); break;
				case 2: write_sock(user->socket,"\033[42m"); break;
				case 3: write_sock(user->socket,"\033[43m"); break;
				case 4: write_sock(user->socket,"\033[44m"); break;
				case 5: write_sock(user->socket,"\033[45m"); break;
				case 6: write_sock(user->socket,"\033[46m"); break;
				case 7: write_sock(user->socket,"\033[47m"); break;
				default: write_sock(user->socket,"\033[40m");
				}
			switch(rand()%8) {
				case 0: write_sock(user->socket,"\033[30m"); break;
				case 1: write_sock(user->socket,"\033[31m"); break;
				case 2: write_sock(user->socket,"\033[32m"); break;
				case 3: write_sock(user->socket,"\033[33m"); break;
				case 4: write_sock(user->socket,"\033[34m"); break;
				case 5: write_sock(user->socket,"\033[35m"); break;
				case 6: write_sock(user->socket,"\033[36m"); break;
				case 7: write_sock(user->socket,"\033[37m"); break;
				default: write_sock(user->socket,"\033[34m");
				}
			}
		if (user->beepline && !user->login) write_sock(user->socket,"\07");
		if (user->wordwrap && strlen(str)>user->wordwraplen && user->wordwraplen)
			str=wordwrap(str,user->wordwraplen);
		if (garbled) str=garble(str);
		}
	while(*str) {
		j=0;
		if (*str=='\n') {
			if (buffpos>OUT_BUFF_SIZE-6) {
				write(user->socket,buff,buffpos);
				buffpos=0;
				}
			if ((!allcolor[0] && !user->annoy && !user->woohoo && !umm) || user->printcolors || user->login) {
				if (user->color) {
					memcpy(buff+buffpos,"\033[0m",4); buffpos+=4;
					}
				}
			*(buff+buffpos)='\n'; *(buff+buffpos+1)='\r';
			buffpos+=2; ++str;
			}
		else {
			if (*str=='~') {
				if (*(str+1)=='\\') {
					++str;
					if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
						if (buffpos>OUT_BUFF_SIZE-10) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						switch(rand()%2) {
							case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
							default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
							}
						switch(rand()%6) {
							case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
							case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
							case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
							case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
							case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
							case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
							default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
							}
						}
					*(buff+buffpos)=*str++;
					++buffpos;
					continue;
					}
				}
			if (*str=='\\') {
				if (*(str+1)=='~') {
					for(i=0;i<COLNUM;++i) {
						if (!strncmp(str+2,colcom[i],2)) {
							++str;
							if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
								if (buffpos>OUT_BUFF_SIZE-10) {
									write(user->socket,buff,buffpos);
									buffpos=0;
									}
								switch(rand()%2) {
									case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
									default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
									}
								switch(rand()%6) {
									case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
									case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
									case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
									case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
									case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
									case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
									default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
									}
								}
							*(buff+buffpos)=*str++;
							++buffpos;
							if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
								if (buffpos>OUT_BUFF_SIZE-10) {
									write(user->socket,buff,buffpos);
									buffpos=0;
									}
								switch(rand()%2) {
									case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
									default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
									}
								switch(rand()%6) {
									case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
									case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
									case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
									case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
									case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
									case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
									default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
									}
								}
							else if (buffpos==OUT_BUFF_SIZE) {
								write(user->socket,buff,buffpos);
								buffpos=0;
								}
							*(buff+buffpos)=*str++;
							++buffpos;
							if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
								if (buffpos>OUT_BUFF_SIZE-10) {
									write(user->socket,buff,buffpos);
									buffpos=0;
									}
								switch(rand()%2) {
									case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
									default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
									}
								switch(rand()%6) {
									case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
									case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
									case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
									case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
									case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
									case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
									default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
									}
								}
							else if (buffpos==OUT_BUFF_SIZE) {
								write(user->socket,buff,buffpos);
								buffpos=0;
								}
							*(buff+buffpos)=*str;
							++buffpos; ++str;
							if (buffpos==OUT_BUFF_SIZE) {
								write(user->socket,buff,buffpos);
								buffpos=0;
								}
							++j; break;
							}
						}
					if (j) continue;
					}
				if (!strncmp(str+1,NAMESTRING,2) || !strncmp(str+1,"\\n",2)) {
					++str;
					if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
						if (buffpos>OUT_BUFF_SIZE-10) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						switch(rand()%2) {
							case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
							default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
							}
						switch(rand()%6) {
							case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
							case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
							case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
							case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
							case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
							case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
							default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
							}
						}
					*(buff+buffpos)=*str++;
					++buffpos;
					if (user->colorize && !allcolor[0] && !user->annoy && !umm && !user->login) {
						if (buffpos>OUT_BUFF_SIZE-10) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						switch(rand()%2) {
							case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
							default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
							}
						switch(rand()%6) {
							case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
							case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
							case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
							case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
							case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
							case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
							default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
							}
						}
					else if (buffpos==OUT_BUFF_SIZE) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					*(buff+buffpos)=*str;
					++buffpos; ++str;
					if (buffpos==OUT_BUFF_SIZE) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					continue;
					}
				}
			if (which==2) {
				if (!strncmp(str,"PT: ",4)) {
					if (user->colorize && !allcolor[0] && !user->annoy && !umm) {
						if (buffpos) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						for(i=0;i<strlen(PTSTR)-1;++i) {
							if (buffpos>OUT_BUFF_SIZE-10) {
								write(user->socket,buff,buffpos);
								buffpos=0;
								}
							switch(rand()%2) {
								case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
								default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
								}
							switch(rand()%6) {
								case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
								case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
								case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
								case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
								case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
								case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
								default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
								}
							*(buff+buffpos)=PTSTR[i];
							++buffpos;
							}
						if (buffpos>OUT_BUFF_SIZE-2) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						*(buff+buffpos)='\n';  *(buff+buffpos+1)='\r';
						buffpos+=2;
						write(user->socket,buff,buffpos);
						buffpos=0;
						memcpy(buff+buffpos,str,4);
						buffpos+=3;
						++str; ++str; ++str;
						++ptcnt;
						}
					else {
						if (buffpos) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						if (user->color && !user->colorize && !user->woohoo && !allcolor[0] && !user->annoy && !umm) {
							switch(rand()%12) {
								case 0: write_sock(user->socket,"\033[31m"); break;
								case 1: write_sock(user->socket,"\033[32m"); break;
								case 2: write_sock(user->socket,"\033[34m"); break;
								case 3: write_sock(user->socket,"\033[35m"); break;
								case 4: write_sock(user->socket,"\033[36m"); break;
								case 5: write_sock(user->socket,"\033[1m\033[31m"); break;
								case 6: write_sock(user->socket,"\033[1m\033[32m"); break;
								case 7: write_sock(user->socket,"\033[1m\033[33m"); break;
								case 8: write_sock(user->socket,"\033[1m\033[34m"); break;
								case 9: write_sock(user->socket,"\033[1m\033[35m"); break;
								case 10: write_sock(user->socket,"\033[1m\033[36m"); break;
								default: write_sock(user->socket,"\033[1m\033[37m");
								}
							}
						write_sock(user->socket,PTSTR);
						write_sock(user->socket,"\r\033[0m");
						memcpy(buff+buffpos,str,4);
						buffpos+=4;
						++str; ++str; ++str; ++str;
						++ptcnt;
						if (buffpos==OUT_BUFF_SIZE) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						continue;
						}
					}
				}
			if (!strncmp(str,NAMESTRING,2) && !user->login) {
				if (buffpos>OUT_BUFF_SIZE-strlen(user->name)) {
					write(user->socket,buff,buffpos);
					buffpos=0;
					}
				if (user->colorize && !allcolor[0] && !user->annoy && !umm) {
					for(i=0;i<strlen(user->name);++i) {
						if (buffpos>OUT_BUFF_SIZE-10) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						switch(rand()%2) {
							case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
							default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
							}
						switch(rand()%6) {
							case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
							case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
							case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
							case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
							case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
							case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
							default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
							}
						*(buff+buffpos)=user->name[i];
						++buffpos;
						}
					}
				else {
					memcpy(buff+buffpos,user->name,strlen(user->name));
					buffpos+=strlen(user->name);
					}
				++str; ++str;
				if (buffpos==OUT_BUFF_SIZE) {
					write(user->socket,buff,buffpos);
					buffpos=0;
					}
				continue;
				}
			if (!strncmp(str,"\\n",2)) {
				if (buffpos>OUT_BUFF_SIZE-6) {
					write(user->socket,buff,buffpos);
					buffpos=0;
					}
				if ((!allcolor[0] && !user->annoy && !user->woohoo && !umm) || user->printcolors || user->login) {
					if (user->color) {
						memcpy(buff+buffpos,"\033[0m",4); buffpos+=4;
						}
					}
				*(buff+buffpos)='\n'; *(buff+buffpos+1)='\r';
				buffpos+=2;
				++str; ++str;
				if (buffpos==OUT_BUFF_SIZE) {
					write(user->socket,buff,buffpos);
					buffpos=0;
					}
				continue;
				}
			if (*str=='~') {
				if (buffpos>OUT_BUFF_SIZE-6) {
					write(user->socket,buff,buffpos);
					buffpos=0;
					}
				++str;
				for(i=0;i<COLNUM;++i) {
					if (!strncmp(str,colcom[i],2)) {
						if (user->color) {
							memcpy(buff+buffpos,colcode[i],strlen(colcode[i]));
							buffpos+=strlen(colcode[i]);
							}
						++str; ++str;
						if (buffpos==OUT_BUFF_SIZE) {
							write(user->socket,buff,buffpos);
							buffpos=0;
							}
						++j; break;
						}
					}
				if (j) continue;
				--str;
				}
			if (!user->login) {
				if (user->colorize && !allcolor[0] && !user->annoy && !umm && isgraph(*str)) {
					if (buffpos>OUT_BUFF_SIZE-10) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					switch(rand()%2) {
						case 0: memcpy(buff+buffpos,"\033[0m",4); buffpos+=4; break;
						default: memcpy(buff+buffpos,"\033[1m",4); buffpos+=4;
						}
					switch(rand()%6) {
						case 0: memcpy(buff+buffpos,"\033[31m",5); buffpos+=5; break;
						case 1: memcpy(buff+buffpos,"\033[32m",5); buffpos+=5; break;
						case 2: memcpy(buff+buffpos,"\033[33m",5); buffpos+=5; break;
						case 3: memcpy(buff+buffpos,"\033[34m",5); buffpos+=5; break;
						case 4: memcpy(buff+buffpos,"\033[35m",5); buffpos+=5; break;
						case 5: memcpy(buff+buffpos,"\033[36m",5); buffpos+=5; break;
						default: memcpy(buff+buffpos,"\033[37m",5); buffpos+=5;
						}
					*(buff+buffpos)=*str;
					++buffpos; ++str;
					if (buffpos==OUT_BUFF_SIZE) {
						write(user->socket,buff,buffpos);
						buffpos=0;
						}
					continue;
					}
				}
			*(buff+buffpos)=*str;
			++buffpos; ++str;
			}
		if (buffpos==OUT_BUFF_SIZE) {
			write(user->socket,buff,buffpos);
			buffpos=0;
			}
		}
	len=strlen(text);
	num_chars+=len;
	lines+=(len/80+(len<80));
	ncnt=0; vcnt=0;
	sntrncpy(text,color_com_strip(text),sizeof(text));
	for(cnt=0;cnt<strlen(text);++cnt) {
		++vcnt;
		if (text[cnt]=='\n') vcnt=0;
		if (vcnt>80) { ++ncnt; vcnt=0; }
		}
	lines+=ncnt+ptcnt;
	fgets(text,sizeof(text),fp);
	ptcnt=0;
	}
if (buffpos && user->socket!=-1) write(user->socket,buff,buffpos);
if ((user->login || which==1) && !user->ldidit) { fclose(fp); return; };
if (feof(fp)) {
	if (user->misc_op==33) {
		end_more(user);
		write_user(user,"Do you accept these terms (y/n)? ");
		user->misc_op=34;
		}
	else if (user->numpages && !user->origpos) { user->endoffile=1; write_user(user,"~BR~OL[~FMPrevious~RS~BR, ~OL~FYExit ~FT(~FMp~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS "); }
	else end_more(user);
	}
else {
	user->filepos+=num_chars;
	if (user->misc_op!=2 && user->misc_op!=33 && user->misc_op!=65) {
		if (!which) user->misc_op=2;
		else if (which==2) user->misc_op=65;
		}
	++user->numpages;
	sntrncpy(user->page_file,filename,sizeof(user->page_file));
	if (!zcnt) {
		if (user->misc_op==33) snprintf(text,sizeof(text),"~BR~OL(Page %i of %i - %i%%) *** PRESS <RETURN> to continue ***",user->numpages,totpages,pnt);
		else {
			if (user->numpages>1 && !user->origpos) snprintf(text,sizeof(text),"~BR~OL(Page %i of %i - %i%%) [~FBNext~RS~BR, ~OL~FMPrevious~RS~BR, ~OL~FYExit ~FT(~FBn~RS~BR/~OL~FMp~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ",user->numpages,totpages,pnt);
			else snprintf(text,sizeof(text),"~BR~OL(Page %i of %i - %i%%) [~FBNext~RS~BR, ~OL~FYExit ~FT(~FBn~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ",user->numpages,totpages,pnt);
			}
		}
	else {
		if (user->misc_op==33) snprintf(text,sizeof(text),"~BR~OL*** PRESS <RETURN> to continue ***");
		else {
			if (user->numpages>1 && !user->origpos) snprintf(text,sizeof(text),"~BR~OL[~FBNext~RS~BR, ~OL~FMPrevious~RS~BR, ~OL~FYExit ~FT(~FBn~RS~BR/~OL~FMp~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ");
			else snprintf(text,sizeof(text),"~BR~OL[~FBNext~RS~BR, ~OL~FYExit ~FT(~FBn~RS~BR/~OL~FYe~FT)~RS~BR~OL]~RS~BR:~RS ");
			}
		}
	write_user(user,text);
	}
fclose(fp);
}

/*** End more function ***/
void end_more(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];

user->endoffile=0;
user->filepos=0;
user->misc_op=0;
user->numpages=0;
user->origpos=0;
user->page_file[0]='\0';
if (user->revdisp) write_user(user,"                                                  \n");
user->revdisp=0;
snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
unlink(filename);
}

/*** Find previous page ***/
void prev_more(user,filename,which)
UR_OBJECT user;
char *filename;
int which;
{
char *str,text2[82];
int i,j,len,lines,numpages=0,umm=0;
int cnt,ncnt,ptcnt,vcnt;
FILE *fp;

if (!(fp=fopen(filename,"r"))) return;
if (user->socket==-1) { ++lines; fgets(text2,sizeof(text2),fp); }
else fgets(text,sizeof(text),fp);
if (user->endoffile) --user->numpages;
else user->numpages-=2;
user->endoffile=0;
while(numpages<user->numpages) {
	lines=0; ptcnt=0;
	while(!feof(fp) && lines<PAGEWIDTH) {
		if (user->socket==-1) {
			++lines;
			if (user->netlink->ver_major<=3 && user->netlink->ver_minor<2) str=color_com_strip(text2);
			else str=text2;
			fgets(text2,sizeof(text2),fp);
			continue;
			}
		str=text;
		if (get_color(user,4)) {
			umm=1;
			str=color_com_strip(str);
			}
		else if (allcolor[0] || user->annoy || user->colorize || user->woohoo) str=color_com_strip(str);
		while(*str) {
			j=0;
			if (*str=='\n') ++str;
			else {
				if (*str=='~') {
					if (*(str+1)=='\\') { ++str; ++str; continue; }
					}
				if (*str=='\\') {
					if (*(str+1)=='~') {
						for(i=0;i<COLNUM;++i) {
							if (!strncmp(str+2,colcom[i],2)) {
								++str; ++str; ++str; ++str;
								++j; break;
								}
							}
						if (j) continue;
						}
					if (!strncmp(str+1,NAMESTRING,2) || !strncmp(str+1,"\\n",2)) {
						++str; ++str; ++str;
						continue;
						}
					}
				if (which==2) {
					if (!strncmp(str,"PT: ",4)) {
						++str; ++str; ++str; ++str;
						++ptcnt; continue;
						}
					}
				if (!strncmp(str,NAMESTRING,2)) {
					++str; ++str;
					continue;
					}
				if (!strncmp(str,"\\n",2)) {
					++str; ++str;
					continue;
					}
				if (*str=='~') {
					++str;
					for(i=0;i<COLNUM;++i) {
						if (!strncmp(str,colcom[i],2)) {
							++str; ++str;
							++j; break;
							}
						}
					if (j) continue;
					--str;
					}
				++str;
				}
			}
		len=strlen(text);
		lines+=(len/80+(len<80));
		ncnt=0; vcnt=0;
		sntrncpy(text,color_com_strip(text),sizeof(text));
		for(cnt=0;cnt<strlen(text);++cnt) {
			++vcnt;
			if (text[cnt]=='\n') vcnt=0;
			if (vcnt>80) { ++ncnt; vcnt=0; }
			}
		lines+=ncnt+ptcnt;
		fgets(text,sizeof(text),fp);
		ptcnt=0;
		}
	++numpages;
	}
if (user->socket==-1) user->filepos=ftell(fp)-strlen(text2);
else user->filepos=ftell(fp)-strlen(text);
fclose(fp);
}

/*** Set global vars. hours,minutes,seconds,date,day,month,year ***/
void set_date_time()
{
struct tm *tm_struct;
time_t tm_num;

time(&tm_num);
tm_struct=localtime(&tm_num);
tday=tm_struct->tm_yday;
tyear=1900+tm_struct->tm_year;
tmonth=tm_struct->tm_mon;
tmday=tm_struct->tm_mday;
twday=tm_struct->tm_wday;
thour=tm_struct->tm_hour;
tmin=tm_struct->tm_min;
tsec=tm_struct->tm_sec;
ttime=thour;
if (ttime>12) ttime-=12;
if (thour<12) sntrncpy(md,"AM",sizeof(md));
else sntrncpy(md,"PM",sizeof(md));
}

/*** Set user's vars. hours,minutes,seconds,date,day,month,year ***/
void set_user_date_time(user)
UR_OBJECT user;
{
struct tm *tm_struct;
time_t tm_num;

if (!user->tdiff) return;
time(&tm_num);
if (user->tdiff==1) tm_num+=(user->tdiffhour*3600);
else if (user->tdiff==2) tm_num-=(user->tdiffhour*3600);
tm_struct=localtime(&tm_num);
user->tday=tm_struct->tm_yday;
user->tyear=1900+tm_struct->tm_year;
user->tmonth=tm_struct->tm_mon;
user->tmday=tm_struct->tm_mday;
user->twday=tm_struct->tm_wday;
user->thour=tm_struct->tm_hour;
user->tmin=tm_struct->tm_min;
user->tsec=tm_struct->tm_sec;
user->ttime=user->thour;
if (user->ttime>12) user->ttime-=12;
if (user->thour<12) sntrncpy(user->md,"AM",sizeof(user->md));
else sntrncpy(user->md,"PM",sizeof(user->md));
}

/*** Return position of second word in string ***/
char *remove_first(str)
char *str;
{
char *s=str;

if (!str || !*str) return str;
while(*s && *s<33) ++s;
while(*s>32) ++s;
while(*s && *s<33) ++s;
return s;
}

/*** Removes spaces at beginning of string ***/
char *remove_space(str)
char *str;
{
char *s=str;

if (!str || !*str) return str;
while(*s && *s==' ') ++s;
return s;
}

/*** Makes the string backwards ***/
char *backwards(str)
char *str;
{
char *p1,*p2;

if (!str || !*str) return str;
if (color_com_count(str,0)) str=color_com_strip(str);
for(p1=str,p2=str+strlen(str)-1;p2>p1;++p1,--p2) {
	*p1 ^= *p2;
	*p2 ^= *p1;
	*p1 ^= *p2;
	}
return str;
}

/*** Does something strange to the string ***/
char *strange(str)
char *str;
{
char c,str2[ARR_SIZE];

if (!str || !*str) return str;
c=str[0];
sntrncpy(str2,str+1,sizeof(str2));
snprintf(str,ARR_SIZE,"%c %s",c,str2);
return str;
}

/*** Centers text ***/
char *center(str,len)
char *str;
int len;
{
static char text2[ARR_SIZE];
char line[ARR_SIZE];
int cnt,i,j,k=0,l;

if (!str || !*str) return str;
while(*str && k<sizeof(text2)-1) {
	cnt=0; l=0;
	while(*str && *str!='\n' && (l<(80+cnt) || l>ARR_SIZE-3)) {
		j=0;
		if (*str=='~') {
			for(i=0;i<COLNUM;++i) {
				if (!strncmp(str+1,colcom[i],2)) { cnt+=3; line[l++]=*str++; line[l++]=*str++; line[l++]=*str++; ++j; break; }
				}
			if (j) continue;
			}
		line[l++]=*str++;
		}
	line[l]='\0';
	i=len-strlen(line)+(color_com_count(line,0)*3);
	for(j=i/2;j>0 && k<sizeof(text2)-1;--j,++k) text2[k]=' ';
	for(j=0;j<strlen(line) && j+k<sizeof(text2)-1;++j,++k) text2[k]=line[j];
	text2[k++]='\n';
	if (*str && l<80) ++str;
	}
text2[k]='\0';
return text2;
}

/*** Returns the name of a user in a ptdisplayed file ***/
char *pt_name(str)
char *str;
{
static char name[USER_NAME_LEN+1];
int i=0;

if (!str || !*str) return str;
sntrncpy(name,remove_first(remove_first(remove_first(str))),sizeof(name));
while(i<strlen(name) && name[i]!=',') ++i;
name[i]='\0';
return name;
}

/*** Returns the string up to delim ***/
char *split_str(str,delim)
char *str,delim;
{
static char text2[ARR_SIZE];
int i=0;

if (!str || !*str) return str;
while(i<strlen(str) && str[i]!=delim) { text2[i]=str[i]; ++i; }
text2[i]='\0';
return text2;
}

/*** Word wrap ***/
char *wordwrap(str,len)
char *str;
int len;
{
static char text2[ARR_SIZE];
char *s=str;
int cnt=0,i=0,num=0;

if (!str || !*str) return str;
while(*s && i<sizeof(text2)) {
	if (*s=='\n') { num=0; cnt=0; }
	if (num<len) text2[i]=*s;
	else {
		num=i; --num;
		while(text2[num]!=' ' && cnt<len) { --num; ++cnt; }
		if (cnt<len) text2[num]='\n';
		else { text2[i]='\n'; ++i; }
		num=0; cnt=0; continue;
		}
	++s; ++num; ++i;
	}
text2[i]='\0';
return text2;
}

/*** Garble garble ***/
char *garble(str)
char *str;
{
static char text2[ARR_SIZE];
char *s=str;
int i=0,j;

if (!str || !*str) return str;
while(*s) {
	while(33>(j=rand()%127));
	if (*s=='\n' || *s==' ') text2[i]=*s;
	else text2[i]=j;
	++i; ++s;
	}
text2[i]='\0';
return text2;
}

/*** Consolidate ***/
char *consolidate(str)
char *str;
{
static char text2[ARR_SIZE];
int i=0;

if (!str || !*str) return str;
while(*str) {
	while(*str && *str==' ') ++str;
	text2[i]=*str;
	if (*str) ++str;
	++i;
	}
text2[i]='\0';
return text2;
}

/*** Get site ***/
char *get_site(str)
char *str;
{
static char site[SITE_NAME_LEN+1];
int cnt=0,i,j;

for(i=0;i<strlen(str);++i) if (str[i]=='.') ++cnt;
if (cnt>1) {
	i=0;
	if (!isnumber(str)) {
		if (cnt>2) cnt-=2; else --cnt;
		for(j=0;j<cnt;++j) { while(i<strlen(str) && str[i]!='.') ++i; ++i; }
		cnt=0;
		while(i<strlen(str)) { site[cnt]=str[i]; ++cnt; ++i; }
		site[cnt]='\0';
		}
	else {
		j=0;
		while(i<strlen(str) && j<cnt) { site[i]=str[i]; if (str[i]=='.') ++j; ++i; }
		site[i]='\0';
		}
	return site;
	}
return str;
}

/*** Annoy topic thingy ***/
void annoy_topic(str)
char *str;
{
int i=0,j=0;

for(i=0;i<strlen(str);++i) {
	if (++j==2) { j=0; if (rand()%2==1) str[i]=''; else str[i]=''; }
	}
}

/*** Hrmph ***/
void sntrncpy(dest,src,size)
char *dest,*src;
size_t size;
{
strncpy(dest,src,size);
dest[size-1]='\0';
}

/*** Returns 1 if string is a positive number ***/
int isnumber(str)
char *str;
{
if (!str || !*str) return 0;
while(*str) { if (!isdigit(*str) && *str!='.') return 0; ++str; }
return 1;
}

/*** This is the function that sends mail to other users ***/
void send_mail(user,to,str,anon)
UR_OBJECT user;
char *to,*str;
int anon;
{
char filename[FILENAME_LEN],from[USER_NAME_LEN+1],*s,*service;
FILE *fp;
NL_OBJECT nl;
UR_OBJECT user2;

if (anon==1 && sys_mail) return;
if (ban_swearing && contains_swearing(str)) {
	swore(user);
	return;
	}
if (contains_pt(str)) return;
s=to;  service=NULL;
while(*s) {
	if (*s=='@') {
		service=s+1;  *s='\0';
		for(nl=nl_first;nl;nl=nl->next) {
			if (!strcmp(nl->service,service) && nl->stage==2) {
				send_external_mail(nl,user,to,str);
				return;
				}
			}
		snprintf(text,sizeof(text),"Service %s unavailable.\n",service);
		write_user(user,text);
		return;
		}
	++s;
	}
snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,to);
if (!(fp=fopen(filename,"a"))) {
	write_user(user,"Error in mail delivery.\n");
	write_syslog("ERROR: Couldn't open mail file in send_mail().\n",0);
	return;
	}
if (anon==1) sntrncpy(from,"SYSTEM",sizeof(from));
else sntrncpy(from,user->name,sizeof(from));
fprintf(fp,"PT: %d\r",(int)time(0));
if (anon==4) {
	if (user) fprintf(fp,"From: %s, %d/%d/%d at %02d:%02d %s (Mass mail)\n",from,tmonth+1,tmday,tyear,ttime,tmin,md);
	else fprintf(fp,"From: MAILER, %d/%d/%d at %02d:%02d %s (Mass mail)\n",tmonth+1,tmday,tyear,ttime,tmin,md);
	}
else if (anon==3) {
	if (user) fprintf(fp,"From: %s, %d/%d/%d at %02d:%02d %s (All mail)\n",from,tmonth+1,tmday,tyear,ttime,tmin,md);
	else fprintf(fp,"From: MAILER, %d/%d/%d at %02d:%02d %s (All mail)\n",tmonth+1,tmday,tyear,ttime,tmin,md);
	}
else if (anon==2) {
	if (user) fprintf(fp,"From: %s, %d/%d/%d at %02d:%02d %s (Friendly mail)\n",from,tmonth+1,tmday,tyear,ttime,tmin,md);
	else fprintf(fp,"From: MAILER, %d/%d/%d at %02d:%02d %s (Friendly mail)\n",tmonth+1,tmday,tyear,ttime,tmin,md);
	}
else {
	if (user) {
		if (user->type==REMOTE_TYPE)
			fprintf(fp,"From: %s@%s, %d/%d/%d at %02d:%02d %s\n",from,user->netlink->service,tmonth+1,tmday,tyear,ttime,tmin,md);
		else fprintf(fp,"From: %s, %d/%d/%d at %02d:%02d %s\n",from,tmonth+1,tmday,tyear,ttime,tmin,md);
		}
	else fprintf(fp,"From: MAILER, %d/%d/%d at %02d:%02d %s\n",tmonth+1,tmday,tyear,ttime,tmin,md);
	}
fputs(str,fp);
if (user->reply) { fclose(fp); reply(user); }
else { fputs("\n",fp); fclose(fp); }
if (user && anon==5) {
	snprintf(filename,sizeof(filename),"%s/%s.Y",USERFILES,user->name);
	if (!(fp=fopen(filename,"a"))) {
		write_user(user,"Error in mail delivery.\n");
		write_syslog("ERROR: Couldn't open mail file in send_mail().\n",0);
		return;
		}
	fprintf(fp,"PT: %d\r",(int)time(0));
	fprintf(fp,"From: %s, To: %s, %d/%d/%d at %02d:%02d %s\n",from,to,tmonth+1,tmday,tyear,ttime,tmin,md);
	fprintf(fp,"%s\n",str);
	fclose(fp);
	}
if (anon==1) {
	snprintf(text,sizeof(text),"A giant hand grabs your message and delivers it to %s anonymously!\n",to);
	write_user(user,text);
	}
else {
	snprintf(text,sizeof(text),"A giant hand grabs your message and delivers it to %s!\n",to);
	write_user(user,text);
	}
if (anon==1) snprintf(text,sizeof(text),"%s mailed %s anonymously!\n",user->name,to);
else snprintf(text,sizeof(text),"%s mailed %s!\n",user->name,to);
write_syslog(text,1);
if (anon && anon!=1) check_vacation(user,to);
if ((user2=get_user(to,0)) && user2->listen) {
	snprintf(text,sizeof(text),"~PZ~LI~OL~FY***~LI~OL~FM You have~RS ~LI~FRNEW MAIL~RS ~LI~OL~FMfrom~RS ~LI~OL~FB%s~RS ~LI~OL~FY***\n",from);
	write_user(user2,text);
	if (user2->autoread==3 || user2->autoread==4) {
		word_count=2;
		sntrncpy(word[1],"new",sizeof(word[1]));
		rmail(user2);
		}
	}
}

/*** This is the function that sends mail to remote talkers ***/
void send_external_mail(nl,user,to,str)
NL_OBJECT nl;
UR_OBJECT user;
char *to,*str;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/OUT_%s_%s@%s",MAILSPOOL,user->name,to,nl->service);
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: unable to spool mail.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to append in send_external_mail().\n",filename);
	write_syslog(text,0);
	return;
	}
putc('\n',fp);
fputs(str,fp);
fclose(fp);
snprintf(text,sizeof(text),"EXISTS? %s %s\n",to,user->name);
write_sock(nl->socket,text);
write_user(user,"Mail sent.\n");
}

/*** Convert string to upper case ***/
void strtoupper(str)
char *str;
{
while(*str) { *str=toupper(*str); ++str; }
}

/*** Convert string to lower case ***/
void strtolower(str)
char *str;
{
while(*str) { *str=tolower(*str); ++str; }
}

/*** Check if character is a letter ***/
int isletter(c)
int c;
{
if (c=='a' || c=='A') return 1;
else if (c=='b' || c=='B') return 1;
else if (c=='c' || c=='C') return 1;
else if (c=='d' || c=='D') return 1;
else if (c=='e' || c=='E') return 1;
else if (c=='f' || c=='F') return 1;
else if (c=='g' || c=='G') return 1;
else if (c=='h' || c=='H') return 1;
else if (c=='i' || c=='I') return 1;
else if (c=='j' || c=='J') return 1;
else if (c=='k' || c=='K') return 1;
else if (c=='l' || c=='L') return 1;
else if (c=='m' || c=='M') return 1;
else if (c=='n' || c=='N') return 1;
else if (c=='o' || c=='O') return 1;
else if (c=='p' || c=='P') return 1;
else if (c=='q' || c=='Q') return 1;
else if (c=='r' || c=='R') return 1;
else if (c=='s' || c=='S') return 1;
else if (c=='t' || c=='T') return 1;
else if (c=='u' || c=='U') return 1;
else if (c=='v' || c=='V') return 1;
else if (c=='w' || c=='W') return 1;
else if (c=='x' || c=='X') return 1;
else if (c=='y' || c=='Y') return 1;
else if (c=='z' || c=='Z') return 1;
else return 0;
}

/*** Check if string contains any non alphanumeric characters ***/
int stralnum(str)
char *str;
{
while(*str) {
	if (!isalnum(*str)) return 1;
	++str;
	}
return 0;
}

/*** Check if string contains any non alphabetic characters ***/
int stralpha(str)
char *str;
{
while(*str) {
	if (!isletter(*str)) return 1;
	++str;
	}
return 0;
}

/*** Check for valid email address ***/
int check_email(user,str)
UR_OBJECT user;
char *str;
{
char *s;
int cnt=0,i;

if (word_count>2) {
	write_user(user,"Not a valid email address.\n");
	return 1;
	}
for(i=0;i<strlen(str);++i) {
	if (!isalnum(str[i]) && str[i]!='.' && str[i]!='@') {
		write_user(user,"Not a valid email address.\n");
		return 1;
		}
	}
if (!isalnum(str[strlen(str)-1])) {
	write_user(user,"Not a valid email address.\n");
	return 1;
	}
s=str;
while(*s) {
	if (*s=='@') {
		if (s==str) {
			write_user(user,"Name missing before @ sign.\n");
			return 1;
			}
		++cnt;  break;
		}
	++s;
	}
if (!cnt || cnt>1) {
	if (!cnt) write_user(user,"Must supply a @ in email address.\n");
	else write_user(user,"Must supply only one @ in email address.\n");
	return 1;
	}
if (!instr(str,".")) {
	write_user(user,"Must supply a . in email address.\n");
	return 1;
	}
return 0;
}

/*** Clear the review buffer in the room ***/
void clear_conv(room)
RM_OBJECT room;
{
char filename[FILENAME_LEN];

snprintf(filename,sizeof(filename),"%s/%s.U",DATAFILES,room->name);
unlink(filename);
}

/*** See if string contains any swearing ***/
int contains_swearing(str)
char *str;
{
char line[82],*s;
int i=0;
FILE *fp;

str=consolidate(str); /* Don't ever say was hit by a car in a public room:P */
if (!(s=(char *)malloc(strlen(str)+1))) return 0;
strcpy(s,str);
strtolower(s);
while(swear_words[i][0]!='*') {
	if (instr(s,swear_words[i])) {  free(s);  return 1;  }
	++i;
	}
if (!(fp=fopen(SWBANS,"r"))) { free(s); return 0; }
fgets(line,sizeof(line),fp);
line[strlen(line)-1]='\0';
while(!feof(fp)) {
	if (instr(s,line)) { fclose(fp);  free(s);  return 1; }
	fgets(line,sizeof(line),fp);
	line[strlen(line)-1]='\0';
	}
fclose(fp);
free(s);
return 0;
}

/*** See if string contains PT: or PTSTR ***/
int contains_pt(str)
char *str;
{
char ptstr[5],*s;

sntrncpy(ptstr,PTSTR,sizeof(ptstr));
if (!(s=(char *)malloc(strlen(str)+1))) return 0;
strcpy(s,str);
strtolower(s);
if (instr(s,"pt:") || instr(s,ptstr)) {  free(s);  return 1;  }
free(s);
return 0;
}

/*** See if string contains trigger ***/
int contains_trigger(user,str)
UR_OBJECT user;
char *str;
{
char filename[FILENAME_LEN],line[82],*s;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.T",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
if (!(s=(char *)malloc(strlen(str)+1))) { fclose(fp); return 0; }
strcpy(s,str);
fgets(line,sizeof(line),fp);
user->whichtrig=1;
while(!feof(fp)) {
	line[strlen(line)-1]='\0';
	if (instr(s,line) && strlen(line)>=2) { fclose(fp); free(s); return 1; }
	fgets(line,sizeof(line),fp); fgets(line,sizeof(line),fp);
	++user->whichtrig;
	}
fclose(fp);
free(s);
return 0;
}

/*** User has swore, now deal with him ***/
int swore(user)
UR_OBJECT user;
{
char name[USER_NAME_LEN+1];
RM_OBJECT room;
UR_OBJECT user2;

write_user(user,noswearing);
snprintf(text,sizeof(text),"%s ~OL~FRSWORE~RS!\n",user->name);
write_syslog(text,1);
room=get_room2("Brig");
move_user(user,room,5);
sntrncpy(name,"Lilmouse",sizeof(name));
if ((user2=get_user(name,0))) {
	snprintf(text,sizeof(text),"~FBlilmouse shouts:~RS ~LINo swearing allowed!!!\n");
	write_room_except(NULL,text,user2,NULL,1,user2);
	}
if (user->level==PRIVATE) { user_goaway(user,1); return 1; }
return 0;
}

/*** Reset terminal ***/
void reset_term(user)
UR_OBJECT user;
{
write_sock(user->socket,"\033[0m");
}

/*** Clear to end of line ***/
void clear_line(user)
UR_OBJECT user;
{
write_sock(user->socket,"\033[K");
}

/*** Count the number of newlines in a string or file ***/
int newline_count(str,which)
char *str;
int which;
{
char c,*s;
int cnt=0;
FILE *fp;

if (!which) {
	s=str;
	while(*s) { if (*s=='\n') ++cnt; ++s; }
	}
else {
	if (!(fp=fopen(str,"r"))) return 0;
	c=getc(fp);
	while(!feof(fp)) {
		if (c=='\n') ++cnt;
		c=getc(fp);
		}
	fclose(fp);
	}
return cnt;
}

/*** Count the number of color commands in a string or file ***/
int color_com_count(str,which)
char *str;
int which;
{
char *s;
int cnt=0,i,j;
FILE *fp;

if (!which) {
	s=str;
	while(*s) {
		j=0;
		if (*s=='~') {
			if (*(s+1)=='\\') { ++s; ++s; continue; }
			}
		if (*s=='\\') {
			if (*(s+1)=='~') {
				for(i=0;i<COLNUM;++i) {
					if (!strncmp(s+2,colcom[i],2)) { ++s; ++s; ++s; ++s; ++j; break; }
					}
				if (j) continue;
				}
			}
		if (*s=='~') {
			for(i=0;i<COLNUM;++i) {
				if (!strncmp(s+1,colcom[i],2)) { ++cnt; ++s; ++s; ++s; ++j; break; }
				}
			if (j) continue;
			}
		++s;
		}
	}
else {
	if (!(fp=fopen(str,"r"))) return 0;
	fgets(text,sizeof(text),fp);
	while(!feof(fp)) {
		s=text;
		while(*s) {
			j=0; s=str;
			if (*s=='~') {
				if (*(s+1)=='\\') { ++s; ++s; continue; }
				}
			if (*s=='\\') {
				if (*(s+1)=='~') {
					for(i=0;i<COLNUM;++i) {
						if (!strncmp(s+2,colcom[i],2)) { ++s; ++s; ++s; ++s; ++j; break; }
						}
					if (j) continue;
					}
				}
			if (*s=='~') {
				for(i=0;i<COLNUM;++i) {
					if (!strncmp(s+1,colcom[i],2)) { ++cnt; ++s; ++s; ++s; ++j; break; }
					}
				if (j) continue;
				}
			++s;
			}
		fgets(text,sizeof(text),fp);
		}
	fclose(fp);
	}
return cnt;
}

/*** Strip out color commands from string for when we are sending strings
     over a netlink to a talker that doesn't support them ***/
char *color_com_strip(str)
char *str;
{
static char text2[ARR_SIZE];
char *s=str,*t=text2;
int i,j;

if (!str || !*str) return str;
while(*s) {
	j=0;
	if (*s=='~') {
		if (*(s+1)=='\\') { *t++=*s++; *t++=*s++; continue; }
		}
	if (*s=='\\') {
		if (*(s+1)=='~') {
			for(i=0;i<COLNUM;++i) {
				if (!strncmp(s+2,colcom[i],2)) { *t++=*s++; *t++=*s++; *t++=*s++; *t++=*s++; ++j; break; }
				}
			if (j) continue;
			}
		}
	if (*s=='~') {
		for(i=0;i<COLNUM;++i) {
			if (!strncmp(s+1,colcom[i],2)) { ++s; ++s; ++s; ++j; break; }
			}
		if (j) continue;
		}
	*t++=*s;
	++s;
	}
*t='\0';
return text2;
}

/*** Count number of NAMESTRINGs in a string or file ***/
int name_count(str,which)
char *str;
int which;
{
char *s;
int cnt=0;
FILE *fp;

if (!which) {
	s=str;
	while(*s) {
		if (*s=='~') {
			if (*(s+1)=='\\') { ++s; ++s; continue; }
			}
		if (*s=='\\') {
			if (!strncmp(s+1,NAMESTRING,2)) { ++s; ++s; ++s; continue; }
			}
		if (!strncmp(s,NAMESTRING,2)) { ++cnt; ++s; }
		++s;
		}
	}
else {
	if (!(fp=fopen(str,"r"))) return 0;
	fgets(text,sizeof(text),fp);
	while(!feof(fp)) {
		s=text;
		while(*s) {
			if (*s=='~') {
				if (*(s+1)=='\\') { ++s; ++s; continue; }
				}
			if (*s=='\\') {
				if (!strncmp(s+1,NAMESTRING,2)) { ++s; ++s; ++s; continue; }
				}
			if (!strncmp(s,NAMESTRING,2)) { ++cnt; ++s; }
			++s;
			}
		fgets(text,sizeof(text),fp);
		}
	fclose(fp);
	}
return cnt;
}

/*** Strip out NAMESTRINGs in a string ***/
char *name_strip(str)
char *str;
{
static char text2[ARR_SIZE];
char *s=str,*t=text2;

if (!str || !*str) return str;
while(*s) {
	if (*s=='~') {
		if (*(s+1)=='\\') { *t++=*s++; *t++=*s++; continue; }
		}
	if (*s=='\\') {
		if (!strncmp(s+1,NAMESTRING,2)) { *t++=*s++; *t++=*s++; *t++=*s++; continue; }
		}
	if (!strncmp(s,NAMESTRING,2)) { ++s; ++s; continue; }
	*t++=*s;
	++s;
	}
*t='\0';
return text2;
}

/*** Count number of PTs in a string or file ***/
int pt_count(str,which)
char *str;
int which;
{
char *s;
int cnt=0;
FILE *fp;

if (!which) {
	s=str;
	while(*s) {
		if (!strncmp(s,"PT:",3)) { ++cnt; ++s; ++s; }
		++s;
		}
	}
else {
	if (!(fp=fopen(str,"r"))) return 0;
	fgets(text,sizeof(text),fp);
	while(!feof(fp)) {
		s=text;
		while(*s) {
			if (!strncmp(s,"PT:",3)) { ++cnt; ++s; ++s; }
			++s;
			}
		fgets(text,sizeof(text),fp);
		}
	fclose(fp);
	}
return cnt;
}

/*** Strip out PTs in a string ***/
char *pt_strip(str)
char *str;
{
static char text2[ARR_SIZE];
char *s=str,*t=text2;

if (!str || !*str) return str;
while(*s) {
	if (!strncmp(s,"PT:",3)) { while(*s && *s!='\r') ++s; if (*s) ++s; continue; }
	*t++=*s;
	++s;
	}
*t='\0';
return text2;
}

/*** Check to see if login message file exists ***/
int check_iflim(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.L",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
else { fclose(fp); return 1; }
}

/*** Check to see if logout message file exists ***/
int check_iflom(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.N",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
else { fclose(fp); return 1; }
}

/*** Check to see if annoystring message file exists ***/
int check_ifannoy(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.Q",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
else { fclose(fp); return 1; }
}

/*** Check to see if autologin message file exists ***/
int check_ifauto(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.V",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
else { fclose(fp); return 1; }
}

/*** Check to see if user is on vacation ***/
void check_vacation(user,other)
UR_OBJECT user;
char *other;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.R",USERFILES,other);
if (!(fp=fopen(filename,"r"))) return;
else { fclose(fp); write_user(user,"User is away with the following message:\n"); more(user,filename,1); }
}

/*** Destroy all clones belonging to given user ***/
void destroy_user_clones(user)
UR_OBJECT user;
{
UR_OBJECT user2;

for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->owner==user) {
		if (!user->hid && user2->room) {
			snprintf(text,sizeof(text),"The clone of %s shimmers and vanishes.\n",user2->morphed);
			write_room(user2->room,text);
			}
		destruct_user(user2,0);
		}
	}
}


/************ NUTS PROTOCOL AND LINK MANAGEMENT FUNCTIONS ************/
/* Please don't alter these functions. If you do you may introduce
   incompatabilities which may prevent other systems connecting or cause
   bugs on the remote site and yours. You may think it looks simple but
   even the newline count is important in some places. */

/*** Accept incoming server connection ***/
void accept_server_connections(sock,acc_addr)
int sock;
struct sockaddr_in acc_addr;
{
char site[SITE_NAME_LEN+1];
int i=0;
NL_OBJECT nl,nl2;
RM_OBJECT room;

snprintf(text,sizeof(text),"NUTS %s\n",NVERSION);
write_sock(sock,text);
sntrncpy(site,get_ip_address(NULL,acc_addr,1),sizeof(site));
snprintf(text,sizeof(text),"NETLINK: Received request connection from site %s.\n",site);
write_syslog(text,1);
for(nl2=nl_first;nl2;nl2=nl2->next) if (!strcmp(nl2->site,site)) ++i;
if (!i) {
	write_sock(sock,"DENIED CONNECT 1\n");
	close(sock);
	write_syslog("NETLINK: Request denied, remote site not in valid sites list.\n",1);
	return;
	}
for(room=room_first;room;room=room->next) {
	if (!room->netlink && room->inlink) {
		if (!(nl=create_netlink())) {
			write_sock(sock,"DENIED CONNECT 2\n");
			close(sock);
			write_syslog("NETLINK: Request denied, unable to create netlink object.\n",1);
			return;
			}
		room->netlink=nl;
		nl->socket=sock;
		nl->type=INCOMING;
		nl->stage=VERIFYING;
		nl->connect_room=room;
		nl->allow=nl2->allow;
		nl->last_recvd=time(0);
		sntrncpy(nl->service,"<verifying>",sizeof(nl->service));
		sntrncpy(nl->site,site,sizeof(nl->site));
		write_sock(sock,"GRANTED CONNECT\n");
		write_syslog("NETLINK: Request granted.\n",1);
		return;
		}
	}
write_sock(sock,"DENIED CONNECT 3\n");
close(sock);
write_syslog("NETLINK: Request denied, no free room links.\n",1);
}

/*** Deal with netlink data on link nl ***/
void exec_netcom(nl,inpstr)
NL_OBJECT nl;
char *inpstr;
{
/* The most used commands have been truncated to save bandwidth, ie ACT is
   short for action, EMSG is short for end message. Commands that don't get
   used much ie VERIFICATION have been left long for readability. */
char *netcom[]={
"DISCONNECT","TRANS","REL","ACT","GRANTED",
"DENIED","MSG","EMSG","PRM","VERIFICATION",
"VERIFY","REMVD","ERROR","EXISTS?","EXISTS_NO",
"EXISTS_YES","MAIL","ENDMAIL","MAILERROR","KA",
"RSTAT","*"
};
char ctemp,*str,w1[ARR_SIZE],w2[ARR_SIZE],w3[ARR_SIZE];
int i=0,lev,netcom_num;

if (nl->buffer[0]) { strncat(nl->buffer,inpstr,sizeof(nl->buffer));  inpstr=nl->buffer; }
nl->last_recvd=time(0);
while(*inpstr) {
	w1[0]='\0';  w2[0]='\0';  w3[0]='\0';  lev=0;
	if (*inpstr!='\n') sscanf(inpstr,"%s %s %s %d",w1,w2,w3,&lev);
	/* Find first newline */
	str=inpstr;  ctemp=1; /* hopefully we'll never get char 1 in the string */
	while(*str) { if (*str=='\n') {  ctemp=*(str+1); *(str+1)='\0';  break; } ++str; }
	/* If no newline then input is incomplete, store and return */
	if (ctemp==1) {
		if (inpstr!=nl->buffer) sntrncpy(nl->buffer,inpstr,sizeof(nl->buffer));
		return;
		}
	/* Get command number */
	netcom_num=0;
	while(netcom[netcom_num][0]!='*') {
		if (!strcmp(netcom[netcom_num],w1)) break;
		++netcom_num;
		}
	/* Deal with initial connects */
	if (nl->stage==VERIFYING) {
		if (nl->type==OUTGOING) {
			if (strcmp(w1,"NUTS")) {
				snprintf(text,sizeof(text),"NETLINK: Incorrect connect message from %s.\n",nl->service);
				write_syslog(text,1);
				shutdown_netlink(nl);
				return;
				}
			/* Store remote version for compat checks */
			nl->stage=UP;
			w2[10]='\0';
			sscanf(w2,"%d.%d.%d",&nl->ver_major,&nl->ver_minor,&nl->ver_patch);
			++i;
			}
		else {
			if (netcom_num!=9) {
				snprintf(text,sizeof(text),"NETLINK: No verification sent by site %s.\n",nl->site);
				write_syslog(text,1);
				shutdown_netlink(nl);
				return;
				}
			nl->stage=UP;
			}
		}
	if (!i) {
		/* If remote is currently sending a message relay it to user, don't
		   interpret it unless its EMSG or ERROR */
		if (nl->mesg_user && netcom_num!=7 && netcom_num!=12) {
			/* If -1 then user logged off before end of mesg received */
			if (nl->mesg_user!=(UR_OBJECT)-1) write_user(nl->mesg_user,inpstr);
			++i;
			}
		}
	if (!i) {
		/* Same goes for mail except its ENDMAIL or ERROR */
		if (nl->mailfile && netcom_num!=17) {
			fputs(inpstr,nl->mailfile);
			++i;
			}
		}
	if (!i) {
		nl->lastcom=netcom_num;
		switch(netcom_num) {
			case 0:
				if (nl->stage==UP) {
					snprintf(text,sizeof(text),"~OLSYSTEM:~RS Disconnecting from service %s in the %s.\n",nl->service,nl->connect_room->name);
					write_room(NULL,text);
					}
				shutdown_netlink(nl);
				break;
			case 1: nl_transfer(nl,w2,w3,lev,inpstr);  break;
			case 2: nl_release(nl,w2);  break;
			case 3: nl_action(nl,w2,inpstr);  break;
			case 4: nl_granted(nl,w2);  break;
			case 5: nl_denied(nl,w2,inpstr);  break;
			case 6: nl_mesg(nl,w2); break;
			case 7: nl->mesg_user=NULL;  break;
			case 8: nl_prompt(nl,w2);  break;
			case 9: nl_verification(nl,w2,w3,0);  break;
			case 10: nl_verification(nl,w2,w3,1);  break;
			case 11: nl_removed(nl,w2);  break;
			case 12: nl_error(nl);  break;
			case 13: nl_checkexist(nl,w2,w3);  break;
			case 14: nl_user_notexist(nl,w2,w3);  break;
			case 15: nl_user_exist(nl,w2,w3);  break;
			case 16: nl_mail(nl,w2,w3);  break;
			case 17: nl_endmail(nl);  break;
			case 18: nl_mailerror(nl,w2,w3);  break;
			case 19: /* Keepalive signal, do nothing */ break;
			case 20: nl_rstat(nl,w2);  break;
			default:
				snprintf(text,sizeof(text),"NETLINK: Received unknown command '%s' from %s.\n",w1,nl->service);
				write_syslog(text,1);
				write_sock(nl->socket,"ERROR\n");
			}
		}
	if (nl->type==UNCONNECTED) return;
	*(str+1)=ctemp;
	inpstr=str+1;
	}
nl->buffer[0]='\0';
}

/*** Deal with user being transferred over from remote site ***/
void nl_transfer(nl,name,pass,lev,inpstr)
NL_OBJECT nl;
char *name,*pass;
int lev;
char *inpstr;
{
UR_OBJECT user2;

if (nl->allow==OUT) {
	snprintf(text,sizeof(text),"DENIED %s 4\n",name);
	write_sock(nl->socket,text);
	return;
	}
if (strlen(name)>USER_NAME_LEN) name[USER_NAME_LEN]='\0';
if (user_banned(name)) {
	if (nl->ver_major==3 && nl->ver_minor>=3 && nl->ver_patch>=3)
		snprintf(text,sizeof(text),"DENIED %s 9\n",name); /* new error for 3.3.3 */
	else snprintf(text,sizeof(text),"DENIED %s 6\n",name); /* old error to old versions */
	write_sock(nl->socket,text);
	return;
	}
if ((user2=get_user(name,0))) {
	snprintf(text,sizeof(text),"DENIED %s 5\n",name);
	write_sock(nl->socket,text);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"DENIED %s 6\n",name);
	write_sock(nl->socket,text);
	return;
	}
user2->type=REMOTE_TYPE;
sntrncpy(user2->name,name,sizeof(user2->name));
if (load_user_details(user2)) {
	if (strcmp(user2->pass,pass) || user2->booted) {
		snprintf(text,sizeof(text),"DENIED %s 7\n",name);
		write_sock(nl->socket,text);
		destruct_user(user2,0);
		return;
		}
	}
else {
	if (nl->ver_major<=3 && nl->ver_minor<=3 && nl->ver_patch<1)
		sntrncpy(text,remove_first(remove_first(remove_first(inpstr))),sizeof(text));
	else sntrncpy(text,remove_first(remove_first(remove_first(remove_first(inpstr)))),sizeof(text));
	text[USER_DESC_LEN]='\0';
	terminate(text);
	sntrncpy(user2->desc,text,sizeof(user2->desc));
	sntrncpy(user2->in_phrase,"enters",sizeof(user2->in_phrase));
	sntrncpy(user2->out_phrase,"goes",sizeof(user2->out_phrase));
	sntrncpy(user2->morphed,user2->name,sizeof(user2->morphed));
	sntrncpy(user2->email,"None",sizeof(user2->email));
	sntrncpy(user2->age,"None",sizeof(user2->age));
	sntrncpy(user2->gender,"None",sizeof(user2->gender));
	sntrncpy(user2->url,"None",sizeof(user2->url));
	sntrncpy(user2->homeroom,"crater",sizeof(user2->homeroom));
	sntrncpy(user2->arrdesc,user2->desc,sizeof(user2->arrdesc));
	sntrncpy(user2->bigname,user2->morphed,sizeof(user2->bigname));
	sntrncpy(user2->bigdesc,user2->desc,sizeof(user2->bigdesc));
	sntrncpy(user2->bakename,user2->morphed,sizeof(user2->bakename));
	sntrncpy(user2->bakedesc,user2->desc,sizeof(user2->bakedesc));
	sntrncpy(user2->merlyn,user2->name,sizeof(user2->merlyn));
	user2->level=-1;
	if (nl->ver_major==3 && nl->ver_minor>=3 && nl->ver_patch>=1) {
		if (lev>rem_user_maxlevel) user2->level=rem_user_maxlevel;
		else user2->level=lev;
		}
	else user2->level=rem_user_deflevel;
	}
if (user2->level<minlogin_level) {
	if (nl->ver_major==3 && nl->ver_minor>=3 && nl->ver_patch>=3)
		snprintf(text,sizeof(text),"DENIED %s 8\n",user2->name); /* new error for 3.3.3 */
	else snprintf(text,sizeof(text),"DENIED %s 6\n",user2->name); /* old error to old versions */
	write_sock(nl->socket,text);
	destruct_user(user2,0);
	return;
	}
sntrncpy(user2->site,nl->service,sizeof(user2->site));
snprintf(text,sizeof(text),"%s enters from cyberspace.\n",user2->name);
write_room(nl->connect_room,text);
snprintf(text,sizeof(text),"NETLINK: Remote user %s received from %s.\n",user2->name,nl->service);
write_syslog(text,1);
user2->room=nl->connect_room;
user2->netlink=nl;
user2->read_mail=time(0);
user2->last_login=time(0);
++num_of_users;
snprintf(text,sizeof(text),"GRANTED %s\n",name);
write_sock(nl->socket,text);
}

/*** User is leaving this system ***/
void nl_release(nl,name)
NL_OBJECT nl;
char *name;
{
UR_OBJECT user2;

if ((user2=get_user(name,0)) && user2->type==REMOTE_TYPE) {
	snprintf(text,sizeof(text),"%s leaves this plain of existence.\n",user2->name);
	write_room_except(user2->room,text,user2,NULL,0,NULL);
	snprintf(text,sizeof(text),"NETLINK: Remote user %s released.\n",user2->name);
	write_syslog(text,1);
	destroy_user_clones(user2);
	destruct_user(user2,0);
	num_of_users--;
	return;
	}
snprintf(text,sizeof(text),"NETLINK: Release requested for unknown/invalid user %s from %s.\n",name,nl->service);
write_syslog(text,1);
}

/*** Remote user performs an action on this system ***/
void nl_action(nl,name,inpstr)
NL_OBJECT nl;
char *name,*inpstr;
{
char ctemp,*str;
UR_OBJECT user2;

if (!(user2=get_user(name,0))) {
	snprintf(text,sizeof(text),"DENIED %s 8\n",name);
	write_sock(nl->socket,text);
	return;
	}
if (user2->socket!=-1) {
	snprintf(text,sizeof(text),"NETLINK: Action requested for local user %s from %s.\n",name,nl->service);
	write_syslog(text,1);
	return;
	}
inpstr=remove_first(remove_first(inpstr));
str=inpstr; ctemp='\0';
while(*str) { if (*str=='\n') {  ctemp=*str;  *str='\0';  break;  } ++str; }
user2->last_input=time(0);
if (user2->misc_op) {
	if (!strcmp(inpstr,"NL")) misc_ops(user2,"\n");
	else misc_ops(user2,inpstr+4);
	return;
	}
clear_words();
word_count=wordfind(inpstr);
if (!strcmp(inpstr,"NL")) return;
if (!strcmp(word[0],"say")) sntrncpy(word[0],".say",sizeof(word[0]));
if (!strcmp(word[0],"look")) sntrncpy(word[0],".look",sizeof(word[0]));
exec_com(user2,inpstr);
if (ctemp) *str=ctemp;
if (!user2->misc_op) prompt(user2);
}

/*** Grant received from remote system ***/
void nl_granted(nl,name)
NL_OBJECT nl;
char *name;
{
RM_OBJECT old_room;
UR_OBJECT user2;

if (!strcmp(name,"CONNECT")) {
	snprintf(text,sizeof(text),"NETLINK: Connection to %s granted.\n",nl->service);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"VERIFICATION %s %s\n",verification,NVERSION);
	write_sock(nl->socket,text);
	return;
	}
if (!(user2=get_user(name,0))) {
	snprintf(text,sizeof(text),"NETLINK: Grant received for unknown user %s from %s.\n",name,nl->service);
	write_syslog(text,1);
	return;
	}
if (user2->remote_com!=GO) {
	snprintf(text,sizeof(text),"NETLINK: Unexpected grant for %s received from %s.\n",name,nl->service);
	write_syslog(text,1);
	return;
	}
write_user(user2,"~OL~FBYou traverse cyberspace...\n");
if (user2->vis) {
	snprintf(text,sizeof(text),"%s %s to the %s.\n",user2->name,user2->out_phrase,nl->service);
	write_room_except(user2->room,text,user2,NULL,0,NULL);
	}
else write_room_except(user2->room,invisleave,user2,NULL,0,NULL);
snprintf(text,sizeof(text),"NETLINK: %s transferred to %s.\n",user2->name,nl->service);
write_syslog(text,1);
old_room=user2->room;
user2->room=NULL;
user2->netlink=nl;
user2->pot_netlink=NULL;
user2->remote_com=-1;
user2->misc_op=0;
user2->endoffile=0;
user2->filepos=0;
user2->numpages=0;
user2->revdisp=0;
user2->origpos=0;
user2->page_file[0]='\0';
reset_access(old_room);
snprintf(text,sizeof(text),"ACT %s look\n",user2->name);
write_sock(nl->socket,text);
}

/*** Deny received from remote system ***/
void nl_denied(nl,name,inpstr)
NL_OBJECT nl;
char *name,*inpstr;
{
char *neterr[]={
"this site is not in the remote services valid sites list",
"the remote service is unable to create a link",
"the remote service has no free room links",
"the link is for incoming users only",
"a user with your name is already logged on the remote site",
"the remote service was unable to create a session for you",
"incorrect password. Use '.go <service> <remote password>'",
"your level there is below the remote services current minlogin level",
"you are banned from that service"
};
int errnum;
UR_OBJECT user2;

errnum=0;
sscanf(remove_first(remove_first(inpstr)),"%d",&errnum);
if (!strcmp(name,"CONNECT")) {
	snprintf(text,sizeof(text),"NETLINK: Connection to %s denied, %s.\n",nl->service,neterr[errnum-1]);
	write_syslog(text,1);
	/* If wiz initiated connect let them know its failed */
	snprintf(text,sizeof(text),"~OLSYSTEM:~RS Connection to %s failed, %s.\n",nl->service,neterr[errnum-1]);
	write_wiz(com_level[CON],text,NULL);
	close(nl->socket);
	nl->type=UNCONNECTED;
	nl->stage=DOWN;
	return;
	}
if (!(user2=get_user(name,0))) {
	snprintf(text,sizeof(text),"NETLINK: Deny for unknown user %s received from %s.\n",name,nl->service);
	write_syslog(text,1);
	return;
	}
snprintf(text,sizeof(text),"NETLINK: Deny %d for user %s received from %s.\n",errnum,name,nl->service);
write_syslog(text,1);
snprintf(text,sizeof(text),"Sorry, %s.\n",neterr[errnum-1]);
write_user(user2,text);
prompt(user2);
user2->remote_com=-1;
user2->pot_netlink=NULL;
}

/*** Text received to display to a user on here ***/
void nl_mesg(nl,name)
NL_OBJECT nl;
char *name;
{
UR_OBJECT user2;

if (!(user2=get_user(name,0))) {
	snprintf(text,sizeof(text),"NETLINK: Message received for unknown user %s from %s.\n",name,nl->service);
	write_syslog(text,1);
	nl->mesg_user=(UR_OBJECT)-1;
	return;
	}
nl->mesg_user=user2;
}

/*** Remote system asking for prompt to be displayed ***/
void nl_prompt(nl,name)
NL_OBJECT nl;
char *name;
{
UR_OBJECT user2;

if (!(user2=get_user(name,0))) {
	snprintf(text,sizeof(text),"NETLINK: Prompt received for unknown user %s from %s.\n",name,nl->service);
	write_syslog(text,1);
	return;
	}
if (user2->type==REMOTE_TYPE) {
	snprintf(text,sizeof(text),"NETLINK: Prompt received for remote user %s from %s.\n",name,nl->service);
	write_syslog(text,1);
	return;
	}
prompt(user2);
}

/*** Verification received from remote site ***/
void nl_verification(nl,w2,w3,com)
NL_OBJECT nl;
char *w2,*w3;
int com;
{
NL_OBJECT nl2;

if (!com) {
	if (!w2[0]) { shutdown_netlink(nl);  return; }
	for(nl2=nl_first;nl2;nl2=nl2->next) {
		if (!strcmp(nl->site,nl2->site) && !strcmp(w2,nl2->verification)) {
			switch(nl->allow) {
				case IN : write_sock(nl->socket,"VERIFY OK IN\n");  break;
				case OUT: write_sock(nl->socket,"VERIFY OK OUT\n");  break;
				case ALL: write_sock(nl->socket,"VERIFY OK ALL\n");
				}
			sntrncpy(nl->service,nl2->service,sizeof(nl->service));
			sscanf(w3,"%d.%d.%d",&nl->ver_major,&nl->ver_minor,&nl->ver_patch);
			snprintf(text,sizeof(text),"NETLINK: Connected to %s in the %s.\n",nl->service,nl->connect_room->name);
			write_syslog(text,1);
			snprintf(text,sizeof(text),"~OLSYSTEM:~RS New connection to service %s in the %s.\n",nl->service,nl->connect_room->name);
			write_room(NULL,text);
			return;
			}
		}
	write_sock(nl->socket,"VERIFY BAD\n");
	shutdown_netlink(nl);
	return;
	}
if (!strcmp(w2,"OK")) {
	if (!strcmp(w3,"OUT")) {
		if (nl->allow==OUT) {
			snprintf(text,sizeof(text),"NETLINK: WARNING - Permissions deadlock, both sides are outgoing only.\n");
			write_syslog(text,1);
			}
		else nl->allow=IN;
		}
	else {
		if (!strcmp(w3,"IN")) {
			if (nl->allow==IN) {
				snprintf(text,sizeof(text),"NETLINK: WARNING - Permissions deadlock, both sides are incoming only.\n");
				write_syslog(text,1);
				}
			else nl->allow=OUT;
			}
		}
	snprintf(text,sizeof(text),"NETLINK: Connection to %s verified.\n",nl->service);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"~OLSYSTEM:~RS New connection to service %s in the %s.\n",nl->service,nl->connect_room);
	write_room(NULL,text);
	return;
	}
if (!strcmp(w2,"BAD")) {
	snprintf(text,sizeof(text),"NETLINK: Connection to %s has bad verification.\n",nl->service);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"~OLSYSTEM:~RS Connection to %s failed, bad verification.\n",nl->service);
	write_wiz(com_level[CON],text,NULL);
	shutdown_netlink(nl);
	return;
	}
snprintf(text,sizeof(text),"NETLINK: Unknown verify return code from %s.\n",nl->service);
write_syslog(text,1);
shutdown_netlink(nl);
}

/* Remote site only sends REMVD (removed) notification if user on remote site
   tries to go back to his home site or user is booted off. Home site doesn't
   bother sending reply since remote site will remove user no matter what. */
void nl_removed(nl,name)
NL_OBJECT nl;
char *name;
{
UR_OBJECT user2;

if (!(user2=get_user(name,0))) {
	snprintf(text,sizeof(text),"NETLINK: Removed notification for unknown user %s received from %s.\n",name,nl->service);
	write_syslog(text,1);
	return;
	}
if (user2->room) {
	snprintf(text,sizeof(text),"NETLINK: Removed notification of local user %s received from %s.\n",name,nl->service);
	write_syslog(text,1);
	return;
	}
snprintf(text,sizeof(text),"NETLINK: %s returned from %s.\n",user2->name,user2->netlink->service);
write_syslog(text,1);
user2->room=user2->netlink->connect_room;
user2->netlink=NULL;
if (user2->vis) {
	snprintf(text,sizeof(text),"%s %s\n",user2->name,user2->in_phrase);
	write_room_except(user2->room,text,user2,NULL,0,NULL);
	}
else write_room_except(user2->room,invisenter,user2,NULL,0,NULL);
look(user2);
prompt(user2);
}

/*** Got an error back from site, deal with it ***/
void nl_error(nl)
NL_OBJECT nl;
{
if (nl->mesg_user) nl->mesg_user=NULL;
snprintf(text,sizeof(text),"NETLINK: Received ERROR from %s, lastcom = %d.\n",nl->service,nl->lastcom);
write_syslog(text,1);
}

/*** Does user exist? This is a question sent by a remote mailer to
     verifiy mail id's. ***/
void nl_checkexist(nl,to,from)
NL_OBJECT nl;
char *to,*from;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.D",USERFILES,to);
if (!(fp=fopen(filename,"r"))) {
	snprintf(text,sizeof(text),"EXISTS_NO %s %s\n",to,from);
	write_sock(nl->socket,text);
	return;
	}
fclose(fp);
snprintf(text,sizeof(text),"EXISTS_YES %s %s\n",to,from);
write_sock(nl->socket,text);
}

/*** Remote user doesnt exist ***/
void nl_user_notexist(nl,to,from)
NL_OBJECT nl;
char *to,*from;
{
char filename[FILENAME_LEN],text2[ARR_SIZE];
UR_OBJECT user2;

if ((user2=get_user(from,0))) {
	snprintf(text,sizeof(text),"~OLSYSTEM:~RS User %s does not exist at %s, your mail bounced.\n",to,nl->service);
	write_user(user2,text);
	}
else {
	snprintf(text,sizeof(text),"There is no user named %s at %s, your mail bounced.\n",to,nl->service);
	send_mail(NULL,from,text2,0);
	}
snprintf(filename,sizeof(filename),"%s/OUT_%s_%s@%s",MAILSPOOL,from,to,nl->service);
unlink(filename);
}

/*** Remote users exists, send him some mail ***/
void nl_user_exist(nl,to,from)
NL_OBJECT nl;
char *to,*from;
{
char filename[FILENAME_LEN],line[82],text2[ARR_SIZE];
FILE *fp;
UR_OBJECT user2;

snprintf(filename,sizeof(filename),"%s/OUT_%s_%s@%s",MAILSPOOL,from,to,nl->service);
if (!(fp=fopen(filename,"r"))) {
	if ((user2=get_user(from,0))) {
		snprintf(text,sizeof(text),"~OLSYSTEM:~RS An error occured during mail delivery to %s@%s.\n",to,nl->service);
		write_user(user2,text);
		}
	else {
		snprintf(text,sizeof(text),"An error occured during mail delivery to %s@%s.\n",to,nl->service);
		send_mail(NULL,from,text2,0);
		}
	return;
	}
snprintf(text,sizeof(text),"MAIL %s %s\n",to,from);
write_sock(nl->socket,text);
fgets(line,80,fp);
while(!feof(fp)) {
	write_sock(nl->socket,line);
	fgets(line,80,fp);
	}
fclose(fp);
write_sock(nl->socket,"\nENDMAIL\n");
unlink(filename);
}

/*** Got some mail coming in ***/
void nl_mail(nl,to,from)
NL_OBJECT nl;
char *to,*from;
{
char filename[FILENAME_LEN];

snprintf(text,sizeof(text),"NETLINK: Mail received for %s from %s.\n",to,nl->service);
write_syslog(text,1);
snprintf(filename,sizeof(filename),"%s/IN_%s_%s@%s",MAILSPOOL,to,from,nl->service);
if (!(nl->mailfile=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in nl_mail().\n",filename);
	write_syslog(text,0);
	snprintf(text,sizeof(text),"MAILERROR %s %s\n",to,from);
	write_sock(nl->socket,text);
	return;
	}
sntrncpy(nl->mail_to,to,sizeof(nl->mail_to));
sntrncpy(nl->mail_from,from,sizeof(nl->mail_from));
}

/*** End of mail message being sent from remote site ***/
void nl_endmail(nl)
NL_OBJECT nl;
{
char c,filename[FILENAME_LEN],line[DNL+1],mailfile[FILENAME_LEN];
int i=0,j=0;
FILE *infp,*outfp;

fclose(nl->mailfile);
nl->mailfile=NULL;
snprintf(mailfile,sizeof(mailfile),"%s/IN_%s_%s@%s",MAILSPOOL,nl->mail_to,nl->mail_from,nl->service);
if (!(outfp=fopen(TEMPFILE,"w"))) {
	write_syslog("ERROR: Couldn't open tempfile in netlink_endmail().\n",0);
	snprintf(text,sizeof(text),"MAILERROR %s %s\n",nl->mail_to,nl->mail_from);
	write_sock(nl->socket,text);
	++i;
	}
if (!i) {
	fprintf(outfp,"%d\r",(int)time(0));
	snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,nl->mail_to);
	if (!(infp=fopen(filename,"r"))) ++j;
	}
if (!i && !j) {
	fgets(line,DNL,infp);
	c=getc(infp);
	while(!feof(infp)) {  putc(c,outfp);  c=getc(infp);  }
	fclose(infp);
	}
if (!i) {
	if (!(infp=fopen(mailfile,"r"))) {
		snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to read in netlink_endmail().\n",mailfile);
		write_syslog(text,0);
		snprintf(text,sizeof(text),"MAILERROR %s %s\n",nl->mail_to,nl->mail_from);
		write_sock(nl->socket,text);
		++i;
		}
	}
if (!i) {
	fprintf(outfp,"PT: %d\rFrom: %s@%s, %d/%d/%d at %02d:%02d %s\n",(int)(time(0)),nl->mail_from,nl->service,tmonth+1,tmday,tyear,ttime,tmin,md);
	c=getc(infp);
	while(!feof(infp)) {  putc(c,outfp);  c=getc(infp);  }
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_syslog("ERROR: Couldn't rename tempfile in nl_endmail().\n",0);
		}
	write_user(get_user(nl->mail_to,0),"*** YOU HAVE NEW MAIL ***\n");
	}
nl->mail_to[0]='\0';
nl->mail_from[0]='\0';
unlink(mailfile);
}

/*** An error occured at remote site ***/
void nl_mailerror(nl,to,from)
NL_OBJECT nl;
char *to,*from;
{
UR_OBJECT user2;

if ((user2=get_user(from,0))) {
	snprintf(text,sizeof(text),"~OLSYSTEM:~RS An error occured during mail delivery to %s@%s.\n",to,nl->service);
	write_user(user2,text);
	}
else {
	snprintf(text,sizeof(text),"An error occured during mail delivery to %s@%s.\n",to,nl->service);
	send_mail(NULL,from,text,0);
	}
}

/*** Send statistics of this server to requesting user on remote site ***/
void nl_rstat(nl,to)
NL_OBJECT nl;
char *to;
{
char site[SITE_NAME_LEN];

gethostname(site,SITE_NAME_LEN);
if (nl->ver_major<=3 && nl->ver_minor<2)
	snprintf(text,sizeof(text),"MSG %s\n\n*** Remote statistics ***\n\n",to);
else snprintf(text,sizeof(text),"MSG %s\n\n~BB*** Remote statistics ***\n\n",to);
write_sock(nl->socket,text);
snprintf(text,sizeof(text),"NUTS version         : %s\nHost                 : %s\n",NVERSION,site);
write_sock(nl->socket,text);
snprintf(text,sizeof(text),"Ports (Main/Wiz/Link): %d ,%d, %d\n",port[0],port[1],port[3]);
write_sock(nl->socket,text);
snprintf(text,sizeof(text),"Number of users      : %d\nRemote user maxlevel : %s\n",num_of_users,level_name[rem_user_maxlevel]);
write_sock(nl->socket,text);
snprintf(text,sizeof(text),"Remote user deflevel : %s\n\nEMSG\nPRM %s\n",level_name[rem_user_deflevel],to);
write_sock(nl->socket,text);
}

/*** Shutdown the netlink and pull any remote users back home ***/
void shutdown_netlink(nl)
NL_OBJECT nl;
{
char mailfile[FILENAME_LEN];
UR_OBJECT user2;

if (nl->type==UNCONNECTED) return;
if (nl->mail_to[0]) {
	snprintf(text,sizeof(text),"MAILERROR %s %s\n",nl->mail_to,nl->mail_from);
	write_sock(nl->socket,text);
	fclose(nl->mailfile);
	snprintf(mailfile,sizeof(mailfile),"%s/IN_%s_%s@%s",MAILSPOOL,nl->mail_to,nl->mail_from,nl->service);
	unlink(mailfile);
	nl->mail_to[0]='\0';
	nl->mail_from[0]='\0';
	}
write_sock(nl->socket,"DISCONNECT\n");
close(nl->socket);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->pot_netlink==nl) {  user2->remote_com=-1;  continue;  }
	if (user2->netlink==nl) {
		if (!user2->room) {
			write_user(user2,"~OL~FBYou feel yourself dragged back across the ether...\n");
			user2->room=user2->netlink->connect_room;
			user2->netlink=NULL;
			if (user2->vis) {
				snprintf(text,sizeof(text),"%s %s\n",user2->name,user2->in_phrase);
				write_room_except(user2->room,text,user2,NULL,0,NULL);
				}
			else write_room_except(user2->room,invisenter,user2,NULL,0,NULL);
			look(user2);  prompt(user2);
			snprintf(text,sizeof(text),"NETLINK: %s recovered from %s.\n",user2->name,nl->service);
			write_syslog(text,1);
			continue;
			}
		if (user2->type==REMOTE_TYPE) {
			snprintf(text,sizeof(text),"%s vanishes!\n",user2->name);
			write_room(user2->room,text);
			destruct_user(user2,0);
			num_of_users--;
			}
		}
	}
if (nl->stage==UP)
	snprintf(text,sizeof(text),"NETLINK: Disconnected from %s.\n",nl->service);
else snprintf(text,sizeof(text),"NETLINK: Disconnected from site %s.\n",nl->site);
write_syslog(text,1);
if (nl->type==INCOMING) {
	nl->connect_room->netlink=NULL;
	destruct_netlink(nl);
	return;
	}
nl->type=UNCONNECTED;
nl->stage=DOWN;
nl->warned=0;
}


/************ START OF COMMAND FUNCTIONS AND THEIR SUBSIDS ************/

/*** Deal with user input ***/
void exec_com(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char *comword=NULL;
int i=0,j,k;

com_num=-1;
comword=word[0];
if (user->command_mode) {
	k=strlen(comword)+1;
	for(j=strlen(comword);j;--j) { comword[k]=comword[j]; --k; }
	comword[1]=comword[0];
	while(command[i][0]!='*') {
		comword[0]='.';
		if (!strncmp(command[i],comword,strlen(comword))) {
			com_num=i;  break;
			}
		comword[0]='-';
		if (!strncmp(command[i],comword,strlen(comword))) {
			com_num=i;  break;
			}
		comword[0]='/';
		if (!strncmp(command[i],comword,strlen(comword))) {
			com_num=i;  break;
			}
		++i;
		}
	if ((user->room && (com_num==-1 || command_disabled(user,command[com_num],1))) || ((com_level[com_num]>user->level && !command_granted(user,command[com_num])) || command_disabled(user,command[com_num],0))) {
		write_user(user,"Unknown command.\n"); return;
		}
	}
if (get_alias(user,word[0],0)) {
	sntrncpy(word[0],user->alias2,sizeof(word[0]));
	user->alias1[0]='\0';
	user->alias2[0]='\0';
	}
else if (!strncmp(comword,"]",1) || !strncmp(comword,"[",1)) sntrncpy(word[0],".say",sizeof(word[0]));
else if (!strncmp(comword,";",1) || !strncmp(comword,":",1)) sntrncpy(word[0],".emote",sizeof(word[0]));
else if (!strncmp(comword,"<",1)) sntrncpy(word[0],".pemote",sizeof(word[0]));
else if (!strncmp(comword,"=",1) || !strncmp(comword,"#",1)) sntrncpy(word[0],".semote",sizeof(word[0]));
else if (!strncmp(comword,"+",1)) sntrncpy(word[0],".echo",sizeof(word[0]));
else if (!strncmp(comword,"&",1) || !strncmp(comword,"%",1)) sntrncpy(word[0],".secho",sizeof(word[0]));
else if (!strncmp(comword,",",1) || !strncmp(comword,">",1)) sntrncpy(word[0],".tell",sizeof(word[0]));
else if (!strncmp(comword,"!",1) || !strcmp(comword,".s")) sntrncpy(word[0],".shout",sizeof(word[0]));
else if (!strncmp(comword,"?",1) || !strcmp(comword,".h")) sntrncpy(word[0],".help",sizeof(word[0]));
else if (!strcmp(comword,".g")) sntrncpy(word[0],".go",sizeof(word[0]));
else if (!strcmp(comword,"-h")) sntrncpy(word[0],"-huggle",sizeof(word[0]));
else if (!strcmp(comword,"/move")) sntrncpy(word[0],"/moves",sizeof(word[0]));
else if (!strcmp(comword,".pic")) sntrncpy(word[0],".pictell",sizeof(word[0]));
else if (!strcmp(comword,"/p")) sntrncpy(word[0],"/people",sizeof(word[0]));
else if (!strcmp(comword,".rev")) sntrncpy(word[0],".review",sizeof(word[0]));
else if (!strcmp(comword,".revc")) sntrncpy(word[0],".revclr",sizeof(word[0]));
else if (!strcmp(comword,"/sys")) sntrncpy(word[0],"/system",sizeof(word[0]));
else if (!strcmp(comword,".t")) sntrncpy(word[0],".tell",sizeof(word[0]));
else if (!strcmp(comword,".u")) sntrncpy(word[0],".ustat",sizeof(word[0]));
else if (!strcmp(comword,".w")) sntrncpy(word[0],".who",sizeof(word[0]));
if (!comword[1]) { write_user(user,"Unknown command.\n");  return; }
if (strchr(",;!<:>+[]=#&%",inpstr[0])) sntrncpy(inpstr,inpstr+2,ARR_SIZE);
else inpstr=remove_first(inpstr);
i=0;
while(command[i][0]!='*') {
	if (!strncmp(command[i],comword,strlen(comword)) && !command_disabled(user,command[i],1) && (com_level[i]<=user->level || command_granted(user,command[i]))) {
		com_num=i;  break;
		}
	++i;
	}
if ((user->room && (com_num==-1 || command_disabled(user,command[com_num],1))) || ((com_level[com_num]>user->level && !command_granted(user,command[com_num])) || command_disabled(user,command[com_num],0))) {
	write_user(user,"Unknown command.\n"); return;
	}
if (!user->room) {
	switch(com_num) {
		case HOME:
		case MODE:
		case PROMPT:
		case QUIT:
		case REBOOT:
		case SHUTDOWN: write_user(user,"(Home exec)\n");  break;
		default:
			snprintf(text,sizeof(text),"ACT %s %s %s\n",user->name,word[0],inpstr);
			write_sock(user->netlink->socket,text);
			return;
			}
		}
if (user->type==REMOTE_TYPE) {
	switch(com_num) {
		case ACCREQ:
		case AFK:
		case CALENDAR:
		case CON:
		case DISCON:
		case ENTPRO:
		case FEMOTE:
		case FMAIL:
		case FRIENDS:
		case FTELL:
		case GREET:
		case HOLERS:
		case IGUSER:
		case LOGIM:
		case LOGOM:
		case MACRO:
		case MERLYN:
		case OLOGIM:
		case OLOGOM:
		case PASTE:
		case PROFILE:
		case QUITIN:
		case SETPRO:
		case SUICIDE:
		case TRIGGER:
		case USTAT:
			write_user(user,"Sorry, you cannot use this command here.\n");
			return;
		default: break;
		}
	}
if (user->muzzled) { print_muzzle(user); return; }
switch(com_num) {
	case ACCREQ: account_request(user,inpstr);  break;
	case ACK: ack(user,inpstr);  break;
	case ADDROOM: adddelroom(user,0);  break;
	case ADDTIME: addtime(user);  break;
	case ADDTSIGN: addtsign(user);  break;
	case ADDUSER: add_user(user);  break;
	case AFK: afk(user,inpstr);  break;
	case AFKLOG: afklog(user);  break;
	case ALIAS: pick_alias(user);  break;
	case ALLCLONES: allclones(user);  break;
	case ALLCOLOR: all_color(user);  break;
	case ANNOY: annoy(user,1);  break;
	case ANNOYEM: annoy_user(user,1,remove_first(inpstr));  break;
	case ANVIL: anvil(user);  break;
	case APPEND: append(user);  break;
	case ARREST: arrest(user);  break;
	case ATMOS: toggle_atmos(user);  break;
	case AUTOHIDE: autohide(user);  break;
	case AUTOLOGIN: autologin(user,inpstr);  break;
	case AUTOREAD: auto_read(user);  break;
	case AVALANCHE: avalanche(user,1);  break;
	case AWHO: awho(user);  break;
	case BAKE: bake(user);  break;
	case BAN: ban(user);  break;
	case BCAST: bcast(user,inpstr);  break;
	case BEAT: beat(user);  break;
	case BECHO: backecho(user,inpstr);  break;
	case BEEPLINE: beepline(user);  break;
	case BEEPLOGIN: beeplogin(user);  break;
	case BEEPTELL: beeptell(user,remove_first(inpstr));  break;
	case BEMOTE: backemote(user,inpstr);  break;
	case BIG: big(user,1);  break;
	case BLAST: blast(user);  break;
	case BOARD: monopoly(user,9);  break;
	case BOOTEM: bootem(user);  break;
	case BOUNCE: bounce(user,1);  break;
	case BRB: brb(user);  break;
	case BSAY: backsay(user,1,inpstr);  break;
	case BSECHO: backsecho(user,inpstr);  break;
	case BSEMOTE: backsemote(user,inpstr);  break;
	case BSHOUT: backshout(user,inpstr);  break;
	case BTELL: backtell(user,remove_first(inpstr));  break;
	case BUY: monopoly(user,2);  break;
	case CALC: calc(user);  break;
	case CALENDAR: calendar(user);  break;
	case CHANNEL: channel(user,inpstr);  break;
	case CHARECHO: charecho(user);  break;
	case CHEMOTE: chemote(user,inpstr);  break;
	case CLEARLINE: clearline(user);  break;
	case CLHEAR: clone_hear(user);  break;
	case CLREV: clone_rev(user);  break;
	case CLREVCLR: clone_revclr(user);  break;
	case CLS: cls(user);  break;
	case CLSAY: clone_say(user,remove_first(inpstr));  break;
	case COLORIZE: colorize(user,1);  break;
	case COMMIT: commit(user,1);  break;
	case COMPLAIN: complain(user,inpstr,0);  break;
	case CON: connect_netlink(user);  break;
	case CONFUSE: confuse(user);  break;
	case CORP: corporal(user);  break;
	case COUNT: recount(user);  break;
	case CREATE: create_clone(user);  break;
	case CRON: cron(user,remove_first(inpstr));  break;
	case DARK: darkness(user);  break;
	case DCHALLENGE: dchallenge(user);  break;
	case DCHANNEL: dchannel(user);  break;
	case DCOMPLAIN: dcomplain(user);  break;
	case DECOLORIZE: colorize(user,0);  break;
	case DELIVER: deliver(user);  break;
	case DELROOM: adddelroom(user,1);  break;
	case DEMOTE: demote(user);  break;
	case DESC: desc(user,inpstr);  break;
	case DESTROY: destroy_clone(user);  break;
	case DESTROYALL: destroy_allclones(user);  break;
	case DESTRUCT: destroy_user(user);  break;
	case DIRTCLOD: dirtclod(user);  break;
	case DISCON: disconnect_netlink(user);  break;
	case DMAIL: dmail(user);  break;
	case DOH: doh(user);  break;
	case DONTIDLEME: dontidle(user);  break;
	case DRAG: drag(user,1);  break;
	case DSHOUTS: dshouts(user);  break;
	case DSMAIL: dsentmail(user);  break;
	case DSUGGEST: dsuggest(user);  break;
	case DWIZ: dwiz(user);  break;
	case ECHOIT: echo(user,inpstr);   break;
	case EEK: eek(user);  break;
	case EH: eh(user);  break;
	case EIGHT: macro(user,8,inpstr);  break;
	case EMOTE: emote(user,inpstr);  break;
	case ENTPRO: enter_profile(user,0);  break;
	case EX: ex(user);  break;
	case EXAMINE: examine(user);  break;
	case FAKELOGOFF: fake_logoff(user);  break;
	case FEMOTE: femote(user,inpstr);  break;
	case FIVE: macro(user,5,inpstr);  break;
	case FIX: change_room_fix(user,1);  break;
	case FLOWERS: flowers(user);  break;
	case FMAIL: fmail(user,inpstr,0);  break;
	case FORTUNE: fortune(user);  break;
	case FORWARD: forward(user);  break;
	case FOUR: macro(user,4,inpstr);  break;
	case FPC: fpc(user);  break;
	case FREEZE: freeze(user);  break;
	case FREEZEALL: freezeall(user);  break;
	case FRIENDS: friends_list(user);  break;
	case FRIENDSTIME: annoyemall(user,inpstr);  break;
	case FROM: mail_from(user,0);  break;
	case FTELL: frtell(user,inpstr);  break;
	case GARBLE: garbletime(user);  break;
	case GO: go(user);  break;
	case GOINGDOWN: going_down(user);  break;
	case GOSSAMER: gossamertime(user);  break;
	case GOSSAMEREM: toggle_gossamer(user);  break;
	case GRANT: grant(user);  break;
	case GRANTED: granted(user);  break;
	case GREET: greet(user,inpstr,0,1);  break;
	case GUESS: hangman(user,1,0);  break;
	case HANGMAN: hangman(user,0,1);  break;
	case HEHEHE: banhehehe(user);  break;
	case HELP: help(user);  break;
	case HIDE: hide(user,1);  break;
	case HIFIVE: hifive(user);  break;
	case HMM: hmm(user);  break;
	case HOLERS: holers(user);  break;
	case HOME: home(user);  break;
	case HOMEROOM: homeroom(user);  break;
	case HOMEWOOM: homewoom(user);  break;
	case HOUR: banhour(user);  break;
	case HOWL: howl(user);  break;
	case HUGGLE: huggle(user);  break;
	case IDEA: idea(user);  break;
	case IDLE: idleuser(user);  break;
	case IGNORE: tignore(user);  break;
	case IGUSER: iguser(user);  break;
	case IHUNT: hunt(user,0);  break;
	case INCOMPETENT: incompetent(user);  break;
	case INNOCENT: innocent(user);  break;
	case INPHRASE: set_iophrase(user,inpstr);  break;
	case INVIS: visibility(user,0);  break;
	case INVITE: invite(user);   break;
	case JEEP: jeep(user);  break;
	case JOIN: join(user);  break;
	case KILL: kill_user(user);  break;
	case KILLALL: kill_allusers(user);  break;
	case KISS: kiss(user);  break;
	case LAST: last_users(user,0);  break;
	case LASTON: laston(user);  break;
	case LBAN: listban(user);  break;
	case LETMEIN: letmein(user);  break;
	case LEVEL: level(user);  break;
	case LILMURDER: banwillkill(user);  break;
	case LISTEN: tlisten(user);  break;
	case LOAD: load_user(user);  break;
	case LOADEM: load_lilmouse(user);  break;
	case LOCK: lock_user(user);  break;
	case LOGGING: logging(user);  break;
	case LOGIM: enter_lim(user,0);  break;
	case LOGINPLACE: login_place(user);  break;
	case LOGOM: enter_lom(user,0);  break;
	case LOL: lol(user);  break;
	case LOOK: look(user);  break;
	case MACRO: macro(user,0,remove_first(inpstr));  break;
	case MAP: more(user,MAPFILE,0);  break;
	case MASSEMOTE: mass(user,1);  break;
	case MASSMAIL: mass(user,0);  break;
	case MASSTELL: mass(user,2);  break;
	case MERLYN: merlyntime(user);  break;
	case MHUNT: hunt(user,1);  break;
	case MINLOGIN: minlogin(user);  break;
	case MIRROR: mirror(user);  break;
	case OMIRROR: mirroro(user);  break;
	case MODE: toggle_mode(user);  break;
	case MONOPOLY: monopoly(user,0);  break;
	case MORPH: morph(user);  break;
	case MORTGAGE: monopoly(user,4);  break;
	case MOTD: motdtime(user,inpstr);  break;
	case MOVE: move(user);  break;
	case MOVEALL: moveall(user);  break;
	case MUHAHA: muhaha(user);  break;
	case MUMBLE: mumble(user);  break;
	case MUZZLE: muzzle(user);  break;
	case MYCLONES: myclones(user);  break;
	case NETDATA: netdata(user);  break;
	case NETSTAT: netstat(user);  break;
	case NEWS: news(user);  break;
	case NINE: macro(user,9,inpstr);  break;
	case NOD: nod(user);  break;
	case NODIFFLOGIN: bandifflogins(user);  break;
	case NOGAMES: bangames(user);  break;
	case NOGREETS: bangreets(user);  break;
	case NOHUNTING: banhunting(user);  break;
	case NOLOGIN: banlogins(user);  break;
	case NOPICTELLS: banpictells(user);  break;
	case NOPROMOS: no_promos(user);  break;
	case NOQUIT: banquits(user);  break;
	case NOSHOUTS: banshouts(user);  break;
	case NOSMAIL: no_smail(user);  break;
	case NOSMOKES: bansmoking(user);  break;
	case NOSOCIALS: bansocials(user);  break;
	case NOSUICIDES: bansuicides(user);  break;
	case NUMBER: number(user);  break;
	case OAFK: oafk(user,remove_first(inpstr));  break;
	case OBEEPLINE: toggle_beep(user);  break;
	case OBEEPLOGIN: obeeplogin(user);  break;
	case OCHARECHO: ocharecho(user);  break;
	case OINPHR: set_oiophrase(user,remove_first(inpstr));  break;
	case OLOGIM: enter_olim(user,0);  break;
	case OLOGOM: enter_olom(user,0);  break;
	case OMODE: toggle_omode(user);  break;
	case ONE: macro(user,1,inpstr);  break;
	case OOUTPHR: set_oiophrase(user,remove_first(inpstr));  break;
	case OPASSWD: change_other_pass(user);  break;
	case OSCOMMAND: scommand_omode(user);  break;
	case OSET: oset(user,remove_first(inpstr));  break;
	case OUNAFK: ounafk(user,inpstr);  break;
	case OUTPHRASE: set_iophrase(user,inpstr);  break;
	case PANIC: panic(user);  break;
	case PASSWD: change_pass(user);  break;
	case PASTE: paste(user,0);  break;
	case PEMOTE: pemote(user,remove_first(inpstr));  break;
	case PEOPLE: who(user,1);  break;
	case PICKCOL: pick_col(user);  break;
	case PICKCOLS: pick_ocol(user);  break;
	case PICTELL: pictell(user);  break;
	case PINFO: monopoly(user,8);  break;
	case PING: ping(user);  break;
	case POKE: poke(user);  break;
	case PONG: pong(user);  break;
	case PRIVCOM: set_room_access(user);  break;
	case PROFILE: profile(user,remove_first(inpstr));  break;
	case PROFILES: profiles(user,remove_first(remove_first(inpstr)));  break;
	case PROMOTE: promote(user);  break;
	case PROMPT: toggle_prompt(user);  break;
	case PROPERTY: monopoly(user,6);  break;
	case PUBCOM: set_room_access(user);  break;
	case PUKE: puke(user);  break;
	case PUT: yahtzee(user,2);  break;
	case QUIET: quiet_user(user);  break;
	case QUIT:
		if (!ban_quitting && !user->frozen) disconnect_user(user);
		else {
			write_user(user,"Why?\n");
			snprintf(text,sizeof(text),"%s tried to quit but failed miserably.\n",user->name);
			write_syslog(text,1);
			}
		break;
	case QUITIN:
		if (!ban_quitting && !user->frozen) quitin(user);
		else {
			write_user(user,"eh?\n");
			snprintf(text,sizeof(text),"%s tried to quit but failed miserably.\n",user->name);
			write_syslog(text,1);
			}
		break;
	case QUIZ: quiz(user);  break;
	case RANKS: ranks(user);  break;
	case RCOMPLAIN: rcomplain(user);  break;
	case READ: read_board(user);  break;
	case REBOOT: write_user(user,"\07*** WARNING - This will reboot the talker! ***\nAre you sure about this (y/n)? "); user->misc_op=10;  break;
	case RECAP: recap(user);  break;
	case REDESC: redesc(user);  break;
	case RENAME: rename_user(user);  break;
	case REROLL: yahtzee(user,1);  break;
	case RESETQUIZ: reset_quiz(user);  break;
	case RESPAWN: respawn(user);  break;
	case ORESPAWN: respawno(user);  break;
	case REVCHANNEL: revchannel(user);  break;
	case REVCLR: clear_conv(user->room); write_user(user,"Buffer cleared.\n");  break;
	case REVCLRALL: clear_allconv(user);  break;
	case REVIEW: review(user);  break;
	case REVOKE: revokeem(user);  break;
	case REVSHOUT: revshout(user);  break;
	case REVTELL: revtell(user);  break;
	case REVWIZ: revwiz(user);  break;
	case RLOOK: rlook(user);  break;
	case RMAIL: rmail(user);  break;
	case RMSN: rooms(user,0);  break;
	case RMST: rooms(user,1);  break;
	case ROFL: rofl(user);  break;
	case ROLL: monopoly(user,1);  break;
	case ROLLS: rolls(user);  break;
	case ROOMADD: add_room(user);  break;
	case ROOMDEL: del_room(user);  break;
	case ROOMDESC: room_desc(user,inpstr,0);  break;
	case RSTAT: remote_stat(user);  break;
	case RSUGGEST: rsuggest(user);  break;
	case RULES: rules(user);  break;
	case SAMESITE: samesite(user);  break;
	case SAY:
		if (word_count<2) {
			write_user(user,"Say what?\n");
			return;
			}
		say(user,inpstr);
		break;
	case SCLOSEALL: close_allsock(user,0);  break;
	case SCOMMAND: scommand_mode(user);  break;
	case SCREAM: scream(user);  break;
	case SEARCH: search_boards(user);  break;
	case SEARCHSITE: searchsite(user);  break;
	case SECHO: secho(user,inpstr);   break;
	case SELFDESTRUCT: selfdestructem(user);  break;
	case SELL: monopoly(user,3);  break;
	case SEMOTE: semote(user,inpstr);  break;
	case SENTMAIL: sent_mail(user);  break;
	case SET: set(user,remove_first(inpstr));  break;
	case SETDESC: set_desc(user,remove_first(inpstr));  break;
	case SETPRO: set_profile(user,0);  break;
	case SEVEN: macro(user,7,inpstr);  break;
	case SFROM: mail_sfrom(user,0);  break;
	case SHAKE: shake(user);  break;
	case SHOUT: shout(user,inpstr);  break;
	case SHOWHIDDEN: show_hidden(user,0);  break;
	case SHRUG: shrug(user);  break;
	case SHUNT: hunt(user,2);  break;
	case SHUTDOWN: write_user(user,"Are you sure about this (y/n)? "); user->misc_op=1;  break;
	case SIGH: sigh(user);  break;
	case SING: sing(user,inpstr);  break;
	case SITE: siteuser(user);  break;
	case SIX: macro(user,6,inpstr);  break;
	case SLEDGE: sledge(user);  break;
	case SLEEP: sleepuser(user);  break;
	case SMAIL: smail(user,inpstr,0);  break;
	case SMAILALL: smailall(user,inpstr,0);  break;
	case SMBAN: bansmailing(user);  break;
	case SMOKE: smoke(user);  break;
	case SOCIALS: socials(user);  break;
	case SPECIAL: makeem_special(user,0);  break;
	case SPECIALSITE: specialsite(user);  break;
	case SPECIALTOO: makeem_special(user,1);  break;
	case SPELL: spell(user);  break;
	case STALK: stalk(user,1);  break;
	case STATUS: status(user);  break;
	case STAYTHERE: stayput(user);  break;
	case STHINK: sthink(user,inpstr);  break;
	case STOPUSER: stopuser(user);  break;
	case STOP_COM: stop_command(user);  break;
	case SU: super_user(user,0);  break;
	case SUBTIME: subtime(user);  break;
	case SUBTSIGN: subtsign(user);  break;
	case SUGGEST: suggest(user,inpstr,0);  break;
	case SUICIDE: suicide(user);  break;
	case SUPERCRON: supercron(user,remove_first(remove_first(inpstr)));  break;
	case SWAT: swat(user);  break;
	case SWBAN: swban(user);  break;
	case SWHO: users(user);  break;
	case SWITCH: clone_switch(user);  break;
	case SYSBANS: system_bans(user);  break;
	case SYSMAIL: sysmail(user);  break;
	case SYSSTAT: sys_stats(user);  break;
	case SYSTEM: system_details(user);  break;
	case TAG: tag(user);  break;
	case TALK: talk_to_me(user);  break;
	case TAP: tapfoot(user);  break;
	case TELL: tell(user,remove_first(inpstr));   break;
	case TEN: macro(user,10,inpstr);  break;
	case THANK: thank(user);  break;
	case THINK: think(user,inpstr);  break;
	case THREE: macro(user,3,inpstr);  break;
	case THROW: throw(user);  break;
	case THWAP: thwap(user);  break;
	case TICKLE: tickle(user);  break;
	case TICTACTOE: ttt(user,0);  break;
	case TIMEDIFF: time_diff(user);  break;
	case TINKLE: tinkle(user);  break;
	case TOGGLE_OIGNORE: otignore(user);  break;
	case TOGGLE_OLISTEN: otlisten(user);  break;
	case TOPIC: set_topic(user,inpstr);  break;
	case TOPICALL: topic_allboard(user,inpstr);  break;
	case TORNADO: tornado(user);  break;
	case TRADE: monopoly(user,7);  break;
	case TRIGGER: trigger(user,0);  break;
	case TWO: macro(user,2,inpstr);  break;
	case TXT: txt(user);  break;
	case UNANNOY: annoy(user,0);  break;
	case UNANNOYEM: annoy_user(user,0,remove_first(inpstr));  break;
	case UNARREST: unarrest(user);  break;
	case UNBAKE: unbake(user);  break;
	case UNBAN: unban(user);  break;
	case UNBIG: big(user,0);  break;
	case UNBOUNCE: bounce(user,0);  break;
	case UNCOMMIT: commit(user,0);  break;
	case UNDARK: undarkness(user);  break;
	case UNDRAG: drag(user,0);  break;
	case UNFIX: change_room_fix(user,0);  break;
	case UNFREEZE: unfreeze(user);  break;
	case UNFREEZEALL: unfreezeall(user);  break;
	case UNHIDE: hide(user,0);  break;
	case UNLOCK: unlock_user(user);  break;
	case UNMORTGAGE: monopoly(user,5);  break;
	case UNMUZZLE: unmuzzle(user);  break;
	case UNRESPAWN: unrespawn(user);  break;
	case UNSTALK: stalk(user,0);  break;
	case UNWOOHOO: woohoo(user,0);  break;
	case USTAT: ustatus(user);  break;
	case VACATION: enter_vacation(user,0);  break;
	case VANITY: vanity(user,0,0);  break;
	case VER:
		snprintf(text,sizeof(text),"HOLE version %s ---> NUTS version %s\n",HVERSION,NVERSION);
		write_user(user,text);
		break;
	case VIEWLOG: viewlog(user);  break;
	case VIEWSITE: viewsite(user);  break;
	case VIOLIN: violin(user);  break;
	case VIS: visibility(user,1);  break;
	case WAKE: wake(user);  break;
	case WARN: warn_user(user,remove_first(inpstr));  break;
	case WAVE: wave(user);  break;
	case WELCOME: welcome(user);  break;
	case WHISTLE: whistle(user);  break;
	case WHO: who(user,0);  break;
	case WHOBTG: whobtg(user,0);  break;
	case WHOIS: whois(user);  break;
	case WHOLOGIN: banwhologins(user);  break;
	case WHYME: whyme(user);  break;
	case WINATTACK: winattack(user);  break;
	case WIPE: wipe_board(user);  break;
	case WIPEALL: wipe_allboard(user);  break;
	case WIZEMOTE: wizemote(user,inpstr);  break;
	case WIZHELP: wizhelp(user);  break;
	case WIZSHOUT: wizshout(user,inpstr);  break;
	case WIZWHO: wizwho(user);  break;
	case WLOOK: wlook(user);  break;
	case WOOHOO: woohoo(user,1);  break;
	case WRITE: write_board(user,inpstr,0);  break;
	case WRITEALL: write_allboard(user,inpstr,0);  break;
	case WRITESOCK: writetosock(user,remove_first(inpstr));  break;
	case YAHTZEE: yahtzee(user,0);  break;
	case YIPPEE: yippee(user);  break;
	default: write_user(user,"Command not found.\n");
	}
}

/*** Display details of room ***/
void look(user)
UR_OBJECT user;
{
char afker[6],temp[80];
int exits=0,i,usercnt=0;
RM_OBJECT room=user->room;
UR_OBJECT user2;

if (!strcmp(room->name,"Dark_room")) return;
write_user(user,PTSTR);
if (room->access==HIDDEN) snprintf(text,sizeof(text),"~OL~FT*?*\n");
else snprintf(text,sizeof(text),"~OL~FT%s\n",room->name);
sntrncpy(text,center(text,80),sizeof(text));
write_user(user,text);
snprintf(text,sizeof(text),"%s\n",PTSTR);
write_user(user,text);
write_user(user,room->desc);
sntrncpy(text,"\n~OL~FYYou can see tunnels leading to ~RS",sizeof(text));
for(i=0;i<MAX_LINKS;++i) {
	if (!room->link[i]) break;
	if (room->link[i]->access==HIDDEN || room->hid) continue;
	if (!exits) snprintf(temp,sizeof(temp),"%s",room->link[i]->name);
	else snprintf(temp,sizeof(temp)," & %s",room->link[i]->name);
	strncat(text,temp,sizeof(text));
	++exits;
	}
if (room->netlink && room->netlink->stage==2) {
	snprintf(temp,sizeof(temp),"  %s*",room->netlink->service);
	strncat(text,temp,sizeof(text));
	}
else if (!exits) sntrncpy(text,"nowhere.",sizeof(text));
strncat(text,".\n\n",sizeof(text));
write_user(user,text);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->room!=room || user2==user || user2->hid || (!user2->vis && user2->level>user->level)) continue;
	if (!usercnt++) write_user(user,"~OL~FRYou can see:\n");
	afker[0]='\0';
	if (user2->afk) sntrncpy(afker,"(AFK)",sizeof(afker));
	if (!user2->vis) snprintf(text,sizeof(text),"     *%s %s ~OL~FM%s\n",user2->morphed,user2->desc,afker);
	else snprintf(text,sizeof(text),"      %s %s ~OL~FM%s\n",user2->morphed,user2->desc,afker);
	write_user(user,text);
	}
if (!usercnt) write_user(user,"~OL~FGThere doesn't seem to be anyone around.\n");
sntrncpy(text,"\nAccess is ",sizeof(text));
switch(room->access) {
	case PUBLIC: strncat(text,"set to ~FGPUBLIC~RS",sizeof(text));  break;
	case PRIVATE: strncat(text,"set to ~FRPRIVATE~RS",sizeof(text));  break;
	case FIXED_PUBLIC: strncat(text,"~FRfixed~RS to ~FGPUBLIC~RS",sizeof(text));  break;
	case FIXED_PRIVATE: strncat(text,"~FRfixed~RS to ~FRPRIVATE~RS",sizeof(text));  break;
	case HIDDEN: strncat(text,"~FRfixed~RS to ~FBHIDDEN~RS",sizeof(text));
	}
if (room->mesg_cnt==1) snprintf(temp,sizeof(temp)," and there is ~OL~FM%d~RS message on the board.\n",room->mesg_cnt);
else snprintf(temp,sizeof(temp)," and there are ~OL~FM%d~RS messages on the board.\n",room->mesg_cnt);
strncat(text,temp,sizeof(text));
sntrncpy(text,center(text,80),sizeof(text));
write_user(user,text);
if (room->topic[0]) {
	snprintf(text,sizeof(text),"~OL~FB%s\n",room->topic);
	sntrncpy(text,center(text,80),sizeof(text));
	write_user(user,text);
	return;
	}
write_user(user,"No topic has been set yet.\n");
}

/*** Display details of another room ***/
void wlook(user)
UR_OBJECT user;
{
char afker[6],temp[80];
int exits=0,i,usercnt=0;
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
if (!strcmp(room->name,"Dark_room")) return;
write_user(user,PTSTR);
if (room->access==HIDDEN) snprintf(text,sizeof(text),"~OL~FT*?*\n");
else snprintf(text,sizeof(text),"~OL~FT%s\n",room->name);
sntrncpy(text,center(text,80),sizeof(text));
write_user(user,text);
snprintf(text,sizeof(text),"%s\n",PTSTR);
write_user(user,text);
write_user(user,room->desc);
sntrncpy(text,"\n~OL~FYYou can see tunnels leading to ~RS",sizeof(text));
for(i=0;i<MAX_LINKS;++i) {
	if (!room->link[i]) break;
	if (room->link[i]->access==HIDDEN || room->hid) continue;
	if (!exits) snprintf(temp,sizeof(temp),"%s",room->link[i]->name);
	else snprintf(temp,sizeof(temp)," & %s",room->link[i]->name);
	strncat(text,temp,sizeof(text));
	++exits;
	}
if (room->netlink && room->netlink->stage==2) {
	snprintf(temp,sizeof(temp),"  %s*",room->netlink->service);
	strncat(text,temp,sizeof(text));
	}
else if (!exits) sntrncpy(text,"nowhere.",sizeof(text));
strncat(text,".\n\n",sizeof(text));
write_user(user,text);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->room!=room || user2==user || user2->hid || (!user2->vis && user2->level>user->level)) continue;
	if (!usercnt++) write_user(user,"~OL~FRYou can see:\n");
	afker[0]='\0';
	if (user2->afk) sntrncpy(afker,"(AFK)",sizeof(afker));
	if (!user2->vis) snprintf(text,sizeof(text),"     *%s %s ~OL~FM%s\n",user2->morphed,user2->desc,afker);
	else snprintf(text,sizeof(text),"      %s %s ~OL~FM%s\n",user2->morphed,user2->desc,afker);
	write_user(user,text);
	}
if (!usercnt) write_user(user,"~OL~FGThere doesn't seem to be anyone around.\n");
sntrncpy(text,"\nAccess is ",sizeof(text));
switch(room->access) {
	case PUBLIC: strncat(text,"set to ~FGPUBLIC~RS",sizeof(text));  break;
	case PRIVATE: strncat(text,"set to ~FRPRIVATE~RS",sizeof(text));  break;
	case FIXED_PUBLIC: strncat(text,"~FRfixed~RS to ~FGPUBLIC~RS",sizeof(text));  break;
	case FIXED_PRIVATE: strncat(text,"~FRfixed~RS to ~FRPRIVATE~RS",sizeof(text));  break;
	case HIDDEN: strncat(text,"~FRfixed~RS to ~FBHIDDEN~RS",sizeof(text));
	}
if (room->mesg_cnt==1) snprintf(temp,sizeof(temp)," and there is ~OL~FM%d~RS message on the board.\n",room->mesg_cnt);
else snprintf(temp,sizeof(temp)," and there are ~OL~FM%d~RS messages on the board.\n",room->mesg_cnt);
strncat(text,temp,sizeof(text));
sntrncpy(text,center(text,80),sizeof(text));
write_user(user,text);
if (room->topic[0]) {
	snprintf(text,sizeof(text),"~OL~FB%s\n",room->topic);
	sntrncpy(text,center(text,80),sizeof(text));
	write_user(user,text);
	return;
	}
write_user(user,"No topic has been set yet.\n");
}

/*** Switch between command and speech mode ***/
void toggle_mode(user)
UR_OBJECT user;
{
if (user->command_mode) {
	user->command_mode=0;
	write_user(user,"Now in SPEECH mode.\n");
	return;
	}
user->command_mode=1;
write_user(user,"Now in COMMAND mode.\n");
}

/*** Toggle other's user's command and speech mode ***/
void toggle_omode(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Toggle whose command and speech mode?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Try just %s please\n",command[com_num]);
		else snprintf(text,sizeof(text),"Try just %s please.\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to toggle your command/speech mode!\n",user->name);
		write_user(user2,text);
		return;
		}
	if (user2->command_mode) {
		user2->command_mode=0;
		snprintf(text,sizeof(text),"%s now in SPEECH mode.\n",user2->name);
		write_user(user,text);
		write_user(user2,"\nNow in SPEECH mode.\n");
		return;
		}
	user2->command_mode=1;
	snprintf(text,sizeof(text),"%s now in COMMAND mode.\n",user2->name);
	write_user(user,text);
	write_user(user2,"Now in COMMAND mode.\n~OLCOM> ");
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in toggle_omode().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to toggle your command/speech mode!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	if (user2->command_mode) {
		user2->command_mode=0;
		snprintf(text,sizeof(text),"%s now in SPEECH mode.\n",user2->name);
		write_user(user,text);
		save_user_details(user2,0);
		destruct_user(user2,0);
		return;
		}
	user2->command_mode=1;
	snprintf(text,sizeof(text),"%s now in COMMAND mode.\n",user2->name);
	write_user(user,text);
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Turn idling on and off ***/
void dontidle(user)
UR_OBJECT user;
{
if (user->noidle) {
	user->noidle=0;
	write_user(user,"Will now idle.\n");
	return;
	}
user->noidle=1;
write_user(user,"Will no longer idle.\n");
}

/*** Switch between quiet and verbose mode ***/
void quiet_user(user)
UR_OBJECT user;
{
if (user->quiet) {
	user->quiet=0;
	write_user(user,"Now in VERBOSE mode.\n");
	return;
	}
user->quiet=1;
write_user(user,"Now in QUIET mode.\n");
}

/*** Switch between super command and speech mode ***/
void scommand_mode(user)
UR_OBJECT user;
{
int i;

if (user->scommand_mode) {
	user->scommand_mode=0;
	write_user(user,"No longer in super command mode.\n");
	reset_scom(user,1);
	return;
	}
user->scommand_mode=1;
write_user(user,"Now in super command mode.\n");
for(i=0;i<MAX_WORDS;++i) user->word[i][0]='\0';
user->wordcnt=0;
print_scom(user,0);
}

/*** Toggle other's user's super command mode ***/
void scommand_omode(user)
UR_OBJECT user;
{
int i;
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Toggle whose super command mode?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Try just %s please\n",command[com_num]);
		else snprintf(text,sizeof(text),"Try just %s please.\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to toggle your super command mode!\n",user->name);
		write_user(user2,text);
		return;
		}
	if (user2->scommand_mode) {
		user2->scommand_mode=0;
		snprintf(text,sizeof(text),"%s no longer in super command mode.\n",user2->name);
		write_user(user,text);
		write_user(user2,"\nNo longer in super command mode.\n");
		reset_scom(user2,1);
		return;
		}
	user2->scommand_mode=1;
	snprintf(text,sizeof(text),"%s now in super command mode.\n",user2->name);
	write_user(user,text);
	write_user(user2,"Now in super command mode.\n");
	for(i=0;i<MAX_WORDS;++i) user->word[i][0]='\0';
	user2->wordcnt=0;
	print_scom(user2,0);
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in scommand_omode().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to toggle your super command mode!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	if (user2->scommand_mode) {
		user2->scommand_mode=0;
		snprintf(text,sizeof(text),"%s no longer in super command mode.\n",user2->name);
		write_user(user,text);
		save_user_details(user2,0);
		destruct_user(user2,0);
		return;
		}
	user2->scommand_mode=1;
	snprintf(text,sizeof(text),"%s now in super command mode.\n",user2->name);
	write_user(user,text);
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** All purpose merlyn function ***/
void merlyntime(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2 && !strcmp(user->name,user->merlyn)) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!strcmp(user->name,user->merlyn)) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in merlyntime().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user_ignored(user2,user)) {
		snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
		write_user(user,text);
		destruct_user(user2,0);
		return;
		}
	sntrncpy(user->merlyn,user2->name,sizeof(user->merlyn));
	destruct_user(user2,0);
	write_user(user,"Merlyn feature turned ON. Yee haw.\n");
	}
else {
	sntrncpy(user->merlyn,user->name,sizeof(user->merlyn));
	write_user(user,"Merlyn feature turned OFF.\n");
	}
}

/*** Reset quiz thingy ***/
void reset_quiz(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Reset whose quiz stats?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2->level>=user->level && user2!=user) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to reset your quiz stats!\n",user->name);
		write_user(user2,text);
		return;
		}
	user2->quizcnt=3;
	user2->question=1;
	snprintf(text,sizeof(text),"%s's quiz stats reset.\n",user2->name);
	write_user(user,text);
	write_user(user2,"Quiz stats reset.\n");
	snprintf(text,sizeof(text),"%s reset %s's quiz stats.\n",user->name,user2->name);
	write_syslog(text,1);
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in reset_quiz().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to reset your quiz stats!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	user2->quizcnt=3;
	user2->question=1;
	snprintf(text,sizeof(text),"%s's quiz stats reset.\n",user2->name);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s reset %s's quiz stats.\n",user->name,user2->name);
	write_syslog(text,1);
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Toggle other's user's beepline stat ***/
void toggle_beep(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Toggle whose beeplines?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Try just %s please\n",command[com_num]);
		else snprintf(text,sizeof(text),"Try just %s please.\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to toggle your beeplines!\n",user->name);
		write_user(user2,text);
		return;
		}
	if (user2->beepline) {
		snprintf(text,sizeof(text),"%s's beeplines turned off.\n",user2->name);
		write_user(user,text);
		user2->beepline=0;
		write_user(user2,"\nNo longer listening to beeps on every line.\n");
		return;
		}
	snprintf(text,sizeof(text),"%s's beeplines turned on.\n",user2->name);
	write_user(user,text);
	user2->beepline=1;
	write_user(user2,"Now listening to beeps on every line.\n");
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in toggle_beep().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to toggle your beeplines!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	if (user2->beepline) {
		user2->beepline=0;
		snprintf(text,sizeof(text),"%s's beeplines turned off.\n",user2->name);
		write_user(user,text);
		save_user_details(user2,0);
		destruct_user(user2,0);
		return;
		}
	user2->beepline=1;
	snprintf(text,sizeof(text),"%s's beeplines turned on.\n",user2->name);
	write_user(user,text);
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Listen ***/
void tlisten(user)
UR_OBJECT user;
{
if (word_count==1) {
	user->listen_store=user->listen;
	user->listen=0;
	snprintf(text,sizeof(text),"%s is no longer listening.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	redrawil(user);
	user->misc_op=28;
	user->il=0;
	}
else toggle_listen(user);
}

/*** Ignore ***/
void tignore(user)
UR_OBJECT user;
{
if (word_count==1) {
	user->listen_store=user->listen;
	user->listen=0;
	snprintf(text,sizeof(text),"%s is no longer listening.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	redrawil(user);
	user->misc_op=28;
	user->il=1;
	}
else toggle_ignore(user);
}

/*** Redraw ignore and listen ***/
void redrawil(user)
UR_OBJECT user;
{
snprintf(text,sizeof(text),"           ~BB~OL-_-~-+-_-~-+-_-~-+-_-~-+--_-~-+-_-~-+-_-~-+-_-~-+-_--~-+-\n");
strncat(text,"           ~BB~OL[]~RS        ~OL[~FR1~FW]~FR All~FW                    [~FY2~FW]~FY Anvil~RS         ~BB~OL[]\n",sizeof(text));
strncat(text,"           ~BB~OL[]~RS        ~OL[~FB3~FW]~FB Channel~FW                [~FM4~FW]~FM Fmail~RS         ~BB~OL[]\n",sizeof(text));
strncat(text,"           ~BB~OL[]~RS        ~OL[~FG5~FW]~FG Greets~FW                 [~FY6~FW]~FY Hunts~RS         ~BB~OL[]\n",sizeof(text));
strncat(text,"           ~BB~OL[]~RS        ~OL[~FT7~FW]~FT Joins~FW                  [~FG8~FW]~FG Pictells~RS      ~BB~OL[]\n",sizeof(text));
strncat(text,"           ~BB~OL[]~RS        ~OL[~FM9~FW]~FM Shouts~FW                [~FR10~FW]~FR Signons~RS       ~BB~OL[]\n",sizeof(text));
strncat(text,"           ~BB~OL[]~RS       ~OL[~FY11~FW]~FY Smail~FW                 [~FB12~FW]~FB Smoke~RS         ~BB~OL[]\n",sizeof(text));
strncat(text,"           ~BB~OL[]~RS       ~OL[~FR13~FW]~FR Socials~FW               [~FT14~FW]~FT Tells~RS         ~BB~OL[]\n",sizeof(text));
strncat(text,"           ~BB~OL-_-~-+-_-~-+-_-~-+-_-~-+--_-~-+-_-~-+-_-~-+-_-~-+-_--~-+-\n\n",sizeof(text));
strncat(text,"~OLSelect (0-14) 0 to quit => ",sizeof(text));
write_user(user,text);
}

/*** Yepperoni ***/
void ti_user(user)
UR_OBJECT user;
{
switch(atoi(word[0])) {
	case 1:
		if (!user->listen_store) {
			write_user(user,"You are already being anti-social!\n");
			redrawil(user);
			return;
			}
		user->turniton=1;
		break;
	case 2:
		if (!user->anvil) {
			write_user(user,"You are already ignoring falling anvils!\n");
			redrawil(user);
			return;
			}
		user->anvil=0;
		write_user(user,"You put on a heavy duty construction hat to prevent cranial damage\nfrom falling anvils.\n");
		snprintf(text,sizeof(text),"%s puts on a heavy duty construction hat to prevent cranial damage\nfrom falling anvils.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 3:
		if (!user->channel) {
			write_user(user,"You are already ignoring channels!\n");
			redrawil(user);
			return;
			}
		user->channel=0;
		write_user(user,"You are now ignoring channels.\n");
		snprintf(text,sizeof(text),"%s is ignoring channels.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 4:
		if (!user->fmail) {
			write_user(user,"You are already ignoring fmail!\n");
			redrawil(user);
			return;
			}
		user->fmail=0;
		write_user(user,"You are now ignoring fmail.\n");
		snprintf(text,sizeof(text),"%s is ignoring fmail.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 5:
		if (!user->greet) {
			write_user(user,"You are already ignoring greets!\n");
			redrawil(user);
			return;
			}
		user->greet=0;
		write_user(user,"You are now ignoring greets.\n");
		snprintf(text,sizeof(text),"%s is ignoring greets.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 6:
		if (!user->hunt) {
			snprintf(text,sizeof(text),"Hunting seasons for %ss is already closed!\n",user->morphed);
			write_user(user,text);
			redrawil(user);
			return;
			}
		user->hunt=0;
		snprintf(text,sizeof(text),"Hunting season for %ss is now closed.\n",user->morphed);
		write_user(user,text);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 7:
		if (!user->join) {
			write_user(user,"You are already ignoring joins!\n");
			redrawil(user);
			return;
			}
		user->join=0;
		write_user(user,"You are now ignoring joins.\n");
		snprintf(text,sizeof(text),"%s is ignoring joins.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 8:
		if (!user->pictell) {
			write_user(user,"You are already ignoring pictells!\n");
			redrawil(user);
			return;
			}
		user->pictell=0;
		write_user(user,"You are now ignoring pictells.\n");
		snprintf(text,sizeof(text),"%s is ignoring pictells.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 9:
		if (!user->shout) {
			write_user(user,"You are already ignoring shouts!\n");
			redrawil(user);
			return;
			}
		user->shout=0;
		write_user(user,"You are now ignoring shouts.\n");
		snprintf(text,sizeof(text),"%s is ignoring shouts.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 10:
		if (!user->signon) {
			write_user(user,"You are already ignoring signons!\n");
			redrawil(user);
			return;
			}
		user->signon=0;
		write_user(user,"You are now ignoring signons.\n");
		snprintf(text,sizeof(text),"%s is ignoring signons.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 11:
		if (!user->smail) {
			write_user(user,"You are already ignoring smail!\n");
			redrawil(user);
			return;
			}
		user->smail=0;
		write_user(user,"You are now ignoring smail.\n");
		snprintf(text,sizeof(text),"%s is ignoring smail.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 12:
		if (!user->smoke) {
			write_user(user,"You are already ignoring smoke!\n");
			redrawil(user);
			return;
			}
		user->smoke=0;
		write_user(user,"You are now ignoring smoke.\n");
		snprintf(text,sizeof(text),"%s is ignoring smoke.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 13:
		if (!user->socials) {
			write_user(user,"You are already ignoring socials!\n");
			redrawil(user);
			return;
			}
		user->socials=0;
		write_user(user,"You are now ignoring socials.\n");
		snprintf(text,sizeof(text),"%s is ignoring socials.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 14:
		if (!user->tell) {
			write_user(user,"You are already ignoring tells!\n");
			redrawil(user);
			return;
			}
		user->tell=0;
		write_user(user,"You are now ignoring tells.\n");
		snprintf(text,sizeof(text),"%s is ignoring tells.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
	}
redrawil(user);
}

/*** Switch ignoring on and off ***/
void toggle_ignore(user)
UR_OBJECT user;
{
if (!strncasecmp(word[1],"all",strlen(word[1]))) {
	if (!user->listen) {
		write_user(user,"You are already being anti-social!\n");
		return;
		}
	user->listen=0;
	write_user(user,"You are now ignoring the dull gossip.\n");
	snprintf(text,sizeof(text),"%s is no longer listening.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"anvils",strlen(word[1]))) {
	if (!user->anvil) {
		write_user(user,"You are already ignoring anvils!\n");
		return;
		}
	user->anvil=0;
	write_user(user,"You put on a heavy duty construction hat to prevent cranial damage\nfrom falling anvils.\n");
	snprintf(text,sizeof(text),"%s puts on a heavy duty construction hat to prevent cranial damage\nfrom falling anvils.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"channels",strlen(word[1]))) {
	if (!user->channel) {
		write_user(user,"You are already ignoring channels!\n");
		return;
		}
	user->channel=0;
	write_user(user,"You are now ignoring channels.\n");
	snprintf(text,sizeof(text),"%s is ignoring channels.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"fmail",strlen(word[1]))) {
	if (!user->fmail) {
		write_user(user,"You are already ignoring fmail!\n");
		return;
		}
	user->fmail=0;
	write_user(user,"You are now ignoring fmail.\n");
	snprintf(text,sizeof(text),"%s is ignoring fmail.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"greet",strlen(word[1]))) {
	if (!user->greet) {
		write_user(user,"You are already ignoring greets!\n");
		return;
		}
	user->greet=0;
	write_user(user,"You are now ignoring greets.\n");
	snprintf(text,sizeof(text),"%s is ignoring greets.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"hunts",strlen(word[1]))) {
	if (!user->hunt) {
		snprintf(text,sizeof(text),"Hunting seasons for %ss is already closed!\n",user->morphed);
		write_user(user,text);
		return;
		}
	user->hunt=0;
	snprintf(text,sizeof(text),"Hunting season for %ss is now closed.\n",user->morphed);
	write_user(user,text);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"joins",strlen(word[1]))) {
	if (!user->join) {
		write_user(user,"You are already ignoring joins!\n");
		return;
		}
	user->join=0;
	write_user(user,"You are now ignoring joins.\n");
	snprintf(text,sizeof(text),"%s is ignoring joins.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"pictells",strlen(word[1]))) {
	if (!user->pictell) {
		write_user(user,"You are already ignoring pictells!\n");
		return;
		}
	user->pictell=0;
	write_user(user,"You are now ignoring pictells.\n");
	snprintf(text,sizeof(text),"%s is ignoring pictells.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"shouts",strlen(word[1]))) {
	if (!user->shout) {
		write_user(user,"You are already ignoring shouts!\n");
		return;
		}
	user->shout=0;
	write_user(user,"You are now ignoring shouts.\n");
	snprintf(text,sizeof(text),"%s is ignoring shouts.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"signons",strlen(word[1]))) {
	if (!user->signon) {
		write_user(user,"You are already ignoring sign-ons!\n");
		return;
		}
	user->signon=0;
	write_user(user,"You are now ignoring sign-ons.\n");
	snprintf(text,sizeof(text),"%s is ignoring sign-ons.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"smail",strlen(word[1]))) {
	if (!user->smail) {
		write_user(user,"You are already ignoring smail!\n");
		return;
		}
	user->smail=0;
	write_user(user,"You are now ignoring smail.\n");
	snprintf(text,sizeof(text),"%s is ignoring smail.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"smoke",strlen(word[1]))) {
	if (!user->smoke) {
		write_user(user,"You are already ignoring smoke!\n");
		return;
		}
	user->smoke=0;
	write_user(user,"You are now ignoring smoke.\n");
	snprintf(text,sizeof(text),"%s is ignoring smoke.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"socials",strlen(word[1]))) {
	if (!user->socials) {
		write_user(user,"You are already ignoring socials!\n");
		return;
		}
	user->socials=0;
	write_user(user,"You are now ignoring socials.\n");
	snprintf(text,sizeof(text),"%s is ignoring socials.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"tells",strlen(word[1]))) {
	if (!user->tell) {
		write_user(user,"You are already ignoring tells!\n");
		return;
		}
	user->tell=0;
	write_user(user,"You are now ignoring tells.\n");
	snprintf(text,sizeof(text),"%s is ignoring tells.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
write_user(user,"Not valid.\nValid options: all, anvils, channels, fmail, greets, hunts, joins,\n               pictells, shouts, signons, smail, smoke, socials, tells\n");
}

/*** Yepperonies Supercalifragilisticexpialidocious ***/
void tl_user(user)
UR_OBJECT user;
{
switch(atoi(word[0])) {
	case 1:
		if (user->listen_store) {
			write_user(user,"You are already listening!\n");
			redrawil(user);
			return;
			}
		user->turniton=1;
		break;
	case 2:
		if (user->anvil) {
			write_user(user,"You are already vulnerable to falling anvils!\n");
			redrawil(user);
			return;
			}
		user->anvil=1;
		write_user(user,"You remove your heavy duty construction hat.\n");
		snprintf(text,sizeof(text),"%s removes %s heavy duty construction hat.\n",user->morphed,gen1[user->gen]);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 3:
		if (user->channel) {
			write_user(user,"You are already listening to channels!\n");
			redrawil(user);
			return;
			}
		user->channel=1;
		write_user(user,"You are now listening to channels.\n");
		snprintf(text,sizeof(text),"%s is listening to channels.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 4:
		if (user->fmail) {
			write_user(user,"You are already listening to fmail!\n");
			redrawil(user);
			return;
			}
		user->fmail=1;
		write_user(user,"You are now listening to fmail.\n");
		snprintf(text,sizeof(text),"%s is listening to fmail.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 5:
		if (user->greet) {
			write_user(user,"You are already listening to greets!\n");
			redrawil(user);
			return;
			}
		user->greet=1;
		write_user(user,"You are now listening to greets.\n");
		snprintf(text,sizeof(text),"%s is listening to greets.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 6:
		if (user->hunt) {
			snprintf(text,sizeof(text),"Hunting seasons for %ss is already open!\n",user->morphed);
			write_user(user,text);
			redrawil(user);
			return;
			}
		user->hunt=1;
		snprintf(text,sizeof(text),"Hunting season for %ss is now open.\n",user->morphed);
		write_user(user,text);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 7:
		if (user->join) {
			write_user(user,"You are already listening to joins!\n");
			redrawil(user);
			return;
			}
		user->join=1;
		write_user(user,"You are now listening to joins.\n");
		snprintf(text,sizeof(text),"%s is listening to joins.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 8:
		if (user->pictell) {
			write_user(user,"You are already listening to pictells!\n");
			redrawil(user);
			return;
			}
		user->pictell=1;
		write_user(user,"You are now listening to pictells.\n");
		snprintf(text,sizeof(text),"%s is listening to pictells.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 9:
		if (user->shout) {
			write_user(user,"You are already listening to shouts!\n");
			redrawil(user);
			return;
			}
		user->shout=1;
		write_user(user,"You are now listening to shouts.\n");
		snprintf(text,sizeof(text),"%s is listening to shouts.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 10:
		if (user->signon) {
			write_user(user,"You are already listening to signons!\n");
			redrawil(user);
			return;
			}
		user->signon=1;
		write_user(user,"You are now listening to signons.\n");
		snprintf(text,sizeof(text),"%s is listening to signons.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 11:
		if (user->smail) {
			write_user(user,"You are already listening to smail!\n");
			redrawil(user);
			return;
			}
		user->smail=1;
		write_user(user,"You are now listening to smail.\n");
		snprintf(text,sizeof(text),"%s is listening to smail.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 12:
		if (user->smoke) {
			write_user(user,"You are already listening to smoke!\n");
			redrawil(user);
			return;
			}
		user->smoke=1;
		write_user(user,"You are now listening to smoke.\n");
		snprintf(text,sizeof(text),"%s is listening to smoke.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 13:
		if (user->socials) {
			write_user(user,"You are already listening to socials!\n");
			redrawil(user);
			return;
			}
		user->socials=1;
		write_user(user,"You are now listening to socials.\n");
		snprintf(text,sizeof(text),"%s is listening to socials.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
		break;
	case 14:
		if (user->tell) {
			write_user(user,"You are already listening to tells!\n");
			redrawil(user);
			return;
			}
		user->tell=1;
		write_user(user,"You are now listening to tells.\n");
		snprintf(text,sizeof(text),"%s is listening to tells.\n",user->morphed);
		write_room_except(user->room,text,user,NULL,0,NULL);
	}
redrawil(user);
}

/*** Switch listening on and off ***/
void toggle_listen(user)
UR_OBJECT user;
{
if (!strncasecmp(word[1],"all",strlen(word[1]))) {
	if (user->listen) {
		write_user(user,"You are already listening!\n");
		return;
		}
	user->listen=1;
	write_user(user,"You listen to the gossip.\n");
	snprintf(text,sizeof(text),"%s is now listening.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"anvils",strlen(word[1]))) {
	if (user->anvil) {
		write_user(user,"You are already vulnerable to falling anvils!\n");
		return;
		}
	user->anvil=1;
	write_user(user,"You are now vulnerable to falling anvils.\n");
	snprintf(text,sizeof(text),"%s is now vulnerable to falling anvils.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"channels",strlen(word[1]))) {
	if (user->channel) {
		write_user(user,"You are already listening to channels!\n");
		return;
		}
	user->channel=1;
	write_user(user,"You are now listening to channels.\n");
	snprintf(text,sizeof(text),"%s is now listening to channels.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"fmail",strlen(word[1]))) {
	if (user->fmail) {
		write_user(user,"You are already listening to fmail!\n");
		return;
		}
	user->fmail=1;
	write_user(user,"You are now listening to fmail.\n");
	snprintf(text,sizeof(text),"%s is now listening to fmail.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"greets",strlen(word[1]))) {
	if (user->greet) {
		write_user(user,"You are already listening to greets!\n");
		return;
		}
	user->greet=1;
	write_user(user,"You are now listening to greets.\n");
	snprintf(text,sizeof(text),"%s is now listening to greets.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"hunts",strlen(word[1]))) {
	if (user->hunt) {
		snprintf(text,sizeof(text),"Hunting seasons for %ss is already open!\n",user->morphed);
		write_user(user,text);
		return;
		}
	user->hunt=1;
	snprintf(text,sizeof(text),"Hunting season for %ss is now open.\n",user->morphed);
	write_user(user,text);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"joins",strlen(word[1]))) {
	if (user->join) {
		write_user(user,"You are already listening to joins!\n");
		return;
		}
	user->join=1;
	write_user(user,"You are now listening to joins.\n");
	snprintf(text,sizeof(text),"%s is now listening to joins.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"pictells",strlen(word[1]))) {
	if (user->pictell) {
		write_user(user,"You are already listening to pictells!\n");
		return;
		}
	user->pictell=1;
	write_user(user,"You are now listening to pictells.\n");
	snprintf(text,sizeof(text),"%s is now listening to pictells.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"shouts",strlen(word[1]))) {
	if (user->shout) {
		write_user(user,"You are already listening to shouts!\n");
		return;
		}
	user->shout=1;
	write_user(user,"You are now listening to shouts.\n");
	snprintf(text,sizeof(text),"%s is now listening to shouts.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"signons",strlen(word[1]))) {
	if (user->signon) {
		write_user(user,"You are already listening to sign-ons!\n");
		return;
		}
	user->signon=1;
	write_user(user,"You are now listening to sign-ons.\n");
	snprintf(text,sizeof(text),"%s is now listening to sign-ons.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"smail",strlen(word[1]))) {
	if (user->smail) {
		write_user(user,"You are already listening to smail!\n");
		return;
		}
	user->smail=1;
	write_user(user,"You are now listening to smail.\n");
	snprintf(text,sizeof(text),"%s is now listening to smail.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"smoke",strlen(word[1]))) {
	if (user->smoke) {
		write_user(user,"You are already listening to smoke!\n");
		return;
		}
	user->smoke=1;
	write_user(user,"You are now listening to smoke.\n");
	snprintf(text,sizeof(text),"%s is now listening to smoke.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"socials",strlen(word[1]))) {
	if (user->socials) {
		write_user(user,"You are already listening to socials!\n");
		return;
		}
	user->socials=1;
	write_user(user,"You are now listening to socials.\n");
	snprintf(text,sizeof(text),"%s is now listening to socials.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
else if (!strncasecmp(word[1],"tells",strlen(word[1]))) {
	if (user->tell) {
		write_user(user,"You are already listening to tells!\n");
		return;
		}
	user->tell=1;
	write_user(user,"You are now listening to tells.\n");
	snprintf(text,sizeof(text),"%s is now listening to tells.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
write_user(user,"Not valid.\nValid options: all, anvils, channels, fmail, greets, hunts, joins,\n               pictells, shouts, signons, smail, smoke, socials, tells\n");
}

/*** Listen - other user ***/
void otlisten(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Change whose settings?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in otlisten().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user->listenset,user2->name,sizeof(user->listenset));
	destruct_user(user2,0);
	}
else sntrncpy(user->listenset,user2->name,sizeof(user->listenset));
if (word_count==2) {
	user->listen_store=user->listen;
	user->listen=0;
	snprintf(text,sizeof(text),"%s is no longer listening.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	redrawil(user);
	user->misc_op=36;
	user->il=0;
	}
else toggle_olisten(user);
}

/*** Ignore - other user ***/
void otignore(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Change whose settings?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in otignore().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user->ignoreset,user2->name,sizeof(user->ignoreset));
	destruct_user(user2,0);
	}
else sntrncpy(user->ignoreset,user2->name,sizeof(user->ignoreset));
if (word_count==2) {
	user->listen_store=user->listen;
	user->listen=0;
	snprintf(text,sizeof(text),"%s is no longer listening.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	redrawil(user);
	user->misc_op=36;
	user->il=1;
	}
else toggle_oignore(user);
}

/*** Yepperoni ***/
void oti_user(user)
UR_OBJECT user;
{
int destructcount=0;
UR_OBJECT user2;

if ((user2=get_user2(user,user->ignoreset))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your ignore settings!\n",user->name);
		write_user(user2,text);
		redrawil(user);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in oti_user().\n",0);
		redrawil(user);
		return;
		}
	sntrncpy(user2->name,user->ignoreset,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		redrawil(user);
		return;
		}
	destructcount=1;
	user2->socket=5;
	}
switch(atoi(word[0])) {
	case 1:
		if (!user2->listen) {
			snprintf(text,sizeof(text),"%s is already being anti-social!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->listen=1;
		snprintf(text,sizeof(text),"%s listens to the dull gossip.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You listen to the dull gossip.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 2:
		if (!user2->anvil) {
			snprintf(text,sizeof(text),"%s is already ignoring falling anvils!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->anvil=0;
		snprintf(text,sizeof(text),"%s puts on %s heavy duty construction hat.\n",user2->morphed,gen1[user2->gen]);
		write_user(user,text);
		write_user(user2,"You put on your heavy duty construction hat.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 3:
		if (!user2->channel) {
			snprintf(text,sizeof(text),"%s is already ignoring channels!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->channel=0;
		snprintf(text,sizeof(text),"%s is now ignoring channels.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring channels.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 4:
		if (!user2->fmail) {
			snprintf(text,sizeof(text),"%s is already ignoring fmail!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->fmail=0;
		snprintf(text,sizeof(text),"%s is now ignoring fmail.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring fmail.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 5:
		if (!user2->greet) {
			snprintf(text,sizeof(text),"%s is already ignoring greets!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->greet=0;
		snprintf(text,sizeof(text),"%s is now ignoring greets.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring greets.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 6:
		if (!user2->hunt) {
			snprintf(text,sizeof(text),"Hunting seasons for %ss is already closed!\n",user2->morphed);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->hunt=0;
		snprintf(text,sizeof(text),"Hunting season for %ss is now closed.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,text);
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 7:
		if (!user2->join) {
			snprintf(text,sizeof(text),"%s is already ignoring joins!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->join=0;
		snprintf(text,sizeof(text),"%s is now ignoring joins.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring joins.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 8:
		if (!user2->pictell) {
			snprintf(text,sizeof(text),"%s is already ignoring pictells!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->pictell=0;
		snprintf(text,sizeof(text),"%s is now ignoring pictells.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring pictells.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 9:
		if (!user2->shout) {
			snprintf(text,sizeof(text),"%s is already ignoring shouts!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->shout=0;
		snprintf(text,sizeof(text),"%s is now ignoring shouts.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring shouts.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 10:
		if (!user2->signon) {
			snprintf(text,sizeof(text),"%s is already ignoring signons!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->signon=0;
		snprintf(text,sizeof(text),"%s is now ignoring signons.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring signons.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 11:
		if (!user2->smail) {
			snprintf(text,sizeof(text),"%s is already ignoring smail!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->smail=0;
		snprintf(text,sizeof(text),"%s is now ignoring smail.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring smail.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 12:
		if (!user2->smoke) {
			snprintf(text,sizeof(text),"%s is already ignoring smoke!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->smoke=0;
		snprintf(text,sizeof(text),"%s is now ignoring smoke.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring smoke.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 13:
		if (!user2->socials) {
			snprintf(text,sizeof(text),"%s is already ignoring socials!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->socials=0;
		snprintf(text,sizeof(text),"%s is now ignoring socials.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring socials.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 14:
		if (!user2->tell) {
			snprintf(text,sizeof(text),"%s is already ignoring tells!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->tell=0;
		snprintf(text,sizeof(text),"%s is now ignoring tells.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are ignoring tells.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
	}
redrawil(user);
if (destructcount) {
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Switch ignoring on and off ***/
void toggle_oignore(user)
UR_OBJECT user;
{
int destructcount=0;
UR_OBJECT user2;

if ((user2=get_user2(user,user->ignoreset))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your ignore settings!\n",user->name);
		write_user(user2,text);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in toggle_oignore().\n",0);
		return;
		}
	sntrncpy(user2->name,user->ignoreset,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	destructcount=1;
	user2->socket=5;
	}
if (!strncasecmp(word[2],"all",strlen(word[2]))) {
	if (!user2->listen) {
		snprintf(text,sizeof(text),"%s is already being anti-social!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->listen=0;
	snprintf(text,sizeof(text),"%s is no longer listening.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring the dull gossip.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"anvils",strlen(word[2]))) {
	if (!user2->anvil) {
		snprintf(text,sizeof(text),"%s is already ignoring anvils!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->anvil=0;
	snprintf(text,sizeof(text),"%s puts on a heavy duty construction hat to prevent cranial damage\nfrom falling anvils.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You put on a heavy duty construction hat to prevent cranial damage\nfrom falling anvils.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"channels",strlen(word[2]))) {
	if (!user2->channel) {
		snprintf(text,sizeof(text),"%s is already ignoring channels!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->channel=0;
	snprintf(text,sizeof(text),"%s is ignoring channels.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring channels.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"fmail",strlen(word[2]))) {
	if (!user2->fmail) {
		snprintf(text,sizeof(text),"%s is already ignoring fmail!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->fmail=0;
	snprintf(text,sizeof(text),"%s is ignoring fmail.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring fmail.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"greets",strlen(word[2]))) {
	if (!user2->greet) {
		snprintf(text,sizeof(text),"%s is already ignoring greets!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->greet=0;
	snprintf(text,sizeof(text),"%s is ignoring greets.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring greets.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"hunts",strlen(word[2]))) {
	if (!user2->hunt) {
		snprintf(text,sizeof(text),"Hunting seasons for %ss is already closed!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->hunt=0;
	snprintf(text,sizeof(text),"Hunting season for %ss is now closed.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,text);
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"joins",strlen(word[2]))) {
	if (!user2->join) {
		snprintf(text,sizeof(text),"%s is already ignoring joins!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->join=0;
	snprintf(text,sizeof(text),"%s is ignoring joins.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring joins.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"pictells",strlen(word[2]))) {
	if (!user2->pictell) {
		snprintf(text,sizeof(text),"%s is already ignoring pictells!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->pictell=0;
	snprintf(text,sizeof(text),"%s is ignoring pictells.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring pictells.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"shouts",strlen(word[2]))) {
	if (!user2->shout) {
		snprintf(text,sizeof(text),"%s is already ignoring shouts!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->shout=0;
	snprintf(text,sizeof(text),"%s is ignoring shouts.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring shouts.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"signons",strlen(word[2]))) {
	if (!user2->signon) {
		snprintf(text,sizeof(text),"%s is already ignoring signons!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->signon=0;
	snprintf(text,sizeof(text),"%s is ignoring signons.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring signons.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"smail",strlen(word[2]))) {
	if (!user2->smail) {
		snprintf(text,sizeof(text),"%s is already ignoring smail!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->smail=0;
	snprintf(text,sizeof(text),"%s is ignoring smail.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring smail.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"smoke",strlen(word[2]))) {
	if (!user2->smoke) {
		snprintf(text,sizeof(text),"%s is already ignoring smoke!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->smoke=0;
	snprintf(text,sizeof(text),"%s is ignoring smoke.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring smoke.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"socials",strlen(word[2]))) {
	if (!user2->socials) {
		snprintf(text,sizeof(text),"%s is already ignoring socials!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->socials=0;
	snprintf(text,sizeof(text),"%s is ignoring socials.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring socials.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"tells",strlen(word[2]))) {
	if (!user2->tell) {
		snprintf(text,sizeof(text),"%s is already ignoring tells!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->tell=0;
	snprintf(text,sizeof(text),"%s is ignoring tells.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now ignoring tells.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
write_user(user,"Not valid.\nValid options: all, anvils, channels, fmail, greets, hunts, joins,\n               pictells, shouts, signons, smail, smoke, socials, tells\n");
if (destructcount) destruct_user(user2,0);
}

/*** Yepperoni ***/
void otl_user(user)
UR_OBJECT user;
{
int destructcount=0;
UR_OBJECT user2;

if ((user2=get_user2(user,user->listenset))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your listen settings!\n",user->name);
		write_user(user2,text);
		redrawil(user);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in otl_user().\n",0);
		redrawil(user);
		return;
		}
	sntrncpy(user2->name,user->listenset,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		redrawil(user);
		return;
		}
	destructcount=1;
	user2->socket=5;
	}
switch(atoi(word[0])) {
	case 1:
		if (user2->listen) {
			snprintf(text,sizeof(text),"%s is already listening!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->listen=0;
		snprintf(text,sizeof(text),"%s listens to the dull gossip.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You listen to the dull gossip.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 2:
		if (user2->anvil) {
			snprintf(text,sizeof(text),"%s is already listening to falling anvils!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->anvil=1;
		snprintf(text,sizeof(text),"%s removes %s heavy duty construction hat.\n",user2->morphed,gen1[user2->gen]);
		write_user(user,text);
		write_user(user2,"You remove your heavy duty construction hat.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 3:
		if (user2->channel) {
			snprintf(text,sizeof(text),"%s is already listening to channels!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->channel=1;
		snprintf(text,sizeof(text),"%s is now listening to channels.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to channels.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 4:
		if (user2->fmail) {
			snprintf(text,sizeof(text),"%s is already listening to fmail!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->fmail=1;
		snprintf(text,sizeof(text),"%s is now listening to fmail.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to fmail.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 5:
		if (user2->greet) {
			snprintf(text,sizeof(text),"%s is already listening to greets!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->greet=1;
		snprintf(text,sizeof(text),"%s is now listening to greets.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to greets.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 6:
		if (user2->hunt) {
			snprintf(text,sizeof(text),"Hunting seasons for %ss is already open!\n",user2->morphed);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->hunt=1;
		snprintf(text,sizeof(text),"Hunting season for %ss is now open.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,text);
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 7:
		if (user2->join) {
			snprintf(text,sizeof(text),"%s is already listening to joins!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->join=1;
		snprintf(text,sizeof(text),"%s is now listening to joins.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to joins.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 8:
		if (user2->pictell) {
			snprintf(text,sizeof(text),"%s is already listening to pictells!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->pictell=1;
		snprintf(text,sizeof(text),"%s is now listening to pictells.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to pictells.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 9:
		if (user2->shout) {
			snprintf(text,sizeof(text),"%s is already listening to shouts!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->shout=1;
		snprintf(text,sizeof(text),"%s is now listening to shouts.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to shouts.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 10:
		if (user2->signon) {
			snprintf(text,sizeof(text),"%s is already listening to signons!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->signon=1;
		snprintf(text,sizeof(text),"%s is now listening to signons.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to signons.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 11:
		if (user2->smail) {
			snprintf(text,sizeof(text),"%s is already listening to smail!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->smail=1;
		snprintf(text,sizeof(text),"%s is now listening to smail.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to smail.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 12:
		if (user2->smoke) {
			snprintf(text,sizeof(text),"%s is already listening to smoke!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->smoke=1;
		snprintf(text,sizeof(text),"%s is now listening to smoke.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to smoke.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 13:
		if (user2->socials) {
			snprintf(text,sizeof(text),"%s is already listening to socials!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->socials=1;
		snprintf(text,sizeof(text),"%s is now listening to socials.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to socials.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
		break;
	case 14:
		if (user2->tell) {
			snprintf(text,sizeof(text),"%s is already listening to tells!\n",user2->name);
			write_user(user,text);
			redrawil(user);
			if (destructcount) destruct_user(user2,0);
			return;
			}
		user2->tell=1;
		snprintf(text,sizeof(text),"%s is now listening to tells.\n",user2->morphed);
		write_user(user,text);
		write_user(user2,"You are listening to tells.\n");
		write_room_except(user2->room,text,user,user2,0,NULL);
	}
if (destructcount) {
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
redrawil(user);
}

/*** Switch listening on and off ***/
void toggle_olisten(user)
UR_OBJECT user;
{
int destructcount=0;
UR_OBJECT user2;

if ((user2=get_user2(user,user->listenset))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your listen settings!\n",user->name);
		write_user(user2,text);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in toggle_olisten().\n",0);
		return;
		}
	sntrncpy(user2->name,user->listenset,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	destructcount=1;
	user2->socket=5;
	}
if (!strncasecmp(word[2],"all",strlen(word[2]))) {
	if (user2->listen) {
		snprintf(text,sizeof(text),"%s is already listening to the dull gossip!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->listen=1;
	snprintf(text,sizeof(text),"%s listens to the dull gossip.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You listen to the dull gossip.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"anvils",strlen(word[2]))) {
	if (user2->anvil) {
		snprintf(text,sizeof(text),"%s is already listening to anvils!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->anvil=1;
	snprintf(text,sizeof(text),"%s removes on a heavy duty construction hat to prevent cranial damage\nfrom falling anvils.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You put on a heavy duty construction hat to prevent cranial damage\nfrom falling anvils.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"channels",strlen(word[2]))) {
	if (user2->channel) {
		snprintf(text,sizeof(text),"%s is already listening to channels!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->channel=1;
	snprintf(text,sizeof(text),"%s is listening to channels.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to channels.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"fmail",strlen(word[2]))) {
	if (user2->fmail) {
		snprintf(text,sizeof(text),"%s is already listening to fmail!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->fmail=1;
	snprintf(text,sizeof(text),"%s is listening to fmail.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to fmail.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"greets",strlen(word[2]))) {
	if (user2->greet) {
		snprintf(text,sizeof(text),"%s is already listening to greets!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->greet=1;
	snprintf(text,sizeof(text),"%s is listening to greets.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to greets.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"hunts",strlen(word[2]))) {
	if (user2->hunt) {
		snprintf(text,sizeof(text),"Hunting seasons for %ss is already open!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->hunt=1;
	snprintf(text,sizeof(text),"Hunting season for %ss is now open.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,text);
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"joins",strlen(word[2]))) {
	if (user2->join) {
		snprintf(text,sizeof(text),"%s is already listening to joins!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->join=1;
	snprintf(text,sizeof(text),"%s is listening to joins.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to joins.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"pictells",strlen(word[2]))) {
	if (user2->pictell) {
		snprintf(text,sizeof(text),"%s is already listening to pictells!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->pictell=1;
	snprintf(text,sizeof(text),"%s is listening to pictells.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to pictells.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"shouts",strlen(word[2]))) {
	if (user2->shout) {
		snprintf(text,sizeof(text),"%s is already listening to shouts!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->shout=1;
	snprintf(text,sizeof(text),"%s is listening to shouts.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to shouts.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"signons",strlen(word[2]))) {
	if (user2->signon) {
		snprintf(text,sizeof(text),"%s is already listening to signons!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->signon=1;
	snprintf(text,sizeof(text),"%s is listening to signons.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to signons.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"smail",strlen(word[2]))) {
	if (user2->smail) {
		snprintf(text,sizeof(text),"%s is already listening to smail!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->smail=1;
	snprintf(text,sizeof(text),"%s is listening to smail.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to smail.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"smoke",strlen(word[2]))) {
	if (user2->smoke) {
		snprintf(text,sizeof(text),"%s is already listening to smoke!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->smoke=1;
	snprintf(text,sizeof(text),"%s is listening to smoke.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to smoke.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"socials",strlen(word[2]))) {
	if (user2->socials) {
		snprintf(text,sizeof(text),"%s is already listening to socials!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->socials=1;
	snprintf(text,sizeof(text),"%s is listening to socials.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to socials.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
else if (!strncasecmp(word[2],"tells",strlen(word[2]))) {
	if (user2->tell) {
		snprintf(text,sizeof(text),"%s is already listening to tells!\n",user2->name);
		write_user(user,text);
		if (destructcount) destruct_user(user2,0);
		return;
		}
	user2->tell=1;
	snprintf(text,sizeof(text),"%s is listening to tells.\n",user2->morphed);
	write_user(user,text);
	write_user(user2,"You are now listening to tells.\n");
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (destructcount) {
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	return;
	}
write_user(user,"Not valid.\nValid options: all, anvils, channels, fmail, greets, hunts, joins,\n               pictells, shouts, signons, smail, smoke, socials, tells\n");
if (destructcount) destruct_user(user2,0);
}

/*** Switch prompt on and off ***/
void toggle_prompt(user)
UR_OBJECT user;
{
if (user->prompt) {
	user->prompt=0;
	write_user(user,"Prompt ~FROFF.\n");
	return;
	}
user->prompt=1;
write_user(user,"Prompt ~FGON.\n");
}

/*** Set user description ***/
void desc(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (word_count<2) {
	snprintf(text,sizeof(text),"Your current description is: %s\n",user->desc);
	write_user(user,text);
	return;
	}
else if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
else if (!strcmp(word[1],"(CLONE)")) {
	write_user(user,"You cannot have that description.\n");
	return;
	}
else if (strlen(inpstr)>USER_DESC_LEN) {
	write_user(user,"Description too long.\n");
	return;
	}
else if (user->big) {
	write_user(user,"Sorry, you're big.\n");
	return;
	}
else if (!strcmp(inpstr,user->desc)) {
	write_user(user,"Description already set to that.\n");
	return;
	}
else if ((color_com_count(inpstr,0) && strlen(inpstr)>USER_DESC_LEN-3) || (name_count(inpstr,0) && strlen(inpstr)>USER_DESC_LEN-USER_NAME_LEN)) {
	write_user(user,"Description too long.\n");
	return;
	}
if (color_com_count(inpstr,0)) strncat(inpstr,"~RS",ARR_SIZE);
sntrncpy(user->desc,inpstr,sizeof(user->desc));
snprintf(text,sizeof(text),"You are now: %s %s\n",user->morphed,user->desc);
write_user(user,text);
}

/*** Set user description via the set command ***/
void descset(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (!word_count) write_user(user,"Try again.\n");
else if (ban_swearing && contains_swearing(inpstr)) if (swore(user)) return;
else if (!strcmp(word[0],"(CLONE)")) write_user(user,"You cannot have that description.\n");
else if (strlen(inpstr)>USER_DESC_LEN) write_user(user,"Description too long.\n");
else if (user->big) write_user(user,"Sorry, you're big.\n");
else if (!strcmp(inpstr,user->desc)) write_user(user,"Description already set to that.\n");
else if ((color_com_count(inpstr,0) && strlen(inpstr)>USER_DESC_LEN-3) || (name_count(inpstr,0) && strlen(inpstr)>USER_DESC_LEN-USER_NAME_LEN)) write_user(user,"Description too long.\n");
else {
	if (color_com_count(inpstr,0)) strncat(inpstr,"~RS",ARR_SIZE);
	sntrncpy(user->desc,inpstr,sizeof(user->desc));
	snprintf(text,sizeof(text),"You are now: %s %s\n",user->morphed,user->desc);
	write_user(user,text);
	}
user->misc_op=26;
redrawset(user);
}

/*** Set user description via the set command for another user ***/
void odescset(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
int destructcount=0;
UR_OBJECT user2;

if ((user2=get_user2(user,user->toggleset))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your settings!\n",user->name);
		write_user(user2,text);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in odescset().\n",0);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	sntrncpy(user2->name,user->toggleset,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	destructcount=1;
	user2->socket=5;
	}
if (!word_count) {
	write_user(user,"Try again.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (ban_swearing && contains_swearing(inpstr)) {
	if (swore(user)) return;
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (!strcmp(word[0],"(CLONE)")) {
	write_user(user,"Cannot have that description.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (strlen(inpstr)>USER_DESC_LEN) {
	write_user(user,"Description too long.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (!strcmp(inpstr,user2->desc)) {
	write_user(user,"Description already set to that.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if ((color_com_count(inpstr,0) && strlen(inpstr)>USER_DESC_LEN-3) || (name_count(inpstr,0) && strlen(inpstr)>USER_DESC_LEN-USER_NAME_LEN)) {
	write_user(user,"Description too long.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
if (color_com_count(inpstr,0)) strncat(inpstr,"~RS",ARR_SIZE);
sntrncpy(user2->desc,inpstr,sizeof(user2->desc));
snprintf(text,sizeof(text),"%s is now: %s %s\n",user2->morphed,user2->morphed,user2->desc);
write_user(user,text);
snprintf(text,sizeof(text),"You are now: %s %s\n",user2->morphed,user2->desc);
write_user(user2,text);
user->misc_op=37;
redrawset(user);
if (destructcount) {
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Set homeroom via set ***/
void ohomeroomset(user)
UR_OBJECT user;
{
int destructcount=0;
RM_OBJECT room;
UR_OBJECT user2;

if ((user2=get_user2(user,user->toggleset))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your settings!\n",user->name);
		write_user(user2,text);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in ohomeroomset().\n",0);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	sntrncpy(user2->name,user->toggleset,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	destructcount=1;
	user2->socket=5;
	}
if (!word_count) {
	write_user(user,"Try again.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (!(room=get_room(user,word[0]))) {
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (!strcmp(room->name,user2->homeroom)) {
	snprintf(text,sizeof(text),"%s's home room already is %s\n",user2->homeroom);
	write_user(user,text);
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
sntrncpy(user2->homeroom,room->name,sizeof(user2->homeroom));
snprintf(text,sizeof(text),"%s's home room set to: %s\n",user2->name,user2->homeroom);
write_user(user,text);
snprintf(text,sizeof(text),"Home room set to: %s\n",user2->homeroom);
write_user(user2,text);
user->misc_op=37;
redrawset(user);
if (destructcount) {
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Set in phrase via the set command ***/
void oinphrset(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
int destructcount=0;
UR_OBJECT user2;

if ((user2=get_user2(user,user->toggleset))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your settings!\n",user->name);
		write_user(user2,text);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in oinphrset().\n",0);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	sntrncpy(user2->name,user->toggleset,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	destructcount=1;
	user2->socket=5;
	}
if (!word_count) {
	write_user(user,"Try again.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (ban_swearing && contains_swearing(inpstr)) {
	if (swore(user)) return;
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (strlen(inpstr)>PHRASE_LEN) {
	write_user(user,"Phrase too long.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (!strcmp(inpstr,user2->in_phrase)) {
	write_user(user,"In phrase already set to that.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
sntrncpy(user2->in_phrase,inpstr,sizeof(user2->in_phrase));
snprintf(text,sizeof(text),"%s's in phrase set.\n",user2->name);
write_user(user,text);
write_user(user2,"In phrase set.\n");
user->misc_op=37;
redrawset(user);
if (destructcount) {
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Set out phrase via the set command ***/
void ooutphrset(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
int destructcount=0;
UR_OBJECT user2;

if ((user2=get_user2(user,user->toggleset))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your settings!\n",user->name);
		write_user(user2,text);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in ooutphrset().\n",0);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	sntrncpy(user2->name,user->toggleset,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		user->misc_op=37;
		redrawset(user);
		return;
		}
	destructcount=1;
	user2->socket=5;
	}
if (!word_count) {
	write_user(user,"Try again.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (ban_swearing && contains_swearing(inpstr)) {
	if (swore(user)) return;
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (strlen(inpstr)>PHRASE_LEN) {
	write_user(user,"Phrase too long.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
else if (!strcmp(inpstr,user2->out_phrase)) {
	write_user(user,"Out phrase already set to that.\n");
	user->misc_op=37;
	redrawset(user);
	if (destructcount) destruct_user(user2,0);
	return;
	}
sntrncpy(user2->out_phrase,inpstr,sizeof(user2->out_phrase));
snprintf(text,sizeof(text),"%s's out phrase set.\n",user2->name);
write_user(user,text);
write_user(user2,"Out phrase set.\n");
user->misc_op=37;
redrawset(user);
if (destructcount) {
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Ignore a user ***/
void iguser(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],line[82],name[USER_NAME_LEN+1],temp[25];
int cnt=0,found=0,total=0,total2=0;
FILE *infp,*outfp;
UR_OBJECT user2;

snprintf(filename,sizeof(filename),"%s/%s.I",USERFILES,user->name);
if (word_count<2) {
	write_user(user,"~BB~OL~FY*** Users you are ignoring ***\n");
	if (!(infp=fopen(filename,"r"))) {
		write_user(user,"You are not ignoring anyone.\n");
		return;
		}
	text[0]='\0';
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%s\n",name);
		snprintf(line,sizeof(line),"  %s",name);
		if ((user2=get_user2(user,name)) && user2->vis) { line[0]='*'; ++total; }
		++total2;
		snprintf(temp,sizeof(temp),"%-*s ",USER_NAME_LEN,line);
		strncat(text,temp,sizeof(text));
		if (++cnt==4) {
			strncat(text,"\n",sizeof(text));  write_user(user,text);
			text[0]='\0';  cnt=0;
			}
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);
	if (!cnt) write_user(user,"\n");
	else { strncat(text,"\n\n",sizeof(text));  write_user(user,text); }
	snprintf(text,sizeof(text),"Total of %d of the %d users you are ignoring signed on.\n\n",total,total2);
	write_user(user,text);
	return;
	}
word[1][0]=toupper(word[1][0]);
if (!strcmp(user->name,word[1])) {
	write_user(user,"Trying to ignore yourself is the 5th sign of madness.\n");
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.D",USERFILES,word[1]);
if ((infp=fopen(filename,"r"))) {
	if (special(word[1],0) && user->level<GENERAL) {
		snprintf(text,sizeof(text),"%s tried to ignore you.\n",user->name);
		send_mail(user,word[1],text,0);
		if (!ban_quitting && !user->frozen) disconnect_user(user);
		else if (user->level!=AWOL) --user->level;
		fclose(infp);
		return;
		}
	fclose(infp);
	}
snprintf(filename,sizeof(filename),"%s/%s.I",USERFILES,user->name);
if ((infp=fopen(filename,"r"))) {
	if (!(outfp=fopen(TEMPFILE,"w"))) {
		snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't open tempfile to write in iguser().\n",0);
		fclose(infp);
		return;
		}
	fscanf(infp,"%s",name);
	while(!feof(infp)) {
		if (!strcmp(word[1],name)) {
			fscanf(infp,"%s",name); ++found; continue;
			}
		fprintf(outfp,"%s\n",name);
		fscanf(infp,"%s",name);
		++cnt;
		}
	fclose(infp);  fclose(outfp);
	}
if (!found) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in iguser().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	destruct_user(user2,0);
	ignore(user);
	unlink(TEMPFILE);
	return;
	}
else {
	if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
	else if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in iguser().\n",0);
		return;
		}
	write_user(user,"Name removed.\n");
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in iguser().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	destruct_user(user2,0);
	}
}

/*** Subset of iguser function ***/
void ignore(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

word[1][0]=toupper(word[1][0]);
snprintf(filename,sizeof(filename),"%s/%s.I",USERFILES,user->name);
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in ignore().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[1]);
fclose(fp);
write_user(user,"Name added.\n");
}

/*** Shutdown the talker ***/
void talker_shutdown(user,str,which)
UR_OBJECT user;
char *str;
int which;
{
char *args[]={progname,confile,NULL};
char name[USER_NAME_LEN+1],*s;
int i;
NL_OBJECT nl;
UR_OBJECT user2;

if (user) s=user->name;
else s=str;
if (which) {
	write_room(NULL,"\07\n~OLSYSTEM:~RS Rebooting now!!\n\n");
	snprintf(text,sizeof(text),"*** REBOOT initiated by %s ***\n",s);
	}
else {
	write_room(NULL,"\07\n");
	snprintf(text,sizeof(text),"~OLSYSTEM:~RS Shutting down now!! Off into the real world we go...\n\n");
	sntrncpy(text,center(text,80),sizeof(text));
	write_room(NULL,text);
	snprintf(text,sizeof(text),"*** SHUTDOWN initiated by %s ***\n",s);
	}
write_syslog(text,0);
usleep(3000000);
if (!strcmp(s,"SYSTEM Reboot")) {
	sntrncpy(name,"Lilmouse",sizeof(name));
	if ((user2=get_user(name,0))) {
		if (command_disabled(user2,"all",1)) {
			sntrncpy(word[1],"all",sizeof(word[1]));
			word_count=2;
			stop_command(user2);
			}
		}
	}
for(nl=nl_first;nl;nl=nl->next) shutdown_netlink(nl);
for(user2=user_first;user2;user2=user2->next) { usleep(1500000); disconnect_user(user2); }
for(i=0;i<4;++i) close(listen_sock[i]);
unlink_channel();
unlink(HOLE_PIDFILE);
if (which) {
	execvp(progname,args);
	snprintf(text,sizeof(text),"*** REBOOT failed at %02d:%02d:%02d %s: %s ***\n\n",ttime,tmin,tsec,md,sys_errlist[errno]);
	write_syslog(text,0);
	exit(1);
	}
snprintf(text,sizeof(text),"*** SHUTDOWN complete at %02d:%02d:%02d %s ***\n\n",ttime,tmin,tsec,md);
write_syslog(text,0);
exit(0);
}

/*** Say user speech ***/
void say(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char colstr[20],name[USER_NAME_LEN+1],type[10];
UR_OBJECT user2;

if (ban_swearing && contains_swearing(inpstr) && (!(user->room->access & 1))) {
	swore(user);
	return;
	}
if (!user->room) {
	snprintf(text,sizeof(text),"ACT %s say %s\n",user->name,inpstr);
	write_sock(user->netlink->socket,text);
	return;
	}
if (user->committed) { psychosay(user); return; }
if (user->incomp) { incompsay(user); return; }
if (word_count<2 && user->command_mode) {
	write_user(user,"Say what?\n");
	return;
	}
if (!strcmp(user->room->name,"Hall_of_Mirrors")) {
	backsay(user,0,inpstr);
	return;
	}
switch(inpstr[strlen(inpstr)-1]) {
	case '?': sntrncpy(type,"ask",sizeof(type)-1);  break;
	case '!': sntrncpy(type,"exclaim",sizeof(type)-1);  break;
	default : sntrncpy(type,"say",sizeof(type)-1);
	}
if (user->type==CLONE_TYPE) {
	snprintf(text,sizeof(text),"Clone of %s %ss: %s\n",user->morphed,type,inpstr);
	write_room(user->room,text);
	record(user->room,text);
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
snprintf(text,sizeof(text),"You %s: %s\n",type,inpstr);
write_user(user,text);
colstr[0]='\0';
if (user->level==GENERAL) sntrncpy(colstr,"~FR",sizeof(colstr));
else if (user->level==COMMANDER) sntrncpy(colstr,"~FM",sizeof(colstr));
else if (user->level==COLONEL) sntrncpy(colstr,"~OL~FY",sizeof(colstr));
else if (user->level==CAPTAIN) sntrncpy(colstr,"~OL~FB",sizeof(colstr));
else if (user->level==CORPORAL) sntrncpy(colstr,"~OL~FG",sizeof(colstr));
if (get_color(user,2)) {
	snprintf(text,sizeof(text),"%s%s %ss:~RS %s\n",user->colstr,user->morphed,type,inpstr);
	user->colstr[0]='\0';
	}
else if (!user->vis) snprintf(text,sizeof(text),"~OL~FBA disembodied voice %ss:~RS %s\n",type,inpstr);
else snprintf(text,sizeof(text),"%s%s %ss:~RS %s\n",colstr,user->morphed,type,inpstr);
write_room_except(user->room,text,user,NULL,0,NULL);
record(user->room,text);
sntrncpy(name,"Lilmouse",sizeof(name));
if (!(user2=get_user(name,0))) return;
if (user2->room==user->room) {
	if (instr(inpstr,"hello")) {
		snprintf(text,sizeof(text),"~FB%s says:~RS hi there.\n",user2->morphed);
		write_room(user->room,text);
		}
	else if (instr(inpstr,"help")) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"~FB%s says:~RS For help, type .help\n",user2->morphed);
		else snprintf(text,sizeof(text),"~FB%s says:~RS For help, use the help command\n",user2->morphed);
		write_room(user->room,text);
		}
	else if (instr(inpstr,"dfh")) {
		snprintf(text,sizeof(text),"~FB%s says:~RS what?\n",user2->morphed);
		write_room(user->room,text);
		}
	else if (instr(inpstr,"die")) {
		snprintf(text,sizeof(text),"~FB%s says:~RS no, YOU DIE!\n",user2->morphed);
		write_room(user->room,text);
		}
	else if (instr(inpstr,"life sucks")) {
		snprintf(text,sizeof(text),"~FB%s says:~RS I know... I know.\n",user2->morphed);
		write_room(user->room,text);
		}
	else if (instr(inpstr,"teehee")) {
		snprintf(text,sizeof(text),"~FB%s says:~RS what are you up to now, %s?\n",user2->morphed,user->morphed);
		write_room(user->room,text);
		}
	else if (instr(inpstr,"what?")) {
		snprintf(text,sizeof(text),"~FB%s says:~RS eh?\n",user2->morphed);
		write_room(user->room,text);
		}
	else if (instr(inpstr,"no bigcat") && bigcatstage==10 && user2->room==user->room) {
		sntrncpy(name,"Bigcat",sizeof(name));
		if (!(user2=get_user(name,0))) return;
		snprintf(text,sizeof(text),"~FYbigcat slowly backs away...\n");
		write_room(user->room,text);
		disconnect_user(user2);
		sntrncpy(name,"Lilmouse",sizeof(name));
		if (!(user2=get_user(name,0))) return;
		snprintf(text,sizeof(text),"~FBlilmouse says:~RS thank you so much!!! YOU SAVED ME!\n");
		write_room(user2->room,text);
		user2->room=room_first;
		bigcattime=time(0);
		bigcatstage=0;
		}
	else if (instr(inpstr,"hi")) {
		snprintf(text,sizeof(text),"~FB%s says:~RS Hewwo.\n",user2->morphed);
		write_room(user->room,text);
		}
	}
}

/*** Say user speech backwards***/
void backsay(user,which,inpstr)
UR_OBJECT user;
int which;
char *inpstr;
{
char colstr[20],name[USER_NAME_LEN+1],type[10];

if (word_count<2 && which) {
	write_user(user,"Say what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr) && (!(user->room->access & 1))) {
	swore(user);
	return;
	}
if (!user->room) {
	snprintf(text,sizeof(text),"ACT %s say %s\n",user->name,inpstr);
	write_sock(user->netlink->socket,text);
	return;
	}
if (user->committed) { psychosay(user); return; }
if (user->incomp) { incompsay(user); return; }
sntrncpy(name,user->morphed,sizeof(name));
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
backwards(name);
backwards(inpstr);
switch(inpstr[0]) {
	case '?': sntrncpy(type,"ksa",sizeof(type));  break;
	case '!': sntrncpy(type,"mialcxe",sizeof(type));  break;
	default : sntrncpy(type,"yas",sizeof(type));
	}
if (user->big) strtoupper(inpstr);
snprintf(text,sizeof(text),"%s: %s uoY\n",inpstr,type);
write_user(user,text);
colstr[0]='\0';
if (user->level==GENERAL) sntrncpy(colstr,"~FR",sizeof(colstr));
else if (user->level==COMMANDER) sntrncpy(colstr,"~FM",sizeof(colstr));
else if (user->level==COLONEL) sntrncpy(colstr,"~OL~FY",sizeof(colstr));
else if (user->level==CAPTAIN) sntrncpy(colstr,"~OL~FB",sizeof(colstr));
else if (user->level==CORPORAL) sntrncpy(colstr,"~OL~FG",sizeof(colstr));
if (get_color(user,2)) {
	snprintf(text,sizeof(text),"%s %s:s%s %s\n",inpstr,user->colstr,type,name);
	user->colstr[0]='\0';
	}
else if (!user->vis) snprintf(text,sizeof(text),"~OL~FBs%s eciov yltsohg A:~RS %s\n",type,inpstr);
else snprintf(text,sizeof(text),"%s %s:s%s %s\n",inpstr,colstr,type,name);
write_room_except(user->room,text,user,NULL,0,NULL);
record(user->room,text);
}

/*** Shout something ***/
void shout(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1],type[10];
UR_OBJECT user2;

if (ban_shouting) {
	write_user(user,"Sorry, shouting has been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Shout what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (user->committed) { psychoshout(user); return; }
if (!strcmp(user->room->name,"Hall_of_Mirrors")) {
	backshout(user,inpstr);
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
switch(inpstr[strlen(inpstr)-1]) {
	case '?': sntrncpy(type,"question",sizeof(type));  break;
	case '!': sntrncpy(type,"scream",sizeof(type));  break;
	default : sntrncpy(type,"shout",sizeof(type));
	}
snprintf(text,sizeof(text),"You %s: %s\n",type,inpstr);
write_user(user,text);
snprintf(text,sizeof(text),"~OL~FY%s %ss:~RS %s\n",user->morphed,type,inpstr);
write_room_except(NULL,text,user,NULL,1,user);
recordsh(user,text);
sntrncpy(name,"Lilmouse",sizeof(name));
if (!(user2=get_user(name,0))) return;
if (!strcmp(inpstr,"no cheese")) {
	snprintf(text,sizeof(text),"~FB%s shouts:~RS :(\n",user2->morphed);
	write_room_except(NULL,text,user2,NULL,1,user2);
	}
if (!strcmp(inpstr,"squeak")) {
	snprintf(text,sizeof(text),"~FB!! %s :P\n",user2->morphed);
	write_room_except(NULL,text,user2,NULL,1,user2);
	}
}

/*** Shout sends backwards speech to all users regardless of area ***/
void backshout(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1],type[10];

if (ban_shouting) {
	write_user(user,"Sorry, shouting has been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Backwards shout what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (user->committed) { psychoshout(user); return; }
sntrncpy(name,user->morphed,strlen(name));
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
backwards(name);
backwards(inpstr);
if (user->big) strtoupper(inpstr);
switch(inpstr[0]) {
	case '?': sntrncpy(type,"noitseuq",sizeof(type));  break;
	case '!': sntrncpy(type,"maercs",sizeof(type));  break;
	default : sntrncpy(type,"tuohs",sizeof(type));
	}
snprintf(text,sizeof(text),"%s :%s uoY\n",inpstr,type);
write_user(user,text);
snprintf(text,sizeof(text),"%s ~OL~FY:%s s%s\n",inpstr,type,name);
write_room_except(NULL,text,user,NULL,1,user);
recordsh(user,text);
}

/*** Tell another user something ***/
void tell(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1],type[12];
UR_OBJECT user2;

if (word_count<3) {
	write_user(user,"Tell who what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Talking to yourself is the first sign of madness.\n");
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start) {
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
		write_user(user,text);
		return;
		}
	else if (user->level<GENERAL) {
		snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
		write_user(user,text);
		return;
		}
	}
if (!user2->tell && user->level<GENERAL) {
	snprintf(text,sizeof(text),"%s is not listening to tells at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!strcmp(user->room->name,"Hall_of_Mirrors")) {
	backtell(user,inpstr);
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
if (inpstr[strlen(inpstr)-1]=='?') sntrncpy(type,"ask",sizeof(type));
else if (inpstr[strlen(inpstr)-1]=='!') sntrncpy(type,"exclaim to",sizeof(type));
else sntrncpy(type,"tell",sizeof(type));
snprintf(text,sizeof(text),"~OLYou %s %s:~RS %s\n",type,user2->morphed,inpstr);
write_user(user,text);
recordtell(user,text);
if (!strcmp(word[2],"force") && user->level>COLONEL) {
	if (strcmp(user2->name,"Lilmouse") && user2->level>=user->level) {
		write_user(user,"Go away.\n");
		return;
		}
	else if (!strcmp(user2->name,"Lilmouse") && user2->level>user->level) {
		write_user(user,"Die!\n");
		return;
		}
	if (user2->misc_op) {
		write_user(user,"Try again later.\n");
		return;
		}
	inpstr=remove_first(inpstr);
	exec_str(user2,inpstr,0);
	return;
	}
sntrncpy(name,user->morphed,sizeof(name));
strtolower(name);
name[0]=toupper(name[0]);
if (get_color(user2,3)) {
	if (strcmp(type,"exclaim to")) {
		if (!strcmp(user->name,name)) snprintf(text,sizeof(text),"%s%s %ss you:~RS %s\n",user2->colstr,user->morphed,type,inpstr);
		else snprintf(text,sizeof(text),"%s%s %ss you:~RS %s\n",user2->colstr,user->name,type,inpstr);
		}
	else {
		sntrncpy(type,"exclaims to",sizeof(type));
		if (!strcmp(user->name,name)) snprintf(text,sizeof(text),"%s%s %s you:~RS %s\n",user2->colstr,user->morphed,type,inpstr);
		else snprintf(text,sizeof(text),"%s%s %s you:~RS %s\n",user2->colstr,user->name,type,inpstr);
		}
	user2->colstr[0]='\0';
	}
else if (get_color(user,3)) {
	if (strcmp(type,"exclaim to")) {
		if (!strcmp(user->name,name)) snprintf(text,sizeof(text),"%s%s %ss you:~RS %s\n",user->colstr,user->morphed,type,inpstr);
		else snprintf(text,sizeof(text),"%s%s %ss you:~RS %s\n",user->colstr,user->name,type,inpstr);
		}
	else {
		sntrncpy(type,"exclaims to",sizeof(type));
		if (!strcmp(user->name,name)) snprintf(text,sizeof(text),"%s%s %s you:~RS %s\n",user->colstr,user->morphed,type,inpstr);
		else snprintf(text,sizeof(text),"%s%s %s you:~RS %s\n",user->colstr,user->name,type,inpstr);
		}
	user->colstr[0]='\0';
	}
else {
	if (strcmp(type,"exclaim to")) {
		if (!strcmp(user->name,name)) snprintf(text,sizeof(text),"~BR~OL~FY%s %ss you:~RS %s\n",user->morphed,type,inpstr);
		else snprintf(text,sizeof(text),"~BR~OL~FY%s %ss you:~RS %s\n",user->name,type,inpstr);
		}
	else {
		sntrncpy(type,"exclaims to",sizeof(type));
		if (!strcmp(user->name,name)) snprintf(text,sizeof(text),"~BR~OL~FY%s %s you:~RS %s\n",user->morphed,type,inpstr);
		else snprintf(text,sizeof(text),"~BR~OL~FY%s %s you:~RS %s\n",user->name,type,inpstr);
		}
	}
if (!user2->afk) {
	write_user(user2,text);
	recordtell(user2,text);
	if (!strcmp(user2->name,"Lilmouse")) {
		strtolower(word[2]);
		if (!strcmp(word[2],"hello")) {
			snprintf(text,sizeof(text),"~FB%s tells you:~RS hello.\n",user2->morphed);
			write_user(user,text);
			}
		else if (!strcmp(word[2],"kill") && user->level>COLONEL) {
			if (!(user2=get_user(word[3],0))) {
				write_user(user,"~FBlilmouse tells you:~RS Kill who??\n");
				return;
				}
			if (user2==user) {
				write_user(user,"~FBlilmouse tells you:~RS feeling suicidal today?\n");
				return;
				}
			if (user2->level>=user->level) {
				snprintf(text,sizeof(text),"~FBlilmouse tells you:~RS Umm, %s wouldn't like that much.\n",user2->name);
				write_user(user,text);
				snprintf(text,sizeof(text),"~FBlilmouse tells you:~RS %s wanted me to kill you!\n",user->name);
				write_user(user2,text);
				return;
				}
			write_user(user,"~FBlilmouse tells you:~RS will do.\n");
			sntrncpy(killem,user2->name,sizeof(killem));
			}
		else if (user->level>COLONEL) exec_str(user2,inpstr,0);
		}
	return;
	}
write_afklog(user2,text);
snprintf(text,sizeof(text),"AFK message from %s: %s\n",user2->morphed,user2->afkmesg);
write_user(user,text);
}

/*** Backwards tell ***/
void backtell(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1],name1[USER_NAME_LEN+1],name2[USER_NAME_LEN+1];
int umm=0;
UR_OBJECT user2;

if (word_count<3) {
	write_user(user,"Backwards tell who what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Talking to yourself is the first sign of madness.\n");
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->tell) {
	snprintf(text,sizeof(text),"%s is not listening to tells at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
sntrncpy(name2,user->morphed,sizeof(name2));
strtolower(name2);
name2[0]=toupper(name2[0]);
if (!strcmp(user->name,name2)) sntrncpy(name,user->morphed,strlen(name));
else sntrncpy(name,user->name,sizeof(name));
sntrncpy(name1,user2->morphed,sizeof(name1));
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
backwards(name);
backwards(name1);
backwards(inpstr);
if (user->big) strtoupper(inpstr);
if (get_color(user2,3)) umm=1;
else if (get_color(user,3)) umm=2;
switch(inpstr[0]) {
	case '?':
		if (!umm) snprintf(text,sizeof(text),"~BR~OL~FY%s~RS :~OL%s ksa uoY\n",inpstr,name1);
		else snprintf(text,sizeof(text),"%s%s~RS :~OL%s ksa uoY\n",user->colstr,inpstr,name1);
		write_user(user,text);
		recordtell(user,text);
		if (!umm) snprintf(text,sizeof(text),"%s ~BR~OL~FY:uoy sksa %s\n",inpstr,name);
		else if (umm==1) snprintf(text,sizeof(text),"%s %s:uoy sksa %s\n",inpstr,user2->colstr,name);
		else snprintf(text,sizeof(text),"%s %s:uoy sksa %s\n",inpstr,user->colstr,name);
		if (umm==1) user2->colstr[0]='\0';
		else if (umm==2) user->colstr[0]='\0';
		if (!user2->afk) {
			write_user(user2,text);
			recordtell(user2,text);
			return;
			}
		break;
	case '!':
		if (!umm) snprintf(text,sizeof(text),"~BR~OL~FY%s~RS :~OL%s ot mialcxe uoY\n",inpstr,name1);
		else snprintf(text,sizeof(text),"%s%s~RS :~OL%s ot mialcxe uoY\n",user->colstr,inpstr,name1);
		write_user(user,text);
		recordtell(user,text);
		if (!umm) snprintf(text,sizeof(text),"%s ~BR~OL~FY:uoy ot smialcxe %s\n",inpstr,name);
		else if (umm==1) snprintf(text,sizeof(text),"%s %s:uoy ot smialcxe %s\n",inpstr,user2->colstr,name);
		else snprintf(text,sizeof(text),"%s %s:uoy ot smialcxe %s\n",inpstr,user->colstr,name);
		if (umm==1) user2->colstr[0]='\0';
		else if (umm==2) user->colstr[0]='\0';
		if (!user2->afk) {
			write_user(user2,text);
			recordtell(user2,text);
			return;
			}
		break;
	default:
		if (!umm) snprintf(text,sizeof(text),"~BR~OL~FY%s~RS :~OL%s llet uoY\n",inpstr,name1);
		else snprintf(text,sizeof(text),"%s%s~RS :~OL%s llet uoY\n",user->colstr,inpstr,name1);
		write_user(user,text);
		recordtell(user,text);
		if (!umm) snprintf(text,sizeof(text),"%s ~BR~OL~FY:uoy sllet %s\n",inpstr,name);
		else if (umm==1) snprintf(text,sizeof(text),"%s %s:uoy sllet %s\n",user2->colstr,inpstr,name);
		else snprintf(text,sizeof(text),"%s %s:uoy sllet %s\n",user->colstr,inpstr,name);
		if (umm==1) user2->colstr[0]='\0';
		else if (umm==2) user->colstr[0]='\0';
		if (!user2->afk) {
			write_user(user2,text);
			recordtell(user2,text);
			return;
			}
		break;
	}
write_afklog(user2,text);
snprintf(text,sizeof(text),"AFK message from %s: %s\n",user2->morphed,user2->afkmesg);
write_user(user,text);
}

/*** Emote something ***/
void emote(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (word_count<2) {
	write_user(user,"Emote what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr) && (!(user->room->access & 1))) {
	swore(user);
	return;
	}
if (user->committed) { psychoemote(user); return; }
if (!strcmp(user->room->name,"Hall_of_Mirrors")) {
	backemote(user,inpstr);
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
if (get_color(user,2)) {
	if (inpstr[0]=='\'') snprintf(text,sizeof(text),"%s%s%s\n",user->colstr,user->morphed,inpstr);
	else snprintf(text,sizeof(text),"%s%s %s\n",user->colstr,user->morphed,inpstr);
	user->colstr[0]='\0';
	}
else {
	if (inpstr[0]=='\'') snprintf(text,sizeof(text),"%s%s\n",user->morphed,inpstr);
	else snprintf(text,sizeof(text),"%s %s\n",user->morphed,inpstr);
	}
write_room(user->room,text);
record(user->room,text);
}

/*** Backwards emote function used for expressing emotional or visual stuff ***/
void backemote(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1];

if (word_count<2) {
	write_user(user,"Backwards emote what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr) && (!(user->room->access & 1))) {
	swore(user);
	return;
	}
if (user->committed) { psychoemote(user); return; }
sntrncpy(name,user->morphed,strlen(name));
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
backwards(inpstr);
backwards(name);
if (user->big) strtoupper(inpstr);
if (get_color(user,2)) {
	if (inpstr[strlen(inpstr)-1]=='\'') snprintf(text,sizeof(text),"%s%s %s\n",user->colstr,inpstr,name);
	else snprintf(text,sizeof(text),"%s%s %s\n",user->colstr,inpstr,name);
	user->colstr[0]='\0';
	}
else {
	if (inpstr[strlen(inpstr)-1]=='\'') snprintf(text,sizeof(text),"%s%s\n",inpstr,name);
	else snprintf(text,sizeof(text),"%s %s\n",inpstr,name);
	}
write_user(user,text);
write_room_except(user->room,text,user,NULL,0,NULL);
record(user->room,text);
}

/*** Do a shout emote ***/
void semote(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (ban_shouting) {
	write_user(user,"Sorry, shouting has been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Shout emote what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (user->committed) { psychosemote(user); return; }
if (!strcmp(user->room->name,"Hall_of_Mirrors")) {
	backsemote(user,inpstr);
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
snprintf(text,sizeof(text),"!! %s %s\n",user->morphed,inpstr);
write_user(user,text);
write_room_except(NULL,text,user,NULL,1,user);
recordsh(user,text);
}

/*** Do a backwards shout emote ***/
void backsemote(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1];

if (ban_shouting) {
	write_user(user,"Sorry, shouting has been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Backwards shout emote what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (user->committed) { psychosemote(user); return; }
sntrncpy(name,user->morphed,strlen(name));
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
backwards(name);
backwards(inpstr);
if (user->big) strtoupper(inpstr);
snprintf(text,sizeof(text),"!! %s %s\n",inpstr,name);
write_user(user,text);
write_room_except(NULL,text,user,NULL,1,user);
recordsh(user,text);
}

/*** Do a private emote ***/
void pemote(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1];
UR_OBJECT user2;

if (word_count<3) {
	write_user(user,"Private emote what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (!strcmp(user2->name,user->name)) {
	write_user(user,"Emoting to yourself is the second sign of madness.\n");
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->tell) {
	snprintf(text,sizeof(text),"%s is not listening to tells at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
sntrncpy(name,user->morphed,sizeof(name));
strtolower(name);
name[0]=toupper(name[0]);
if (!strcmp(user->name,name)) {
	if (inpstr[0]=='\'') snprintf(text,sizeof(text),"(To %s) %s%s\n",user2->morphed,user->morphed,inpstr);
	else snprintf(text,sizeof(text),"(To %s) %s %s\n",user2->morphed,user->morphed,inpstr);
	}
else {
	if (inpstr[0]=='\'') snprintf(text,sizeof(text),"(To %s) %s%s\n",user2->morphed,user->name,inpstr);
	else snprintf(text,sizeof(text),"(To %s) %s %s\n",user2->morphed,user->name,inpstr);
	}
write_user(user,text);
recordtell(user,text);
if (get_color(user2,3)) {
	if (inpstr[0]=='\'') snprintf(text,sizeof(text),"%s>>~RS %s%s\n",user2->colstr,user->name,inpstr);
	else snprintf(text,sizeof(text),"%s>>~RS %s %s\n",user2->colstr,user->name,inpstr);
	user2->colstr[0]='\0';
	}
else if (get_color(user,3)) {
	if (inpstr[0]=='\'') snprintf(text,sizeof(text),"%s>>~RS %s%s\n",user->colstr,user->name,inpstr);
	else snprintf(text,sizeof(text),"%s>>~RS %s %s\n",user->colstr,user->name,inpstr);
	user->colstr[0]='\0';
	}
else {
	if (inpstr[0]=='\'') snprintf(text,sizeof(text),"~OL~FR>>~RS %s%s\n",user->name,inpstr);
	else snprintf(text,sizeof(text),"~OL~FR>>~RS %s %s\n",user->name,inpstr);
	}
if (!user2->afk) {
	write_user(user2,text);
	recordtell(user2,text);
	return;
	}
write_afklog(user2,text);
snprintf(text,sizeof(text),"AFK message from %s: %s\n",user2->morphed,user2->afkmesg);
write_user(user,text);
}

/*** Echo something to screen ***/
void echo(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Echo what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr) && (!(user->room->access & 1))) {
	swore(user);
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (!strcmp(user->room->name,"Hall_of_Mirrors")) {
	backecho(user,inpstr);
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->room==user->room) {
		if (!user2->listen || user2->login) continue;
		if (user2->type==CLONE_TYPE) if (user2->room==user2->owner->room) continue;
		if (user2->level>user->level) snprintf(text,sizeof(text),"[ %s ] - %s\n",user->name,inpstr);
		else snprintf(text,sizeof(text),"- %s\n",inpstr);
		write_user(user2,text);
		}
	}
}

/*** Backwards echo function ***/
void backecho(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1];
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Backwards echo what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr) && (!(user->room->access & 1))) {
	swore(user);
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
sntrncpy(name,user->morphed,sizeof(name));
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
backwards(name);
backwards(inpstr);
if (user->big) strtoupper(inpstr);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->room==user->room) {
		if (!user2->listen || user2->login) continue;
		if (user2->type==CLONE_TYPE) if (user2->room==user2->owner->room) continue;
		if (user2->level>user->level) snprintf(text,sizeof(text),"[ %s ] - %s\n",user->name,inpstr);
		else snprintf(text,sizeof(text),"- %s\n",inpstr);
		write_user(user2,text);
		}
	}
}

/*** Shout echo something to all screens ***/
void secho(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
UR_OBJECT user2;

if (ban_shouting) {
	write_user(user,"Sorry, shouting has been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Shout echo what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (!strcmp(user->room->name,"Hall_of_Mirrors")) {
	backsecho(user,inpstr);
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
for(user2=user_first;user2;user2=user2->next) {
	if (!user2->shout || !user2->listen || user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
	if (user2->level>user->level) snprintf(text,sizeof(text),"[ %s ] ~ %s\n",user->name,inpstr);
	else snprintf(text,sizeof(text),"~ %s\n",inpstr);
	write_user(user2,text);
	}
}

/*** Back shout echo something to all screens ***/
void backsecho(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char name[USER_NAME_LEN+1];
UR_OBJECT user2;

if (ban_shouting) {
	write_user(user,"Sorry, shouting has been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Backwards shout echo what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
sntrncpy(name,user->morphed,strlen(name));
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
backwards(name);
backwards(inpstr);
if (user->big) strtoupper(inpstr);
for(user2=user_first;user2;user2=user2->next) {
	if (!user2->shout || !user2->listen || user2->login || user2->type==CLONE_TYPE) continue;
	if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
	if (user2->level>user->level) snprintf(text,sizeof(text),"[ %s ] ~ %s\n",name,inpstr);
	else snprintf(text,sizeof(text),"~ %s\n",inpstr);
	write_user(user2,text);
	}
}

/*** Talk to me puhleeeeeeeeze ***/
void talk_to_me(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (user->talking || check_talk(user)) {
	write_user(user,"You are already talking to someone.\n");
	return;
	}
if (!user->talkready) {
	write_user(user,"Please type scmquit to abort.\nWho do you wish to talk to? ");
	user->misc_op=115;
	return;
	}
if (user->port!=port[2]) {
	if (!(user2=get_user2(user,word[1]))) {
		write_user(user,notloggedon);
		end_talking(user,0);
		return;
		}
	}
else {
	for(user2=user_first;user2;user2=user2->next) {
		if (user2==user) continue;
		if (user2->port==port[2]) break;
		}
	if (!user2) { end_talking(user,0); return; }
	}
sntrncpy(user->talkto,user2->name,sizeof(user->talkto));
sntrncpy(user2->talkto,user->name,sizeof(user2->talkto));
init_mode(user); init_mode(user2);
user->listen_store=user->listen; user2->listen_store=user2->listen;
user->listen=0; user2->listen=0;
user->talking=1; user2->talking=1;
user->whichtalk=1; user2->whichtalk=2;
draw_screen(user,user2,0);
}

/*** Draw talk screen ***/
void draw_screen(user,user2,which)
UR_OBJECT user,user2;
int which;
{
char text2[ARR_SIZE],text3[ARR_SIZE];
int align,align2,align3;

snprintf(text,sizeof(text),"------------------------ Welcome to Hole's talk service ------------------------\n");
if (!which) {
	cls(user);
	if (user->color) write_sock(user->socket,"[1;31m");
	write_sock(user->socket,text);
	if (user->color) write_sock(user->socket,"[0m");
	gotoxy(user,13,1,0);
	snprintf(text2,sizeof(text2),"* %s@Hole *",user2->name);
	align=80-strlen(text2);
	align2=align/2;
	text3[0]='\0';
	for(align3=0;align3<align2;++align3) strncat(text3,"-",sizeof(text3));
	strncat(text3,text2,sizeof(text3));
	for(align3=align-align3;align3;--align3) strncat(text3,"-",sizeof(text3));
	strncat(text3,"\n",sizeof(text3));
	if (user->color) write_sock(user->socket,"[1;34m");
	write_sock(user->socket,text3);
	if (user->color) write_sock(user->socket,"[0m");
	gotoxy(user,2,1,1);
	cls(user2);
	if (user2->color) write_sock(user2->socket,"[1;31m");
	write_sock(user2->socket,text);
	if (user2->color) write_sock(user2->socket,"[0m");
	gotoxy(user2,13,1,0);
	snprintf(text2,sizeof(text2),"* %s@Hole *",user->name);
	align=80-strlen(text2);
	align2=align/2;
	text3[0]='\0';
	for(align3=0;align3<align2;++align3) strncat(text3,"-",sizeof(text3));
	strncat(text3,text2,sizeof(text3));
	for(align3=align-align3;align3;--align3) strncat(text3,"-",sizeof(text3));
	strncat(text3,"\n",sizeof(text3));
	if (user2->color) write_sock(user2->socket,"[1;34m");
	write_sock(user2->socket,text3);
	if (user2->color) write_sock(user2->socket,"[0m");
	gotoxy(user2,14,1,1);
	}
else {
	cls(user);
	if (user->color) write_sock(user->socket,"[1;31m");
	write_sock(user->socket,text);
	if (user->color) write_sock(user->socket,"[0m");
	gotoxy(user,13,1,0);
	snprintf(text2,sizeof(text2),"* %s@Hole *",user2->name);
	align=80-strlen(text2);
	align2=align/2;
	text3[0]='\0';
	for(align3=0;align3<align2;++align3) strncat(text3,"-",sizeof(text3));
	strncat(text3,text2,sizeof(text3));
	for(align3=align-align3;align3;--align3) strncat(text3,"-",sizeof(text3));
	if (user->color) write_sock(user->socket,"[1;34m");
	write_sock(user->socket,text3);
	if (user->color) write_sock(user->socket,"[0m");
	if (user->whichtalk==1) { gotoxy(user,2,1,1); gotoxy(user2,2,1,0); }
	else { gotoxy(user,14,1,1); gotoxy(user2,14,1,0); }
	clear_line(user2);
	}
}

/*** Check character for telnet options ***/
void check_char(user,c)
UR_OBJECT user;
unsigned char c;
{
if (user->ctrl_last) {
	switch(user->ctrl_last) {
		case T_IAC:
			switch(c) {
				case T_IAC: user->ctrl_last=0; talk_time(user,T_IAC); break;
				case T_WILL: user->ctrl_last=T_WILL; break;
				case T_WONT: user->ctrl_last=T_WONT; break;
				case T_DO: user->ctrl_last=T_DO; break;
				case T_DONT: user->ctrl_last=T_DONT; break;
				case T_EC: user->ctrl_last=0; talk_time(user,8); break;
				}
			break;
		case T_DO:
		case T_WILL:
		case T_WONT: user->ctrl_last=0; break;
		case T_DONT: user->ctrl_last=0;
		}
	}
else {
	if (c==T_IAC) user->ctrl_last=T_IAC;
	else talk_time(user,c);
	}
}

/*** Time to talk ***/
void talk_time(user,c)
UR_OBJECT user;
unsigned char c;
{
UR_OBJECT user2;

if (user->port!=port[2]) {
	if (!(user2=get_user2(user,user->talkto))) { end_talking(user,0); return; }
	}
else {
	for(user2=user_first;user2;user2=user2->next) {
		if (user2==user) continue;
		if (user2->port==port[2]) break;
		}
	if (!user2) { end_talking(user,0); return; }
	}
if (c==3) { end_talking(user,0); return; }
else if (c==18) { draw_screen(user,user2,1); return; }
gotoxy(user,user->xval,user->yval,0); gotoxy(user2,user->xval,user->yval,0);
snprintf(text,sizeof(text),"%c",c);
write(user->socket,text,1); write(user2->socket,text,1);
if (c=='\n' || c=='\r') {
	if (user->xval>=12 && user->whichtalk==1) user->xval=2;
	else if (user->xval>24 && user->whichtalk==2) user->xval=14;
	else ++user->xval;
	user->yval=1;
	gotoxy(user,user->xval,user->yval,0); gotoxy(user2,user->xval,user->yval,0);
	clear_line(user); clear_line(user2);
	}
else if (c==8 || c==127) {
	if (user->yval>1) --user->yval;
	gotoxy(user,user->xval,user->yval,0); gotoxy(user2,user->xval,user->yval,0);
	clear_line(user); clear_line(user2);
	}
else if (isprint(c)) {
	if (user->yval>=80) {
		if (user->xval>=12 && user->whichtalk==1) user->xval=2;
		else if (user->xval>24 && user->whichtalk==2) user->xval=14;
		else ++user->xval;
		user->yval=1;
		gotoxy(user,user->xval,user->yval,0); gotoxy(user2,user->xval,user->yval,0);
		clear_line(user); clear_line(user2);
		}
	else ++user->yval;
	}
}

/*** Stop talking already ***/
void end_talking(user,which)
UR_OBJECT user;
int which;
{
UR_OBJECT user2;

if (!which) {
	if (user->port!=port[2]) {
		if ((user2=get_user2(user,user->talkto))) end_talking(user2,1);
		}
	else {
		for(user2=user_first;user2;user2=user2->next) {
			if (user2==user) continue;
			if (user2->port==port[2]) break;
			}
		if (user2) end_talking(user2,1);
		}
	}
reset_mode(user);
cls(user);
user->ctrl_last=0;
user->listen=user->listen_store;
user->listen_store=1;
user->talking=0;
user->talkready=0;
user->talkto[0]='\0';
user->xval=0;
user->yval=0;
user->whichtalk=0;
if (user->port==port[2]) disconnect_user(user);
}

/*** Accept talk requests ***/
void accept_talk_connections(user,which)
UR_OBJECT user;
{
int cnt=0;
UR_OBJECT user2;

if (!which) {
	for(user2=user_first;user2;user2=user2->next) {
		if (user2==user) continue;
		if (user2->port==port[2]) ++cnt;
		}
	if (cnt>1) {
		write_user(user,"Sorry, people are already talking on this port...\n");
		disconnect_user(user);
		return;
		}
	write_user(user,"Enter name to use (press enter to exit): ");
	user->misc_op=62;
	}
else {
	user->misc_op=0;
	strtolower(word[0]);
	word[0][0]=toupper(word[0][0]);
	sntrncpy(user->name,word[0],sizeof(user->name));
	for(user2=user_first;user2;user2=user2->next) {
		if (user2==user) continue;
		if (user2->port==port[2]) {
			user->talkready=1;
			user2->waiting=0;
			sntrncpy(word[1],user2->name,sizeof(word[1]));
			talk_to_me(user);
			return;
			}
		}
	write_user(user,"Waiting for connection...\n");
	user->waiting=1;
	}
}

/*** Move to another room ***/
void go(user)
UR_OBJECT user;
{
int i;
NL_OBJECT nl=user->room->netlink;
RM_OBJECT room;

if (word_count<2) {
	write_user(user,"Go where?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (nl && !strncmp(nl->service,word[1],strlen(word[1]))) {
	room=user->room;
	if (nl->stage<2) {
		write_user(user,"The netlink is inactive.\n");
		return;
		}
	if (nl->allow==IN && user->netlink!=nl) {
		write_user(user,"Sorry, link is for incoming users only.\n");
		return;
		}
	if (user->netlink==nl) {
		write_user(user,"You traverse cyberspace...\n");
		snprintf(text,sizeof(text),"REMVD %s\n",user->name);
		write_sock(nl->socket,text);
		if (user->vis) {
			snprintf(text,sizeof(text),"%s goes to the %s\n",user->name,nl->service);
			write_room_except(room,text,user,NULL,0,NULL);
			}
		else write_room_except(room,invisleave,user,NULL,0,NULL);
		snprintf(text,sizeof(text),"NETLINK: Remote user %s removed.\n",user->name);
		write_syslog(text,1);
		destruct_user(user,1);
		reset_access(room);
		--num_of_users;
		return;
		}
	if (user->type==REMOTE_TYPE) {
		write_user(user,"Sorry, due to software limitations you can only traverse 1 netlink.\n");
		return;
		}
	if (!user->gopass) {
		write_user(user,"Enter your password: ");
		echo_off(user);
		user->misc_op=47;
		user->listen_store=user->listen;
		user->listen=0;
		sntrncpy(user->inpstr_old,word[1],strlen(user->inpstr_old));
		return;
		}
	snprintf(text,sizeof(text),"TRANS %s %s %s\n",user->name,(char *)crypt(word[0],"NU"),user->desc);
	write_sock(nl->socket,text);
	user->remote_com=GO;
	return;
	}
if (user->frozen) {
	write_user(user,"You try to move but fail!\n");
	snprintf(text,sizeof(text),"%s tries to move but fails.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
if (user->bake) {
	write_user(user,"Sorry, you aren't done yet.\n");
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (!strcmp(word[1],"home")) {
	if (!(room=get_room2(user->homeroom))) {
		sntrncpy(user->homeroom,"crater",sizeof(user->homeroom));
		room=room_first;
		}
	if (!strcmp(room->name,"wizroom")) { move_user(user,room,6); return; }
	if (!strcmp(room->name,user->room->name)) {
		write_user(user,"You are already in your home room.\n");
		return;
		}
	move_user(user,room,1);
	return;
	}
if (!strncasecmp(word[1],"upstairs",strlen(word[1])) && (!strcmp(user->room->name,"storm_room") || user->level>=GENERAL)) {
	if ((room=get_room2("Innerspace"))) move_user(user,room,7);
	return;
	}
else if (!strncasecmp(word[1],"downstairs",strlen(word[1])) && (!strcmp(user->room->name,"Innerspace") || user->level>=GENERAL)) {
	if ((room=get_room2("storm_room"))) move_user(user,room,8);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
if (room==user->room) {
	snprintf(text,sizeof(text),"You are already in the %s!\n",room->name);
	write_user(user,text);
	return;
	}
if ((!strcmp(room->name,"AVALANCHE_WORLD") || !strcmp(room->name,"storm_room")) && ban_quitting) {
	write_user(user,"Sorry, can't let ya do that.\n");
	return;
	}
if (user->incomp) { incompgo(user); return; }
if (user->bounce) { bouncy(user); return; }
if (!strcmp(room->name,"wizroom")) { move_user(user,room,6); return; }
for(i=0;i<MAX_LINKS;++i) {
	if (user->room->link[i]==room) {
		if (!strcmp(room->name,"Ice_cavern")) move_user(user,room_first,9);
		else move_user(user,room,0);
		return;
		}
	}
if (user->level<CAPTAIN) {
	snprintf(text,sizeof(text),"The %s is not adjoined to here.\n",room->name);
	write_user(user,text);
	return;
	}
if (!strcmp(room->name,"Ice_cavern")) move_user(user,room_first,9);
else move_user(user,room,1);
}

/*** Called by go() and move() ***/
void move_user(user,room,teleport)
UR_OBJECT user;
RM_OBJECT room;
int teleport;
{
RM_OBJECT old_room=user->room;
UR_OBJECT user2;

if (!user->room || (user->room==room && teleport!=9) || !room) return;
if (user->level<GENERAL && old_room->level!=room->level && staythere) {
	look(user);
	prompt(user);
	return;
	}
if (teleport==6) {
	if (!user->wizroom) {
		write_user(user,"\nEnter the top-secret password (scmquit to abort): ");
		echo_off(user);
		user->misc_op=25;
		return;
		}
	else user->wizroom=0;
	}
if (teleport!=2 && (room->access & 1) && user->level<gatecrash_level && user->invite_room!=room && !((room->access & 2) && user->level>=COMMANDER)) {
	write_user(user,"The doors are locked, you cannot enter.\n");
	return;
	}
if (teleport==2 && user->room==room) return;
if (user->invite_room==room) user->invite_room=NULL;
if (user->hid && user->level>COLONEL) {
	for(user2=user_first;user2;user2=user2->next) {
		if (user2->level>=user->level && user2!=user && user->room==user2->room) {
			snprintf(text,sizeof(text),"%s sneaks out of the room.\n",user->name);
			write_user(user2,text);
			}
		}
	for(user2=user_first;user2;user2=user2->next) {
		if (user2->level>=user->level && user2!=user && room==user2->room) {
			snprintf(text,sizeof(text),"%s sneaks into the room.\n",user->name);
			write_user(user2,text);
			}
		}
	}
else if (!user->vis) {
	write_room(room,invisenter);
	write_room_except(user->room,invisleave,user,NULL,0,NULL);
	user->room=room;
	look(user);
	}
else if (teleport==1) {
	snprintf(text,sizeof(text),"~OL%s appears in an explosion of light!\n",user->morphed);
	write_room(room,text);
	snprintf(text,sizeof(text),"~OL%s chants a spell and vanishes into a magical vortex.\n",user->morphed);
	write_room_except(old_room,text,user,NULL,0,NULL);
	}
else if (teleport==2) {
	write_user(user,"\nA giant hand grabs you and pulls you through a rip in cyberspace!\n");
	snprintf(text,sizeof(text),"%s falls out of a rip in cyberspace!\n",user->morphed);
	write_room(room,text);
	if (!old_room) {
		snprintf(text,sizeof(text),"REL %s\n",user->name);
		write_sock(user->netlink->socket,text);
		user->netlink=NULL;
		}
	else {
		snprintf(text,sizeof(text),"A giant hand grabs %s who is pulled through a rip in cyberspace!\n",user->morphed);
		write_room_except(old_room,text,user,NULL,0,NULL);
		}
	}
else if (teleport==3) {
	write_user(user,"\nA giant hand delivers you via First class air mail!\n");
	snprintf(text,sizeof(text),"%s gets delivered via First class air mail!\n",user->morphed);
	write_room(room,text);
	if (!user->room) {
		snprintf(text,sizeof(text),"REL %s\n",user->name);
		write_sock(user->netlink->socket,text);
		user->netlink=NULL;
		}
	snprintf(text,sizeof(text),"A giant hand delivers %s via First class air mail!\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	}
else if (teleport==4) {
	write_user(user,"\nA giant hand sends you to the Brig!\n");
	snprintf(text,sizeof(text),"%s gets arrested and sent to the Brig!\n",user->morphed);
	write_room(room,text);
	if (!user->room) {
		snprintf(text,sizeof(text),"REL %s\n",user->name);
		write_sock(user->netlink->socket,text);
		user->netlink=NULL;
		}
	snprintf(text,sizeof(text),"A giant hand sends %s to the Brig!\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	}
else if (teleport==5) {
	write_user(user,"\nA giant hand sends you to the Brig!\n");
	snprintf(text,sizeof(text),"%s gets sent to the Brig for swearing!\n",user->morphed);
	write_room(room,text);
	if (!user->room) {
		snprintf(text,sizeof(text),"REL %s\n",user->name);
		write_sock(user->netlink->socket,text);
		user->netlink=NULL;
		}
	snprintf(text,sizeof(text),"A giant hand sends %s to the Brig!\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	}
else if (teleport==6) {
	if (old_room) {
		snprintf(text,sizeof(text),"~OL%s chants a spell and vanishes into a magical vortex.\n",user->morphed);
		write_room_except(old_room,text,user,NULL,0,NULL);
		}
	snprintf(text,sizeof(text),"~OL%s appears in an explosion of light!\n",user->morphed);
	write_room(room,text);
	}
else if (teleport==7) {
	write_user(user,"You begin to climb a long flight of stairs. You can see a small hole\nin the distance. You wonder what awaits you...\n");
	snprintf(text,sizeof(text),"%s disappears into the darkness.\nOff in the distance, an alarm clock goes off.\n",user->morphed);
	write_room_except(old_room,text,user,NULL,0,NULL);
	snprintf(text,sizeof(text),"%s arrives and collapses from having just climbed a huge staircase.\nOff in the distance, a system crashes, running Windows 95.\n",user->morphed);
	write_room_except(room,text,user,NULL,0,NULL);
	}
else if (teleport==8) {
	write_user(user,"You go tumbling down a long flight of stairs and land hard on the ground\nwith a loud *THUMP*\n");
	snprintf(text,sizeof(text),"%s goes tumbling down a huge flight of stairs.\nOff in the distance, you hear a scream.\n",user->morphed);
	write_room_except(old_room,text,user,NULL,0,NULL);
	snprintf(text,sizeof(text),"%s tumbles in and lands on the ground with a loud *THUMP*\nOff in the distance, a wolf howls.\n",user->morphed);
	write_room_except(room,text,user,NULL,0,NULL);
	}
else if (teleport==9) {
	if (user->level<GENERAL && old_room->level!=room->level && staythere) return;
	write_user(user,"You have begun sliding down the cavern!\n\nYou feel as if you are out of control!\n");
	snprintf(text,sizeof(text),"\07%s is sliding down the Ice cavern.\n",user->morphed);
	write_room_except(old_room,text,user,NULL,0,NULL);
	slide(user);
	snprintf(text,sizeof(text),"%s slides in from the Ice cavern.\n",user->morphed);
	write_room_except(room,text,user,NULL,0,NULL);
	write_user(user,"~LI~FRNow wasn't that fun?\n");
	snprintf(text,sizeof(text),"%s slid down the Ice cavern.\n",user->name);
	write_syslog(text,1);
	}
else {
	snprintf(text,sizeof(text),"%s %s.\n",user->morphed,user->in_phrase);
	write_room(room,text);
	if (room->access==HIDDEN) snprintf(text,sizeof(text),"%s %s to the *?*.\n",user->morphed,user->out_phrase);
	else snprintf(text,sizeof(text),"%s %s to the %s.\n",user->morphed,user->out_phrase,room->name);
	write_room_except(user->room,text,user,NULL,0,NULL);
	}
user->room=room;
if ((user2=get_user(user->draggee,0))) move_user(user2,user->room,teleport);
if ((user2=get_user(user->stalker,0))) move_user(user2,user->room,teleport);
if (!strcmp(old_room->name,"Dark_room") && user->level<GENERAL) echo_on(user,0);
if (!strcmp(user->room->name,"Dark_room") && user->level<GENERAL) echo_off(user);
if (user->jeep) {
	if (user->jeepcnt==user->jeeprooms) {
		user->jeeptime=time(0);
		user->jeep=0;
		user->jeeprooms=0;
		}
	else { user->jeeptime=time(0); ++user->jeepcnt; }
	}
look(user);
prompt(user);
reset_access(old_room);
}

/*** Slide ***/
void slide(user)
UR_OBJECT user;
{
int i;
RM_OBJECT room;

if (!(room=get_room2("Ice_cavern"))) return;
user->room=room;
for(i=0;i<8;++i) {
	look(user);
	write_user(user,"Whoa.....................................\n");
	}
}

/*** Set in and out phrases ***/
void set_iophrase(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (strlen(inpstr)>PHRASE_LEN) {
	write_user(user,"Phrase too long.\n");
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (com_num==INPHRASE) {
	if (word_count<2) {
		snprintf(text,sizeof(text),"Your current in phrase is: %s\n",user->in_phrase);
		write_user(user,text);
		return;
		}
	if (!strcmp(inpstr,user->in_phrase)) {
		write_user(user,"In phrase already set to that.\n");
		return;
		}
	sntrncpy(user->in_phrase,inpstr,sizeof(user->in_phrase));
	write_user(user,"In phrase set.\n");
	return;
	}
if (word_count<2) {
	snprintf(text,sizeof(text),"Your current out phrase is: %s\n",user->out_phrase);
	write_user(user,text);
	return;
	}
if (!strcmp(inpstr,user->out_phrase)) {
	write_user(user,"Out phrase already set to that.\n");
	return;
	}
sntrncpy(user->out_phrase,inpstr,sizeof(user->out_phrase));
write_user(user,"Out phrase set.\n");
}

/*** Set in phrase via the set command ***/
void inphrset(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (!word_count) write_user(user,"Try again.\n");
else if (ban_swearing && contains_swearing(inpstr)) if (swore(user)) return;
else if (strlen(inpstr)>PHRASE_LEN) write_user(user,"Phrase too long.\n");
else if (!strcmp(inpstr,user->in_phrase)) write_user(user,"In phrase already set to that.\n");
else {
	sntrncpy(user->in_phrase,inpstr,sizeof(user->in_phrase));
	write_user(user,"In phrase set.\n");
	}
user->misc_op=26;
redrawset(user);
}

/*** Set out phrase via the set command ***/
void outphrset(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (!word_count) write_user(user,"Try again.\n");
else if (ban_swearing && contains_swearing(inpstr)) if (swore(user)) return;
else if (strlen(inpstr)>PHRASE_LEN) write_user(user,"Phrase too long.\n");
else if (!strcmp(inpstr,user->out_phrase)) write_user(user,"Out phrase already set to that.\n");
else {
	sntrncpy(user->out_phrase,inpstr,sizeof(user->out_phrase));
	write_user(user,"Out phrase set.\n");
	}
user->misc_op=26;
redrawset(user);
}

/*** Set in and out phrases for another user ***/
void set_oiophrase(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
UR_OBJECT user2;

if (word_count<3) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user> <phrase>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user> <phrase>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	if (com_num==OINPHR) write_user(user,"Umm, use the inphr command please.\n");
	else write_user(user,"Umm, use the outphr command please.\n");
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"Hmm .. inadvisable.\n");
	if (com_num==OINPHR) snprintf(text,sizeof(text),"%s tried to change your in phrase!\n",user->name);
	else snprintf(text,sizeof(text),"%s tried to change your out phrase!\n",user->name);
	write_user(user2,text);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (strlen(inpstr)>PHRASE_LEN) {
	write_user(user,"Phrase too long.\n");
	return;
	}
if (com_num==OINPHR) {
	if (!strcmp(inpstr,user2->in_phrase)) {
		write_user(user,"In phrase already set to that.\n");
		return;
		}
	sntrncpy(user2->in_phrase,inpstr,sizeof(user->in_phrase));
	write_user(user,"In phrase set.\n");
	return;
	}
if (!strcmp(inpstr,user2->out_phrase)) {
	write_user(user,"Out phrase already set to that.\n");
	return;
	}
sntrncpy(user2->out_phrase,inpstr,sizeof(user->out_phrase));
write_user(user,"Out phrase set.\n");
}

/*** Set rooms to public or private ***/
void set_room_access(user)
UR_OBJECT user;
{
char *name;
int cnt=0;
RM_OBJECT room=user->room;
UR_OBJECT user2;

if (room->access>PRIVATE) {
	write_user(user,"This room's access is fixed.\n");
	return;
	}
if (com_num==PUBCOM && room->access==PUBLIC) {
	write_user(user,"The room is already public.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (com_num==PRIVCOM) {
	if (room->access==PRIVATE) {
		write_user(user,"The room is already private.\n");
		return;
		}
	for(user2=user_first;user2;user2=user2->next) if (user2->room==room) ++cnt;
	if (cnt<min_private_users && user->level<ignore_mp_level) {
		snprintf(text,sizeof(text),"You need at least %d people in a room before it can be made private.\n",min_private_users);
		write_user(user,text);
		return;
		}
	write_user(user,"Door locked.\n");
	snprintf(text,sizeof(text),"%s locks the door.\n",name);
	write_room_except(room,text,user,NULL,0,NULL);
	room->access=PRIVATE;
	return;
	}
write_user(user,"Door unlocked.\n");
snprintf(text,sizeof(text),"%s has unlocked the door.\n",name);
write_room_except(room,text,user,NULL,0,NULL);
room->access=PUBLIC;
for(user2=user_first;user2;user2=user2->next) if (user2->invite_room==room) user2->invite_room=NULL;
clear_conv(room);
}

/*** Ask to be let into a private room ***/
void letmein(user)
UR_OBJECT user;
{
char *name;
int i,j=0;
RM_OBJECT room;

if (word_count<2) {
	write_user(user,"Let you into where?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
if (room==user->room) {
	snprintf(text,sizeof(text),"You are already in the %s!\n",room->name);
	write_user(user,text);
	return;
	}
for(i=0;i<MAX_LINKS;++i) if (user->room->link[i]==room) { ++j; break; }
if (!j) {
	snprintf(text,sizeof(text),"The %s is not adjoined to here.\n",room->name);
	write_user(user,text);
	return;
	}
if (!(room->access & 1)) {
	snprintf(text,sizeof(text),"The %s is currently public.\n",room->name);
	write_user(user,text);
	return;
	}
snprintf(text,sizeof(text),"You knock on the %s door.\n",room->name);
write_user(user,text);
if (user->vis) name=user->morphed; else name=invisname;
snprintf(text,sizeof(text),"%s knocks on the %s door.\n",name,room->name);
write_room_except(user->room,text,user,NULL,0,NULL);
snprintf(text,sizeof(text),"*KNOCK* *KNOCK* %s knocks on the door.\n",name);
write_room(room,text);
}

/*** Invite a user into a private room ***/
void invite(user)
UR_OBJECT user;
{
char *name;
RM_OBJECT room=user->room;
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Invite who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room->access & 1)) {
	write_user(user,"This room is currently public.\n");
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Inviting yourself to somewhere is the third sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user2->room) {
	if (room->level!=user2->room->level && user->level<GENERAL) {
		write_user(user,nosuchroom);
		return;
		}
	}
if (room->access==HIDDEN) {
	write_user(user,"You can't invite anyone to this room!\n");
	return;
	}
if (user2->room==room) {
	snprintf(text,sizeof(text),"%s is already here!\n",user2->name);
	write_user(user,text);
	return;
	}
if (user2->invite_room==room) {
	snprintf(text,sizeof(text),"%s has already been invited into here.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
snprintf(text,sizeof(text),"You invite %s in.\n",user2->morphed);
write_user(user,text);
if (user->vis) name=user->morphed; else name=invisname;
snprintf(text,sizeof(text),"%s has invited you into the %s.\n",name,room->name);
write_user(user2,text);
user2->invite_room=room;
}

/*** Set the room topic ***/
void set_topic(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char *name;
RM_OBJECT room=user->room;

if (word_count<2) {
	if (!strlen(room->topic)) {
		write_user(user,"No topic has been set yet.\n");
		return;
		}
	snprintf(text,sizeof(text),"The current topic is: %s\n",room->topic);
	write_user(user,text);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (word_count>2 && !strcmp(word[1],"annoy")) {
	inpstr=remove_first(inpstr);
	annoy_topic(inpstr);
	}
if (strlen(inpstr)>TOPIC_LEN) {
	write_user(user,"Topic too long.\n");
	return;
	}
snprintf(text,sizeof(text),"Topic set to: %s\n",inpstr);
write_user(user,text);
if (user->vis) name=user->morphed; else name=invisname;
snprintf(text,sizeof(text),"%s has set the topic to: %s\n",name,inpstr);
write_room_except(room,text,user,NULL,0,NULL);
sntrncpy(room->topic,inpstr,sizeof(room->topic));
}

/*** Wizard moves a user to another room ***/
void move(user)
UR_OBJECT user;
{
char *name;
RM_OBJECT room,old_room;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user> [<room>]\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user> [<room>]\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (!strncasecmp(word[2],"upstairs",strlen(word[2])) && word_count>2 && !staythere) {
	if ((room=get_room2("Innerspace"))) {
		if (room->level!=user2->room->level)
			write_user(user2,"You begin to climb a long flight of stairs. You can see a small hole\nin the distance. You wonder what awaits you...\n");
		else {
			snprintf(text,sizeof(text),"%s is already on that level.\n",user2->name);
			write_user(user,text);
			return;
			}
		write_user(user,"You chant an ancient spell...\n");
		snprintf(text,sizeof(text),"%s disappears into the darkness.\nOff in the distance, an alarm clock goes off.\n",user2->morphed);
		write_room_except(user2->room,text,user2,NULL,0,NULL);
		old_room=user2->room;
		user2->room=room;
		snprintf(text,sizeof(text),"%s arrives and collapses from having just climbed a huge staircase.\nOff in the distance, a system crashes, running Windows 95.\n",user2->morphed);
		write_room_except(user2->room,text,user2,NULL,0,NULL);
		snprintf(text,sizeof(text),"%s moved %s to the %s.\n",user->name,user2->name,room->name);
		write_syslog(text,1);
		look(user2); prompt(user2);
		reset_access(old_room);
		}
	return;
	}
else if (!strncasecmp(word[2],"downstairs",strlen(word[2])) && word_count>2 && !staythere) {
	if ((room=get_room2("storm_room"))) {
		if (room->level!=user2->room->level)
			write_user(user2,"You go tumbling down a long flight of stairs and land hard on the ground\nwith a loud *THUMP*\n");
		else {
			snprintf(text,sizeof(text),"%s is already on that level.\n",user2->name);
			write_user(user,text);
			return;
			}
		write_user(user,"You chant an ancient spell...\n");
		snprintf(text,sizeof(text),"%s goes tumbling down a huge flight of stairs.\nOff in the distance, you hear a scream.\n",user2->morphed);
		write_room_except(user2->room,text,user2,NULL,0,NULL);
		old_room=user2->room;
		user2->room=room;
		snprintf(text,sizeof(text),"%s tumbles in and lands on the ground with a loud *THUMP*\nOff in the distance, a wolf howls.\n",user2->morphed);
		write_room_except(user2->room,text,user2,NULL,0,NULL);
		snprintf(text,sizeof(text),"%s moved %s to the %s.\n",user->name,user2->name,room->name);
		write_syslog(text,1);
		look(user2); prompt(user2);
		reset_access(old_room);
		}
	return;
	}
if (word_count<3) room=user->room;
else if (!(room=get_room(user,word[2]))) return;
if (user2==user) {
	write_user(user,"Trying to move yourself this way is the fourth sign of madness.\n");
	return;
	}
if (room==user2->room) {
	snprintf(text,sizeof(text),"%s is already in the %s.\n",user2->name,room->name);
	write_user(user,text);
	return;
	}
if ((user2->level>=user->level && strcmp(user2->name,"Lilmouse")) || (!strcmp(user2->name,"Lilmouse") && user->level<GENERAL)) {
	write_user(user,"Hmm .. inadvisable.\n");
	snprintf(text,sizeof(text),"%s thought about moving you.\n",user->name);
	write_user(user2,text);
	return;
	}
if (user2->frozen) {
	snprintf(text,sizeof(text),"%s is frozen to the spot by a magic charm.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user2->dark) {
	snprintf(text,sizeof(text),"Sorry, %s is in the dark.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user2->bake) {
	snprintf(text,sizeof(text),"%s is still being cooked.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user2->committed) {
	snprintf(text,sizeof(text),"Sorry, but %s is psycho and a threat to society.\n",user2->name);
	write_user(user,text);
	return;
	}
if ((room->access & 1) && user2->level<gatecrash_level && user2->invite_room!=room) {
	if (!((room->access & 2) && user2->level>=COMMANDER)) {
		snprintf(text,sizeof(text),"The %s is currently private, %s cannot be moved there.\n",room->name,user2->name);
		write_user(user,text);
		return;
		}
	}
if ((!strcmp(room->name,"AVALANCHE_WORLD") || !strcmp(room->name,"Ice_cavern")) && user2->type==REMOTE_TYPE) {
	snprintf(text,sizeof(text),"Sorry, can't move %s to that room.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user2->room) {
	if (user->level<COLONEL && (!(user2->room->access & 1))) {
		snprintf(text,sizeof(text),"Can't move %s out of a private room.\n",user2->name);
		write_user(user,text);
		return;
		}
	}
if (!strcmp(room->name,"AVALANCHE_WORLD") && user->level<COLONEL) {
	snprintf(text,sizeof(text),"Sorry, can't move %s to that room.\n",user2->name);
	write_user(user,text);
	return;
	}
write_user(user,"You chant an ancient spell...\n");
if (user->vis) name=user->morphed; else name=invisname;
snprintf(text,sizeof(text),"%s chants an ancient spell...\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
move_user(user2,room,2);
snprintf(text,sizeof(text),"%s moved %s to the %s.\n",user->name,user2->name,room->name);
write_syslog(text,1);
}

/*** Wizard moves all users to another room ***/
void moveall(user)
UR_OBJECT user;
{
char *name;
int cnt=0;
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<2) room=user->room;
else if (!(room=get_room(user,word[1]))) return;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->room==room || user2->level>=user->level || user2->login || user2->type==CLONE_TYPE || user2->dark || user2->frozen || user2->bake || user2->committed) continue;
	if (user2->room) if (user2->room->level!=user->room->level && user->level<GENERAL) continue;
	if (++cnt==1) {
		write_user(user,"You chant an ancient spell...\n");
		if (user->vis) name=user->morphed; else name=invisname;
		snprintf(text,sizeof(text),"%s chants an ancient spell...\n",name);
		write_room_except(user->room,text,user,NULL,0,NULL);
		}
	move_user(user2,room,2);
	}
if (!cnt) write_user(user,"No users to move.\n");
}

/*** Broadcast an important message ***/
void bcast(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <message>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <message>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
force_listen=1;
snprintf(text,sizeof(text),"\n\07\07*>( %s )<*\n\n",inpstr);
if (user->level>=GENERAL) write_room(NULL,text);
else write_room_except(NULL,text,user,NULL,1,user);
}

/*** Do a short who ***/
void users(user)
UR_OBJECT user;
{
char temp[25],userstr[6];
int cnt=0,invis=0;
UR_OBJECT user2;

snprintf(text,sizeof(text),"%s\n",PTSTR);
write_user(user,text);
snprintf(text,sizeof(text),"*** Current users on %s, %s %d, %02d:%02d %s ***\n",day[twday],month[tmonth],tmday,ttime,tmin,md);
sntrncpy(text,center(text,80),sizeof(text));
write_user(user,text);
write_user(user,"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
text[0]='\0';
for(user2=user_first;user2;user2=user2->next) {
	if (!strcmp(user2->name,"Lilmouse") || !user2->vis || user2->hid) { ++invis; continue; }
	if (user2->login || user2->type==CLONE_TYPE) continue;
	if (user->room && user2->room) if (user2->room->level!=user->room->level && user->level<GENERAL) continue;
	snprintf(temp,sizeof(temp),"%-*s ",USER_NAME_LEN,user2->morphed);
	strncat(text,temp,sizeof(text));
	if (++cnt==5) {
		strncat(text,"\n",sizeof(text));  write_user(user,text);
		text[0]='\0'; cnt=0;
		}
	}
if (cnt) { strncat(text,"\n",sizeof(text)); write_user(user,text); }
if (num_of_users-invis==1) sntrncpy(userstr,"user",sizeof(userstr));
else sntrncpy(userstr,"users",sizeof(userstr));
snprintf(text,sizeof(text),"\nTotal of %d %s signed on.\n%s",num_of_users-invis,userstr,PTSTR);
write_user(user,text);
}

/*** Show who is on ***/
void who(user,people)
UR_OBJECT user;
int people;
{
char line[USER_NAME_LEN+USER_DESC_LEN+4],minutes[8],text2[200];
char rname[ROOM_NAME_LEN+1];
char afker[6],col_level[20],doing[10],idlestr[6],ports[5],type[5];
char users1[6],users2[6];
int hid=0,i,idletime,invis=0,mins,remote,temp,tm,tm2,total=0;
int align,align2,align3,cnt,cnt2,cnt3,colorstr,ol=0;
RM_OBJECT room;
UR_OBJECT user2;

if (user->color) {
	if (get_color(user,1) || user->colorize || user->woohoo || user->annoy || allcolor[0]) colorstr=1;
	else colorstr=0;
	if (!people && !colorstr) {
		write_user(user,"~BW                                                                                \n");
		if (!user->room->level) write_user(user,"~BW  ~BB                                                                            ~BW  \n");
		else write_user(user,"~BW  ~BM                                                                            ~BW  \n");
		}
	else {
		i=rand()%3;
		if (colorstr) {
			snprintf(text,sizeof(text),"%s                                                                                \n",user->colstr);
			write_user(user,text);
			}
		else if (!user->room->level) {
			if (!i || i==1) write_user(user,"~BR                                                                                \n");
			else write_user(user,"~BB                                                                                \n");
			}
		else {
			if (!i || i==1) write_user(user,"~BG                                                                                \n");
			else write_user(user,"~BM                                                                                \n");
			}
		}
	}
else write_user(user,PTSTR);
if (!people && user->color && !colorstr) {
	if (!user->tdiff) {
		if (!user->room->level) snprintf(text2,sizeof(text2),"~RS~BB~OL~FB*** Current users on %s %s %d %02d:%02d %s ***",day[twday],month[tmonth],tmday,ttime,tmin,md);
		else snprintf(text2,sizeof(text2),"~RS~BM~OL~FM*** Current users on %s %s %d %02d:%02d %s ***",day[twday],month[tmonth],tmday,ttime,tmin,md);
		}
	else {
		if (!user->room->level) snprintf(text2,sizeof(text2),"~RS~BB~OL~FB*** Current users on %s %s %d %02d:%02d %s ***",day[user->twday],month[user->tmonth],user->tmday,user->ttime,user->tmin,user->md);
		else snprintf(text2,sizeof(text2),"~RS~BM~OL~FM*** Current users on %s %s %d %02d:%02d %s ***",day[user->twday],month[user->tmonth],user->tmday,user->ttime,user->tmin,user->md);
		}
	align=76-strlen(text2);
	align+=color_com_count(text2,0)*3;
	align2=align/2;
	text[0]='\0';
	if (!user->room->level) {
		strncat(text,"~RS~BW  ~BB",sizeof(text));
		for(align3=0;align3<align2;++align3) strncat(text," ",sizeof(text));
		strncat(text,text2,sizeof(text));
		for(align3=align-align3;align3;--align3) strncat(text," ",sizeof(text));
		strncat(text,"~RS~BK ~BW \n",sizeof(text));
		}
	else {
		strncat(text,"~RS~BW  ~BM",sizeof(text));
		for(align3=0;align3<align2;++align3) strncat(text," ",sizeof(text));
		strncat(text,text2,sizeof(text));
		for(align3=align-align3;align3;--align3) strncat(text," ",sizeof(text));
		strncat(text,"~RS~BK ~BW \n",sizeof(text));
		}
	}
else {
	if (!user->tdiff) snprintf(text,sizeof(text),"\n~BM~OL~FT*** Current users on %s, %s %d, %02d:%02d %s ***\n\n",day[twday],month[tmonth],tmday,ttime,tmin,md);
	else snprintf(text,sizeof(text),"\n~BM~OL~FT*** Current users on %s, %s %d, %02d:%02d %s ***\n\n",day[user->twday],month[user->tmonth],user->tmday,user->ttime,user->tmin,user->md);
	sntrncpy(text,center(text,80),sizeof(text));
	}
write_user(user,text);
if (!people && user->color && !colorstr) {
	if (!user->room->level) write_user(user,"~BW  ~BB                                                                       ~BB     ~BK ~BW \n");
	else write_user(user,"~BW  ~BM                                                                       ~BM     ~BK ~BW \n");
	}
if (people) { write_user(user,"Name            : Level Line Lstn Visi Idle  Mins  Port  Site/Service\n\n");
	write_user(user,"\n");
	}
if (!people) {
	for(room=room_first;room;room=room->next) {
		temp=0;
		for(user2=user_first;user2;user2=user2->next) {
			if (user2->type==CLONE_TYPE || user2->login) continue;
			if (user2->room!=room) continue;
			if (user->room && user2->room) if (user2->room->level!=user->room->level) { ++ol; continue; }
			if (user2->hid) { ++hid; continue; }
			afker[0]='\0';
			if (user2->afk) sntrncpy(afker,"AFK",sizeof(afker));
			mins=(int)(time(0)-user2->last_login)/60;
			idletime=(int)(time(0)-user2->last_input)/60;
			++total;
			if (mins==1) sntrncpy(minutes,"min ",sizeof(minutes));
			else if (mins>=10000) sntrncpy(minutes,"mns",sizeof(minutes));
			else sntrncpy(minutes,"mins",sizeof(minutes));
			switch(user2->level) {
				case AWOL: sntrncpy(col_level,"AWOL ",sizeof(col_level));  break;
				case PRIVATE: sntrncpy(col_level,"Private ",sizeof(col_level));  break;
				case CORPORAL: sntrncpy(col_level,"~OL~FGCorporal~RS ",sizeof(col_level));  break;
				case CAPTAIN: sntrncpy(col_level,"~OL~FBCaptain~RS ",sizeof(col_level));  break;
				case COLONEL: sntrncpy(col_level,"~OL~FYColonel~RS ",sizeof(col_level));  break;
				case COMMANDER: sntrncpy(col_level,"~FMCommander~RS ",sizeof(col_level));  break;
				case GENERAL: sntrncpy(col_level,"~FRGeneral~RS ",sizeof(col_level));  break;
				default: sntrncpy(col_level,"* ",sizeof(col_level));
				}
			if (user2->type==REMOTE_TYPE) ++remote;
			if (!user2->vis) {
				++invis;
				if (user2->level>=user->level) continue;
				}
			snprintf(line,sizeof(line),"  %s %s",user2->morphed,user2->desc);
			if (!user2->vis) line[0]='*';
			if (user2->type==REMOTE_TYPE) line[1]='@';
			if (!room) sntrncpy(rname,"<offsite>:",sizeof(rname));
			if (room->access==HIDDEN) sntrncpy(rname,"*?*:",sizeof(rname));
			else snprintf(rname,sizeof(rname),"%s:",room->name);
			doing[0]='\0';
			switch(user2->misc_op) {
				case 1: sntrncpy(doing," Shutdown",sizeof(doing));  break;
				case 2: sntrncpy(doing,"  Reading",sizeof(doing));  break;
				case 3: sntrncpy(doing,"  Writing",sizeof(doing));  break;
				case 4: sntrncpy(doing,"     Mail",sizeof(doing));  break;
				case 5: sntrncpy(doing,"  Profile",sizeof(doing));  break;
				case 8: sntrncpy(doing,"  Suicide",sizeof(doing));  break;
				case 9: sntrncpy(doing,"    Fmail",sizeof(doing));  break;
				case 10: sntrncpy(doing,"Rebooting",sizeof(doing));  break;
				case 11: sntrncpy(doing,"  Suggest",sizeof(doing));  break;
				case 12: sntrncpy(doing,"Complaint",sizeof(doing));  break;
				case 26: sntrncpy(doing," Set menu",sizeof(doing));  break;
				case 35: sntrncpy(doing,"Quiz time",sizeof(doing));  break;
				case 46: sntrncpy(doing,"  Pasting",sizeof(doing));  break;
				case 62: sntrncpy(doing,"  Hangman",sizeof(doing));  break;
				case 68: sntrncpy(doing,"      Bog",sizeof(doing));
				}
			sntrncpy(line,color_com_strip(line),sizeof(line));
			cnt=color_com_count(line,0);
			if (!colorstr) sntrncpy(col_level,color_com_strip(col_level),sizeof(col_level));
			cnt2=color_com_count(col_level,0);
			if (name_count(line,0)>3) sntrncpy(line,name_strip(line),sizeof(line));
			cnt3=name_count(line,0);
			if (!temp) {
				if (colorstr) snprintf(text,sizeof(text),"~OL~FT%-21s\n",rname);
				else if (user->color) {
					if (!user->room->level) snprintf(text,sizeof(text),"~BW  ~RS~BB~OL~FT%-21s                                                       ~BK ~BW \n",rname);
					else snprintf(text,sizeof(text),"~BW  ~RS~BM~FB%-21s                                                       ~BK ~BW \n",rname);
					}
				else snprintf(text,sizeof(text),"%-21s\n",rname);
				write_user(user,text);
				++temp;
				}
			tm=(int)(time(0)-user2->last_input)/60;
			tm2=(int)(time(0)-user2->afktime)/60;
			idlestr[0]='\0';
			if (tm>=2 && !user2->afk) sntrncpy(idlestr,"IDLE",sizeof(idlestr));
			if (user->color && !colorstr) {
				if (!strcmp(idlestr,"IDLE") && !user2->malloc_start) {
					if (!user->room->level) snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB    ~LI~FR%s~RS~BB ~OL~FY%-3d~RS~BB ~FRof~RS~BB  ~OL~FG%-4d~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,idlestr,tm,mins);
					else snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM    ~LI~FR%s~RS~BM ~OL~FT%-3d~RS~BM ~FRof~RS~BM  ~OL~FG%-4d~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,idlestr,tm,mins);
					}
				else if (user2->afk) {
					if (!user->room->level) snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB     ~OL~FM%s~RS~BB ~OL~FY%-3d~RS~BB ~FRof~RS~BB  ~OL~FG%-4d~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,afker,tm2,mins);
					else snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM     ~OL~FG%s~RS~BM ~OL~FT%-3d~RS~BM ~FRof~RS~BM  ~OL~FG%-4d~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,afker,tm2,mins);
					}
				else {
					if (!user->room->level) snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB  %-9s ~OL~FY%-4d~RS~BB ~FK%s~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,doing,mins,minutes);
					else snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM  %-9s ~OL~FG%-4d~RS~BM ~FK%s~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,doing,mins,minutes);
					}
				write_user(user,text);
				}
			else if (colorstr) {
				if (!strcmp(idlestr,"IDLE") && !user2->malloc_start) snprintf(text,sizeof(text),"%-*s  %-*s          ~LI~FR%s~RS %d/%d\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,idlestr,tm,mins);
				else if (user2->afk) snprintf(text,sizeof(text),"%-*s  %-*s           ~OL~FM%s~RS %d/%d\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,afker,tm2,mins);
				else snprintf(text,sizeof(text),"%-*s  %-*s  %-9s     %-4d %s\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,doing,mins,minutes);
				write_user(user,text);
				}
			else {
				if (!strcmp(idlestr,"IDLE") && !user2->malloc_start) snprintf(text,sizeof(text),"%-*s  %-*s          %s %d/%d\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,idlestr,tm,mins);
				else if (user2->afk) snprintf(text,sizeof(text),"%-*s  %-*s           %s %d/%d\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,afker,tm2,mins);
				else snprintf(text,sizeof(text),"%-*s  %-*s  %-9s     %-4d %s\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,doing,mins,minutes);
				write_user(user,text);
				}
			}
		}
	temp=0;
	for(user2=user_first;user2;user2=user2->next) {
		if (user2->login || user2->room || user2->type==CLONE_TYPE) continue;
		afker[0]='\0';
		if (user2->afk) sntrncpy(afker,"(AFK)",sizeof(afker));
		mins=(int)(time(0)-user2->last_login)/60;
		idletime=(int)(time(0)-user2->last_input)/60;
		++total;
		switch(user2->level) {
			case AWOL: sntrncpy(col_level,"AWOL ",sizeof(col_level));  break;
			case PRIVATE: sntrncpy(col_level,"Private ",sizeof(col_level));  break;
			case CORPORAL: sntrncpy(col_level,"~OL~FGCorporal~RS ",sizeof(col_level));  break;
			case CAPTAIN: sntrncpy(col_level,"~OL~FBCaptain~RS ",sizeof(col_level));  break;
			case COLONEL: sntrncpy(col_level,"~OL~FYColonel~RS ",sizeof(col_level));  break;
			case COMMANDER: sntrncpy(col_level,"~FMCommander~RS ",sizeof(col_level));  break;
			case GENERAL: sntrncpy(col_level,"~FRGeneral~RS ",sizeof(col_level));  break;
			default: sntrncpy(col_level,"* ",sizeof(col_level));
			}
		snprintf(line,sizeof(line),"  %s %s",user2->morphed,user2->desc);
		sntrncpy(line,color_com_strip(line),sizeof(line));
		cnt=color_com_count(line,0);
		sntrncpy(col_level,color_com_strip(col_level),sizeof(col_level));
		cnt2=color_com_count(col_level,0);
		if (name_count(line,0)>3) sntrncpy(line,name_strip(line),sizeof(line));
		cnt3=name_count(line,0);
		if (!temp) {
			if (user->color && !colorstr) {
				if (!user->room->level) write_user(user,"~BW  ~BB~OL~FT<offsite>~RS~BB                                                                   ~BK ~BW \n");
				else write_user(user,"~BW  ~BM~FB<offsite>~RS~BM                                                                   ~BK ~BW \n");
				}
			else write_user(user,"<offsite>\n");
			++temp;
			}
		if (user->color && !colorstr) {
			if (!user->room->level) {
				if (mins==1) snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB       ~OL~FY%-3d~RS~BB  ~FKmin ~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,mins);
				else snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB       ~OL~FY%-3d~RS~BB  ~FKmins~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,mins);
				}
			else {
				if (mins==1) snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM       ~OL~FG%-3d~RS~BM  ~FKmin ~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,mins);
				else snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM       ~OL~FG%-3d~RS~BM  ~FKmins~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,mins);
				}
			}
		else snprintf(text,sizeof(text),"%-*s  %-*s  %-8s  %-3d mins.\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,doing,mins);
		write_user(user,text);
		}
	}
else {
	for(user2=user_first;user2;user2=user2->next) {
		if (user2->type==CLONE_TYPE || user2->level>user->level) continue;
		if (!user2->login) mins=(int)(time(0)-user2->last_login)/60;
		else mins=(int)(time(0)-user2->logintime)/60;
		idletime=(int)(time(0)-user2->last_input)/60;
		switch(user2->level) {
			case AWOL: sntrncpy(type,"AWL ",sizeof(type));  break;
			case PRIVATE: sntrncpy(type,"PVT ",sizeof(type));  break;
			case CORPORAL: sntrncpy(type,"CPL ",sizeof(type));  break;
			case CAPTAIN: sntrncpy(type,"CAP ",sizeof(type));  break;
			case COLONEL: sntrncpy(type,"COL ",sizeof(type));  break;
			case COMMANDER: sntrncpy(type,"CMD ",sizeof(type));  break;
			case GENERAL: sntrncpy(type,"GEN ",sizeof(type));  break;
			default: sntrncpy(type,"*   ",sizeof(type));
			}
		if (user2->type==REMOTE_TYPE) sntrncpy(ports,"   -",sizeof(ports));
		else {
			if (user2->port==port[0]) sntrncpy(ports,"MAIN",sizeof(ports));
			else if (user2->port==port[2]) sntrncpy(ports,"TALK",sizeof(ports));
			else sntrncpy(ports," WIZ",sizeof(ports));
			}
		if (user2->port==port[2]) {
			snprintf(text,sizeof(text),"[Talking......] :       %4d           %4d %5d  %-2s  %-2s\n",user2->socket,idletime,mins,ports,user2->site);
			write_user(user,text);
			continue;
			}
		else if (user2->login) {
			snprintf(text,sizeof(text),"[Login stage %d] :       %4d           %4d %5d  %-2s  %-2s\n",user2->login,user2->socket,idletime,mins,ports,user2->site);
			write_user(user,text);
			continue;
			}
		++total;
		if (user2->type==REMOTE_TYPE) ++remote;
		if (!user2->vis) ++invis;
		snprintf(text,sizeof(text),"%-*s :  %2s  %3d  %3s  %-2s %4d %5d  %-2s  %-2s\n",USER_NAME_LEN,user2->name,type,user2->socket,noyes1[user2->listen],noyes1[user2->vis],idletime,mins,ports,user2->site);
		write_user(user,text);
		continue;
		}
	}
if (remote==1) sntrncpy(users1,"user",sizeof(users1));
else sntrncpy(users1,"users",sizeof(users1));
if (total==1) sntrncpy(users2,"user",sizeof(users2));
else sntrncpy(users2,"users",sizeof(users2));
if (people || !user->color || colorstr) {
	if ((num_of_users-invis-hid-ol)==1) snprintf(text,sizeof(text),"\nTotal of %d user currently inhabiting this reality.\n\n",num_of_users-invis-hid-ol);
	else snprintf(text,sizeof(text),"\nTotal of %d users currently inhabiting this reality.\n\n",num_of_users-invis-hid-ol);
	write_user(user,text);
	}
if (user->color) {
	if (!people && !colorstr) {
		if (!user->room->level) {
			if ((num_of_users-invis-hid-ol)==1) snprintf(text2,sizeof(text2),"~RS~BG~OL~FGTotal of %i user currently inhabiting this reality.",num_of_users-invis-hid-ol);
			else snprintf(text2,sizeof(text2),"~RS~BG~OL~FGTotal of %i users currently inhabiting this reality.",num_of_users-invis-hid-ol);
			}
		else {
			if ((num_of_users-invis-hid-ol)==1) snprintf(text2,sizeof(text2),"~RS~BR~OL~FRTotal of %i user currently inhabiting this reality.",num_of_users-invis-hid-ol);
			else snprintf(text2,sizeof(text2),"~RS~BR~OL~FRTotal of %i users currently inhabiting this reality.",num_of_users-invis-hid-ol);
			}
		align=76-strlen(text2);
		align+=color_com_count(text2,0)*3;
		align2=align/2;
		text[0]='\0';
		if (!user->room->level) {
			strncat(text,"~BW   ~BK                                                                            ~BW \n",sizeof(text));
			strncat(text,"~BW                                                                                \n",sizeof(text));
			strncat(text,"~BW  ~BG                                                                            ~BW  \n",sizeof(text));
			strncat(text,"~RS~BW  ~BG",sizeof(text));
			for(align3=0;align3<align2;++align3) strncat(text," ",sizeof(text));
			strncat(text,text2,sizeof(text));
			for(align3=align-align3;align3;--align3) strncat(text," ",sizeof(text));
			strncat(text,"~BK ~BW \n",sizeof(text));
			strncat(text,"~BW  ~BG                                                                            ~BK ~BW \n",sizeof(text));
			strncat(text,"~BW   ~BK                                                                            ~BW \n",sizeof(text));
			strncat(text,"~BW                                                                                \n",sizeof(text));
			}
		else {
			strncat(text,"~BW   ~BK                                                                            ~BW \n",sizeof(text));
			strncat(text,"~BW                                                                                \n",sizeof(text));
			strncat(text,"~BW  ~BR                                                                            ~BW  \n",sizeof(text));
			strncat(text,"~RS~BW  ~BR",sizeof(text));
			for(align3=0;align3<align2;++align3) strncat(text," ",sizeof(text));
			strncat(text,text2,sizeof(text));
			for(align3=align-align3;align3;--align3) strncat(text," ",sizeof(text));
			strncat(text,"~BK ~BW \n",sizeof(text));
			strncat(text,"~BW  ~BR                                                                            ~BK ~BW \n",sizeof(text));
			strncat(text,"~BW   ~BK                                                                           ~BK ~BW \n",sizeof(text));
			strncat(text,"~BW                                                                                \n",sizeof(text));
			}
		write_user(user,text);
		}
	else {
		if (colorstr) {
			snprintf(text,sizeof(text),"%s                                                                                \n",user->colstr);
			write_user(user,text);
			user->colstr[0]='\0';
			}
		else if (!user->room->level) {
			if (!i || i==1) write_user(user,"~BR                                                                                \n");
			else write_user(user,"~BB                                                                                \n");
			}
		else {
			if (!i || i==1) write_user(user,"~BG                                                                                \n");
			else write_user(user,"~BM                                                                                \n");
			}
		}
	}
else write_user(user,PTSTR);
}

/*** See which wizzes are on ***/
void wizwho(user)
UR_OBJECT user;
{
char room[ROOM_NAME_LEN+1];
int total=0;
UR_OBJECT user2;

write_user(user,"               ~OL-= High level users currently inhabiting HOLE =-\n\n-_-~-+-_-~-+-_-~-+-_-~-+--_-~-+-_-~-+-_-~-+-_-~-+-_--~-+-_-~-+-_-~-+-_-~-_-~-_-~\n");
for(user2=user_first;user2;user2=user2->next) {
	if (user2->level>CAPTAIN && !user2->hid && !user2->login && user2->type==USER_TYPE) {
		if (user2->room) {
			if (user2->room->level==user->room->level) {
				++total;
				if (user2->room->access==HIDDEN) sntrncpy(room,"*?*",sizeof(room));
				else sntrncpy(room,user2->room->name,sizeof(room));
				snprintf(text,sizeof(text),"~OL~FT%s~RS ~FR%s~RS ~OLis currently inhabiting the ~OL~FB%s~RS.\n",level_name[user2->level],user2->morphed,room);
				write_user(user,text);
				}
			}
		}
	}
if (total==1) snprintf(text,sizeof(text),"\nTotal of ~OL~FM%d~RS wizard signed on.\n%s",total,PTSTR);
else snprintf(text,sizeof(text),"\nTotal of ~OL~FM%d~RS wizzes signed on.\n%s",total,PTSTR);
write_user(user,text);
}

/*** Show who is on upstairs/downstairs ***/
void awho(user)
UR_OBJECT user;
{
char line[USER_NAME_LEN+USER_DESC_LEN+4],minutes[8],rname[ROOM_NAME_LEN+1],text2[200];
char afker[6],col_level[20],doing[10],idlestr[6],users1[6],users2[6];
int hid=0,i,idletime,invis=0,mins,remote,temp,tm,tm2,total=0;
int align,align2,align3,cnt,cnt2,cnt3,colorstr,ol=0;
RM_OBJECT room;
UR_OBJECT user2;

if (staythere && user->level<GENERAL) { who(user,0); return; }
if (user->color) {
	if (get_color(user,1) || user->colorize || user->woohoo || user->annoy || allcolor[0]) colorstr=1;
	else colorstr=0;
	if (!colorstr) {
		if (!user->room->level) {
			write_user(user,"~BW                                    ~OL~FTUpstairs                                    \n");
			write_user(user,"~BW  ~BM                                                                            ~BW  \n");
			}
		else {
			write_user(user,"~BW                                   ~OL~FTDownstairs                                   \n");
			write_user(user,"~BW  ~BB                                                                            ~BW  \n");
			}
		}
	else {
		i=rand()%3;
		if (colorstr) {
			snprintf(text,sizeof(text),"%s                                                                                \n",user->colstr);
			write_user(user,text);
			}
		else if (!user->room->level) {
			if (!i || i==1) write_user(user,"~BG                                                                                \n");
			else write_user(user,"~BM                                                                                \n");
			}
		else {
			if (!i || i==1) write_user(user,"~BR                                                                                \n");
			else write_user(user,"~BB                                                                                \n");
			}
		}
	}
else write_user(user,PTSTR);
if (user->color && !colorstr) {
	if (!user->tdiff) {
		if (!user->room->level) snprintf(text2,sizeof(text2),"~RS~BM~OL~FM*** Current users on %s %s %d %02d:%02d %s ***",day[twday],month[tmonth],tmday,ttime,tmin,md);
		else snprintf(text2,sizeof(text2),"~RS~BB~OL~FB*** Current users on %s %s %d %02d:%02d %s ***",day[twday],month[tmonth],tmday,ttime,tmin,md);
		}
	else {
		if (!user->room->level) snprintf(text2,sizeof(text2),"~RS~BM~OL~FM*** Current users on %s %s %d %02d:%02d %s ***",day[user->twday],month[user->tmonth],user->tmday,user->ttime,user->tmin,user->md);
		else snprintf(text2,sizeof(text2),"~RS~BB~OL~FB*** Current users on %s %s %d %02d:%02d %s ***",day[user->twday],month[user->tmonth],user->tmday,user->ttime,user->tmin,user->md);
		}
	align=76-strlen(text2);
	align+=color_com_count(text2,0)*3;
	align2=align/2;
	text[0]='\0';
	if (!user->room->level) {
		strncat(text,"~RS~BW  ~BM",sizeof(text));
		for(align3=0;align3<align2;++align3) strncat(text," ",sizeof(text));
		strncat(text,text2,sizeof(text));
		for(align3=align-align3;align3;--align3) strncat(text," ",sizeof(text));
		strncat(text,"~RS~BK ~BW \n",sizeof(text));
		}
	else {
		strncat(text,"~RS~BW  ~BB",sizeof(text));
		for(align3=0;align3<align2;++align3) strncat(text," ",sizeof(text));
		strncat(text,text2,sizeof(text));
		for(align3=align-align3;align3;--align3) strncat(text," ",sizeof(text));
		strncat(text,"~RS~BK ~BW \n",sizeof(text));
		}
	}
else {
	if (!user->tdiff) snprintf(text,sizeof(text),"\n            ~BM~OL~FT*** Current users on %s, %s %d, %02d:%02d %s ***\n\n",day[twday],month[tmonth],tmday,ttime,tmin,md);
	else snprintf(text,sizeof(text),"\n            ~BM~OL~FT*** Current users on %s, %s %d, %02d:%02d %s ***\n\n",day[user->twday],month[user->tmonth],user->tmday,user->ttime,user->tmin,user->md);
	}
write_user(user,text);
if (user->color && !colorstr) {
	if (!user->room->level) write_user(user,"~BW  ~BM~FM                                                                       ~RS~BM     ~RS~BK ~RS~BW \n");
	else write_user(user,"~BW  ~BB~FB                                                                       ~RS~BB     ~RS~BK ~RS~BW \n");
	}
for(room=room_first;room;room=room->next) {
	temp=0;
	for(user2=user_first;user2;user2=user2->next) {
		if (user2==user) continue;
		if (user2->type==CLONE_TYPE || user2->login) continue;
		if (user2->room!=room) continue;
		if (user2->hid) { ++hid; continue; }
		if (user->room && user2->room) if (user2->room->level==user->room->level) { ++ol; continue; }
		afker[0]='\0';
		if (user2->afk) sntrncpy(afker,"AFK",sizeof(afker));
		mins=(int)(time(0)-user2->last_login)/60;
		idletime=(int)(time(0)-user2->last_input)/60;
		++total;
		if (mins==1) sntrncpy(minutes,"min ",sizeof(minutes));
		else if (mins>=10000) sntrncpy(minutes,"mns",sizeof(minutes));
		else sntrncpy(minutes,"mins",sizeof(minutes));
		switch(user2->level) {
			case AWOL: sntrncpy(col_level,"AWOL ",sizeof(col_level));  break;
			case PRIVATE: sntrncpy(col_level,"Private ",sizeof(col_level));  break;
			case CORPORAL: sntrncpy(col_level,"~OL~FGCorporal~RS ",sizeof(col_level));  break;
			case CAPTAIN: sntrncpy(col_level,"~OL~FBCaptain~RS ",sizeof(col_level));  break;
			case COLONEL: sntrncpy(col_level,"~OL~FYColonel~RS ",sizeof(col_level));  break;
			case COMMANDER: sntrncpy(col_level,"~FMCommander~RS ",sizeof(col_level));  break;
			case GENERAL: sntrncpy(col_level,"~FRGeneral~RS ",sizeof(col_level));  break;
			default: sntrncpy(col_level,"* ",sizeof(col_level));
			}
		if (user2->type==REMOTE_TYPE) ++remote;
		if (!user2->vis) {
			++invis;
			if (user2->level>=user->level) continue;
			}
		snprintf(line,sizeof(line),"  %s %s",user2->morphed,user2->desc);
		if (!user2->vis) line[0]='*';
		if (user2->type==REMOTE_TYPE) line[1]='@';
		if (!room) sntrncpy(rname,"<offsite>:",sizeof(rname));
		if (room->access==HIDDEN) sntrncpy(rname,"*?*:",sizeof(rname));
		else snprintf(rname,sizeof(rname),"%s:",room->name);
		doing[0]='\0';
		switch(user2->misc_op) {
			case 1: sntrncpy(doing," Shutdown",sizeof(doing));  break;
			case 2: sntrncpy(doing,"  Reading",sizeof(doing));  break;
			case 3: sntrncpy(doing,"  Writing",sizeof(doing));  break;
			case 4: sntrncpy(doing,"     Mail",sizeof(doing));  break;
			case 5: sntrncpy(doing,"  Profile",sizeof(doing));  break;
			case 8: sntrncpy(doing,"  Suicide",sizeof(doing));  break;
			case 9: sntrncpy(doing,"    Fmail",sizeof(doing));  break;
			case 10: sntrncpy(doing,"Rebooting",sizeof(doing));  break;
			case 11: sntrncpy(doing,"  Suggest",sizeof(doing));  break;
			case 12: sntrncpy(doing,"Complaint",sizeof(doing));  break;
			case 26: sntrncpy(doing," Set menu",sizeof(doing));  break;
			case 35: sntrncpy(doing,"Quiz time",sizeof(doing));  break;
			case 46: sntrncpy(doing,"  Pasting",sizeof(doing));  break;
			case 62: sntrncpy(doing,"  Hangman",sizeof(doing));  break;
			case 68: sntrncpy(doing,"      Bog",sizeof(doing));
			}
		sntrncpy(line,color_com_strip(line),sizeof(line));
		cnt=color_com_count(line,0);
		if (!colorstr) sntrncpy(col_level,color_com_strip(col_level),sizeof(col_level));
		cnt2=color_com_count(col_level,0);
		if (name_count(line,0)>3) sntrncpy(line,name_strip(line),sizeof(line));
		cnt3=name_count(line,0);
		if (!temp) {
			if (colorstr) snprintf(text,sizeof(text),"~OL~FT%-21s\n",rname);
			else if (user->color) {
				if (!user->room->level) snprintf(text,sizeof(text),"~BW  ~RS~BM~FB%-21s                                                       ~BK ~BW \n",rname);
				else snprintf(text,sizeof(text),"~BW  ~RS~BB~OL~FT%-21s                                                       ~BK ~BW \n",rname);
				}
			else snprintf(text,sizeof(text),"%-21s\n",rname);
			write_user(user,text);
			++temp;
			}
		tm=(int)(time(0)-user2->last_input)/60;
		tm2=(int)(time(0)-user2->afktime)/60;
		idlestr[0]='\0';
		if (tm>=2 && !user2->afk) sntrncpy(idlestr,"IDLE",sizeof(idlestr));
		if (user->color && !colorstr) {
			if (!strcmp(idlestr,"IDLE") && !user2->malloc_start) {
				if (!user->room->level) snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM    ~LI~FR%s~RS~BM ~OL~FT%-3d~RS~BM ~FRof~RS~BM  ~OL~FG%-4d~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,idlestr,tm,mins);
				else snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB    ~LI~FR%s~RS~BB ~OL~FY%-3d~RS~BB ~FRof~RS~BB  ~OL~FG%-4d~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,idlestr,tm,mins);
				}
			else if (user2->afk) {
				if (!user->room->level) snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM     ~OL~FG%s~RS~BM ~OL~FT%-3d~RS~BM ~FRof~RS~BM  ~OL~FG%-4d~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,afker,tm2,mins);
				else snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB     ~OL~FM%s~RS~BB ~OL~FY%-3d~RS~BB ~FRof~RS~BB  ~OL~FG%-4d~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,afker,tm2,mins);
				}
			else {
				if (!user->room->level) snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM  %-9s ~OL~FG%-4d~RS~BM ~FK%s~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,doing,mins,minutes);
				else snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB  %-9s ~OL~FY%-4d~RS~BB ~FK%s~RS~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,doing,mins,minutes);
				}
			write_user(user,text);
			}
		else if (colorstr) {
			if (!strcmp(idlestr,"IDLE") && !user2->malloc_start) snprintf(text,sizeof(text),"%-*s  %-*s          ~LI~FR%s~RS %d/%d\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,idlestr,tm,mins);
			else if (user2->afk) snprintf(text,sizeof(text),"%-*s  %-*s           ~OL~FM%s~RS %d/%d\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,afker,tm2,mins);
			else snprintf(text,sizeof(text),"%-*s  %-*s  %-9s     %-4d %s\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,doing,mins,minutes);
			write_user(user,text);
			}
		else {
			if (!strcmp(idlestr,"IDLE") && !user2->malloc_start) snprintf(text,sizeof(text),"%-*s  %-*s          %s %d/%d\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,idlestr,tm,mins);
			else if (user2->afk) snprintf(text,sizeof(text),"%-*s  %-*s           %s %d/%d\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,afker,tm2,mins);
			else snprintf(text,sizeof(text),"%-*s  %-*s  %-9s     %-4d %s\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,10+cnt2*3,col_level,doing,mins,minutes);
			write_user(user,text);
			}
		}
	}
temp=0;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->room || user2->type==CLONE_TYPE) continue;
	afker[0]='\0';
	if (user2->afk) sntrncpy(afker,"(AFK)",sizeof(afker));
	mins=(int)(time(0)-user2->last_login)/60;
	idletime=(int)(time(0)-user2->last_input)/60;
	++total;
	switch(user2->level) {
		case AWOL: sntrncpy(col_level,"AWOL ",sizeof(col_level));  break;
		case PRIVATE: sntrncpy(col_level,"Private ",sizeof(col_level));  break;
		case CORPORAL: sntrncpy(col_level,"~OL~FGCorporal~RS ",sizeof(col_level));  break;
		case CAPTAIN: sntrncpy(col_level,"~OL~FBCaptain~RS ",sizeof(col_level));  break;
		case COLONEL: sntrncpy(col_level,"~OL~FYColonel~RS ",sizeof(col_level));  break;
		case COMMANDER: sntrncpy(col_level,"~FMCommander~RS ",sizeof(col_level));  break;
		case GENERAL: sntrncpy(col_level,"~FRGeneral~RS ",sizeof(col_level));  break;
		default: sntrncpy(col_level,"* ",sizeof(col_level));
		}
	snprintf(line,sizeof(line),"  %s %s",user2->morphed,user2->desc);
	sntrncpy(line,color_com_strip(line),sizeof(line));
	cnt=color_com_count(line,0);
	sntrncpy(col_level,color_com_strip(col_level),sizeof(col_level));
	cnt2=color_com_count(col_level,0);
	if (name_count(line,0)>3) sntrncpy(line,name_strip(line),sizeof(line));
	cnt3=name_count(line,0);
	doing[0]='\0';
	if (!temp) {
		if (user->color && !colorstr) {
			if (!user->room->level) write_user(user,"~BW  ~BM~FB<offsite>~RS~BM                                                                   ~BK ~BW \n");
			else write_user(user,"~BW  ~BB~OL~FT<offsite>~RS~BB                                                                   ~BK ~BW \n");
			}
		else write_user(user,"<offsite>\n");
		++temp;
		}
	if (user->color && !colorstr) {
		if (!user->room->level) {
			if (mins==1) snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM       ~OL~FG%-3d~RS~BM  ~FKmin ~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,mins);
			else snprintf(text,sizeof(text),"~BW  ~BM~OL~FY%-*s~RS~BM   ~OL%-*s~RS~BM       ~OL~FG%-3d~RS~BM  ~FKmins~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,mins);
			}
		else {
			if (mins==1) snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB       ~OL~FY%-3d~RS~BB  ~FKmin ~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,mins);
			else snprintf(text,sizeof(text),"~BW  ~BB~OL~FM%-*s~RS~BB   ~OL%-*s~RS~BB       ~OL~FY%-3d~RS~BB  ~FKmins~BK ~BW \n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,mins);
			}
		}
	else snprintf(text,sizeof(text),"%-*s  %-*s  %-8s  %-3d mins.\n",(USER_NAME_LEN+USER_DESC_LEN+2)+(cnt*3)-(cnt3*strlen(user->name))+(cnt3*2),line,15+cnt2*3,col_level,doing,mins);
	write_user(user,text);
	}
if (remote==1) sntrncpy(users1,"user",sizeof(users1));
else sntrncpy(users1,"users",sizeof(users1));
if (total==1) sntrncpy(users2,"user",sizeof(users2));
else sntrncpy(users2,"users",sizeof(users2));
++ol;
if (!user->color || colorstr) {
	if ((num_of_users-invis-hid-ol)==1) snprintf(text,sizeof(text),"\nTotal of %d user currently inhabiting this reality.\n\n",num_of_users-invis-hid-ol);
	else snprintf(text,sizeof(text),"\nTotal of %d users currently inhabiting this reality.\n\n",num_of_users-invis-hid-ol);
	write_user(user,text);
	}
if (user->color) {
	if (!colorstr) {
		if (!user->room->level) {
			if ((num_of_users-invis-hid-ol)==1) snprintf(text2,sizeof(text2),"~RS~BR~OL~FRTotal of %i user currently inhabiting this reality.",num_of_users-invis-hid-ol);
			else snprintf(text2,sizeof(text2),"~RS~BR~OL~FRTotal of %i users currently inhabiting this reality.",num_of_users-invis-hid-ol);
			}
		else {
			if ((num_of_users-invis-hid-ol)==1) snprintf(text2,sizeof(text2),"~RS~BG~OL~FGTotal of %i user currently inhabiting this reality.",num_of_users-invis-hid-ol);
			else snprintf(text2,sizeof(text2),"~RS~BG~OL~FGTotal of %i users currently inhabiting this reality.",num_of_users-invis-hid-ol);
			}
		align=76-strlen(text2);
		align+=color_com_count(text2,0)*3;
		align2=align/2;
		text[0]='\0';
		if (!user->room->level) {
			strncat(text,"~BW   ~BK                                                                            ~BW \n",sizeof(text));
			strncat(text,"~BW                                                                                \n",sizeof(text));
			strncat(text,"~BW  ~BR                                                                            ~BW  \n",sizeof(text));
			strncat(text,"~RS~BW  ~BR",sizeof(text));
			for(align3=0;align3<align2;++align3) strncat(text," ",sizeof(text));
			strncat(text,text2,sizeof(text));
			for(align3=align-align3;align3;--align3) strncat(text," ",sizeof(text));
			strncat(text,"~BK ~BW \n",sizeof(text));
			strncat(text,"~BW  ~BR                                                                            ~BK ~BW \n",sizeof(text));
			strncat(text,"~BW   ~BK                                                                           ~BK ~BW \n",sizeof(text));
			strncat(text,"~BW                                                                                \n",sizeof(text));
			}
		else {
			strncat(text,"~BW   ~BK                                                                            ~BW \n",sizeof(text));
			strncat(text,"~BW                                                                                \n",sizeof(text));
			strncat(text,"~BW  ~BG                                                                            ~BW  \n",sizeof(text));
			strncat(text,"~RS~BW  ~BG",sizeof(text));
			for(align3=0;align3<align2;++align3) strncat(text," ",sizeof(text));
			strncat(text,text2,sizeof(text));
			for(align3=align-align3;align3;--align3) strncat(text," ",sizeof(text));
			strncat(text,"~BK ~BW \n",sizeof(text));
			strncat(text,"~BW  ~BG                                                                            ~BK ~BW \n",sizeof(text));
			strncat(text,"~BW   ~BK                                                                            ~BW \n",sizeof(text));
			strncat(text,"~BW                                                                                \n",sizeof(text));
			}
		write_user(user,text);
		}
	else {
		snprintf(text,sizeof(text),"%s                                                                                \n",user->colstr);
		write_user(user,text);
		user->colstr[0]='\0';
		if (!user->room->level) {
			if (!i || i==1) write_user(user,"~BG                                                                                \n");
			else write_user(user,"~BM                                                                                \n");
			}
		else {
			if (!i || i==1) write_user(user,"~BR                                                                                \n");
			else write_user(user,"~BB                                                                                \n");
			}
		}
	}
else write_user(user,PTSTR);
}

/*** Return to home site ***/
void home(user)
UR_OBJECT user;
{
if (user->room) {
	write_user(user,"You are already on your home system.\n");
	return;
	}
write_user(user,"You traverse cyberspace...\n");
snprintf(text,sizeof(text),"REL %s\n",user->name);
write_sock(user->netlink->socket,text);
snprintf(text,sizeof(text),"NETLINK: User %s returned from %s.\n",user->name,user->netlink->service);
write_syslog(text,1);
user->room=user->netlink->connect_room;
user->netlink=NULL;
if (user->vis) {
	snprintf(text,sizeof(text),"%s %s\n",user->name,user->in_phrase);
	write_room_except(user->room,text,user,NULL,0,NULL);
	}
else write_room_except(user->room,invisenter,user,NULL,0,NULL);
look(user);
}

/*** Read the message board ***/
void read_board(user)
UR_OBJECT user;
{
char c,filename[FILENAME_LEN],*name;
int cnt=0,cnt2=0,lines,which=0;
FILE *fp;
RM_OBJECT room;

if (word_count<2) room=user->room;
else {
	if (!isnumber(word[1])) {
		if (!(room=get_room(user,word[1]))) return;
		if (word_count==3 && !isnumber(word[2])) {
			if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<room>/<lines from the end>] [<lines from the end>]\n",command[com_num]);
			else snprintf(text,sizeof(text),"Usage: %s [<room>/<lines from the end>] [<lines from the end>]\n",command[com_num]+1);
			write_user(user,text);
			return;
			}
		else if (word_count==3) { lines=atoi(word[2]); ++which; }
		}
	else { room=user->room; lines=atoi(word[1]); ++which; }
	}
snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,room->name);
if (!which) {
	snprintf(text,sizeof(text),"\n~BB~OL~FY*** The %s message board ***\n\n",room->name);
	write_user(user,text);
	if (user->vis) name=user->morphed; else name=invisname;
	if (room==user->room) {
		snprintf(text,sizeof(text),"%s reads the message board.\n",name);
		write_room_except(user->room,text,user,NULL,0,NULL);
		}
	user->mesg=1;
	user->misc_op=99;
	user->readroom=room;
	ptdisplay(user,user->readroom,0,0);
	return;
	}
if (!(fp=fopen(filename,"r"))) {
	snprintf(text,sizeof(text),"\n~BB~OL~FY*** The %s message board ***\n\n",room->name);
	write_user(user,text);
	write_user(user,"There are no messages on the board.\n");
	return;
	}
cnt=newline_count(filename,1);
if (cnt<lines) {
	if (cnt==1) snprintf(text,sizeof(text),"There is only %d line on the %s message board.\n",cnt,room->name);
	else snprintf(text,sizeof(text),"There are only %d lines on the %s message board.\n",cnt,room->name);
	write_user(user,text);
	fclose(fp);
	return;
	}
if (cnt==lines) {
	fclose(fp);
	snprintf(text,sizeof(text),"\n~BB~OL~FY*** The %s message board ***\n",room->name);
	write_user(user,text);
	more(user,filename,2);
	if (user->vis) name=user->morphed; else name=invisname;
	if (room==user->room) {
		snprintf(text,sizeof(text),"%s reads the message board.\n",name);
		write_room_except(user->room,text,user,NULL,0,NULL);
		}
	return;
	}
fseek(fp,0,0);
c=getc(fp);
while(!feof(fp)) {
	if (c=='\n') ++cnt2;
	c=getc(fp);
	if (cnt2==cnt-lines) {
		if (lines==1) snprintf(text,sizeof(text),"\n~BB~OL~FY*** The %s message board (last %d line) ***\n",room->name,lines);
		else snprintf(text,sizeof(text),"\n~BB~OL~FY*** The %s message board (last %d lines) ***\n",room->name,lines);
		write_user(user,text);
		user->filepos=ftell(fp)-1;
		user->origpos=ftell(fp)-1;
		fclose(fp);
		more(user,filename,2);
		if (user->vis) name=user->morphed; else name=invisname;
		if (room==user->room) {
			snprintf(text,sizeof(text),"%s reads the message board.\n",name);
			write_room_except(user->room,text,user,NULL,0,NULL);
			}
		return;
		}
	}
fclose(fp);
snprintf(text,sizeof(text),"%s: Line count error.\n",syserror);
write_user(user,text);
write_syslog("ERROR: Line count error in read().\n",0);
}

/*** Write on the message board ***/
void write_board(user,inpstr,done_editing)
UR_OBJECT user;
char *inpstr;
int done_editing;
{
char filename[FILENAME_LEN],*name,*ptr;
int cnt=0;
FILE *fp;

if (!done_editing) {
	if (word_count<2) {
		if (user->type==REMOTE_TYPE) {
			write_user(user,"Sorry, due to software limitations remote users cannot use the line editor.\nUse the 'write <mesg>' method instead.\n");
			return;
			}
		snprintf(text,sizeof(text),"\n~BB~OL~FY*** Writing message on the %s board ***\n\n",user->room->name);
		write_user(user,text);
		user->misc_op=3;
		editor(user,NULL);
		return;
		}
	ptr=inpstr;
	}
else ptr=user->malloc_start;
if (ban_swearing && contains_swearing(ptr)) {
	swore(user);
	return;
	}
if (contains_pt(ptr)) return;
snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,user->room->name);
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: cannot write to file.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to append in write_board().\n",filename);
	write_syslog(text,0);
	return;
	}
/* if (user->vis) name=user->name; else name=invisname; */
name=user->name;
if (user->type==REMOTE_TYPE)
	snprintf(text,sizeof(text),"PT: %d\rFrom: %s@%s, %d/%d/%d at %02d:%02d %s\n",(int)(time(0)),name,user->netlink->service,tmonth+1,tmday,tyear,ttime,tmin,md);
else snprintf(text,sizeof(text),"PT: %d\rFrom: %s, %d/%d/%d at %02d:%02d %s\n",(int)(time(0)),name,tmonth+1,tmday,tyear,ttime,tmin,md);
fputs(text,fp);
while(*ptr) {
	putc(*ptr,fp);
	if (*ptr=='\n') cnt=0; else ++cnt;
	if (cnt==80) { putc('\n',fp); cnt=0; }
	++ptr;
	}
if (!done_editing) fputs("\n\n",fp); else putc('\n',fp);
fclose(fp);
write_user(user,"You write the message on the board.\n");
snprintf(text,sizeof(text),"%s writes a message on the board.\n",user->morphed);
write_room_except(user->room,text,user,NULL,0,NULL);
++user->room->mesg_cnt;
}

/*** Wipe some messages off the board ***/
void wipe_board(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],garbage[82],id[82],line[82],name[USER_NAME_LEN+1];
int cnt=0,num,ret;
FILE *infp,*outfp;

if (word_count<2 || ((num=atoi(word[1]))<1 && word[1][0]!='$' && word[1][0]!='#' && strcmp(word[1],"*") && strcmp(word[1],"all") && strcmp(word[1],"prompt"))) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <num>/$name/#num/(*/all)/prompt\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <num>/$name/#num/(*/all)/prompt\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,user->room->name);
if (!(infp=fopen(filename,"r"))) {
	write_user(user,"The message board is empty.\n");
	user->misc_op=0;
	user->mesg=0;
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile in wipe_board().\n",0);
	fclose(infp);
	return;
	}
if (!strcmp(word[1],"all") || !strcmp(word[1],"*")) {
	fclose(infp);  fclose(outfp);
	unlink(filename);
	write_user(user,"All messages deleted.\n");
	snprintf(text,sizeof(text),"%s wipes the message board.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	user->room->mesg_cnt=0;
	snprintf(text,sizeof(text),"%s wiped all the messages off the %s message board.\n",user->name,user->room->name);
	write_syslog(text,1);
	return;
	}
else if (!strcmp(word[1],"prompt")) {
	++user->mesg;
	ret=ptdisplay(user,user->room,0,0);
	if (ret) {
		write_user(user,"Do you wish to delete this message (y/n)? (scmquit to abort) ");
		user->misc_op=70;
		}
	else { write_user(user,"There are no messages on the board.\n"); user->misc_op=0; user->mesg=0; }
	fclose(infp);  fclose(outfp);
	return;
	}
else if (word[1][0]=='$') {
	sntrncpy(word[1],word[1]+1,sizeof(word[1]));
	if (!strlen(word[1])) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <num>/$name/#num/(*/all)/prompt\n",command[com_num]);
		else snprintf(text,sizeof(text),"Usage: %s <num>/$name/#num/(*/all)/prompt\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	word[1][0]=toupper(word[1][0]);
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s %s %s",id,garbage,garbage);
	sntrncpy(name,pt_name(line),sizeof(name));
	while(!feof(infp)) {
		if (!strcmp(id,"PT:") && !strcmp(name,word[1])) {
			++cnt;
			fgets(line,sizeof(line),infp);
			sscanf(line,"%s %s %s",id,garbage,garbage);
			sntrncpy(name,pt_name(line),sizeof(name));
			while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s %s %s",id,garbage,garbage);
				sntrncpy(name,pt_name(line),sizeof(name));
				}
			}
		else {
			fputs(line,outfp);
			fgets(line,sizeof(line),infp);
			sscanf(line,"%s %s %s",id,garbage,garbage);
			sntrncpy(name,pt_name(line),sizeof(name));
			while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
				fputs(line,outfp);
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s %s %s",id,garbage,garbage);
				sntrncpy(name,pt_name(line),sizeof(name));
				}
			fputs("\n",outfp);
			}
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s %s %s",id,garbage,garbage);
		sntrncpy(name,pt_name(line),sizeof(name));
		}
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in wipe_board().\n",0);
		return;
		}
	if (!cnt) { write_user(user,"No messages by that user.\n"); return; }
	else {
		if (cnt==1) snprintf(text,sizeof(text),"%d message deleted.\n",cnt);
		else snprintf(text,sizeof(text),"%d messages deleted.\n",cnt);
		write_user(user,text);
		user->room->mesg_cnt-=cnt;
		}
	if (cnt==1) snprintf(text,sizeof(text),"%s wipes a message off the board.\n",user->morphed);
	else snprintf(text,sizeof(text),"%s wipes some messages off the board.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	if (cnt==1) snprintf(text,sizeof(text),"%s wiped %d message off the %s message board.\n",user->name,cnt,user->room->name);
	else snprintf(text,sizeof(text),"%s wiped %d messages off the %s message board.\n",user->name,cnt,user->room->name);
	write_syslog(text,1);
	if (!(infp=fopen(filename,"r"))) return;
	cnt=0;
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) ++cnt;
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);
	if (!cnt) unlink(filename);
	return;
	}
else if (word[1][0]=='#') {
	num=atoi(word[1]+1);
	if (!num) {
		write_user(user,"Not a valid message number.\n");
		fclose(infp);  fclose(outfp);
		return;
		}
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s",id);
	while(!feof(infp)) {
		if (!strcmp(id,"PT:")) {
			if (++cnt==num) {
				while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
					fgets(line,sizeof(line),infp);
					sscanf(line,"%s",id);
					}
				}
			else {
				fputs(line,outfp);
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s",id);
				while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
					fputs(line,outfp);
					fgets(line,sizeof(line),infp);
					sscanf(line,"%s",id);
					}
				fputs("\n",outfp);
				}
			}
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s",id);
		}
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in wipe_board().\n",0);
		return;
		}
	if (cnt<num) { write_user(user,"No such message.\n"); return; }
	else {
		snprintf(text,sizeof(text),"Message #%d deleted.\n",num);
		write_user(user,text);
		--user->room->mesg_cnt;
		}
	snprintf(text,sizeof(text),"%s wipes a message off the board.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	snprintf(text,sizeof(text),"%s wiped a message off the %s message board.\n",user->name,user->room->name);
	write_syslog(text,1);
	if (!(infp=fopen(filename,"r"))) return;
	cnt=0;
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) ++cnt;
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);
	if (!cnt) unlink(filename);
	return;
	}
fgets(line,sizeof(line),infp);
while(!feof(infp)) {
	if (cnt<=num) {
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) if (++cnt>num) fputs(line,outfp);
		}
	else fputs(line,outfp);
	fgets(line,sizeof(line),infp);
	}
fclose(infp);  fclose(outfp);
unlink(filename);
if (cnt<num) {
	unlink(TEMPFILE);
	if (cnt==1) snprintf(text,sizeof(text),"There was only %d message on the board, all now deleted.\n",cnt);
	else snprintf(text,sizeof(text),"There were only %d messages on the board, all now deleted.\n",cnt);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s wipes the message board.\n",user->morphed);
	write_room_except(user->room,text,user,NULL,0,NULL);
	user->room->mesg_cnt=0;
	snprintf(text,sizeof(text),"%s wiped all messages off the %s message board.\n",user->name,num,user->room->name);
	write_syslog(text,1);
	return;
	}
if (cnt==num) {
	unlink(TEMPFILE);
	write_user(user,"All messages deleted.\n");
	user->room->mesg_cnt=0;
	}
else {
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in wipe_board().\n",0);
		return;
		}
	user->room->mesg_cnt-=num;
	}
if (num==1) snprintf(text,sizeof(text),"%d message wiped off the %s message board.\n",num,user->room->name);
else snprintf(text,sizeof(text),"%d messages wiped off the %s message board.\n",num,user->room->name);
write_user(user,text);
snprintf(text,sizeof(text),"%s wipes the message board.\n",user->morphed);
write_room_except(user->room,text,user,NULL,0,NULL);
if (num==1) snprintf(text,sizeof(text),"%s wiped %d message off the %s message board.\n",user->name,num,user->room->name);
else snprintf(text,sizeof(text),"%s wiped %d messages off the %s message board.\n",user->name,num,user->room->name);
write_syslog(text,1);
}

/*** Write on all the message boards ***/
void write_allboard(user,inpstr,done_editing)
UR_OBJECT user;
char *inpstr;
int done_editing;
{
char filename[FILENAME_LEN],*ptr;
int cnt=0,inp=0,temp=0;
FILE *fp;
RM_OBJECT room;

if (!done_editing) {
	if (word_count<2) {
		if (user->type==REMOTE_TYPE) {
			write_user(user,"Sorry, due to software limitations remote users cannot use the line editor.\nUse the 'writeall <mesg>' method instead.\n");
			return;
			}
		write_user(user,"\n~BB~OL~FY*** Writing message on all boards ***\n\n");
		user->misc_op=7;
		editor(user,NULL);
		return;
		}
	ptr=inpstr;
	++inp;
	}
else { ptr=user->malloc_start; ++temp; }
if (ban_swearing && contains_swearing(ptr)) {
	swore(user);
	return;
	}
for(room=room_first;room;room=room->next) {
	if (room->level!=user->room->level && user->level<GENERAL) continue;
	snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,room->name);
	if (!(fp=fopen(filename,"a"))) {
		snprintf(text,sizeof(text),"%s: cannot write to file.\n",syserror);
		write_user(user,text);
		snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to append in write_allboard().\n",filename);
		write_syslog(text,0);
		return;
		}
	if (user->type==REMOTE_TYPE)
		snprintf(text,sizeof(text),"PT: %d\rFrom: %s@%s, %d/%d/%d at %02d:%02d %s\n",(int)(time(0)),user->name,user->netlink->service,tmonth+1,tmday,tyear,ttime,tmin,md);
	else snprintf(text,sizeof(text),"PT: %d\rFrom: %s, %d/%d/%d at %02d:%02d %s\n",(int)(time(0)),user->name,tmonth+1,tmday,tyear,ttime,tmin,md);
	fputs(text,fp);
	if (temp) ptr=user->malloc_start;
	else { ptr=inpstr; ++inp; }
	while(*ptr) {
		putc(*ptr,fp);
		if (*ptr=='\n') cnt=0; else ++cnt;
		if (cnt==80) { putc('\n',fp); cnt=0; }
		++ptr;
		}
	if (inp) fputs("\n\n",fp); else putc('\n',fp);
	++room->mesg_cnt;
	fclose(fp);
	}
write_user(user,"You write the message on all the boards.\n");
snprintf(text,sizeof(text),"%s writes a message on all the boards.\n",user->morphed);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Wipe some messages off all boards ***/
void wipe_allboard(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],garbage[82],id[82],line[82],name[USER_NAME_LEN+1],w1[81];
int cnt=0,message=0,num=0,total=0,w,yes=0;
FILE *infp,*outfp;
RM_OBJECT room;

if (word_count<2 || (word[1][0]!='$' && word[1][0]!='&')) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s $name/&word\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s $name/&word\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
sntrncpy(word[1],word[1]+1,sizeof(word[1]));
if (!strlen(word[1])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s $name/&word\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s $name/&word\n",command[com_num]+1);
	write_user(user,text);
	return;
	}
else if (word[1][0]=='$') {
	word[1][0]=toupper(word[1][0]);
	for(room=room_first;room;room=room->next) {
		if (room->level!=user->room->level && user->level<GENERAL) continue;
		snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,room->name);
		if (!(infp=fopen(filename,"r"))) continue;
		if (!(outfp=fopen(TEMPFILE,"w"))) {
			snprintf(text,sizeof(text),"%s: couldn't open tempfile.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Couldn't open tempfile in wipe_allboard().\n",0);
			fclose(infp);
			return;
			}
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s %s %s",id,garbage,garbage);
		sntrncpy(name,pt_name(line),sizeof(name));
		while(!feof(infp)) {
			if (!strcmp(id,"PT:") && !strcmp(name,word[1])) {
				++cnt; ++total;
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s %s %s",id,garbage,garbage);
				sntrncpy(name,pt_name(line),sizeof(name));
				while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
					fgets(line,sizeof(line),infp);
					sscanf(line,"%s %s %s",id,garbage,garbage);
					sntrncpy(name,pt_name(line),sizeof(name));
					}
				}
			else {
				fputs(line,outfp);
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s %s %s",id,garbage,garbage);
				sntrncpy(name,pt_name(line),sizeof(name));
				while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
					fputs(line,outfp);
					fgets(line,sizeof(line),infp);
					sscanf(line,"%s %s %s",id,garbage,garbage);
					sntrncpy(name,pt_name(line),sizeof(name));
					}
				fputs("\n",outfp);
				}
			fgets(line,sizeof(line),infp);
			sscanf(line,"%s %s %s",id,garbage,garbage);
			sntrncpy(name,pt_name(line),sizeof(name));
			}
		fclose(infp);  fclose(outfp);
		if (rename(TEMPFILE,filename)==-1) {
			unlink(TEMPFILE);
			snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Couldn't rename tempfile in wipe_allboard().\n",0);
			return;
			}
		if (!cnt) continue;
		else room->mesg_cnt-=cnt;
		if (!(infp=fopen(filename,"r"))) return;
		cnt=0;
		fgets(line,sizeof(line),infp);
		while(!feof(infp)) {
			sscanf(line,"%s",id);
			if (!strcmp(id,"PT:")) ++cnt;
			fgets(line,sizeof(line),infp);
			}
		fclose(infp);
		if (!cnt) unlink(filename);
		}
	if (total) {
		if (total==1) snprintf(text,sizeof(text),"%d message deleted.\n",total);
		else snprintf(text,sizeof(text),"%d messages deleted.\n",total);
		write_user(user,text);
		}
	else { write_user(user,"No messages by that user.\n"); return; }
	if (total==1) snprintf(text,sizeof(text),"%s wipes %d message off all the message boards.\n",user->name,total);
	else snprintf(text,sizeof(text),"%s wipes %d messages off all the message boards.\n",user->name,total);
	write_room_except(user->room,text,user,NULL,0,NULL);
	if (total==1) snprintf(text,sizeof(text),"%s wiped %d message off all the message boards.\n",user->name,total);
	else snprintf(text,sizeof(text),"%s wiped %d messages off all the message boards.\n",user->name,total);
	write_syslog(text,1);
	}
else {
	for(room=room_first;room;room=room->next) {
		snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,room->name);
		if (!(infp=fopen(filename,"r"))) continue;
		fgets(line,sizeof(line),infp);
		while(!feof(infp)) {
			if (*line=='\n') { message=0;  yes=0; }
			if (!message) {
				w1[0]='\0';
				sscanf(line,"%s",w1);
				if (!strcmp(w1,"PT:")) {
					++message; ++num;
					}
				}
			for(w=1;w<word_count;++w) {
				if (!yes && instr(line,word[w])) {
					delete_mesg(room,user,num,0);
					++cnt; ++yes;
					}
				}
			fgets(line,sizeof(line),infp);
			}
		fclose(infp);
		}
	if (cnt) {
		if (cnt==1) snprintf(text,sizeof(text),"Total of %d match found.\n\n",cnt);
		else snprintf(text,sizeof(text),"Total of %d matches found.\n\n",cnt);
		write_user(user,text);
		if (cnt==1) snprintf(text,sizeof(text),"%s deleted %d message off all the boards.\n",user->name,cnt);
		else snprintf(text,sizeof(text),"%s deleted %d messages off all the boards.\n",user->name,cnt);
		write_syslog(text,1);
		}
	else write_user(user,"No occurences found.\n");
	}
}

/*** Delete a particular message ***/
void delete_mesg(room,user,num,which)
RM_OBJECT room;
UR_OBJECT user;
int num,which;
{
char filename[FILENAME_LEN],id[82],line[82];
int cnt=0;
FILE *infp,*outfp;

if (!which) snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,room->name);
else if (which==1) snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,user->name);
else if (which==2) snprintf(filename,sizeof(filename),"complaints.txt");
else if (which==3) snprintf(filename,sizeof(filename),"sugg.txt");
else if (which==4) snprintf(filename,sizeof(filename),"%s/%s.Y",USERFILES,user->name);
if (!(infp=fopen(filename,"r"))) return;
if (!(outfp=fopen(TEMPFILE,"w"))) {
	write_syslog("ERROR: Couldn't open tempfile in delete_mesg().\n",0);
	fclose(infp);
	return;
	}
if (!num) { fclose(infp); fclose(outfp); return; }
fgets(line,sizeof(line),infp);
sscanf(line,"%s",id);
while(!feof(infp)) {
	if (!strcmp(id,"PT:")) {
		if (++cnt==num) {
			while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s",id);
				}
			}
		else {
			fputs(line,outfp);
			fgets(line,sizeof(line),infp);
			sscanf(line,"%s",id);
			while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
				fputs(line,outfp);
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s",id);
				}
			fputs("\n",outfp);
			}
		}
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s",id);
	}
fclose(infp);  fclose(outfp);
if (rename(TEMPFILE,filename)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in delete_mesg().\n",0);
	return;
	}
if (cnt<num) return;
if (room && !which) --room->mesg_cnt;
if (user) --user->mesg;
if (!(infp=fopen(filename,"r"))) return;
cnt=0;
fgets(line,sizeof(line),infp);
while(!feof(infp)) {
	sscanf(line,"%s",id);
	if (!strcmp(id,"PT:")) ++cnt;
	fgets(line,sizeof(line),infp);
	}
fclose(infp);
if (!cnt) unlink(filename);
}

/*** Set all the room topics ***/
void topic_allboard(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
RM_OBJECT room=user->room;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <topic>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <topic>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (strlen(inpstr)>TOPIC_LEN) {
	write_user(user,"Topic too long.\n");
	return;
	}
for(room=room_first;room;room=room->next) {
	if (room->level!=user->room->level && user->level<GENERAL) continue;
	sntrncpy(room->topic,inpstr,sizeof(room->topic));
	}
snprintf(text,sizeof(text),"Topic on all boards set to: %s\n",inpstr);
write_user(user,text);
}

/*** Search all the boards for the words given in the list. Rooms fixed to
     private will be ignore if the users level is less than gatecrash_level ***/
void search_boards(user)
UR_OBJECT user;
{
char buff[ARR_SIZE],filename[FILENAME_LEN],line[82],w1[81];
int cnt=0,message=0,room_given,w,yes=0;
RM_OBJECT room;
FILE *fp;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <word list>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <word list>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
for(room=room_first;room;room=room->next) {
	if (room->access==HIDDEN || room->hid || (room->level!=user->room->level && user->level<GENERAL)) continue;
	snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,room->name);
	if (!(fp=fopen(filename,"r"))) continue;
	if ((room->access & 1) && (room->access & 2) && user->level<gatecrash_level) {  fclose(fp);  continue;  }
	fgets(line,sizeof(line),fp);
	room_given=0;  buff[0]='\0';
	while(!feof(fp)) {
		if (*line=='\n') {
			if (yes) {  strncat(buff,"\n",sizeof(buff));  write_user(user,buff);  }
			message=0;  yes=0;  buff[0]='\0';
			}
		if (!message) {
			w1[0]='\0';
			sscanf(line,"%s",w1);
			if (!strcmp(w1,"PT:")) {
				++message;
				sntrncpy(buff,remove_first(remove_first(line)),sizeof(buff));
				}
			}
		else strncat(buff,line,sizeof(buff));
		for(w=1;w<word_count;++w) {
			if (!yes && instr(line,word[w])) {
				if (!room_given) {
					snprintf(text,sizeof(text),"~BB~OL~FY*** %s board ***\n\n",room->name);
					write_user(user,text);
					++room_given;
					}
				++cnt; ++yes;
				}
			}
		fgets(line,sizeof(line),fp);
		}
	if (yes) {  strncat(buff,"\n",sizeof(buff));  write_user(user,buff);  }
	fclose(fp);
	}
if (cnt) {
	if (cnt==1) snprintf(text,sizeof(text),"Total of %d matching message.\n\n",cnt);
	else snprintf(text,sizeof(text),"Total of %d matching messages.\n\n",cnt);
	write_user(user,text);
	}
else write_user(user,"No occurences found.\n");
}

/*** Review the conversation ***/
void review(user)
UR_OBJECT user;
{
char c,filename[FILENAME_LEN];
int cnt=0,cnt2=0,lines,which=0;
FILE *fp;
RM_OBJECT room;

if (word_count<2) room=user->room;
else {
	if (!isnumber(word[1])) {
		if (!(room=get_room(user,word[1]))) return;
		if (word_count==3 && !isnumber(word[2])) {
			if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<room>/<lines from the end>] [<lines from the end>]\n",command[com_num]);
			else snprintf(text,sizeof(text),"Usage: %s [<room>/<lines from the end>] [<lines from the end>]\n",command[com_num]+1);
			write_user(user,text);
			return;
			}
		else if (word_count==3) { lines=atoi(word[2]); ++which; }
		}
	else { room=user->room; lines=atoi(word[1]); ++which; }
	}
snprintf(filename,sizeof(filename),"%s/%s.U",DATAFILES,room->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"                     ~OL~FY-REVIEW-~RS                     \n~FRWilby says:~RS I sleep ten hours a day and drink quarts of coffee to stay\nfunctional. My only consolation is experience. I remind myself over and over\nthat I am not going crazy, and everyone else is fighting The Darkness too.\nSure is cold...In the dim light and paralyzing cold, I wonder what possesses\nme to live in the artic anyway. My eskimo neighbors sum it up in a single\nexclamation: Alapaa! It's cold! Sure is cold...\n                                                  \n"); return;
	}
if (!which) {
	write_user(user,"                     ~OL~FY-REVIEW-~RS                     \n");
	user->revdisp=1;
	fclose(fp);
	more(user,filename,0);
	return;
	}
cnt=newline_count(filename,1);
if (cnt<lines) {
	if (cnt==1) snprintf(text,sizeof(text),"There is only %d line in the %s review buffer.\n",cnt,room->name);
	else snprintf(text,sizeof(text),"There are only %d lines in the %s review buffer.\n",cnt,room->name);
	write_user(user,text);
	fclose(fp);
	return;
	}
if (cnt==lines) {
	fclose(fp);
	write_user(user,"                     ~OL~FY-REVIEW-~RS                     \n");
	user->revdisp=1;
	more(user,filename,0);
	return;
	}
fseek(fp,0,0);
c=getc(fp);
while(!feof(fp)) {
	if (c=='\n') ++cnt2;
	c=getc(fp);
	if (cnt2==cnt-lines) {
		write_user(user,"                     ~OL~FY-REVIEW-~RS                     \n");
		user->filepos=ftell(fp)-1;
		user->origpos=ftell(fp)-1;
		fclose(fp);
		user->revdisp=1;
		more(user,filename,0);
		return;
		}
	}
fclose(fp);
snprintf(text,sizeof(text),"%s: Line count error.\n",syserror);
write_user(user,text);
write_syslog("ERROR: Line count error in review().\n",0);
}

/*** Do the help ***/
void help(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];

if (word_count<2) {
	help_commands(user);
	return;
	}
if (!strcmp(word[1],"credits")) {
	snprintf(text,sizeof(text),"\n*** The Credits :) ***\n\nNUTS version %s, (C) Neil Robertson 1996.\n\n",NVERSION);
	write_user(user,text);
	write_user(user,"Neil's Unix Talker System (NUTS) was written by Neil Robertson as a university\nproject during autumn and winter 1992 and went live on the net close to the\nend of the same year. Version 3 is a complete rewrite which was done during\nthe first half of 1996.\n\n");
	return;
	}
if (stralnum(word[1])) {
	write_user(user,"Sorry, there is no help on that topic.\n");
	snprintf(text,sizeof(text),"%s tried to view help on the topic %s.\n",user->name,word[1]);
	write_syslog(text,1);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s",HELPFILES,word[1]);
more(user,filename,0);
}

/*** Show the commands available ***/
void help_commands(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],temp[20];
int cnt=0,com=0,i=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) return;
snprintf(text,sizeof(text),"~BB~OL~FY*** Commands available for user level %s ***\n\n",level_name[user->level]);
sntrncpy(text,center(text,80),sizeof(text));
fputs(text,fp);
text[0]='\0';
while(command[com][0]!='*') {
	if (command_disabled(user,command[com],1)) { ++com; continue; }
	if ((com_level[com]>user->level && !command_granted(user,command[com])) || command_disabled(user,command[com],0)) { ++com; continue; }
	if (command[com][0]!='.') { ++com; continue; }
	if (!isletter(command[com][1])) { ++com; continue; }
	switch(i) {
		case 0:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~FR%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~FR%-12s~RS ",command[com]+1);
			break;
		case 1:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~OL%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~OL%-12s~RS ",command[com]+1);
			break;
		default:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~FB%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~FB%-12s~RS ",command[com]+1);
		}
	if (++i==3) i=0;
	strncat(text,temp,sizeof(text));
	if (cnt==5) {
		strncat(text,"\n",sizeof(text));
		fputs(text,fp);
		text[0]='\0';  cnt=-1;
		}
	++com; ++cnt;
	}
if (!cnt) fputs("\n",fp);
else fputs("\n\n",fp);
fclose(fp);
more(user,filename,0);
}

/*** Show the social commands available ***/
void socials(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],temp[20],text2[ARR_SIZE];
int cnt=0,com=0,i=0,temp1=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) return;
text[0]='\0';
while(command[com][0]!='*') {
	if (command_disabled(user,command[com],1)) { ++com; continue; }
	if ((com_level[com]>user->level && !command_granted(user,command[com])) || command_disabled(user,command[com],0)) { ++com; continue; }
	if (command[com][0]!='-') { ++com; continue; }
	if (!isletter(command[com][1])) { ++com; continue; }
	if (!temp1) {
		snprintf(text2,sizeof(text2),"~BB~OL~FY*** Social commands available for user level %s ***\n\n",level_name[user->level]);
		sntrncpy(text2,center(text2,80),sizeof(text2));
		fputs(text2,fp);
		++temp1;
		}
	switch(i) {
		case 0:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~FR%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~FR%-12s~RS ",command[com]+1);
			break;
		case 1:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~OL%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~OL%-12s~RS ",command[com]+1);
			break;
		default:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~FB%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~FB%-12s~RS ",command[com]+1);
		}
	if (++i==3) i=0;
	strncat(text,temp,sizeof(text));
	if (cnt==5) {
		strncat(text,"\n",sizeof(text));
		fputs(text,fp);
		text[0]='\0';  cnt=-1;
		}
	++com; ++cnt;
	}
if (!cnt) fputs("\n",fp);
else fputs("\n\n",fp);
fclose(fp);
if (!temp1) {
	write_user(user,"No social commands available to you.\n");
	unlink(filename);
	}
else more(user,filename,0);
}

/*** Show the wiz commands available ***/
void wizhelp(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],temp[20],text2[ARR_SIZE];
int cnt=0,com=0,i=0,temp1=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) return;
text[0]='\0';
while(command[com][0]!='*') {
	if (command_disabled(user,command[com],1)) { ++com; continue; }
	if ((com_level[com]>user->level && !command_granted(user,command[com])) || command_disabled(user,command[com],0)) { ++com; continue; }
	if (command[com][0]!='/') { ++com; continue; }
	if (!isletter(command[com][1])) { ++com; continue; }
	if (!temp1) {
		snprintf(text2,sizeof(text2),"~BB~OL~FY*** WIZ commands available for user level %s ***\n\n",level_name[user->level]);
		sntrncpy(text2,center(text2,80),sizeof(text2));
		fputs(text2,fp);
		++temp1;
		}
	switch(i) {
		case 0:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~FR%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~FR%-12s~RS ",command[com]+1);
			break;
		case 1:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~OL%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~OL%-12s~RS ",command[com]+1);
			break;
		default:
			if (!user->command_mode && !user->scommand_mode) snprintf(temp,sizeof(temp),"~FB%-12s~RS ",command[com]);
			else snprintf(temp,sizeof(temp),"~FB%-12s~RS ",command[com]+1);
		}
	if (++i==3) i=0;
	strncat(text,temp,sizeof(text));
	if (cnt==5) {
		strncat(text,"\n",sizeof(text));
		fputs(text,fp);
		text[0]='\0';  cnt=-1;
		}
	++com; ++cnt;
	}
if (!cnt) fputs("\n",fp);
else fputs("\n\n",fp);
fclose(fp);
if (!temp1) {
	write_user(user,"No wiz commands available to you.\n");
	unlink(filename);
	}
else more(user,filename,0);
}

/*** Show some user stats ***/
void status(user)
UR_OBJECT user;
{
char bstr[40],ir[ROOM_NAME_LEN+1],text2[ARR_SIZE];
int days,destructcount=0,hours,hs,i,mins,secs;
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<2 || user->level<CAPTAIN) {
	user2=user;
	if (user->color && !allcolor[0] && !user->colorize && !user->annoy && !user->woohoo && !get_color(user,4)) { snprintf(text,sizeof(text),"~BB~OL~FY*** Your status ***\n\n"); sntrncpy(text,center(text,80),sizeof(text)); write_user(user,text); }
	else { snprintf(text,sizeof(text),"*** Your status ***\n\n"); sntrncpy(text,center(text,65),sizeof(text)); write_user(user,text); }
	}
else {
	if (!(user2=get_user2(user,word[1]))) {
		if (!(user2=create_user())) {
			snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Unable to create temporary user session in status().\n",0);
			return;
			}
		sntrncpy(user2->name,word[1],sizeof(user2->name));
		if (!load_user_details(user2)) {
			write_user(user,nosuchuser);
			destruct_user(user2,0);
			return;
			}
		destructcount=1;
		}
	if (user2->level>=user->level && user2!=user) {
		write_user(user,"You cannot stat a user of equal or higher level than yourself.\n");
		if (destructcount) destruct_user(user2,0);
		return;
		}
	if (user2==user) {
		if (user->color) { snprintf(text,sizeof(text),"~BB~OL~FY*** Your status ***\n\n"); sntrncpy(text,center(text,80),sizeof(text)); write_user(user,text); }
		else { snprintf(text,sizeof(text),"*** Your status ***\n\n"); sntrncpy(text,center(text,65),sizeof(text)); write_user(user,text); }
		}
	else {
		if (user->color) { snprintf(text,sizeof(text),"~BB~OL~FY*** %s's status ***\n\n",user2->name); sntrncpy(text,center(text,80),sizeof(text)); write_user(user,text); }
		else { snprintf(text,sizeof(text),"*** %s's status ***\n\n",user2->name); sntrncpy(text,center(text,65),sizeof(text)); write_user(user,text); }
		}
	}
if (!user2->invite_room) sntrncpy(ir,"<nowhere>",sizeof(ir));
else sntrncpy(ir,user2->invite_room->name,sizeof(ir));
if (!(room=get_room2(user2->homeroom))) sntrncpy(user2->homeroom,"crater",sizeof(user2->homeroom));
if (user2->type==REMOTE_TYPE || !user2->room) hs=0; else hs=1;
snprintf(text,sizeof(text),"~BB~FKChar echo~RS~BB   ~OL~FY:~RS~BB ~OL~FT%-3s~RS~BB                       ~RS~BR~FKAnnoyed~RS~BR   ~OL~FY:~RS~BR ~OL~FT%-3s~RS~BR                         \n",noyes1[user2->charmode_echo],noyes1[user2->annoy]);
write_user(user,text);
snprintf(text,sizeof(text),"~BB~FKCommand mode~RS~BB~OL~FY:~RS~BB ~OL~FT%-3s~RS~BB                       ~RS~BR~FKBeeplines~RS~BR ~OL~FY:~RS~BR ~OL~FT%-3s~RS~BR                         \n",noyes1[user2->command_mode],noyes1[user2->beepline]);
write_user(user,text);
snprintf(text,sizeof(text),"~BB~FKExamining on~RS~BB~OL~FY:~RS~BB ~OL~FT%-3s~RS~BB                       ~RS~BR~FKBeeplogins~RS~BR~OL~FY:~RS~BR ~OL~FT%-3s~RS~BR                         \n",noyes1[user2->examine],noyes1[user2->beeplogin]);
write_user(user,text);
snprintf(text,sizeof(text),"~BB~FKOn home site~RS~BB~OL~FY:~RS~BB ~OL~FT%-3s~RS~BB                       ~RS~BR~FKColor~RS~BR     ~OL~FY:~RS~BR ~OL~FT%-3s~RS~BR                         \n",noyes1[hs],noyes1[user2->color]);
write_user(user,text);
snprintf(text,sizeof(text),"~BB~FKS.comm. mode~RS~BB~OL~FY:~RS~BB ~OL~FT%-3s~RS~BB                       ~RS~BR~FKColorized~RS~BR ~OL~FY:~RS~BR ~OL~FT%-3s~RS~BR                         \n",noyes1[user2->scommand_mode],noyes1[(user2->colorize)]);
write_user(user,text);
snprintf(text,sizeof(text),"~BM~FKUnread mail~RS~BM ~OL~FY:~RS~BM ~OL~FT%-3s~RS~BM                       ~RS~BG~FKDarkness~RS~BG  ~OL~FY:~RS~BG ~OL~FT%-3s~RS~BG                         \n",noyes1[has_unread_mail(user2)],noyes1[user2->dark]);
write_user(user,text);
snprintf(text,sizeof(text),"~BM~FKVisible~RS~BM     ~OL~FY:~RS~BM ~OL~FT%-3s~RS~BM                       ~RS~BG~FKWoohooed~RS~BG  ~OL~FY:~RS~BG ~OL~FT%-3s~RS~BG                         \n",noyes1[user2->vis],noyes1[(user2->woohoo)]);
write_user(user,text);
snprintf(text,sizeof(text),"~BM~FKWord wrap~RS~BM   ~OL~FY:~RS~BM ~OL~FT%-3s~RS~BM                       ~RS",noyes1[user2->wordwrap]);
if (user2->exd==1) snprintf(text2,sizeof(text2),"~BG~FKExamined~RS~BG  ~OL~FY:~RS~BG ~OL~FT%i time~RS~BG",user2->exd);
else snprintf(text2,sizeof(text2),"~BG~FKExamined~RS~BG  ~OL~FY:~RS~BG ~OL~FT%i times~RS~BG",user2->exd);
strncat(text,text2,sizeof(text));
for(i=strlen(text)-(color_com_count(text,0)*3);i<80;++i) strncat(text," ",sizeof(text));
strncat(text,"\n",sizeof(text));
write_user(user,text);
snprintf(text,sizeof(text),"~BM~FKHome room~RS~BM   ~OL~FY:~RS~BM ~OL~FT%s",user2->homeroom);
for(i=strlen(text)-(color_com_count(text,0)*3);i<40;++i) strncat(text," ",sizeof(text));
snprintf(text2,sizeof(text2),"~RS~BG~FKIn phrase~RS~BG ~OL~FY:~RS~BG ~OL~FT%s",user2->in_phrase);
strncat(text,text2,sizeof(text));
for(i=strlen(text)-(color_com_count(text,0)*3);i<80;++i) strncat(text," ",sizeof(text));
strncat(text,"\n",sizeof(text));
write_user(user,text);
snprintf(text,sizeof(text),"~BM~FKInvited to~RS~BM  ~OL~FY:~RS~BM ~OL~FT%s",ir);
for(i=strlen(text)-(color_com_count(text,0)*3);i<40;++i) strncat(text," ",sizeof(text));
snprintf(text2,sizeof(text2),"~RS~BG~FKOut phrase~RS~BG~OL~FY:~RS~BG ~OL~FT%s",user2->out_phrase);
strncat(text,text2,sizeof(text));
for(i=strlen(text)-(color_com_count(text,0)*3);i<80;++i) strncat(text," ",sizeof(text));
strncat(text,"\n",sizeof(text));
write_user(user,text);
if (user2->quitting) {
	mins=(int)((user2->quitin2*60)-(time(0)-user2->quitin1))/60;
	secs=(int)((user2->quitin2*60)-(time(0)-user2->quitin1)-(mins*60));
	snprintf(text,sizeof(text),"~BM~FKQuitting in~RS~BM ~OL~FY:~RS~BM~OL~FT ");
	if (mins==1) snprintf(text2,sizeof(text2),"%d minute, ",mins);
	else snprintf(text2,sizeof(text2),"%d minutes, ",mins);
	strncat(text,text2,sizeof(text));
	if (secs==1) snprintf(text2,sizeof(text2),"%d second",secs);
	else snprintf(text2,sizeof(text2),"%d seconds",secs);
	strncat(text,text2,sizeof(text));
	strncat(text,"~RS~BM",sizeof(text));
	for(i=strlen(text)-(color_com_count(text,0)*3);i<80;++i) strncat(text," ",sizeof(text));
	strncat(text,"\n",sizeof(text));
	write_user(user,text);
	}
if (user2->booted) {
	if ((int)(time(0)<user2->boottime)) {
		snprintf(bstr,sizeof(bstr),"%s",ctime(&user2->boottime));
		bstr[strlen(bstr)-1]='\0';
		snprintf(text,sizeof(text),"~BM~FK%s may not log in until %s.",user2->name,bstr);
		for(i=strlen(text)-(color_com_count(text,0)*3);i<80;++i) strncat(text," ",sizeof(text));
		strncat(text,"\n",sizeof(text));
		write_user(user,text);
		secs=(int)(user2->boottime-time(0));
		days=secs/86400;
		hours=(secs%86400)/3600;
		mins=(secs%3600)/60;
		secs=secs%60;
		snprintf(text,sizeof(text),"~BM~FKThat's in ");
		if (days==1) snprintf(text2,sizeof(text),"%d day, ",days);
		else snprintf(text2,sizeof(text2),"%d days, ",days);
		strncat(text,text2,sizeof(text));
		if (hours==1) snprintf(text2,sizeof(text2),"%d hour, ",hours);
		else snprintf(text2,sizeof(text2),"%d hours, ",hours);
		strncat(text,text2,sizeof(text));
		if (mins==1) snprintf(text2,sizeof(text2),"%d minute, ",mins);
		else snprintf(text2,sizeof(text2),"%d minutes, ",mins);
		strncat(text,text2,sizeof(text));
		if (secs==1) snprintf(text2,sizeof(text2),"%d second.",secs);
		else snprintf(text2,sizeof(text2),"%d seconds.",secs);
		strncat(text,text2,sizeof(text));
		for(i=strlen(text)-(color_com_count(text,0)*3);i<80;++i) strncat(text," ",sizeof(text));
		strncat(text,"\n",sizeof(text));
		write_user(user,text);
		}
	}
if (user2->cron) {
	snprintf(text,sizeof(text),"~BM~FKCron job~RS~BM    ~OL~FY:~RS~BM");
	for(i=strlen(text)-(color_com_count(text,0)*3);i<80;++i) strncat(text," ",sizeof(text));
	strncat(text,"\n",sizeof(text));
	write_user(user,text);
	snprintf(text,sizeof(text),"~BM%s\n",user2->croncom);
	write_user(user,text);
	}
if (destructcount) destruct_user(user2,0);
}

/*** Read your mail ***/
void rmail(user)
UR_OBJECT user;
{
char c,filename[FILENAME_LEN],id[82],line[82];
int cnt=0,cnt2=0,lines,newmail;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"You have no mail.\n");
	return;
	}
fclose(fp);
if (word_count==1) {
	scom_main(user,NULL,3,0);
	return;
	}
if (!strcmp(word[1],"all")) {
	user->mesg=1;
	user->misc_op=100;
	write_user(user,"\n~BB~OL~FY*** Your mail ***\n\n");
	ptdisplay(user,NULL,1,0);
	return;
	}
if (!strcmp(word[1],"new")) {
	if (!(fp=fopen(filename,"r"))) return;
	fgets(line,sizeof(line),fp);
	while(!feof(fp)) {
		sscanf(line,"%s %d",id,&newmail);
		if (!strcmp(id,"PT:")) {
			++cnt;
			if (newmail>(int)user->read_mail) {
				fclose(fp);
				write_user(user,"\n~BB~OL~FY*** Your new mail ***\n\n");
				user->misc_op=100;
				user->mesg=cnt;
				ptdisplay(user,NULL,1,0);
				return;
				}
			}
		fgets(line,sizeof(line),fp);
		}
	fclose(fp);
	write_user(user,"You have no new mail.\n");
	return;
	}
if (!isnumber(word[1])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<lines from the end>]\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s [<lines from the end>]\n",command[com_num]+1);
	write_user(user,text);
	return;
	}
if (!(fp=fopen(filename,"r"))) { write_user(user,"\n~BB~OL~FY*** Your mail ***\n\n"); write_user(user,"You have no mail."); return; }
lines=atoi(word[1]);
cnt=newline_count(filename,1);
if (cnt<lines) {
	if (cnt==1) snprintf(text,sizeof(text),"There is only %d line in your mail.\n",cnt);
	else snprintf(text,sizeof(text),"There are only %d lines in your mail.\n",cnt);
	write_user(user,text);
	fclose(fp);
	return;
	}
if (cnt==lines) {
	fclose(fp);
	write_user(user,"\n~BB~OL~FY*** Your mail ***\n");
	more(user,filename,2);
	return;
	}
fseek(fp,0,0);
c=getc(fp);
while(!feof(fp)) {
	if (c=='\n') ++cnt2;
	c=getc(fp);
	if (cnt2==cnt-lines) {
		if (lines==1) snprintf(text,sizeof(text),"\n~BB~OL~FY*** Your mail (last %d line) ***\n",lines);
		else snprintf(text,sizeof(text),"\n~BB~OL~FY*** Your mail (last %d lines) ***\n",lines);
		write_user(user,text);
		user->filepos=ftell(fp)-1;
		user->origpos=ftell(fp)-1;
		fclose(fp);
		more(user,filename,2);
		return;
		}
	}
fclose(fp);
snprintf(text,sizeof(text),"%s: Line count error.\n",syserror);
write_user(user,text);
write_syslog("ERROR: Line count error in rmail().\n",0);
}

/*** Set autoread ***/
void auto_read(user)
UR_OBJECT user;
{
write_user(user,"1. Never autoread mail\n");
write_user(user,"2. Autoread mail upon logging in\n");
write_user(user,"3. Autoread mail when sent new mail while online\n");
write_user(user,"4. Always autoread mail (Both 2 & 3)\n");
write_user(user,"~OLSelect (1-4) scmquit to abort => ");
user->misc_op=110;
}

/*** Read your sent mail ***/
void sent_mail(user)
UR_OBJECT user;
{
char c,filename[FILENAME_LEN],id[82],line[82];
int cnt=0,cnt2=0,lines,newmail;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.Y",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"You have not sent any mail.\n");
	return;
	}
fclose(fp);
if (word_count==1) {
	scom_main(user,NULL,3,0);
	return;
	}
if (!strcmp(word[1],"all")) {
	user->mesg=1;
	user->misc_op=111;
	write_user(user,"\n~BB~OL~FY*** Your sent mail ***\n\n");
	ptdisplay(user,NULL,4,0);
	return;
	}
if (!strcmp(word[1],"new")) {
	if (!(fp=fopen(filename,"r"))) return;
	fgets(line,sizeof(line),fp);
	while(!feof(fp)) {
		sscanf(line,"%s %d",id,&newmail);
		if (!strcmp(id,"PT:")) {
			++cnt;
			if (newmail>(int)user->read_sentmail) {
				fclose(fp);
				write_user(user,"\n~BB~OL~FY*** Your new sent mail ***\n\n");
				user->misc_op=111;
				user->mesg=cnt;
				ptdisplay(user,NULL,4,0);
				return;
				}
			}
		fgets(line,sizeof(line),fp);
		}
	fclose(fp);
	write_user(user,"You have no new sent mail.\n");
	return;
	}
if (!isnumber(word[1])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<lines from the end>]\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s [<lines from the end>]\n",command[com_num]+1);
	write_user(user,text);
	return;
	}
if (!(fp=fopen(filename,"r"))) { write_user(user,"\n~BB~OL~FY*** Your sent mail ***\n\n"); write_user(user,"You have no sent mail."); return; }
lines=atoi(word[1]);
cnt=newline_count(filename,1);
if (cnt<lines) {
	if (cnt==1) snprintf(text,sizeof(text),"There is only %d line in your sent mail.\n",cnt);
	else snprintf(text,sizeof(text),"There are only %d lines in your sent mail.\n",cnt);
	write_user(user,text);
	fclose(fp);
	return;
	}
if (cnt==lines) {
	fclose(fp);
	write_user(user,"\n~BB~OL~FY*** Your sent mail ***\n");
	more(user,filename,2);
	return;
	}
fseek(fp,0,0);
c=getc(fp);
while(!feof(fp)) {
	if (c=='\n') ++cnt2;
	c=getc(fp);
	if (cnt2==cnt-lines) {
		if (lines==1) snprintf(text,sizeof(text),"\n~BB~OL~FY*** Your sent mail (last %d line) ***\n",lines);
		else snprintf(text,sizeof(text),"\n~BB~OL~FY*** Your sent mail (last %d lines) ***\n",lines);
		write_user(user,text);
		user->filepos=ftell(fp)-1;
		user->origpos=ftell(fp)-1;
		fclose(fp);
		more(user,filename,2);
		return;
		}
	}
fclose(fp);
snprintf(text,sizeof(text),"%s: Line count error.\n",syserror);
write_user(user,text);
write_syslog("ERROR: Line count error in sent_mail().\n",0);
}

/*** Send mail message ***/
void smail(user,inpstr,done_editing)
UR_OBJECT user;
char *inpstr;
int done_editing;
{
char filename[FILENAME_LEN],*str;
int remote=0;
FILE *fp;
UR_OBJECT user2;

if (ban_smailing) {
	write_user(user,"Sorry, smailing has been turned off.\n");
	if (user->reply) end_reply(user);
	return;
	}
if (done_editing) {
	send_mail(user,user->mail_to,user->malloc_start,5);
	return;
	}
if (word_count<2) {
	write_user(user,"Smail who?\n");
	scom_main(user,NULL,3,0);
	if (user->reply) end_reply(user);
	return;
	}
str=word[1];
while(*str) {
	if (*str=='@') {
		if (str==word[1]) {
			write_user(user,"Name missing before @ sign.\n");
			if (user->reply) end_reply(user);
			return;
			}
		++remote;  break;
		}
	++str;
	}
word[1][0]=toupper(word[1][0]);
if (!remote) {
	if ((user2=get_user2(user,word[1]))) {
		if (!user2->smail && user->level<GENERAL) {
			snprintf(text,sizeof(text),"%s is not listening to smail at the moment.\n",user2->name);
			write_user(user,text);
			if (user->reply) end_reply(user);
			return;
			}
		if ((user_ignored(user2,user))) {
			snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
			write_user(user,text);
			if (user->reply) end_reply(user);
			return;
			}
		}
	else {
		if (!(user2=create_user())) {
			snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Unable to create temporary user session in smail().\n",0);
			if (user->reply) end_reply(user);
			return;
			}
		sntrncpy(user2->name,word[1],sizeof(user2->name));
		if (!load_user_details(user2)) {
			write_user(user,nosuchuser);
			destruct_user(user2,0);
			if (user->reply) end_reply(user);
			return;
			}
		if (!user2->smail && user->level<GENERAL) {
			snprintf(text,sizeof(text),"%s is not listening to smail at the moment.\n",user2->name);
			write_user(user,text);
			destruct_user(user2,0);
			if (user->reply) end_reply(user);
			return;
			}
		if (user_ignored(user2,user)) {
			snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
			write_user(user,text);
			destruct_user(user2,0);
			if (user->reply) end_reply(user);
			return;
			}
		destruct_user(user2,0);
		}
	}
if (nosmail(word[1])) {
	write_user(user,nosuchuser);
	snprintf(text,sizeof(text),"%s tried to smail %s.\n",user->name,word[1]);
	write_syslog(text,1);
	if (user->reply) end_reply(user);
	return;
	}
if (!remote) {
	snprintf(filename,sizeof(filename),"%s/%s.D",USERFILES,word[1]);
	if (!(fp=fopen(filename,"r"))) {
		write_user(user,nosuchuser);
		if (user->reply) end_reply(user);
		return;
		}
	fclose(fp);
	}
if (word_count>2) {
	strncat(inpstr,"\n",ARR_SIZE);
	send_mail(user,word[1],remove_first(inpstr),5);
	if (user->reply) end_reply(user);
	return;
	}
if (user->type==REMOTE_TYPE) {
	write_user(user,"Sorry, due to software limitations remote users cannot use the line editor.\nUse the 'smail <user> <mesg>' method instead.\n");
	if (user->reply) end_reply(user);
	return;
	}
snprintf(text,sizeof(text),"\n~BB~OL~FY*** Writing mail message to %s ***\n\n",word[1]);
write_user(user,text);
user->misc_op=4;
sntrncpy(user->mail_to,word[1],sizeof(user->mail_to));
editor(user,NULL);
}

/*** Send mail message to all users ***/
void smailall(user,inpstr,done_editing)
UR_OBJECT user;
char *inpstr;
int done_editing;
{
char name[USER_NAME_LEN+1];
int cnt=0,cnt2,i,num,total=0,which=0;
struct dirent **namelist;

if (ban_smailing) {
	write_user(user,"Sorry, smailing has been turned off.\n");
	return;
	}
if (word_count>1) which=1;
else if (done_editing) which=2;
if (which) {
	if ((num=scandir(USERFILES,&namelist,0,alphasort))==-1) return;
	if (which==1) strncat(inpstr,"\n",ARR_SIZE);
	while(cnt<num) {
		if ((strcmp(namelist[cnt]->d_name,".")) && (strcmp(namelist[cnt]->d_name,".."))) {
			cnt2=0;
			for(i=0;i<strlen(namelist[cnt]->d_name);++i) if (namelist[cnt]->d_name[i]=='.' && namelist[cnt]->d_name[i+1]=='D') ++cnt2;
			if (cnt2) {
				sntrncpy(name,split_str(namelist[cnt]->d_name,'.'),sizeof(name));
				if (which==1) send_mail(user,name,inpstr,3);
				else if (which==2) send_mail(user,name,user->malloc_start,3);
				++total;
				}
			}
		++cnt;
		}
	if (total==1) snprintf(text,sizeof(text),"Total of %i user mailed.\n",total);
	else snprintf(text,sizeof(text),"Total of %i users mailed.\n",total);
	write_user(user,text);
	return;
	}
if (user->type==REMOTE_TYPE) {
	write_user(user,"Sorry, due to software limitations remote users cannot use the line editor.\nUse the 'smailall <mesg>' method instead.\n");
	return;
	}
write_user(user,"\n~BB~OL~FY*** Writing mail message to all users ***\n\n");
user->misc_op=55;
editor(user,NULL);
}

/*** Mass time ***/
void mass(user,which)
UR_OBJECT user;
int which;
{
write_user(user,"Enter user (scmquit to stop): ");
if (!which) user->misc_op=76;
else if (which==1) user->misc_op=90;
else if (which==2) user->misc_op=91;
}

/*** Add user to temporary mass file ***/
void addmass(user,which)
UR_OBJECT user;
int which;
{
char filename[FILENAME_LEN],line[82];
int cnt;
FILE *fp;

if (strlen(word[0])>USER_NAME_LEN) {
	write_user(user,"Try a valid name.\n");
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	if (!(fp=fopen(filename,"a"))) {
		write_user(user,"An error has occurred. Like you know, whatever.\n");
		nomass(user);
		return;
		}
	fprintf(fp,"%s\n",word[0]);
	fclose(fp);
	return;
	}
fscanf(fp,"%s",line);
while(!feof(fp)) {
	if (!strcmp(line,word[0])) {
		if (!which) write_user(user,"You are already mailing that user.\n");
		else if (which==1) write_user(user,"You are already emoting to that user.\n");
		else if (which==2) write_user(user,"You are already telling to that user.\n");
		fclose(fp);
		return;
		}
	fscanf(fp,"%s",line);
	}
cnt=newline_count(filename,1);
if (cnt<100) {
	if (!(fp=fopen(filename,"a"))) return;
	fprintf(fp,"%s\n",word[0]);
	fclose(fp);
	return;
	}
else {
	if (!(fp=fopen(filename,"a"))) return;
	fprintf(fp,"%s\n",word[0]);
	fclose(fp);
	write_user(user,"Maximum names added.\n");
	if (!which) massmailtime(user,0);
	else if (which==1) massemotetime(user,0);
	else if (which==2) masstelltime(user,0);
	}
}

/*** Mass mail time ***/
void massmailtime(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
FILE *fp;
UR_OBJECT user2;

if (user->muzzled) {
	write_user(user,"You are muzzled, you cannot mass mail.\n");
	nomass(user);
	return;
	}
if (ban_smailing) {
	write_user(user,"Sorry, smailing has been turned off.\n");
	nomass(user);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"No users to mass mail.\n");
	nomass(user);
	return;
	}
if (!done_editing) fclose(fp);
else {
	if (ban_swearing && contains_swearing(user->malloc_start)) {
		fclose(fp);
		swore(user);
		return;
		}
	while(!feof(fp)) {
		fscanf(fp,"%s\n",name);
		if (nosmail(name)) continue;
		if ((user2=get_user(name,0))) {
			if (!user2->smail) continue;
			if (user_ignored(user2,user)) continue;
			}
		else {
			if (!(user2=create_user())) {
				snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
				write_user(user,text);
				write_syslog("ERROR: Unable to create temporary user session in massmailtime().\n",0);
				fclose(fp);
				return;
				}
			sntrncpy(user2->name,name,sizeof(user2->name));
			if (!load_user_details(user2)) {
				destruct_user(user2,0);
				continue;
				}
			if (!user2->smail) {
				destruct_user(user2,0);
				continue;
				}
			if (user_ignored(user2,user)) {
				destruct_user(user2,0);
				continue;
				}
			destruct_user(user2,0);
			}
		send_mail(user,name,user->malloc_start,4);
		}
	fclose(fp);
	return;
	}
write_user(user,"\n~BB~OL~FY*** Writing mass mail message ***\n\n");
user->misc_op=77;
editor(user,NULL);
}

/*** Mass emote time ***/
void massemotetime(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
int cnt=0;
FILE *infp;
UR_OBJECT user2;

if (user->muzzled) {
	write_user(user,"You are muzzled, you cannot mass emote.\n");
	nomass(user);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
if (!(infp=fopen(filename,"r"))) {
	write_user(user,"No users to mass emote to.\n");
	nomass(user);
	return;
	}
if (!done_editing) fclose(infp);
else {
	if (user->malloc_start[0]=='\'') snprintf(text,sizeof(text),"~OL~FBMass emote ~OL~FR>>~RS %s%s",user->name,user->malloc_start);
	else snprintf(text,sizeof(text),"~OL~FBMass emote ~OL~FR>>~RS %s %s",user->name,user->malloc_start);
	while(!feof(infp)) {
		fscanf(infp,"%s\n",name);
		if ((user2=get_user(name,0)) && user2->listen && user2->tell && !user_ignored(user2,user)) {
			if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
			if (user2->afk) write_afklog(user2,text);
			else write_user(user2,text);
			if (!cnt) {
				if (user->malloc_start[0]=='\'') snprintf(text,sizeof(text),"(Mass emote) %s%s",user->name,user->malloc_start);
				else snprintf(text,sizeof(text),"(Mass emote) %s %s",user->name,user->malloc_start);
				write_user(user,text);
				++cnt;
				}
			}
		}
	fclose(infp);
	if (!cnt) write_user(user,"None of the people you wish to mass emote to are signed on.\n");
	return;
	}
write_user(user,"\n~BB~OL~FY*** Writing mass emote message ***\n\n");
user->misc_op=92;
editor(user,NULL);
}

/*** Mass tell time ***/
void masstelltime(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1],type[12];
int cnt=0;
FILE *infp;
UR_OBJECT user2;

if (user->muzzled) {
	write_user(user,"You are muzzled, you cannot mass tell.\n");
	nomass(user);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
if (!(infp=fopen(filename,"r"))) {
	write_user(user,"No users to mass tell to.\n");
	nomass(user);
	return;
	}
if (!done_editing) fclose(infp);
else {
	snprintf(text,sizeof(text),"~OL~FB(Friendly message)~RS %s tells you: %s",user->name,user->malloc_start);
	while(!feof(infp)) {
		fscanf(infp,"%s\n",name);
		if ((user2=get_user(name,0)) && user2->listen && user2->tell && !user_ignored(user2,user)) {
			if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
			if (user2->afk) write_afklog(user2,text);
			else write_user(user2,text);
			if (!cnt) {
				if (user->malloc_start[strlen(user->malloc_start)-2]=='?') sntrncpy(type,"ask",sizeof(type));
				else if (user->malloc_start[strlen(user->malloc_start)-2]=='!') sntrncpy(type,"exclaim to",sizeof(type));
				else sntrncpy(type,"tell",sizeof(type)-2);
				snprintf(text,sizeof(text),"You %s the users you are mass telling: %s",type,user->malloc_start);
				write_user(user,text);
				++cnt;
				}
			}
		}
	fclose(infp);
	if (!cnt) write_user(user,"None of the people you wish to mass tell to are signed on.\n");
	return;
	}
write_user(user,"\n~BB~OL~FY*** Writing mass tell message ***\n\n");
user->misc_op=93;
editor(user,NULL);
}

/*** Stop mass ***/
void nomass(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];

if (destructed) return;
user->misc_op=0;
snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
unlink(filename);
}

/*** Delete some or all of your mail. A problem here is once we have deleted
     some mail from the file do we mark the file as read? If not we could
     have a situation where the user deletes all his mail but still gets
     the YOU HAVE UNREAD MAIL message on logging in if the idiot forgot to
     read it first ***/
void dmail(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],garbage[82],id[82],line[82],name[USER_NAME_LEN+1];
int cnt=0,num,ret;
FILE *infp,*outfp;

if (word_count<2 || ((num=atoi(word[1]))<1 && word[1][0]!='$' && word[1][0]!='#' && strcmp(word[1],"*") && strcmp(word[1],"all") && strcmp(word[1],"prompt"))) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <num>/$name/#num/(*/all)/prompt\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <num>/$name/#num/(*/all)/prompt\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,user->name);
if (!(infp=fopen(filename,"r"))) {
	write_user(user,"You have no mail.\n");
	user->misc_op=0;
	user->mesg=0;
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile in dmail().\n",0);
	fclose(infp);
	return;
	}
if (!strcmp(word[1],"all") || !strcmp(word[1],"*")) {
	fclose(infp);  fclose(outfp);
	unlink(filename);
	write_user(user,"All mail deleted.\n");
	return;
	}
else if (!strcmp(word[1],"prompt")) {
	++user->mesg;
	ret=ptdisplay(user,NULL,1,0);
	if (ret) {
		write_user(user,"Do you wish to delete this message (y/n)? (scmquit to abort) ");
		user->misc_op=69;
		}
	else { write_user(user,"You have no mail.\n"); user->misc_op=0; user->mesg=0; }
	fclose(infp);  fclose(outfp);
	return;
	}
else if (word[1][0]=='$') {
	sntrncpy(word[1],word[1]+1,sizeof(word[1]));
	if (!strlen(word[1])) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <num>/$name/#num/(*/all)/prompt\n",command[com_num]);
		else snprintf(text,sizeof(text),"Usage: %s <num>/$name/#num/(*/all)/prompt\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	word[1][0]=toupper(word[1][0]);
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s %s %s",id,garbage,garbage);
	sntrncpy(name,pt_name(line),sizeof(name));
	while(!feof(infp)) {
		if (!strcmp(id,"PT:") && !strcmp(name,word[1])) {
			++cnt;
			fgets(line,sizeof(line),infp);
			sscanf(line,"%s %s %s",id,garbage,garbage);
			sntrncpy(name,pt_name(line),sizeof(name));
			while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s %s %s",id,garbage,garbage);
				sntrncpy(name,pt_name(line),sizeof(name));
				}
			}
		else {
			fputs(line,outfp);
			fgets(line,sizeof(line),infp);
			sscanf(line,"%s %s %s",id,garbage,garbage);
			sntrncpy(name,pt_name(line),sizeof(name));
			while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
				fputs(line,outfp);
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s %s %s",id,garbage,garbage);
				sntrncpy(name,pt_name(line),sizeof(name));
				}
			fputs("\n",outfp);
			}
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s %s %s",id,garbage,garbage);
		sntrncpy(name,pt_name(line),sizeof(name));
		}
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in dmail().\n",0);
		return;
		}
	if (!cnt) { write_user(user,"No messages by that user.\n"); return; }
	else {
		if (cnt==1) snprintf(text,sizeof(text),"%d message deleted.\n",cnt);
		else snprintf(text,sizeof(text),"%d messages deleted.\n",cnt);
		write_user(user,text);
		}
	if (!(infp=fopen(filename,"r"))) return;
	cnt=0;
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) ++cnt;
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);
	if (!cnt) unlink(filename);
	return;
	}
else if (word[1][0]=='#') {
	num=atoi(word[1]+1);
	if (!num) {
		write_user(user,"Not a valid message number.\n");
		fclose(infp);  fclose(outfp);
		return;
		}
	cnt=0;
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s",id);
	while(!feof(infp)) {
		if (!strcmp(id,"PT:")) {
			if (++cnt==num) {
				while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
					fgets(line,sizeof(line),infp);
					sscanf(line,"%s",id);
					}
				}
			else {
				fputs(line,outfp);
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s",id);
				while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
					fputs(line,outfp);
					fgets(line,sizeof(line),infp);
					sscanf(line,"%s",id);
					}
				fputs("\n",outfp);
				}
			}
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s",id);
		}
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in dmail().\n",0);
		return;
		}
	if (cnt<num) { write_user(user,"No such message.\n"); return; }
	else {
		snprintf(text,sizeof(text),"Message #%d deleted.\n",num);
		write_user(user,text);
		}
	if (!(infp=fopen(filename,"r"))) return;
	cnt=0;
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) ++cnt;
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);
	if (!cnt) unlink(filename);
	return;
	}
cnt=0;
fgets(line,sizeof(line),infp);
while(!feof(infp)) {
	if (cnt<=num) {
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) if (++cnt>num) fputs(line,outfp);
		}
	else fputs(line,outfp);
	fgets(line,sizeof(line),infp);
	}
fclose(infp);  fclose(outfp);
unlink(filename);
if (cnt<num) {
	unlink(TEMPFILE);
	if (cnt==1) snprintf(text,sizeof(text),"There was only %d message in your mailbox, all now deleted.\n",cnt);
	else snprintf(text,sizeof(text),"There were only %d messages in your mailbox, all now deleted.\n",cnt);
	write_user(user,text);
	return;
	}
if (cnt==num) {
	unlink(TEMPFILE);
	write_user(user,"All mail deleted.\n");
	}
else {
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in dmail().\n",0);
		return;
		}
	}
if (num==1) snprintf(text,sizeof(text),"%d message deleted from your mailbox.\n",num);
else snprintf(text,sizeof(text),"%d messages deleted from your mailbox.\n",num);
write_user(user,text);
}

/*** Delete some or all of your sent mail ***/
void dsentmail(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],id[82],line[82];
int cnt=0,num,ret;
FILE *infp,*outfp;

if (word_count<2 || ((num=atoi(word[1]))<1 && word[1][0]!='#' && strcmp(word[1],"*") && strcmp(word[1],"all") && strcmp(word[1],"prompt"))) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <num>/#num/(*/all)/prompt\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <num>/#num/(*/all)/prompt\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.Y",USERFILES,user->name);
if (!(infp=fopen(filename,"r"))) {
	write_user(user,"You have no sent mail.\n");
	user->misc_op=0;
	user->mesg=0;
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile in dsentmail().\n",0);
	fclose(infp);
	return;
	}
if (!strcmp(word[1],"all") || !strcmp(word[1],"*")) {
	fclose(infp);  fclose(outfp);
	unlink(filename);
	write_user(user,"All sent mail deleted.\n");
	return;
	}
else if (!strcmp(word[1],"prompt")) {
	++user->mesg;
	ret=ptdisplay(user,NULL,1,0);
	if (ret) {
		write_user(user,"Do you wish to delete this message (y/n)? (scmquit to abort) ");
		user->misc_op=113;
		}
	else { write_user(user,"You have no sent mail.\n"); user->misc_op=0; user->mesg=0; }
	fclose(infp);  fclose(outfp);
	return;
	}
else if (word[1][0]=='#') {
	num=atoi(word[1]+1);
	if (!num) {
		write_user(user,"Not a valid message number.\n");
		fclose(infp);  fclose(outfp);
		return;
		}
	cnt=0;
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s",id);
	while(!feof(infp)) {
		if (!strcmp(id,"PT:")) {
			if (++cnt==num) {
				while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
					fgets(line,sizeof(line),infp);
					sscanf(line,"%s",id);
					}
				}
			else {
				fputs(line,outfp);
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s",id);
				while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
					fputs(line,outfp);
					fgets(line,sizeof(line),infp);
					sscanf(line,"%s",id);
					}
				fputs("\n",outfp);
				}
			}
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s",id);
		}
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in dsentmail().\n",0);
		return;
		}
	if (cnt<num) { write_user(user,"No such message.\n"); return; }
	else {
		snprintf(text,sizeof(text),"Message #%d deleted.\n",num);
		write_user(user,text);
		}
	if (!(infp=fopen(filename,"r"))) return;
	cnt=0;
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) ++cnt;
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);
	if (!cnt) unlink(filename);
	return;
	}
cnt=0;
fgets(line,sizeof(line),infp);
while(!feof(infp)) {
	if (cnt<=num) {
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) if (++cnt>num) fputs(line,outfp);
		}
	else fputs(line,outfp);
	fgets(line,sizeof(line),infp);
	}
fclose(infp);  fclose(outfp);
unlink(filename);
if (cnt<num) {
	unlink(TEMPFILE);
	if (cnt==1) snprintf(text,sizeof(text),"There was only %d message in your sent mailbox, all now deleted.\n",cnt);
	else snprintf(text,sizeof(text),"There were only %d messages in your sent mailbox, all now deleted.\n",cnt);
	write_user(user,text);
	return;
	}
if (cnt==num) {
	unlink(TEMPFILE);
	write_user(user,"All sent mail deleted.\n");
	}
else {
	if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in dsentmail().\n",0);
		return;
		}
	}
if (num==1) snprintf(text,sizeof(text),"%d message deleted from your sent mailbox.\n",num);
else snprintf(text,sizeof(text),"%d messages deleted from your sent mailbox.\n",num);
write_user(user,text);
}

/*** Show list of people your mail is from without seeing the whole lot ***/
void mail_from(user,which)
UR_OBJECT user;
int which;
{
char filename[FILENAME_LEN],id[82],line[82];
int cnt=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"You have no mail.\n");
	return;
	}
if (!which) write_user(user,"\n~BB~OL~FY*** Mail from ***\n\n");
else {
	while(!feof(fp) && user->fromcnt>cnt) {
		fgets(line,sizeof(line),fp);
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) ++cnt;
		}
	}
cnt=0;
fgets(line,sizeof(line),fp);
while(!feof(fp)) {
	sscanf(line,"%s",id);
	if (!strcmp(id,"PT:")) {
		sntrncpy(line,remove_first(remove_first(line)),sizeof(line));
		snprintf(text,sizeof(text),"Message #%i: %s",user->fromcnt+cnt+1,line);
		write_user(user,text);
		if (++cnt==19) {
			user->fromcnt+=cnt;
			write_user(user,"~BR~OL*** PRESS <RETURN>, E<RETURN> TO EXIT ***");
			user->misc_op=108;
			fclose(fp);
			return;
			}
		}
	fgets(line,sizeof(line),fp);
	}
fclose(fp);
if (which) cnt+=user->fromcnt;
user->fromcnt=0;
user->misc_op=0;
}

/*** Show list of people your sent mail is from without seeing the whole lot ***/
void mail_sfrom(user,which)
UR_OBJECT user;
int which;
{
char filename[FILENAME_LEN],id[82],line[82];
int cnt=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.Y",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"You have no sent mail.\n");
	return;
	}
if (!which) write_user(user,"\n~BB~OL~FY*** Sent mail from ***\n\n");
else {
	while(!feof(fp) && user->fromcnt>cnt) {
		fgets(line,sizeof(line),fp);
		sscanf(line,"%s",id);
		if (!strcmp(id,"PT:")) ++cnt;
		}
	}
cnt=0;
fgets(line,sizeof(line),fp);
while(!feof(fp)) {
	sscanf(line,"%s",id);
	if (!strcmp(id,"PT:")) {
		sntrncpy(line,remove_first(remove_first(line)),sizeof(line));
		snprintf(text,sizeof(text),"Message #%i: %s",user->fromcnt+cnt+1,line);
		write_user(user,text);
		if (++cnt==19) {
			user->fromcnt+=cnt;
			write_user(user,"~BR~OL*** PRESS <RETURN>, E<RETURN> TO EXIT ***");
			user->misc_op=112;
			fclose(fp);
			return;
			}
		}
	fgets(line,sizeof(line),fp);
	}
fclose(fp);
if (which) cnt+=user->fromcnt;
user->fromcnt=0;
user->misc_op=0;
}

/*** Display one particular message ***/
int ptdisplay(user,room,which,which2)
UR_OBJECT user;
RM_OBJECT room;
int which,which2;
{
char filename[FILENAME_LEN],garbage[82],id[82],line[82];
int cnt=0,newtime,ptcnt,retval=0;
FILE *fp;

if (!which && room) snprintf(filename,sizeof(filename),"%s/%s.B",DATAFILES,room->name);
else if (which==1 && user) snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,user->name);
else if (which==2) snprintf(filename,sizeof(filename),"complaints.txt");
else if (which==3) snprintf(filename,sizeof(filename),"sugg.txt");
else if (which==4 && user) snprintf(filename,sizeof(filename),"%s/%s.Y",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	if ((user->misc_op==99 && !which2) || (which2 && user->ptmisc_op==99)) {
		write_user(user,"There are no messages on the board.\n");
		user->misc_op=0;
		user->mesg=0;
		user->pnq=0;
		user->readroom=NULL;
		}
	else if ((user->misc_op==100 && !which2) || (which2 && user->ptmisc_op==100)) {
		write_user(user,"You have no mail.\n");
		user->misc_op=0;
		user->mesg=0;
		user->pnq=0;
		}
	else if ((user->misc_op==101 && !which2) || (which2 && user->ptmisc_op==101)) {
		write_user(user,"There are no complaints. yay!\n");
		user->misc_op=0;
		user->mesg=0;
		user->pnq=0;
		}
	else if ((user->misc_op==102 && !which2) || (which2 && user->ptmisc_op==102)) {
		write_user(user,"There are no suggestions.\n");
		user->misc_op=0;
		user->mesg=0;
		user->pnq=0;
		}
	else if ((user->misc_op==111 && !which2) || (which2 && user->ptmisc_op==111)) {
		write_user(user,"You have no sent mail.\n");
		user->misc_op=0;
		user->mesg=0;
		user->pnq=0;
		}
	return retval;
	}
if (user->misc_op==99 || user->misc_op==100 || user->misc_op==101 || user->misc_op==102 || user->misc_op==107 || user->misc_op==111) {
	if (!user->pnq && user->mesg>1) user->pnq=1;
	else if (user->pnq==1 && user->mesg==1) user->pnq=0;
	}
fgets(line,sizeof(line),fp);
sscanf(line,"%s %d %s",id,&newtime,garbage);
while(!feof(fp)) {
	if (!strcmp(id,"PT:")) {
		if (++cnt==user->mesg) {
			sscanf(line,"%s %d %s",id,&newtime,garbage);
			sntrncpy(user->mail_to,pt_name(line),sizeof(user->mail_to));
			if (user->misc_op==100 && user->read_mail<(time_t)newtime) user->read_mail=(time_t)newtime;
			else if (user->misc_op==111 && user->read_sentmail<(time_t)newtime) user->read_sentmail=(time_t)newtime;
			retval=1;
			text[0]='\0';
			if (!which2) {
				switch(rand()%12) {
					case 0: strncat(text,"~FR",sizeof(text)); break;
					case 1: strncat(text,"~FB",sizeof(text)); break;
					case 2: strncat(text,"~FT",sizeof(text)); break;
					case 3: strncat(text,"~FG",sizeof(text)); break;
					case 4: strncat(text,"~FM",sizeof(text)); break;
					case 5: strncat(text,"~OL~FY",sizeof(text)); break;
					case 6: strncat(text,"~OL~FW",sizeof(text)); break;
					case 7: strncat(text,"~OL~FR",sizeof(text)); break;
					case 8: strncat(text,"~OL~FB",sizeof(text)); break;
					case 9: strncat(text,"~OL~FT",sizeof(text)); break;
					case 10: strncat(text,"~OL~FG",sizeof(text)); break;
					default: strncat(text,"~OL~FM",sizeof(text));
					}
				strncat(text,PTSTR,sizeof(text));
				write_user(user,text);
				write_user(user,line);
				}
			else fseek(fp,user->ptpos,0);
			ptcnt=1;
			fgets(line,sizeof(line),fp);
			sscanf(line,"%s %d %s",id,&newtime,garbage);
			while(!feof(fp) && *line!='\n' && strcmp(id,"PT:")) {
				if (++ptcnt==PAGEWIDTH && strcmp(word[1],"prompt")) {
					user->ptpos=ftell(fp);
					write_user(user,"~BR~OL*** PRESS <RETURN>, E<RETURN> TO EXIT ***");
					if (!which2) {
						user->ptmisc_op=user->misc_op;
						user->misc_op=107;
						}
					fclose(fp);
					return retval;
					}
				write_user(user,line);
				fgets(line,sizeof(line),fp);
				sscanf(line,"%s %d %s",id,&newtime,garbage);
				}
			if (which2) {
				user->ptpos=0;
				user->misc_op=user->ptmisc_op;
				user->ptmisc_op=0;
				}
			fclose(fp);
			if (user->misc_op==100) {
				if (user->pnq==2) {
					if (user->mesg==1) user->pnq=0;
					else --user->pnq;
					}
				if (!user->pnq) {
					if (user->level>=com_level[RMAIL]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FGReply~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FGr~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
					else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
					}
				else {
					if (user->level>=com_level[RMAIL]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FGReply~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FGr~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
					else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
					}
				}
			else if (user->misc_op==111) {
				if (user->pnq==2) {
					if (user->mesg==1) user->pnq=0;
					else --user->pnq;
					}
				if (!user->pnq) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
				}
			else if (user->misc_op==99 || user->misc_op==101 || user->misc_op==102) {
				if (user->pnq==2) {
					if (user->mesg==1) user->pnq=0;
					else --user->pnq;
					}
				if (!user->pnq) {
					if (user->misc_op==99) {
						if (user->level>=com_level[WIPE]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
						}
					else if (user->misc_op==101) {
						if (user->level>=com_level[DCOMPLAIN]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
						}
					else if (user->level>=com_level[DSUGGEST]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
					else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
					}
				else {
					if (user->misc_op==99) {
						if (user->level>=com_level[WIPE]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
						}
					else if (user->misc_op==101) {
						if (user->level>=com_level[DCOMPLAIN]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
						}
					else if (user->level>=com_level[DSUGGEST]) write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FRDelete~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FRd~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
					else write_user(user,"~OL[~RS~OL~FBNext~RS, ~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FBn~RS/~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
					}
				}
			return retval;
			}
		else {
			fgets(line,sizeof(line),fp);
			sscanf(line,"%s %d %s",id,&newtime,garbage);
			while(!feof(fp) && *line!='\n' && strcmp(id,"PT:")) {
				fgets(line,sizeof(line),fp);
				sscanf(line,"%s %d %s",id,&newtime,garbage);
				}
			}
		}
	fgets(line,sizeof(line),fp);
	sscanf(line,"%s %d %s",id,&newtime,garbage);
	}
fclose(fp);
if (which2) {
	user->ptpos=0;
	user->misc_op=user->ptmisc_op;
	user->ptmisc_op=0;
	}
if (user->misc_op==99 || user->misc_op==100 || user->misc_op==101 || user->misc_op==102 || user->misc_op==111) {
	write_user(user,"No more messages.\n");
	user->mesg=cnt+1;
	user->pnq=2;
	write_user(user,"~OL[~RS~OL~FMPrevious~RS, ~OL~FYExit~RS ~OL~FT(~RS~OL~FMp~RS/~OL~FYe~RS~OL~FT)~RS~OL]~RS: ");
	}
return retval;
}

/*** Reply ***/
void reply(user)
UR_OBJECT user;
{
char id[82],infile[FILENAME_LEN],outfile[FILENAME_LEN],line[82];
int cnt=0,newtime;
FILE *infp,*outfp;

snprintf(infile,sizeof(infile),"%s/%s.M",USERFILES,user->name);
snprintf(outfile,sizeof(outfile),"%s/%s.M",USERFILES,user->mail_to);
if (!(infp=fopen(infile,"r"))) return;
if (!(outfp=fopen(outfile,"a"))) { fclose(infp); return; }
fgets(line,sizeof(line),infp);
sscanf(line,"%s %d",id,&newtime);
while(!feof(infp)) {
	if (!strcmp(id,"PT:")) {
		if (++cnt==user->mesg) {
			fprintf(outfp,"~RS\nOriginal message:\n>%s",remove_first(remove_first(line)));
			fgets(line,sizeof(line),infp);
			sscanf(line,"%s %d",id,&newtime);
			while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
				fprintf(outfp,">%s",line);
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s %d",id,&newtime);
				}
			fputs("\n",outfp);
			fclose(infp);  fclose(outfp);
			return;
			}
		else {
			fgets(line,sizeof(line),infp);
			sscanf(line,"%s %d",id,&newtime);
			while(!feof(infp) && *line!='\n' && strcmp(id,"PT:")) {
				fgets(line,sizeof(line),infp);
				sscanf(line,"%s %d",id,&newtime);
				}
			}
		}
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s %d",id,&newtime);
	}
fclose(infp);  fclose(outfp);
}

/*** End reply ***/
void end_reply(user)
UR_OBJECT user;
{
user->mail_to[0]='\0';
if (user->reply==1) user->misc_op=100;
else user->misc_op=111;
user->reply=0;
++user->mesg;
ptdisplay(user,NULL,1,0);
}

/*** Enter user profile ***/
void enter_profile(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],*str;
FILE *fp;

if (!done_editing) {
	write_user(user,"\n~BB~OL~FY*** Writing profile ***\n\n");
	user->misc_op=5;
	editor(user,NULL);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.P",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't save your profile.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in enter_profile().\n",filename);
	write_syslog(text,0);
	return;
	}
str=user->malloc_start;
if (ban_swearing && contains_swearing(str)) {
	fclose(fp);
	swore(user);
	return;
	}
while(str!=user->malloc_end) putc(*str++,fp);
fclose(fp);
write_user(user,"Profile stored.\n");
}

/*** Store user profile ***/
void store_profile(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.P",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't save your profile.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in store_profile().\n",filename);
	write_syslog(text,0);
	return;
	}
fputs(user->lprofile,fp);
fclose(fp);
}

/*** Enter profile for another user ***/
void set_profile(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],*str;
FILE *fp;
UR_OBJECT user2;

if (word_count<2 && !done_editing) {
	write_user(user,"Enter profile for who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!done_editing) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in set_profile().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) { destruct_user(user2,0); return; }
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to kill you!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	destruct_user(user2,0);
	sntrncpy(user->setpro,word[1],sizeof(user->setpro));
	snprintf(text,sizeof(text),"\n~BB~OL~FY*** Writing profile for %s ***\n\n",user->setpro);
	write_user(user,text);
	user->misc_op=14;
	editor(user,NULL);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.P",USERFILES,user->setpro);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't save %s's profile.\n",syserror,user->setpro);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in set_profile().\n",filename);
	write_syslog(text,0);
	user->setpro[0]='\0';
	return;
	}
str=user->malloc_start;
if (ban_swearing && contains_swearing(str)) {
	fclose(fp);
	if (swore(user)) return;
	user->setpro[0]='\0';
	return;
	}
while(str!=user->malloc_end) putc(*str++,fp);
fclose(fp);
write_user(user,"Profile stored.\n");
snprintf(text,sizeof(text),"%s changed %s's profile.\n",user->name,user->setpro);
write_syslog(text,1);
user->setpro[0]='\0';
}

/*** Examine a user ***/
void examine(user)
UR_OBJECT user;
{
char afkstr[6],filename[FILENAME_LEN];
int days,days2,hid=0,hours,hours2,mins,mins2,newmail=0;
FILE *fp;
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Examine who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
word[1][0]=toupper(word[1][0]);
if ((user2=get_user2(user,word[1]))) {
	if (user2->hid) { ++user2->exd; hid=1; }
	}
if (!(user2=get_user2(user,word[1]))) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in examine().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (special(user2->name,0) && user->level<GENERAL) {
		write_user(user,nosuchuser);
		user2->socket=5;
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		++user2->exd;
		if (!hid) save_user_details(user2,0);
		destruct_user(user2,0);
		return;
		}
	if (!user2->examine && user->level<GENERAL) {
		write_user(user,nosuchuser);
		user2->socket=5;
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		++user2->exd;
		if (!hid) save_user_details(user2,0);
		destruct_user(user2,0);
		return;
		}
	if (user_ignored(user2,user)) {
		write_user(user,nosuchuser);
		user2->socket=5;
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		++user2->exd;
		if (!hid) save_user_details(user2,0);
		destruct_user(user2,0);
		return;
		}
	snprintf(filename,sizeof(filename),"%s/%s.M",USERFILES,user2->name);
	write_user(user,"");
	snprintf(text,sizeof(text),"\nProfile of: %s %s\n",user2->morphed,user2->desc);
	write_user(user,text);
	write_user(user,"");
	snprintf(text,sizeof(text),"\nLast login: %s",ctime((time_t *)&user2->last_login));
	write_user(user,text);
	days=user2->total_login/86400;
	hours=(user2->total_login%86400)/3600;
	mins=(user2->total_login%3600)/60;
	days2=(int)(time(0)-user2->last_login)/86400;
	hours2=((int)(time(0)-user2->last_login)%86400)/3600;
	mins2=((int)(time(0)-user2->last_login)%3600)/60;
	snprintf(text,sizeof(text),"Which was : ");
	write_user(user,text);
	if (days2==1) snprintf(text,sizeof(text),"%d day, ",days2);
	else snprintf(text,sizeof(text),"%d days, ",days2);
	write_user(user,text);
	if (hours2==1) snprintf(text,sizeof(text),"%d hour, ",hours2);
	else snprintf(text,sizeof(text),"%d hours, ",hours2);
	write_user(user,text);
	if (mins2==1) snprintf(text,sizeof(text),"%d minute ago\n",mins2);
	else snprintf(text,sizeof(text),"%d minutes ago\n",mins2);
	write_user(user,text);
	snprintf(text,sizeof(text),"Was on for: ");
	write_user(user,text);
	if ((user2->last_login_len/3600)==1) snprintf(text,sizeof(text),"%d hour, ",user2->last_login_len/3600);
	else snprintf(text,sizeof(text),"%d hours, ",user2->last_login_len/3600);
	write_user(user,text);
	if ((user2->last_login_len%3600)/60==1) snprintf(text,sizeof(text),"%d minute\n",(user2->last_login_len%3600)/60);
	else snprintf(text,sizeof(text),"%d minutes\n",(user2->last_login_len%3600)/60);
	write_user(user,text);
	write_user(user,"");
	snprintf(text,sizeof(text),"\nCumulative time: ");
	write_user(user,text);
	if (days==1) snprintf(text,sizeof(text),"%d Day ",days);
	else snprintf(text,sizeof(text),"%d Days ",days);
	write_user(user,text);
	if (hours==1) snprintf(text,sizeof(text),"%d Hour ",hours);
	else snprintf(text,sizeof(text),"%d Hours ",hours);
	write_user(user,text);
	if (mins==1) snprintf(text,sizeof(text),"%d Minute.	",mins);
	else snprintf(text,sizeof(text),"%d Minutes.	",mins);
	write_user(user,text);
	snprintf(text,sizeof(text),"Total sign-ons: %d\n",user2->tsign);
	write_user(user,text);
	snprintf(text,sizeof(text),"Level: %s      Gender: %s          Age: %s\n",level_name[user2->level],user2->gender,user2->age);
	write_user(user,text);
	snprintf(text,sizeof(text),"Email Address: %s\n",user2->email);
	write_user(user,text);
	snprintf(text,sizeof(text),"Homepage URL: %s\n",user2->url);
	write_user(user,text);
	if (has_unread_mail(user2)) {
		++newmail;
		snprintf(text,sizeof(text),"%s has unread mail. ",user2->name);
		write_user(user,text);
		}
	if (user2->selfdestructing) { snprintf(text,sizeof(text),"%s will self-destruct.\n",user2->name); write_user(user,text); }
	else if (newmail) write_user(user,"\n");
	write_user(user,"\n");
	snprintf(filename,sizeof(filename),"%s/%s.P",USERFILES,user2->name);
	if (!(fp=fopen(filename,"r"))) write_user(user,"~FTey cawnt mak a prefil nouh kuz mi mommie dudnet teech mee too spil\n");
	else { fclose(fp); more(user,filename,1); }
	write_user(user,"\n");
	user2->socket=5;
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	++user2->exd;
	if (!hid) save_user_details(user2,0);
	destruct_user(user2,0);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (!user2->examine && user->level<GENERAL) {
	write_user(user,nosuchuser);
	return;
	}
if (user_ignored(user2,user)) {
	write_user(user,nosuchuser);
	return;
	}
write_user(user,"");
snprintf(text,sizeof(text),"\nProfile of: %s %s\n",user2->morphed,user2->desc);
write_user(user,text);
write_user(user,"");
days=user2->total_login/86400;
hours=(user2->total_login%86400)/3600;
mins=(user2->total_login%3600)/60;
hours2=((int)(time(0)-user2->last_login)%86400)/3600;
mins2=((int)(time(0)-user2->last_login)%3600)/60;
snprintf(text,sizeof(text),"\nOn since  : %sOn for    : ",ctime((time_t *)&user2->last_login));
write_user(user,text);
if (hours2==1) snprintf(text,sizeof(text),"%d hour, ",hours2);
else snprintf(text,sizeof(text),"%d hours, ",hours2);
write_user(user,text);
if (mins2==1) snprintf(text,sizeof(text),"%d minute\n",mins2);
else snprintf(text,sizeof(text),"%d minutes\n",mins2);
write_user(user,text);
if (user2->afk) sntrncpy(afkstr,"(AFK)",sizeof(afkstr)); else afkstr[0]='\0';
write_user(user,"");
snprintf(text,sizeof(text),"\nCumulative time: ");
write_user(user,text);
if (days==1) snprintf(text,sizeof(text),"%d Day ",days);
else snprintf(text,sizeof(text),"%d Days ",days);
write_user(user,text);
if (hours==1) snprintf(text,sizeof(text),"%d Hour ",hours);
else snprintf(text,sizeof(text),"%d Hours ",hours);
write_user(user,text);
if (mins==1) snprintf(text,sizeof(text),"%d Minute.	",mins);
else snprintf(text,sizeof(text),"%d Minutes.	",mins);
write_user(user,text);
snprintf(text,sizeof(text),"Total sign-ons: %d\n",user2->tsign);
write_user(user,text);
snprintf(text,sizeof(text),"Level: %s      Gender: %s          Age: %s\n",level_name[user2->level],user2->gender,user2->age);
write_user(user,text);
snprintf(text,sizeof(text),"Email Address: %s\n",user2->email);
write_user(user,text);
snprintf(text,sizeof(text),"Homepage URL: %s\n",user2->url);
write_user(user,text);
if (has_unread_mail(user2)) {
	++newmail;
	snprintf(text,sizeof(text),"%s has unread mail. ",user2->name);
	write_user(user,text);
	}
if (user2->selfdestructing) { snprintf(text,sizeof(text),"%s will self-destruct.\n",user2->name); write_user(user,text); }
else if (newmail) write_user(user,"\n");
write_user(user,"\n");
snprintf(filename,sizeof(filename),"%s/%s.P",USERFILES,user2->name);
if (!(fp=fopen(filename,"r"))) write_user(user,"~FTey cawnt mak a prefil nouh kuz mi mommie dudnet teech mee too spil\n");
else { fclose(fp); more(user,filename,1); }
write_user(user,"\n");
++user2->exd;
}

/*** Display last n logged in users ***/
void last_users(user,which)
UR_OBJECT user;
int which;
{
char filename[FILENAME_LEN],filename2[FILENAME_LEN],line[82],text2[80];
char temp1[20],temp2[20],temp3[20],temp4[20],temp5[20],temp6[20],temp7[20];
int ago,cnt,cnt2=0,days,hours,mins,numusers,tm,tm2;
FILE *infp,*outfp;

if (word_count<2 || which) numusers=15;
else if (isnumber(word[1])) numusers=atoi(word[1]);
else { write_user(user,"Not a valid numbers of users, is it?\n"); return; }
snprintf(filename,sizeof(filename),"%s/lastusers",DATAFILES);
if (!which) snprintf(filename2,sizeof(filename2),"%s/%s.Z",USERFILES,user->name);
else snprintf(filename2,sizeof(filename2),"%s/login",DATAFILES);
if (!(infp=fopen(filename,"r"))) {
	write_user(user,"Try again later.\n");
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	write_user(user,"Try again later.\n");
	fclose(infp);
	return;
	}
cnt=newline_count(filename,1);
if (word_count<2 && cnt<15) numusers=cnt;
if (cnt<numusers) {
	if (cnt==1) snprintf(text,sizeof(text),"There was only %d user last logged on.\n",cnt);
	else snprintf(text,sizeof(text),"There were only %d users last logged on.\n",cnt);
	write_user(user,text);
	fclose(infp);  fclose(outfp);
	if (which) unlink(filename2);
	unlink(TEMPFILE);
	return;
	}
if (cnt==numusers) {
	write_user(user,"\n~BB~OL~FY*** All last logged on users ***\n");
	fseek(infp,0,0);
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%d %d %s %s %s %s %s %s %s",&tm,&tm2,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
		ago=(int)(time(0)-tm2);
		days=ago/86400;
		hours=(ago%86400)/3600;
		mins=(ago%3600)/60;
		fprintf(outfp,"%-*s %s %s %s %s %s %s ",USER_NAME_LEN,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
		if (days==1) snprintf(text2,sizeof(text2),"%d day, ",days);
		else snprintf(text2,sizeof(text2),"%d days, ",days);
		fprintf(outfp,"%s",text2);
		if (hours==1) snprintf(text2,sizeof(text2),"%d hour, ",hours);
		else snprintf(text2,sizeof(text2),"%d hours, ",hours);
		fprintf(outfp,"%s",text2);
		if (mins==1) snprintf(text2,sizeof(text2),"%d minute ago.\n",mins);
		else snprintf(text2,sizeof(text2),"%d minutes ago.\n",mins);
		fprintf(outfp,"%s",text2);
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);  fclose(outfp);
	if (rename(TEMPFILE,filename2)==-1) {
		unlink(filename2);  unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in last_users().\n",0);
		return;
		}
	more(user,filename2,0);
	if (which) unlink(filename2);
	return;
	}
if (numusers==1) snprintf(text,sizeof(text),"\n~BB~OL~FY*** Last %d logged on user ***\n",numusers);
else snprintf(text,sizeof(text),"\n~BB~OL~FY*** Last %d logged on users ***\n",numusers);
write_user(user,text);
fseek(infp,0,0);
fgets(line,sizeof(line),infp);
while(!feof(infp) && cnt2<numusers) {
	++cnt2;
	sscanf(line,"%d %d %s %s %s %s %s %s %s",&tm,&tm2,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
	ago=(int)(time(0)-tm2);
	days=ago/86400;
	hours=(ago%86400)/3600;
	mins=(ago%3600)/60;
	fprintf(outfp,"%-*s %s %s %s %s %s %s ",USER_NAME_LEN,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
	if (days==1) snprintf(text2,sizeof(text2),"%d day, ",days);
	else snprintf(text2,sizeof(text2),"%d days, ",days);
	fprintf(outfp,"%s",text2);
	if (hours==1) snprintf(text2,sizeof(text2),"%d hour, ",hours);
	else snprintf(text2,sizeof(text2),"%d hours, ",hours);
	fprintf(outfp,"%s",text2);
	if (mins==1) snprintf(text2,sizeof(text2),"%d minute ago.\n",mins);
	else snprintf(text2,sizeof(text2),"%d minutes ago.\n",mins);
	fprintf(outfp,"%s",text2);
	fgets(line,sizeof(line),infp);
	}
fclose(infp);  fclose(outfp);
if (rename(TEMPFILE,filename2)==-1) {
	unlink(filename2);  unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in last_users().\n",0);
	return;
	}
more(user,filename2,0);
if (which) unlink(filename2);
}

/*** See when user was last on ***/
void laston(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],line[82];
int ago,days,hours,last_login,mins;
FILE *fp;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in laston().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (special(user2->name,0) && user->level<GENERAL) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (!user2->examine && user->level<GENERAL) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	snprintf(filename,sizeof(filename),"%s/%s.D",USERFILES,user2->name);
	if (!(fp=fopen(filename,"r"))) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	else {
		fgets(line,sizeof(line),fp);
		fscanf(fp,"%d",&last_login);
		}
	fclose(fp);
	ago=(int)(time(0)-last_login);
	days=ago/86400;
	hours=(ago%86400)/3600;
	mins=(ago%3600)/60;
	snprintf(text,sizeof(text),"%s was last logged in ",user2->name);
	write_user(user,text);
	if (days==1) snprintf(text,sizeof(text),"%d day, ",days);
	else snprintf(text,sizeof(text),"%d days, ",days);
	write_user(user,text);
	if (hours==1) snprintf(text,sizeof(text),"%d hour, ",hours);
	else snprintf(text,sizeof(text),"%d hours, ",hours);
	write_user(user,text);
	if (mins==1) snprintf(text,sizeof(text),"%d minute ago.\n",mins);
	else snprintf(text,sizeof(text),"%d minutes ago.\n",mins);
	write_user(user,text);
	destruct_user(user2,0);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
snprintf(text,sizeof(text),"%s is currently logged in.\n",user2->name);
write_user(user,text);
}

/*** Enter login message ***/
void enter_lim(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],*str;
FILE *fp;

if (!done_editing) {
	if (!strcmp(word[1],"delete")) {
		snprintf(filename,sizeof(filename),"%s/%s.L",USERFILES,user->name);
		if (!(fp=fopen(filename,"r"))) {
			write_user(user,"No login message.\n");
			return;
			}
		fclose(fp);
		unlink(filename);
		write_user(user,"Login message deleted.\n");
		return;
		}
	write_user(user,"\n~BB~OL~FY*** Writing login message ***\n\n");
	user->misc_op=43;
	editor(user,NULL);
	return;
	}
if (!instr(user->malloc_start,"$d")) {
	write_user(user,"Must supply at least one $ds.\n");
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.L",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't save your login message.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in enter_lim().\n",filename);
	write_syslog(text,0);
	return;
	}
str=user->malloc_start;
if (ban_swearing && contains_swearing(str)) {
	fclose(fp);
	swore(user);
	return;
	}
while(str!=user->malloc_end) putc(*str++,fp);
fclose(fp);
write_user(user,"Login message stored.\n");
}

/*** Enter login message for another user ***/
void enter_olim(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],*str;
FILE *fp;
UR_OBJECT user2;

if (word_count<2 && !done_editing) {
	write_user(user,"Enter login message for who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!done_editing) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in enter_olim().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) { destruct_user(user2,0); return; }
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to enter a login message for you!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	destruct_user(user2,0);
	sntrncpy(user->setlogin,word[1],sizeof(user->setlogin));
	if (!strcmp(word[2],"delete")) {
		snprintf(filename,sizeof(filename),"%s/%s.L",USERFILES,user->setlogin);
		if (!(fp=fopen(filename,"r"))) {
			write_user(user,"No login message.\n");
			return;
			}
		fclose(fp);
		unlink(filename);
		write_user(user,"Login message deleted.\n");
		snprintf(text,sizeof(text),"%s deleted %s's login message.\n",user->name,user->setlogin);
		write_syslog(text,1);
		return;
		}
	snprintf(text,sizeof(text),"\n~BB~OL~FY*** Writing login message for %s ***\n\n",user->setlogin);
	write_user(user,text);
	user->misc_op=44;
	editor(user,NULL);
	return;
	}
if (!instr(user->malloc_start,"$d")) {
	write_user(user,"Must supply at least one $ds.\n");
	user->setlogin[0]='\0';
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.L",USERFILES,user->setlogin);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't save %s's profile.\n",syserror,user->setlogin);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in enter_olim().\n",filename);
	write_syslog(text,0);
	user->setlogin[0]='\0';
	return;
	}
str=user->malloc_start;
if (ban_swearing && contains_swearing(str)) {
	fclose(fp);
	if (swore(user)) return;
	user->setlogin[0]='\0';
	return;
	}
while(str!=user->malloc_end) putc(*str++,fp);
fclose(fp);
write_user(user,"Login message stored.\n");
snprintf(text,sizeof(text),"%s entered a login message for %s.\n",user->name,user->setlogin);
write_syslog(text,1);
user->setlogin[0]='\0';
}

/*** Enter logout message ***/
void enter_lom(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],*str;
FILE *fp;

if (!done_editing) {
	if (!strcmp(word[1],"delete")) {
		snprintf(filename,sizeof(filename),"%s/%s.N",USERFILES,user->name);
		if (!(fp=fopen(filename,"r"))) {
			write_user(user,"No logout message.\n");
			return;
			}
		fclose(fp);
		unlink(filename);
		write_user(user,"Logout message deleted.\n");
		return;
		}
	write_user(user,"\n~BB~OL~FY*** Writing logout message ***\n\n");
	user->misc_op=52;
	editor(user,NULL);
	return;
	}
if (!instr(user->malloc_start,"$d")) {
	write_user(user,"Must supply at least one $ds.\n");
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.N",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't save your logout message.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in enter_lom().\n",filename);
	write_syslog(text,0);
	return;
	}
str=user->malloc_start;
if (ban_swearing && contains_swearing(str)) {
	fclose(fp);
	swore(user);
	return;
	}
while(str!=user->malloc_end) putc(*str++,fp);
fclose(fp);
write_user(user,"Logout message stored.\n");
}

/*** Enter logout message for another user ***/
void enter_olom(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],*str;
FILE *fp;
UR_OBJECT user2;

if (word_count<2 && !done_editing) {
	write_user(user,"Enter logout message for who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!done_editing) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in enter_olom().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) { destruct_user(user2,0); return; }
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to enter a logout message for you!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	destruct_user(user2,0);
	sntrncpy(user->setlogout,word[1],sizeof(user->setlogout));
	if (!strcmp(word[2],"delete")) {
		snprintf(filename,sizeof(filename),"%s/%s.N",USERFILES,user->setlogout);
		if (!(fp=fopen(filename,"r"))) {
			write_user(user,"No logout message.\n");
			return;
			}
		fclose(fp);
		unlink(filename);
		write_user(user,"Logout message deleted.\n");
		snprintf(text,sizeof(text),"%s deleted %s's logout message.\n",user->name,user->setlogout);
		write_syslog(text,1);
		return;
		}
	snprintf(text,sizeof(text),"\n~BB~OL~FY*** Writing logout message for %s ***\n\n",user->setlogout);
	write_user(user,text);
	user->misc_op=53;
	editor(user,NULL);
	return;
	}
if (!instr(user->malloc_start,"$d")) {
	write_user(user,"Must supply at least one $ds.\n");
	user->setlogout[0]='\0';
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.N",USERFILES,user->setlogout);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't save %s's profile.\n",syserror,user->setlogout);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in enter_olom().\n",filename);
	write_syslog(text,0);
	user->setlogout[0]='\0';
	return;
	}
str=user->malloc_start;
if (ban_swearing && contains_swearing(str)) {
	fclose(fp);
	if (swore(user)) return;
	user->setlogout[0]='\0';
	return;
	}
while(str!=user->malloc_end) putc(*str++,fp);
fclose(fp);
write_user(user,"Logout message stored.\n");
snprintf(text,sizeof(text),"%s entered a logout message for %s.\n",user->name,user->setlogout);
write_syslog(text,1);
user->setlogout[0]='\0';
}

/*** Enter vacation message ***/
void enter_vacation(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char filename[FILENAME_LEN],*str;
FILE *fp;

if (!done_editing) {
	if (!strcmp(word[1],"delete")) {
		snprintf(filename,sizeof(filename),"%s/%s.R",USERFILES,user->name);
		if (!(fp=fopen(filename,"r"))) {
			write_user(user,"No vacation message.\n");
			return;
			}
		fclose(fp);
		unlink(filename);
		write_user(user,"Vacation message deleted.\n");
		return;
		}
	write_user(user,"\n~BB~OL~FY*** Writing vacation message ***\n\n");
	user->misc_op=105;
	editor(user,NULL);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.R",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) {
	snprintf(text,sizeof(text),"%s: couldn't save your vacation message.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Couldn't open file %s to write in enter_vacation().\n",filename);
	write_syslog(text,0);
	return;
	}
str=user->malloc_start;
if (ban_swearing && contains_swearing(str)) {
	fclose(fp);
	swore(user);
	return;
	}
while(str!=user->malloc_end) putc(*str++,fp);
fclose(fp);
write_user(user,"Vacation message stored.\n");
}

/*** Show talker rooms ***/
void rooms(user,show_topics)
UR_OBJECT user;
int show_topics;
{
char accesstype[10],serv[SERV_NAME_LEN+1],stat[9];
int cnt,cnt2=0,i,temp=0;
NL_OBJECT nl;
RM_OBJECT room,room1;
UR_OBJECT user2;

user->rooms=show_topics;
user->numrooms=0;
for(room=room_first;room;room=room->next) {
	if (room->access==HIDDEN || room->hid) continue;
	if (room->level!=user->room->level && user->level<GENERAL) continue;
	++user->numrooms;
	}
if (show_topics) write_user(user,"\n~OL~FBRoom name            : Access  Users  Mesgs  Topic\n\n");
else write_user(user,"\n~OL~FBRoom name            : Access  Users  Mesgs  Inlink  LStat  Service\n\n");
room1=room_first;
if (user->morelines && !temp) {
	++temp;
	while(user->morelines>cnt2) {
		if (room1->access==HIDDEN || room1->hid || (room1->level!=user->room->level && user->level<GENERAL)) { room1=room1->next; continue; }
		++cnt2;
		room1=room1->next;
		}
	}
for(room=room1;room;room=room->next) {
	cnt=0; i=0;
	if (room->access==HIDDEN || room->hid) continue;
	if (room->level!=user->room->level && user->level<GENERAL) continue;
	if (room->access & 1) sntrncpy(accesstype," ~FRPRIV",sizeof(accesstype));
	else sntrncpy(accesstype,"  ~FGPUB",sizeof(accesstype));
	if (room->access & 2) accesstype[0]='*';
	for(user2=user_first;user2;user2=user2->next) if (user2->room==room && !user2->hid) if (user2->type!=CLONE_TYPE && user2->room==room) ++cnt;
	if (show_topics) snprintf(text,sizeof(text),"%-*s : %9s~RS    %3d    %3d  ~BR~OL%s\n",ROOM_NAME_LEN,room->name,accesstype,cnt,room->mesg_cnt,room->topic);
	else {
		nl=room->netlink;  serv[0]='\0';
		if (!nl || nl->type==UNCONNECTED) sntrncpy(stat,"~FRDOWN",sizeof(stat));
		else if (nl->stage==2) sntrncpy(stat,"  ~FGUP",sizeof(stat));
		else sntrncpy(stat," ~FYVER",sizeof(stat));
		if (nl) sntrncpy(serv,nl->service,sizeof(serv));
		snprintf(text,sizeof(text),"%-*s : %9s~RS    %3d    %3d     %s   %s~RS  %s\n",ROOM_NAME_LEN,room->name,accesstype,cnt,room->mesg_cnt,noyes1[room->inlink],stat,serv);
		}
	write_user(user,text);
	if (room==room_last || user->morelines>=user->numrooms) { ++i; break; }
	if (++user->morelines==(user->morelines1*22)) {
		++user->morelines1;
		break;
		}
	}
if (i) {
	user->misc_op=0;
	user->morelines=0;
	user->morelines1=1;
	user->rooms=0;
	user->numrooms=0;
	return;
	}
else {
	write_user(user,"~BR~OL*** PRESS <RETURN>, E<RETURN> TO EXIT ***");
	user->misc_op=13;
	}
}

/*** Show holers ***/
void holers(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
int cnt=0,cnt2,i,num,total=0;
FILE *fp;
struct dirent **namelist;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <letter(s)>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <letter(s)>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (stralpha(word[1])) {
	write_user(user,"Only letters are allowed.\n");
	snprintf(text,sizeof(text),"%s tried to search for holers matching %s.\n",user->name,word[1]);
	write_syslog(text,1);
	return;
	}
if (strlen(word[1])>USER_NAME_LEN) {
	write_user(user,"Don't waste my time.\n");
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.Z",USERFILES,user->name);
if (!(fp=fopen(filename,"w"))) return;
if ((num=scandir(USERFILES,&namelist,0,alphasort))==-1) return;
strtolower(word[1]);
word[1][0]=toupper(word[1][0]);
if (strlen(word[1])==1) snprintf(text,sizeof(text),"\n~BB~OL~FY*** Holers starting with the letter %s ***\n\n",word[1]);
else snprintf(text,sizeof(text),"\n~BB~OL~FY*** Holers starting with the letters %s ***\n\n",word[1]);
write_user(user,text);
while(cnt<num) {
	if ((strcmp(namelist[cnt]->d_name,".")) && (strcmp(namelist[cnt]->d_name,".."))) {
		cnt2=0;
		for(i=0;i<strlen(namelist[cnt]->d_name);++i) if (namelist[cnt]->d_name[i]=='.' && namelist[cnt]->d_name[i+1]=='D') ++cnt2;
		if (cnt2) {
			if (strncmp(namelist[cnt]->d_name,word[1],strlen(word[1]))) { ++cnt; continue; }
			sntrncpy(name,split_str(namelist[cnt]->d_name,'.'),sizeof(name));
			if (special(name,0) || special(name,1)) { ++cnt; continue; }
			++total;
			fprintf(fp,"Match #%i: %s\n",total,name);
			}
		}
	++cnt;
	}
fclose(fp);
if (!total) { write_user(user,"No matches found.\n"); return; }
more(user,filename,0);
}

/*** Show ranks of holers ***/
void ranks(user)
UR_OBJECT user;
{
char name[USER_NAME_LEN+1];
int cnt=0,cnt2,i=0,j=0,new=0,num=0,total=0,totalcom=0;
int awolers=0,privates=0,corporals=0,captains=0,colonels=0,commanders=0,generals=0;
struct dirent **namelist;
UR_OBJECT user2;

snprintf(text,sizeof(text),"~BB~OL~FY*** The ranks of HOLE ***\n\n");
sntrncpy(text,center(text,80),sizeof(text));
write_user(user,text);
if ((num=scandir(USERFILES,&namelist,0,alphasort))==-1) return;
if (user->level>CAPTAIN) {
	while(cnt<num) {
		if ((strcmp(namelist[cnt]->d_name,".")) && (strcmp(namelist[cnt]->d_name,".."))) {
			cnt2=0;
			for(i=0;i<strlen(namelist[cnt]->d_name);++i) if (namelist[cnt]->d_name[i]=='.' && namelist[cnt]->d_name[i+1]=='D') ++cnt2;
			if (cnt2) {
				sntrncpy(name,split_str(namelist[cnt]->d_name,'.'),sizeof(name));
				if (special(name,0) || special(name,1)) { ++cnt; continue; }
				if (!(user2=create_user())) {
					write_syslog("ERROR: Unable to create temporary user session in ranks().\n",0);
					return;
					}
				sntrncpy(user2->name,name,sizeof(user2->name));
				if (!load_user_details(user2)) {
					destruct_user(user2,0);
					++cnt;
					continue;
					}
				switch(user2->level) {
					case AWOL: ++awolers; break;
					case PRIVATE: ++privates; break;
					case CORPORAL: ++corporals; break;
					case CAPTAIN: ++captains; break;
					case COLONEL: ++colonels; break;
					case COMMANDER: ++commanders; break;
					case GENERAL: ++generals;
					}
				destruct_user(user2,0);
				}
			}
		++cnt;
		}
	}
while(level_name[j][0]!='*') {
	com_num=0;
	while(command[com_num][0]!='*') {
		if (com_level[com_num]==j) { ++new; ++totalcom; }
		++com_num;
		}
	if (j==user->level) snprintf(text,sizeof(text),"*~OL~FB%-9s~RS - Level ~FR%i~RS ",level_name[j],j);
	else snprintf(text,sizeof(text)," ~OL~FB%-9s~RS - Level ~FR%i~RS ",level_name[j],j);
	write_user(user,text);
	if (totalcom==1) snprintf(text,sizeof(text),"~OL~FY[~RS%-3i command total~OL~FY]~RS - ",totalcom);
	else snprintf(text,sizeof(text),"~OL~FY[~RS%-3i commands total~OL~FY]~RS - ",totalcom);
	write_user(user,text);
	if (new==1) snprintf(text,sizeof(text),"~OL~FT%-3i~RS new command this level.\n",new);
	else snprintf(text,sizeof(text),"~OL~FT%-3i~RS new commands this level.\n",new);
	write_user(user,text);
	if (user->level>CAPTAIN) {
		switch(j) {
			case AWOL: total=awolers; break;
			case PRIVATE: total=privates; break;
			case CORPORAL: total=corporals; break;
			case CAPTAIN: total=captains; break;
			case COLONEL: total=colonels; break;
			case COMMANDER: total=commanders; break;
			case GENERAL: total=generals;
			}
		if (total==1) snprintf(text,sizeof(text),"=> ~OL~FM%i~RS user of this level. <=\n",total);
		else snprintf(text,sizeof(text),"=> ~OL~FM%i~RS users of this level. <=\n",total);
		sntrncpy(text,center(text,80),sizeof(text));
		write_user(user,text);
		}
	++j; com_num=0; total=0; new=0;
	}
}

/*** Recount the board messages ***/
void recount(user)
UR_OBJECT user;
{
check_messages(1);
write_user(user,"Messages recounted.\n");
snprintf(text,sizeof(text),"%s recounted the message boards.\n",user->name);
write_syslog(text,1);
}

/*** Super command mode ***/
void print_scom(user,which)
UR_OBJECT user;
int which;
{
int cnt=1,cnt2=0,cnt3=1,i=0;

com_num=0;
if (user->morelines) {
	while(user->morelines>cnt2) {
		if (command[com_num][0]!='*') {
			if (command_disabled(user,command[com_num],1) || ((com_level[com_num]>user->level && !command_granted(user,command[com_num])) || command_disabled(user,command[com_num],0))) { ++com_num; continue; }
			if (++cnt==5) { ++cnt2; cnt=1; }
			++com_num; ++cnt3;
			}
		else break;
		}
	cnt2=0;
	}
cnt=cnt3; ++cnt2;
while(command[com_num][0]!='*') {
	if (!command_disabled(user,command[com_num],1) && (com_level[com_num]<=user->level || command_disabled(user,command[com_num],0))) {
		if (!which) {
			snprintf(text,sizeof(text),"~OL[%-3i]:~RS ~OL~FB%-12s~RS",cnt,command[com_num]+1);
			write_user(user,text);
			if (++cnt2==5) {
				write_user(user,"\n");
				cnt2=1;
				if (++user->morelines==(user->morelines1*22)) {
					++user->morelines1;
					++i;
					break;
					}
				}
			}
		++cnt;
		}
	++com_num;
	}
if (!i) {
	if (!which) {
		if (cnt) write_user(user,"\n");
		end_printscom(user,0);
		}
	snprintf(text,sizeof(text),"~OLSelect (1-%i) scmquit to exit super command mode => ",cnt-1);
	write_user(user,text);
	return;
	}
write_user(user,"~BR~OL*** PRESS <RETURN>, E<RETURN> TO EXIT ***");
user->misc_op=59;
}

/*** End it all ***/
void end_printscom(user,which)
UR_OBJECT user;
int which;
{
user->misc_op=0;
user->morelines=0;
user->morelines1=1;
if (which) print_scom(user,1);
prompt(user);
}

/*** Pick a user ***/
void pick_user(user,which,inpstr)
UR_OBJECT user;
int which;
char *inpstr;
{
int cnt=0,cnt2=0;
UR_OBJECT user2;

if (!strcasecmp(word[0],"scmquit")) {
	reset_scom(user,0);
	return;
	}
if (!which) {
	++cnt;
	for(user2=user_first;user2;user2=user2->next) {
		if (user) if (user->room && user2->room) if (user2->room->level!=user->room->level && user->level<GENERAL) continue;
		if (user2->type==CLONE_TYPE || user2->login) continue;
		if (!user2->vis || user2->hid) continue;
		snprintf(text,sizeof(text),"~OL~FM[%-2i]:~RS ~FR%-*s~RS",cnt,USER_NAME_LEN,user2->morphed);
		write_user(user,text);
		if (++cnt2==3) { write_user(user,"\n"); cnt2=0; }
		++cnt;
		}
	if (cnt2) write_user(user,"\n");
	snprintf(text,sizeof(text),"~OLSelect (1-%i) => ",cnt-1);
	write_user(user,text);
	user->misc_op=57;
	}
else {
	for(user2=user_first;user2;user2=user2->next) {
		if (user) if (user->room && user2->room) if (user2->room->level!=user->room->level && user->level<GENERAL) continue;
		if (user2->type==CLONE_TYPE || user2->login) continue;
		if (!user2->vis || user2->hid) continue;
		if (++cnt==atoi(word[0])) { ++cnt2; break; }
		}
	if (cnt2) sntrncpy(user->word[user->wordcnt],user2->name,sizeof(user->word[user->wordcnt]));
	else {
		write_user(user,"Not valid.\n");
		pick_user(user,0,inpstr);
		return;
		}
	scom_main(user,inpstr,2,0);
	}
}

/*** Pick a room ***/
void pick_room(user,which,inpstr)
UR_OBJECT user;
int which;
char *inpstr;
{
int cnt=0,cnt2=0;
RM_OBJECT room;

if (!strcasecmp(word[0],"scmquit")) {
	reset_scom(user,0);
	return;
	}
if (!which) {
	++cnt;
	for(room=room_first;room;room=room->next) {
		if ((room->access==HIDDEN || room->hid) && user->level<GENERAL) continue;
		if (room->level!=user->room->level && user->level<GENERAL) continue;
		snprintf(text,sizeof(text),"~OL~FY[%-2i]:~RS ~FR%-*s~RS",cnt,ROOM_NAME_LEN,room->name);
		write_user(user,text);
		if (++cnt2==3) { write_user(user,"\n"); cnt2=0; }
		++cnt;
		}
	if (cnt2) write_user(user,"\n");
	snprintf(text,sizeof(text),"~OLSelect (1-%i) => ",cnt-1);
	write_user(user,text);
	user->misc_op=58;
	}
else {
	for(room=room_first;room;room=room->next) {
		if ((room->access==HIDDEN || room->hid) && user->level<GENERAL) continue;
		if (room->level!=user->room->level && user->level<GENERAL) continue;
		if (++cnt==atoi(word[0])) { ++cnt2; break; }
		}
	if (cnt2) sntrncpy(user->word[user->wordcnt],room->name,sizeof(user->word[user->wordcnt]));
	else {
		write_user(user,"Not valid.\n");
		pick_room(user,0,inpstr);
		return;
		}
	scom_main(user,inpstr,2,0);
	}
}

/*** Pick a text file ***/
void pick_text(user,which,inpstr)
UR_OBJECT user;
int which;
char *inpstr;
{
char filename[FILENAME_LEN],line[82];
int cnt=0,cnt2=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/index",TXTDIR);
if (!strcasecmp(word[0],"scmquit")) {
	reset_scom(user,0);
	return;
	}
if (!which) {
	++cnt;
	if (!(fp=fopen(filename,"r"))) { scom_main(user,inpstr,2,0); return; }
	fgets(line,sizeof(line),fp);
	write_user(user,line);
	fscanf(fp,"%s",line);
	while(!feof(fp)) {
		snprintf(text,sizeof(text),"~OL~FM[%-2i]:~RS ~FR%-*s~RS",cnt,USER_NAME_LEN,line);
		write_user(user,text);
		if (++cnt2==3) { write_user(user,"\n"); cnt2=0; }
		++cnt;
		fscanf(fp,"%s",line);
		}
	fclose(fp);
	if (cnt2) write_user(user,"\n");
	snprintf(text,sizeof(text),"~OLSelect (1-%i) => ",cnt-1);
	write_user(user,text);
	user->misc_op=66;
	}
else {
	if (!(fp=fopen(filename,"r"))) { scom_main(user,inpstr,2,0); return; }
	fgets(line,sizeof(line),fp);
	fscanf(fp,"%s",line);
	while(!feof(fp)) {
		if (++cnt==atoi(word[0])) { ++cnt2; break; }
		fscanf(fp,"%s",line);
		}
	fclose(fp);
	if (cnt2) sntrncpy(user->word[user->wordcnt],line,sizeof(user->word[user->wordcnt]));
	else {
		write_user(user,"Not valid.\n");
		pick_text(user,0,inpstr);
		return;
		}
	scom_main(user,inpstr,2,0);
	}
}

/*** Pick a pic ***/
void pick_pic(user,which,inpstr)
UR_OBJECT user;
int which;
char *inpstr;
{
char filename[FILENAME_LEN],line[82];
int cnt=0,cnt2=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/index",PICTDIR);
if (!strcasecmp(word[0],"scmquit")) {
	reset_scom(user,0);
	return;
	}
if (!which) {
	++cnt;
	if (!(fp=fopen(filename,"r"))) { scom_main(user,inpstr,2,0); return; }
	fgets(line,sizeof(line),fp);
	write_user(user,line);
	fscanf(fp,"%s",line);
	while(!feof(fp)) {
		snprintf(text,sizeof(text),"~OL~FM[%-2i]:~RS ~FR%-*s~RS",cnt,USER_NAME_LEN,line);
		write_user(user,text);
		if (++cnt2==3) { write_user(user,"\n"); cnt2=0; }
		++cnt;
		fscanf(fp,"%s",line);
		}
	fclose(fp);
	if (cnt2) write_user(user,"\n");
	snprintf(text,sizeof(text),"~OLSelect (1-%i) => ",cnt-1);
	write_user(user,text);
	user->misc_op=67;
	}
else {
	if (!(fp=fopen(filename,"r"))) { scom_main(user,inpstr,2,0); return; }
	fgets(line,sizeof(line),fp);
	fscanf(fp,"%s",line);
	while(!feof(fp)) {
		if (++cnt==atoi(word[0])) { ++cnt2; break; }
		fscanf(fp,"%s",line);
		}
	fclose(fp);
	if (cnt2) sntrncpy(user->word[user->wordcnt],line,sizeof(user->word[user->wordcnt]));
	else {
		write_user(user,"Not valid.\n");
		pick_pic(user,0,inpstr);
		return;
		}
	scom_main(user,inpstr,2,0);
	}
}

/*** Pick a label ***/
void pick_label(user,which,inpstr)
UR_OBJECT user;
int which;
char *inpstr;
{
int cnt=0,cnt2=0;
RM_OBJECT room;

if (!strcasecmp(word[0],"scmquit")) {
	reset_scom(user,0);
	return;
	}
if (!which) {
	++cnt;
	for(room=room_first;room;room=room->next) {
		if ((room->access==HIDDEN || room->hid) && user->level<GENERAL) continue;
		if (room->level!=user->room->level && user->level<GENERAL) continue;
		snprintf(text,sizeof(text),"~OL~FY[%-2i]:~RS ~OL~FB%s~RS - ~FR%-*s~RS",cnt,room->label,ROOM_NAME_LEN,room->name);
		write_user(user,text);
		if (++cnt2==2) { write_user(user,"\n"); cnt2=0; }
		++cnt;
		}
	if (cnt2) write_user(user,"\n");
	if (user->wordcnt==4) snprintf(text,sizeof(text),"~OLSelect (0-%i) 0 to quit => ",cnt-1);
	else snprintf(text,sizeof(text),"~OLSelect (1-%i) => ",cnt-1);
	write_user(user,text);
	user->misc_op=114;
	}
else {
	if (user->wordcnt==4 && !atoi(inpstr) && isnumber(inpstr) && word_count && user->word[user->wordcnt][0]) { scom_main(user,inpstr,2,0); return; }
	for(room=room_first;room;room=room->next) {
		if ((room->access==HIDDEN || room->hid) && user->level<GENERAL) continue;
		if (room->level!=user->room->level && user->level<GENERAL) continue;
		if (++cnt==atoi(word[0])) { ++cnt2; break; }
		}
	if (cnt2) {
		if (user->wordcnt==4) { if (user->word[user->wordcnt][0]) strncat(user->word[user->wordcnt]," ",sizeof(user->word[user->wordcnt])); strncat(user->word[user->wordcnt],room->label,sizeof(user->word[user->wordcnt])); }
		else sntrncpy(user->word[user->wordcnt],room->label,sizeof(user->word[user->wordcnt]));
		}
	else {
		write_user(user,"Not valid.\n");
		pick_label(user,0,inpstr);
		return;
		}
	if (user->wordcnt==5) scom_main(user,inpstr,2,0);
	else pick_label(user,0,inpstr);
	}
}

/*** Pick a color ***/
void pick_col(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.E",USERFILES,user->name);
if (!strcasecmp(word[1],"delete")) {
	if (!strcasecmp(word[2],"who")) {
		if (!(get_color(user,1))) {
			write_user(user,"No who colors.\n");
			user->colstr[0]='\0';
			return;
			}
		user->colstr[0]='\0';
		remove_line(user,filename,word[2]);
		write_user(user,"Who colors deleted.\n");
		return;
		}
	else if (!strcasecmp(word[2],"say")) {
		if (!(get_color(user,2))) {
			write_user(user,"No say colors.\n");
			user->colstr[0]='\0';
			return;
			}
		user->colstr[0]='\0';
		remove_line(user,filename,word[2]);
		write_user(user,"Say colors deleted.\n");
		return;
		}
	else if (!strcasecmp(word[2],"tell")) {
		if (!(get_color(user,3))) {
			write_user(user,"No tell colors.\n");
			user->colstr[0]='\0';
			return;
			}
		user->colstr[0]='\0';
		remove_line(user,filename,word[2]);
		write_user(user,"Tell colors deleted.\n");
		return;
		}
	else if (!strcasecmp(word[2],"all")) {
		if (!(get_color(user,4))) {
			write_user(user,"No all colors.\n");
			user->colstr[0]='\0';
			return;
			}
		user->colstr[0]='\0';
		remove_line(user,filename,word[2]);
		reset_term(user);
		write_user(user,"All colors deleted.\n");
		return;
		}
	else if (word_count>2) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s delete [who/say/tell/all]\n",command[com_num]);
		else snprintf(text,sizeof(text),"Usage: %s delete [who/say/tell/all]\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	if (!(fp=fopen(filename,"r"))) {
		write_user(user,"No colors.\n");
		return;
		}
	fclose(fp);
	unlink(filename);
	reset_term(user);
	write_user(user,"Colors deleted.\n");
	return;
	}
reset_term(user);
user->printcolors=1;
write_user(user,"1. Who.\n");
write_user(user,"2. Say.\n");
write_user(user,"3. Tell.\n");
write_user(user,"4. All.\n");
write_user(user,"Which colors do you wish to change? (scmquit to abort) ");
user->misc_op=73;
}

/*** Get color ***/
int get_color(user,which)
UR_OBJECT user;
int which;
{
char filename[FILENAME_LEN],line[82],temp[82];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.E",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
fgets(line,sizeof(line),fp);
while(!feof(fp)) {
	sscanf(line,"%s",temp);
	if (!strcasecmp(temp,"who") && which==1) { sscanf(line,"%s %s",temp,user->colstr); fclose(fp); return 1; }
	else if (!strcasecmp(temp,"say") && which==2) { sscanf(line,"%s %s",temp,user->colstr); fclose(fp); return 1; }
	else if (!strcasecmp(temp,"tell") && which==3) { sscanf(line,"%s %s",temp,user->colstr); fclose(fp); return 1; }
	else if (!strcasecmp(temp,"all") && which==4) { sscanf(line,"%s %s",temp,user->colstr); fclose(fp); return 1; }
	fgets(line,sizeof(line),fp);
	}
fclose(fp);
return 0;
}

/*** Put color into the file ***/
void put_color(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],line[82],temp[82];
int cnt=0,i=0;
FILE *infp,*outfp;

if (!user->whichcol) snprintf(filename,sizeof(filename),"%s/%s.E",USERFILES,user->name);
else snprintf(filename,sizeof(filename),"%s/%s.E",USERFILES,user->pickcol);
if (!(infp=fopen(filename,"r"))) {
	if (!(outfp=fopen(filename,"a"))) ++i;
	if (!i) {
		if (user->whichcol1==1) fputs("who ",outfp);
		else if (user->whichcol1==2) fputs("say ",outfp);
		else if (user->whichcol1==3) fputs("tell ",outfp);
		else if (user->whichcol1==4) fputs("all ",outfp);
		fputs(user->colstr2,outfp);
		fputs("\n",outfp);
		fclose(outfp);
		user->printcolors=0;
		write_user(user,user->colstr2);
		write_user(user,"Color stored.\n");
		++i;
		}
	}
if (!i) {
	if (!(outfp=fopen(TEMPFILE,"w"))) {
		snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't open tempfile to write in put_color().\n",0);
		fclose(infp);
		++i;
		}
	}
if (!i) {
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s",temp);
	while(!feof(infp)) {
		if (!strcasecmp(temp,"who") && user->whichcol1==1) {
			fputs("who ",outfp);
			fputs(user->colstr2,outfp);
			fputs("\n",outfp);
			++cnt;
			}
		else if (!strcasecmp(temp,"say") && user->whichcol1==2) {
			fputs("say ",outfp);
			fputs(user->colstr2,outfp);
			fputs("\n",outfp);
			++cnt;
			}
		else if (!strcasecmp(temp,"tell") && user->whichcol1==3) {
			fputs("tell ",outfp);
			fputs(user->colstr2,outfp);
			fputs("\n",outfp);
			++cnt;
			}
		else if (!strcasecmp(temp,"all") && user->whichcol1==4) {
			fputs("all ",outfp);
			fputs(user->colstr2,outfp);
			fputs("\n",outfp);
			++cnt;
			}
		else fputs(line,outfp);
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s",temp);
		}
	fclose(infp);  fclose(outfp);
	if (!cnt) {
		unlink(TEMPFILE);
		if (!(outfp=fopen(filename,"a"))) ++i;
		if (!i) {
			if (user->whichcol1==1) fputs("who ",outfp);
			else if (user->whichcol1==2) fputs("say ",outfp);
			else if (user->whichcol1==3) fputs("tell ",outfp);
			else if (user->whichcol1==4) fputs("all ",outfp);
			fputs(user->colstr2,outfp);
			fputs("\n",outfp);
			fclose(outfp);
			}
		}
	else {
		if (rename(TEMPFILE,filename)==-1) {
			unlink(TEMPFILE);
			snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Couldn't rename tempfile in put_color().\n",0);
			return;
			}
		}
	user->printcolors=0;
	write_user(user,user->colstr2);
	write_user(user,"Color stored.\n");
	}
end_usercol(user,0);
}

/*** End adding user color ***/
void end_usercol(user,which)
UR_OBJECT user;
int which;
{
char filename[FILENAME_LEN];

user->colstr[0]='\0';
user->colstr2[0]='\0';
user->misc_op=0;
user->pickcol[0]='\0';
user->whichcol=0;
user->whichcol1=0;
user->whichcol2=0;
user->whichcol3=0;
if (which) {
	snprintf(filename,sizeof(filename),"%s/%s.E",USERFILES,user->name);
	unlink(filename);
	}
}

/*** Pick a color ***/
void pick_color(user,which)
UR_OBJECT user;
int which;
{
if (user->whichcol3>=10) {
	write_user(user,"Maximum number of colors reached.\n");
	if (!which) put_color(user);
	else put_allcolor(user);
	return;
	}
reset_term(user);
write_user(user," 1. reset terminal to default\n");
write_user(user," 2. ~RVreverse video\n");
write_user(user," 3. ~OLbold\n");
write_user(user," 4. ~LIblink/flash text\n");
write_user(user," 5. ~PZBEEP!\n");
write_user(user," 6. ~ULunderline\n");
write_user(user," 7. ~FK~OLforeground black\n");
write_user(user," 8. ~FRforeground red\n");
write_user(user," 9. ~FGforeground green\n");
write_user(user,"10. ~FYforeground yellow\n");
write_user(user,"11. ~FBforeground blue\n");
write_user(user,"12. ~FMforeground magenta\n");
write_user(user,"13. ~FTforeground turquoise\n");
write_user(user,"14. ~FWforeground white\n");
write_user(user,"15. ~BKbackground black\n");
write_user(user,"16. ~BRbackground red\n");
write_user(user,"17. ~BGbackground green\n");
write_user(user,"18. ~BYbackground yellow\n");
write_user(user,"19. ~BBbackground blue\n");
write_user(user,"20. ~BMbackground magenta\n");
write_user(user,"21. ~BTbackground turqouise\n");
write_user(user,"22. ~BW~OLbackground white\n");
write_user(user,"~OLSelect (1-22) scmquit to abort => ");
if (!which) user->misc_op=74;
else user->misc_op=97;
}

/*** Put color into string ***/
void color_time(user)
UR_OBJECT user;
{
switch(atoi(word[0])) {
	case 1: strncat(user->colstr2,"~RS",sizeof(user->colstr2)); break;
	case 2: strncat(user->colstr2,"~RV",sizeof(user->colstr2)); break;
	case 3: strncat(user->colstr2,"~OL",sizeof(user->colstr2)); break;
	case 4: strncat(user->colstr2,"~LI",sizeof(user->colstr2)); break;
	case 5: strncat(user->colstr2,"~PZ",sizeof(user->colstr2)); break;
	case 6: strncat(user->colstr2,"~UL",sizeof(user->colstr2)); break;
	case 7: strncat(user->colstr2,"~FK",sizeof(user->colstr2)); break;
	case 8: strncat(user->colstr2,"~FR",sizeof(user->colstr2)); break;
	case 9: strncat(user->colstr2,"~FG",sizeof(user->colstr2)); break;
	case 10: strncat(user->colstr2,"~FY",sizeof(user->colstr2)); break;
	case 11: strncat(user->colstr2,"~FB",sizeof(user->colstr2)); break;
	case 12: strncat(user->colstr2,"~FM",sizeof(user->colstr2)); break;
	case 13: strncat(user->colstr2,"~FT",sizeof(user->colstr2)); break;
	case 14: strncat(user->colstr2,"~FW",sizeof(user->colstr2)); break;
	case 15: strncat(user->colstr2,"~BK",sizeof(user->colstr2)); break;
	case 16: strncat(user->colstr2,"~BR",sizeof(user->colstr2)); break;
	case 17: strncat(user->colstr2,"~BG",sizeof(user->colstr2)); break;
	case 18: strncat(user->colstr2,"~BY",sizeof(user->colstr2)); break;
	case 19: strncat(user->colstr2,"~BB",sizeof(user->colstr2)); break;
	case 20: strncat(user->colstr2,"~BM",sizeof(user->colstr2)); break;
	case 21: strncat(user->colstr2,"~BT",sizeof(user->colstr2)); break;
	case 22: strncat(user->colstr2,"~BW",sizeof(user->colstr2)); break;
	default: write_user(user,"Try again.\n"); pick_color(user,0); return;
	}
++user->whichcol3;
write_user(user,"Are you finished (y/n)? ");
user->misc_op=75;
}

/*** Pick a color for another user ***/
void pick_ocol(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Pick colors for who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in pick_ocol().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) { destruct_user(user2,0); return; }
if (user2->level>=user->level) {
	write_user(user,"Hmm .. inadvisable.\n");
	snprintf(text,sizeof(text),"%s tried to pick colors for you!\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
sntrncpy(user->pickcol,user2->name,sizeof(user->pickcol));
if (!strcasecmp(word[2],"delete")) {
	snprintf(filename,sizeof(filename),"%s/%s.E",USERFILES,user->pickcol);
	user2->socket=5;
	if (!strcasecmp(word[3],"who")) {
		if (!(get_color(user2,1))) {
			write_user(user,"No who colors.\n");
			destruct_user(user2,0);
			return;
			}
		destruct_user(user2,0);
		remove_line(user,filename,word[3]);
		write_user(user,"Who colors deleted.\n");
		return;
		}
	else if (!strcasecmp(word[3],"say")) {
		if (!(get_color(user2,2))) {
			write_user(user,"No say colors.\n");
			destruct_user(user2,0);
			return;
			}
		destruct_user(user2,0);
		remove_line(user,filename,word[3]);
		write_user(user,"Say colors deleted.\n");
		return;
		}
	else if (!strcasecmp(word[3],"tell")) {
		if (!(get_color(user2,3))) {
			write_user(user,"No tell colors.\n");
			destruct_user(user2,0);
			return;
			}
		destruct_user(user2,0);
		remove_line(user,filename,word[3]);
		write_user(user,"Tell colors deleted.\n");
		return;
		}
	else if (!strcasecmp(word[3],"all")) {
		if (!(get_color(user2,4))) {
			write_user(user,"No all colors.\n");
			destruct_user(user2,0);
			return;
			}
		destruct_user(user2,0);
		remove_line(user,filename,word[3]);
		write_user(user,"All colors deleted.\n");
		return;
		}
	if (!(fp=fopen(filename,"r"))) {
		write_user(user,"No colors.\n");
		return;
		}
	fclose(fp);
	unlink(filename);
	write_user(user,"Colors deleted.\n");
	destruct_user(user2,0);
	return;
	}
destruct_user(user2,0);
write_user(user,"1. Who.\n");
write_user(user,"2. Say.\n");
write_user(user,"3. Tell.\n");
write_user(user,"4. All.\n");
write_user(user,"Which colors do you wish to change? (scmquit to abort) ");
user->misc_op=73;
user->printcolors=1;
}

/*** Print out colors ***/
void print_colors(user,which)
UR_OBJECT user;
{
char *s;
int i,j;

if (!which) s=user->colstr;
else s=allcolor;
while(*s) {
	j=0;
	if (*s=='~') {
		if (*(s+1)=='\\') { ++s; ++s; continue; }
		}
	if (*s=='\\') {
		if (*(s+1)=='~') {
			for(i=0;i<COLNUM;++i) {
				if (!strncmp(s+2,colcom[i],2)) { ++s; ++s; ++s; ++s; ++j; break; }
				}
			if (j) continue;
			}
		}
	if (*s=='~') {
		for(i=0;i<COLNUM;++i) {
			if (!strncmp(s+1,colcom[i],2)) { write_sock(user->socket,colcode[i]); ++s; ++s; ++s; ++j; break; }
			}
		if (j) continue;
		}
	++s;
	}
}

/*** Alias time ***/
void pick_alias(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.K",USERFILES,user->name);
if (!strcasecmp(word[1],"view")) {
	write_user(user,"~BB~OL~FY*** Your aliases ***\n");
	more(user,filename,0);
	return;
	}
else if (!strcasecmp(word[1],"delete")) {
	if (word_count>2) {
		if (!(get_alias(user,word[2],1))) {
			write_user(user,"No such alias.\n");
			return;
			}
		remove_line(user,filename,word[2]);
		write_user(user,"Alias deleted.\n");
		return;
		}
	if (!(fp=fopen(filename,"r"))) {
		write_user(user,"No aliases.\n");
		return;
		}
	fclose(fp);
	unlink(filename);
	write_user(user,"All aliases deleted.\n");
	return;
	}
write_user(user,"Enter alias (max 2 chars) (scmquit to abort) ");
user->misc_op=78;
}

/*** Remove a line ***/
void remove_line(user,filename,str)
UR_OBJECT user;
char *filename,*str;
{
char line[82],temp[80];
int cnt=0,found=0;
FILE *infp,*outfp;

if (!(infp=fopen(filename,"r"))) return;
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in remove_line().\n",0);
	fclose(infp);
	return;
	}
fgets(line,sizeof(line),infp);
sscanf(line,"%s",temp);
while(!feof(infp)) {
	if (!strcmp(temp,str)) {
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s",temp); ++found; continue;
		}
	fputs(line,outfp);
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s",temp);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!found) { unlink(TEMPFILE); return; }
if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,filename)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in remove_line().\n",0);
	return;
	}
}

/*** Get alias ***/
int get_alias(user,str,which)
UR_OBJECT user;
char *str;
int which;
{
char filename[FILENAME_LEN],line[82],temp[82];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.K",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) return 0;
fgets(line,sizeof(line),fp);
while(!feof(fp)) {
	sscanf(line,"%s",temp);
	if (!strcmp(temp,str)) {
		sscanf(line,"%s %s",user->alias1,user->alias2);
		fclose(fp);
		return 1;
		}
	fgets(line,sizeof(line),fp);
	}
fclose(fp);
return 0;
}

/*** Put alias into the file ***/
void put_alias(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],line[82],temp[82];
int cnt=0,i=0;
FILE *infp,*outfp;

snprintf(filename,sizeof(filename),"%s/%s.K",USERFILES,user->name);
if (!(infp=fopen(filename,"r"))) {
	if (!(outfp=fopen(filename,"a"))) ++i;
	if (!i) {
		fprintf(outfp,"%s %s\n",user->alias1,user->alias2);
		fclose(outfp);
		write_user(user,"Alias stored.\n");
		++i;
		}
	}
if (!i) {
	fclose(infp);
	if (!(infp=fopen(filename,"r"))) ++i;
	if (!i) {
		if (!(outfp=fopen(TEMPFILE,"w"))) {
			snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Couldn't open tempfile to write in put_alias().\n",0);
			fclose(infp);
			++i;
			}
		}
	}
if (!i) {
	fgets(line,sizeof(line),infp);
	sscanf(line,"%s",temp);
	while(!feof(infp)) {
		if (!strcmp(temp,user->alias1)) {
			fprintf(outfp,"%s %s\n",user->alias1,user->alias2);
			++cnt;
			}
		else fputs(line,outfp);
		fgets(line,sizeof(line),infp);
		sscanf(line,"%s",temp);
		}
	fclose(infp);  fclose(outfp);
	if (!cnt) {
		if (!(outfp=fopen(filename,"a"))) ++i;
		if (!i) {
			fprintf(outfp,"%s %s\n",user->alias1,user->alias2);
			fclose(outfp);
			unlink(TEMPFILE);
			}
		}
	else {
		if (rename(TEMPFILE,filename)==-1) {
			unlink(TEMPFILE);
			snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Couldn't rename tempfile in put_alias().\n",0);
			return;
			}
		}
	if (!i) write_user(user,"Alias stored.\n");
	}
user->alias1[0]='\0';
user->alias2[0]='\0';
}

/*** Reset command mode thingy ***/
void reset_scom(user,which)
UR_OBJECT user;
int which;
{
int i;

if (!which && !user->notcomplete) {
	write_user(user,"~OLPress enter to continue...");
	user->misc_op=60;
	return;
	}
for(i=0;i<user->wordcnt;++i) user->word[i][0]='\0';
user->wordcnt=0;
if (user->scommand_mode) print_scom(user,0);
else { user->misc_op=0; user->notcomplete=0; }
}

/*** Get right command ***/
void get_rightcomm(user,com)
UR_OBJECT user;
int com;
{
int cnt=0;

com_num=0;
while(command[com_num][0]!='*') {
	if (command_disabled(user,command[com_num],1) || ((com_level[com_num]>user->level && !command_granted(user,command[com_num])) || command_disabled(user,command[com_num],0))) { ++com_num; continue; }
	if (cnt==com) break;
	++com_num; ++cnt;
	}
}

/*** Super command mode main ***/
void scom_main(user,inpstr,which,hmmer)
UR_OBJECT user;
char *inpstr;
int which,hmmer;
{
int com,dunno=0,i;

if (user->muzzled) { print_muzzle(user); return; }
if (!user->room) { user->misc_op=0; return; }
if (user->notcomplete) user->misc_op=56;
else if (user->scommand_mode) user->misc_op=0;
if (!word_count && !user->wordcnt && user->scommand_mode) { print_scom(user,1); return; }
if (!user->scommand_mode) {
	if (which==3 && !hmmer) { snprintf(user->word[0],sizeof(user->word[0]),"%i",com_num); user->wordcnt=word_count; --user->wordcnt; user->misc_op=56; write_user(user,"~OLEnter scmquit to abort.\n"); }
	if (!(which==3 && !hmmer)) if (!strcasecmp(word[0],"scmquit")) { reset_scom(user,0); return; }
	}
if (user->scommand_mode) {
	if (!strcasecmp(word[0],"scmquit")) {
		scommand_mode(user);
		return;
		}
	if (which==1) ++dunno;
	}
if (!dunno) {
	if (which!=2 && !(which==3 && !hmmer)) sntrncpy(user->word[user->wordcnt],word[0],sizeof(user->word[user->wordcnt]));
	if (strlen(word[0])) ++user->wordcnt;
	com=atoi(user->word[0]);
	if (user->scommand_mode) --com;
	if (which==3 && !hmmer) for(i=1;i<user->wordcnt;++i) sntrncpy(user->word[i],word[i],sizeof(user->word[i]));
	else for(i=0;i<user->wordcnt;++i) sntrncpy(word[i],user->word[i],sizeof(word[i]));
	word_count=user->wordcnt;
	if (user->scommand_mode) get_rightcomm(user,com);
	else com_num=com;
	if ((user->room && (com_num==-1 || command_disabled(user,command[com_num],1))) || ((com_level[com_num]>user->level && !command_granted(user,command[com_num])) || command_disabled(user,command[com_num],0))) {
		write_user(user,"Unknown command.\n"); ++dunno;
		}
	}
if (!dunno) {
	switch(com_num) {
		case ACCREQ:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter an email address we can contact you at + any relevant info: ");
					break;
				case 2:
					account_request(user,inpstr);
					++dunno;
				}
			break;
		case ACK:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to ack: ");
					break;
				case 2:
					ack(user,inpstr);
					++dunno;
				}
			break;
		case ADDROOM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter room: ");
					break;
				case 2:
					adddelroom(user,0);
					++dunno;
				}
			break;
		case ADDTIME:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter number of minutes: ");
					break;
				case 3:
					addtime(user);
					++dunno;
				}
			break;
		case ADDTSIGN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter number of signons: ");
					break;
				case 3:
					addtsign(user);
					++dunno;
				}
			break;
		case ADDUSER: add_user(user); ++dunno; break;
		case AFK: afk(user,inpstr); ++dunno; break;
		case AFKLOG: afklog(user); ++dunno; break;
		case ALIAS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to add an alias, delete an alias or see your aliases?\n(add/del/see): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) { --word_count; pick_alias(user); }
					else if (!strncasecmp(user->word[1],"del",strlen(user->word[1]))) write_user(user,"Do you wish to delete one alias or all (one/all)? ");
					else if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { sntrncpy(word[1],"view",sizeof(word[1])); pick_alias(user); ++dunno; }
					else { write_user(user,"Do you wish to add an alias, delete an alias or see your aliases?\n(add/del/see): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[2],"one",strlen(user->word[2]))) write_user(user,"~OL~FBEnter alias to delete: ");
					else if (!strncasecmp(user->word[2],"all",strlen(user->word[2]))) { --word_count; sntrncpy(word[1],"delete",sizeof(word[1])); pick_alias(user); ++dunno; }
					else write_user(user,"Do you wish to delete one alias or all (one/all)? "); --word_count;
					break;
				case 4:
					--word_count;
					sntrncpy(word[1],"delete",sizeof(word[1]));
					sntrncpy(word[2],user->word[3],sizeof(word[2]));
					pick_alias(user);
					++dunno;
				}
			break;
		case ALLCLONES: allclones(user); ++dunno; break;
		case ALLCOLOR: all_color(user); ++dunno; break;
		case ANNOY:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					annoy(user,1);
					++dunno;
				}
			break;
		case ANNOYEM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter friendly string: ");
					break;
				case 3:
					annoy_user(user,1,inpstr);
					++dunno;
				}
			break;
		case ANVIL:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					write_user(user,"~OL~FBEnter weight in tons: ");
					break;
				case 3:
					anvil(user);
					++dunno;
				}
			break;
		case APPEND: append(user); ++dunno; break;
		case ARREST:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					arrest(user);
					++dunno;
				}
			break;
		case ATMOS: toggle_atmos(user); ++dunno; break;
		case AUTOHIDE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to add a site or see who you're autohiding? (add/see): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) write_user(user,"~OL~FBEnter site you wish to autohide from: ");
					else if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; autohide(user); ++dunno; }
					else { write_user(user,"Do you wish to see who you're autohiding from or add a site? (see/add): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					autohide(user);
					++dunno;
				}
			break;
		case AUTOLOGIN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter command to be executed upon any user logging in: ");
					break;
				case 2:
					autologin(user,inpstr);
					++dunno;
				}
			break;
		case AUTOREAD: auto_read(user); ++dunno; break;
		case AVALANCHE: avalanche(user,1); ++dunno; break;
		case AWHO: awho(user); ++dunno; break;
		case BAKE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					bake(user);
					++dunno;
				}
			break;
		case BAN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter if ya want to ban a domain, user, new domain, swear word, or allow a\ndomain. For God's sake, please think twice before using this command:P\n(allow/domain/newdomain/swearing/user): ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter domain to allow or domain, new domain, swear word, or user to ban: ");
					break;
				case 3:
					ban(user);
					++dunno;
				}
			break;
		case BCAST:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to broadcast: ");
					break;
				case 2:
					bcast(user,inpstr);
					++dunno;
				}
			break;
		case BEAT:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					beat(user);
					++dunno;
				}
			break;
		case BECHO:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to backwards echo: ");
					break;
				case 2:
					backecho(user,inpstr);
					++dunno;
				}
			break;
		case BEEPLINE: beepline(user); ++dunno; break;
		case BEEPLOGIN: beeplogin(user); ++dunno; break;
		case BEEPTELL:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					write_user(user,"~OL~FBEnter what you wish to beeptell: ");
					break;
				case 3:
					beeptell(user,inpstr);
					++dunno;
				}
			break;
		case BEMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to backwards emote: ");
					break;
				case 2:
					backemote(user,inpstr);
					++dunno;
				}
			break;
		case BIG:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to make yourself big or someone else? (me/else): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; big(user,1); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to make yourself big or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					big(user,1);
					++dunno;
				}
			break;
		case BLAST:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					blast(user);
					++dunno;
				}
			break;
		case BOARD: monopoly(user,9); ++dunno; break;
		case BOOTEM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					bootem(user);
					++dunno;
				}
			break;
		case BOUNCE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					bounce(user,1);
					++dunno;
				}
			break;
		case BRB: brb(user); ++dunno; break;
		case BSAY:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to backwards say: ");
					break;
				case 2:
					backsay(user,1,inpstr);
					++dunno;
				}
			break;
		case BSECHO:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to backwards shout echo: ");
					break;
				case 2:
					backsecho(user,inpstr);
					++dunno;
				}
			break;
		case BSEMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to backwards shout emote: ");
					break;
				case 2:
					backsemote(user,inpstr);
					++dunno;
				}
			break;
		case BSHOUT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to backwards shout: ");
					break;
				case 2:
					backshout(user,inpstr);
					++dunno;
				}
			break;
		case BTELL:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					write_user(user,"~OL~FBEnter what you wish to backwards tell: ");
					break;
				case 3:
					backtell(user,inpstr);
					++dunno;
				}
			break;
		case BUY:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to buy: ");
					break;
				case 2:
					monopoly(user,2);
					++dunno;
				}
			break;
		case CALC:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FRFirst number: ");
					break;
				case 2:
					write_user(user,"~OL~FMOperand: ");
					break;
				case 3:
					write_user(user,"~OL~FGSecond number: ");
					break;
				case 4:
					write_user(user,"Do you wish to include another number (y/n)? ");
					break;
				case 5:
					if (!strcasecmp(user->word[4],"Y")) write_user(user,"~OL~FTOperand: ");
					else if (!strcasecmp(user->word[4],"N")) { --word_count; calc(user); ++dunno; }
					else { write_user(user,"Do you wish to include another number (y/n)? "); --word_count; }
					break;
				case 6:
					write_user(user,"~OL~FYThird number: ");
					break;
				case 7:
					--word_count;
					sntrncpy(word[4],user->word[5],sizeof(word[4]));
					sntrncpy(word[5],user->word[6],sizeof(word[5]));
					calc(user);
					++dunno;
				}
			break;
		case CALENDAR:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FMMonth or year (m/y): ");
					break;
				case 2:
					calendar(user);
					++dunno;
				}
			break;
		case CHANNEL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to channel: ");
					break;
				case 2:
					channel(user,inpstr);
					++dunno;
				}
			break;
		case CHARECHO: charecho(user); ++dunno; break;
		case CHEMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to channel emote: ");
					break;
				case 2:
					chemote(user,inpstr);
					++dunno;
				}
			break;
		case CLEARLINE:
			switch(user->wordcnt) {
				case 1:
					print_sockets(user);
					write_user(user,"~OL~FBEnter the line you wish to clear: ");
					break;
				case 2:
					clearline(user);
					++dunno;
				}
			break;
		case CLHEAR:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					write_user(user,"~OL~FBEnter what you want the clone to hear: ");
					break;
				case 3:
					clone_hear(user);
					++dunno;
				}
			break;
		case CLREV:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					clone_rev(user);
					++dunno;
				}
			break;
		case CLREVCLR:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					clone_revclr(user);
					++dunno;
				}
			break;
		case CLS: cls(user); ++dunno; break;
		case CLSAY:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					write_user(user,"~OL~FBEnter what you want the clone to say: ");
					break;
				case 3:
					clone_say(user,inpstr);
					++dunno;
				}
			break;
		case COLORIZE:
			switch(user->wordcnt) {
				case 1:
					if (user->level>CAPTAIN) write_user(user,"Do you wish to colorize yourself or someone else? (me/else): ");
					else { colorize(user,1); ++dunno; }
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; colorize(user,1); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to colorize yourself or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					colorize(user,1);
					++dunno;
				}
			break;
		case COMMIT:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					commit(user,1);
					++dunno;
				}
			break;
		case COMPLAIN: --word_count; complain(user,inpstr,0); ++dunno; break;
		case CON:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter which room ya want to connect: ");
					break;
				case 2:
					connect_netlink(user);
					++dunno;
				}
			break;
		case CONFUSE: confuse(user); ++dunno; break;
		case CORP:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					corporal(user);
					++dunno;
				}
			break;
		case COUNT: recount(user); ++dunno; break;
		case CREATE:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					create_clone(user);
					++dunno;
				}
			break;
		case CRON:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter number of seconds (or 'stop' to cancel current cron job): ");
					break;
				case 2:
					if (!strcasecmp(user->word[1],"stop")) { cron(user,inpstr); ++dunno; }
					else write_user(user,"~OL~FBEnter cron job: ");
					break;
				case 3:
					cron(user,inpstr);
					++dunno;
				}
			break;
		case DARK:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					darkness(user);
					++dunno;
				}
			break;
		case DCHALLENGE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					dchallenge(user);
					++dunno;
				}
			break;
		case DCHANNEL: dchannel(user); ++dunno; break;
		case DCOMPLAIN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to delete all the complaints, one complaint,\nall complaints from a certain user, first n number\nof complaints, or prompt you? (all/one/user/num/prompt): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"all",strlen(user->word[1]))) { sntrncpy(word[1],"all",sizeof(word[1])); dcomplain(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"prompt",strlen(user->word[1]))) { sntrncpy(word[1],"prompt",sizeof(word[1])); wipe_board(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) write_user(user,"~OL~FBEnter complaint number: ");
					else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user name: ");
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of complaints: ");
					else { write_user(user,"Do you wish to delete all the complaints, one complaint,\nall complaints from a certain user, first n number\nof complaints, or prompt you? (all/one/user/num/prompt): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"#%i",atoi(user->word[2])); dcomplain(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"$%s",user->word[2]);  dcomplain(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { --word_count; sntrncpy(word[1],user->word[2],sizeof(word[1])); dcomplain(user); ++dunno; }
					else {
						if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter complaint number: "); }
						else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter user name: "); }
						else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter number of complaints: "); }
						--user->wordcnt;
						}
				}
			break;
		case DECOLORIZE:
			switch(user->wordcnt) {
				case 1:
					if (user->level>CAPTAIN) write_user(user,"Do you wish to decolorize yourself or someone else? (me/else): ");
					else { colorize(user,0); ++dunno; }
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; colorize(user,0); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to decolorize yourself or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					colorize(user,0);
					++dunno;
				}
			break;
		case DELIVER:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					deliver(user);
					++dunno;
				}
			break;
		case DELROOM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter room: ");
					break;
				case 2:
					adddelroom(user,1);
					++dunno;
				}
			break;
		case DEMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					demote(user);
					++dunno;
				}
			break;
		case DESC:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see your description or change it? (see/change): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; desc(user,inpstr); ++dunno; }
					else if (!strncasecmp(user->word[1],"change",strlen(user->word[1]))) write_user(user,"~OL~FBEnter your new description: ");
					else { write_user(user,"Do you wish to see your description or change it? (see/change): "); --user->wordcnt; }
					break;
				case 3:
					desc(user,inpstr);
					++dunno;
				}
			break;
		case DESTROY:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					destroy_clone(user);
					++dunno;
				}
			break;
		case DESTROYALL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter owner: ");
					break;
				case 2:
					destroy_allclones(user);
					++dunno;
				}
			break;
		case DESTRUCT:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					destroy_user(user);
					++dunno;
				}
			break;
		case DIRTCLOD:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					dirtclod(user);
					++dunno;
				}
			break;
		case DISCON:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter which room ya want to disconnect: ");
					break;
				case 2:
					disconnect_netlink(user);
					++dunno;
				}
			break;
		case DMAIL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to delete all your mail, one message,\nall mail from a certain user, first n number\nof messages, or prompt you? (all/one/user/num/prompt): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"all",strlen(user->word[1]))) { sntrncpy(word[1],"all",sizeof(word[1])); dmail(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"prompt",strlen(user->word[1]))) { sntrncpy(word[1],"prompt",sizeof(word[1])); dmail(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) write_user(user,"~OL~FBEnter message number: ");
					else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user name: ");
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of messages: ");
					else { write_user(user,"Do you wish to delete all your mail, one message,\nall mail from a certain user, first n number\nof messages, or prompt you? (all/one/user/num/prompt): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"#%i",atoi(user->word[2])); dmail(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"$%s",user->word[2]); dmail(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { --word_count; sntrncpy(word[1],user->word[2],sizeof(word[1])); dmail(user); ++dunno; }
					else {
						if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) write_user(user,"~OL~FBEnter message number: ");
						else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user name: ");
						else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of messages: ");
						--user->wordcnt;
						}
				}
			break;
		case DOH: doh(user); ++dunno; break;
		case DONTIDLEME: dontidle(user); ++dunno; break;
		case DRAG:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					drag(user,1);
					++dunno;
				}
			break;
		case DSHOUTS: dshouts(user); ++dunno; break;
		case DSMAIL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to delete all your sent mail, one message,\nfirst n number of messages, or prompt you? (all/one/num/prompt): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"all",strlen(user->word[1]))) { sntrncpy(word[1],"all",sizeof(word[1])); dsentmail(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"prompt",strlen(user->word[1]))) { sntrncpy(word[1],"prompt",sizeof(word[1])); dsentmail(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) write_user(user,"~OL~FBEnter message number: ");
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of messages: ");
					else { write_user(user,"Do you wish to delete all your sent mail, one message,\nfirst n number of messages, or prompt you? (all/one/num/prompt): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"#%i",atoi(user->word[2])); dsentmail(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { --word_count; sntrncpy(word[1],user->word[2],sizeof(word[1])); dsentmail(user); ++dunno; }
					else {
						if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) write_user(user,"~OL~FBEnter message number: ");
						else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of messages: ");
						--user->wordcnt;
						}
				}
			break;
		case DSUGGEST:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to delete all the suggestions, one suggestion,\nall suggestions from a certain user, first n number\nof suggestions, or prompt you? (all/one/user/num/prompt): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"all",strlen(user->word[1]))) { sntrncpy(word[1],"all",sizeof(word[1])); dsuggest(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"prompt",strlen(user->word[1]))) { sntrncpy(word[1],"prompt",sizeof(word[1])); dsuggest(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) write_user(user,"~OL~FBEnter suggestion number: ");
					else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user name: ");
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of suggestions: ");
					else { write_user(user,"Do you wish to delete all the suggestions, one suggestion,\nall suggestions from a certain user, first n number\nof suggestions, or prompt you? (all/one/user/num/prompt): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"#%i",atoi(user->word[2])); dsuggest(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"$%s",user->word[2]); dsuggest(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { --word_count; sntrncpy(word[1],user->word[2],sizeof(word[1])); dsuggest(user); ++dunno; }
					else {
						if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter suggestion number: "); }
						else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter user name: "); }
						else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter number of suggestions: "); }
						--user->wordcnt;
						}
				}
			break;
		case DWIZ: dwiz(user); ++dunno; break;
		case ECHOIT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to echo: ");
					break;
				case 2:
					echo(user,inpstr);
					++dunno;
				}
			break;
		case EEK: eek(user); ++dunno; break;
		case EH:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					eh(user);
					++dunno;
				}
			break;
		case EIGHT: macro(user,8,inpstr); ++dunno; break;
		case EMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to emote: ");
					break;
				case 2:
					emote(user,inpstr);
					++dunno;
				}
			break;
		case ENTPRO: enter_profile(user,0); ++dunno; break;
		case EX:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"on or off: ");
					break;
				case 3:
					ex(user);
					++dunno;
				}
			break;
		case EXAMINE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter who you wish to examine: ");
					break;
				case 2:
					examine(user);
					++dunno;
				}
			break;
		case FAKELOGOFF: fake_logoff(user); ++dunno; break;
		case FEMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to emote to your friends: ");
					break;
				case 2:
					femote(user,inpstr);
					++dunno;
				}
			break;
		case FIVE: macro(user,5,inpstr); ++dunno; break;
		case FIX:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					change_room_fix(user,1);
					++dunno;
				}
			break;
		case FLOWERS:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					flowers(user);
					++dunno;
				}
			break;
		case FMAIL: --word_count; fmail(user,inpstr,0); ++dunno; break;
		case FORTUNE: fortune(user); ++dunno; break;
		case FORWARD:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter email address: ");
					break;
				case 2:
					forward(user);
					++dunno;
				}
			break;
		case FOUR: macro(user,4,inpstr); ++dunno; break;
		case FPC:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					fpc(user);
					++dunno;
				}
			break;
		case FREEZE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					freeze(user);
					++dunno;
				}
			break;
		case FREEZEALL: freezeall(user); ++dunno; break;
		case FRIENDS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see your friends or add a name? (see/add): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; friends_list(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) write_user(user,"~OL~FBEnter name to add: ");
					else { write_user(user,"Do you wish to see your friends or add a name? (see/add): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					friends_list(user);
					++dunno;
				}
			break;
		case FRIENDSTIME:
			if (!annoystring[0]) {
				switch(user->wordcnt) {
					case 1:
						write_user(user,"~OL~FBEnter friendly string: ");
						break;
					case 2:
						annoyemall(user,inpstr);
						++dunno;
						break;
					}
				}
			else { annoyemall(user,inpstr); ++dunno; }
			break;
		case FROM: mail_from(user,0); ++dunno; break;
		case FTELL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to tell your friends: ");
					break;
				case 2:
					frtell(user,inpstr);
					++dunno;
				}
			break;
		case GARBLE: garbletime(user); ++dunno; break;
		case GO:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					go(user);
					++dunno;
				}
			break;
		case GOINGDOWN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to shutdown, reboot, or abort current shutdown/reboot?\n(shutdown/reboot/stop): ");
					break;
				case 2:
					if (!strcasecmp(user->word[1],"stop")) { going_down(user); ++dunno; }
					else write_user(user,"~OL~FBEnter number of minutes: ");
					break;
				case 3:
					going_down(user);
					++dunno;
				}
			break;
		case GOSSAMER: gossamertime(user); ++dunno; break;
		case GOSSAMEREM:
			switch(user->wordcnt) {
				case 1:
					if (user->level>CAPTAIN) write_user(user,"Do you wish to gossamer yourself or someone else? (me/else): ");
					else { toggle_gossamer(user); ++dunno; }
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; toggle_gossamer(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to gossamer yourself or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					toggle_gossamer(user);
					++dunno;
				}
			break;
		case GRANT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					if (user->scommand_mode) snprintf(text,sizeof(text),"Do you wish to see what %s has granted or grant a command? (see/add): ",user->word[1]);
					else snprintf(text,sizeof(text),"Do you wish to see what's granted or grant a command? (see/add): ");
					write_user(user,text);
					break;
				case 3:
					if (!strncasecmp(user->word[2],"see",strlen(user->word[2]))) { --word_count; grant(user); ++dunno; }
					else if (!strncasecmp(user->word[2],"add",strlen(user->word[2]))) { write_user(user,"~OL~FBEnter command you wish to grant: "); }
					else { write_user(user,"See or add (see/add): "); --user->wordcnt; }
					break;
				case 4:
					sntrncpy(word[2],user->word[3],sizeof(word[2]));
					grant(user);
					++dunno;
				}
			break;
		case GRANTED: granted(user); ++dunno; break;
		case GREET:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to center the text (y/n)? ");
					break;
				case 2:
					if (!strcasecmp(user->word[1],"Y")) sntrncpy(user->word[1],"center",sizeof(user->word[1]));
					else if (strcasecmp(user->word[1],"N")) { write_user(user,"Do you wish to center the text (y/n)? ");--user->wordcnt; }
					else write_user(user,"~OL~FBEnter text to greet: ");
					break;
				case 3:
					greet(user,inpstr,0,0);
					++dunno;
				}
			break;
		case GUESS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter letter (~ to redraw, ! to quit): ");
					break;
				case 2:
					hangman(user,1,0);
					++dunno;
				}
			break;
		case HANGMAN: hangman(user,0,1); ++dunno; break;
		case HEHEHE: banhehehe(user); ++dunno; break;
		case HELP: help(user); ++dunno; break;
		case HIDE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to hide yourself or someone else? (me/else): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; hide(user,1); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to hide yourself or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					hide(user,1);
					++dunno;
				}
			break;
		case HIFIVE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					hifive(user);
					++dunno;
				}
			break;
		case HMM: hmm(user); ++dunno; break;
		case HOLERS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter letter<s>: ");
					break;
				case 2:
					holers(user);
					++dunno;
				}
			break;
		case HOME: home(user); ++dunno; break;
		case HOMEROOM:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					homeroom(user);
					++dunno;
				}
			break;
		case HOMEWOOM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					pick_room(user,0,inpstr);
					break;
				case 3:
					homewoom(user);
					++dunno;
				}
			break;
		case HOUR: banhour(user); ++dunno; break;
		case HOWL: howl(user); ++dunno; break;
		case HUGGLE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					huggle(user);
					++dunno;
				}
			break;
		case IDEA: idea(user); ++dunno; break;
		case IDLE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					write_user(user,"~OL~FBEnter number of minutes: ");
					break;
				case 3:
					idleuser(user);
					++dunno;
				}
			break;
		case IGNORE: tignore(user); ++dunno; break;
		case IGUSER:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see who you are ignoring or add a name? (see/add): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; iguser(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) write_user(user,"~OL~FBEnter name to add: ");
					else { write_user(user,"Do you wish to see who you are ignoring or add a name? (see/add): "); --user->wordcnt; }
					break;
				case 3:
					iguser(user);
					++dunno;
				}
			break;
		case IHUNT:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					hunt(user,0);
					++dunno;
				}
			break;
		case INCOMPETENT: incompetent(user); ++dunno; break;
		case INNOCENT: innocent(user); ++dunno; break;
		case INPHRASE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see your current in phrase or change it? (see/change): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; set_iophrase(user,inpstr); ++dunno; }
					else if (!strncasecmp(user->word[1],"change",strlen(user->word[1]))) write_user(user,"~OL~FBEnter your new in phrase: ");
					else { write_user(user,"Do you wish to see your current out phrase or change it? (see/change): "); --user->wordcnt; }
					break;
				case 3:
					set_iophrase(user,inpstr);
					++dunno;
				}
			break;
		case INVIS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to make yourself invisible or someone else? (me/else): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; visibility(user,0); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) pick_user(user,0,inpstr);
					else { write_user(user,"Do you wish to make yourself invisible or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					visibility(user,0);
					++dunno;
				}
			break;
		case INVITE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					invite(user);
					++dunno;
				}
			break;
		case JEEP:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					jeep(user);
					++dunno;
				}
			break;
		case JOIN:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					join(user);
					++dunno;
				}
			break;
		case KILL:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					kill_user(user);
					++dunno;
				}
			break;
		case KILLALL: kill_allusers(user); ++dunno; break;
		case KISS:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					kiss(user);
					++dunno;
				}
			break;
		case LAST: last_users(user,0); ++dunno; break;
		case LASTON:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					laston(user);
					++dunno;
				}
			break;
		case LBAN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what bans ya wish to list (allow/domain/newdomain/swearing/user): ");
					break;
				case 2:
					listban(user);
					++dunno;
				}
			break;
		case LETMEIN:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					letmein(user);
					++dunno;
				}
			break;
		case LEVEL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter level: ");
					break;
				case 3:
					level(user);
					++dunno;
				}
			break;
		case LILMURDER: banwillkill(user); ++dunno; break;
		case LISTEN: tlisten(user); ++dunno; break;
		case LOAD:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					load_user(user);
					++dunno;
				}
			break;
		case LOADEM: load_lilmouse(user); ++dunno; break;
		case LOCK:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					lock_user(user);
					++dunno;
				}
			break;
		case LOGGING: logging(user); ++dunno; break;
		case LOGIM: enter_lim(user,0); ++dunno; break;
		case LOGINPLACE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Upstairs or Downstairs? ");
					break;
				case 2:
					login_place(user);
					++dunno;
				}
			break;
		case LOGOM: enter_lom(user,0); ++dunno; break;
		case LOL: lol(user); ++dunno; break;
		case LOOK: look(user); ++dunno; break;
		case MACRO:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to add a macro, delete your macros, or see your macros?\n(add/del/see): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { macro(user,0,inpstr); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) write_user(user,"~OL~FBEnter macro number: ");
					else if (!strncasecmp(user->word[1],"del",strlen(user->word[1]))) { sntrncpy(word[1],"delete",sizeof(word[1])); macro(user,0,inpstr); ++dunno; }
					else { write_user(user,"Do you wish to add a macro, delete your macros, or see your macros?\n(add/del/see): "); --user->wordcnt; }
					break;
				case 3:
					if (!isnumber(word[2])) { --word_count; write_user(user,"Get a clue freak and enter a number: "); }
					else { snprintf(text,sizeof(text),"~OL~FBEnter macro #%i: ",atoi(word[2])); write_user(user,text); }
					break;
				case 4:
					sntrncpy(word[1],word[2],sizeof(word[1]));
					macro(user,0,inpstr);
					++dunno;
				}
			break;
		case MAP: more(user,MAPFILE,0); ++dunno; break;
		case MASSEMOTE: mass(user,1); ++dunno; break;
		case MASSMAIL: mass(user,0); ++dunno; break;
		case MASSTELL: mass(user,2); ++dunno; break;
		case MERLYN:
			if (!strcmp(user->name,user->merlyn)) {
				switch(user->wordcnt) {
					case 1:
						write_user(user,"~OL~FBEnter user: ");
						break;
					case 2:
						merlyntime(user);
						++dunno;
						break;
					}
				}
			else { merlyntime(user); ++dunno; }
			break;
		case MHUNT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Move to where: ");
					break;
				case 2:
					hunt(user,1);
					++dunno;
				}
			break;
		case MINLOGIN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter the minlogin level: ");
					break;
				case 2:
					minlogin(user);
					++dunno;
				}
			break;
		case MIRROR: mirror(user); ++dunno; break;
		case OMIRROR:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					mirroro(user);
					++dunno;
				}
			break;
		case MODE: toggle_mode(user); ++dunno; break;
		case MONOPOLY:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"How many players? ");
					break;
				case 2:
					monopoly(user,0);
					++dunno;
				}
			break;
		case MORPH:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter new morph name: ");
					break;
				case 3:
					morph(user);
					++dunno;
				}
			break;
		case MORTGAGE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to mortgage: ");
					break;
				case 2:
					monopoly(user,4);
					++dunno;
				}
			break;
		case MOTD:
			if (!motd[0]) {
				switch(user->wordcnt) {
					case 1:
						write_user(user,"~OL~FBEnter motd string: ");
						break;
					case 2:
						motdtime(user,inpstr);
						++dunno;
						break;
					}
				}
			else { motdtime(user,inpstr); ++dunno; }
			break;
		case MOVE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					write_user(user,"Here or another room (here/another): ");
					break;
				case 3:
					if (!strncasecmp(user->word[2],"here",strlen(user->word[2]))) { --word_count; move(user); ++dunno; }
					else if (!strncasecmp(user->word[2],"another",strlen(user->word[2]))) { pick_room(user,0,inpstr); }
					else { write_user(user,"Here or another room (here/another): "); --user->wordcnt; }
					break;
				case 4:
					move(user);
					++dunno;
				}
			break;
		case MOVEALL:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					moveall(user);
					++dunno;
				}
			break;
		case MUHAHA: muhaha(user); ++dunno; break;
		case MUMBLE: mumble(user); ++dunno; break;
		case MUZZLE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter who you wish to muzzle: ");
					break;
				case 2:
					muzzle(user);
					++dunno;
				}
			break;
		case MYCLONES: myclones(user); ++dunno; break;
		case NETDATA: netdata(user); ++dunno; break;
		case NETSTAT: netstat(user); ++dunno; break;
		case NEWS: news(user); ++dunno; break;
		case NINE: macro(user,9,inpstr); ++dunno; break;
		case NOD: nod(user); ++dunno; break;
		case NODIFFLOGIN: bandifflogins(user); ++dunno; break;
		case NOGAMES: bangames(user); ++dunno; break;
		case NOGREETS: bangreets(user); ++dunno; break;
		case NOHUNTING: banhunting(user); ++dunno; break;
		case NOLOGIN: banlogins(user); ++dunno; break;
		case NOPICTELLS: banpictells(user); ++dunno; break;
		case NOPROMOS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see the sites or add one? (see/add): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; no_promos(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) { --user->wordcnt; write_user(user,"~OL~FBEnter site to add: "); }
					else { write_user(user,"Do you wish to see the sites or add one? (see/add): "); --user->wordcnt; }
					break;
				case 3:
					no_promos(user);
					++dunno;
				}
			break;
		case NOQUIT: banquits(user); ++dunno; break;
		case NOSHOUTS: banshouts(user); ++dunno; break;
		case NOSMAIL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see the users or add one? (see/add): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; no_smail(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user to add: ");
					else { write_user(user,"Do you wish to see the users or add one? (see/add): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					no_smail(user);
					++dunno;
				}
			break;
		case NOSMOKES: bansmoking(user); ++dunno; break;
		case NOSOCIALS: bansocials(user); ++dunno; break;
		case NOSUICIDES: bansuicides(user); ++dunno; break;
		case NUMBER:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter a number: ");
					break;
				case 2:
					number(user);
					++dunno;
				}
			break;
		case OAFK:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					oafk(user,inpstr);
					++dunno;
				}
			break;
		case OBEEPLINE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					toggle_beep(user);
					++dunno;
				}
			break;
		case OBEEPLOGIN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					obeeplogin(user);
					++dunno;
				}
			break;
		case OCHARECHO:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					ocharecho(user);
					++dunno;
				}
			break;
		case OINPHR:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter new in phrase: ");
					break;
				case 3:
					set_oiophrase(user,inpstr);
					++dunno;
				}
			break;
		case OLOGIM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					enter_olim(user,0);
					++dunno;
				}
			break;
		case OLOGOM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					enter_olom(user,0);
					++dunno;
				}
			break;
		case OMODE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					toggle_omode(user);
					++dunno;
				}
			break;
		case ONE: macro(user,1,inpstr); ++dunno; break;
		case OOUTPHR:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter new out phrase: ");
					break;
				case 3:
					set_oiophrase(user,inpstr);
					++dunno;
				}
			break;
		case OPASSWD:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					change_other_pass(user);
					++dunno;
				}
			break;
		case OSCOMMAND:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					scommand_omode(user);
					++dunno;
				}
			break;
		case OSET:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					oset(user,inpstr);
					++dunno;
				}
			break;
		case OUNAFK:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					ounafk(user,inpstr);
					++dunno;
				}
			break;
		case OUTPHRASE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see your current out phrase or change it? (see/change): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; set_iophrase(user,inpstr); ++dunno; }
					else if (!strncasecmp(user->word[1],"change",strlen(user->word[1]))) write_user(user,"~OL~FBEnter your new out phrase: ");
					else { write_user(user,"Do you wish to see your current out phrase or change it? (see/change): "); --user->wordcnt; }
					break;
				case 3:
					set_iophrase(user,inpstr);
					++dunno;
				}
			break;
		case PANIC: panic(user); ++dunno; break;
		case PASSWD: change_pass(user); ++dunno; break;
		case PASTE: --word_count; paste(user,0); ++dunno; break;
		case PEMOTE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					if (user->scommand_mode) snprintf(text,sizeof(text),"~OL~FBEnter what you wish to private emote to %s: ",user->word[1]);
					else snprintf(text,sizeof(text),"~OL~FBEnter what you wish to private emote: ");
					write_user(user,text);
					break;
				case 3:
					pemote(user,inpstr);
					++dunno;
				}
			break;
		case PEOPLE: who(user,1); ++dunno; break;
		case PICKCOL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to pick a color or delete a color? (pick/del): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"pick",strlen(user->word[1]))) { pick_col(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"del",strlen(user->word[1]))) write_user(user,"~OL~FBEnter color to delete (who/say/tell/all): ");
					else { write_user(user,"Do you wish to pick a color or delete a color? (pick/del): "); --user->wordcnt; }
					break;
				case 3:
					sntrncpy(word[1],"delete",sizeof(word[1]));
					pick_col(user);
					++dunno;
				}
			break;
		case PICKCOLS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"Do you wish to pick a color or delete a color? (pick/del): ");
					break;
				case 3:
					if (!strncasecmp(user->word[2],"pick",strlen(user->word[2]))) { pick_ocol(user); ++dunno; }
					else if (!strncasecmp(user->word[2],"del",strlen(user->word[2]))) write_user(user,"~OL~FBEnter color to delete (who/say/tell/all): ");
					else { write_user(user,"Do you wish to pick a color or delete a color? (pick/del): "); --user->wordcnt; }
					break;
				case 4:
					sntrncpy(word[2],"delete",sizeof(word[2]));
					pick_ocol(user);
					++dunno;
				}
			break;
		case PICTELL:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					pick_pic(user,0,inpstr);
					break;
				case 3:
					pictell(user);
					++dunno;
				}
			break;
		case PINFO:
			switch(user->wordcnt) {
				case 1: write_user(user,"~OL~FBEnter property number: ");
					break;
				case 2:
					monopoly(user,8);
					++dunno;
				}
			break;
		case PING:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					ping(user);
					++dunno;
				}
			break;
		case POKE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					poke(user);
					++dunno;
				}
			break;
		case PONG:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					pong(user);
					++dunno;
				}
			break;
		case PRIVCOM: set_room_access(user); ++dunno; break;
		case PROFILE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see your login profile or add to it? (see/add): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; profile(user,inpstr); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) write_user(user,"~OL~FBEnter profile number and text: ");
					else { write_user(user,"Do you wish to see your login profile or add to it? (see/add): "); --user->wordcnt; }
					break;
				case 3:
					profile(user,inpstr);
					++dunno;
				}
			break;
		case PROFILES:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"Do you wish to see the profile or add to it? (see/add): ");
					break;
				case 3:
					if (!strncasecmp(user->word[2],"see",strlen(user->word[2]))) { --word_count; profiles(user,inpstr); ++dunno; }
					else if (!strncasecmp(user->word[2],"add",strlen(user->word[2]))) write_user(user,"~OL~FBEnter profile number: ");
					else { write_user(user,"Do you wish to see the profile or add to it? (see/add): "); --user->wordcnt; }
					break;
				case 4:
					sntrncpy(user->word[2],user->word[3],sizeof(user->word[2]));
					write_user(user,"~OL~FBEnter text: ");
					break;
				case 5:
					profiles(user,inpstr);
					++dunno;
				}
			break;
		case PROMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					promote(user);
					++dunno;
				}
			break;
		case PROMPT: toggle_prompt(user); ++dunno; break;
		case PROPERTY: monopoly(user,6); ++dunno; break;
		case PUBCOM: set_room_access(user); ++dunno; break;
		case PUKE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					puke(user);
					++dunno;
				}
			break;
		case PUT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Where do you wish to put that? ");
					break;
				case 2:
					yahtzee(user,2);
					++dunno;
				}
			break;
		case QUIET: quiet_user(user); ++dunno; break;
		case QUIT:
			if (!ban_quitting && !user->frozen) disconnect_user(user);
			else { write_user(user,"Why?\n"); snprintf(text,sizeof(text),"%s tried to quit but failed miserably.\n",user->name); write_syslog(text,1); }
			++dunno;
			break;
		case QUITIN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter number of minutes: ");
					break;
				case 2:
					if (!ban_quitting && !user->frozen) quitin(user);
					else {
						write_user(user,"eh?\n");
						snprintf(text,sizeof(text),"%s tried to quit but failed miserably.\n",user->name);
						write_syslog(text,1);
						++dunno;
						}
				}
			break;
		case QUIZ: quiz(user); ++dunno; break;
		case RANKS: ranks(user); ++dunno; break;
		case RCOMPLAIN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to read all the complaints or n number of lines? (all/num): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"all",strlen(user->word[1]))) { --word_count; rcomplain(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { --user->wordcnt; write_user(user,"~OL~FBEnter number of lines: "); }
					else { write_user(user,"Do you wish to read all the complaints or n number of lines? (all/num): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					if (isnumber(word[1])) {
						rcomplain(user);
						++dunno;
						break;
						}
					else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
				}
			break;
		case READ:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to read this room's board or another? (here/another): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"here",strlen(user->word[1]))) write_user(user,"Do you wish to read the whole board or n number of lines? (all/num): ");
					else if (!strncasecmp(user->word[1],"another",strlen(user->word[1]))) pick_room(user,0,inpstr);
					else { write_user(user,"Do you wish to read this room's board or another? (here/another): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"here",strlen(user->word[1]))) {
						if (!strncasecmp(user->word[2],"all",strlen(user->word[2]))) {
							word_count-=2;
							read_board(user);
							++dunno;
							break;
							}
						else if (!strncasecmp(user->word[2],"num",strlen(user->word[2]))) write_user(user,"~OL~FBEnter number of lines: ");
						else { write_user(user,"Do you wish to read the whole board or n number of lines? (all/num): "); --user->wordcnt; }
						}
					else {
						if (!strncasecmp(user->word[1],"another",strlen(user->word[1]))) write_user(user,"Do you wish to read the whole board or n number of lines? (all/num): ");
						sntrncpy(user->word[1],user->word[2],sizeof(user->word[1]));
						}
					break;
				case 4:
					if (!strncasecmp(user->word[1],"here",strlen(user->word[1]))) {
						word_count-=2;
						sntrncpy(word[1],user->word[3],sizeof(word[1]));
						if (isnumber(word[1])) {
							read_board(user);
							++dunno;
							break;
							}
						else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
						}
					if (!strncasecmp(user->word[3],"all",strlen(user->word[3]))) { word_count-=2; read_board(user); ++dunno; }
					else if (!strncasecmp(user->word[3],"num",strlen(user->word[3]))) write_user(user,"~OL~FBEnter number of lines: ");
					else { write_user(user,"All or n number of lines (all/num): "); --user->wordcnt; }
					break;
				case 5:
					word_count-=2;
					sntrncpy(word[2],user->word[4],sizeof(word[2]));
					if (isnumber(word[2])) {
						read_board(user);
						++dunno;
						break;
						}
					else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
				}
			break;
		case REBOOT: write_user(user,"\07*** WARNING - This will reboot the talker! ***\n\nAre you sure about this (y/n)? "); user->misc_op=10; ++dunno; break;
		case RECAP:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter new recapped name: ");
					break;
				case 2:
					recap(user);
					++dunno;
				}
			break;
		case REDESC:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter room name or all: ");
					break;
				case 2:
					redesc(user);
					++dunno;
				}
			break;
		case RENAME:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter new name: ");
					break;
				case 3:
					rename_user(user);
					++dunno;
				}
			break;
		case REROLL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Reroll which dice? ");
					break;
				case 2:
					yahtzee(user,1);
					++dunno;
				}
			break;
		case RESETQUIZ:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					reset_quiz(user);
					++dunno;
				}
			break;
		case RESPAWN: respawn(user); ++dunno; break;
		case ORESPAWN:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					respawno(user);
					++dunno;
				}
			break;
		case REVCHANNEL: revchannel(user); ++dunno; break;
		case REVCLR: clear_conv(user->room); write_user(user,"Buffer cleared.\n"); ++dunno; break;
		case REVCLRALL: clear_allconv(user); ++dunno; break;
		case REVIEW:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to review this room's conversation or another? (here/another): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"here",strlen(user->word[1]))) write_user(user,"Do you wish to review the whole conversation or n number of lines? (all/num): ");
					else if (!strncasecmp(user->word[1],"another",strlen(user->word[1]))) pick_room(user,0,inpstr);
					else { write_user(user,"Do you wish to review this room's conversation or another? (here/another): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"here",strlen(user->word[1]))) {
						if (!strncasecmp(user->word[2],"all",strlen(user->word[2]))) {
							word_count-=2;
							review(user);
							++dunno;
							break;
							}
						else if (!strncasecmp(user->word[2],"num",strlen(user->word[2]))) write_user(user,"~OL~FBEnter number of lines: ");
						else { write_user(user,"Do you wish to review the whole conversation or n number of lines? (all/num): "); --user->wordcnt; }
						}
					else {
						if (!strncasecmp(user->word[1],"another",strlen(user->word[1]))) write_user(user,"Do you wish to review the whole conversation or n number of lines? (all/num): ");
						sntrncpy(user->word[1],user->word[2],sizeof(user->word[1]));
						}
					break;
				case 4:
					if (!strncasecmp(user->word[1],"here",strlen(user->word[1]))) {
						word_count-=2;
						sntrncpy(word[1],user->word[3],sizeof(word[1]));
						if (isnumber(word[1])) {
							review(user);
							++dunno;
							break;
							}
						else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
						}
					if (!strncasecmp(user->word[3],"all",strlen(user->word[3]))) { word_count-=2; review(user); ++dunno; }
					else if (!strncasecmp(user->word[3],"num",strlen(user->word[3]))) write_user(user,"~OL~FBEnter number of lines: ");
					else { write_user(user,"All or n number of lines (all/num): "); --user->wordcnt; }
					break;
				case 5:
					word_count-=2;
					sntrncpy(word[2],user->word[4],sizeof(word[2]));
					if (isnumber(word[2])) {
						review(user);
						++dunno;
						break;
						}
					else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
				}
			break;
		case REVOKE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"Revoke what: ");
					break;
				case 3:
					revokeem(user);
					++dunno;
				}
			break;
		case REVSHOUT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to read all the shouts or n number of lines? (all/num): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"all",strlen(user->word[1]))) { --word_count; revshout(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of lines: ");
					else { write_user(user,"Do you wish to read all the shouts or n number of lines? (all/num): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					if (isnumber(word[1])) {
						revshout(user);
						++dunno;
						break;
						}
					else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
				}
			break;
		case REVTELL: revtell(user); ++dunno; break;
		case REVWIZ: revwiz(user); ++dunno; break;
		case RLOOK:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					rlook(user);
					++dunno;
				}
			break;
		case RMAIL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBAll~RS your mail, n number of ~OL~FRlines~RS, or ~OL~FGnew~RS mail? ~OL~FY(~RS~OL~FBa~RS~OL~FM/~RS~OL~FRl~RS~OL~FM/~RS~OL~FGn~RS~OL~FY)~RS: ");
					break;
				case 2:
					if (!strcasecmp(user->word[1],"A")) { sntrncpy(word[1],"all",sizeof(word[1])); rmail(user); ++dunno; }
					else if (!strcasecmp(user->word[1],"N")) { sntrncpy(word[1],"new",sizeof(word[1])); rmail(user); ++dunno; }
					else if (!strcasecmp(user->word[1],"L")) { sntrncpy(user->word[1],"lines",sizeof(user->word[1])); write_user(user,"~OL~FBEnter number of lines: "); }
					else { write_user(user,"~OL~FBAll~RS your mail, n number of ~OL~FRlines~RS, or ~OL~FGnew~RS mail? ~OL~FY(~RS~OL~FBa~RS~OL~FM/~RS~OL~FRl~RS~OL~FM/~RS~OL~FGn~RS~OL~FY)~RS: "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					if (isnumber(word[1])) {
						rmail(user);
						++dunno;
						break;
						}
					else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
				}
			break;
		case RMSN: rooms(user,0); ++dunno; break;
		case RMST: rooms(user,1); ++dunno; break;
		case ROFL: rofl(user); ++dunno; break;
		case ROLL: monopoly(user,1); ++dunno; break;
		case ROLLS: rolls(user); ++dunno; break;
		case ROOMADD:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter name: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter room label: ");
					break;
				case 3:
					write_user(user,"~OL~FBEnter room access~RS (~FGPUB~RS/~FRPRIV~RS/~OL~FYBOTH~RS/~FBHID~RS): ");
					break;
				case 4:
					write_user(user,"~OL~FBEnter room links\n");
					pick_label(user,0,inpstr);
					break;
				case 5:
					write_user(user,"~OL~FBEnter room exit\n");
					pick_label(user,0,inpstr);
					break;
				case 6:
					add_room(user);
					++dunno;
				}
			break;
		case ROOMDEL:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					del_room(user);
					++dunno;
				}
			break;
		case ROOMDESC:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					room_desc(user,inpstr,0);
					++dunno;
				}
			break;
		case RSTAT:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					remote_stat(user);
					++dunno;
				}
			break;
		case RSUGGEST:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to read all the suggestions or n number of lines? (all/num): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"all",strlen(user->word[1]))) { --word_count; rsuggest(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of lines: ");
					else { write_user(user,"Do you wish to read all the suggestions or n number of lines? (all/num): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					if (isnumber(word[1])) {
						rsuggest(user);
						++dunno;
						break;
						}
					else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
					}
				break;
		case RULES: rules(user); ++dunno; break;
		case SAMESITE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"user or site: ");
					break;
				case 2:
					write_user(user,"user/site: ");
					break;
				case 3:
					samesite(user);
					++dunno;
				}
			break;
		case SAY:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to say: ");
					break;
				case 2:
					say(user,inpstr);
					++dunno;
				}
			break;
		case SCLOSEALL: close_allsock(user,0); ++dunno; break;
		case SCOMMAND: scommand_mode(user); ++dunno; break;
		case SCREAM: scream(user); ++dunno; break;
		case SEARCH:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to search for: ");
					break;
				case 2:
					search_boards(user);
					++dunno;
				}
			break;
		case SEARCHSITE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"site or user: ");
					break;
				case 2:
					write_user(user,"site/user: ");
					break;
				case 3:
					searchsite(user);
					++dunno;
				}
			break;
		case SECHO:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to shout echo: ");
					break;
				case 2:
					secho(user,inpstr);
					++dunno;
				}
			break;
		case SELFDESTRUCT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					selfdestructem(user);
					++dunno;
				}
			break;
		case SELL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to sell: ");
					break;
				case 2:
					monopoly(user,3);
					++dunno;
				}
			break;
		case SEMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to shout emote: ");
					break;
				case 2:
					semote(user,inpstr);
					++dunno;
				}
			break;
		case SENTMAIL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBAll~RS your sent mail, n number of ~OL~FRlines~RS, or ~OL~FGnew~RS sent mail? ~OL~FY(~RS~OL~FBa~RS~OL~FM/~RS~OL~FRl~RS~OL~FM/~RS~OL~FGn~RS~OL~FY)~RS: ");
					break;
				case 2:
					if (!strcasecmp(user->word[1],"A")) { sntrncpy(word[1],"all",sizeof(word[1])); sent_mail(user); ++dunno; }
					else if (!strcasecmp(user->word[1],"N")) { sntrncpy(word[1],"new",sizeof(word[1])); sent_mail(user); ++dunno; }
					else if (!strcasecmp(user->word[1],"L")) { sntrncpy(user->word[1],"lines",sizeof(user->word[1])); write_user(user,"~OL~FBEnter number of lines: "); }
					else { write_user(user,"~OL~FBAll~RS your sent mail, n number of ~OL~FRlines~RS, or ~OL~FGnew~RS sent mail? ~OL~FY(~RS~OL~FBa~RS~OL~FM/~RS~OL~FRl~RS~OL~FM/~RS~OL~FGn~RS~OL~FY)~RS: "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					if (isnumber(word[1])) {
						sent_mail(user);
						++dunno;
						break;
						}
					else { write_user(user,"~OL~FBEnter number of lines: "); --word_count; }
				}
			break;
		case SET: set(user,inpstr); ++dunno; break;
		case SETDESC:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter new description: ");
					break;
				case 3:
					set_desc(user,inpstr);
					++dunno;
				}
			break;
		case SETPRO:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter which user's profile you wish to change: ");
					break;
				case 2:
					--word_count;
					set_profile(user,0);
					++dunno;
				}
			break;
		case SEVEN: macro(user,7,inpstr); ++dunno; break;
		case SFROM: mail_sfrom(user,0); ++dunno; break;
		case SHAKE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					shake(user);
					++dunno;
				}
			break;
		case SHOUT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to shout: ");
					break;
				case 2:
					shout(user,inpstr);
					++dunno;
				}
			break;
		case SHOWHIDDEN: show_hidden(user,0); ++dunno; break;
		case SHRUG: shrug(user); ++dunno; break;
		case SHUNT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Shoot where: ");
					break;
				case 2:
					hunt(user,2);
					++dunno;
				}
			break;
		case SHUTDOWN: write_user(user,"Are you sure about this (y/n)? "); user->misc_op=1; ++dunno; break;
		case SIGH: sigh(user); ++dunno; break;
		case SING:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to sing: ");
					break;
				case 2:
					sing(user,inpstr);
					++dunno;
				}
			break;
		case SITE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter which user you wish to site: ");
					break;
				case 2:
					siteuser(user);
					++dunno;
				}
			break;
		case SIX: macro(user,6,inpstr); ++dunno; break;
		case SLEDGE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					sledge(user);
					++dunno;
				}
			break;
		case SLEEP: sleepuser(user); ++dunno; break;
		case SMAIL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter which user you wish to smail: ");
					break;
				case 2:
					smail(user,inpstr,0);
					++dunno;
				}
			break;
		case SMAILALL: --word_count; smailall(user,inpstr,0); ++dunno; break;
		case SMBAN: bansmailing(user); ++dunno; break;
		case SMOKE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					smoke(user);
					++dunno;
				}
			break;
		case SOCIALS: socials(user); ++dunno; break;
		case SPECIAL: makeem_special(user,0); ++dunno; break;
		case SPECIALSITE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see who the special sites or add a site? (see/add): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; specialsite(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) write_user(user,"~OL~FBEnter special site: ");
					else { write_user(user,"Do you wish to see who the special sites or add a site? (see/add): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					specialsite(user);
					++dunno;
				}
			break;
		case SPECIALTOO: makeem_special(user,1); ++dunno; break;
		case SPELL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter word to spell check: ");
					break;
				case 2:
					spell(user);
					++dunno;
				}
			break;
		case STALK:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					stalk(user,1);
					++dunno;
				}
			break;
		case STATUS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to stat yourself or someone else? (me/else): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; status(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to stat yourself or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					status(user);
					++dunno;
				}
			break;
		case STAYTHERE: stayput(user); ++dunno; break;
		case STHINK:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you think: ");
					break;
				case 2:
					sthink(user,inpstr);
					++dunno;
				}
			break;
		case STOPUSER:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"Stop what: ");
					break;
				case 3:
					stopuser(user);
					++dunno;
				}
			break;
		case STOP_COM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter command to stop: ");
					break;
				case 2:
					stop_command(user);
					++dunno;
				}
			break;
		case SU: super_user(user,0); ++dunno; break;
		case SUBTIME:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter number of minutes: ");
					break;
				case 3:
					subtime(user);
					++dunno;
				}
			break;
		case SUBTSIGN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter number of signons: ");
					break;
				case 3:
					subtsign(user);
					++dunno;
				}
			break;
		case SUGGEST: suggest(user,inpstr,0); ++dunno; break;
		case SUICIDE: suicide(user); ++dunno; break;
		case SUPERCRON:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter hour: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter minute: ");
					break;
				case 3:
					write_user(user,"~OL~FBEnter cron job: ");
					break;
				case 4:
					supercron(user,inpstr);
					++dunno;
				}
			break;
		case SWAT: swat(user); ++dunno; break;
		case SWBAN: swban(user); ++dunno; break;
		case SWHO: users(user); ++dunno; break;
		case SWITCH:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					clone_switch(user);
					++dunno;
				}
			break;
		case SYSBANS: system_bans(user); ++dunno; break;
		case SYSMAIL: sysmail(user); ++dunno; break;
		case SYSSTAT: sys_stats(user); ++dunno; break;
		case SYSTEM: system_details(user); ++dunno; break;
		case TAG:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					tag(user);
					++dunno;
				}
			break;
		case TALK: talk_to_me(user); ++dunno; break;
		case TAP: tapfoot(user); ++dunno; break;
		case TELL:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					if (user->scommand_mode) snprintf(text,sizeof(text),"~OL~FBEnter what you wish to tell %s: ",user->word[1]);
					else snprintf(text,sizeof(text),"~OL~FBEnter what you wish to tell: ");
					write_user(user,text);
					break;
				case 3:
					tell(user,inpstr);
					++dunno;
				}
			break;
		case TEN: macro(user,10,inpstr); ++dunno; break;
		case THANK:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					thank(user);
					++dunno;
				}
			break;
		case THINK:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you think: ");
					break;
				case 2:
					think(user,inpstr);
					++dunno;
				}
			break;
		case THREE: macro(user,3,inpstr); ++dunno; break;
		case THROW:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					throw(user);
					++dunno;
				}
			break;
		case THWAP:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					thwap(user);
					++dunno;
				}
			break;
		case TICKLE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					tickle(user);
					++dunno;
				}
			break;
		case TICTACTOE: ttt(user,0); ++dunno; break;
		case TIMEDIFF:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to add/subtract from the current time or delete current time\ndifference? (add/delete/sub): ");
					break;
				case 2:
					if (!strcasecmp(user->word[1],"delete")) { time_diff(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1])) || !strncasecmp(user->word[1],"sub",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of hours: ");
					else { write_user(user,"Do you wish to add/subtract from the current time or delete current time\ndifference? (add/delete/sub): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"+%s",user->word[2]); time_diff(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"sub",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"-%s",user->word[2]); time_diff(user); ++dunno; }
					else {
						write_user(user,"~OL~FBEnter number of hours: ");
						--user->wordcnt;
						}
				}
			break;
		case TINKLE: tinkle(user); ++dunno; break;
		case TOGGLE_OIGNORE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					otignore(user);
					++dunno;
				}
			break;
		case TOGGLE_OLISTEN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					otlisten(user);
					++dunno;
				}
			break;
		case TOPIC:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see the current topic or change it? (see/change): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; set_topic(user,inpstr); ++dunno; }
					else if (!strncasecmp(user->word[1],"change",strlen(user->word[1]))) write_user(user,"~OL~FBEnter the new topic: ");
					else { write_user(user,"Do you wish to see the current topic or change it? (see/change): "); --user->wordcnt; }
					break;
				case 3:
					set_topic(user,inpstr);
					++dunno;
				}
			break;
		case TOPICALL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter new topic: ");
					break;
				case 2:
					topic_allboard(user,inpstr);
					++dunno;
				}
			break;
		case TORNADO: tornado(user); ++dunno; break;
		case TRADE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to trade money or a property? (money/property): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"property",strlen(user->word[1]))) pick_prop(user,inpstr,user->name,0);
					else write_user(user,"~OL~FBEnter dollar amount: ");
					break;
				case 3:
					pick_user(user,0,inpstr);
					break;
				case 4:
					write_user(user,"Do you wish to trade for money or a property? (money/property): ");
					break;
				case 5:
					if (!strncasecmp(user->word[4],"property",strlen(user->word[4]))) pick_prop(user,inpstr,user->word[user->wordcnt-2],0);
					else write_user(user,"~OL~FBEnter dollar amount: ");
					break;
				case 6:
					monopoly(user,7);
					++dunno;
				}
			break;
		case TRIGGER:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to see your tiggers since tiggers are a wonderful thing, add a\ntigger, or delete your tiggers:( (add/del/see): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"see",strlen(user->word[1]))) { --word_count; trigger(user,0); ++dunno; }
					else if (!strncasecmp(user->word[1],"add",strlen(user->word[1]))) write_user(user,"~OL~FBEnter trigger number: ");
					else if (!strncasecmp(user->word[1],"del",strlen(user->word[1]))) { sntrncpy(word[1],"delete",sizeof(word[1])); trigger(user,0); ++dunno; }
					else { write_user(user,"Do you wish to see your tiggers since tiggers are a wonderful thing, add a\ntrigger, or delete your tiggers:( (add/del/see): "); --user->wordcnt; }
					break;
				case 3:
					sntrncpy(word[1],word[2],sizeof(word[1]));
					trigger(user,0);
					++dunno;
				}
			break;
		case TWO: macro(user,2,inpstr); ++dunno; break;
		case TXT:
			switch(user->wordcnt) {
				case 1:
					pick_text(user,0,inpstr);
					break;
				case 2:
					txt(user);
					++dunno;
				}
			break;
		case UNANNOY:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					annoy(user,0);
					++dunno;
				}
			break;
		case UNANNOYEM:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					annoy_user(user,0,inpstr);
					++dunno;
				}
			break;
		case UNARREST:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					unarrest(user);
					++dunno;
				}
			break;
		case UNBAKE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					unbake(user);
					++dunno;
				}
			break;
		case UNBAN:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter if ya want to unban a site, domain, user, swear word, or allow:\n(allow/domain/newdomain/swearing/user): ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter domain to unallow or domain, new domain, swear word, or user to unban: ");
					break;
				case 3:
					unban(user);
					++dunno;
				}
			break;
		case UNBIG:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to make yourself small or someone else? (me/else): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; big(user,0); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to make yourself small or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					big(user,0);
					++dunno;
				}
			break;
		case UNBOUNCE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					bounce(user,0);
					++dunno;
				}
			break;
		case UNCOMMIT:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					commit(user,0);
					++dunno;
				}
			break;
		case UNDARK:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					undarkness(user);
					++dunno;
				}
			break;
		case UNDRAG:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					drag(user,0);
					++dunno;
				}
			break;
		case UNFIX:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					change_room_fix(user,0);
					++dunno;
				}
			break;
		case UNFREEZE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					unfreeze(user);
					++dunno;
				}
			break;
		case UNFREEZEALL: unfreezeall(user); ++dunno; break;
		case UNHIDE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to unhide yourself or someone else? (me/else): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; hide(user,0); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to unhide yourself or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					hide(user,0);
					++dunno;
				}
			break;
		case UNLOCK:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter user: ");
					break;
				case 2:
					unlock_user(user);
					++dunno;
				}
			break;
		case UNMORTGAGE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to unmortgage: ");
					break;
				case 2:
					monopoly(user,5);
					++dunno;
				}
			break;
		case UNMUZZLE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter who you wish to unmuzzle: ");
					break;
				case 2:
					unmuzzle(user);
					++dunno;
				}
			break;
		case UNRESPAWN:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					unrespawn(user);
					++dunno;
				}
			break;
		case UNSTALK:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					stalk(user,0);
					++dunno;
				}
			break;
		case UNWOOHOO:
			switch(user->wordcnt) {
				case 1:
					if (user->level>CAPTAIN) write_user(user,"Do you wish to unwoohoo yourself or someone else? (me/else): ");
					else { woohoo(user,0); ++dunno; }
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; woohoo(user,0); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to unwoohoo yourself or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					woohoo(user,0);
					++dunno;
				}
			break;
		case USTAT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to ustat yourself or someone else? (me/else): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; ustatus(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"You or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					ustatus(user);
					++dunno;
				}
			break;
		case VACATION: enter_vacation(user,0); ++dunno; break;
		case VANITY:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"How many players? ");
					break;
				case 2:
					vanity(user,0,0);
					++dunno;
				}
			break;
		case VER: snprintf(text,sizeof(text),"HOLE version %s ---> NUTS version %s\n",HVERSION,NVERSION); write_user(user,text); ++dunno; break;
		case VIEWLOG: viewlog(user); ++dunno; break;
		case VIEWSITE: viewsite(user); ++dunno; break;
		case VIOLIN:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					violin(user);
					++dunno;
				}
			break;
		case VIS:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to make yourself visible or someone else? (me/else): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; visibility(user,1); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) pick_user(user,0,inpstr);
					else { write_user(user,"Do you wish to make yourself visible or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					visibility(user,1);
					++dunno;
				}
			break;
		case WAKE:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					wake(user);
					++dunno;
				}
			break;
		case WARN:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					write_user(user,"Warn of what? ");
					break;
				case 3:
					warn_user(user,inpstr);
					++dunno;
				}
			break;
		case WAVE: wave(user); ++dunno; break;
		case WELCOME:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					welcome(user);
					++dunno;
				}
			break;
		case WHISTLE: whistle(user); ++dunno; break;
		case WHO: who(user,0); ++dunno; break;
		case WHOBTG:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"talker or site: ");
					break;
				case 2:
					write_user(user,"<talker/site>: ");
					break;
				case 3:
					whobtg(user,0);
					++dunno;
				}
			break;
		case WHOIS:
			switch(user->wordcnt) {
				case 1:
					pick_user(user,0,inpstr);
					break;
				case 2:
					whois(user);
					++dunno;
				}
			break;
		case WHOLOGIN: banwhologins(user); ++dunno; break;
		case WHYME: whyme(user); ++dunno; break;
		case WINATTACK:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"site/user: " );
					break;
				case 2:
					write_user(user,"<site/user name>: " );
					break;
				case 3:
					winattack(user);
					++dunno;
				}
			break;
		case WIPE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to delete all the messages, one message,\nall messages from a certain user, first n number\nof messages, or prompt you? (all/one/user/num/prompt): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"all",strlen(user->word[1]))) { sntrncpy(word[1],"all",sizeof(word[1])); wipe_board(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"prompt",strlen(user->word[1]))) { sntrncpy(word[1],"prompt",sizeof(word[1])); wipe_board(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) write_user(user,"~OL~FBEnter message number: ");
					else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user name: ");
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) write_user(user,"~OL~FBEnter number of messages: ");
					else { write_user(user,"Do you wish to delete all the messages, one message,\nall messages from a certain user, first n number\nof messages, or prompt you? (all/one/user/num/prompt): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"#%i",atoi(user->word[2])); wipe_board(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"$%s",user->word[2]); wipe_board(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { --word_count; sntrncpy(word[1],user->word[2],sizeof(word[1])); wipe_board(user); ++dunno; }
					else {
						if (!strncasecmp(user->word[1],"one",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter message number: "); }
						else if (!strncasecmp(user->word[1],"user",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter user name: "); }
						else if (!strncasecmp(user->word[1],"num",strlen(user->word[1]))) { write_user(user,"~OL~FBEnter number of messages: "); }
						--user->wordcnt;
						}
				}
			break;
		case WIPEALL:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"Do you wish to delete all the messages by a user or that contains\na given word? (name/word): ");
					break;
				case 2:
					if (!strncasecmp(user->word[1],"name",strlen(user->word[1]))) write_user(user,"~OL~FBEnter name: ");
					else if (!strncasecmp(user->word[1],"word",strlen(user->word[1]))) write_user(user,"~OL~FBEnter word: ");
					else { write_user(user,"Do you wish to delete all the messages by a user or that contains\na given word? (name/word): "); --user->wordcnt; }
					break;
				case 3:
					if (!strncasecmp(user->word[1],"name",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"$%s",user->word[2]); wipe_allboard(user); ++dunno; }
					else if (!strncasecmp(user->word[1],"word",strlen(user->word[1]))) { --word_count; snprintf(word[1],sizeof(word[1]),"&%s",user->word[2]); wipe_allboard(user); ++dunno; }
					else {
						if (!strncasecmp(user->word[1],"name",strlen(user->word[1]))) write_user(user,"~OL~FBEnter name: ");
						else if (!strncasecmp(user->word[1],"word",strlen(user->word[1]))) write_user(user,"~OL~FBEnter word: ");
						--user->wordcnt;
						}
				}
			break;
		case WIZEMOTE:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to wizemote: ");
					break;
				case 2:
					wizemote(user,inpstr);
					++dunno;
				}
			break;
		case WIZHELP: wizhelp(user); ++dunno; break;
		case WIZSHOUT:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter what you wish to wizshout: ");
					break;
				case 2:
					wizshout(user,inpstr);
					++dunno;
				}
			break;
		case WIZWHO: wizwho(user); ++dunno; break;
		case WLOOK:
			switch(user->wordcnt) {
				case 1:
					pick_room(user,0,inpstr);
					break;
				case 2:
					wlook(user);
					++dunno;
				}
			break;
		case WOOHOO:
			switch(user->wordcnt) {
				case 1:
					if (user->level>CAPTAIN) write_user(user,"Do you wish to woohoo yourself or someone else? (me/else): ");
					else { woohoo(user,1); ++dunno; }
					break;
				case 2:
					if (!strncasecmp(user->word[1],"me",strlen(user->word[1]))) { --word_count; woohoo(user,1); ++dunno; }
					else if (!strncasecmp(user->word[1],"else",strlen(user->word[1]))) write_user(user,"~OL~FBEnter user: ");
					else { write_user(user,"Do you wish to woohoo yourself or someone else? (me/else): "); --user->wordcnt; }
					break;
				case 3:
					--word_count;
					sntrncpy(word[1],user->word[2],sizeof(word[1]));
					woohoo(user,1);
					++dunno;
				}
			break;
		case WRITE: --word_count; write_board(user,inpstr,0); ++dunno; break;
		case WRITEALL: --word_count; write_allboard(user,inpstr,0); ++dunno; break;
		case WRITESOCK:
			switch(user->wordcnt) {
				case 1:
					write_user(user,"~OL~FBEnter which socket: ");
					break;
				case 2:
					write_user(user,"~OL~FBEnter text: ");
					break;
				case 3:
					writetosock(user,inpstr);
					++dunno;
				}
			break;
		case YAHTZEE: yahtzee(user,0); ++dunno; break;
		case YIPPEE: yippee(user); ++dunno; break;
		default: write_user(user,"Command not found.\n"); ++dunno;
		}
	}
if (destructed) return;
if (!dunno) {
	if (!user->scommand_mode) {
		if (which==3 && !hmmer && !user->notcomplete) user->notyet=0;
		else if (which==3 && !hmmer && user->notcomplete) user->notyet=1;
		user->notcomplete=1;
		}
	return;
	}
else {
	if (!user->misc_op || (user->misc_op==56 && !user->notyet)) reset_scom(user,0);
	user->notyet=0;
	}
}

/*** Re-read the room descriptions ***/
void redesc(user)
UR_OBJECT user;
{
char c,filename[FILENAME_LEN];
int i=0;
FILE *fp;
RM_OBJECT room;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room name/all>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room name/all>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!strcasecmp(word[1],"all")) {
	for(room=room_first;room;room=room->next) {
		snprintf(filename,sizeof(filename),"%s/%s.R",DATAFILES,room->name);
		if (!(fp=fopen(filename,"r"))) {
			fprintf(stderr,"SYSTEM ERROR: Can't open description file for room \"%s\".\n",room->name);
			return;
			}
		c=getc(fp);
		while(c!=EOF) {
			if (i==ROOM_DESC_LEN) {
				fprintf(stderr,"SYSTEM ERROR: Description too long for room \"%s\".\n",room->name);
				continue;
				}
			room->desc[i++]=c;
			c=getc(fp);
			}
		room->desc[i]='\0';
		fclose(fp);
		}
	snprintf(text,sizeof(text),"%s re-read the room descriptions.\n",user->name);
	write_syslog(text,1);
	write_user(user,"Room descriptions re-read.\n");
	return;
	}
if (!(room=get_room(user,word[1]))) return;
snprintf(filename,sizeof(filename),"%s/%s.R",DATAFILES,room->name);
if (!(fp=fopen(filename,"r"))) {
	fprintf(stderr,"SYSTEM ERROR: Can't open description file for room \"%s\".\n",room->name);
	return;
	}
c=getc(fp);
while(c!=EOF) {
	if (i==ROOM_DESC_LEN) {
		fprintf(stderr,"SYSTEM ERROR: Description too long for room \"%s\".\n",room->name);
		break;
		}
	room->desc[i++]=c;
	c=getc(fp);
	}
room->desc[i]='\0';
fclose(fp);
snprintf(text,sizeof(text),"%s re-read the room description for room %s.\n",user->name,room->name);
write_syslog(text,1);
write_user(user,"Room description re-read.\n");
}

/*** List defined netlinks and their status ***/
void netstat(user)
UR_OBJECT user;
{
char *allow[]={ "  ?","ALL"," IN","OUT" };
char *type[]={ "  -"," IN","OUT" };
char portstr[6],stat[9],vers[8];
int a,iu=0,ou=0;
NL_OBJECT nl;
UR_OBJECT user2;

if (!nl_first) {
	write_user(user,"No remote connections configured.\n");
	return;
	}
write_user(user,"\n~BB*** Netlink data & status ***\n\n~FTService name    : Allow Type Status IU OU Version  Site\n\n");
for(nl=nl_first;nl;nl=nl->next) {
	iu=0;  ou=0;
	if (nl->stage==2) {
		for(user2=user_first;user2;user2=user2->next) {
			if (user2->netlink==nl) {
				if (user2->type==REMOTE_TYPE) ++iu;
				if (!user2->room) ++ou;
				}
			}
		}
	if (nl->port) snprintf(portstr,sizeof(portstr),"%d",nl->port);  else portstr[0]='\0';
	if (nl->type==UNCONNECTED) {
		sntrncpy(stat,"~FRDOWN",sizeof(stat));  sntrncpy(vers,"-",sizeof(vers));
		}
	else {
		if (nl->stage==2) sntrncpy(stat,"  ~FGUP",sizeof(stat));
		else sntrncpy(stat," ~FYVER",sizeof(stat));
		if (!nl->ver_major) sntrncpy(vers,"3.?.?",sizeof(vers));
		else snprintf(vers,sizeof(vers),"%d.%d.%d",nl->ver_major,nl->ver_minor,nl->ver_patch);
		}
	if (!nl->ver_major && nl->type==INCOMING && nl->allow!=IN) a=0;
	else a=nl->allow+1;
	snprintf(text,sizeof(text),"%-15s :   %s  %s   %s~RS %2d %2d %7s  %s %s\n",nl->service,allow[a],type[nl->type],stat,iu,ou,vers,nl->site,portstr);
	write_user(user,text);
	}
write_user(user,"\n");
}

/*** Show type of data being received down links (this is useful when a
     link has hung) ***/
void netdata(user)
UR_OBJECT user;
{
char from[80],name[USER_NAME_LEN+1];
int cnt=0;
NL_OBJECT nl;

write_user(user,"\n*** Mail receiving status ***\n\n");
for(nl=nl_first;nl;nl=nl->next) {
	if (nl->type==UNCONNECTED || !nl->mailfile) continue;
	if (++cnt==1) write_user(user,"To              : From                       Last recv.\n\n");
	snprintf(from,sizeof(from),"%s@%s",nl->mail_from,nl->service);
	snprintf(text,sizeof(text),"%-15s : %-25s  %d seconds ago.\n",nl->mail_to,from,(int)(time(0)-nl->last_recvd));
	write_user(user,text);
	}
if (!cnt) write_user(user,"No mail being received.\n");
cnt=0;
write_user(user,"\n\n*** Message receiving status ***\n\n");
for(nl=nl_first;nl;nl=nl->next) {
	if (nl->type==UNCONNECTED || !nl->mesg_user) continue;
	if (++cnt==1) write_user(user,"To              : From             Last recv.\n\n");
	if (nl->mesg_user==(UR_OBJECT)-1) sntrncpy(name,"<unknown>",sizeof(name));
	else sntrncpy(name,nl->mesg_user->name,sizeof(name));
	snprintf(text,sizeof(text),"%-*s : %-15s  %d seconds ago.\n",USER_NAME_LEN,name,nl->service,(time(0)-nl->last_recvd));
	write_user(user,text);
	}
if (!cnt) write_user(user,"No messages being received.\n\n");
else write_user(user,"\n");
}

/*** Connect a netlink. Use the room as the key ***/
void connect_netlink(user)
UR_OBJECT user;
{
int ret;
NL_OBJECT nl;
RM_OBJECT room;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
if (!(nl=room->netlink)) {
	write_user(user,"That room is not linked to a service.\n");
	return;
	}
if (nl->type!=UNCONNECTED) {
	write_user(user,"That room's netlink is already up.\n");
	return;
	}
write_user(user,"Attempting connect (Warning, this may cause a temporary hang!) ...\n");
snprintf(text,sizeof(text),"NETLINK: Connection attempt to %s initiated by %s.\n",nl->service,user->name);
write_syslog(text,1);
errno=0;
if (!(ret=connect_to_site(nl))) {
	write_user(user,"Initial connection made...\n");
	snprintf(text,sizeof(text),"NETLINK: Connected to service %s (%s %d).\n",nl->service,nl->site,nl->port);
	write_syslog(text,1);
	nl->connect_room=room;
	return;
	}
write_user(user,"Connect failed: ");
write_syslog("NETLINK: Connection attempt failed: ",1);
if (ret==1) {
	snprintf(text,sizeof(text),"%s.\n",sys_errlist[errno]);
	write_user(user,text);
	write_syslog(text,0);
	return;
	}
write_user(user,"Unknown hostname.\n");
write_syslog("Unknown hostname.\n",0);
}

/*** Disconnect a link ***/
void disconnect_netlink(user)
UR_OBJECT user;
{
NL_OBJECT nl;
RM_OBJECT room;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
nl=room->netlink;
if (!nl) {
	write_user(user,"That room is not linked to a service.\n");
	return;
	}
if (nl->type==UNCONNECTED) {
	write_user(user,"That room's netlink is not connected.\n");
	return;
	}
if (nl->stage==2) {
	snprintf(text,sizeof(text),"~OLSYSTEM:~RS Disconnecting from service %s in room %s.\n",nl->service,room->name);
	write_room(NULL,text);
	snprintf(text,sizeof(text),"NETLINK: Link to %s in room %s disconnected by %s.\n",nl->service,room->name,user->name);
	write_syslog(text,1);
	}
else {
	snprintf(text,sizeof(text),"NETLINK: Link to %s disconnected by %s.\n",nl->service,user->name);
	write_syslog(text,1);
	}
shutdown_netlink(nl);
write_user(user,"Disconnected.\n");
}

/*** Add a user ***/
void add_user(user)
UR_OBJECT user;
{
write_user(user,"Type exit at any point to abort.\nEnter user's name: ");
user->misc_op=48;
user->listen_store=user->listen;
user->listen=0;
}

/*** End adding a user ***/
void end_adduser(user)
UR_OBJECT user;
{
user->misc_op=0;
echo_on(user,0);
user->listen=user->listen_store;
user->listen_store=1;
user->astage=0;
user->addpass[0]='\0';
user->addpass2[0]='\0';
user->addname[0]='\0';
}

/*** Change user's password ***/
void change_pass(user)
UR_OBJECT user;
{
write_user(user,"Enter old password: ");
echo_off(user);
user->misc_op=16;
user->listen=user->listen_store;
user->listen=0;
user->pstage=1;
}

/*** Done changing password, write it to syslog and stuff ***/
void pass_changed(user)
UR_OBJECT user;
{
sntrncpy(user->pass,user->newpass,sizeof(user->pass));
user->fpc=0;
write_user(user,"\nPassword changed.\n");
snprintf(text,sizeof(text),"%s changed %s password.\n",user->name,gen1[user->gen]);
write_syslog(text,1);
}

/*** Test if password is too short or too long ***/
int test_pass(user,str)
UR_OBJECT user;
char *str;
{
char name[USER_NAME_LEN+1],*s;
int i=0,j=0;

if (strlen(str)<PASS_MIN_LEN) {
	write_user(user,"\nNew password too short.\n");
	return 0;
	}
if (strlen(str)>PASS_MAX_LEN) {
	write_user(user,"\nNew password too long.\n");
	return 0;
	}
for(i=0;i<strlen(str);++i) { if (isupper(str[i])) ++j; }
if (!j) {
	write_user(user,"\nPassword must have at least one upper case character.\n");
	return 0;
	}
if (!(s=(char *)malloc(strlen(str)+1))) return 0;
strcpy(s,str);
strtolower(s);
sntrncpy(name,user->name,sizeof(name));
strtolower(name);
if (instr(s,name)) { write_user(user,"\nDon't enter your name as your password dork.\n"); free(s); return 0; }
free(s);
return 1;
}

/*** Change other user's password ***/
void change_other_pass(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your password!\n",user->name);
		write_user(user2,text);
		}
	sntrncpy(user->passwd,word[1],sizeof(user->passwd));
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in change_other_pass().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot change a user's password of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to change your password!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user->passwd,user2->name,sizeof(user->passwd));
	destruct_user(user2,0);
	}
write_user(user,"Enter new password: ");
echo_off(user);
user->misc_op=17;
user->listen_store=user->listen;
user->listen=0;
user->pstage=1;
}

/*** Done changing password, write it to syslog and stuff ***/
void other_pass_changed(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if ((user2=get_user2(user,user->passwd))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to change your password!\n",user->name);
		write_user(user2,text);
		}
	sntrncpy(user2->pass,user->newpass,sizeof(user2->pass));
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in change_other_pass().\n",0);
		return;
		}
	sntrncpy(user2->name,user->passwd,sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot change a user's password of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to change your password!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	sntrncpy(user2->pass,user->newpass,sizeof(user2->pass));
	save_user_details(user2,0);
	destruct_user(user2,0);
	destructed=0;
	}
snprintf(text,sizeof(text),"\n%s's password changed.\n",user->passwd);
write_user(user,text);
snprintf(text,sizeof(text),"%s changed %s's password.\n",user->name,user->passwd);
write_syslog(text,1);
}

/*** Kill a user ***/
void kill_user(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (word_count<2) {
	snprintf(text,sizeof(text),"%s who?\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to commit suicide this way is the sixth sign of madness.\n");
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"Hmm .. inadvisable.\n");
	snprintf(text,sizeof(text),"%s tried to kill you!\n",user->name);
	write_user(user2,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
write_user(user,"You chant an evil incantation...\n");
if (!user->quiet) {
	snprintf(text,sizeof(text),"%s chants an evil incantation...\n",name);
	write_room_except(user->room,text,user,NULL,0,NULL);
	write_user(user2,"A shrieking furie rises up out of the ground, and devours you!!!\n");
	snprintf(text,sizeof(text),"A shrieking furie rises up out of the ground, devours %s and vanishes!!!\n",name1);
	write_room_except(user2->room,text,user2,NULL,0,NULL);
	snprintf(text,sizeof(text),"%s KILLED %s.\n",user->name,user2->name);
	write_syslog(text,1);
	}
disconnect_user(user2);
if (!user->quiet) write_room(NULL,"You hear insane laughter from the beyond...\n");
}

/*** Kill all users ***/
void kill_allusers(user)
UR_OBJECT user;
{
char *name;
int cnt=0;
UR_OBJECT user2;

if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You chant an evil incantation...\n");
snprintf(text,sizeof(text),"%s chants an evil incantation...\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->login || user2->type==CLONE_TYPE || user2->level>=user->level) continue;
	if (++cnt==1) {
		write_user(user,"You chant an evil incantation...\n");
		snprintf(text,sizeof(text),"%s chants an evil incantation...\n",name);
		write_room_except(user->room,text,user,NULL,0,NULL);
		}
	write_user(user2,"A shrieking furie rises up out of the ground, and devours you!!!\n");
	snprintf(text,sizeof(text),"A shrieking furie rises up out of the ground, devours %s and vanishes!!!\n",user2->name);
	write_room_except(user2->room,text,user2,NULL,0,NULL);
	snprintf(text,sizeof(text),"%s KILLED %s.\n",user->name,user2->name);
	write_syslog(text,1);
	disconnect_user(user2);
	}
if (!cnt) write_user(user,"No users to kill.\n");
else write_room(NULL,"You hear insane laughter from the beyond...\n");
}

/*** Promote a user ***/
void promote(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Promote who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"Promote yourself? This incident will be reported.\n");
		snprintf(text,sizeof(text),"%s tried to promote %sself.\n",user->name,gen2[user->gen]);
		write_syslog(text,1);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot promote a user of a level equal or higher than your own.\n");
		snprintf(text,sizeof(text),"%s tried to promote you!\n",user->name);
		write_user(user2,text);
		snprintf(text,sizeof(text),"%s tried to promote %s.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (user2->level>=COMMANDER) {
		write_user(user,"Umm, no.\n");
		snprintf(text,sizeof(text),"%s tried to promote %s to GENERAL.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (++user2->level>=user->level) {
		write_user(user,"You cannot promote a user to a level equal or higher than your own.\n");
		--user2->level;
		snprintf(text,sizeof(text),"%s tried to promote %s.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (nopromos(user2->site) && !check_specialsite(user2->site)) {
		write_user(user,"Umm, contact a general.\n");
		--user2->level;
		snprintf(text,sizeof(text),"%s tried to promote %s but failed.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	snprintf(text,sizeof(text),"You promote %s to %s.\n",user2->name,level_name[user2->level]);
	write_user(user,text);
	if (!sys_mail) {
		snprintf(text,sizeof(text),"You have been promoted to %s!\n",level_name[user2->level]);
		write_user(user2,text);
		}
	snprintf(text,sizeof(text),"%s promoted %s to %s.\n",user->name,user2->name,level_name[user2->level]);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in promote().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"You cannot promote a user of a level equal or higher than your own.\n");
	snprintf(text,sizeof(text),"%s tried to promote %s.\n",user->name,user2->name);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"%s tried to promote you!\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=COMMANDER) {
	write_user(user,"Umm, no.\n");
	snprintf(text,sizeof(text),"%s tried to promote %s to GENERAL.\n",user->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
if (++user2->level>=user->level) {
	write_user(user,"You cannot promote a user to a level equal or higher than your own.\n");
	snprintf(text,sizeof(text),"%s tried to promote %s.\n",user->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
if (nopromos(user2->site) && !check_specialsite(user2->site)) {
	write_user(user,"Umm, contact a general.\n");
	snprintf(text,sizeof(text),"%s tried to promote %s but failed.\n",user->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
save_user_details(user2,0);
snprintf(text,sizeof(text),"You promote %s to %s.\n",user2->name,level_name[user2->level]);
write_user(user,text);
snprintf(text,sizeof(text),"%s promoted %s to %s.\n",user->name,user2->name,level_name[user2->level]);
write_syslog(text,1);
snprintf(text,sizeof(text),"You have been promoted to %s.\n",level_name[user2->level]);
send_mail(user,user2->name,text,1);
destruct_user(user2,0);
}

/*** Demote a user ***/
void demote(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Demote who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"If you want yourself demoted, send your resignation to a general.\n");
		snprintf(text,sizeof(text),"%s tried to demote %sself.\n",user->name,gen2[user->gen]);
		write_syslog(text,1);
		return;
		}
	if (user2->level==AWOL) {
		write_user(user,"You cannot demote a user of level AWOL.\n");
		snprintf(text,sizeof(text),"%s tried to demote %s to AWOL.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to demote you!\n",user->name);
		write_user(user2,text);
		snprintf(text,sizeof(text),"%s tried to demote %s.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	--user2->level;
	snprintf(text,sizeof(text),"You demote %s to %s.\n",user2->name,level_name[user2->level]);
	write_user(user,text);
	if (!sys_mail) {
		snprintf(text,sizeof(text),"You have been demoted to %s!\n",level_name[user2->level]);
		write_user(user2,text);
		}
	snprintf(text,sizeof(text),"%s demoted %s to %s.\n",user->name,user2->name,level_name[user2->level]);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in demote().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level==AWOL) {
	write_user(user,"You cannot demote a user of level AWOL.\n");
	snprintf(text,sizeof(text),"%s tried to demote %s to AWOL.\n",user->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"Hmm .. inadvisable.\n");
	snprintf(text,sizeof(text),"%s tried to demote %s.\n",user->name,user2->name);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"%s tried to demote you!\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
--user2->level;
user2->socket=5;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
save_user_details(user2,0);
snprintf(text,sizeof(text),"You demote %s to %s.\n",user2->name,level_name[user2->level]);
write_user(user,text);
snprintf(text,sizeof(text),"%s demoted %s to %s.\n",user->name,user2->name,level_name[user2->level]);
write_syslog(text,1);
snprintf(text,sizeof(text),"You have been demoted to %s.\n",level_name[user2->level]);
send_mail(user,user2->name,text,1);
destruct_user(user2,0);
}

/*** Promote a private to corporal ***/
void corporal(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2->level!=PRIVATE) {
		write_user(user,"This command is only for use on privates.\n");
		snprintf(text,sizeof(text),"%s tried to promote %s to corporal but %s isn't a private.\n",user->name,user2->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (user2->total_login<1800) {
		write_user(user,"Privates must have at least 30 mins before they can be promoted.\n");
		snprintf(text,sizeof(text),"%s tried to promote %s to corporal but %s lacks cumul. time.\n",user->name,user2->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (nopromos(user2->site) && !check_specialsite(user2->site)) {
		write_user(user,"Umm, contact a general.\n");
		snprintf(text,sizeof(text),"%s tried to promote %s but failed.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	++user2->level;
	snprintf(text,sizeof(text),"You promote %s to %s.\n",user2->name,level_name[user2->level]);
	write_user(user,text);
	snprintf(text,sizeof(text),"You have been promoted to %s!\n",level_name[user2->level]);
	write_user(user2,text);
	snprintf(text,sizeof(text),"%s promoted %s to %s.\n",user->name,user2->name,level_name[user2->level]);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in corporal().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level!=PRIVATE) {
	write_user(user,"This command is only for use on privates.\n");
	snprintf(text,sizeof(text),"%s tried to promote %s to corporal but %s isn't a private.\n",user->name,user2->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
if (user2->total_login<1800) {
	write_user(user,"Privates must have at least 30 mins before they can be promoted.\n");
	snprintf(text,sizeof(text),"%s tried to promote %s to corporal but %s lacks cumul. time.\n",user->name,user2->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
if (nopromos(user2->site) && !check_specialsite(user2->site)) {
	write_user(user,"Umm, contact a general.\n");
	snprintf(text,sizeof(text),"%s tried to promote %s but failed.\n",user->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
++user2->level;
user2->socket=5;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
save_user_details(user2,0);
snprintf(text,sizeof(text),"You promote %s to %s.\n",user2->name,level_name[user2->level]);
write_user(user,text);
snprintf(text,sizeof(text),"%s promoted %s to %s.\n",user->name,user2->name,level_name[user2->level]);
write_syslog(text,1);
snprintf(text,sizeof(text),"You have been promoted to %s.\n",level_name[user2->level]);
send_mail(user,user2->name,text,1);
destruct_user(user2,0);
}

/*** Lock a user's account ***/
void lock_user(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"Trying to lock yourself out is the thirty-second sign of madness.\n");
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot lock a user's account of a level equal or higher than your own.\n");
		snprintf(text,sizeof(text),"%s tried to lock your account!\n",user->name);
		write_user(user2,text);
		snprintf(text,sizeof(text),"%s tried to lock %s's account.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (user2->locked) {
		snprintf(text,sizeof(text),"%s's account is already locked.\n",user2->name);
		write_user(user,text);
		return;
		}
	user2->locked=1;
	snprintf(text,sizeof(text),"You lock %s's account.\n",user2->name);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s locked %s's account.\n",user->name,user2->name);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in lock_user().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"You cannot lock a user's account of a level equal or higher than your own.\n");
	snprintf(text,sizeof(text),"%s tried to lock %s's account.\n",user->name,user2->name);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"%s tried to lock your account!\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
if (user2->locked) {
	snprintf(text,sizeof(text),"%s's account is already locked.\n",user2->name);
	write_user(user,text);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
user2->locked=1;
save_user_details(user2,0);
snprintf(text,sizeof(text),"You lock %s's account.\n",user2->name);
write_user(user,text);
snprintf(text,sizeof(text),"%s locked %s's account.\n",user->name,user2->name);
write_syslog(text,1);
destruct_user(user2,0);
}

/*** Unlock a user's account ***/
void unlock_user(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2->level>=user->level) {
		write_user(user,"You cannot unlock a user's account of a level equal or higher than your own.\n");
		snprintf(text,sizeof(text),"%s tried to unlock your account!\n",user->name);
		write_user(user2,text);
		snprintf(text,sizeof(text),"%s tried to unlock %s's account.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (!user2->locked) {
		snprintf(text,sizeof(text),"%s's account isn't locked.\n",user2->name);
		write_user(user,text);
		return;
		}
	user2->locked=0;
	snprintf(text,sizeof(text),"You unlock %s's account.\n",user2->name);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s unlocked %s's account.\n",user->name,user2->name);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in unlock_user().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"You cannot unlock a user's account of a level equal or higher than your own.\n");
	snprintf(text,sizeof(text),"%s tried to unlock %s's account.\n",user->name,user2->name);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"%s tried to unlock your account!\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
if (!user2->locked) {
	snprintf(text,sizeof(text),"%s's account isn't locked.\n",user2->name);
	write_user(user,text);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
user2->locked=0;
save_user_details(user2,0);
snprintf(text,sizeof(text),"You unlock %s's account.\n",user2->name);
write_user(user,text);
snprintf(text,sizeof(text),"%s unlocked %s's account.\n",user->name,user2->name);
write_syslog(text,1);
destruct_user(user2,0);
}

/*** Boot a user for n minutes ***/
void bootem(user)
UR_OBJECT user;
{
char *name;
int days,hours,mins;
UR_OBJECT user2;

if (word_count<3 || !isnumber(word[2])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user> <number of minutes>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user> <number of minutes>\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"Trying to commit suicide this way is the thirty-seventh sign of madness.\n");
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. very inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to boot you!\n",user->name);
		write_user(user2,text);
		return;
		}
	if (user->vis) name=user->morphed; else name=invisname;
	write_user(user,"You chant an evil incantation...\n");
	snprintf(text,sizeof(text),"%s chants an evil incantation...\n",name);
	write_room_except(user->room,text,user,NULL,0,NULL);
	if (!sys_mail) write_user(user2,"You have been booted off the system!\n");
	days=atoi(word[2])/1440;
	hours=(atoi(word[2])-(days*1440))/60;
	mins=(atoi(word[2])-(hours*60)-(days*1440));
	snprintf(text,sizeof(text),"%s booted %s off for ",user->name,user2->name);
	write_syslog(text,1);
	if (days==1) snprintf(text,sizeof(text),"%d day, ",days);
	else snprintf(text,sizeof(text),"%d days, ",days);
	write_syslog(text,0);
	if (hours==1) snprintf(text,sizeof(text),"%d hour, ",hours);
	else snprintf(text,sizeof(text),"%d hours, ",hours);
	write_syslog(text,0);
	if (mins==1) snprintf(text,sizeof(text),"%d minute!\n",mins);
	else snprintf(text,sizeof(text),"%d minutes!\n",mins);
	write_syslog(text,0);
	user2->booted=1;
	user2->boottime=(int)time(0)+atoi(word[2])*60;
	disconnect_user(user2);
	write_room(NULL,"You hear insane laughter from the beyond...\n");
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in bootem().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"Hmm .. very inadvisable.\n");
	snprintf(text,sizeof(text),"%s tried to boot you!\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
user2->booted=1;
user2->boottime=(int)time(0)+atoi(word[2])*60;
save_user_details(user2,0);
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You chant an evil incantation...\n");
snprintf(text,sizeof(text),"%s chants an evil incantation...\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
if (!sys_mail) {
	snprintf(text,sizeof(text),"You have been booted off the system!\n");
	send_mail(user,user2->name,text,0);
	}
days=atoi(word[2])/1440;
hours=(atoi(word[2])-(days*1440))/60;
mins=(atoi(word[2])-(hours*60)-(days*1440));
snprintf(text,sizeof(text),"%s booted %s off for ",user->name,user2->name);
write_syslog(text,1);
if (days==1) snprintf(text,sizeof(text),"%d day, ",days);
else snprintf(text,sizeof(text),"%d days, ",days);
write_syslog(text,0);
if (hours==1) snprintf(text,sizeof(text),"%d hour, ",hours);
else snprintf(text,sizeof(text),"%d hours, ",hours);
write_syslog(text,0);
if (mins==1) snprintf(text,sizeof(text),"%d minute!\n",mins);
else snprintf(text,sizeof(text),"%d minutes!\n",mins);
write_syslog(text,0);
destruct_user(user2,0);
write_room(NULL,"You hear insane laughter from the beyond...\n");
}

/*** Destruct a user - say, after they read their mail ***/
void selfdestructem(user)
UR_OBJECT user;
{
char *name;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"Trying to commit suicide this way is the thirty-seventh sign of madness.\n");
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. very inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to make you self-destruct!\n",user->name);
		write_user(user2,text);
		return;
		}
	if (user->vis) name=user->morphed; else name=invisname;
	write_user(user,"You chant an evil incantation...\n");
	snprintf(text,sizeof(text),"%s chants an evil incantation...\n",name);
	write_room_except(user->room,text,user,NULL,0,NULL);
	if (!sys_mail) write_user(user2,"You will self-destruct!\n");
	snprintf(text,sizeof(text),"%s forced %s to self-destruct!\n",user->name,user2->name);
	write_syslog(text,1);
	user2->selfdestructing=1;
	selfdestructime(user2);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in selfdestructem().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"Hmm .. very inadvisable.\n");
	snprintf(text,sizeof(text),"%s tried to make you self-destruct!\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
if (user2->selfdestructing) {
	snprintf(text,sizeof(text),"%s is already self-destructing.\n",user2->name);
	write_user(user,text);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
user2->selfdestructing=1;
save_user_details(user2,0);
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You chant an evil incantation...\n");
snprintf(text,sizeof(text),"%s chants an evil incantation...\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
if (!sys_mail) {
	snprintf(text,sizeof(text),"You will self-destruct!\n");
	send_mail(user,user2->name,text,0);
	}
snprintf(text,sizeof(text),"%s forced %s to self-destruct!\n",user->name,user2->name);
write_syslog(text,1);
destruct_user(user2,0);
write_room(NULL,"You hear insane laughter from the beyond...\n");
}

/*** Force a user to change their password on next login ***/
void fpc(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"Trying to force yourself to change your password is the 38th sign of madness.\n");
		return;
		}
	get_gender(user2);
	if (user2->level>=user->level) {
		write_user(user,"You cannot force anyone of a level equal or higher than your own\nto change their password.\n");
		snprintf(text,sizeof(text),"%s tried to get you to change your password!\n",user->name);
		write_user(user2,text);
		snprintf(text,sizeof(text),"%s tried to get %s to change %s password.\n",user->name,user2->name,gen1[user2->gen]);
		write_syslog(text,1);
		return;
		}
	if (user2->fpc) {
		snprintf(text,sizeof(text),"Force password change already enforced for %s.\n",user2->name);
		write_user(user,text);
		return;
		}
	user2->fpc=1;
	snprintf(text,sizeof(text),"You force %s to change %s password.\n",user2->name,gen1[user2->gen]);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s forced %s to change %s password.\n",user->name,user2->name,gen1[user2->gen]);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in fpc().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
get_gender(user2);
if (user2->level>=user->level) {
	write_user(user,"You cannot force anyone of a level equal or higher than your own\nto change their password.\n");
	snprintf(text,sizeof(text),"%s tried to get %s to change %s password.\n",user->name,user2->name,gen1[user2->gen]);
	write_syslog(text,1);
	snprintf(text,sizeof(text),"%s tried to get you to change your password!\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
if (user2->fpc) {
	snprintf(text,sizeof(text),"Force password change already enforced for %s.\n",user2->name);
	write_user(user,text);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
user2->fpc=1;
save_user_details(user2,0);
snprintf(text,sizeof(text),"You force %s to change %s password.\n",user2->name,gen1[user2->gen]);
write_user(user,text);
snprintf(text,sizeof(text),"%s forced %s to change %s password.\n",user->name,user2->name,gen1[user2->gen]);
write_syslog(text,1);
destruct_user(user2,0);
}

/*** Paste some stuff ***/
void paste(user,done_editing)
UR_OBJECT user;
int done_editing;
{
char comstr[ARR_SIZE],line[82],*str;
int i=0;

if (!done_editing) {
	write_user(user,"\n~BB~OL~FY*** Writing stuff to paste ***\n\n");
	user->misc_op=46;
	editor(user,NULL);
	return;
	}
str=user->malloc_start;
if (ban_swearing && contains_swearing(str)) {
	swore(user);
	return;
	}
while(*str) {
	while(*str && *str!='\n') { line[i]=*str++; ++i; }
	if (*str) ++str;
	line[i]='\n'; line[i+1]='\0';
	sntrncpy(comstr,line,ARR_SIZE);
	terminate(comstr);
	exec_str(user,comstr,0);
	}
write_user(user,"Text pasted.\n");
}

/*** List banned domains, new domains, swear words, or users ***/
void listban(user)
UR_OBJECT user;
{
char *usage="Usage: lban allow/domains/newdomains/swearing/users\n";
FILE *fp;

if (word_count<2) {
	write_user(user,usage);
	scom_main(user,NULL,3,0);
	return;
	}
if (!strncasecmp(word[1],"allow",strlen(word[1]))) {
	write_user(user,"\n~BB~OL~FY*** Allowed domains ***\n");
	if (!(fp=fopen(ALLOWDOMAINS,"r"))) { write_user(user,"There are no allowed domains.\n\n"); return; }
	fclose(fp);
	more(user,ALLOWDOMAINS,0);
	}
else if (!strncasecmp(word[1],"domains",strlen(word[1]))) {
	write_user(user,"\n~BB~OL~FY*** Banned domains ***\n");
	if (!(fp=fopen(DOMAINBANS,"r"))) { write_user(user,"There are no banned domains.\n\n"); return; }
	fclose(fp);
	more(user,DOMAINBANS,0);
	}
else if (!strncasecmp(word[1],"newdomains",strlen(word[1]))) {
	write_user(user,"\n~BB~OL~FY*** Banned domains for new users ***\n");
	if (!(fp=fopen(NEWDOMAINBANS,"r"))) { write_user(user,"There are no banned domains for new users.\n\n"); return; }
	fclose(fp);
	more(user,NEWDOMAINBANS,0);
	}
else if (!strncasecmp(word[1],"swearing",strlen(word[1]))) {
	write_user(user,"\n~BB~OL~FY*** Banned words ***\n");
	if (!(fp=fopen(SWBANS,"r"))) { write_user(user,"There are no banned words.\n\n"); return; }
	fclose(fp);
	more(user,SWBANS,0);
	}
else if (!strncasecmp(word[1],"users",strlen(word[1]))) {
	write_user(user,"\n~BB~OL~FY*** Banned users ***\n");
	if (!(fp=fopen(USERBANS,"r"))) { write_user(user,"There are no banned users.\n\n"); return; }
	fclose(fp);
	more(user,USERBANS,0);
	}
else write_user(user,usage);
}

/*** Ban a domain, new domain, swear word, or user ***/
void ban(user)
UR_OBJECT user;
{
char *usage="Usage: ban allow/domain/newdomain/swearing/user\n<domain to allow/domain/new domain/word/user name>\n";

if (word_count<3) {
	write_user(user,usage);
	scom_main(user,NULL,3,0);
	return;
	}
if (!strncasecmp(word[1],"allow",strlen(word[1]))) allow_domain(user);
else if (!strncasecmp(word[1],"domain",strlen(word[1]))) ban_domain(user);
else if (!strncasecmp(word[1],"newdomain",strlen(word[1]))) ban_newdomain(user);
else if (!strncasecmp(word[1],"swearing",strlen(word[1]))) ban_swword(user);
else if (!strncasecmp(word[1],"user",strlen(word[1]))) ban_user(user);
else write_user(user,usage);
}

/*** Ban a domain ***/
void ban_domain(user)
UR_OBJECT user;
{
char domain[SITE_NAME_LEN+1];
FILE *fp;

strtolower(word[2]);
if ((fp=fopen(DOMAINBANS,"r"))) {
	fscanf(fp,"%s",domain);
	while(!feof(fp)) {
		if (!strcmp(domain,word[2])) {
			write_user(user,"That domain is already banned.\n");
			fclose(fp);
			return;
			}
		fscanf(fp,"%s",domain);
		}
	fclose(fp);
	}
if (!(fp=fopen(DOMAINBANS,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in ban_domain().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[2]);
fclose(fp);
write_user(user,"Domain banned.\n");
snprintf(text,sizeof(text),"%s BANNED domain %s.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Ban a user ***/
void ban_user(user)
UR_OBJECT user;
{
char name[USER_NAME_LEN+1];
FILE *fp;
UR_OBJECT user2;

word[2][0]=toupper(word[2][0]);
if (!strcmp(user->name,word[2])) {
	write_user(user,"Trying to ban yourself is the seventh sign of madness.\n");
	return;
	}
if ((fp=fopen(USERBANS,"r"))) {
	fscanf(fp,"%s",name);
	while(!feof(fp)) {
		if (!strcmp(name,word[2])) {
			write_user(user,"That user is already banned.\n");
			fclose(fp);
			return;
			}
		fscanf(fp,"%s",name);
		}
	fclose(fp);
	}
if ((user2=get_user(word[2],0))) {
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to ban you!\n",user->name);
		write_user(user2,text);
		return;
		}
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in ban_user().\n",0);
		return;
		}
	sntrncpy(user2->name,word[2],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to ban you!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	destruct_user(user2,0);
	}
if (!(fp=fopen(USERBANS,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in ban_user().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[2]);
fclose(fp);
write_user(user,"User banned.\n");
snprintf(text,sizeof(text),"%s BANNED user %s.\n",user->name,word[2]);
write_syslog(text,1);
if ((user2=get_user(word[2],0))) disconnect_user(user2);
}

/*** Ban a domain for new users ***/
void ban_newdomain(user)
UR_OBJECT user;
{
char domain[SITE_NAME_LEN+1];
FILE *fp;

strtolower(word[2]);
if ((fp=fopen(NEWDOMAINBANS,"r"))) {
	fscanf(fp,"%s",domain);
	while(!feof(fp)) {
		if (!strcmp(domain,word[2])) {
			write_user(user,"That domain is already banned.\n");
			fclose(fp);
			return;
			}
		fscanf(fp,"%s",domain);
		}
	fclose(fp);
	}
if (!(fp=fopen(NEWDOMAINBANS,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in ban_newdomain().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[2]);
fclose(fp);
write_user(user,"Domain banned for new users.\n");
snprintf(text,sizeof(text),"%s BANNED domain %s for new users.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Ban a word from being used ***/
void ban_swword(user)
UR_OBJECT user;
{
char swword[80];
FILE *fp;

strtolower(word[2]);
if ((fp=fopen(SWBANS,"r"))) {
	fscanf(fp,"%s",swword);
	while(!feof(fp)) {
		if (!strcmp(swword,word[2])) {
			write_user(user,"That word is already banned.\n");
			fclose(fp);
			return;
			}
		fscanf(fp,"%s",swword);
		}
	fclose(fp);
	}
if (!(fp=fopen(SWBANS,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in ban_swword().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[2]);
fclose(fp);
write_user(user,"Word banned.\n");
snprintf(text,sizeof(text),"%s BANNED word %s.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Allow a domain ***/
void allow_domain(user)
UR_OBJECT user;
{
char domain[SITE_NAME_LEN+1];
FILE *fp;

strtolower(word[2]);
if ((fp=fopen(ALLOWDOMAINS,"r"))) {
	fscanf(fp,"%s",domain);
	while(!feof(fp)) {
		if (!strcmp(domain,word[2])) {
			write_user(user,"That domain is already allowed.\n");
			fclose(fp);
			return;
			}
		fscanf(fp,"%s",domain);
		}
	fclose(fp);
	}
if (!(fp=fopen(ALLOWDOMAINS,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in allow_domain().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[2]);
fclose(fp);
write_user(user,"Domain allowed.\n");
snprintf(text,sizeof(text),"%s ALLOWED domain %s.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Unban a domain, new domain, swear word, or user ***/
void unban(user)
UR_OBJECT user;
{
char *usage="Usage: unban allow/domain/newdomain/swearing/user\n<domain to unallow/domain/new domain/word/user name>\n";

if (word_count<3) {
	write_user(user,usage);
	scom_main(user,NULL,3,0);
	return;
	}
if (!strncasecmp(word[1],"allow",strlen(word[1]))) unallow_domain(user);
else if (!strncasecmp(word[1],"domain",strlen(word[1]))) unban_domain(user);
else if (!strncasecmp(word[1],"newdomain",strlen(word[1]))) unban_newdomain(user);
else if (!strncasecmp(word[1],"swearing",strlen(word[1]))) unban_swword(user);
else if (!strncasecmp(word[1],"user",strlen(word[1]))) unban_user(user);
else write_user(user,usage);
}

/*** Unban a domain ***/
void unban_domain(user)
UR_OBJECT user;
{
char domain[SITE_NAME_LEN+1];
int cnt=0,found=0;
FILE *infp,*outfp;

if (!(infp=fopen(DOMAINBANS,"r"))) {
	write_user(user,"That domain is not currently banned.\n");
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in unban_domain().\n",0);
	fclose(infp);
	return;
	}
strtolower(word[2]);
fscanf(infp,"%s",domain);
while(!feof(infp)) {
	if (!strcmp(word[2],domain)) {
		fscanf(infp,"%s",domain); ++found; continue;
		}
	fprintf(outfp,"%s\n",domain);
	fscanf(infp,"%s",domain);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!found) {
	write_user(user,"That domain is not currently banned.\n");
	unlink(TEMPFILE);
	return;
	}
if (!cnt) { unlink(DOMAINBANS);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,DOMAINBANS)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in unban_domain().\n",0);
	return;
	}
write_user(user,"Domain ban removed.\n");
snprintf(text,sizeof(text),"%s UNBANNED domain %s.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Unban a user ***/
void unban_user(user)
UR_OBJECT user;
{
char name[USER_NAME_LEN+1];
int cnt=0,found=0;
FILE *infp,*outfp;

if (!(infp=fopen(USERBANS,"r"))) {
	write_user(user,"That user is not currently banned.\n");
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in unban_user().\n",0);
	fclose(infp);
	return;
	}
word[2][0]=toupper(word[2][0]);
fscanf(infp,"%s",name);
while(!feof(infp)) {
	if (!strcmp(word[2],name)) {
		fscanf(infp,"%s",name); ++found; continue;
		}
	fprintf(outfp,"%s\n",name);
	fscanf(infp,"%s",name);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!found) {
	write_user(user,"That user is not currently banned.\n");
	unlink(TEMPFILE);
	return;
	}
if (!cnt) { unlink(USERBANS);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,USERBANS)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in unban_user().\n",0);
	return;
	}
write_user(user,"User ban removed.\n");
snprintf(text,sizeof(text),"%s UNBANNED user %s.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Unban a domain ban for new users ***/
void unban_newdomain(user)
UR_OBJECT user;
{
char domain[SITE_NAME_LEN+1];
int cnt=0,found=0;
FILE *infp,*outfp;

if (!(infp=fopen(NEWDOMAINBANS,"r"))) {
	write_user(user,"That domain is not currently banned.\n");
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in unban_newdomain().\n",0);
	fclose(infp);
	return;
	}
strtolower(word[2]);
fscanf(infp,"%s",domain);
while(!feof(infp)) {
	if (!strcmp(word[2],domain)) {
		fscanf(infp,"%s",domain); ++found; continue;
		}
	fprintf(outfp,"%s\n",domain);
	fscanf(infp,"%s",domain);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!found) {
	write_user(user,"That domain is not currently banned.\n");
	unlink(TEMPFILE);
	return;
	}
if (!cnt) { unlink(NEWDOMAINBANS);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,NEWDOMAINBANS)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in unban_newdomainban().\n",0);
	return;
	}
write_user(user,"Domain ban removed for new users.\n");
snprintf(text,sizeof(text),"%s UNBANNED domain %s for new users.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Unban a word from being used ***/
void unban_swword(user)
UR_OBJECT user;
{
char swword[80];
int cnt=0,found=0;
FILE *infp,*outfp;

if (!(infp=fopen(SWBANS,"r"))) {
	write_user(user,"That word is not currently banned.\n");
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in unban_swword().\n",0);
	fclose(infp);
	return;
	}
strtolower(word[2]);
fscanf(infp,"%s",swword);
while(!feof(infp)) {
	if (!strcmp(word[2],swword)) {
		fscanf(infp,"%s",swword); ++found; continue;
		}
	fprintf(outfp,"%s\n",swword);
	fscanf(infp,"%s",swword);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!found) {
	write_user(user,"That word is not currently banned.\n");
	unlink(TEMPFILE);
	return;
	}
if (!cnt) { unlink(SWBANS);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,SWBANS)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in unban_swword().\n",0);
	return;
	}
write_user(user,"Word ban removed.\n");
snprintf(text,sizeof(text),"%s UNBANNED word %s.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Unallow a domain ***/
void unallow_domain(user)
UR_OBJECT user;
{
char domain[SITE_NAME_LEN+1];
int cnt=0,found=0;
FILE *infp,*outfp;

if (!(infp=fopen(ALLOWDOMAINS,"r"))) {
	write_user(user,"That domain is not currently allowed.\n");
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in unallow_domain().\n",0);
	fclose(infp);
	return;
	}
strtolower(word[2]);
fscanf(infp,"%s",domain);
while(!feof(infp)) {
	if (!strcmp(word[2],domain)) {
		fscanf(infp,"%s",domain); ++found; continue;
		}
	fprintf(outfp,"%s\n",domain);
	fscanf(infp,"%s",domain);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!found) {
	write_user(user,"That domain is not currently allowed.\n");
	unlink(TEMPFILE);
	return;
	}
if (!cnt) { unlink(ALLOWDOMAINS);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,ALLOWDOMAINS)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in unallow_domain().\n",0);
	return;
	}
write_user(user,"Domain allow removed.\n");
snprintf(text,sizeof(text),"%s UNALLOWED domain %s.\n",user->name,word[2]);
write_syslog(text,1);
}

/*** Set user visible or invisible ***/
void visibility(user,vis)
UR_OBJECT user;
int vis;
{
UR_OBJECT user2;

if (word_count<2) {
	if (vis) {
		if (user->vis) {
			write_user(user,"You are already visible.\n");
			return;
			}
		write_user(user,"You recite a melodic incantation and reappear.\n");
		/* snprintf(text,sizeof(text),"You hear a melodic incantation chanted and %s materializes!\n",user->name);
		write_room_except(user->room,text,user,NULL,0,NULL); */
		user->vis=1;
		sntrncpy(user->morphed,user->invisname,sizeof(user->morphed));
		return;
		}
	if (!user->vis) {
		write_user(user,"You are already invisible.\n");
		return;
		}
	write_user(user,"You recite a melodic incantation and fade out.\n");
	/* snprintf(text,sizeof(text),"%s recites a melodic incantation and disappears!\n",user->name);
	write_room_except(user->room,text,user,NULL,0,NULL); */
	user->vis=0;
	sntrncpy(user->invisname,user->morphed,sizeof(user->invisname));
	sntrncpy(user->morphed,"Someone",sizeof(user->morphed));
	}
else {
	if (!(user2=get_user2(user,word[1]))) {
		write_user(user,notloggedon);
		return;
		}
	if (check_multiple(user,word[1])>1) {
		multiple(user,word[1]);
		return;
		}
	if (user2==user) {
		snprintf(text,sizeof(text),"Uh huh.\n");
		write_user(user,text);
		return;
		}
	if (user2->level>=user->level) {
		if (vis) write_user(user,"You cannot make a user of equal or higher level than yourself visible!\n");
		else write_user(user,"You cannot make a user of equal or higher level than yourself invisible!\n");
		if (vis) snprintf(text,sizeof(text),"%s tried to make you visible!\n",user->name);
		else snprintf(text,sizeof(text),"%s tried to make you invisible!\n",user->name);
		write_user(user2,text);
		return;
		}
	if (user2->vis && vis) {
		snprintf(text,sizeof(text),"%s is already visible!\n",user2->name);
		write_user(user,text);
		return;
		}
	if (!user2->vis && !vis) {
		snprintf(text,sizeof(text),"%s is not invisible!\n",user2->name);
		write_user(user,text);
		return;
		}
	user2->vis=vis;
	if (vis) {
		snprintf(text,sizeof(text),"%s is no longer invisible!\n",user2->name);
		write_user(user,text);
		write_user(user2,"You are no longer invisible!\n");
		sntrncpy(user2->morphed,user2->invisname,sizeof(user2->morphed));
		}
	else {
		snprintf(text,sizeof(text),"%s is invisible!\n",user2->name);
		write_user(user,text);
		write_user(user2,"You are invisible!\n");
		sntrncpy(user2->invisname,user2->morphed,sizeof(user2->invisname));
		sntrncpy(user2->morphed,"Someone",sizeof(user2->morphed));
		}
	}
}

/*** Idles a user ***/
void idleuser(user)
UR_OBJECT user;
{
int days,hours,mins,secs,tm,tm2;
UR_OBJECT user2;

if (word_count<3 || !isnumber(word[2])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user> <mins>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user> <mins>\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2->level>=user->level && user2!=user) {
	write_user(user,"You cannot idle a user of equal or higher level than yourself invisible!\n");
	snprintf(text,sizeof(text),"%s tried to idle you!\n",user->name);
	write_user(user2,text);
	return;
	}
if (user2->afk) {
	snprintf(text,sizeof(text),"%s is currently away from the keyboard.\n",user2->name);
	write_user(user,text);
	return;
	}
tm=(int)(time(0)-user2->last_input)/60;
if (tm>=2) {
	snprintf(text,sizeof(text),"%s is already idle.\n",user2->name);
	write_user(user,text);
	return;
	}
tm=atoi(word[2])*60;
tm2=(int)(time(0)-boot_time);
if (tm>tm2) {
	days=tm2/86400;
	hours=(tm2%86400)/3600;
	mins=(tm2%3600)/60;
	secs=tm2%60;
	snprintf(text,sizeof(text),"Sorry, the talker has only been up ");
	write_user(user,text);
	if (days==1) snprintf(text,sizeof(text),"%d day, ",days);
	else snprintf(text,sizeof(text),"%d days, ",days);
	write_user(user,text);
	if (hours==1) snprintf(text,sizeof(text),"%d hour, ",hours);
	else snprintf(text,sizeof(text),"%d hours, ",hours);
	write_user(user,text);
	if (mins==1) snprintf(text,sizeof(text),"%d minute, ",mins);
	else snprintf(text,sizeof(text),"%d minutes, ",mins);
	write_user(user,text);
	if (secs==1) snprintf(text,sizeof(text),"%d second.\n",secs);
	else snprintf(text,sizeof(text),"%d seconds.\n",secs);
	write_user(user,text);
	return;
	}
user2->last_input=time(0)-tm;
user2->last_login=user2->last_login-120;
if (user2==user) snprintf(text,sizeof(text),"You begin to idle.\n");
else snprintf(text,sizeof(text),"%s begins to idle.\n",user2->name);
write_user(user,text);
}

/*** Grant a command ***/
void grant(user)
UR_OBJECT user;
{
char comm[20],filename[FILENAME_LEN],line[82],temp[25];
char *comword=NULL;
int cnt=0,found=0,i=0,yepper=0;
FILE *fp;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user> <command>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user> <command>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	snprintf(filename,sizeof(filename),"%s/%s.C",USERFILES,user2->name);
	if (word_count<3) {
		if (user2==user) {
			write_user(user,"Use granted please.\n");
			return;
			}
		if (user2->level>=user->level) {
			write_user(user,"I don't think so.\n");
			snprintf(text,sizeof(text),"%s tried to see what commands you had granted!\n",user->name);
			write_user(user2,text);
			return;
			}
		snprintf(text,sizeof(text),"~BB~OL~FY*** %s's granted commands ***\n",user2->name);
		write_user(user,text);
		if (!(fp=fopen(filename,"r"))) {
			write_user(user,"No granted commands.\n");
			return;
			}
		text[0]='\0';
		fgets(line,sizeof(line),fp);
		while(!feof(fp)) {
			sscanf(line,"%s\n",comm);
			snprintf(temp,sizeof(temp),"%-18s ",comm);
			strncat(text,temp,sizeof(text));
			if (++cnt==4) {
				strncat(text,"\n",sizeof(text));  write_user(user,text);
				text[0]='\0';  cnt=0;
				}
			fgets(line,sizeof(line),fp);
			}
		if (!cnt) write_user(user,"\n");
		else { strncat(text,"\n\n",sizeof(text));  write_user(user,text); }
		fclose(fp);
		return;
		}
	if (user2==user) {
		write_user(user,"Nope, this incident will be reported.\n");
		snprintf(text,sizeof(text),"%s tried to grant %sself %s.\n",user->name,gen2[user->gen],word[2]);
		write_syslog(text,1);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"I don't think so.\n");
		snprintf(text,sizeof(text),"%s tried to grant you %s!\n",user->name,word[2]);
		write_user(user2,text);
		return;
		}
	comword=word[2];
	while(command[i][0]!='*') {
		if (!strcmp(command[i],comword)) { ++yepper;  break; }
		++i;
		}
	if (!yepper || com_level[i]>user->level) {
		write_user(user,"Unknown command.\n");
		snprintf(text,sizeof(text),"%s tried to grant %s %s.\n",user->name,user2->name,word[2]);
		write_syslog(text,1);
		return;
		}
	if (com_level[i]<=user2->level) {
		write_user(user,"User already has that command.\n");
		snprintf(text,sizeof(text),"%s tried to grant you %s!\n",user->name,word[2]);
		write_user(user2,text);
		snprintf(text,sizeof(text),"%s tried to grant %s %s.\n",user->name,user2->name,word[2]);
		write_syslog(text,1);
		return;
		}
	if ((fp=fopen(filename,"r"))) {
		word[1][0]=toupper(word[1][0]);
		fscanf(fp,"%s",comm);
		while(!feof(fp)) {
			if (!strcmp(word[2],comm)) {
				fscanf(fp,"%s",comm); ++found; continue;
				}
			fscanf(fp,"%s",comm);
			++cnt;
			}
		fclose(fp);
		}
	if (!found) add_command(user);
	else write_user(user,"User already has that command granted.\n");
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in grant().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.C",USERFILES,user2->name);
if (word_count<3) {
	if (user2->level>=user->level) {
		write_user(user,"I don't think so.\n");
		snprintf(text,sizeof(text),"%s tried to see what commands you had granted!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	snprintf(text,sizeof(text),"~BB~OL~FY*** %s's granted commands ***\n",user2->name);
	write_user(user,text);
	if (!(fp=fopen(filename,"r"))) {
		write_user(user,"No granted commands.\n");
		destruct_user(user2,0);
		return;
		}
	text[0]='\0';
	fgets(line,sizeof(line),fp);
	while(!feof(fp)) {
		sscanf(line,"%s\n",comm);
		snprintf(temp,sizeof(temp),"%-18s ",comm);
		strncat(text,temp,sizeof(text));
		if (++cnt==4) {
			strncat(text,"\n",sizeof(text));  write_user(user,text);
			text[0]='\0';  cnt=0;
			}
		fgets(line,sizeof(line),fp);
		}
	if (!cnt) write_user(user,"\n");
	else { strncat(text,"\n\n",sizeof(text));  write_user(user,text); }
	fclose(fp);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"I don't think so.\n");
	snprintf(text,sizeof(text),"%s tried to grant you %s!\n",user->name,word[2]);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
comword=word[2];
while(command[i][0]!='*') {
	if (!strcmp(command[i],comword)) { ++yepper;  break; }
	++i;
	}
if (!yepper || com_level[i]>user->level) {
	write_user(user,"Unknown command.\n");
	snprintf(text,sizeof(text),"%s tried to grant %s %s.\n",user->name,user2->name,word[2]);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
if (com_level[i]<=user2->level) {
	write_user(user,"User already has that command.\n");
	snprintf(text,sizeof(text),"%s tried to grant you %s!\n",user->name,word[2]);
	send_mail(user,user2->name,text,0);
	snprintf(text,sizeof(text),"%s tried to grant %s %s.\n",user->name,user2->name,word[2]);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
if ((fp=fopen(filename,"r"))) {
	word[1][0]=toupper(word[1][0]);
	fscanf(fp,"%s",comm);
	while(!feof(fp)) {
		if (!strcmp(word[2],comm)) {
			fscanf(fp,"%s",comm); ++found; continue;
			}
		fscanf(fp,"%s",comm);
		++cnt;
		}
	fclose(fp);
	}
if (!found) add_command(user);
else write_user(user,"User already has that command granted.\n");
destruct_user(user2,0);
}

/*** Subset of grant function ***/
void add_command(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;
UR_OBJECT user2;

if ((user2=get_user2(user,word[1]))) {
	snprintf(filename,sizeof(filename),"%s/%s.C",USERFILES,user2->name);
	if (!(fp=fopen(filename,"a"))) {
		snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't open file to append in add_command().\n",0);
		return;
		}
	fprintf(fp,"%s\n",word[2]);
	fclose(fp);
	write_user(user,"Command granted.\n");
	if (!sys_mail) {
		snprintf(text,sizeof(text),"You have been granted %s.\n",word[2]);
		write_user(user2,text);
		}
	snprintf(text,sizeof(text),"%s granted %s %s.\n",user->name,user2->name,word[2]);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in add_command().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.C",USERFILES,user2->name);
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in add_command().\n",0);
	destruct_user(user2,0);
	return;
	}
fprintf(fp,"%s\n",word[2]);
fclose(fp);
write_user(user,"Command granted.\n");
snprintf(text,sizeof(text),"You have been granted %s.\n",word[2]);
send_mail(user,user2->name,text,1);
snprintf(text,sizeof(text),"%s granted %s %s.\n",user->name,user2->name,word[2]);
write_syslog(text,1);
destruct_user(user2,0);
}

/*** Revoke a command ***/
void revokeem(user)
UR_OBJECT user;
{
char comm[20],filename[FILENAME_LEN];
char *comword=NULL;
int cnt=0,found=0,i=0,yepper=0;
FILE *infp,*outfp;
UR_OBJECT user2;

if (word_count<3) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user> <command>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user> <command>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"Nope, this incident will be reported.\n");
		snprintf(text,sizeof(text),"%s tried to revoke %sself %s.\n",user->name,gen2[user->gen],word[2]);
		write_syslog(text,1);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"I don't think so.\n");
		snprintf(text,sizeof(text),"%s tried to revoke you %s!\n",user->name,word[2]);
		write_user(user2,text);
		return;
		}
	snprintf(filename,sizeof(filename),"%s/%s.C",USERFILES,user2->name);
	comword=word[2];
	while(command[i][0]!='*') {
		if (!strcmp(command[i],comword)) { ++yepper;  break; }
		++i;
		}
	if (!yepper || com_level[i]>user->level) {
		write_user(user,"Unknown command.\n");
		snprintf(text,sizeof(text),"%s tried to revoke %s %s.\n",user->name,user2->name,word[2]);
		write_syslog(text,1);
		return;
		}
	if (!(infp=fopen(filename,"r"))) return;
	if (!(outfp=fopen(TEMPFILE,"w"))) {
		snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't open tempfile to write in revokeem().\n",0);
		fclose(infp);
		return;
		}
	fscanf(infp,"%s",comm);
	while(!feof(infp)) {
		if (!strcmp(word[2],comm)) {
			fscanf(infp,"%s",comm); ++found; continue;
			}
		fprintf(outfp,"%s\n",comm);
		fscanf(infp,"%s",comm);
		++cnt;
		}
	fclose(infp);  fclose(outfp);
	if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
	else if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in revokeem().\n",0);
		return;
		}
	if (!found) write_user(user,"Command not granted to user.\n");
	else {
		write_user(user,"Command revoked.\n");
		if (!sys_mail) {
			snprintf(text,sizeof(text),"%s has been revoked.\n",word[2]);
			write_user(user2,text);
			}
		snprintf(text,sizeof(text),"%s revoked %s %s.\n",user->name,user2->name,word[2]);
		write_syslog(text,1);
		}
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in revokeem().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"I don't think so.\n");
	snprintf(text,sizeof(text),"%s tried to revoke you %s!\n",user->name,word[2]);
	send_mail(user,user2->name,text,1);
	destruct_user(user2,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.C",USERFILES,user2->name);
comword=word[2];
while(command[i][0]!='*') {
	if (!strcmp(command[i],comword)) { ++yepper;  break; }
	++i;
	}
if (!yepper || com_level[i]>user->level) {
	write_user(user,"Unknown command.\n");
	snprintf(text,sizeof(text),"%s tried to revoke %s %s.\n",user->name,user2->name,word[2]);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
if (!(infp=fopen(filename,"r"))) return;
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in revokeem().\n",0);
	fclose(infp);
	destruct_user(user2,0);
	return;
	}
fscanf(infp,"%s",comm);
while(!feof(infp)) {
	if (!strcmp(word[2],comm)) {
		fscanf(infp,"%s",comm); ++found; continue;
		}
	fprintf(outfp,"%s\n",comm);
	fscanf(infp,"%s",comm);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,filename)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in revokeem().\n",0);
	return;
	}
if (!found) write_user(user,"Command not granted to user.\n");
else {
	write_user(user,"Command revoked.\n");
	snprintf(text,sizeof(text),"%s has been revoked.\n",word[2]);
	send_mail(user,user2->name,text,1);
	snprintf(text,sizeof(text),"%s revoked %s %s.\n",user->name,user2->name,word[2]);
	write_syslog(text,1);
	}
destruct_user(user2,0);
}

/*** Display granted commands ***/
void granted(user)
UR_OBJECT user;
{
char comm[20],filename[FILENAME_LEN],line[82];
int cnt=0,total=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/%s.C",USERFILES,user->name);
write_user(user,"~BB~OL~FY*** Granted commands ***\n");
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"No granted commands.\n");
	return;
	}
text[0]='\0';
fgets(line,sizeof(line),fp);
while(!feof(fp)) {
	sscanf(line,"%s\n",comm);
	strncat(text,comm,sizeof(text));
	++total;
	if (++cnt==4) {
		strncat(text,"\n",sizeof(text));  write_user(user,text);
		text[0]='\0';  cnt=0;
		}
	fgets(line,sizeof(line),fp);
	}
if (!cnt) write_user(user,"\n");
else { strncat(text,"\n\n",sizeof(text));  write_user(user,text); }
if (total==1) snprintf(text,sizeof(text),"Total of %d granted command.\n\n",total);
else snprintf(text,sizeof(text),"Total of %d granted commands.\n\n",total);
write_user(user,text);
fclose(fp);
}

/*** Stop a user from using a command ***/
void stopuser(user)
UR_OBJECT user;
{
char comm[20],filename[FILENAME_LEN],line[82];
char *comword=NULL;
int cnt=0,found=0,i=0,yepper=0;
FILE *infp,*outfp;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user> <command>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user> <command>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	snprintf(filename,sizeof(filename),"%s/%s.G",USERFILES,user2->name);
	if (word_count<3) {
		if (user2==user) {
			write_user(user,"Umm, why?\n");
			return;
			}
		if (user2->level>=user->level) {
			write_user(user,"I don't think so.\n");
			snprintf(text,sizeof(text),"%s tried to see what commands you couldn't use!\n",user->name);
			write_user(user2,text);
			return;
			}
		snprintf(text,sizeof(text),"~BB~OL~FY*** Commands %s can't use ***\n",user2->name);
		write_user(user,text);
		if (!(infp=fopen(filename,"r"))) {
			write_user(user,"No stopped commands.\n");
			return;
			}
		fgets(line,sizeof(line),infp);
		while(!feof(infp)) {
			snprintf(text,sizeof(text),"%s",line);
			write_user(user,text);
			fgets(line,sizeof(line),infp);
			}
		fclose(infp);
		return;
		}
	if (user2==user) {
		write_user(user,"Umm, why?\n");
		snprintf(text,sizeof(text),"%s tried to stop %sself %s.\n",user->name,gen2[user->gen],word[2]);
		write_syslog(text,1);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"I don't think so.\n");
		snprintf(text,sizeof(text),"%s tried to stop you from using %s!\n",user->name,word[2]);
		write_user(user2,text);
		return;
		}
	comword=word[2];
	while(command[i][0]!='*') {
		if (!strcmp(command[i],comword)) { ++yepper;  break; }
		++i;
		}
	if (!yepper || com_level[i]>user->level) {
		write_user(user,"Unknown command.\n");
		snprintf(text,sizeof(text),"%s tried to stop you from using %s!\n",user->name,word[2]);
		write_user(user2,text);
		snprintf(text,sizeof(text),"%s tried to stop %s from using %s.\n",user->name,user2->name,word[2]);
		write_syslog(text,1);
		return;
		}
	if ((infp=fopen(filename,"r"))) {
		if (!(outfp=fopen(TEMPFILE,"w"))) {
			snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Couldn't open tempfile to write in stopuser().\n",0);
			fclose(infp);
			return;
			}
		word[1][0]=toupper(word[1][0]);
		fscanf(infp,"%s",comm);
		while(!feof(infp)) {
			if (!strcmp(word[2],comm)) {
				fscanf(infp,"%s",comm); ++found; continue;
				}
			fprintf(outfp,"%s\n",comm);
			fscanf(infp,"%s",comm);
			++cnt;
			}
		fclose(infp);  fclose(outfp);
		}
	if (!found) { stop_comm(user); unlink(TEMPFILE); }
	else {
		if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
		else if (rename(TEMPFILE,filename)==-1) {
			unlink(TEMPFILE);
			snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Couldn't rename tempfile in stopuser().\n",0);
			return;
			}
		write_user(user,"Command re-enabled.\n");
		}
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in stopuser().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.G",USERFILES,user2->name);
if (word_count<3) {
	if (user2->level>=user->level) {
		write_user(user,"I don't think so.\n");
		snprintf(text,sizeof(text),"%s tried to see what commands you couldn't use!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	snprintf(text,sizeof(text),"~BB~OL~FY*** Commands %s can't use ***\n",user2->name);
	write_user(user,text);
	if (!(infp=fopen(filename,"r"))) {
		write_user(user,"No stopped commands.\n");
		destruct_user(user2,0);
		return;
		}
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		snprintf(text,sizeof(text),"%s",line);
		write_user(user,text);
		fgets(line,sizeof(line),infp);
		}
	fclose(infp);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"I don't think so.\n");
	snprintf(text,sizeof(text),"%s tried to stop you from using %s!\n",user->name,word[2]);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
comword=word[2];
while(command[i][0]!='*') {
	if (!strcmp(command[i],comword)) { ++yepper;  break; }
	++i;
	}
if (!yepper || com_level[i]>user->level) {
	write_user(user,"Unknown command.\n");
	snprintf(text,sizeof(text),"%s tried to stop %s from using %s.\n",user->name,user2->name,word[2]);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
if ((infp=fopen(filename,"r"))) {
	if (!(outfp=fopen(TEMPFILE,"w"))) {
		snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't open tempfile to write in stopuser().\n",0);
		fclose(infp);
		destruct_user(user2,0);
		return;
		}
	cnt=0;
	word[1][0]=toupper(word[1][0]);
	fscanf(infp,"%s",comm);
	while(!feof(infp)) {
		if (!strcmp(word[2],comm)) {
			fscanf(infp,"%s",comm); ++found; continue;
			}
		fprintf(outfp,"%s\n",comm);
		fscanf(infp,"%s",comm);
		++cnt;
		}
	fclose(infp);  fclose(outfp);
	}
if (!found) { stop_comm(user); unlink(TEMPFILE); }
else {
	if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
	else if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in stopuser().\n",0);
		return;
		}
	write_user(user,"Command re-enabled.\n");
	}
destruct_user(user2,0);
}

/*** Subset of stopuser function ***/
void stop_comm(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;
UR_OBJECT user2;

if ((user2=get_user2(user,word[1]))) {
	snprintf(filename,sizeof(filename),"%s/%s.G",USERFILES,user2->name);
	if (!(fp=fopen(filename,"a"))) {
		snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't open file to append in stop_comm().\n",0);
		return;
		}
	fprintf(fp,"%s\n",word[2]);
	fclose(fp);
	write_user(user,"Command stopped.\n");
	if (!sys_mail) {
		snprintf(text,sizeof(text),"%s has been stopped.\n",word[2]);
		write_user(user2,text);
		}
	snprintf(text,sizeof(text),"%s stopped %s from using %s.\n",user->name,user2->name,word[2]);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in stop_comm().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.G",USERFILES,user2->name);
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in stop_comm().\n",0);
	destruct_user(user2,0);
	return;
	}
fprintf(fp,"%s\n",word[2]);
fclose(fp);
write_user(user,"Command stopped.\n");
snprintf(text,sizeof(text),"%s has been stopped.\n",word[2]);
send_mail(user,user2->name,text,1);
snprintf(text,sizeof(text),"%s stopped %s from using %s.\n",user->name,user2->name,word[2]);
write_syslog(text,1);
destruct_user(user2,0);
}

/*** Site a user ***/
void siteuser(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Site who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (special(user2->name,0) && user->level<GENERAL) {
		write_user(user,nosuchuser);
		return;
		}
	if (user2->level>user->level) {
		write_user(user,"You cannot site a user of higher level than yourself.\n");
		return;
		}
	if (user2->type==REMOTE_TYPE) snprintf(text,sizeof(text),"%s is remotely connected from %s.\n",user2->name,user2->site);
	else snprintf(text,sizeof(text),"%s is logged in from %s:%d.\n",user2->name,user2->site,user2->site_port);
	write_user(user,text);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in site().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (special(user2->name,0) && user->level<GENERAL) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level>user->level) {
	write_user(user,"You cannot site a user of higher level than yourself.\n");
	destruct_user(user2,0);
	return;
	}
snprintf(text,sizeof(text),"%s was last logged in from %s.\n",user2->name,user2->last_site);
write_user(user,text);
destruct_user(user2,0);
}

/*** Find out all users from given user's site ***/
void sameloginsite(str)
char *str;
{
char garbage[82],line[82],scanname[USER_NAME_LEN+1],scanname2[USER_NAME_LEN+1],site[SITE_NAME_LEN+1],scansite[SITE_NAME_LEN+1];
int cnt=0,i;
FILE *infp,*outfp;

if (!(infp=fopen(SITELOG,"r"))) {
	write_wiz(GENERAL,"No possible users.\n",NULL);
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w+"))) {
	snprintf(text,sizeof(text),"%s: couldn't open tempfile.\n",syserror);
	write_wiz(GENERAL,text,NULL);
	write_syslog("ERROR: Couldn't open tempfile in sameloginsite().\n",0);
	fclose(infp);
	return;
	}
sntrncpy(site,str,sizeof(site));
write_wiz(GENERAL,"Possible users from this site:\n",NULL);
fgets(line,sizeof(line),infp);
while(!feof(infp)) {
	i=0;
	sscanf(line,"%s %s %s",scanname,garbage,scansite);
	if (!strcmp(scansite,wholeaddy)) ++i;
	if (!i) if (special(scanname,1)) ++i;
	if (!i) {
		if (check_site(scansite,site)) {
			fgets(line,sizeof(line),outfp);
			while(!feof(outfp)) {
				sscanf(line,"%s\n",scanname2);
				if (!strcmp(scanname,scanname2)) { ++i; break; }
				fgets(line,sizeof(line),outfp);
				}
			if (!i) {
				snprintf(text,sizeof(text),"%-*s @ %s\n",USER_NAME_LEN,scanname,scansite);
				write_wiz(GENERAL,text,NULL);
				++cnt;
				fprintf(outfp,"%s\n",scanname);
				}
			}
		}
	rewind(outfp);
	fgets(line,sizeof(line),infp);
	}
fclose(infp);  fclose(outfp);
if (!cnt) write_wiz(GENERAL,"None found.\n",NULL);
unlink(TEMPFILE);
}

/*** Find out all users from given user's site ***/
void samesite(user)
UR_OBJECT user;
{
char garbage[82],line[82],name[USER_NAME_LEN+1],scanname[USER_NAME_LEN+1],scanname2[USER_NAME_LEN+1],site[SITE_NAME_LEN+1],scansite[SITE_NAME_LEN+1];
int cnt=0,i;
FILE *infp,*outfp;
UR_OBJECT user2;

if (word_count<3) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s user/site <user/site>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s user/site <user/site>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!strncasecmp(word[1],"user",strlen(word[1]))) {
	if ((user2=get_user2(user,word[2]))) {
		if (special(user2->name,0) && user->level<GENERAL) {
			write_user(user,nosuchuser);
			return;
			}
		if (user2->level>user->level) {
			write_user(user,"You cannot samesite a user of higher level than yourself.\n");
			return;
			}
		sntrncpy(name,user2->name,sizeof(name));
		sntrncpy(site,user2->site,sizeof(site));
		}
	else {
		if (!(user2=create_user())) {
			snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Unable to create temporary user session in samesite().\n",0);
			return;
			}
		sntrncpy(user2->name,word[2],sizeof(user2->name));
		if (!load_user_details(user2)) {
			write_user(user,nosuchuser);
			destruct_user(user2,0);
			return;
			}
		if (special(user2->name,0) && user->level<GENERAL) {
			write_user(user,nosuchuser);
			destruct_user(user2,0);
			return;
			}
		if (user2->level>user->level) {
			write_user(user,"You cannot samesite a user of higher level than yourself.\n");
			destruct_user(user2,0);
			return;
			}
		sntrncpy(name,user2->name,sizeof(name));
		sntrncpy(site,user2->last_site,sizeof(site));
		destruct_user(user2,0);
		}
	}
else if (!strncasecmp(word[1],"site",strlen(word[1]))) {
	sntrncpy(name,"NULL",sizeof(name));
	sntrncpy(site,word[2],sizeof(site));
	}
else {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s user/site <user/site>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s user/site <user/site>\n",command[com_num]+1);
	write_user(user,text);
	return;
	}
if (!(infp=fopen(SITELOG,"r"))) {
	snprintf(text,sizeof(text),"No users from %s's site.\n",name);
	write_user(user,text);
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w+"))) {
	snprintf(text,sizeof(text),"%s: couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile in samesite().\n",0);
	fclose(infp);
	return;
	}
if (!strncasecmp(word[1],"user",strlen(word[1]))) snprintf(text,sizeof(text),"Users with the same site as %s:\n",name);
else snprintf(text,sizeof(text),"Users that have logged in from %s:\n",site);
write_user(user,text);
fgets(line,sizeof(line),infp);
while(!feof(infp)) {
	i=0;
	sscanf(line,"%s %s %s",scanname,garbage,scansite);
	if (!strcmp(scansite,wholeaddy)) ++i;
	if (!i) if (special(scanname,1) && user->level<GENERAL) ++i;
	if (!i) if (!strcmp(scanname,name)) ++i;
	if (!i) {
		if (check_site(scansite,site)) {
			fgets(line,sizeof(line),outfp);
			while(!feof(outfp)) {
				sscanf(line,"%s\n",scanname2);
				if (!strcmp(scanname,scanname2)) { ++i; break; }
				fgets(line,sizeof(line),outfp);
				}
			if (!i) {
				snprintf(text,sizeof(text),"%-*s @ %s\n",USER_NAME_LEN,scanname,scansite);
				write_user(user,text);
				++cnt;
				fprintf(outfp,"%s\n",scanname);
				}
			}
		}
	rewind(outfp);
	fgets(line,sizeof(line),infp);
	}
fclose(infp);  fclose(outfp);
if (cnt==1) snprintf(text,sizeof(text),"\n%d match found.\n",cnt);
else snprintf(text,sizeof(text),"\n%d matches found.\n",cnt);
write_user(user,text);
unlink(TEMPFILE);
}

/*** Find out all sites a user has logged in from ***/
void searchsite(user)
UR_OBJECT user;
{
char garbage[82],line[82],name[USER_NAME_LEN+1],scanname[81],scansite[SITE_NAME_LEN+1],scansite2[81];
int cnt=0,i;
FILE *infp,*outfp;

if (word_count<2) {
	write_user(user,"Searchsite who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
word[1][0]=toupper(word[1][0]);
sntrncpy(name,word[1],sizeof(name));
if (special(name,1) && user->level<GENERAL) {
	write_user(user,nosuchuser);
	return;
	}
if (!(infp=fopen(SITELOG,"r"))) {
	snprintf(text,sizeof(text),"No users from %s's site.\n",name);
	write_user(user,text);
	return;
	}
if (!(outfp=fopen(TEMPFILE,"w+"))) {
	snprintf(text,sizeof(text),"%s: couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile in searchsite().\n",0);
	fclose(infp);
	return;
	}
snprintf(text,sizeof(text),"Sites %s has logged in from:\n",name);
write_user(user,text);
fgets(line,sizeof(line),infp);
while(!feof(infp)) {
	i=0;
	sscanf(line,"%s %s %s",scanname,garbage,scansite);
	if (!strcmp(name,scanname)) {
		fgets(line,sizeof(line),outfp);
		while(!feof(outfp)) {
			sscanf(line,"%s\n",scansite2);
			if (!strcmp(scansite,scansite2)) ++i;
			if (!i) fgets(line,sizeof(line),outfp);
			}
		if (!i) {
			snprintf(text,sizeof(text),"%-*s @ %s\n",USER_NAME_LEN,scanname,scansite);
			write_user(user,text);
			++cnt;
			fprintf(outfp,"%s\n",scansite);
			}
		}
	rewind(outfp);
	fgets(line,sizeof(line),infp);
	}
fclose(infp);  fclose(outfp);
if (cnt==1) snprintf(text,sizeof(text),"\n%d match found.\n",cnt);
else snprintf(text,sizeof(text),"\n%d matches found.\n",cnt);
write_user(user,text);
unlink(TEMPFILE);
}

/*** Disable mail for a user ***/
void no_smail(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
FILE *fp;
UR_OBJECT user2;

snprintf(filename,sizeof(filename),"%s/nosmail",DATAFILES);
if (word_count<2) {
	write_user(user,"~BB~OL~FY*** People refusing smail ***\n");
	more(user,filename,0);
	return;
	}
word[1][0]=toupper(word[1][0]);
if ((fp=fopen(filename,"r"))) {
	fscanf(fp,"%s",name);
	while(!feof(fp)) {
		if (!strcmp(name,word[1])) {
			fclose(fp);
			yes_smail(user);
			return;
			}
		fscanf(fp,"%s",name);
		}
	fclose(fp);
	}
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in no_smail().\n",0);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in no_smail().\n",0);
	fclose(fp);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	fclose(fp);
	return;
	}
destruct_user(user2,0);
fprintf(fp,"%s\n",word[1]);
fclose(fp);
snprintf(text,sizeof(text),"%s is no longer receiving smail.\n",word[1]);
write_user(user,text);
snprintf(text,sizeof(text),"%s turned smail off for %s.\n",user->name,word[1]);
write_syslog(text,1);
}

/*** Enable mail for a user ***/
void yes_smail(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
int cnt=0;
FILE *infp,*outfp;

snprintf(filename,sizeof(filename),"%s/nosmail",DATAFILES);
if (!(infp=fopen(filename,"r"))) return;
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in yes_smail().\n",0);
	fclose(infp);
	return;
	}
fscanf(infp,"%s",name);
while(!feof(infp)) {
	if (!strcmp(word[1],name)) {
		fscanf(infp,"%s",name); continue;
		}
	fprintf(outfp,"%s\n",name);
	fscanf(infp,"%s",name);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,filename)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in yes_smail().\n",0);
	return;
	}
snprintf(text,sizeof(text),"%s is now receiving smail.\n",word[1]);
write_user(user,text);
snprintf(text,sizeof(text),"%s turned smail on for %s.\n",user->name,word[1]);
write_syslog(text,1);
}

/*** Disable promotions from a site ***/
void no_promos(user)
UR_OBJECT user;
{
char domain[SITE_NAME_LEN+1],filename[FILENAME_LEN];
FILE *fp;

snprintf(filename,sizeof(filename),"%s/nopromos",DATAFILES);
if (word_count<2) {
	write_user(user,"~BB~OL~FY*** Sites where promos aren't allowed ***\n");
	more(user,filename,0);
	return;
	}
if ((fp=fopen(filename,"r"))) {
	fscanf(fp,"%s",domain);
	while(!feof(fp)) {
		if (!strcmp(domain,word[1])) {
			fclose(fp);
			yes_promos(user);
			return;
			}
		fscanf(fp,"%s",domain);
		}
	fclose(fp);
	}
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in no_promos().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[1]);
fclose(fp);
snprintf(text,sizeof(text),"There will be no promotions from anyone at site %s.\n",word[1]);
write_user(user,text);
snprintf(text,sizeof(text),"%s turned promotions off for site %s.\n",user->name,word[1]);
write_syslog(text,1);
}

/*** Enable promotions from a site ***/
void yes_promos(user)
UR_OBJECT user;
{
char domain[SITE_NAME_LEN+1],filename[FILENAME_LEN];
int cnt=0;
FILE *infp,*outfp;

snprintf(filename,sizeof(filename),"%s/nopromos",DATAFILES);
if (!(infp=fopen(filename,"r"))) return;
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in yes_promos().\n",0);
	fclose(infp);
	return;
	}
fscanf(infp,"%s",domain);
while(!feof(infp)) {
	if (!strcmp(word[1],domain)) {
		fscanf(infp,"%s",domain); continue;
		}
	fprintf(outfp,"%s\n",domain);
	fscanf(infp,"%s",domain);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,filename)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in yes_promos().\n",0);
	return;
	}
snprintf(text,sizeof(text),"There can now be promotions from users at site %s.\n",word[1]);
write_user(user,text);
snprintf(text,sizeof(text),"%s turned promotions on for site %s.\n",user->name,word[1]);
write_syslog(text,1);
}

/*** Disables a command ***/
void stop_command(user)
UR_OBJECT user;
{
char comname[20],filename[FILENAME_LEN],line[82],temp[25];
char *comword=NULL;
int cnt=0,i=0,yepper=0;
FILE *fp;

snprintf(filename,sizeof(filename),"%s/nocommands",DATAFILES);
if (word_count<2) {
	write_user(user,"~BB~OL~FY*** Commands currently disabled ***\n");
	if (!(fp=fopen(filename,"r"))) {
		write_user(user,"No commands disabled.\n");
		return;
		}
	text[0]='\0';
	fgets(line,sizeof(line),fp);
	while(!feof(fp)) {
		sscanf(line,"%s\n",comname);
		snprintf(temp,sizeof(temp),"%-18s ",comname);
		strncat(text,temp,sizeof(text));
		if (++cnt==4) {
			strncat(text,"\n",sizeof(text));  write_user(user,text);
			text[0]='\0';  cnt=0;
			}
		fgets(line,sizeof(line),fp);
		}
	if (!cnt) write_user(user,"\n");
	else { strncat(text,"\n\n",sizeof(text));  write_user(user,text); }
	fclose(fp);
	return;
	}
comword=word[1];
if (strcasecmp(comword,"all")) {
	while(command[i][0]!='*') {
		if (!strcmp(command[i],comword)) { ++yepper;  break; }
		++i;
		}
	if (!yepper || com_level[i]>user->level) {
		write_user(user,"Unknown command.\n");
		snprintf(text,sizeof(text),"%s tried to disable %s.\n",user->name,word[1]);
		write_syslog(text,1);
		return;
		}
	}
if (!strcmp(word[1],"/stop")) {
	write_user(user,"Unknown command.\n");
	snprintf(text,sizeof(text),"%s tried to disable %s.\n",user->name,word[1]);
	write_syslog(text,1);
	return;
	}
if ((fp=fopen(filename,"r"))) {
	fscanf(fp,"%s",comname);
	while(!feof(fp)) {
		if (!strcmp(comname,word[1])) {
			fclose(fp);
			remove_comm(user);
			return;
			}
		fscanf(fp,"%s",comname);
		}
	fclose(fp);
	}
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in stop_command().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[1]);
fclose(fp);
snprintf(text,sizeof(text),"%s is now disabled.\n",word[1]);
write_user(user,text);
snprintf(text,sizeof(text),"%s disabled %s.\n",user->name,word[1]);
write_syslog(text,1);
}

/*** Subset of stop_command function ***/
void remove_comm(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
int cnt=0;
FILE *infp,*outfp;

snprintf(filename,sizeof(filename),"%s/nocommands",DATAFILES);
if (!(infp=fopen(filename,"r"))) return;
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in remove_comm().\n",0);
	fclose(infp);
	return;
	}
if (strcasecmp(word[1],"all")) word[1][0]=toupper(word[1][0]);
fscanf(infp,"%s",name);
while(!feof(infp)) {
	if (!strcmp(word[1],name)) {
		fscanf(infp,"%s",name); continue;
		}
	fprintf(outfp,"%s\n",name);
	fscanf(infp,"%s",name);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,filename)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in remove_comm().\n",0);
	return;
	}
snprintf(text,sizeof(text),"%s is no longer disabled.\n",word[1]);
write_user(user,text);
snprintf(text,sizeof(text),"%s enabled %s.\n",user->name,word[1]);
write_syslog(text,1);
}

/*** Special people ***/
void makeem_special(user,which)
UR_OBJECT user;
int which;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
FILE *fp;
UR_OBJECT user2;

if (!which) snprintf(filename,sizeof(filename),"%s/special",DATAFILES);
else snprintf(filename,sizeof(filename),"%s/special2",DATAFILES);
if (word_count<2) {
	if (!which) write_user(user,"~BB~OL~FY*** Special people ***\n");
	else write_user(user,"~BB~OL~FY*** Special people II ***\n");
	more(user,filename,0);
	return;
	}
word[1][0]=toupper(word[1][0]);
if ((fp=fopen(filename,"r"))) {
	fscanf(fp,"%s",name);
	while(!feof(fp)) {
		if (!strcmp(name,word[1])) {
			fclose(fp);
			makeem_notspecial(user,which);
			return;
			}
		fscanf(fp,"%s",name);
		}
	fclose(fp);
	}
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in makeem_special().\n",0);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in makeem_special().\n",0);
	fclose(fp);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	fclose(fp);
	return;
	}
destruct_user(user2,0);
fprintf(fp,"%s\n",word[1]);
fclose(fp);
if (!which) snprintf(text,sizeof(text),"%s is now special.\n",word[1]);
else snprintf(text,sizeof(text),"%s is now special II.\n",word[1]);
write_user(user,text);
if (!which) snprintf(text,sizeof(text),"%s made %s special.\n",user->name,word[1]);
else snprintf(text,sizeof(text),"%s made %s special II.\n",user->name,word[1]);
write_syslog(text,1);
}

/*** Make someone no longer special ***/
void makeem_notspecial(user,which)
UR_OBJECT user;
int which;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
int cnt=0;
FILE *infp,*outfp;

if (!which) snprintf(filename,sizeof(filename),"%s/special",DATAFILES);
else snprintf(filename,sizeof(filename),"%s/special2",DATAFILES);
if (!(infp=fopen(filename,"r"))) return;
if (!(outfp=fopen(TEMPFILE,"w"))) {
	snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open tempfile to write in makeem_notspecial().\n",0);
	fclose(infp);
	return;
	}
word[1][0]=toupper(word[1][0]);
fscanf(infp,"%s",name);
while(!feof(infp)) {
	if (!strcmp(word[1],name)) {
		fscanf(infp,"%s",name);
		continue;
		}
	fprintf(outfp,"%s\n",name);
	fscanf(infp,"%s",name);
	++cnt;
	}
fclose(infp);  fclose(outfp);
if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
else if (rename(TEMPFILE,filename)==-1) {
	unlink(TEMPFILE);
	snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't rename tempfile in makeem_notspecial().\n",0);
	return;
	}
if (!which) snprintf(text,sizeof(text),"%s is no longer special.\n",word[1]);
else snprintf(text,sizeof(text),"%s is no longer special II.\n",word[1]);
write_user(user,text);
if (!which) snprintf(text,sizeof(text),"%s made %s no longer special.\n",user->name,word[1]);
else snprintf(text,sizeof(text),"%s made %s no longer special II.\n",user->name,word[1]);
write_syslog(text,1);
}

/*** Friends list for keeping track of your friends ***/
void friends_list(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],line[82],name[USER_NAME_LEN+1],temp[25];
int cnt=0,found=0,total=0,total2=0;
FILE *infp,*outfp;
UR_OBJECT user2;

snprintf(filename,sizeof(filename),"%s/%s.F",USERFILES,user->name);
if (word_count<2) {
	write_user(user,"~BB~OL~FY*** Friends ***\n");
	if (!(infp=fopen(filename,"r"))) {
		write_user(user,"You have no friends.\n");
		return;
		}
	text[0]='\0';
	fgets(line,sizeof(line),infp);
	while(!feof(infp)) {
		sscanf(line,"%s\n",name);
		snprintf(line,sizeof(line),"  %s",name);
		if ((user2=get_user2(user,name)) && user2->vis) { line[0]='*'; ++total; }
		++total2;
		snprintf(temp,sizeof(temp),"%-*s ",USER_NAME_LEN,line);
		strncat(text,temp,sizeof(text));
		if (++cnt==4) {
			strncat(text,"\n",sizeof(text));  write_user(user,text);
			text[0]='\0';  cnt=0;
			}
		fgets(line,sizeof(line),infp);
		}
	if (!cnt) write_user(user,"\n");
	else { strncat(text,"\n\n",sizeof(text));  write_user(user,text); }
	snprintf(text,sizeof(text),"Total of %d of your %d friends signed on.\n\n",total,total2);
	write_user(user,text);
	fclose(infp);
	return;
	}
if ((infp=fopen(filename,"r"))) {
	if (!(outfp=fopen(TEMPFILE,"w"))) {
		snprintf(text,sizeof(text),"%s: Couldn't open tempfile.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't open tempfile to write in friends_list().\n",0);
		fclose(infp);
		return;
		}
	word[1][0]=toupper(word[1][0]);
	fscanf(infp,"%s",name);
	while(!feof(infp)) {
		if (!strcmp(word[1],name)) {
			fscanf(infp,"%s",name); ++found; continue;
			}
		fprintf(outfp,"%s\n",name);
		fscanf(infp,"%s",name);
		++cnt;
		}
	fclose(infp);  fclose(outfp);
	}
if (!found) {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in friends_list().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user_ignored(user2,user)) {
		snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
		write_user(user,text);
		destruct_user(user2,0);
		return;
		}
	destruct_user(user2,0);
	add_friend(user);
	unlink(TEMPFILE);
	return;
	}
else {
	if (!cnt) { unlink(filename);  unlink(TEMPFILE); }
	else if (rename(TEMPFILE,filename)==-1) {
		unlink(TEMPFILE);
		snprintf(text,sizeof(text),"%s: renaming failure.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Couldn't rename tempfile in friends_list().\n",0);
		return;
		}
	write_user(user,"Name removed.\n");
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in friends_list().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	destruct_user(user2,0);
	}
}

/*** Subset of friends_list function ***/
void add_friend(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
FILE *fp;

word[1][0]=toupper(word[1][0]);
snprintf(filename,sizeof(filename),"%s/%s.F",USERFILES,user->name);
if (!(fp=fopen(filename,"a"))) {
	snprintf(text,sizeof(text),"%s: Can't open file to append.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Couldn't open file to append in add_friend().\n",0);
	return;
	}
fprintf(fp,"%s\n",word[1]);
fclose(fp);
write_user(user,"Name added.\n");
}

/*** Send mail to all of your friends ***/
void fmail(user,inpstr,done_editing)
UR_OBJECT user;
char *inpstr;
int done_editing;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
FILE *fp;
UR_OBJECT user2;

if (ban_smailing) {
	write_user(user,"Sorry, smailing has been turned off.\n");
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.F",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"Sorry, but you have no friends.\n");
	return;
	}
if (!done_editing) fclose(fp);
else {
	if (ban_swearing && contains_swearing(user->malloc_start)) {
		fclose(fp);
		swore(user);
		return;
		}
	while(!feof(fp)) {
		fscanf(fp,"%s\n",name);
		if (nosmail(name)) continue;
		if ((user2=get_user(name,0))) {
			if (!user2->smail || !user2->fmail) continue;
			if (user_ignored(user2,user)) continue;
			}
		else {
			if (!(user2=create_user())) {
				snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
				write_user(user,text);
				write_syslog("ERROR: Unable to create temporary user session in fmail().\n",0);
				fclose(fp);
				return;
				}
			sntrncpy(user2->name,name,sizeof(user2->name));
			if (!load_user_details(user2)) {
				destruct_user(user2,0);
				continue;
				}
			if (!user2->smail || !user2->fmail) {
				destruct_user(user2,0);
				continue;
				}
			if (user_ignored(user2,user)) {
				destruct_user(user2,0);
				continue;
				}
			destruct_user(user2,0);
			}
		send_mail(user,name,user->malloc_start,2);
		}
	fclose(fp);
	return;
	}
if (word_count<2) inpstr=remove_first(inpstr);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"You have no friends.\n");
	return;
	}
if (word_count>1) {
	if (ban_swearing && contains_swearing(inpstr)) {
		fclose(fp);
		swore(user);
		return;
		}
	strncat(inpstr,"\n",ARR_SIZE);
	while(!feof(fp)) {
		fscanf(fp,"%s\n",name);
		if (nosmail(name)) continue;
		if ((user2=get_user(name,0))) {
			if (!user2->smail || !user2->fmail) continue;
			if (user_ignored(user2,user)) continue;
			}
		else {
			if (!(user2=create_user())) {
				snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
				write_user(user,text);
				write_syslog("ERROR: Unable to create temporary user session in fmail().\n",0);
				fclose(fp);
				return;
				}
			sntrncpy(user2->name,name,sizeof(user2->name));
			if (!load_user_details(user2)) {
				destruct_user(user2,0);
				continue;
				}
			if (!user2->smail || !user2->fmail) {
				destruct_user(user2,0);
				continue;
				}
			if (user_ignored(user2,user)) {
				destruct_user(user2,0);
				continue;
				}
			destruct_user(user2,0);
			}
		send_mail(user,name,inpstr,2);
		}
	fclose(fp);
	return;
	}
write_user(user,"\n~BB~OL~FY*** Writing mail message to all of your friends ***\n\n");
user->misc_op=9;
editor(user,NULL);
}

/*** Tell something to all your friends ***/
void frtell(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1],type[12];
int cnt=0;
FILE *fp;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <message>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <message>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.F",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"You have no friends.\n");
	return;
	}
snprintf(text,sizeof(text),"~OL~FB(Friendly message)~RS %s tells you: %s\n",user->name,inpstr);
while(!feof(fp)) {
	fscanf(fp,"%s\n",name);
	if ((user2=get_user(name,0)) && user2->listen && user2->tell && !user_ignored(user2,user)) {
		if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
		if (user2->afk) write_afklog(user2,text);
		else write_user(user2,text);
		if (!cnt) {
			if (inpstr[strlen(inpstr)-1]=='?') sntrncpy(type,"ask",sizeof(type));
			else if (inpstr[strlen(inpstr)-1]=='!') sntrncpy(type,"exclaim to",sizeof(type));
			else sntrncpy(type,"tell",sizeof(type));
			snprintf(text,sizeof(text),"You %s your friends: %s\n",type,inpstr);
			write_user(user,text);
			++cnt;
			}
		}
	}
fclose(fp);
if (!cnt) write_user(user,"None of your friends are signed on.\n");
}

/*** Emote something to all your friends ***/
void femote(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char filename[FILENAME_LEN],name[USER_NAME_LEN+1];
int cnt=0;
FILE *fp;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <emote>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <emote>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
snprintf(filename,sizeof(filename),"%s/%s.F",USERFILES,user->name);
if (!(fp=fopen(filename,"r"))) {
	write_user(user,"You have no friends.\n");
	return;
	}
if (inpstr[0]=='\'') snprintf(text,sizeof(text),"~OL~FBFriend ~OL~FR>>~RS %s%s\n",user->name,inpstr);
else snprintf(text,sizeof(text),"~OL~FBFriend ~OL~FR>>~RS %s %s\n",user->name,inpstr);
while(!feof(fp)) {
	fscanf(fp,"%s\n",name);
	if ((user2=get_user(name,0)) && user2->listen && user2->tell && !user_ignored(user2,user)) {
		if (user2->room) if (user2->room->level!=user->room->level && user2->level<GENERAL) continue;
		if (user2->afk) write_afklog(user2,text);
		else write_user(user2,text);
		if (!cnt) {
			if (inpstr[0]=='\'') snprintf(text,sizeof(text),"(To Your Friends) %s%s\n",user->name,inpstr);
			else snprintf(text,sizeof(text),"(To Your Friends) %s %s\n",user->name,inpstr);
			write_user(user,text);
			++cnt;
			}
		}
	}
fclose(fp);
if (!cnt) write_user(user,"None of your friends are signed on.\n");
}

/*** Wake up some sleepy herbert ***/
void wake(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Wake who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to wake yourself up is the eighth sign of madness.\n");
	return;
	}
if (user2->level>user->level) {
	write_user(user,"You cannot wake someone of a higher level than yourself.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
write_user(user2,"\07~LI~FR*** ~FBWAKE ~OL~FYUP ~PZ~FGSLEEPY ~FTHEAD~FM!! ~FR***\n");
write_user(user,"Wake up call sent.\n");
}

/*** Shout something to other wizzes and gods. If the level isn't given it
     defaults to WIZ level ***/
void wizshout(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char filename[FILENAME_LEN];
int lev;
FILE *fp;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<superuser level>] <message>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s [<superuser level>] <message>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	write_user(user,noswearing);
	return;
	}
strtoupper(word[1]);
if ((lev=get_level(word[1],1))==-1) lev=COLONEL;
else {
	if (lev<COLONEL || word_count<3) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<superuser level>] <message>\n",command[com_num]);
		else snprintf(text,sizeof(text),"Usage: %s [<superuser level>] <message>\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	if (lev>user->level) {
		write_user(user,"You can't specifically shout to users of a higher level than yourself.\n");
		return;
		}
	snprintf(text,sizeof(text),"You wizshout to level %s: %s\n",level_name[lev],inpstr);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s wizshouts to level %s: %s\n",user->morphed,level_name[lev],inpstr);
	write_wiz(lev,text,user);
	return;
	}
snprintf(filename,sizeof(filename),"%s/wizshout",DATAFILES);
snprintf(text,sizeof(text),"You wizshout: %s\n",inpstr);
write_user(user,text);
snprintf(text,sizeof(text),"%s wizshouts: %s\n",user->morphed,inpstr);
write_wiz(COLONEL,text,user);
if (!(fp=fopen(filename,"a"))) return;
fprintf(fp,"~OL~FB%s wizshouts:~RS %s\n",user->morphed,inpstr);
fclose(fp);
}

/*** Emote something to other wizzes and gods. If the level isn't given it
     defaults to WIZ level ***/
void wizemote(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char filename[FILENAME_LEN];
int lev;
FILE *fp;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<superuser level>] <message>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s [<superuser level>] <message>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	write_user(user,noswearing);
	return;
	}
strtoupper(word[1]);
if ((lev=get_level(word[1],1))==-1) lev=COLONEL;
else {
	if (lev<COLONEL || word_count<3) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<superuser level>] <message>\n",command[com_num]);
		else snprintf(text,sizeof(text),"Usage: %s [<superuser level>] <message>\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	if (lev>user->level) {
		write_user(user,"You can't specifically emote to users of a higher level than yourself.\n");
		return;
		}
	snprintf(text,sizeof(text),"You wizemote to level %s: %s %s\n",level_name[lev],user->morphed,inpstr);
	write_user(user,text);
	snprintf(text,sizeof(text),"[WIZEMOTE] to level %s: %s %s\n",level_name[lev],user->morphed,inpstr);
	write_wiz(lev,text,user);
	return;
	}
snprintf(filename,sizeof(filename),"%s/wizshout",DATAFILES);
snprintf(text,sizeof(text),"You wizemote: %s %s\n",user->morphed,inpstr);
write_user(user,text);
snprintf(text,sizeof(text),"[WIZEMOTE]: %s %s\n",user->morphed,inpstr);
write_wiz(COLONEL,text,user);
if (!(fp=fopen(filename,"a"))) return;
fprintf(fp,"[~OL~FBWIZEMOTE~RS] %s %s\n",user->morphed,inpstr);
fclose(fp);
}

/*** Muzzle an annoying user so he cant speak, emote, echo, write,
     or smail, or anything for that matter :P.
     Muzzles have levels from WIZ to GOD so for instance a wiz
     cannot remove a muzzle set by a god ***/
void muzzle(user)
UR_OBJECT user;
{
char *name;
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Muzzle who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"Trying to muzzle yourself is the ninth sign of madness.\n");
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"Hmm .. inadvisable.\n");
		snprintf(text,sizeof(text),"%s tried to muzzle you.\n",user->name);
		write_user(user2,text);
		return;
		}
	if (user2->muzzled>=user->level) {
		snprintf(text,sizeof(text),"%s is already muzzled.\n",user2->name);
		write_user(user,text);
		snprintf(text,sizeof(text),"%s tried to muzzle %s but failed.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (user->vis) name=user->morphed; else name=invisname;
	snprintf(text,sizeof(text),"%s chants an ancient spell...\n",name);
	write_room_except(user->room,text,user,NULL,0,NULL);
	user2->muzzled=user->level;
	snprintf(text,sizeof(text),"%s now has a muzzle of level %s.\n",user2->name,level_name[user->level]);
	write_user(user,text);
	write_user(user2,"You have been muzzled!\n");
	snprintf(text,sizeof(text),"%s muzzled %s.\n",user->name,user2->name);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in muzzle().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"Hmm .. inadvisable.\n");
	snprintf(text,sizeof(text),"%s tried to muzzle you.\n",user->name);
	send_mail(user,user2->name,text,0);
	destruct_user(user2,0);
	return;
	}
if (user2->muzzled>=user->level) {
	snprintf(text,sizeof(text),"%s is already muzzled.\n",user2->name);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s tried to muzzle %s but failed.\n",user->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
if (user->vis) name=user->morphed; else name=invisname;
snprintf(text,sizeof(text),"%s chants an ancient spell...\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
user2->muzzled=user->level;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
save_user_details(user2,0);
snprintf(text,sizeof(text),"%s given a muzzle of level %s.\n",user2->name,level_name[user->level]);
write_user(user,text);
snprintf(text,sizeof(text),"%s muzzled %s.\n",user->name,user2->name);
write_syslog(text,1);
snprintf(text,sizeof(text),"You have been muzzled!\n");
send_mail(user,user2->name,text,1);
destruct_user(user2,0);
}

/*** Unmuzzle the bastard ***/
void unmuzzle(user)
UR_OBJECT user;
{
char *name;
UR_OBJECT user2;

if (user->muzzled) {
	write_user(user,"You are muzzled, you cannot unmuzzle anyone.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Unmuzzle who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		write_user(user,"Trying to unmuzzle yourself is the tenth sign of madness.\n");
		return;
		}
	if (!user2->muzzled) {
		snprintf(text,sizeof(text),"%s is not muzzled.\n",user2->name);
		return;
		}
	if (user2->muzzled>user->level) {
		snprintf(text,sizeof(text),"%s's muzzle is set to level %s, you do not have the power to remove it.\n",user2->name,level_name[user2->muzzled]);
		write_user(user,text);
		snprintf(text,sizeof(text),"%s tried to unmuzzle %s but failed.\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	if (user->vis) name=user->morphed; else name=invisname;
	snprintf(text,sizeof(text),"%s chants an ancient spell...\n",name);
	write_room_except(user->room,text,user,NULL,0,NULL);
	user2->muzzled=0;
	snprintf(text,sizeof(text),"You remove %s's muzzle.\n",user2->name);
	write_user(user,text);
	write_user(user2,"You have been unmuzzled!\n");
	snprintf(text,sizeof(text),"%s unmuzzled %s.\n",user->name,user2->name);
	write_syslog(text,1);
	return;
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create temporary user session in unmuzzle().\n",0);
	return;
	}
sntrncpy(user2->name,word[1],sizeof(user2->name));
if (!load_user_details(user2)) {
	write_user(user,nosuchuser);
	destruct_user(user2,0);
	return;
	}
if (user2->muzzled>user->level) {
	snprintf(text,sizeof(text),"%s's muzzle is set to level %s, you do not have the power to remove it.\n",user2->name,level_name[user2->muzzled]);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s tried to unmuzzle %s but failed.\n",user->name,user2->name);
	write_syslog(text,1);
	destruct_user(user2,0);
	return;
	}
user2->socket=5;
if (user->vis) name=user->morphed; else name=invisname;
snprintf(text,sizeof(text),"%s chants an ancient spell...\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
user2->muzzled=0;
sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
save_user_details(user2,0);
snprintf(text,sizeof(text),"You remove %s's muzzle.\n",user2->name);
write_user(user,text);
snprintf(text,sizeof(text),"%s unmuzzled %s.\n",user->name,user2->name);
write_syslog(text,1);
snprintf(text,sizeof(text),"You have been unmuzzled!\n");
send_mail(user,user2->name,text,1);
destruct_user(user2,0);
}

/*** Switch system logging on and off ***/
void logging(user)
UR_OBJECT user;
{
if (system_logging) {
	system_logging=0;
	write_user(user,"System logging OFF.\n");
	snprintf(text,sizeof(text),"%s switched system logging OFF.\n",user->name);
	write_syslog(text,1);
	return;
	}
system_logging=1;
write_user(user,"System logging ON.\n");
snprintf(text,sizeof(text),"%s switched system logging ON.\n",user->name);
write_syslog(text,1);
}

/*** Set minlogin level ***/
void minlogin(user)
UR_OBJECT user;
{
char *usage="Usage: minlogin NONE/<user level>\n";
char levstr[10];
int lev;

if (word_count<2) {
	write_user(user,usage);
	scom_main(user,NULL,3,0);
	return;
	}
strtoupper(word[1]);
if ((lev=get_level(word[1],1))==-1) {
	if (strcmp(word[1],"NONE")) {
		write_user(user,usage);
		return;
		}
	lev=-1;
	sntrncpy(levstr,"NONE",sizeof(levstr));
	}
else sntrncpy(levstr,level_name[lev],sizeof(levstr));
if (lev>user->level) {
	write_user(user,"You cannot set minlogin to a higher level that your own.\n");
	return;
	}
if (minlogin_level>user->level) {
	snprintf(text,sizeof(text),"Sorry, but you must be at level %s or higher to change the minlogin level.\n",level_name[minlogin_level]);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s tried to change the minlogin level but failed.\n",user->name);
	write_syslog(text,1);
	return;
	}
if (minlogin_level==lev) {
	write_user(user,"It is already set to that.\n");
	return;
	}
minlogin_level=lev;
snprintf(text,sizeof(text),"Minlogin level set to %s.\n",levstr);
write_user(user,text);
snprintf(text,sizeof(text),"%s has set the minlogin level to %s.\n",user->name,levstr);
write_wiz(COLONEL,text,user);
snprintf(text,sizeof(text),"%s set the minlogin level to %s.\n",user->name,levstr);
write_syslog(text,1);
}

/*** Show various system stats ***/
void sys_stats(user)
UR_OBJECT user;
{
char bstr[40],text2[100];
int days,hours,i,mins,secs;

snprintf(text,sizeof(text),"~BB~FK*** HOLE version %s - system status ***",HVERSION);
for(i=strlen(text)-(color_com_count(text,0)*3);i<60;++i) strncat(text," ",sizeof(text));
strncat(text,"\n",sizeof(text));
write_user(user,text);
text[0]='\0';
strncat(text,"~BB~FK",sizeof(text));
for(i=0;i<60;++i) strncat(text," ",sizeof(text));
strncat(text,"\n",sizeof(text));
write_user(user,text);
sntrncpy(bstr,ctime(&boot_time),sizeof(bstr));
bstr[strlen(bstr)-1]='\0';
secs=(int)(time(0)-boot_time);
days=secs/86400;
hours=(secs%86400)/3600;
mins=(secs%3600)/60;
secs=secs%60;
snprintf(text,sizeof(text),"~BB~FKTalker booted : %s",bstr);
for(i=strlen(text)-(color_com_count(text,0)*3);i<60;++i) strncat(text," ",sizeof(text));
strncat(text,"\n",sizeof(text));
write_user(user,text);
snprintf(text,sizeof(text),"~BB~FKUptime        : ");
if (days==1) snprintf(text2,sizeof(text2),"%d day, ",days);
else snprintf(text2,sizeof(text2),"%d days, ",days);
strncat(text,text2,sizeof(text));
if (hours==1) snprintf(text2,sizeof(text2),"%d hour, ",hours);
else snprintf(text2,sizeof(text2),"%d hours, ",hours);
strncat(text,text2,sizeof(text));
if (mins==1) snprintf(text2,sizeof(text2),"%d minute, ",mins);
else snprintf(text2,sizeof(text2),"%d minutes, ",mins);
strncat(text,text2,sizeof(text));
if (secs==1) snprintf(text2,sizeof(text2),"%d second",secs);
else snprintf(text2,sizeof(text2),"%d seconds",secs);
strncat(text,text2,sizeof(text));
for(i=strlen(text)-(color_com_count(text,0)*3);i<60;++i) strncat(text," ",sizeof(text));
strncat(text,"\n",sizeof(text));
write_user(user,text);
i=0;
while(command[i][0]!='*') ++i;
snprintf(text,sizeof(text),"~BB~FKTotal commands: %i",i);
for(i=strlen(text)-(color_com_count(text,0)*3);i<60;++i) strncat(text," ",sizeof(text));
strncat(text,"\n",sizeof(text));
write_user(user,text);
}

/*** Show talker system parameters etc ***/
void system_details(user)
UR_OBJECT user;
{
char *offon[]={ "OFF","ON " };
char *ca[]={ "NONE","IGNORE","REBOOT" };
char bstr[40],minloginlev[10];
int days,hours,mins,secs;
int inc=0,netlinks=0,live=0,outg=0;
int hid=0,inlinks=0,mem=0,num_clones=0,rms=0,size=0;
NL_OBJECT nl;
RM_OBJECT room;
UR_OBJECT user2;

snprintf(text,sizeof(text),"\n~BB*** HOLE version %s - system status ***\n\n",HVERSION);
write_user(user,text);
sntrncpy(bstr,ctime(&boot_time),sizeof(bstr));
secs=(int)(time(0)-boot_time);
days=secs/86400;
hours=(secs%86400)/3600;
mins=(secs%3600)/60;
secs=secs%60;
size=sizeof(struct user_struct);
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && !user2->hid) ++num_clones;
	mem+=size;
	if (user2->hid) ++hid;
	}
snprintf(text,sizeof(text),"Ports (M/W/T/L): %d,  %d,  %d,  %d\n",port[0],port[1],port[2],port[3]);
write_user(user,text);
snprintf(text,sizeof(text),"Process ID     : %d\nTalker booted  : %sUptime         : ",getpid(),bstr);
write_user(user,text);
if (days==1) snprintf(text,sizeof(text),"%d day, ",days);
else snprintf(text,sizeof(text),"%d days, ",days);
write_user(user,text);
if (hours==1) snprintf(text,sizeof(text),"%d hour, ",hours);
else snprintf(text,sizeof(text),"%d hours, ",hours);
write_user(user,text);
if (mins==1) snprintf(text,sizeof(text),"%d minute, ",mins);
else snprintf(text,sizeof(text),"%d minutes, ",mins);
write_user(user,text);
if (secs==1) snprintf(text,sizeof(text),"%d second\n\n",secs);
else snprintf(text,sizeof(text),"%d seconds\n\n",secs);
write_user(user,text);
snprintf(text,sizeof(text),"Max users             : %-3d           Current num. of users : %d\n",max_users,num_of_users-hid);
write_user(user,text);
snprintf(text,sizeof(text),"Max clones            : %-2d            Current num. of clones: %d\n",max_clones,num_clones);
write_user(user,text);
if (minlogin_level==-1) sntrncpy(minloginlev,"NONE",sizeof(minloginlev));
else sntrncpy(minloginlev,level_name[minlogin_level],sizeof(minloginlev));
snprintf(text,sizeof(text),"Current minlogin level: %-9s     Login idle time out   : ",minloginlev);
write_user(user,text);
if (login_idle_time==1) snprintf(text,sizeof(text),"%d second\n",login_idle_time);
else snprintf(text,sizeof(text),"%d secs\n",login_idle_time);
write_user(user,text);
snprintf(text,sizeof(text),"User idle time out    : %-3d secs      Heartbeat             : %d\n",user_idle_time,heartbeat);
write_user(user,text);
snprintf(text,sizeof(text),"Remote user maxlevel  : %-9s     Remote user def level : %-9s\n",level_name[rem_user_maxlevel],level_name[rem_user_deflevel]);
write_user(user,text);
snprintf(text,sizeof(text),"Wizport min login lev : %-9s     Gatecrash level       : %-9s\n",level_name[wizport_level],level_name[gatecrash_level]);
write_user(user,text);
snprintf(text,sizeof(text),"Private room min count: %-2d            Message lifetime      : ",min_private_users);
write_user(user,text);
if (mesg_life==1) snprintf(text,sizeof(text),"%d day\n",mesg_life);
else snprintf(text,sizeof(text),"%d days\n",mesg_life);
write_user(user,text);
snprintf(text,sizeof(text),"Message check time    : %02d:%02d         Net idle time out     : ",mesg_check_hour,mesg_check_min);
write_user(user,text);
if (net_idle_time==1) snprintf(text,sizeof(text),"%d second\n",net_idle_time);
else snprintf(text,sizeof(text),"%d seconds\n",net_idle_time);
write_user(user,text);
size=sizeof(struct room_struct);
for(room=room_first;room;room=room->next) {
	if (room->inlink) ++inlinks;
	++rms;	mem+=size;
	}
snprintf(text,sizeof(text),"Number of rooms       : %-2d            Accepting netconnects : %s\n",rms,noyes2[inlinks]);
write_user(user,text);
size=sizeof(struct netlink_struct);
for(nl=nl_first;nl;nl=nl->next) {
	if (nl->type!=UNCONNECTED && nl->stage==2) ++live;
	if (nl->type==INCOMING) ++inc;
	if (nl->type==OUTGOING) ++outg;
	++netlinks;  mem+=size;
	}
snprintf(text,sizeof(text),"Total netlinks        : %-2d            Number which are live : %d\n",netlinks,live);
write_user(user,text);
snprintf(text,sizeof(text),"Number incoming       : %-2d            Number outgoing       : %d\n",inc,outg);
write_user(user,text);
snprintf(text,sizeof(text),"New user prompt def.  : %s           System logging        : %s\n",offon[prompt_def],offon[system_logging]);
write_user(user,text);
snprintf(text,sizeof(text),"Ignoring sigterm      : %s           Echoing passwords     : %s\n",noyes2[ignore_sigterm],noyes2[password_echo]);
write_user(user,text);
snprintf(text,sizeof(text),"Swearing banned       : %s           Crash action          : %-7s\n",noyes2[ban_swearing],ca[crash_action]);
write_user(user,text);
snprintf(text,sizeof(text),"New user color default: %s           Object mem allocated  : %d bytes\n\n",offon[color_def],mem);
write_user(user,text);
}

/*** Show talker system bans ***/
void system_bans(user)
UR_OBJECT user;
{
if (!user->tdiff) snprintf(text,sizeof(text),"\n~BB~OL~FY*** System bans - %s, %s %d, %02d:%02d %s ***\n\n",day[twday],month[tmonth],tmday,ttime,tmin,md);
else snprintf(text,sizeof(text),"\n~BB~OL~FY*** System bans - %s, %s %d, %02d:%02d *** %s\n\n",day[user->twday],month[user->tmonth],user->tmday,user->ttime,user->tmin,user->md);
write_user(user,text);
snprintf(text,sizeof(text),"Shouting banned: %s         Smailing banned  : %s\n",noyes2[ban_shouting],noyes2[ban_smailing]);
write_user(user,text);
snprintf(text,sizeof(text),"Smoking banned : %s         Socials banned   : %s\n",noyes2[ban_smoking],noyes2[ban_socials]);
write_user(user,text);
snprintf(text,sizeof(text),"Games banned   : %s         Difflogins banned: %s\n",noyes2[ban_games],noyes2[!difflogin]);
write_user(user,text);
snprintf(text,sizeof(text),"Pictells banned: %s         Greets banned    : %s\n",noyes2[ban_pictells],noyes2[ban_greets]);
write_user(user,text);
snprintf(text,sizeof(text),"Hunting banned : %s         Suicides banned  : %s\n",noyes2[ban_hunting],noyes2[ban_suicides]);
write_user(user,text);
snprintf(text,sizeof(text),"Quitting banned: %s         Lilmurders banned: %s\n",noyes2[ban_quitting],noyes2[ban_willkill]);
write_user(user,text);
}

/*** Set the character mode echo on or off. This is only for users logging in
     via a character mode client, those using a line mode client (eg unix
     telnet) will see no effect ***/
void charecho(user)
UR_OBJECT user;
{
if (!user->charmode_echo) {
	user->charmode_echo=1;
	write_user(user,"Echoing for character mode clients ON.\n");
	}
else {
	user->charmode_echo=0;
	write_user(user,"Echoing for character mode clients OFF.\n");
	}
if (!user->room) prompt(user);
}

/*** Toggle other's user's charecho ***/
void ocharecho(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Toggle whose charecho?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if ((user2=get_user2(user,word[1]))) {
	if (user2==user) {
		if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Try just %s please\n",command[com_num]);
		else snprintf(text,sizeof(text),"Try just %s please.\n",command[com_num]+1);
		write_user(user,text);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to toggle your charecho!\n",user->name);
		write_user(user2,text);
		return;
		}
	if (!user2->charmode_echo) {
		snprintf(text,sizeof(text),"%s's echoing for character mode clients ON.\n",user2->name);
		write_user(user,text);
		write_user(user2,"Echoing for character mode clients ON.\n");
		user2->charmode_echo=1;
		return;
		}
	user2->charmode_echo=0;
	snprintf(text,sizeof(text),"%s's echoing for character mode clients OFF.\n",user2->name);
	write_user(user,text);
	write_user(user2,"Echoing for character mode clients OFF.\n");
	}
else {
	if (!(user2=create_user())) {
		snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
		write_user(user,text);
		write_syslog("ERROR: Unable to create temporary user session in ocharecho().\n",0);
		return;
		}
	sntrncpy(user2->name,word[1],sizeof(user2->name));
	if (!load_user_details(user2)) {
		write_user(user,nosuchuser);
		destruct_user(user2,0);
		return;
		}
	if (user2->level>=user->level) {
		write_user(user,"You cannot do this to a user of equal or higher level than yourself.\n");
		snprintf(text,sizeof(text),"%s tried to toggle your charecho!\n",user->name);
		send_mail(user,user2->name,text,0);
		destruct_user(user2,0);
		return;
		}
	user2->socket=5;
	sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
	if (!user2->charmode_echo) {
		snprintf(text,sizeof(text),"%s's echoing for character mode clients ON.\n",user2->name);
		write_user(user,text);
		user2->charmode_echo=1;
		save_user_details(user2,0);
		destruct_user(user2,0);
		return;
		}
	user2->charmode_echo=0;
	snprintf(text,sizeof(text),"%s's echoing for character mode clients OFF.\n",user2->name);
	write_user(user,text);
	save_user_details(user2,0);
	destruct_user(user2,0);
	}
}

/*** Free a hung socket ***/
void clearline(user)
UR_OBJECT user;
{
int i=0,sock;
UR_OBJECT user2;

if (word_count<2 || !isnumber(word[1])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <line>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <line>\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
sock=atoi(word[1]);
for(user2=user_first;user2;user2=user2->next) if (user2->type!=CLONE_TYPE && user2->socket==sock) { ++i; break; }
if (!i) {
	write_user(user,"That line is not currently active.\n");
	return;
	}
if (!user2->login) {
	write_user(user,"You cannot clear the line of a logged in user.\n");
	return;
	}
write_user(user2,"\n");
snprintf(text,sizeof(text),"%s cleared line %d.\n",user->name,sock);
write_syslog(text,1);
disconnect_user(user2);
snprintf(text,sizeof(text),"Line %d cleared.\n",sock);
write_user(user,text);
destructed=0;
}

/*** Print what sockets are active and who is on said socket ***/
void print_sockets(user)
UR_OBJECT user;
{
int cnt=0;
UR_OBJECT user2;

for(user2=user_first;user2;user2=user2->next) {
	if (user2->socket<0 || !user2->login) continue;
	if (++cnt==1) write_user(user,"Currently active sockets:\n");
	snprintf(text,sizeof(text),"Line ~OL%i~RS - ~OL~FY[~RSLogin stage ~OL~FM%d~RS~OL~FY]~RS: ~OL~FB%s\n",user2->socket,user2->login,user2->site);
	write_user(user,text);
	}
if (!cnt) write_user(user,"No one currently logging in... Gee, what a surprise:P\n");
}

/*** Write text straight to socket ***/
void writetosock(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
char buff[OUT_BUFF_SIZE],*str;
int buffpos=0,i,j,sock;
UR_OBJECT user2;

if (word_count<3 || !isnumber(word[1])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <socket> <text>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <socket> <text>\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
sock=atoi(word[1]);
for(user2=user_first;user2;user2=user2->next) if (user2->type!=CLONE_TYPE && user2->socket==sock) { ++i; break; }
if (!i) {
	write_user(user,"That socket is not currently active.\n");
	return;
	}
str=inpstr;
strncat(str,"\n",ARR_SIZE);
while(*str) {
	j=0;
	if (*str=='\n') {
		if (buffpos>OUT_BUFF_SIZE-6) {
			write(user2->socket,buff,buffpos);
			buffpos=0;
			}
		if (user2->color) {
			memcpy(buff+buffpos,"\033[0m",4); buffpos+=4;
			}
		*(buff+buffpos)='\n'; *(buff+buffpos+1)='\r';
		buffpos+=2; ++str;
		}
	else {
		if (*str=='~') {
			if (*(str+1)=='\\') { ++str; *(buff+buffpos)=*str++; ++buffpos; continue; }
			}
		if (*str=='\\') {
			if (*(str+1)=='~') {
				for(i=0;i<COLNUM;++i) {
					if (!strncmp(str+2,colcom[i],2)) {
						++str;
						*(buff+buffpos)=*str++;
						++buffpos;
						if (buffpos==OUT_BUFF_SIZE) {
							write(user2->socket,buff,buffpos);
							buffpos=0;
							}
						*(buff+buffpos)=*str++;
						++buffpos;
						if (buffpos==OUT_BUFF_SIZE) {
							write(user2->socket,buff,buffpos);
							buffpos=0;
							}
						*(buff+buffpos)=*str;
						++buffpos; ++str;
						if (buffpos==OUT_BUFF_SIZE) {
							write(user2->socket,buff,buffpos);
							buffpos=0;
							}
						++j; break;
						}
					}
				if (j) continue;
				}
			if (!strncmp(str+1,NAMESTRING,2) || !strncmp(str+1,"\\n",2)) {
				++str;
				*(buff+buffpos)=*str++;
				++buffpos;
				if (buffpos==OUT_BUFF_SIZE) {
					write(user2->socket,buff,buffpos);
					buffpos=0;
					}
				*(buff+buffpos)=*str;
				++buffpos; ++str;
				if (buffpos==OUT_BUFF_SIZE) {
					write(user2->socket,buff,buffpos);
					buffpos=0;
					}
				continue;
				}
			}
		if (!strncmp(str,NAMESTRING,2) && !user2->login) {
			if (buffpos>OUT_BUFF_SIZE-strlen(user2->name)) {
				write(user2->socket,buff,buffpos);
				buffpos=0;
				}
			memcpy(buff+buffpos,user2->name,strlen(user2->name));
			buffpos+=strlen(user2->name);
			++str; ++str;
			if (buffpos==OUT_BUFF_SIZE) {
				write(user2->socket,buff,buffpos);
				buffpos=0;
				}
			continue;
			}
		if (!strncmp(str,"\\n",2)) {
			if (buffpos>OUT_BUFF_SIZE-6) {
				write(user2->socket,buff,buffpos);
				buffpos=0;
				}
			if (user2->color) {
				memcpy(buff+buffpos,"\033[0m",4); buffpos+=4;
				}
			*(buff+buffpos)='\n'; *(buff+buffpos+1)='\r';
			buffpos+=2;
			++str; ++str;
			if (buffpos==OUT_BUFF_SIZE) {
				write(user2->socket,buff,buffpos);
				buffpos=0;
				}
			continue;
			}
		if (*str=='~') {
			if (buffpos>OUT_BUFF_SIZE-6) {
				write(user2->socket,buff,buffpos);
				buffpos=0;
				}
			++str;
			for(i=0;i<COLNUM;++i) {
				if (!strncmp(str,colcom[i],2)) {
					if (user2->color) {
						memcpy(buff+buffpos,colcode[i],strlen(colcode[i]));
						buffpos+=strlen(colcode[i]);
						}
					++str; ++str;
					if (buffpos==OUT_BUFF_SIZE) {
						write(user2->socket,buff,buffpos);
						buffpos=0;
						}
					++j; break;
					}
				}
			if (j) continue;
			*(buff+buffpos)=*(--str);
			++buffpos; ++str;
			if (buffpos==OUT_BUFF_SIZE) {
				write(user2->socket,buff,buffpos);
				buffpos=0;
				}
			continue;
			}
		*(buff+buffpos)=*str;
		++buffpos; ++str;
		}
	if (buffpos==OUT_BUFF_SIZE) {
		write(user2->socket,buff,buffpos);
		buffpos=0;
		}
	}
if (buffpos) write(user2->socket,buff,buffpos);
reset_term(user2);
snprintf(text,sizeof(text),"Text wrote to socket %d.\n",sock);
write_user(user,text);
}

/*** Close all sockets not used by users ***/
void close_allsock(user,which)
UR_OBJECT user;
int which;
{
int cnt,i=7;
NL_OBJECT nl;
UR_OBJECT user2;

while(i<245) {
	cnt=0;
	for(user2=user_first;user2;user2=user2->next) if (user2->socket==i) ++cnt;
	for(nl=nl_first;nl;nl=nl->next) if (nl->socket==i) ++cnt;
	if (!cnt) close(i);
	++i;
	}
if (!which) write_user(user,"All non-used sockets closed.\n");
}

/*** Change whether a room's access is fixed or not ***/
void change_room_fix(user,fix)
UR_OBJECT user;
int fix;
{
RM_OBJECT room;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
if (fix) {
	if (room->access & 2) {
		write_user(user,"That rooms access is already fixed.\n");
		return;
		}
	snprintf(text,sizeof(text),"Access for room %s is now FIXED.\n",room->name);
	write_user(user,text);
	snprintf(text,sizeof(text),"%s changed room %s to FIXED access.\n",user->name,room->name);
	write_syslog(text,1);
	room->access+=2;
	return;
	}
if (!(room->access & 2)) {
	write_user(user,"That rooms access is already unfixed.\n");
	return;
	}
snprintf(text,sizeof(text),"Access for room %s is now UNFIXED.\n",room->name);
write_user(user,text);
snprintf(text,sizeof(text),"%s changed room %s to UNFIXED access.\n",user->name,room->name);
write_syslog(text,1);
room->access-=2;
}

/*** View the system log ***/
void viewlog(user)
UR_OBJECT user;
{
char c;
int cnt=0,cnt2=0,lines;
FILE *fp;

if (word_count==1) {
	write_user(user,"\n~BB*** System log ***\n");
	more(user,SYSLOG,0);
	return;
	}
if (!isnumber(word[1])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<lines from the end>]\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s [<lines from the end>]\n",command[com_num]+1);
	write_user(user,text);
	return;
	}
if (!(fp=fopen(SYSLOG,"r"))) { write_user(user,"\n~BB*** System log ***\n"); write_user(user,"The system log is empty.\n"); return; }
lines=atoi(word[1]);
cnt=newline_count(SYSLOG,1);
if (cnt<lines) {
	if (cnt==1) snprintf(text,sizeof(text),"There is only %d line in the log.\n",cnt);
	else snprintf(text,sizeof(text),"There are only %d lines in the log.\n",cnt);
	write_user(user,text);
	fclose(fp);
	return;
	}
if (cnt==lines) {
	fclose(fp);
	write_user(user,"\n~BB*** System log ***\n");
	more(user,SYSLOG,0);
	return;
	}
fseek(fp,0,0);
c=getc(fp);
while(!feof(fp)) {
	if (c=='\n') ++cnt2;
	c=getc(fp);
	if (cnt2==cnt-lines) {
		if (lines==1) snprintf(text,sizeof(text),"\n~BB*** System log (last %d line) ***\n",lines);
		else snprintf(text,sizeof(text),"\n~BB*** System log (last %d lines) ***\n",lines);
		write_user(user,text);
		user->filepos=ftell(fp)-1;
		user->origpos=ftell(fp)-1;
		fclose(fp);
		more(user,SYSLOG,0);
		return;
		}
	}
fclose(fp);
snprintf(text,sizeof(text),"%s: Line count error.\n",syserror);
write_user(user,text);
write_syslog("ERROR: Line count error in viewlog().\n",0);
}

/*** View the site log ***/
void viewsite(user)
UR_OBJECT user;
{
char c;
int cnt=0,cnt2=0,lines;
FILE *fp;

if (word_count==1) {
	write_user(user,"\n~BB~OL~FY*** Site log ***\n");
	more(user,SITELOG,0);
	return;
	}
if (!isnumber(word[1])) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s [<lines from the end>]\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s [<lines from the end>]\n",command[com_num]+1);
	write_user(user,text);
	return;
	}
if (!(fp=fopen(SITELOG,"r"))) { write_user(user,"\n~BB~OL~FY*** Site log ***\n"); write_user(user,"The system log is empty.\n"); return; }
lines=atoi(word[1]);
cnt=newline_count(SITELOG,1);
if (cnt<lines) {
	if (cnt==1) snprintf(text,sizeof(text),"There is only %d line in the log.\n",cnt);
	else snprintf(text,sizeof(text),"There are only %d lines in the log.\n",cnt);
	write_user(user,text);
	fclose(fp);
	return;
	}
if (cnt==lines) {
	fclose(fp);
	write_user(user,"\n~BB~OL~FY*** Site log ***\n");
	more(user,SITELOG,0);
	return;
	}
fseek(fp,0,0);
c=getc(fp);
while(!feof(fp)) {
	if (c=='\n') ++cnt2;
	c=getc(fp);
	if (cnt2==cnt-lines) {
		if (lines==1) snprintf(text,sizeof(text),"\n~BB~OL~FY*** Site log (last %d line) ***\n",lines);
		else snprintf(text,sizeof(text),"\n~BB~OL~FY*** Site log (last %d lines) ***\n",lines);
		write_user(user,text);
		user->filepos=ftell(fp)-1;
		user->origpos=ftell(fp)-1;
		fclose(fp);
		more(user,SITELOG,0);
		return;
		}
	}
fclose(fp);
snprintf(text,sizeof(text),"%s: Line count error.\n",syserror);
write_user(user,text);
write_syslog("ERROR: Line count error in viewsite().\n",0);
}

/*** A newbie is requesting an account. Get his email address off him so we
     can validate who he is before we promote him and let him loose as a
     proper user ***/
void account_request(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (user->level>PRIVATE) {
	write_user(user,"This command is for new users only, you already have a full account.\n");
	return;
	}
if (user->accreq) {
	write_user(user,"You have already requested an account.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <an email address we can contact you on + any relevant info>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <an email address we can contact you on + any relevant info>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
snprintf(text,sizeof(text),"ACCOUNT REQUEST from %s: %s.\n",user->name,inpstr);
write_syslog(text,1);
snprintf(text,sizeof(text),"~OLSYSTEM:~RS %s has made a request for an account.\n",user->name);
write_wiz(COLONEL,text,NULL);
write_user(user,"Account request logged.\n");
user->accreq=1;
}

/*** Clear the conversation buffer in all rooms ***/
void clear_allconv(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN];
RM_OBJECT room;

for(room=room_first;room;room=room->next) {
	snprintf(filename,sizeof(filename),"%s/%s.U",DATAFILES,room->name);
	unlink(filename);
	}
write_user(user,"Buffer on all rooms cleared.\n");
}

/*** Clone a user in another room ***/
void create_clone(user)
UR_OBJECT user;
{
char *name;
int cnt=0;
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<2) room=user->room;
else if (!(room=get_room(user,word[1]))) return;
if ((room->access & 1) && user->level<COMMANDER) {
	snprintf(text,sizeof(text),"Unable to create a clone in the %s.\n",room->name);
	write_user(user,text);
	return;
	}
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->owner==user) {
		if (user2->room==room) {
			snprintf(text,sizeof(text),"You already have a clone in the %s.\n",room->name);
			write_user(user,text);
			return;
			}
		if (++cnt==max_clones) {
			write_user(user,"You already have the maximum number of clones allowed.\n");
			return;
			}
		}
	}
if (!(user2=create_user())) {
	snprintf(text,sizeof(text),"%s: Unable to create copy.\n",syserror);
	write_user(user,text);
	write_syslog("ERROR: Unable to create user copy in clone().\n",0);
	return;
	}
user2->type=CLONE_TYPE;
user2->socket=user->socket;
user2->room=room;
user2->owner=user;
sntrncpy(user2->name,user->name,sizeof(user2->name));
if (!load_user_details(user2)) {
	snprintf(text,sizeof(text),"%s: Unable to reload your details.\n",syserror);
	write_user(user,text);
	snprintf(text,sizeof(text),"ERROR: Unable to reload %s's details in clone().\n",user->name);
	write_syslog(text,0);
	return;
	}
sntrncpy(user2->desc,"(CLONE)",sizeof(user2->desc));
if (room==user->room) write_user(user,"You whisper a haunting spell and a clone is created here.\n");
else {
	snprintf(text,sizeof(text),"You whisper a haunting spell and a clone is created in the %s.\n",room->name);
	write_user(user,text);
	}
if (!user->hid) {
	if (user->vis) name=user->morphed; else name=invisname;
	snprintf(text,sizeof(text),"%s whispers a haunting spell...\n",name);
	write_room_except(user->room,text,user,NULL,0,NULL);
	snprintf(text,sizeof(text),"A clone of %s appears in a swirling magical mist!\n",name);
	write_room_except(room,text,user,NULL,0,NULL);
	}
}

/*** Destroy user clone ***/
void destroy_clone(user)
UR_OBJECT user;
{
char *name,*name2;
RM_OBJECT room;
UR_OBJECT user2,user3;

if (word_count<2) room=user->room;
else if (!(room=get_room(user,word[1]))) return;
if (word_count>2) {
	if (!(user3=get_user2(user,word[2]))) {
		write_user(user,notloggedon);
		return;
		}
	if (check_multiple(user,word[2])>1) {
		multiple(user,word[2]);
		return;
		}
	if (user3->level>=user->level) {
		write_user(user,"You cannot destroy the clone of a user of an equal or higher level.\n");
		return;
		}
	}
else user3=user;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->room==room && user2->owner==user3) {
		destruct_user(user2,0);
		reset_access(room);
		write_user(user,"You whisper a sharp spell and the clone is destroyed.\n");
		if (!user->hid) {
			if (user->vis) name=user->morphed; else name=invisname;
			if (user3->vis) name2=user3->morphed; else name2=invisname;
			snprintf(text,sizeof(text),"%s whispers a sharp spell...\n",name);
			write_room_except(user->room,text,user,NULL,0,NULL);
			snprintf(text,sizeof(text),"The clone of %s shimmers and vanishes.\n",name2);
			write_room(room,text);
			}
		if (user3!=user) {
			snprintf(text,sizeof(text),"~OLSYSTEM:~RS %s has destroyed your clone in the %s.\n",user->name,room->name);
			write_user(user3,text);
			}
		destructed=0;
		return;
		}
	}
if (user3==user) snprintf(text,sizeof(text),"You do not have a clone in the %s.\n",room->name);
else snprintf(text,sizeof(text),"%s does not have a clone in the %s.\n",user3->name,room->name);
write_user(user,text);
}

/*** Destroy all user clones ***/
void destroy_allclones(user)
UR_OBJECT user;
{
RM_OBJECT room;
UR_OBJECT user2,user3;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <owner>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <owner>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user3=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user3->level>=user->level) {
	write_user(user,"You cannot destroy the clones of a user of an equal or higher level.\n");
	return;
	}
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->level==GENERAL && user->level<GENERAL) continue;
	if (user2->type==CLONE_TYPE && !strcmp(user2->name,user3->name)) {
		room=user2->room;
		destruct_user(user2,0);
		reset_access(room);
		}
	}
write_user(user,"You whisper a sharp spell and the clones are destroyed.\n");
if (user3!=user) {
	snprintf(text,sizeof(text),"~OLSYSTEM:~RS %s has destroyed all your clones!\n",user->name);
	write_user(user3,text);
	}
destructed=0;
}

/*** Show user's own clones ***/
void myclones(user)
UR_OBJECT user;
{
int cnt=0;
UR_OBJECT user2;

for(user2=user_first;user2;user2=user2->next) {
	if (user2->type!=CLONE_TYPE || user2->owner!=user) continue;
	if (++cnt==1) write_user(user,"\nYou have clones in the following rooms:\n");
	snprintf(text,sizeof(text),"    %s\n",user2->room);
	write_user(user,text);
	}
if (!cnt) write_user(user,"You have no clones.\n");
else write_user(user,"\n");
}

/*** Show all clones on the system ***/
void allclones(user)
UR_OBJECT user;
{
int cnt=0;
UR_OBJECT user2;

for(user2=user_first;user2;user2=user2->next) {
	if (user2->type!=CLONE_TYPE || !user2->room) continue;
	if (++cnt==1) {
		if (!user->tdiff) snprintf(text,sizeof(text),"~FR\n               *** Current clones on %s, %s %d, %02d:%02d ***\n\n",day[twday],month[tmonth],tmday,thour,tmin);
		else snprintf(text,sizeof(text),"~FR\n               *** Current clones on %s, %s %d, %02d:%02d ***\n\n",day[user->twday],month[user->tmonth],user->tmday,user->thour,user->tmin);
		write_user(user,text);
		write_user(user,"Name                 Area\n");
		write_user(user,"\n");
		}
	snprintf(text,sizeof(text),"%-*s %s\n",USER_NAME_LEN,user2->name,user2->room->name);
	write_user(user,text);
	}
if (!cnt) write_user(user,"There are no clones on the system.\n");
else {
	if (cnt==1) snprintf(text,sizeof(text),"\nTotal of %d clone.\n\n",cnt);
	else snprintf(text,sizeof(text),"\nTotal of %d clones.\n\n",cnt);
	write_user(user,text);
	}
}

/*** User swaps places with his own clone. All we do is swap the rooms the
     objects are in ***/
void clone_switch(user)
UR_OBJECT user;
{
char *name;
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room clone is in>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room clone is in>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->room==room && user2->owner==user) {
		if (user->vis) name=user->morphed; else name=invisname;
		write_user(user,"\nYou experience a strange sensation...\n");
		user2->room=user->room;
		user->room=room;
		snprintf(text,sizeof(text),"The clone of %s comes alive!\n",name);
		write_room_except(user->room,text,user,NULL,0,NULL);
		snprintf(text,sizeof(text),"%s turns into a clone!\n",name);
		write_room_except(user2->room,text,user2,NULL,0,NULL);
		look(user);
		return;
		}
	}
write_user(user,"You do not have a clone in that room.\n");
}

/*** Make a clone speak ***/
void clone_say(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<3) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room clone is in>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room clone is in>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->room==room && user2->owner==user) {
		say(user2,inpstr);
		return;
		}
	}
write_user(user,"You do not have a clone in that room.\n");
}

/*** Set what a clone will hear, either all speech, just bad language
     or nothing ***/
void clone_hear(user)
UR_OBJECT user;
{
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<3 || (strcasecmp(word[2],"all") && strcasecmp(word[2],"swears") && strcasecmp(word[2],"nothing"))) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room clone is in> all/swears/nothing\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room clone is in> all/swears/nothing\n",command[com_num]+1);
	write_user(user,text);
	word_count=1;
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->room==room && user2->owner==user) break;
	}
if (!user2) {
	write_user(user,"You do not have a clone in that room.\n");
	return;
	}
if (!strcasecmp(word[2],"all")) {
	user2->clone_hear=CLONE_HEAR_ALL;
	write_user(user,"Clone will hear everything.\n");
	return;
	}
if (!strcasecmp(word[2],"swears")) {
	user2->clone_hear=CLONE_HEAR_SWEARS;
	write_user(user,"Clone will only hear swearing.\n");
	return;
	}
user2->clone_hear=CLONE_HEAR_NOTHING;
write_user(user,"Clone will hear nothing.\n");
}

/*** Review the buffer in the room the clone is in ***/
void clone_rev(user)
UR_OBJECT user;
{
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room clone is in> all/swears/nothing\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room clone is in> all/swears/nothing\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->room==room && user2->owner==user) break;
	}
if (!user2) {
	write_user(user,"You do not have a clone in that room.\n");
	return;
	}
sntrncpy(word[1],user2->room->name,sizeof(word[1]));
review(user);
}

/*** Clear the review buffer in the room the clone is in ***/
void clone_revclr(user)
UR_OBJECT user;
{
RM_OBJECT room;
UR_OBJECT user2;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room clone is in> all/swears/nothing\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room clone is in> all/swears/nothing\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
for(user2=user_first;user2;user2=user2->next) {
	if (user2->type==CLONE_TYPE && user2->room==room && user2->owner==user) break;
	}
if (!user2) {
	write_user(user,"You do not have a clone in that room.\n");
	return;
	}
clear_conv(room);
write_user(user,"Buffer where clone is cleared.\n");
}

/*** Stat a remote system ***/
void remote_stat(user)
UR_OBJECT user;
{
NL_OBJECT nl;
RM_OBJECT room;

if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <room service is linked to>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <room service is linked to>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(room=get_room(user,word[1]))) return;
if (!(nl=room->netlink)) {
	write_user(user,"That room is not linked to a service.\n");
	return;
	}
if (nl->stage!=2) {
	write_user(user,"Not (fully) connected to service.\n");
	return;
	}
if (nl->ver_major<=3 && nl->ver_minor<1) {
	write_user(user,"The NUTS version of that service does not support this facility.\n");
	return;
	}
snprintf(text,sizeof(text),"RSTAT %s\n",user->name);
write_sock(nl->socket,text);
write_user(user,"Request sent.\n");
}

/*** Switch swearing ban on and off ***/
void swban(user)
UR_OBJECT user;
{
if (!ban_swearing) {
	ban_swearing=1;
	write_user(user,"Swearing ban ON.\n");
	snprintf(text,sizeof(text),"%s switched swearing ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_swearing=0;
write_user(user,"Swearing ban OFF.\n");
snprintf(text,sizeof(text),"%s switched swearing ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch smailing on and off ***/
void bansmailing(user)
UR_OBJECT user;
{
if (!ban_smailing) {
	ban_smailing=1;
	write_user(user,"Smailing ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched smailing ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_smailing=0;
write_user(user,"Smailing ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched smailing ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch pictells on and off ***/
void banpictells(user)
UR_OBJECT user;
{
if (!ban_pictells) {
	ban_pictells=1;
	write_user(user,"Pictell ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched pictell ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_pictells=0;
write_user(user,"Pictell ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched pictell ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch greets on and off ***/
void bangreets(user)
UR_OBJECT user;
{
if (!ban_greets) {
	ban_greets=1;
	write_user(user,"Greets ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched greets ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_greets=0;
write_user(user,"Greets ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched greets ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch shouting on and off ***/
void banshouts(user)
UR_OBJECT user;
{
if (!ban_shouting) {
	ban_shouting=1;
	write_user(user,"Shouting ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched shouting ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_shouting=0;
write_user(user,"Shouting ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched shouting ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch quitting on and off ***/
void banquits(user)
UR_OBJECT user;
{
if (!ban_quitting) {
	ban_quitting=1;
	write_user(user,"Quitting ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched quitting ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_quitting=0;
write_user(user,"Quitting ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched quitting ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Open and close hunting season ***/
void banhunting(user)
UR_OBJECT user;
{
if (!ban_hunting) {
	ban_hunting=1;
	write_user(user,"Hunting season is now CLOSED.\n");
	snprintf(text,sizeof(text),"%s switched hunting ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_hunting=0;
write_user(user,"Hunting season is now OPEN.\n");
snprintf(text,sizeof(text),"%s switched hunting ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch suicides on and off ***/
void bansuicides(user)
UR_OBJECT user;
{
if (!ban_suicides) {
	ban_suicides=1;
	write_user(user,"Suicide ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched suicide ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_suicides=0;
write_user(user,"Suicide ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched suicide ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch lilmouse murders on and off ***/
void banwillkill(user)
UR_OBJECT user;
{
if (!ban_willkill) {
	ban_willkill=1;
	write_user(user,"lilmouse murder ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched lilmouse murder ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_willkill=0;
write_user(user,"lilmouse murder ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched lilmouse murder ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch games playing on and off ***/
void bangames(user)
UR_OBJECT user;
{
if (!ban_games) {
	ban_games=1;
	write_user(user,"Game ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched game ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_games=0;
write_user(user,"Game ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched game ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Turn off system mailing to users for adding time, promos, etc. ***/
void sysmail(user)
UR_OBJECT user;
{
if (!sys_mail) {
	sys_mail=1;
	write_user(user,"System mail will no longer be sent.\n");
	snprintf(text,sizeof(text),"%s turned off system mailing.\n",user->name);
	write_syslog(text,1);
	return;
	}
sys_mail=0;
write_user(user,"System mail will now be sent.\n");
snprintf(text,sizeof(text),"%s turned on system mailing.\n",user->name);
write_syslog(text,1);
}

/*** Switch difficult logins on and off ***/
void bandifflogins(user)
UR_OBJECT user;
{
if (!difflogin) {
	difflogin=1;
	write_user(user,"Difficult logins turned ON.\n");
	snprintf(text,sizeof(text),"%s switched difficult logins ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
difflogin=0;
write_user(user,"Difficult logins turned OFF.\n");
snprintf(text,sizeof(text),"%s switched difficult logins OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch who logins on and off ***/
void banwhologins(user)
UR_OBJECT user;
{
if (!whologin) {
	whologin=1;
	write_user(user,"Who logins turned ON.\n");
	snprintf(text,sizeof(text),"%s switched who logins ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
whologin=0;
write_user(user,"Who logins turned OFF.\n");
snprintf(text,sizeof(text),"%s switched who logins OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch hehe on and off ***/
void banhehehe(user)
UR_OBJECT user;
{
if (!hehehe) {
	hehehe=1;
	write_user(user,"Hehehe ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched hehehe ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
hehehe=0;
write_user(user,"Hehehe ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched hehehe ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch garbling on and off ***/
void garbletime(user)
UR_OBJECT user;
{
if (!garbled) {
	garbled=1;
	write_user(user,"Garbling turned ON.\n");
	snprintf(text,sizeof(text),"%s switched garbling ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
garbled=0;
write_user(user,"Garbling turned OFF.\n");
snprintf(text,sizeof(text),"%s switched garbling OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch atmospherics on and off ***/
void toggle_atmos(user)
UR_OBJECT user;
{
if (!atmos) {
	atmos=1;
	write_user(user,"Atmospherics turned ON.\n");
	snprintf(text,sizeof(text),"%s switched atmospherics ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
atmos=0;
write_user(user,"Atmospherics turned OFF.\n");
snprintf(text,sizeof(text),"%s switched atmospherics OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch clock thingy on and off ***/
void banhour(user)
UR_OBJECT user;
{
if (!hour) {
	hour=1;
	write_user(user,"Hour ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched hour ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
hour=0;
write_user(user,"Hour ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched hour ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch smoking on and off ***/
void bansmoking(user)
UR_OBJECT user;
{
if (!ban_smoking) {
	ban_smoking=1;
	write_user(user,"Smoking ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched smoking ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_smoking=0;
write_user(user,"Smoking ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched smoking ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Switch socials on and off ***/
void bansocials(user)
UR_OBJECT user;
{
if (!ban_socials) {
	ban_socials=1;
	write_user(user,"Socials ban turned ON.\n");
	snprintf(text,sizeof(text),"%s switched socials ban ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
ban_socials=0;
write_user(user,"Socials ban turned OFF.\n");
snprintf(text,sizeof(text),"%s switched socials ban OFF.\n",user->name);
write_syslog(text,1);
}

/*** Make users login upstairs/downstairs ***/
void login_place(user)
UR_OBJECT user;
{
if (word_count<2 && !lplace) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s upstairs/downstairs\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s upstairs/downstairs\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (word_count>1) {
	if (!strncasecmp(word[1],"upstairs",strlen(word[1]))) {
		if (loginplace && lplace) {
			write_user(user,"Users are already logging in upstairs.\n");
			return;
			}
		lplace=1;
		loginplace=1;
		write_user(user,"Users will now login upstairs.\n");
		snprintf(text,sizeof(text),"%s made users login upstairs.\n",user->name);
		write_syslog(text,1);
		return;
		}
	else if (!strncasecmp(word[1],"downstairs",strlen(word[1]))) {
		if (!loginplace && lplace) {
			write_user(user,"Users are already logging in downstairs.\n");
			return;
			}
		lplace=1;
		loginplace=0;
		write_user(user,"Users will now login downstairs.\n");
		snprintf(text,sizeof(text),"%s made users login downstairs.\n",user->name);
		write_syslog(text,1);
		return;
		}
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s upstairs/downstairs\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s upstairs/downstairs\n",command[com_num]+1);
	write_user(user,text);
	return;
	}
lplace=0;
loginplace=0;
write_user(user,"User logins will now be random.\n");
snprintf(text,sizeof(text),"%s made user logins random.\n",user->name);
write_syslog(text,1);
}

/*** Super user ***/
void super_user(user,which)
UR_OBJECT user;
int which;
{
if (user->level>GENERAL) { user->level=GENERAL; return; }
if (!which) {
	write_user(user,"Enter the super-user password: ");
	echo_off(user);
	user->misc_op=106;
	return;
	}
if (user->level==GENERAL) ++user->level;
}

/*** Toggle gossamer ***/
void toggle_gossamer(user)
UR_OBJECT user;
{
UR_OBJECT user2;

if (word_count<2 || user->level<CAPTAIN) {
	if (!user->gossamer) {
		user->gossamer=1;
		write_user(user,"Gossamer comes to visit.\n");
		return;
		}
	user->gossamer=0;
	write_user(user,"You tuck Gossamer into bed.\n");
	return;
	}
else {
	if ((user2=get_user2(user,word[1]))) {
		if (user2==user) {
			snprintf(text,sizeof(text),"Nah..\n");
			write_user(user,text);
			return;
			}
		if (user2->level>=user->level) {
			write_user(user,"Yeah.. sure.\n");
			snprintf(text,sizeof(text),"%s tried to gossamer you!\n",user->name);
			write_user(user2,text);
			return;
			}
		if (!user2->gossamer) {
			user2->gossamer=1;
			snprintf(text,sizeof(text),"Gossamer goes to visit %s.\n",user2->name);
			write_user(user,text);
			write_user(user2,"Gossamer comes to visit.\n");
			snprintf(text,sizeof(text),"%s sends Gossamer to visit %s!\n",user->name,user2->name);
			write_syslog(text,1);
			return;
			}
		user2->gossamer=0;
		write_user(user,"You tuck Gossamer into bed.\n");
		write_user(user2,"Gossamer gets tucked into bed, thank god.\n");
		snprintf(text,sizeof(text),"%s tucks Gossamer into bed at %s's house!\n",user->name,user2->name);
		write_syslog(text,1);
		return;
		}
	else {
		if (!(user2=create_user())) {
			snprintf(text,sizeof(text),"%s: unable to create temporary user session.\n",syserror);
			write_user(user,text);
			write_syslog("ERROR: Unable to create temporary user session in toggle_gossamer().\n",0);
			return;
			}
		sntrncpy(user2->name,word[1],sizeof(user2->name));
		if (!load_user_details(user2)) {
			write_user(user,nosuchuser);
			destruct_user(user2,0);
			return;
			}
		if (user2->level>=user->level) {
			write_user(user,"Yeah.. sure.\n");
			snprintf(text,sizeof(text),"%s tried to gossamer you!\n",user->name);
			send_mail(user,user2->name,text,0);
			destruct_user(user2,0);
			return;
			}
		user2->socket=5;
		sntrncpy(user2->site,user2->last_site,sizeof(user2->site));
		if (!user2->gossamer) {
			user2->gossamer=1;
			snprintf(text,sizeof(text),"Gossamer goes to visit %s.\n",user2->name);
			write_user(user,text);
			snprintf(text,sizeof(text),"%s sends Gossamer to visit %s!\n",user->name,user2->name);
			write_syslog(text,1);
			save_user_details(user2,0);
			destruct_user(user2,0);
			return;
			}
		user2->gossamer=0;
		write_user(user,"You tuck Gossamer into bed.\n");
		snprintf(text,sizeof(text),"%s tucks Gossamer into bed at %s's house!\n",user->name,user2->name);
		write_syslog(text,1);
		save_user_details(user2,0);
		destruct_user(user2,0);
		}
	}
}

/*** Gossamer ***/
void gossamertime(user)
UR_OBJECT user;
{
if (!gossamer) {
	gossamer=1;
	write_user(user,"Gossamer comes to visit HOLE.\n");
	snprintf(text,sizeof(text),"%s let Gossamer loose on HOLE.\n",user->name);
	write_syslog(text,1);
	return;
	}
gossamer=0;
write_user(user,"You tuck Gossamer into bed, safe from the HOLE users.\n");
snprintf(text,sizeof(text),"%s tucked Gossamer into bed, safe from the HOLE users.\n",user->name);
write_syslog(text,1);
}

/*** Switch logins on and off ***/
void banlogins(user)
UR_OBJECT user;
{
if (!nologin) {
	nologin=1;
	write_user(user,"No logins turned ON.\n");
	snprintf(text,sizeof(text),"%s switched no logins ON.\n",user->name);
	write_syslog(text,1);
	return;
	}
nologin=0;
write_user(user,"No logins turned OFF.\n");
snprintf(text,sizeof(text),"%s switched no logins OFF.\n",user->name);
write_syslog(text,1);
}

/*** Keep em upstairs or downstairs ***/
void stayput(user)
UR_OBJECT user;
{
if (!staythere) {
	staythere=1;
	write_user(user,"Upstairs/downstairs gateway removed.\n");
	snprintf(text,sizeof(text),"%s removed the upstairs/downstairs gateway.\n",user->name);
	write_syslog(text,1);
	return;
	}
staythere=0;
write_user(user,"Upstairs/downstairs gateway added.\n");
snprintf(text,sizeof(text),"%s added upstairs/downstairs gateway.\n",user->name);
write_syslog(text,1);
}

/*** Shake the hand of your friend ***/
void shake(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to shake yourself is the eleventh sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You reach out and shake %s's hand with all your might!\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s reaches over and shakes your hand!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s reaches out and shakes %s's hand madly!!\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
if (!strcmp(user2->name,"Lilmouse")) {
	write_user(user,"lilmouse reaches over and shakes your hand politely!\n");
	snprintf(text,sizeof(text),"%s reaches out and shakes %s's hand politely!\n",name1,name);
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
	}
}

/*** Huggle that special person ***/
void huggle(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (word_count<2) {
	write_user(user,"You huggle everyone in the room.\n");
	snprintf(text,sizeof(text),"%s huggles you with all of %s might!\n",name,gen1[user->gen]);
	write_room_except(user->room,text,user,NULL,0,NULL);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to hug yourself is the twelveth sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You huggle %s with all your might!\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s huggles you with all of %s might!\n",name,gen1[user->gen]);
write_user(user2,text);
snprintf(text,sizeof(text),"%s huggles %s with all of %s might!!\n",name,name1,gen1[user->gen]);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,NULL,0,NULL);
if (!strcmp(user2->name,"Lilmouse")) {
	write_user(user,"lilmouse huggles you with all of his might!\n");
	snprintf(text,sizeof(text),"%s huggles %s with all of %s might!\n",name1,name,gen1[user2->gen]);
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
	}
}

/*** Poke someone to get their attention ***/
void poke(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Poke who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to poke yourself is the fourteenth sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You poke %s with a needle!\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s pokes you with a needle!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s pokes %s with a needle!!\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,NULL,0,NULL);
if (!strcmp(user2->name,"Lilmouse")) {
	write_user(user,"lilmouse pokes you with a needle!\n");
	snprintf(text,sizeof(text),"%s pokes %s with a needle!!\n",name1,name);
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
	}
}

/*** Tickle that silly person ***/
void tickle(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Tickle who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to tickle yourself is the thirteenth sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You tickle %s with a giant feather!\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s tickles you with a giant feather!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s tickles %s with a giant feather!!\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,NULL,0,NULL);
if (!strcmp(user2->name,"Lilmouse")) {
	write_user(user,"lilmouse tickles you with a giant feather!\n");
	snprintf(text,sizeof(text),"%s tickles %s with a giant feather!!\n",name1,name);
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
	}
}

/*** Throw someone across the room ***/
void throw(user)
UR_OBJECT user;
{
char *name,*name1,name2[USER_NAME_LEN+1],an[3];
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Throw who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to throw yourself is the twenty-seventh sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
sntrncpy(name2,name1,sizeof(name2));
name2[0]=tolower(name2[0]);
if (strchr("aeiou",name2[0])) sntrncpy(an,"an",sizeof(an));
else sntrncpy(an,"a",sizeof(an));
snprintf(text,sizeof(text),"You pick up %s %s and throw %s across the room!\n",an,name1,gen2[user2->gen]);
write_user(user,text);
snprintf(text,sizeof(text),"%s picks you up and throws you across the room!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s picks up %s %s and throws %s across the room!\n",name,an,name1,gen2[user2->gen]);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
}

/*** High five someone ***/
void hifive(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Highfive who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to high five yourself is the twenty-fourth sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You high five %s!\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s high fives you!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s high fives %s!!\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
if (!strcmp(user2->name,"Lilmouse")) {
	write_user(user,"lilmouse high fives you!\n");
	snprintf(text,sizeof(text),"%s high fives %s!!\n",name1,name);
	write_room_except(user2->room,text,user,user2,0,NULL);
	if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
	}
}

/*** Muhaha ***/
void muhaha(user)
UR_OBJECT user;
{
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
write_user(user,"You laugh maniacally, causing everyone's hair to stand on end!\n");
if (user->vis) snprintf(text,sizeof(text),"%s laughs maniacally, causing everyone's hair to stand on end!\n",user->morphed);
else snprintf(text,sizeof(text),"A disembodied person laughs maniacally, causing everyone's hair to stand on end!\n");
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Confuse ***/
void confuse(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You succeed in confusing yourself totally!\n");
snprintf(text,sizeof(text),"%s succeeds in confusing %sself totally!!\n",name,gen2[user->gen]);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Eeeeeeeeeeeeeeeek ***/
void eek(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"Eeeeeeeeeeeeeeeeeeeeek!\n");
snprintf(text,sizeof(text),"%s leaps onto the table and screams 'Eeeeeeeeeeeeek'!\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Hmm ***/
void hmm(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"Trying to act pensive eh?\n");
snprintf(text,sizeof(text),"%s hmms in deep thought.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Sigh ***/
void sigh(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You sigh deeply.\n");
snprintf(text,sizeof(text),"%s sighs deeply.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Howl ***/
void howl(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"Arrrrrrrrrrooooooooooooouuuuuuuuuuu!\n");
snprintf(text,sizeof(text),"%s howls at the moon.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Idea ***/
void idea(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"What's on your mind?\n");
snprintf(text,sizeof(text),"A ~OL~FYlightbulb~RS lights up over the top of %s's head!\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Innocent ***/
void innocent(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You exclaim: they made me do it!\n");
snprintf(text,sizeof(text),"%s points a finger at %sself and says 'Who? ME!?'\n",name,gen2[user->gen]);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Mumble ***/
void mumble(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"What?\n");
snprintf(text,sizeof(text),"%s mumbles something unintelligible.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Panic ***/
void panic(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"~OLCalm down!~RS The answer is ~OL~FG4~FM2~RS!\n");
snprintf(text,sizeof(text),"%s begins to panic.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Rofl ***/
void rofl(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You roll on the floor, laughing hysterically.\n");
snprintf(text,sizeof(text),"%s rolls on the floor, laughing hysterically.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** SCREAM!!!!!!!!!!!!!!!!!!!! ***/
void scream(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"AAAAAAAAAAAAAAAAAAAARRRRRRRRRRRRRRRRRGGGGGGGGGGGGGGHHHHHHHHHH!!!!\n");
snprintf(text,sizeof(text),"%s screams ~FRbloody~RS murder!\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Shrug ***/
void shrug(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You shrug.\n");
snprintf(text,sizeof(text),"%s shrugs helplessly.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Sleep ***/
void sleepuser(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"ZZZZZZZZZZZZZzzzzzzzzzz........\n");
snprintf(text,sizeof(text),"%s falls down sleeping.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Swat a fly? ***/
void swat(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You swat at a fly that is buzzing annoyingly around your head.\n");
snprintf(text,sizeof(text),"%s swats at an annoying fly.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Tap ***/
void tapfoot(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"Impatient, aren't we?\n");
snprintf(text,sizeof(text),"%s taps %s foot in an impatient manner.\n",name,gen1[user->gen]);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Whistle ***/
void whistle(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"~OLYou??? ~FBInnocent?! ~FRHAH!\n");
snprintf(text,sizeof(text),"%s whistles innocently.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Wave ***/
void wave(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You wave happily.\n");
snprintf(text,sizeof(text),"%s waves happily.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Why me?? ***/
void whyme(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"Does someone have a vendetta against you or ~OLWHAT?!\n");
snprintf(text,sizeof(text),"%s throws %s hands up in the air and shouts 'WHY ME?!?!?!'\n",name,gen1[user->gen]);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Roll across the floor ***/
void rolls(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You go rolling across the floor.\n");
snprintf(text,sizeof(text),"You watch oddly as %s goes rolling across the floor.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Nod ***/
void nod(user)
UR_OBJECT user;
{
char *name;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
write_user(user,"You nod your head agreeingly.\n");
snprintf(text,sizeof(text),"%s nods.\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Eh ***/
void eh(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to eh yourself is the thirty-seventh sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
write_user(user,"Listen! sheesh!\n");
snprintf(text,sizeof(text),"%s didn't quite understand you.\n",name);
write_user(user2,text);
}

/*** Sledge ***/
void sledge(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to sledge yourself is the thirty-eighth sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
write_user(user,"~OL~FRTHWACK!\n");
snprintf(text,sizeof(text),"%s hits you over the head with a sledge hammer.\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s hits %s over the head with a sledge hammer.\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
}

/*** Tag a user ***/
void tag(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to tag yourself is the thirty-ninth sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You tag %s.\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s tags you and says '~OL~FYYou're it!~RS'\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s tags %s.\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
}

/*** Thank a user ***/
void thank(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to thank yourself is the fourtieth sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
write_user(user,"Are you truly grateful, or just saying that?\n");
snprintf(text,sizeof(text),"%s thanks you.\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s thanks %s.\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
}

/*** Violin :P ***/
void violin(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to play the violin for yourself is the fourty-first sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"Awww... POOR %s\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s plays 'My Heart Bleeds for You' on the world's smallest violin.\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s plays 'My Heart Bleeds for %s' on the world's smallest violin.\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
}

/*** Welcome to your life ***/
void welcome(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <user>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to welcome yourself is the fourty-second sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You welcome %s to this humble abode.\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s welcomes you.\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s welcomes %s.\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,user2,0,NULL);
}

/*** ACK something ***/
void ack(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (ban_shouting) {
	write_user(user,"Sorry, shouting has been turned off.\n");
	return;
	}
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"ACK what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
snprintf(text,sizeof(text),"You ack: %s\n",inpstr);
write_user(user,text);
if (user->vis) snprintf(text,sizeof(text),"~OL~FY%s acks:~RS %s\n",user->morphed,inpstr);
else snprintf(text,sizeof(text),"~FMA disembodied voice acks:~RS %s\n",inpstr);
write_room_except(user->room,text,user,NULL,1,NULL);
record(user->room,text);
}

/*** Beat the heck out of someone just for kicks ***/
void beat(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Beat who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to beat yourself is the sixteenth sign of madness.\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You beat %s with a crowbar!\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s beats you with a crowbar!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s beats %s with a crowbar!!\n",name,name1);
write_room_except(user2->room,text,user,user2,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Thwap Thwap Thwap ***/
void thwap(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Thwap who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to thwap yourself is the seventeenth sign of madness.\n");
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You thwap %s with a large blunt object!\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"\07%s thwaps you!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s thwaps %s with a large blunt object!!\n",name,name1);
write_room_except(user2->room,text,user2,user,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Be Right Back ***/
void brb(user)
UR_OBJECT user;
{
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
write_user(user,"You will be right back!\n");
if (user->vis) snprintf(text,sizeof(text),"%s will be right back!\n",user->morphed);
else snprintf(text,sizeof(text),"A disembodied person will be right back!!\n");
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Doh ***/
void doh(user)
UR_OBJECT user;
{
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
write_user(user,"Slapping your head, you say D'OH!!\n");
if (user->vis) snprintf(text,sizeof(text),"Slapping %s head, %s says D'OH!\n",gen1[user->gen],user->morphed);
else snprintf(text,sizeof(text),"Slapping %s head, A disembodied person says D'OH!!\n",gen1[user->gen]);
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Yippee ***/
void yippee(user)
UR_OBJECT user;
{
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
write_user(user,"Jumping out of the hole, you yell: YIPPEE YI YAY!!\n");
if (user->vis) snprintf(text,sizeof(text),"Jumping out of the hole, %s yells: YIPPEE YI YAY!!\n",user->morphed);
else snprintf(text,sizeof(text),"Jumping out of the hole, a disembodied person yells: YIPPEE YI YAY!!\n");
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Laugh out Loud ***/
void lol(user)
UR_OBJECT user;
{
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
write_user(user,"You laugh out loud! Ha Ha!\n");
if (user->vis) snprintf(text,sizeof(text),"%s laughs out loud! Ha ha ha!\n",user->morphed);
else snprintf(text,sizeof(text),"A disembodied person laughs out loud! Ha ha ha!!\n");
write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Kiss em ***/
void kiss(user)
UR_OBJECT user;
{
char *name,*name1;
UR_OBJECT user2;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Kiss who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Trying to kiss yourself is the 33rd sign of madness. (Besides that its sick!)\n");
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You give %s a real big kiss!\n",name1);
write_user(user,text);
snprintf(text,sizeof(text),"%s kisses you!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"%s gives %s a big kiss!\n",name,name1);
write_room_except(user2->room,text,user2,user,0,NULL);
if (user2->room!=user->room) write_room_except(user->room,text,user,NULL,0,NULL);
}

/*** Tinkle ***/
void tinkle(user)
UR_OBJECT user;
{
RM_OBJECT room;

if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
write_user(user,"You chant, I have to go pee!!\n");
if (user->vis) snprintf(text,sizeof(text),"%s needs to use the bathroom!\n",user->name);
else snprintf(text,sizeof(text),"A disembodied person needs to use the bathroom!!\n");
write_room_except(user->room,text,user,NULL,0,NULL);
room=get_room2("Bathroom");
move_user(user,room,2);
}

/*** Think ***/
void think(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <what you think>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <what you think>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (ban_swearing && contains_swearing(inpstr) && (!(user->room->access & 1))) {
	swore(user);
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
snprintf(text,sizeof(text),"You think . o @ O [ %s ]\n",inpstr);
write_user(user,text);
if (user->vis) snprintf(text,sizeof(text),"%s thinks . o @ O [ %s ]\n",user->morphed,inpstr);
else snprintf(text,sizeof(text),"A disembodied person thinks . o @ O [ %s ]\n",inpstr);
write_room_except(user->room,text,user,NULL,0,NULL);
record(user->room,text);
}

/*** Shout think ***/
void sthink(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (ban_shouting) {
	write_user(user,"Sorry, shouting has been turned off.\n");
	return;
	}
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	write_user(user,"Shout think what?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr)) {
	swore(user);
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
snprintf(text,sizeof(text),"You shout think: . o @ O [ %s ]\n",inpstr);
write_user(user,text);
if (user->vis) snprintf(text,sizeof(text),"! %s thinks: . o @ O [ %s ]\n",user->morphed,inpstr);
else snprintf(text,sizeof(text),"A disembodied voice thinks:!~[ %s ]\n",inpstr);
write_room_except(NULL,text,user,NULL,1,user);
snprintf(text,sizeof(text),"%s thinks: ~. o O [ %s ]\n",user->morphed,inpstr);
recordsh(user,text);
}

/*** Death puke a user ***/
void puke(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],*name,*name1;
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Puke on who?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"On yourself? Are ya NUTS?\n");
	return;
	}
if (user->level>=GENERAL) {
	write_user(user,"I can't let you do that. It's not right.\n");
	return;
	}
/* if (user2->level>user->level) {
	write_user(user,"You cannot puke on that user!\n");
	snprintf(text,sizeof(text),"%s tried to puke on you!\n",user->name);
	write_user(user2,text);
	return;
	} */
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (ban_quitting || user->frozen) {
	write_user(user,"Umm, nope.\n");
	return;
	}
if (user->vis) name=user->morphed; else name=invisname;
if (user2->vis) name1=user2->morphed; else name1=invisname;
snprintf(text,sizeof(text),"You puke on %s\n",user2->morphed);
write_user(user,text);
snprintf(text,sizeof(text),"%s attempts to puke on %s\n",name,name1);
write_room_except(user->room,text,user,NULL,0,NULL);
snprintf(text,sizeof(text),"%s attempts to puke on you!!!\n",name);
write_user(user2,text);
snprintf(text,sizeof(text),"A strong gust of wind blows the death puke back on %s!!!\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
write_user(user,"A strong gust of wind blows the death puke back on you!!\n");
snprintf(text,sizeof(text),"~OLWrong move!\n");
write_user(user,text);
write_user(user,"The death puke instantly dissolves your body!!\n");
snprintf(text,sizeof(text),"The death puke instantly dissolves %s!!!\n",name);
write_room_except(user->room,text,user,NULL,0,NULL);
snprintf(filename,sizeof(filename),"%s/sick",PICTDIR);
more(user,filename,1);
snprintf(text,sizeof(text),"%s puked out!\n",user->name);
write_syslog(text,1);
disconnect_user(user);
write_room_except(NULL,"You smell a rancid odor from the beyond...\n",NULL,NULL,1,NULL);
}

/*** Sing ***/
void sing(user,inpstr)
UR_OBJECT user;
char *inpstr;
{
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (word_count<2) {
	if (!user->command_mode && !user->scommand_mode) snprintf(text,sizeof(text),"Usage: %s <what you want to sing>\n",command[com_num]);
	else snprintf(text,sizeof(text),"Usage: %s <what you want to sing>\n",command[com_num]+1);
	write_user(user,text);
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_swearing && contains_swearing(inpstr) && (!(user->room->access & 1))) {
	swore(user);
	return;
	}
if (user->committed) {
	write_user(user,"Sorry, but you are mental and a threat to society.\n");
	return;
	}
if (user->big) strtoupper(inpstr);
if (!strcmp(user->room->name,":P")) proom(user,inpstr);
snprintf(text,sizeof(text),"You sing o/~ %s\n",inpstr);
write_user(user,text);
if (user->vis) snprintf(text,sizeof(text),"%s sings o/~ %s\n",user->morphed,inpstr);
else snprintf(text,sizeof(text),"A disembodied person sings o/~ %s\n",inpstr);
write_room_except(user->room,text,user,NULL,0,NULL);
record(user->room,text);
}

/*** Smoke 'em on a stick ***/
void smoke(user)
UR_OBJECT user;
{
char filename[FILENAME_LEN],*name,*name1;
UR_OBJECT user2;

if (word_count<2) {
	write_user(user,"Smoke who on a stick?\n");
	scom_main(user,NULL,3,0);
	return;
	}
if (ban_socials) {
	write_user(user,"Sorry, socials have been turned off.\n");
	return;
	}
if (ban_smoking) {
	write_user(user,"Sorry, smoking has been turned off.\n");
	return;
	}
if (!(user2=get_user2(user,word[1]))) {
	write_user(user,notloggedon);
	return;
	}
if (check_multiple(user,word[1])>1) {
	multiple(user,word[1]);
	return;
	}
if (user2==user) {
	write_user(user,"Smoke yourself on a stick?\n");
	write_user(user,"I wouldn't recommend it.\n");
	return;
	}
if (user2->level>=user->level) {
	write_user(user,"You cannot smoke that user on a stick!\n");
	snprintf(text,sizeof(text),"%s tried to smoke you on a stick!\n",user->name);
	write_user(user2,text);
	return;
	}
if (!user2->listen) {
	if (user2->malloc_start)
		snprintf(text,sizeof(text),"%s is writing a message at the moment.\n",user2->name);
	else snprintf(text,sizeof(text),"%s is not listening at the moment.\n",user2->name);
	write_user(user,text);
	return;
	}
if (user_ignored(user2,user)) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring you.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->socials) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring socials.\n",user2->name);
	write_user(user,text);
	return;
	}
if (!user2->smoke) {
	snprintf(text,sizeof(text),"Sorry, %s is ignoring smoke.\n",user2->name);
	write_user(user,text);
	r