/* @(#)hdump.c	1.7 97/06/16 Copyright 1986 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)hdump.c	1.7 97/06/16 Copyright 1986 J. Schilling";
#endif
/*
 *	hex dump for files
 *
 *	Copyright (c) 1986 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <standard.h>
#include <stdxlib.h>
#define octdig(x)	(x >= '0' && x <= '7')
#ifndef	TRUE
#define TRUE 	1
#define FALSE	0
#endif
int	curradix;
int	lradix = 16;
char	*lfmt;
long pos = 0L;
BOOL dflag = FALSE;
BOOL oflag = FALSE;
BOOL aflag = FALSE;
BOOL bflag = FALSE;
BOOL cflag = FALSE;
BOOL fflag = FALSE;
BOOL Fflag = FALSE;
BOOL lflag = FALSE;
BOOL uflag = FALSE;
BOOL lenflag = FALSE;
BOOL vflag = FALSE;
char buffer[BUFSIZ];	/* buffer for standard out */

LOCAL	void	usage	__PR((int exitcode));
EXPORT	int	main	__PR((int ac, char** av));
LOCAL	void	dump	__PR((FILE * f, char* name, long len));
LOCAL	void	prbuf	__PR((int cnt, short* obuf));
LOCAL	void	prbytes	__PR((int cnt, char* buf));
LOCAL	void	prascii	__PR((int cnt, char* buf));
LOCAL	void	prlong	__PR((int cnt, long* obuf));
LOCAL	void	prshort	__PR((int cnt, short* obuf));
#ifndef	NO_FLOATINGPOINT
LOCAL	void	prdouble __PR((int cnt, double* obuf));
#endif
LOCAL	BOOL	bufeql	__PR((long* b1, long* b2));
LOCAL	long	myatol	__PR((char* s));

LOCAL void
usage(exitcode)
  int exitcode;
{
	error("Usage:	hdump [options] [file [starting address[.][b|B] [count]]]\n");
	error("Options:\n");
	error("\t-a\tDisplay content also in characters\n");
	error("\t-b\tDisplay content in bytes\n");
	error("\t-c\tDisplay content in quoted characters\n");
	error("\t-d\tDisplay content in decimal\n");
#ifndef	NO_FLOATINGPOINT
	error("\t-f\tDisplay content longs as floats\n");
	error("\t-F\tDisplay content double longs as doubles\n");
#endif
	error("\t-l\tDisplay content as longs\n");
	error("\t-o\tDisplay content in octal\n");
	error("\t-u\tDisplay content as unsigned\n");
	error("\t-v\tShow all data even if it is identical\n");
	error("Address label radix depends on starting address radix (decimal if ends with .)\n");
	error("'b' after starting address multiplies with 512 'B' with 1024\n");
	exit(exitcode);
}

EXPORT int
main(ac, av)
  int	ac;
  char	*av[];
{
	long	len = 0L;
	FILE	*infile;
	char	*inname;
	char	*options = "a,b,c,d,f,F,l,o,u,v,help";
	BOOL	help = FALSE;
	int	cac;
	char	* const * cav;

	save_args(ac, av);
	cac = --ac;
	cav = ++av;

	if (getallargs(&cac, &cav, options,
			&aflag, &bflag, &cflag, &dflag, &fflag, &Fflag,
			&lflag, &oflag, &uflag, &vflag,
								&help) < 0) {
		error("Bad flag: '%s'\n", cav[0]);
		usage(1);
	}
	if (help) usage(0);

	setbuf(stdout, buffer);

	cac = ac;
	cav = av;
	if (getfiles(&cac, &cav, options) <= 0) {
		infile = stdin;
		inname = "stdin";
	}
	else {
		inname = cav[0];
		infile = fileopen(cav[0],"r");
		if(infile == 0)
			comerr("Can't open '%s'.\n",cav[0]);
		file_raise(infile,FALSE);
		cac--, cav++;
	}
#ifdef	_FASCII		/* Mark Williams C */
	infile->_ff &= ~_FASCII;
#endif
	if (getfiles(&cac, &cav, options) > 0) {
		(void) fileseek(infile, pos = myatol(cav[0]) & ~1L);
		lradix = curradix;
		cac--, cav++;
	}
	if (getfiles(&cac, &cav, options) > 0) {
		len = myatol(cav[0]);
		lenflag = TRUE;
		cac--; cav++;
	}

	if(getfiles(&cac, &cav, options) > 0) {
		errmsgno(1,"Unexpected argument '%s'.\n",cav[0]);
		usage(1);
	}
	lfmt = lradix == 8 ? "%06lo: " : (lradix == 10 ? "%6ld: " : "%6lx: ");
	dump (infile, inname, len);
	return (0);	
}

LOCAL void
dump(f, name, len)
		FILE	*f;
		char	*name;
	register long	len;
{
	short	obuf1[8];
	short	obuf2[8];
	register short	*buf = obuf1;
	register short	*oldbuf = obuf2;
	register short	*temp;
	register int	cnt;

	do {
		if(lenflag && len <= 0)
			return;
		cnt = fileread(f, (char *)buf, (int)(lenflag?(len > 16 ? 16:len):16));
		if(cnt < 0)
			comerr("Error reading '%s'.\n", name);
		if (vflag || !bufeql ((long *)buf, (long *)oldbuf) || cnt<16)
			prbuf(cnt, buf);
		pos += cnt;
		len -= cnt;

		temp = oldbuf;
		oldbuf = buf;
		buf = temp;

	} while(cnt>0);
/*	printf("%6X: \n", pos);*/
	printf(lfmt, pos);
	printf("\n");
}

LOCAL void
prbuf(cnt, obuf)
	   int		cnt;
  register short	obuf[8];
{
	if (cnt <= 0)
		return;
/*	printf("%6X: ", pos);*/
	printf(lfmt, pos);
	if (aflag)
		prascii (cnt, (char *) obuf);
	else if (bflag | cflag)
		prbytes (cnt, (char *) obuf);
#ifndef	NO_FLOATINGPOINT
	else if (Fflag)
		prdouble(cnt, (double *)obuf);
#endif
	else if (lflag || fflag)
		prlong(cnt, (long *)obuf);
	else
		prshort(cnt, (short *)obuf);
}

LOCAL void
prbytes(cnt, buf)
  register int	cnt;
  register char	buf[16];
{
	register short i;

	if(cflag) {
		for(i=0;i<cnt;i++) {
			if(buf[i] < ' ' || buf[i] >= '\177')
				printf("  \\%02X", 0377&buf[i]);
			else
				printf("    %c", buf[i]);
			if(i == 7 && cnt > 8)
				printf("\n        ");
		}
		putchar('\n');
	}
	if(cflag & bflag)
		printf("        ");
	if(bflag) {
		for(i=0; i < cnt; i++) {
			if(dflag) {
				if (uflag)
					printf("  %4d", 0377&buf[i]);
				else
					printf("  %4d", buf[i]);
			} else if(oflag) {
				printf(" %04o", 0377&buf[i]);
			} else {
				printf("   %02X", 0377&buf[i]);
			}
			if(i == 7 && cnt > 8)
				printf("\n        ");
		}
		putchar('\n');
	} 
}

LOCAL void
prascii (cnt, buf)
  register int	cnt;
  register char	*buf;
{
	register short	i;
	register char	c;

	for(i=0; i < 16; i++) {
		if (i >= cnt)
			printf("   ");
		else if (dflag) {
			if (uflag)
				printf("%4u", 0377&buf[i]);
			else
				printf("%4d", buf[i]);
		} else if(oflag) {
			printf(" %03o", 0377&buf[i]);
		} else {
			printf(" %02X", 0377&buf[i]);
		}
		if (i == 7)
			printf ("  ");
	}
	if (dflag || oflag)
		printf ("\n         ");
	else
		printf ("   ");
	for (i=0;i < cnt;i++) {
		c = buf[i];
		putchar (c < ' ' || c >= 0177 ? '.' : c);
	}
	putchar('\n');
}

LOCAL void
prlong(cnt, obuf)
	   int		cnt;
  register long		obuf[4];
{
	register short	i;
	register int	n = cnt;
#ifndef	NO_FLOATINGPOINT
	register float	*fp;
#endif

	n /= 4;
	for(i=0;i < n;i++) {
last:
		if (dflag) {
			if (uflag)
				printf("%12lu", obuf[i]);
			else
				printf("%12ld", obuf[i]);
#ifndef	NO_FLOATINGPOINT
		} else if (fflag) {
			fp = (float *)&obuf[i];
			printf("%14.7e", *fp);
#endif
		} else if (oflag) {
			printf(" %012lo", obuf[i]);
		} else {
			printf("   %08lX", obuf[i]);
		}
	}
	if ((i = (cnt % 4)) != 0) {
		fillbytes(&((char *)obuf)[cnt], 4-i, '\0');
		cnt -= i;
		i = cnt / 4;
		goto last;
	}
	putchar('\n');
}

LOCAL void
prshort(cnt, obuf)
	   int		cnt;
  register short	obuf[8];
{
	register short	i;
	register int	n = cnt;

	n /= 2;
	for(i=0;i < n;i++) {
last:
		if (dflag) {
			if (uflag)
				printf("%7hu", obuf[i]);
			else
				printf("%7hd", obuf[i]);
		} else if (oflag) {
			printf(" %06ho", obuf[i]);
		} else {
			printf("   %04hX", obuf[i]);
		}
	}
	if (cnt & 1L) {
		((char *) obuf)[cnt--] = '\0';
		goto last;
	}
	putchar('\n');
}

#ifndef	NO_FLOATINGPOINT
LOCAL void
prdouble(cnt, obuf)
	   int		cnt;
  register double	obuf[2];
{
	register short	i;
	register int	n = cnt;

	n /= 8;
	for(i=0;i < n;i++) {
last:
		printf("%21.14e", obuf[i]);
	}
	if ((i = (cnt % 8)) != 0) {
		fillbytes(&((char *)obuf)[cnt], 8-i, '\0');
		cnt -= i;
		i = cnt / 8;
		goto last;
	}
	putchar('\n');
}
#endif

LOCAL BOOL
bufeql (b1, b2)
	register long	*b1;
	register long	*b2;
{
	register int	i;
	static	BOOL	dont_print ;

	for (i=4; --i >= 0;)
		if (*b1++ != *b2++)
			return dont_print = FALSE;
	if (!dont_print) {
		printf ("     *\n");
		fflush(stdout);
	}
	return dont_print = TRUE;
}

LOCAL long
myatol(s)
	char	 *s;
{
	char *p;
	long val = 0;

	if (s[0] == '0' && (s[1] == 'x' || s[1] == 'X'))
		curradix = 16;
	else if (s[0] == '0' && !streql("0", s))
		curradix = 8;
	else
		curradix = 0;

	p = astol(s, &val);

	if(*p != '\0') {
		if (*p == '.') {
			p++;
			curradix = 10;
		}
		if (*p && (streql(p, "b") || streql(p, "B"))) {
			if (*p == 'b') val *= 512;
			if (*p == 'B') val *= 1024;
		} else if (*p)
			comerrno(1,"Bad numeric argument '%s'.\n",s);
	}

	return(val);
}
