#ifndef lint
static char *RCSid = "$Header: /dd/USR/MIKEH/YUP/rcs/od.c_v 1.1 94/06/03 18:06:47 mikeh Exp $";
#endif

/*
 * $Log:	od.c_v $
 * Revision 1.1  94/06/03  18:06:47  mikeh
 * Initial revision
 * 
 */

/* Od.c Octal dump */

#include <stdio.h>
#include <ctype.h>
#include "cnv.h"

char *usgmsg[] = {
	"Syntax: dump [<opts>] [<path>] [<opts>]\n",
	"Function: formatted display of contents of a file\n",
	"Options:\n",
	"   -b    binary display\n",
	"   -d    decimal display\n",
#ifdef OSK
	"   -h    hexadecimal display\n",
	"   -o    octal display (default)\n",
#else
	"   -h    hexadecimal display (default)\n",
	"   -o    octal display\n",
#endif
	"   -z    read from standard input\n",
	"   -v    version\n",
	NULL
};

version(name)
char *name;
{
	fprintf(stderr,"%s: Version %d.%d %s\n",name,VERSION,REVISION,RELEASE);
}

usage()
{
	int i = 0;

	while(usgmsg[i])
		fputs(usgmsg[i++],stderr);
	exit(0);
}

header(hdrs)
char **hdrs;
{
	int i = 0;
	
	printf("\n");
	while(hdrs[i])
		printf("%s\n",hdrs[i++]);
}

main(argc,argv)
int    argc;
char **argv;
{
	FILE *fp;
	int i;
	int files   = 0;
	int rdstdin = 0;
	char *opt;

	if (argc < 2)
		usage();
		
	for (i = 1; i < argc ; i++)
	{
		if (argv[i][0] == '-')
		{
			
			if (argv[i][1] == '\0')
			{
				rdstdin = TRUE;
			}
			else
			{
				opt = &argv[i][1];
				while (*opt)
				{
					switch (toupper(*opt++))
					{
					case 'Z' :
						rdstdin = TRUE;
						break;
					case 'O':
						base = OCTAL;
						break;
					case 'H':
						base = HEX;
						break;
					case 'B':
						base = BINARY;
						break;
					case 'D':
						base = DECIMAL;
						break;
					case 'V':
						version(argv[0]);
					default :
						usage();
					}
				}
			}
		}
		else
			files++;
	}

	if (files == 0	&& ! rdstdin)
		usage();

	initialize(base);

	if (rdstdin)
		dump(stdin);
	else for (i = 1; i < argc ; i++)
	{
		if (argv[i][0] != '-')
		{
			if ((fp = fopen(argv[i],"r")) != (FILE *)NULL)
			{
				dump(fp);
				fclose(fp);
			}
			else
			{
			        printf("Can't open '%s'.\n",argv[i]);
				exit(errno);
			}
		}
	}
}

dump(fp)
FILE *fp;
{
	int k = 0;
	int i = 0;
	int pos = 0;
	int ch;
	char string[40];
	char buffer[80];
	char *strptr;
	char *s;

	s = buffer;
	*buffer = '\0';
	strptr = string;
	*string = '\0';
	while ((ch = fgetc(fp)) != EOF)
	{
		*strptr++ = (isprint(ch) && ((ch & 0x80) == 0)) ? ch : '.';
		*strptr = '\0';			
		s = outtype(s,ch);
		i++;
		if (i == maxwide)
		{
			if ((pos % maxline) == 0)
				header(hdrs);
			printf(fmt,typeint(pos),buffer, string);
			k++;
			pos++;
			i = 0;
			s = buffer;
			*buffer = '\0';
			strptr = string;
			*string = '\0';
			if (k == maxline)
				k = 0;
		}
	}
	if (k == 0 && i > 0)
		header(hdrs);
	if (i > 0)
		printf(fmt,typeint(pos),buffer, string);
}



