#ifndef lint
static char *RCSid = "$Header: /dd/USR/MIKEH/YUP/rcs/cnv.c_v 1.1 94/06/03 18:06:22 mikeh Exp $";
#endif

/*
 * $Log:	cnv.c_v $
 * Revision 1.1  94/06/03  18:06:22  mikeh
 * Initial revision
 * 
 */

/* Cnv.c - conversion routines for od.c */

#define CNV	/* For cnv.h */

#include <stdio.h>
#include <ctype.h>
#include "cnv.h"

static char oint[40];
	
char *hexhdr[] = {
	"  Offset    0 1  2 3  4 5  6 7  8 9  A B  C D  E F  0 2 4 6 8 A C E",
    " --------  ---- ---- ---- ---- ---- ---- ---- ----  ----------------",
    NULL
};

char *octhdr[] = {
	" Oct. Offset    0   1   2   3   4   5   6   7   0 2 4 6 ",
	" ------------  --- --- --- --- --- --- --- ---  --------",
	NULL
};

char *binhdr[] = {
"   Binary Offset                      00       01     01",
" --------------------------------  -------- --------  --",
	NULL
};

char *dechdr[] = {
	" Dec. Offset   0   1   2   3   4   5   6   7   8   9   0 2 4 6 8",
	" -----------  --- --- --- --- --- --- --- --- --- ---  ----------",
	NULL
};

static char *hexfmt = " %-8.8s  %-40.40s %-16.16s\n";
static char *octfmt = " %-12.12s  %-32.32s %-8.8s\n";
static char *binfmt = " %-32.32s  %-18.18s %-2.2s\n";
static char *decfmt = " %-11.11s  %-40.40s %-10.10s\n";

char *outhex(s,ch)
char *s;
int  ch;
{
	static int i = 0;
	char tmpstr[10];
	
	sprintf(tmpstr,"%02x",ch);

	*s++ = tmpstr[0];
	*s++ = tmpstr[1];
	if (i)
		*s++ = ' ';
	*s   = '\0';
	i = (i) ? 0 : 1;
	return (s);
}


char *hexint(val)
int  val;
{
	char *s = oint;
	char ch;
	int  i;
	
	sprintf(oint,"%08x",val);

	return (oint);
}


char *outoct(s,ch)
char *s;
int  ch;
{
	*s++ = '0' + ((ch >> 6) & 0x3);
	*s++ = '0' + ((ch >> 3) & 0x7);
	*s++ = '0' + (ch & 0x7);
	*s++ = ' ';
	*s = '\0';
	return (s);
}


char *octint(val)
int  val;
{
	char *s = oint;
	char ch;
	int  i;
	
	for (i = 3; i >= 0; i--)
	{
		ch = (val >> (8 * i)) & 0xFF;
		*s++ = '0' + ((ch >> 6) & 0x3);
		*s++ = '0' + ((ch >> 3) & 0x7);
		*s++ = '0' + (ch & 0x7);
	}
	*s = '\0';
	return (oint);
}

char *outbin(s,ch)
char *s;
int  ch;
{
	int i;

	for (i = 7 ; i >= 0 ; i--)
	{
		*s++ = '0' + ((ch >> i) & 0x1);
	}
	*s++ = ' ';
	*s = '\0';
	return (s);
}

char *binint(val)
int  val;
{
	char *s = oint;
	char ch;
	int  i, j;
	
	for (i = 3; i >= 0; i--)
	{
		ch = (val >> (8 * i)) & 0xFF;
		for (j = 7 ; j >= 0 ; j--)
		{
			*s++ = '0' + ((ch >> j) & 0x1);
		}
	}
	*s = '\0';
	return (oint);
}

char *outdec(s,ch)
char *s;
int  ch;
{
	char tmpstr[10];
	
	sprintf(tmpstr,"%03d",ch & 0xFF);

	*s++ = tmpstr[0];
	*s++ = tmpstr[1];
	*s++ = tmpstr[2];
	*s++ = ' ';
	*s   = '\0';

	return (s);
}


char *decint(val)
int  val;
{
	char *s = oint;
	char ch;
	int  i;
	
	sprintf(oint,"%011d",val);

	return (oint);
}


initialize(base)
int base;
{
	switch (base)
	{
	case HEX:
		maxline = 16;
		maxwide = 16;
		outtype = outhex;
		typeint = hexint;
		hdrs    = hexhdr;
		fmt     = hexfmt;
		break;
	case BINARY:
		maxline = 16;
		maxwide = 2;
		outtype = outbin;
		typeint = binint;
		hdrs    = binhdr;
		fmt     = binfmt;
		break;
	case DECIMAL:
		maxline = 10;
		maxwide = 10;
		outtype = outdec;
		typeint = decint;
		hdrs    = dechdr;
		fmt     = decfmt;
		break;
	case OCTAL:
	default:
		maxline = 8;
		maxwide = 8;
		outtype = outoct;
		typeint = octint;
		hdrs    = octhdr;
		fmt     = octfmt;
	}
}



