# *****************************************************************************
# *									      *
# *	     HEXED Makefile - DOS & OS/2 version using Watcom-C++	      *
# *									      *
# * (C) 1993-96  Ullrich von Bassewitz					      *
# *		 Wacholderweg 14					      *
# *		 D-70597 Stuttgart					      *
# * EMail:	 uz@ibb.schwaben.com					      *
# *									      *
# *****************************************************************************



# $Id$
#
#  $Log$
#
#



# ------------------------------------------------------------------------------
# Generelle Einstellungen

.AUTODEPEND
.SUFFIXES	.ASM .C .CC .CPP
.SWAP

# ------------------------------------------------------------------------------
# Allgemeine Definitionen

# Names of executables
AS = TASM
AR = WLIB
LD = WLINK
!if $d(__OS2__)
ZIP = zip
MV = c:\os2\4os2\4os2 /C MOVE /Q
!else
ZIP = pkzip
MV = mv
!endif


!if !$d(TARGET)
!if $d(__OS2__)
TARGET = OS2
!else
TARGET = DOS
!endif
!endif

LIBDIR= ..\spunk



# target specific macros.
!if $(TARGET)==OS2
SYSTEM = os2v2
CC = WCL386
CCCFG  = -bm -bt=$(TARGET) -d$(TARGET) -i=$(LIBDIR) -d2 -oneatx -zp4 -5 -fp3 -zq -w2 -ze
!elif $(TARGET)==DOS32
SYSTEM = pmodew
CC = WCL386
CCCFG  = -bt=$(TARGET) -d$(TARGET) -i=$(LIBDIR) -d2 -oneatx -zp4 -5 -fp3 -zq -w2 -ze
!elif $(TARGET)==DOS
SYSTEM = dos
CC = WCL
CCCFG  = -bt=$(TARGET) -d$(TARGET) -i=$(LIBDIR) -d2 -oneatx -zp2 -0 -fpi87 -ml -zq -w2 -ze
!else
!error
!endif

LIB	= $(LIBDIR)\$(TARGET)\SPUNK.LIB

# ------------------------------------------------------------------------------
# Implicit rules

.c.obj:
  $(CC) $(CCCFG) -c {$< }

.cc.obj:
  $(CC) $(CCCFG) -c {$< }

# --------------------------------------------------------------------

exe:		hexed.exe

os2:
	$(MAKE) -DTARGET=OS2

dos4g:
	$(MAKE) -DTARGET=DOS4G

dos:
	$(MAKE) -DTARGET=DOS

hexed:		hexed.exe


# --------------------------------------------------------------------
#

hexed.exe:	hexed.obj	\
		hexopt.obj	\
		hexwin.obj
		$(LD) system $(SYSTEM) @&&|
DEBUG all
NAME hexed.exe
OPTION DOSSEG
OPTION STACK=32K
FILE hexed.obj
FILE hexopt.obj
FILE hexwin.obj
FILE $(LIB)
|

# ------------------------------------------------------------------------------
# ZIP File erzeugen

zip:
	-del hexed.zip
	-del *.bak
	copy makefile make\watcom.mak
	$(ZIP) hexed.zip *.cc *.h hexed.res *.doc hexed.1 make\*.mak

strip:
	-65535 wstrip hexed.exe

bin-dist:	exe strip
	-del hexed.zip
	$(ZIP) -9 hexed.zip hexed.exe hexed.res *.doc hexed.1

# ------------------------------------------------------------------------------
# Zeilenzahl

linecount:
	-wc -l *.cc *.

# ------------------------------------------------------------------------------
# Aufrumen

clean:
	-del *.bak

zap:	clean
	-del *.obj
	-del *.mbr
	-del *.dbr

