# *****************************************************************************
# *									      *
# *		     HEXED Makefile for FreeBSD / GNU-C++		      *
# *									      *
# * (C) 1995-96  Ullrich von Bassewitz					      *
# *		 Wacholderweg 14					      *
# *		 D-70597 Stuttgart					      *
# * EMail:	 uz@ibb.schwaben.com					      *
# *									      *
# *****************************************************************************



# $Id$
#
# $Log$
#
#



# ------------------------------------------------------------------------------
# Definitions

# Names of executables
AS = gas
AR = ar
LD = ld
ZIP = zip
CC = g++

LIB	= ../spunk/spunk.a
INCDIR	= ../spunk

CFLAGS	= -g -DFREEBSD -Wall -I$(INCDIR) -x c++

# ------------------------------------------------------------------------------
# Implicit rules

.c.o:
	$(CC) $(CFLAGS) -c $<

.cc.o:
	$(CC) $(CFLAGS) -c $<

# ------------------------------------------------------------------------------
# All OBJ files

OBJS =	hexed.o		\
	hexopt.o	\
	hexwin.o

# ------------------------------------------------------------------------------
#

hexed:	$(LIB) $(OBJS)
	$(CC) -o hexed $(OBJS) $(LIB) -ltermcap -lg++

depend dep:
	@echo "Creating dependency information"
	$(CC) -I$(INCDIR) -DFREEBSD -MM *.cc > .depend

# ------------------------------------------------------------------------------
# Create a ZIP file

strip:
	strip hexed

zip:
	-rm -f hexed.zip
	cp Makefile make\freebsd.mak
	$(ZIP) *.cc *.h hexed.res *.doc hexed.1 make\*.mak

bin-dist:	hexed strip
	rm -f hexed.zip
	$(ZIP) -9 hexed.zip hexed hexed.res hexed.doc hexed.1

# ------------------------------------------------------------------------------
# clean up

clean:
	-rm *.bak *~

zap:	clean
	-rm *.o
	-rm .depend


