# *****************************************************************************
# *									      *
# *		   HEXED Makefile for FreeBSD / X Window System		      *
# *									      *
# * (C) 1995-96  Ullrich von Bassewitz					      *
# *		 Wacholderweg 14					      *
# *		 D-70597 Stuttgart					      *
# * EMail:	 uz@ibb.schwaben.com					      *
# *									      *
# *****************************************************************************



# $Id$
#
# $Log$
#
#



# ------------------------------------------------------------------------------
# Definitions

# Names of executables
AS = gas
AR = ar
LD = ld
ZIP = zip
CC = g++

LIB	= ../spunk/spunk.a
INCDIR	= ../spunk

# Both configurations of CFLAGS will probably work since FreeBSD has a
# smart linker...
#CFLAGS = -DFREEBSD -g -Wall -I$(INCDIR) -x c++ -L /usr/X11R6/lib
CFLAGS	= -DFREEBSD -g -Wall -I$(INCDIR) -x c++ -L /usr/X11R6/lib -fno-implicit-templates -DEXPLICIT_TEMPLATES



# ------------------------------------------------------------------------------
# Implicit rules

.c.o:
	$(CC) $(CFLAGS) -c $<

.cc.o:
	$(CC) $(CFLAGS) -c $<

# ------------------------------------------------------------------------------
# All OBJ files

OBJS =	hexed.o		\
	hexopt.o	\
	hexwin.o

# ------------------------------------------------------------------------------
#

xhexed:		$(LIB) $(OBJS)
	$(CC) -o xhexed $(OBJS) $(LIB) -L/usr/X11R6/lib -lg++ -lX11

depend dep:
	@echo "Creating dependency information"
	$(CC) -I$(INCDIR) -DFREEBSD -MM *.cc > .depend

# ------------------------------------------------------------------------------
# Create a ZIP file

strip:
	strip xhexed

zip:
	-rm -f hexed.zip
	cp Makefile make\freebsd.mak
	$(ZIP) *.cc *.h hexed.res *.doc hexed.1 make\*.mak

bin-dist:	xhexed strip
	rm -f hexed.zip
	$(ZIP) -9 hexed.zip xhexed hexed.res *.doc hexed.1

# ------------------------------------------------------------------------------
# clean up

clean:
	-rm *.bak *~

zap:	clean
	-rm *.o
	-rm .depend


