/*****************************************************************************/
/*									     */
/*				   HEXWIN.CC				     */
/*									     */
/* (C) 1995-96	Ullrich von Bassewitz					     */
/*		Wacholderweg 14						     */
/*		D-70597 Stuttgart					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef _HEXWIN_H
#define _HEXWIN_H



#include <stdio.h>

#include "window.h"



/*****************************************************************************/
/*				    EditMode				     */
/*****************************************************************************/



enum	EditMode { emHex, emASCII, emShow, emReadonly };

// The default mode if the file is not read only
extern EditMode		DefaultEditMode;



/*****************************************************************************/
/*				class HexedWin				     */
/*****************************************************************************/



class HexedWin: public ItemWindow {

protected:
    // Persistent data
    String		Filename;	// Name of the file to edit
    u32			Filesize;	// Size of the file to edit
    u32			StartOffset;	// Offset of upper left corner in file
    u32			CursorOffset;	// Offset of the cursor in the file
    i32			LowNibble;	// Cursor is on lower nibble (hex mode)
    EditMode		Mode;		// Current edit mode
    Rect		SmallSize;	// Small window size
    i16			RelFilePos;	// Relative cursor position in file

    // non persistent data
    FILE*		F;
    int			ErrorFlag;	// True if the constructor had errors
    unsigned		BytesPerRow;	// Bytes per window row
    unsigned char*	PageBuf;	// Buffer
    unsigned		PageBufSize;
    unsigned		PageBufFill;
    unsigned		PageBufDirty;
    unsigned		FileIsModified;
    String		ShadowFile;	// Name of the shadow file
    unsigned		HasShadowFile;	// True if we are not reading the original


    void Init ();
    // Initialize the window - is called from the constructors

    void InitData ();
    // Recalculate needed data, resize buffers

    void CopyFile (FILE* Source, FILE* Target);
    // Copy a file from Source to Target

    void OpenError (const String& Name);
    // Print an error message "Could not open XXXX"

    void Goto (u32 NewOffs);
    // Go to a new cursor offset. The function tries to center the new cursor
    // position in the window.

    void SetPageBufDirty ();
    // Set the page buf dirty flag. The function checks if this is the first
    // time that the file has been changed and updates the footer (where a
    // "file is changed" mark is display) if so.

    void SetCursorOffset (u32 NewOffset);
    // Set a new cursor position in the file recalculating all data that
    // depends on this position

    void ReadPageBuf ();
    // Read the page buffer

    void WritePageBuf ();
    // Write the page buffer

    void DrawLine (unsigned Y);
    // Draw one line

    void DrawPage ();
    // Draw the complete page

    void DrawCursor (unsigned Attr);
    // Draw the cursor in the given attribute

    String GetPosFooterText ();
    // Return the text that is displayed in the lower left corner of the
    // frame.

    void SetModeFooter ();
    // Set the footer string according to the mode

    virtual void DrawFooter ();
    // Draw the footer of the window frame. The function exits immidiately if
    // the window is not framed.
    // The footer is positioned at the lower right of the frame, there is
    // exactly one horizontal frame element to the right of the footer text.
    // This function overrides Window::Footer and places a position mark
    // on the left side of the frame

    void ShowCursor ();
    // Draw a visible cursor

    void HideCursor ();
    // Make the cursor invisible

    void CursorUp (unsigned Bytes);
    // Raw cursor movement up

    void CursorDown (unsigned Bytes);
    // Raw cursor movement down

    void InsertChar (Key K);
    // Insert a key

    void ToggleMode ();
    // Toggle the edit mode

    void PgUp ();
    void PgDn ();
    void Home ();
    void End ();
    void Up ();
    void Down ();
    void Left ();
    void Right ();

    u32 FileSearch (u32 Start, const char* S, unsigned Len);
    // Search for the string S beginning from the offset Start up to the end of
    // the file. The function returns the position a copy of S is found, or -1
    // if no copy has been found. The string S may contain null bytes.

public:
    HexedWin (const Rect& Bounds, const String& Name);
    // Construct a HexedWin instance. Name is the name of the file to edit

    HexedWin (StreamableInit);
    // Create an empty hexed window

    virtual ~HexedWin ();
    // Delete a HexedWin instance, close the file etc.

    virtual void Store (Stream&) const;
    // Store the hexed window into a stream

    virtual void Load (Stream&);
    // Load the window from a stream

    virtual u16 StreamableID () const;
    // Return the stream ID of the window

    static Streamable* Build ();
    // Build an empty hexed window

    virtual void DrawInterior ();
    // Draw the window interior

    int HadError ();
    // Return the error marker

    const String& GetFilename ();
    // Return the name of the file

    void Search ();
    // Request a search string from the user and search for this string. Position
    // the cursor to the string found.

    virtual Key Browse ();
    // Edit/view the file, return the abort key

    virtual unsigned MinXSize () const;
    // Return the minimum window size

    virtual unsigned MinYSize () const;
    // Return the minimum window size

    int CanClose ();
    // Return true if closing the window is allowed

    void Zoom ();
    // Zoom the window in or out

    void Goto ();
    // Set a new position in the file

    void Save ();
    // Save the file if it is modified

    virtual void ScreenSizeChanged (const Rect& NewScreen);
    // Called when the screen got another resolution. NewScreen is the new
    // screen size.

};



inline int HexedWin::HadError ()
{
    return ErrorFlag;
}



inline const String& HexedWin::GetFilename ()
// Return the name of the file
{
    return Filename;
}



// End of HEXWIN.H

#endif



