/*****************************************************************************/
/*									     */
/*				      HEXOPT.H				     */
/*									     */
/* (C) 1995-96	Ullrich von Bassewitz					     */
/*		Wacholderweg 14						     */
/*		D-70597 Stuttgart					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef _HEXOPT_H
#define _HEXOPT_H



#include "strmable.h"



/*****************************************************************************/
/*				     Data				     */
/*****************************************************************************/



extern class HexedOptions*     HexOpt;



/*****************************************************************************/
/*			       class HexedOptions			     */
/*****************************************************************************/



class HexedOptions: public Streamable {

private:
    u32		OptFlags;		// Bitmapped on/off options
    u16		DefaultMode;		// Default edit mode

public:
    HexedOptions ();
    // Construct an HexedOptions instance, set all values to defaults

    HexedOptions (StreamableInit);
    // Build constructor

    virtual void Load (Stream&);
    // Load the object from a stream

    virtual void Store (Stream&) const;
    // Store the object into a stream

    virtual u16 StreamableID () const;
    // Return the stream ID

    static Streamable* Build ();
    // Build an empty HexedOptions object

    // Requests for boolean options
    int AutoSave () const;
    int ShowExtAscii () const;
    int CreateShadow () const;
    int SearchWraps () const;
    int ReloadFiles () const;

    unsigned GetDefaultMode () const;
    // Return the default edit mode

    void Edit ();
    // Allow editing of the object

};



inline unsigned HexedOptions::GetDefaultMode () const
// Return the default edit mode
{
    return DefaultMode;
}



// End of HEXOPT.H

#endif






