/*****************************************************************************/
/*                                                                           */
/*                                  HEXOPT.CC                                */
/*                                                                           */
/* (C) 1995-96  Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include "menuitem.h"
#include "menue.h"
#include "stdmenue.h"
#include "stdmsg.h"
#include "crcstrm.h"
#include "memstrm.h"
#include "settings.h"
#include "progutil.h"

#include "hexobjid.h"
#include "hexopt.h"



// Register the UTOptions class
LINK (HexedOptions, ID_HexedOptions);



/*****************************************************************************/
/*                        Constants for bitmapped flags                      */
/*****************************************************************************/



const u32 optAutoSave           = 0x00000001;   // Auto save options on exit
const u32 optShowExtAscii       = 0x00000002;   // Show chars > 127
const u32 optCreateShadow       = 0x00000004;   // Create shadow file
const u32 optSearchWraps        = 0x00000008;   // Search wraps at end
const u32 optReloadFiles        = 0x00000010;   // Reload files on start



/*****************************************************************************/
/*                                   Data                                    */
/*****************************************************************************/



// Pointer to the options object
HexedOptions*     HexOpt = NULL;

// Name of the window position in the settings file
static const String HexOptEditWinPos = "HexOpt.EditWindow.Position";



/*****************************************************************************/
/*                            class HexedOptions                             */
/*****************************************************************************/



HexedOptions::HexedOptions ():
    OptFlags (optCreateShadow | optReloadFiles),
    DefaultMode (1)
// Construct an HexedOptions instance, set all values to defaults
{
}



HexedOptions::HexedOptions (StreamableInit)
// Build constructor
{
}



void HexedOptions::Load (Stream& S)
// Load the object from a stream
{
    S >> OptFlags >> DefaultMode;
}



void HexedOptions::Store (Stream& S) const
// Store the object into a stream
{
    S << OptFlags << DefaultMode;
}



u16 HexedOptions::StreamableID () const
// Return the stream ID
{
    return ID_HexedOptions;
}



Streamable* HexedOptions::Build ()
// Build an empty HexedOptions object
{
    return new HexedOptions (Empty);
}



int HexedOptions::AutoSave () const
{
    return ((OptFlags & optAutoSave) != 0);
}



int HexedOptions::ShowExtAscii () const
{
    return ((OptFlags & optShowExtAscii) != 0);
}



int HexedOptions::CreateShadow () const
{
    return ((OptFlags & optCreateShadow) != 0);
}



int HexedOptions::SearchWraps () const
{
    return ((OptFlags & optSearchWraps) != 0);
}



int HexedOptions::ReloadFiles () const
{
    return ((OptFlags & optReloadFiles) != 0);
}



void HexedOptions::Edit ()
// Allow editing of the options
{
    // Constants for menue items
    const i16 miAutoSave                =  1;
    const i16 miCreateShadow            =  3;
    const i16 miShowExtAscii            =  5;
    const i16 miDefaultMode             =  7;
    const i16 miSearchWraps             = 11;
    const i16 miReloadFiles             = 13;


    // Save the current settings
    MemoryStream SaveStream (128);
    Store (SaveStream);

    // Get a crc over the data
    unsigned OldCRC = GetCRC (this);

    // Load the edit window
    Menue* Win = (Menue*) LoadResource ("@HEXOPT.EditWindow");

    // If there is a stored window position in the settings file, move the
    // window to this position. As the window is invisible, this operation
    // is cheap and is performed in any case.
    Win->MoveAbs (StgGetPoint (HexOptEditWinPos, Win->OuterBounds ().A));

    // Transfer the data into the edit window
    Win->SetToggleValue (miAutoSave, AutoSave ());
    Win->SetToggleValue (miCreateShadow, CreateShadow ());
    Win->SetToggleValue (miShowExtAscii, ShowExtAscii ());
    Win->SetToggleValue (miDefaultMode, DefaultMode);
    Win->SetToggleValue (miSearchWraps, SearchWraps ());
    Win->SetToggleValue (miReloadFiles, ReloadFiles ());

    // Create a new status line and activate the window
    PushStatusLine (siAbort | siAccept | siChange);
    Win->Activate ();

    // Edit loop
    int Done = 0;
    while (!Done) {

        // Get a choice from the user
        int Choice = Win->GetChoice ();
        switch (Choice) {

            case miAutoSave:
                OptFlags &= ~optAutoSave;
                break;

            case miAutoSave+1:
                OptFlags |= optAutoSave;
                break;

            case miCreateShadow:
                OptFlags &= ~optCreateShadow;
                break;

            case miCreateShadow+1:
                OptFlags |= optCreateShadow;
                break;

            case miShowExtAscii:
                OptFlags &= ~optShowExtAscii;
                break;

            case miShowExtAscii+1:
                OptFlags |= optShowExtAscii;
                break;

            case miDefaultMode+0:
            case miDefaultMode+1:
            case miDefaultMode+2:
            case miDefaultMode+3:
                DefaultMode = Choice - miDefaultMode;
                break;

            case miSearchWraps:
                OptFlags &= ~optSearchWraps;
                break;

            case miSearchWraps+1:
                OptFlags |= optSearchWraps;
                break;

            case miReloadFiles:
                OptFlags &= ~optReloadFiles;
                break;

            case miReloadFiles+1:
                OptFlags |= optReloadFiles;
                break;

            case 0:
                switch (Win->GetAbortKey ()) {

                    case vkAbort:
                        if (OldCRC != GetCRC (this)) {
                            // Something has changed
                            if (AskDiscardChanges () == arYes) {
                                // Discard changes
                                Load (SaveStream);
                                Done = 1;
                            }
                        } else {
                            // Nothing has changed
                            Done = 1;
                        }
                        break;

                    case vkAccept:
                        Done = 1;
                        break;

                }
                break;

        }

    }

    // Store the current window position in the settings file
    StgPutPoint (Win->OuterBounds ().A, HexOptEditWinPos);

    // Pop the old statusline
    PopStatusLine ();

    // Discard the window
    delete Win;
}



