/*****************************************************************************/
/*									     */
/*				    HEXED.H				     */
/*									     */
/* (C) 1995-96	Ullrich von Bassewitz					     */
/*		Wacholderweg 14						     */
/*		D-70597 Stuttgart					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef _HEXED_H
#define _HEXED_H



#include "program.h"



/*****************************************************************************/
/*				 Menue items				     */
/*****************************************************************************/



const i16 miNone			=    1;

const i16 miHexed			= 1000;
const i16 miAbout			= 1100;

const i16 miFile			= 2000;
const i16 miOpen			= 2100;
const i16 miSave			= 2200;
const i16 miSaveAll			= 2300;
const i16 miSearch			= 2400;
const i16 miGoto			= 2500;
const i16 miQuit			= 2600;

const i16 miWindow			= 4000;
const i16 miTile			= 4100;
const i16 miCascade			= 4200;
const i16 miCloseAll			= 4300;
const i16 miRedraw			= 4400;
const i16 miResize			= 4500;
const i16 miZoom			= 4600;
const i16 miClose			= 4700;
const i16 miWindowList			= 4800;

const i16 miOptions			= 5000;
const i16 miEditOptions			= 5100;
const i16 miSaveOptions			= 5200;



/*****************************************************************************/
/*				class HexedApp				     */
/*****************************************************************************/



// Forward
class HexedOptions;



class HexedApp: public Program {


private:
    static TopMenueBar* CreateMenueBar ();
    static BottomStatusLine* CreateStatusLine ();

protected:
    String		SettingsFile;		// Name of the settings file
    u32			StatusFlags;		// statusline flags
    String		LastFile;		// Last filename used



    static void ArgumentError (const char* Arg);
    // Print an error message

    void DisableStatusItem (u32 ItemFlag);
    // Disable the statusline text corresponding to ItemFlag

    void EnableStatusItem (u32 ItemFlag);
    // Enable the statusline text corresponding to ItemFlag

    HexedWin* NewWindow (const String& Filename, const Rect& Bounds);
    // Add a new hexed window to the window manager

    HexedWin* NewWindow ();
    // Get a file name from the user and insert the given window into the list

    void Zoom (ItemWindow* Win);
    // Zoom a hexed window

    void Resize (ItemWindow* W);
    // Resize a hexed window

    void Close (ItemWindow* W);
    // Close a hexed window

    void Search (ItemWindow* Win);
    // Search a string in a window

    void Goto (ItemWindow* Win);
    // Goto a specific position in file


public:
    HexedApp (int argc, char* argv []);
    // Construct an application object

    virtual ~HexedApp ();
    // Destruct an application object

    virtual int Run ();
    // Run the application

    void HandleEvent (Event& E);
    // Handle incoming events.

    virtual void DisableCommand (i16 ID);
    // Disable the command bound to the menue item with the given ID

    virtual void EnableCommand (i16 ID);
    // Enable the command bound to the menue item with the given ID

};



// End of HEXED.H

#endif
