# 
# Example spec file for cdplayer app... 
# 
Summary: Secure File Wiping and Deletion
Name: fwipe
Version: 0.35
Release: 1
Copyright: BSD
Group: Applications/File
Source: http://www.pobox.com/~lbudney/linux/software/fwipe/fwipe-%{version}.tar.gz
URL: http://www.pobox.com/~lbudney/linux/software/fwipe.html
Distribution: RedHat 6.2 Contrib
Packager: Len Budney <lbudney@pobox.com>
Buildroot: /tmp/fwipe-%{version}

%description 
When you delete files from disk, you are not deleting your data! All
that is removed is an entry in a directory, telling where your data
is. Utilities like Disk Doctor, and lots of others, can pretty easily
undelete your files.

Enter fwipe. fwipe overwrites your file several times before deleting
it. It was designed with security in mind: fwipe0, which actually
erases your files, is immune to filenames containing spaces, carriage
returns, dashes, or any other special characters (see the man
page). You can use it in place of rm in cron jobs, together with "find
... -print0". The output of fwipe0 is specially designed to be parsed
easily by machine, so it can be imbedded in other applications which
need secure file erasure.

%prep
%setup
echo $RPM_BUILD_ROOT/usr > conf-root
mkdir -p %{buildroot}

%build
make

%install
make setup check

%clean
rm -rf $RPM_BUILD_ROOT

%files
%attr(-,root,root) %doc BLURB INSTALL COPYING
%attr(-,root,root) /usr/bin/*
%attr(-,root,root) /usr/man/man1/*
%attr(-,root,root) /usr/man/cat1/*
