/* Copyright (c) 2000, Len Budney. All rights reserved.
   echo0 is provided under the BSD license.
 */

/* echo0 -- print each command line argument, followed by a 0-byte. */
#include "buffer.h"
#include "strerr.h"

#define FATAL "echo0: fatal: "

int
main(int argc, char *argv[])
{
  int j;

  if (!argc) exit (0);
  for (j=1;j<argc;j++) {
    if (buffer_puts(buffer_1,argv[j])<0)
      strerr_die2sys(111,FATAL,"unable to write stdout: ");
    if (buffer_put(buffer_1,"\0",1)<0)
      strerr_die2sys(111,FATAL,"unable to write stdout: ");
  }
  if (buffer_flush(buffer_1)<0)
    strerr_die2sys(111,FATAL,"unable to write stdout: ");
  exit (0);
}
