#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "config.h"
#include "sysdep.h"

usage()
{
	printf("Usage: fixstamp filename.gz [filename.gz...]\n");
}

main(argc, argv)
int		argc;
char		**argv;
{
FILE		*wrong;
time_t		stamp;
struct stat	wrongstat;
#ifdef	HAVE_UTIME
struct utimbuf	timep;
#endif
#ifdef	HAVE_UTIMES
struct timeval	tvp[2];
#endif
unsigned char	buf[2], good, *p1, *p2;
int		i, rc;

	if (argc<2) {usage(); return 1;}
#ifdef	__EMX__
	_wildcard(&argc, &argv);
#endif
	for (i=1; i<argc; i++) {
		wrong = fopen(argv[i],BINARY_OPEN);
		if (!wrong) {
			printf("%s: open error\n",argv[i]); 
			return 1;
		}
		rc = fread(buf,1,2,wrong);
		if (rc < 2) {
			printf("%s: read error\n",argv[i]); 
			return 1;
		}
		fstat(fileno(wrong), &wrongstat);
		good = 0;
		if (buf[0]==0x1f || buf[1]==0x8b) {	/* XXX */
			printf("%s: gzipped;",argv[i]);
			fseek(wrong,4,SEEK_SET);
			rc = fread(&stamp,1,4,wrong);
			if (rc < 4) {
				printf("%s: read error\n",argv[i]); 
				return 1;
			} 
			if (stamp) {
				good = 1;
			} else {
				printf (" no timestamp present\n");
			}
		}
		fclose(wrong);
		if (good) {
			p1 = (unsigned char *) ctime(&wrongstat.st_mtime);
			*(p1+strlen(p1)-1)='\0';
			printf(" %s",p1);
#ifdef	HAVE_UTIME
			timep.actime=timep.modtime=stamp;
			utime(argv[i],&timep);
#else
#ifdef	HAVE_UTIMES
			tvp[0].tv_sec=tvp[1].tv_sec=stamp;
			tvp[0].tv_usec=tvp[1].tv_usec=0;
			utimes(argv[i],tvp);
#endif
#endif
			printf(" -> %s",ctime(&stamp));
		} else {
			printf("%s: no action taken\n",argv[i]);
		}
	}
}
