#define _POSIX_SOURCE 1
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <string.h>

/* my includes */
#include "getopt.h"
#include "finfo.h"

/* functions */
char *name=NULL;
void main(int argc, char *argv[])
{
	int fd=0, opt_index=0, c=0;
	char fname[1024]={0};
	struct stat buf[2]={0};
	struct option long_options[3] = {
		{"help", 0, 0, 'h'},
		{"version", 0, 0, 'v'},
		{0, 0, 0, 0}
	};

	name=argv[0];
	fprintf(stdout,"finfo, version "VERSION"\n"
		"    Copyright (c) 1996 Peter M. Jones, "EMAIL"\n"
		"\n");
	if(argc==1)
		help(1,NULL,'h');
	while((c=getopt_long(argc, argv, "hv", long_options, &opt_index))>-1) {
		switch (c) {
			case 'v':
				help(0,NULL,'v');
				break;
			case 'h':
				help(0,NULL,'h');
				break;
			default:
				help(0,NULL,'h');
				break;
		}
	}
	if(optind<argc) {
		if(lstat(argv[optind],&buf[0])<0) {
			perror(argv[0]);
			exit(1);
		}
		if((buf[0].st_mode&S_IFMT) == S_IFLNK) {
			fname[readlink(argv[optind],fname,sizeof(fname))+1]='\0';
			fprintf(stdout,
				"Name:              %s\n",fname);
			stat(argv[optind],&buf[1]);
			print(buf[1]);
			printf("%c",'\n');
		} else {
			stat(argv[optind],&buf[0]);
		}
		fprintf(stdout,
			"Name:              %s\n",argv[optind]);
		print(buf[0]);
	} else {
		help(1,NULL,'h');
	}
	exit(0);
}

void print(struct stat buf)
{
	dev_t maj_dev=0,min_dev=0;
	mode_t operm=0;
	char perms[11]={0}, uname[9]={0}, gname[9]={0};
	struct tm *time=NULL;

	if (buf.st_rdev) {
		maj_dev=major(buf.st_rdev);
		min_dev=minor(buf.st_rdev);
	}

	if (buf.st_rdev)
		fprintf(stdout,
			"Device:            Yes.\n"
			"   Major:          %d\n"
			"   Minor:          %d\n",maj_dev,min_dev);
	else
		fprintf(stdout,
			"Device:            No.\n");
	fprintf(stdout, "Inode:             %ld\n",buf.st_ino);
	set_perms(perms,buf);
	operm=set_octal(buf.st_mode);
	fprintf(stdout, "Mode:              (%s) (0%o)\n",perms, operm);
	if (perms[0]=='d')
		fprintf(stdout,"Subdirectories:    %d\n",buf.st_nlink);
	else
		fprintf(stdout,"Links to file:     %d\n",buf.st_nlink);
	getnames(buf.st_uid,buf.st_gid, uname,gname);
	fprintf(stdout,"Owner Name:        %s\n"
		"Group Name:        %s\n",uname,gname);
	fprintf(stdout,"Size:              %ld\n",(long int)buf.st_size);
	time=localtime(&buf.st_atime);
	fprintf(stdout,"Last accessed:     %s",asctime(time));
	time=localtime(&buf.st_mtime);
	fprintf(stdout,"Last modified:     %s",asctime(time));
	time=localtime(&buf.st_ctime);
	fprintf(stdout,"Last inode change: %s",asctime(time));
}

void getnames(long int uid, long int gid, char *uname, char *gname)
{
	struct passwd *pw=NULL;
	struct group *gpw=NULL;

	pw=getpwuid(uid);
	strcpy(uname,pw->pw_name);
	gpw=getgrgid(gid);
	strcpy(gname,gpw->gr_name);
}

void set_perms(char *perms, struct stat buf)
{
	char *modes[] = {"---","--x","-w-","-wx","r--","r-x","rw-","rwx"};
	int i=0, j=0;

	memset(perms,0,11);
	switch (buf.st_mode & S_IFMT) {
		case S_IFREG:
			perms[0]='-'; 
			break;
		case S_IFDIR:
			perms[0]='d';
			break;
		case S_IFCHR:
			perms[0]='c';
			break;
		case S_IFBLK:
			perms[0]='b';
			break;
		case S_IFLNK:
			perms[0]='l';
			break;
		case S_IFSOCK:
			perms[0]='s';
			break;
		case S_IFIFO:
			perms[0]='f';
			break;
		default:
			perms[0]='?';
			break;
	}
	for(i=2; i>=0; i--) {
		j = (buf.st_mode >> (i*3)) & 07;
		strcat(perms, modes[j]);
	}
	if ((buf.st_mode & S_ISUID) != 0) {
		if(perms[3]=='x')
			perms[3] = 's';
		else
			perms[3] = 'S';
	}
	if ((buf.st_mode & S_ISGID) != 0) {
		if(perms[6]=='x')
			perms[6] = 's';
		else
			perms[6] = 'S';
	}
	if ((buf.st_mode & S_ISVTX) != 0) {
		if(perms[9]=='x')
			perms[9] = 't';
		else
			perms[9] = 'T';
	}
}

mode_t set_octal(mode_t oct)
{
	oct&=(~S_IFMT);
	return(oct);
}

void help(int exitval, char *fname, char prob)
{
	FILE *fp=NULL;

	fp=fdopen(exitval+1,"w");
	switch (prob) {
		case 'h':
			fprintf(fp,"\nusage: finfo filename\n");
			break;
		case 'v':
			break;
	}
	exit(exitval);
}
