#!/bin/sh
# tst.sh
# $Id: tst.sh,v 1.1 2000/03/18 21:29:06 gwiley Exp $
#
# regression tests for filechkd
#

fnpid="$PWD/filechkd.pid"
dirconf="$PWD/etc"
fnlog="$PWD/filechkd.log"
freq=5
dir_src=`pwd`/incoming
dir_dst=`pwd`/dest
dir_etc=`pwd`/etc
logsev="debug"
quiet="s"

printf "start filechkd test script\n\n"

printf "many of the steps in this script will involve long delays, be "
printf "patient and try to not terminate it please...\n\n"

#-------------------- figure out which egrep we have
# for quite operation...
# sun's egrep likes -s
# gnu egrep likes -q
egrep -q freq tst.sh >/dev/null 2>&1
if [ "$?" = "0" ]
then
	quiet="q"
else
	quiet="s"
fi

#-------------------- clean up any leftovers from prev. tests

printf "cleaning up..."

rm -f $dir_dst/*dst $dir_dst/*dst.[0-9] $dir_src/*src filechkd.log $dir_src/*lck $dir_src/*stab

printf "ok\n"

#-------------------- generate the test filespecs
[ ! -d $dir_etc ] && mkdir $dir_etc
[ ! -d $dir_src ] && mkdir $dir_src
[ ! -d $dir_dst ] && mkdir $dir_dst

cat <<EOF > etc/basic.fs
SOURCE   $dir_src/basic.src
DEST     $dir_dst/basic.dst
RMSOURCE true
MINAGE   6
EOF

cat <<EOF > etc/backup.fs
SOURCE   $dir_src/backup.src
DEST     $dir_dst/backup.dst
RMSOURCE true
NBACKUPS 3
MINAGE   6
EOF

cat <<EOF > etc/lock.fs
SOURCE   $dir_src/lock.src
DEST     $dir_dst/lock.dst
LOCKFILE $dir_src/lock.lck
MINAGE   5
EOF

cat <<EOF > etc/stab.fs
SOURCE   $dir_src/stab.src
DEST     $dir_dst/stab.dst
STABFILE $dir_src/stab.stab
RMSTAB   true
MINAGE   0
EOF

cat <<EOF > etc/uidgid.fs
SOURCE   $dir_src/uidgid.src
DEST     $dir_dst/uidgid.dst
USER     bin
GROUP    bin
STAB     $dir_src/uidgid.stab
MINAGE   0
EOF

#-------------------- start filechkd
printf "starting filechkd..."

# this will run as a daemon for us
../filechkd -p $fnpid -c $dirconf -f $freq -l $fnlog -L $logsev

sleep 1

if [ -r $fnpid ]
then
	pid=`cat $fnpid`
	if [ -d /proc ]
	then
		if [ ! -d /proc/$pid ]
		then
			printf "error - not running\n"
			exit 1
		fi
	else
		printf "unable to determine run state..."
	fi
else	
	printf "error - not running\n"
	exit 1
fi

printf "ok\n"

#-------------------- basic

printf "basic test: "
if [ ! -r etc/basic.fs ]
then
	printf "skipping\n"
else
	fn=$dir_src/basic.src
	fndst=$dir_dst/basic.dst

	printf "this file will have 5 lines total, delivered at intervals\n" > $fn
	printf "."
	# freq + 1
	sleep 6
	printf "line 2\n" >> $fn
	printf "."
	printf "line 3\n" >> $fn
	printf "."
	printf "line 4\n" >> $fn
	printf "."
	sleep 6
	printf "line 5\n" >> $fn
	printf "."
	printf "waiting..."
	# freq * 2
	sleep 10
	set -- `wc -l $fndst`
	if [ "$1" = "5" ]
	then
		if [ -r $fn ]
		then
			printf " ==> FAIL\n"
		else
			printf " ==> pass\n"
		fi
	else
		printf " ==> FAIL\n"
	fi
fi

#-------------------- backup
printf "backup test: "
if [ ! -r etc/backup.fs ]
then
	printf "skipping\n"
else
	fn=$dir_src/backup.src
	printf "this file is meant as a test for the backup functions\n" > $fn
	printf "."
	sleep 11
	printf "second file in\n" > $fn
	printf "."
	sleep 11
	printf "third file in\n" > $fn
	printf "."
	sleep 11
	printf "fourth file in\n" > $fn
	printf "."
	sleep 11
	printf "fifth file in\n" > $fn
	printf "."
	sleep 11

	status="FAIL"

	set -- `ls -1 $dir_dst/backup* | wc -l`
	if [ "$1" = "4" ]
	then
		egrep -$quiet fifth $dir_dst/backup.dst
		if [ "$?" = "0" ]
		then
			egrep -$quiet third $dir_dst/backup.dst.1
			if [ "$?" = "0" ]
			then
				if [ ! -r $dir_dst/backup.dst.3 ]
				then
					status="pass"
				fi
			fi
		fi
	fi
	printf " ===> $status\n"
fi

#-------------------- lock
printf "lock test: "
if [ ! -r etc/lock.fs ]
then
	printf "skipping\n"
else
	fn=$dir_src/lock.src
	fnlck=$dir_src/lock.lck
	fndst=$dir_dst/lock.dst
	status="FAIL"

	printf "lock" > $fnlck
	printf "look for 1 line\n" > $fn
	printf "waiting..."
	# freq * 2
	sleep 16
	if [ ! -r $fndst ]
	then
		rm $fnlck
		# freq + 1
		sleep 6
		if [ -r $fndst ]
		then
			status="pass"
		fi
	fi

	printf " ==> $status\n"
fi

#-------------------- stability flag file
printf "stab flag test: "
if [ ! -r etc/stab.fs ]
then
	printf "skipping\n"
else
	fn=$dir_src/stab.src
	fnsta=$dir_src/stab.stab
	fndst=$dir_dst/stab.dst
	status="FAIL"

	printf "look for 1 line\n" > $fn
	printf "waiting..."
	sleep 11
	if [ ! -r $fndst ]
	then
	   printf "placed flag, waiting..."
		touch $fnsta
		sleep 11
		if [ -r $fndst ]
		then
			if [ ! -r $fnsta ]
			then
				status="pass"
			fi
		fi
	fi

	printf " ==> $status\n"
fi

#-------------------- uidgid
printf "uidgid test: "
if [ ! -r etc/uidgid.fs ]
then
	printf "skipping\n"
else
	fn=$dir_src/uidgid.src
	fnsta=$dir_src/uidgid.stab
	fndst=$dir_dst/uidgid.dst
	status="FAIL"

	printf "look for 1 line\n" > $fn
	touch $fnsta
	printf "waiting..."
	sleep 20
	if [ -r $fndst ]
	then
		set -- `ls -l $fndst`
		if [ "$3:$4" = "bin:bin" ]
		then
			status="pass"
		fi
	fi

	printf " ==> $status\n"
fi

#-------------------- end of tests

kill -TERM $pid

printf "\nend filechkd test script\n"

# tst.sh
