/* str.c
	string utility functions
*/
#include <ctype.h>
#include <string.h>

/*---------------------------------------- strlower
  convert all characters in the string to lower case
*/
void
strlower(char *str)
{
	int l;
	int i;

	if(str == NULL)
		return;

	l = strlen(str);
	for(i=0; i<l; i++)
		str[i] = tolower(str[i]);

	return;
} /* strlower */

/*---------------------------------------- strupper
  convert all characters in the string to upper case
*/
void
strupper(char *str)
{
	int l;
	int i;

	if(str == NULL)
		return;

	l = strlen(str);
	for(i=0; i<l; i++)
		str[i] = toupper(str[i]);

	return;
} /* strupper */

/*---------------------------------------- strrspn
  returns a pointer to the first  character  in  the
  string that is not one of the characters in tc, iterating
  over the string from the rear
 */
char *
strrspn(const char *str, const char *tc)
{
	int  c;
	char *retval = NULL;

	/* this is non-std but I'd rather not core... */
	if(str == NULL || tc == NULL || *tc == '\0')
		return NULL;

	for(c = strlen(str) - 1; c > -1 && strchr(tc, str[c]); c--);

	if(c > -1 && (str + c) != '\0')
		retval = (char *)str + c + 1;

	return retval;
} /* strrspn */

/* str.c */
