// filespec.h
//
// this class represents everything interesting about a log
// file specification and provides a run-time representation
// of a particular monitor.

#ifndef FILESPEC_H
#define FILESPEC_H

#include <stdio.h>

class Logger;

class FileSpec
{
	//-------------------- public
	public :

	// create a new filespec using configuration values in  fn_conf
	// if a log is specified then it will be used to log activity
	FileSpec(const char *fn_conf, Logger *log = NULL);
	~FileSpec();

	// return true if the filespec is properly configured
	bool isValid(void) { return isvalid; };

	// return true if the source file has aged enough to be stable
	// this involves checking and storing file info
	bool isStable(void);

	// execute the copy from source to dest
	// and follow any special instructions per config values
	int copyFile(void);

	// get the name for this filespec (from the config file)
	const char *getName(void) { return name; };

	//-------------------- private
	private :

	Logger *log;

	// configuration values
	char   *name;
	char   *fn_src;
	char   *fn_dst;
	char   *fn_lck;
	char   *fn_sta;
	int    age_min;
	uid_t  uid;
	gid_t  gid;
	int    mode;
	int    nbackups;
	char   *mail;
	bool   rmsrc;
	bool   rmsta;
	bool   rmlck;
	bool   chgown;

	// run-time values
	bool     isvalid;
	bool     copied;
	bool     locked;
	time_t   prevtm;
	fpos_t   prevsz;
	time_t   copytm_src;
	fpos_t   copysz_src;
	time_t   copytm_dst;
	fpos_t   copysz_dst;

	int  readConf(const char *fn);
	void reset(void);
	int  makeBackups(const char *fn);
	int  cp(const char *src, const char *dst);
	int  setowner(void);
	int  locksource(char mode = 'l');
	int  unlocksource(void) { return locksource('u'); };

}; // FileSpec

#endif // FILESPEC_H
// filespec.h
