dnl $Id: filespec.m4,v 1.3 2000/03/18 17:44:33 gwiley Exp $
dnl filespec details for use in text and man pages (not HTML)
ifdef(`MAN', `.LP')
Each file that is monitored must have a filespec
configuration which is a text file consisting of 
attribute/value pairs (1 per line).  These files are
named with an ".fs" suffix e.g. something.fs and are 
placed in the configuration directory specified on the
command line.  The default configuration directory is
/usr/local/etc/filechkd, change this via the -c command 
line option.
ifdef(`MAN', `.LP')
Blank lines and lines beginning with '#' are ignored 
as comments.  Only the first four characters of the
attribute name is considered (case is ignored).
ifdef(`MAN', `.LP')
The following attributes can be assigned for a file:
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI NAME\  name', `NAME name')
If no name is specified then the name of the filespec file
is used.  This name is written to log records, useful since
all logging is done to a single file.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI SOURCEFILE\  filename', `SOURCEFILE filename')
The name of the file to monitor - this should be the
absolute path to the file since filechkd changes its running
directory to '/'.  Wild-cards/globbing is currently NOT
supported. This attribute is mandatory.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI DESTFILE\  filename', `DESTFILE filename')
The name of the file to copy the source file to once it is
determined stable. Wild-cards/globbing is currently NOT
supported. This attribute is mandatory.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI LOCKFILE\  filename', `LOCKFILE filename')
If this file exists then the source file is always
considered unstable.  Once the lock file no longer exists
the source file must still meet other stability tests before
being copied.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI STABLEFLAG\  filename', `STABLEFLAG filename')
If this file exists then the source file is considered
stable, it does not need to meet any other stability tests.
This can be useful when another process knows that it is
stable and wants it to be picked up next time tests are
done.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI USER\  username', `USER username')
Change the owner of the destination file to the specified
user name.  If this is not given then the owner of the
source file will also be the owner of the destination file
and any backups that might be created.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI GROUP\  groupname', `GROUP groupname')
Change the group of the destination file to the specified
group name.  If this is not given then the group of the
source file will also be the group of the destination file
and any backups that might be created.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI MODE\  accessmode', `MODE accessmode')
Change the access mode on the destination file to the
specified mode.  This must be using numeric, octal notation
such as 660 for -rw-rw---.  If this is not given then the
mode on the source file will be used for the destination and
any backup files.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI NBACKUPS\  num', `NBACKUPS num')
Make "num" backups of the destination file, as new files are
copied the backups are "rolled" using integer suffixes.  For
example a destination file /archive/foo might have backups
named /archive/foo.0 and /archive/foo.1.  If a new foo needs
to be created and NBACKUPS is set to 2 then foo.1 would be
unlinked, foo.0 would be renamed to foo.1, foo would be
renamed to foo.0 and the new foo destination file would then
be written.  If "num" is 0 then no backups are made (the
default).
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.BI MINAGE\  nseconds', `MINAGE nseconds')
A file is not considered stable until it has not been
observed to change for nseconds seconds.  Once the minimum
age has been satisfied the file will be considered stable
(unless a lock file exists) and it will be copied.  The
default minimum age is 120 seconds.
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.B RMSOURCE true', `RMSOURCE true')
If this attribute is valued with "true" then the source file
will be unlinked after the destination file has been
successfully copied. This defaults to "false".
ifdef(`MAN', `.TP')
ifelse(MAN, 1, `.B RMSTABLEFLAG true', `RMSTABLEFLAG true')
If this attribute is valued with "true" then the file used
to flag stability will be removed once the destination file
is successfully written.  This defaults to "false".  
ifdef(`MAN', `.LP')
A simple filespec might contain the following lines:
ifdef(`MAN', `.RS')
ifdef(`MAN', `.br')dnl
SOURCEFILE /public/ftp/incoming/myproj.tar
ifdef(`MAN', `.br')dnl
DESTFILE   /public/ftp/myproj/myproj.tar
ifdef(`MAN', `.br')dnl
USER       theman
ifdef(`MAN', `.br')dnl
GROUP      wheel
ifdef(`MAN', `.br')dnl
MODE       644
ifdef(`MAN', `.br')dnl
RMSOURCE   true
ifdef(`MAN', `.RE')
dnl end filespec.m4
