dnl $Id: INSTALL.m4,v 1.4 2000/03/18 21:01:38 gwiley Exp $
include(defines.m4)dnl
Installation and Build Instructions for filechkd
------------------------------------------------

Thanks to the powerful GNU configuration and build utilities
you should be able to use filechkd on just about any UNIXish
platform.  If you have platform specific problems please write
me (MAILADDR) and I will do what I can to address them.
If you successfully overcome porting problems I would like to
know what you did so that I can incorporate the changes in
the distribution.

Contents
--------
Dependencies
Building and Installing from Sources
Execution Tests
Uninstalling from Sources
Installing Binary Packages
Uninstalling Binary Packages


Dependencies
------------
This package relies on the following programs and libraries:

- a recent C++ compiler (like g++ 2.95)
- C++ Standard Library or at least a recent STL, gnu C++ ships with it


Building and Installing from Sources
------------------------------------
To build and install you should be able to follow these steps:

	./configure
	make
	make install

Refer to the man page (filechkd.1) and on-line help (filechkd -h) for
a detailed description of options and usage.


Execution Tests
---------------
A few tests are included in for regression testing and to try and
perform a sanity check on new installations. If you want peace of 
mind that the program is likely to perform as described in the 
docs then you may want to run these tests.

Follow these steps after building:

	cd test
	make
	./tst

If you get messages indicating that a series of tests passed then
as far as I can tell things should work.  However, if you see any
message indicating failed tests then you should look at the
log file and the directories.  Note that the uid/gid test requires
that they be run as root.

If any tests fail please send me the log file and output from
ls -lR in the test directory.


Uninstalling from Sources
-------------------------
If you kept the source tree you can uninstall by issuing
the following command in the build directory:

	make uninstall

If you did not keep the source tree you need to unarchive it
and issue the following commands:

	./configure
	make uninstall


Installing Binary Packages
--------------------------

Solaris Packages
----------------
Solaris packages are built with the following naming convention:

	filechkd-VERSION-SunOS5.7sparc-local.gz

The Sun OS release will vary and "sparc" may also be "i386", 
otherwise they all end up installing in the /usr/local tree.  
To install a Solaris package:

	# gunzip filechkd-VERSION-SunOS5.7sparc-local.gz
	# pkgadd -d ./filechkd-VERSION-SunOS5.7sparc-local

This results in a fully installed package named GSWfchkd.

Red Hat Packages
----------------
Red Hat packages for Linux are built with the following 
naming convention:

	filechkd-VERSION-1.i386.rpm

The release (VERSION) and platform (i386) may vary.  To install
the package:

	# rpm -ivh filechkd-VERSION-1.i386.rpm

Binary tarballs
---------------
Binaries for other platforms are built as tarballs which can
be installed by:

	# cd /usr/local/src
	# gunzip filechkd-VERSION-HP-UX.tar.gz
	# tar -xvf filechkd-VERSION-HP-UX.tar.gz
	# cd filechkd-VERSION
	# make install

I recommend that you leave the files created in /usr/local/src
until you have uninstalled the package.


Uninstalling Binary Packages
----------------------------

Solaris Packages
----------------
To uninstall a Solaris package:

	# pkgrm GSWfchkd

Red Hat Packages
----------------
To uninstall a Red Hat package:

	# rpm -e filechkd-VERSION-1

Binary tarballs
---------------
To uninstall a binary tarball:

	# cd /usr/local/src/filechkd-VERSION
	# make uninstall

If you removed the directory tree used for the install then
you can simply follow the installation instructions
performing a "make uninstall" in place of the "make install"

-----------
end INSTALL

$Id: INSTALL.m4,v 1.4 2000/03/18 21:01:38 gwiley Exp $
