// conffile.h
// simple configuration file
// one line per record, each line is space/tab separated attribute/value

#ifndef CONFFILE_H
#define CONFFILE_H

#include <stdio.h>

class ConfFile
{
	//-------------------- public
	public :

	ConfFile(const char *fn);
	~ConfFile();

	// get the next attribute, return EOF when done
	int nextAttr(char **pattr, char **pval);

	// return true if any errors were encountered reading/parsing the file
	bool hadErrors(void) { return haderrors; };

	// longest line to be expected
	static int maxline;

	//-------------------- private
	private :

	FILE *fh;
	bool haderrors;

}; // ConfFile

#endif // CONFFILE_H

// conffile.h
