// conffile.cc
//
// ignores blank lines and lines beginning with #
// tolerates CRLF or LF terminated lines

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <string.h>
#include "conffile.h"

// the longest line expected 
// TODO: this should get adjusted at run-time
//       based on the length of the lines we run into
int ConfFile::maxline = 255;

//---------------------------------------- ConfFile
ConfFile::
ConfFile(const char *fn)
{
	haderrors = false;
	fh = fopen(fn, "r");
	if(fh == NULL)
		haderrors = true;
} // ConfFile

//---------------------------------------- ~ConfFile
ConfFile::
~ConfFile()
{
	if(fh)
		fclose(fh);
} // ~ConfFile

//---------------------------------------- nextAttr
// populate attr and val with attribute and value
// allocates storage using new char[] which MUST be freed by the user
int ConfFile::
nextAttr(char **pattr, char **pval)
{
	int retval         = EOF;
	int l;
	char *tok;
	static int  buflen = -1;
	static char *buf   = NULL;

	if(fh)
	{
		// adjust our buffer size as needed
		if(buflen != maxline)
		{
			if(buf)
				delete[] buf;

			buflen = maxline;
			buf = new char[buflen + 1];
		}

		if(buf)
		{
			// we will break out once we get a single valid line
			while(fgets(buf, buflen, fh))
			{
				// remove the EOL chars - any mix of CR/LF
				l = strlen(buf);
				if(buf[l-1] == '\015' || buf[l-1] == '\012')
					l--;
				if(buf[l-1] == '\015' || buf[l-1] == '\012')
					l--;
				buf[l] = '\0';

				// skip leading whitespace
				tok = buf + strspn(buf, "	 ");
				if(*tok == '#')
					continue;
				
				// skip tabs and spaces following the attribute
				l = strcspn(tok, " 	");
				tok[l] = '\0';
				if(tok == 0 || tok[l+1] == '\0')
					continue;

				*pattr = new char[l];
				if(*pattr == NULL)
				{
					haderrors = true;
					break;
				}
				strcpy(*pattr, tok);

				// skip tabs and spaces preceeding the value

				tok += strlen(tok) + 1;
				l   = strspn(tok, "	 ");
				tok = tok + l;

				*pval = new char[strlen(tok) + 1];
				if(*pval == NULL)
				{
					haderrors = true;
					break;
				}
				strcpy(*pval, tok);

				// we got both an attribute and value so we are done
				retval = 0;
				break;
			} // while(fgets(buf, buflen, fh))
		}
		else
			haderrors = true;
	}

	return retval;
} // nextAttr

// conffile.cc
