/*
 * Copyright 1996 by E. Toernig (froese@gmx.de)
 */
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <etlib/cattr.h>
#include <etlib/error.h>
#include "mk_ff.h"
#include "emit.h"
#include "hashs.h"

static int
parse(char *str, char *dst, char *fmt, ...)
{
    void *arg = &fmt + 1;
    int nargs = 0;
    long n;
    char *x;

    while (*fmt)
    {
	switch (*fmt++)
	{
	    case ' ':
	    	while (is_space(*str))
		    str++;
		continue;
	    case '9':
		if (not is_digit(*str))
		    break;
		for (n = 0; is_digit(*str); ++str)
		    n = 10 * n + digitval(*str);
		**((long **)arg)++ = n;
		nargs++;
		continue;
	    case 'x':
		x = dst;
		if (*fmt == ' ')
		{
		    if (*str == 0)
			break;
		    while (*str && not is_space(*str))
			*dst++ = *str++;
		}
		else if (*fmt)
		{
		    if (*str == 0)
			break;
		    while (*str && *str != *fmt)
			*dst++ = *str++;
		}
		else
		{
		    while (*str)
			*dst++ = *str++;
		    while (dst > x && is_space(dst[-1]))
			--dst;
		}
		*dst++ = 0;
		**((char ***)arg)++ = x;
		nargs++;
		continue;
	    default:
	    	if (*str++ != fmt[-1])
		    break;
		continue;
	}
	break;
    }
    return nargs;
}

static int
make_year(int day, int mon)
{
    extern struct tm *current_tm;

    int dm = mon - current_tm->tm_mon;
    int dd = day - current_tm->tm_mday;
    int d = 1900;

    if (dm > 0 || (dm == 0 && dd > 0))
	d--;

    return current_tm->tm_year + d;
}

static int
make_day(int day, char *month, int year)
{
    static int mday[] = { 0,31,59,90,120,151,181,212,243,273,304,334 };
    static char months[] = "janfebmaraprmayjunjulaugsepoctnovdec"
			   "janfebmraprmaijunjulaugsepoktnovdez";
    static char *mon = months;
    int l, m;

    for (l = 0; l < 2; ++l)
    {
	for (m = 0; m < 12; ++m)
	    if (to_lower(month[2]) == mon[m*3 + 2]
	     && to_lower(month[1]) == mon[m*3 + 1]
	     && to_lower(month[0]) == mon[m*3 + 0])
	    {
		if (year == -1)
		    year = make_year(day, m);
		year -= 1970;

		if (m < 2 || (year + 2) % 4)
		    day--;
		return year * 365 + (year + 1) / 4 + mday[m] + day;
	    }
	mon += 12 * 3;
	if (*mon == 0)
	    mon = months;
    }
    error("Unrecognized month-name '%s'.", month);
    return 0;
}

int
ignore_component(char *path)
{
    char *x, *y;

    if (not have_ignore)
	return 0;

    for (x = path; y = strchr(x, '/'); x = y+1)
    {
	*y = 0;
	if (test_ignore(x) || (x != path && test_ignore(path)))
	{
	    *y = '/';
	    return 1;
	}
	*y = '/';
    }
    return test_ignore(x) || (x != path && test_ignore(path));
}

void
process_tar(void)
{
    char buf[PATH_LEN], pool[PATH_LEN];
    char *perms, *owner, *month, *path;
    long size, day, hour, minute, year, dev;
    struct entry entry[1];
    char *misc;

    while (fgets(buf, sizeof(buf), stdin))
    {
	if (parse(buf, pool, "COMMENT: x", &misc) == 1)
	{
	    emit_comment(misc);
	    continue;
	}
	else if (parse(buf, pool, "x x 9 x 9 9:9 9 x", &perms, &owner, &size,
	    		&month, &day, &hour, &minute, &year, &path) == 9
	    && strlen(perms) == 10
	    && strlen(month) == 3
	    && day >= 1 && day < 32
	    && hour >= 0 && hour < 24
	    && minute >= 0 && minute < 60
	    && year >= 1970 && year < 2100
	    && *path)
	{
	    if (perms[0] != '-' || ignore_component(path))
		continue;

	    entry->size = size;
	    entry->date = make_day(day, month, year);
	    emit_file(entry, path);
	}
	else if (parse(buf, pool, "x x 9,9 x 9 9:9 9 x", &perms, &owner, &dev, &dev,
	    		&month, &day, &hour, &minute, &year, &path) == 10)
	    continue;
	else if (parse(buf, pool, "x", &misc) == 1)
	    error("Malformed: '%s'.", misc);
	else
	    fatal("Internal error: process_tar.");
    }
}



void
process_cpio(void)
{
    char buf[PATH_LEN], pool[PATH_LEN];
    char *perms, *owner, *group, *month, *date, *path;
    long nlink, size, day, year, dev;
    struct entry entry[1];
    char *misc;

    while (fgets(buf, sizeof(buf), stdin))
    {
	if (parse(buf, pool, "COMMENT: x", &misc) == 1)
	{
	    emit_comment(misc);
	    continue;
	}
	else if (parse(buf, pool, "x 9 x x 9 x 9 x x", &perms, &nlink,
	    		&owner, &group, &size, &month, &day, &date, &path) == 9
	    && strlen(perms) == 10
	    && strlen(month) == 3
	    && day >= 1 && day < 32
	    && (strlen(date) & ~1) == 4
	    && *path)
	{
	    if (perms[0] != '-' || ignore_component(path))
		continue;

	    if (date[2] == ':')
		year = -1;
	    else if (parse(date, 0, "9", &year) == 1 && year >= 1970 && year < 2100)
		;
	    else
	    {
		error("Bad year '%s'.", date);
		continue;
	    }

	    entry->size = size;
	    entry->date = make_day(day, month, year);
	    emit_file(entry, path);
	}
	else if (parse(buf, pool, "x 9 x x 9, 9 x 9 x x", &perms, &nlink,
	    		&owner, &group, &dev, &dev, &month, &day, &date, &path) == 10)
	    continue;
	else if (parse(buf, pool, "x", &misc) == 1)
	    error("Malformed: '%s'.", misc);
	else
	    fatal("Internal error: process_cpio.");
    }
}
