#include <sys/types.h>
#include <stdlib.h>
#include "generic.h"
#include "error.h"

static char nomem[] = "Out of memory.\n";

void *
xmalloc(size_t size)
{
    void *ptr;

    if (size == 0)
	size = 1;

    ptr = malloc(size ? size : 1);

    if (ptr == 0)
	fatal(nomem);
    return ptr;
}

void *
xcalloc(size_t nelem, size_t elem_size)
{
    void *ptr;

    if ((nelem | elem_size) == 0)
	nelem = elem_size = 1;

    ptr = calloc(nelem, elem_size);

    if (ptr == 0)
	fatal(nomem);
    return ptr;
}

void *
xrealloc(void *ptr, size_t newsize)
{
    if (newsize == 0)
	newsize = 1;

    ptr = ptr ? realloc(ptr, newsize) : malloc(newsize);

    if (ptr == 0)
	fatal(nomem);
    return ptr;
}

void
xfree(void *ptr)
{
    if (ptr)
	free(ptr);
}

void *
xstrdup(void *str)
{
    int l;

    if (str == 0)
	return 0;

    l = strlen(str) + 1;

    return memcpy(xmalloc(l), str, l);
}

void *
xmemdup(void *mem, size_t size)
{
    if (mem == 0)
	return 0;

    return memcpy(xmalloc(size), mem, size);
}
