#ifndef TINFO_H
#define TINFO_H

typedef unsigned char ti_byte;
typedef unsigned short ti_word;

#define TIMAGIC 0432	// magic number of compiled terminfo files.
#define TICSIZE	4096	// maximum allowed size of a compiled terminfo file.

struct tinfo		// you mustn't touch the fields!
{			// just allocate and pass it to the functions.
    ti_word magic;
    ti_word nname;
    ti_word nflgs;
    ti_word nnums;
    ti_word nstrs;
    ti_word nchrs;
    ti_byte data[TICSIZE - 6*sizeof(ti_word)];
    ti_byte *pflgs;
    ti_word *pnums;
    ti_word *pstrs;
    ti_byte *pchrs;
};

// extracted from term.h

enum ti_str {			// pass this identifiers to tigetstr()
    ti_back_tab = 256,		// Back tab
    ti_bell,			// Audible signal (bell)
    ti_carriage_return,		// Carriage return (*)
    ti_change_scroll_region,	// change to lines #1 thru #2 (vt100) (G)
    ti_clear_all_tabs,		// Clear all tab stops.
    ti_clear_screen,		// Clear screen (*)
    ti_clr_eol,			// Clear to end of line
    ti_clr_eos,			// Clear to end of display (*)
    ti_column_address,		// Set cursor column (G)
    ti_command_character,	// Term. settable cmd char in prototype
    ti_crsr_address,		// Cursor motion to row #1 col #2 (G)
    ti_crsr_down,		// Down one line
    ti_crsr_home,		// Home cursor (if no cup)
    ti_crsr_invisible,		// Make cursor invisible
    ti_crsr_left,		// Move cursor left one space.
    ti_crsr_mem_address,	// Memory relative cursor addressing.
    ti_crsr_normal,		// Make cursor appear normal (undo vs/vi)
    ti_crsr_right,		// Non-destructive space (cursor right)
    ti_crsr_to_ll,		// Last line, first column (if no cup)
    ti_crsr_up,			// Upline (cursor up)
    ti_crsr_visible,		// Make cursor very visible
    ti_dlt_character,		// Delete character (*)
    ti_dlt_line,		// Delete line (*)
    ti_dis_status_line,		// Disable status line
    ti_down_half_line,		// Half-line down (forward 1/2 linefeed)
    ti_entr_alt_charset_mode,	// Start alternate character set
    ti_entr_blink_mode,		// Turn on blinking
    ti_entr_bold_mode,		// Turn on bold (extra bright) mode
    ti_entr_ca_mode,		// String to begin programs that use cup
    ti_entr_delete_mode,	// Delete mode (enter)
    ti_entr_dim_mode,		// Turn on half-bright mode
    ti_entr_insert_mode,	// Insert mode (enter);
    ti_entr_secure_mode,	// Turn on blank mode (chars invisible)
    ti_entr_protected_mode,	// Turn on protected mode
    ti_entr_reverse_mode,	// Turn on reverse video mode
    ti_entr_standout_mode,	// Begin stand out mode
    ti_entr_underline_mode,	// Start underscore mode
    ti_erase_chars,		// Erase #1 characters (G)
    ti_exit_alt_charset_mode,	// End alternate character set
    ti_exit_attribute_mode,	// Turn off all attributes
    ti_exit_ca_mode,		// String to end programs that use cup
    ti_exit_delete_mode,	// End delete mode
    ti_exit_insert_mode,	// End insert mode;
    ti_exit_standout_mode,	// End stand out mode
    ti_exit_underline_mode,	// End underscore mode
    ti_flash_screen,		// Visible bell (may not move cursor)
    ti_form_feed,		// Hardcopy terminal page eject (*)
    ti_from_status_line,	// Return from status line
    ti_init_1string,		// Terminal initialization string
    ti_init_2string,		// Terminal initialization string
    ti_init_3string,		// Terminal initialization string
    ti_init_file,		// Name of file containing is
    ti_ins_character,		// Insert character
    ti_ins_line,		// Add new blank line (*)
    ti_ins_padding,		// Insert pad after character inserted (*)
    ti_key_backspace,	// KEY_BACKSPACE, 0407, Sent by backspace key
    ti_key_catab,	// KEY_CATAB, 0526, Sent by clear-all-tabs key.
    ti_key_clear,	// KEY_CLEAR, 0515, Sent by clear screen or erase key.
    ti_key_ctab,	// KEY_CTAB, 0525, Sent by clear-tab key
    ti_key_dc,		// KEY_DC, 0512, Sent by delete character key.
    ti_key_dl,		// KEY_DL, 0510, Sent by delete line key.
    ti_key_down,	// KEY_DOWN, 0402, Sent by terminal down arrow key
    ti_key_eic,		// KEY_EIC, 0514, Sent by rmir or smir in insert mode.
    ti_key_eol,		// KEY_EOL, 0517, Sent by clear-to-end-of-line key.
    ti_key_eos,		// KEY_EOS, 0516, Sent by clear-to-end-of-screen key.
    ti_key_f0,		// KEY_F(0), 0410, function key f0.
    ti_key_f1,		// KEY_F(1), 0411, function key f1.
    ti_key_f10,		// KEY_F(10), 0422, function key f10.
    ti_key_f2,		// KEY_F(2), 0412, function key f2.
    ti_key_f3,		// KEY_F(3), 0413, function key f3.
    ti_key_f4,		// KEY_F(4), 0414, function key f4.
    ti_key_f5,		// KEY_F(5), 0415, function key f5.
    ti_key_f6,		// KEY_F(6), 0416, function key f6.
    ti_key_f7,		// KEY_F(7), 0417, function key f7.
    ti_key_f8,		// KEY_F(8), 0420, function key f8.
    ti_key_f9,		// KEY_F(9), 0421, function key f9.
    ti_key_home,	// KEY_HOME, 0406, Sent by home key.
    ti_key_ic,		// KEY_IC, 0513, Sent by ins char/enter ins mode key.
    ti_key_il,		// KEY_IL, 0511, Sent by insert line.
    ti_key_left,	// KEY_LEFT, 0404, Sent by terminal left arrow key
    ti_key_ll,		// KEY_LL, 0533, Sent by home-down key
    ti_key_npage,	// KEY_NPAGE, 0522, Sent by next-page key
    ti_key_ppage,	// KEY_PPAGE, 0523, Sent by previous-page key
    ti_key_right,	// KEY_RIGHT, 0405, Sent by terminal right arrow key
    ti_key_sf,		// KEY_SF, 0520, Sent by scroll-forward/down key
    ti_key_sr,		// KEY_SR, 0521, Sent by scroll-backward/up key
    ti_key_stab,	// KEY_STAB, 0524, Sent by set-tab key
    ti_key_up,		// KEY_UP, 0403, Sent by terminal up arrow key
    ti_keypad_local,	// Out of "keypad transmit" mode
    ti_keypad_xmit,	// Put terminal in "keypad transmit" mode
    ti_lab_f0,		// Labels on function key f0 if not f0
    ti_lab_f1,		// Labels on function key f1 if not f1
    ti_lab_f10,		// Labels on function key f10 if not f10
    ti_lab_f2,		// Labels on function key f2 if not f2
    ti_lab_f3,		// Labels on function key f3 if not f3
    ti_lab_f4,		// Labels on function key f4 if not f4
    ti_lab_f5,		// Labels on function key f5 if not f5
    ti_lab_f6,		// Labels on function key f6 if not f6
    ti_lab_f7,		// Labels on function key f7 if not f7
    ti_lab_f8,		// Labels on function key f8 if not f8
    ti_lab_f9,		// Labels on function key f9 if not f9
    ti_meta_off,	// Turn off "meta mode"
    ti_meta_on,		// Turn on "meta mode" (8th bit)
    ti_newline,		// Newline (behaves like cr followed by lf)
    ti_pad_char,	// Pad character (rather than null)
    ti_prm_dch,		// Delete #1 chars (G*)
    ti_prm_delete_line,	// Delete #1 lines (G*)
    ti_prm_down_cursor,	// Move cursor down #1 lines. (G*)
    ti_prm_ich,		// Insert #1 blank chars (G*)
    ti_prm_index,	// Scroll forward #1 lines. (G)
    ti_prm_insert_line,	// Add #1 new blank lines (G*)
    ti_prm_left_cursor,	// Move cursor left #1 spaces (G)
    ti_prm_right_cursor,// Move cursor right #1 spaces. (G*)
    ti_prm_rindex,	// Scroll backward #1 lines. (G)
    ti_prm_up_cursor,	// Move cursor up #1 lines. (G*)
    ti_pkey_key,	// Prog funct key #1 to type string #2
    ti_pkey_local,	// Prog funct key #1 to execute string #2
    ti_pkey_xmit,	// Prog funct key #1 to xmit string #2
    ti_print_screen,	// Print contents of the screen
    ti_prtr_off,	// Turn off the printer
    ti_prtr_on,		// Turn on the printer
    ti_repeat_char,	// Repeat char #1 #2 times.  (G*)
    ti_reset_1string,	// Reset terminal completely to sane modes.
    ti_reset_2string,	// Reset terminal completely to sane modes.
    ti_reset_3string,	// Reset terminal completely to sane modes.
    ti_reset_file,	// Name of file containing reset string.
    ti_restore_cursor,	// Restore cursor to position of last sc.
    ti_row_address,	// Like hpa but sets row. (G)
    ti_save_cursor,	// Save cursor position.
    ti_scrll_forward,	// Scroll text up
    ti_scrll_reverse,	// Scroll text down
    ti_set_attributes,	// Define the video attributes (G9)
    ti_set_tab,		// Set a tab in all rows, current column.
    ti_set_window,	// Current window is lines #1-#2 cols #3-#4
    ti_tab,		// Tab to next 8 space hardware tab stop.
    ti_to_status_line,	// Go to status line, col #1
    ti_underline_char,	// Underscore one char and move past it
    ti_up_half_line,	// Half-line up (reverse 1/2 linefeed)
    ti_init_prog,	// Path name of program for init.
    ti_key_a1,		// KEY_A1, 0534, Upper left of keypad
    ti_key_a3,		// KEY_A3, 0535, Upper right of keypad
    ti_key_b2,		// KEY_B2, 0536, Center of keypad
    ti_key_c1,		// KEY_C1, 0537, Lower left of keypad
    ti_key_c3,		// KEY_C3, 0540, Lower right of keypad
    ti_prtr_non,	// Turn on the printer for #1 bytes.
    ti_char_padding,	// Like ip but when in replace mode
    ti_acs_chars,	// Graphic charset pairs aAbBcC - def=vt100
    ti_plab_norm,	// Prog label #1 to show string #2
    ti_key_btab,	// KEY_BTAB, 0541, Back tab key
    ti_entr_xon_mode,	// Turn on xon/xoff handshaking
    ti_exit_xon_mode,	// Turn off xon/xoff handshaking
    ti_entr_am_mode,	// Turn on automatic margins
    ti_exit_am_mode,	// Turn off automatic margins
    ti_xon_character,	// X-on character
    ti_xoff_character,	// X-off character
    ti_ena_acs,		// Enable alternate char set
    ti_labl_on,		// Turn on soft labels
    ti_labl_off,	// Turn off soft labels
    ti_key_beg,		// KEY_BEG, 0542, beg(inning) key
    ti_key_cancel,	// KEY_CANCEL, 0543, cancel key
    ti_key_close,	// KEY_CLOSE, 0544, close key
    ti_key_command,	// KEY_COMMAND, 0545, cmd (command) key
    ti_key_copy,	// KEY_COPY, 0546, copy key
    ti_key_create,	// KEY_CREATE, 0547, create key
    ti_key_end,		// KEY_END, 0550, end key
    ti_key_enter,	// KEY_ENTER, 0527, Enter/send (unreliable)
    ti_key_exit,	// KEY_EXIT, 0551, exit key
    ti_key_find,	// KEY_FIND, 0552, find key
    ti_key_help,	// KEY_HELP, 0553, help key
    ti_key_mark,	// KEY_MARK, 0554, mark key
    ti_key_message,	// KEY_MESSAGE, 0555, message key
    ti_key_move,	// KEY_MOVE, 0556, move key
    ti_key_next,	// KEY_NEXT, 0557, next object key
    ti_key_open,	// KEY_OPEN, 0560, open key
    ti_key_options,	// KEY_OPTIONS, 0561, options key
    ti_key_previous,	// KEY_PREVIOUS, 0562, previous object key
    ti_key_print,	// KEY_PRINT, 0532, print or copy
    ti_key_redo,	// KEY_REDO, 0563, redo key
    ti_key_reference,	// KEY_REFERENCE, 0564, ref(erence) key
    ti_key_refresh,	// KEY_REFRESH, 0565, refresh key
    ti_key_replace,	// KEY_REPLACE, 0566, replace key
    ti_key_restart,	// KEY_RESTART, 0567, restart key
    ti_key_resume,	// KEY_RESUME, 0570, resume key
    ti_key_save,	// KEY_SAVE, 0571, save key
    ti_key_suspend,	// KEY_SUSPEND, 0627, suspend key
    ti_key_undo,	// KEY_UNDO, 0630, undo key
    ti_key_sbeg,	// KEY_SBEG, 0572, shifted beginning key
    ti_key_scancel,	// KEY_SCANCEL, 0573, shifted cancel key
    ti_key_scommand,	// KEY_SCOMMAND, 0574, shifted command key
    ti_key_scopy,	// KEY_SCOPY, 0575, shifted copy key
    ti_key_screate,	// KEY_SCREATE, 0576, shifted create key
    ti_key_sdc,		// KEY_SDC, 0577, shifted delete char key
    ti_key_sdl,		// KEY_SDL, 0600, shifted delete line key
    ti_key_select,	// KEY_SELECT, 0601, select key
    ti_key_send,	// KEY_SEND, 0602, shifted end key
    ti_key_seol,	// KEY_SEOL, 0603, shifted clear line key
    ti_key_sexit,	// KEY_SEXIT, 0604, shifted exit key
    ti_key_sfind,	// KEY_SFIND, 0605, shifted find key
    ti_key_shelp,	// KEY_SHELP, 0606, shifted help key
    ti_key_shome,	// KEY_SHOME, 0607, shifted home key
    ti_key_sic,		// KEY_SIC, 0610, shifted input key
    ti_key_sleft,	// KEY_SLEFT, 0611, shifted left arrow key
    ti_key_smessage,	// KEY_SMESSAGE, 0612, shifted message key
    ti_key_smove,	// KEY_SMOVE, 0613, shifted move key
    ti_key_snext,	// KEY_SNEXT, 0614, shifted next key
    ti_key_soptions,	// KEY_SOPTIONS, 0615, shifted options key
    ti_key_sprevious,	// KEY_SPREVIOUS, 0616, shifted prev key
    ti_key_sprint,	// KEY_SPRINT, 0617, shifted print key
    ti_key_sredo,	// KEY_SREDO, 0620, shifted redo key
    ti_key_sreplace,	// KEY_SREPLACE, 0621, shifted replace key
    ti_key_sright,	// KEY_SRIGHT, 0622, shifted right arrow
    ti_key_srsume,	// KEY_SRSUME, 0623, shifted resume key
    ti_key_ssave,	// KEY_SSAVE, 0624, shifted save key
    ti_key_ssuspend,	// KEY_SSUSPEND, 0625, shifted suspend key
    ti_key_sundo,	// KEY_SUNDO, 0626, shifted undo key
    ti_req_for_input,	// send next input char (for ptys)
    ti_key_f11,		// KEY_F(11), 0423, function key f11.
    ti_key_f12,		// KEY_F(12), 0424, function key f12.
    ti_key_f13,		// KEY_F(13), 0425, function key f13.
    ti_key_f14,		// KEY_F(14), 0426, function key f14.
    ti_key_f15,		// KEY_F(15), 0427, function key f15.
    ti_key_f16,		// KEY_F(16), 0430, function key f16.
    ti_key_f17,		// KEY_F(17), 0431, function key f17.
    ti_key_f18,		// KEY_F(18), 0432, function key f18.
    ti_key_f19,		// KEY_F(19), 0433, function key f19.
    ti_key_f20,		// KEY_F(20), 0434, function key f20.
    ti_key_f21,		// KEY_F(21), 0435, function key f21.
    ti_key_f22,		// KEY_F(22), 0436, function key f22.
    ti_key_f23,		// KEY_F(23), 0437, function key f23.
    ti_key_f24,		// KEY_F(24), 0440, function key f24.
    ti_key_f25,		// KEY_F(25), 0441, function key f25.
    ti_key_f26,		// KEY_F(26), 0442, function key f26.
    ti_key_f27,		// KEY_F(27), 0443, function key f27.
    ti_key_f28,		// KEY_F(28), 0444, function key f28.
    ti_key_f29,		// KEY_F(29), 0445, function key f29.
    ti_key_f30,		// KEY_F(30), 0446, function key f30.
    ti_key_f31,		// KEY_F(31), 0447, function key f31.
    ti_key_f32,		// KEY_F(32), 0450, function key f32.
    ti_key_f33,		// KEY_F(33), 0451, function key f33.
    ti_key_f34,		// KEY_F(34), 0452, function key f34.
    ti_key_f35,		// KEY_F(35), 0453, function key f35.
    ti_key_f36,		// KEY_F(36), 0454, function key f36.
    ti_key_f37,		// KEY_F(37), 0455, function key f37.
    ti_key_f38,		// KEY_F(38), 0456, function key f38.
    ti_key_f39,		// KEY_F(39), 0457, function key f39.
    ti_key_f40,		// KEY_F(40), 0460, function key f40.
    ti_key_f41,		// KEY_F(41), 0461, function key f41.
    ti_key_f42,		// KEY_F(42), 0462, function key f42.
    ti_key_f43,		// KEY_F(43), 0463, function key f43.
    ti_key_f44,		// KEY_F(44), 0464, function key f44.
    ti_key_f45,		// KEY_F(45), 0465, function key f45.
    ti_key_f46,		// KEY_F(46), 0466, function key f46.
    ti_key_f47,		// KEY_F(47), 0467, function key f47.
    ti_key_f48,		// KEY_F(48), 0470, function key f48.
    ti_key_f49,		// KEY_F(49), 0471, function key f49.
    ti_key_f50,		// KEY_F(50), 0472, function key f50.
    ti_key_f51,		// KEY_F(51), 0473, function key f51.
    ti_key_f52,		// KEY_F(52), 0474, function key f52.
    ti_key_f53,		// KEY_F(53), 0475, function key f53.
    ti_key_f54,		// KEY_F(54), 0476, function key f54.
    ti_key_f55,		// KEY_F(55), 0477, function key f55.
    ti_key_f56,		// KEY_F(56), 0500, function key f56.
    ti_key_f57,		// KEY_F(57), 0501, function key f57.
    ti_key_f58,		// KEY_F(58), 0502, function key f58.
    ti_key_f59,		// KEY_F(59), 0503, function key f59.
    ti_key_f60,		// KEY_F(60), 0504, function key f60.
    ti_key_f61,		// KEY_F(61), 0505, function key f61.
    ti_key_f62,		// KEY_F(62), 0506, function key f62.
    ti_key_f63,		// KEY_F(63), 0507, function key f63.
    ti_clr_bol,		// Clear to beginning of line, inclusive
    ti_clear_margins,	// Clear left and right soft margins
    ti_set_left_margin,	// Set soft left margin
    ti_set_right_margin,// Set soft right margin
    ti_labl_format,	// Label format
    ti_set_clock,	// Set time-of-day clock
    ti_display_clock,	// Display time-of-day clock
    ti_remove_clock,	// Remove time-of-day clock
    ti_create_window,	// Define win #1 to go from #2,#3 to #4,#5
    ti_goto_window,	// Got to window #1
    ti_hangup,		// Hang-up phone
    ti_dial_phone,	// Dial phone number #1
    ti_quick_dial,	// Dial phone number #1, without progress detection
    ti_tone,		// Select touch tone dialing
    ti_pulse,		// Select pulse dialing
    ti_flash_hook,	// Flash the switch hook
    ti_fixed_pause,	// Pause for 2-3 seconds
    ti_wait_tone,	// Wait for dial tone
    ti_user0,		// User string 0
    ti_user1,		// User string 1
    ti_user2,		// User string 2
    ti_user3,		// User string 3
    ti_user4,		// User string 4
    ti_user5,		// User string 5
    ti_user6,		// User string 6
    ti_user7,		// User string 7
    ti_user8,		// User string 8
    ti_user9,		// User string 9
    ti_orig_pair,		// Original color-pair
    ti_orig_colors,		// Original colors
    ti_initialize_color,	// Initialize the definition of color
    ti_initialize_pair,		// Initialize color pair
    ti_set_color_pair,		// Set color pair	
    ti_set_foreground,		// Set foregrounf color
    ti_set_background,		// Set background color
    ti_change_char_pitch,	// Change no. characters per inch
    ti_change_line_pitch,	// Change no. lines per inch
    ti_change_res_horz,		// Change horizontal resolution
    ti_change_res_vert,		// Change vertical resolution
    ti_define_char,		// Define a character in a character set
    ti_entr_doublewide_mode,	// Enable double wide printing
    ti_entr_draft_quality,	// Set draft quality print
    ti_entr_italics_mode,	// Enable italics
    ti_entr_leftward_mode,	// Enable leftward carriage motion
    ti_entr_micro_mode,		// Enable micro motion capabilities
    ti_entr_near_letter_quality,// Set near-letter quality print
    ti_entr_normal_quality,	// Set normal quality print
    ti_entr_shadow_mode,	// Enable shadow printing
    ti_entr_subscript_mode,	// Enable subscript printing
    ti_entr_superscript_mode,	// Enable superscript printing
    ti_entr_upward_mode,	// Enable upward carriage motion
    ti_exit_doublewide_mode,	// Disable double wide printing
    ti_exit_italics_mode,	// Disable italics
    ti_exit_leftward_mode,	// Enable rightward (normal) carriage motion
    ti_exit_micro_mode,		// Disable micro motion capabilities
    ti_exit_shadow_mode,	// Disable shadow printing
    ti_exit_subscript_mode,	// Disable subscript printing
    ti_exit_superscript_mode,	// Disable superscript printing
    ti_exit_upward_mode,	// Enable downward (normal) carriage motion
    ti_micro_column_address,	// Like column_address for micro adjustment
    ti_micro_down,		// Like cursor_down for micro adjustment
    ti_micro_left,		// Like cursor_left for micro adjustment
    ti_micro_right,		// Like cursor_right for micro adjustment
    ti_micro_row_address,	// Like row_address for micro adjustment
    ti_micro_up,		// Like cursor_up for micro adjustment
    ti_order_of_pins,		// Matches software bits to print-head pins
    ti_prm_down_micro,		// Like parm_down_cursor for micro adjust.
    ti_prm_left_micro,		// Like parm_left_cursor for micro adjust.
    ti_prm_right_micro,		// Like parm_right_cursor for micro adjust.
    ti_prm_up_micro,		// Like parm_up_cursor for micro adjust.
    ti_select_char_set,		// Select character set
    ti_set_bottom_margin,	// Set soft bottom margin at current line
    ti_set_bottom_margin_parm,	// Set soft bottom margin
    ti_set_left_margin_parm,	// Set soft left margin
    ti_set_right_margin_parm,	// Set soft right margin
    ti_set_top_margin,		// Set soft top margin at current line
    ti_set_top_margin_parm,	// Set soft top margin
    ti_start_bit_image,		// Start printing bit image graphics
    ti_start_char_set_def,	// Start definition of a character set
    ti_stop_bit_image,		// End printing bit image graphics
    ti_stop_char_set_def,	// End definition of a character set
    ti_subscript_characters,	// List of ``subscript-able'' characters
    ti_superscript_characters,	// List of ``superscript-able'' characters
    ti_these_cause_cr,		// Printing any of these chars causes cr
    ti_zero_motion,		// No motion for the subsequent character
    ti_char_set_names,		// List of character set names
    ti_key_mouse,		// Mouse event has occurred
    ti_mouse_info,		// Mouse status information
    ti_req_mouse_pos,		// Request mouse position
    ti_get_mouse,		// Curses should get button events
    ti_set_a_foreground,	// Set ANSI foreground color
    ti_set_a_background,	// Set ANSI background color
    ti_pkey_plab,		// Program f-key #1 to type #2 and show #3
    ti_device_type,		// Indicate language/codeset support
    ti_code_set_init,		// Init sequence for multiple codesets
    ti_set0_des_seq,		// Shift to code set 0 (EUC set 0, ASCII)
    ti_set1_des_seq,		// Shift to code set 1
    ti_set2_des_seq,		// Shift to code set 2
    ti_set3_des_seq,		// Shift to code set 3
    ti_set_lr_margin,		// Set both left and right margins to #1, #2
    ti_set_tb_margin,		// Set both top and bottom margins to #1, #2
    ti_bit_image_repeat,	// Repeat bit image cell #1 #2 times
    ti_bit_image_newline,	// Move to next row of the bit image
    ti_bit_image_carriage_return, // Move to beginning of same row
    ti_color_names,		// Give name for color #1
    ti_define_bit_image_region,	// Define rectangular bit image region
    ti_end_bit_image_region,	// End a bit image region
    ti_set_color_band,		// Change to ribbon color #1
    ti_set_page_length,		// Set page length to #1 lines
    ti_display_pc_char,		// Display PC character
    ti_entr_pc_charset_mode,	// Enable PC character display mode
    ti_exit_pc_charset_mode,	// Disable PC character display mode
    ti_entr_scancode_mode,	// Enable PC scancode mode
    ti_exit_scancode_mode,	// Disable PC scancode mode
    ti_pc_term_options,		// PC terminal options
    ti_scancode_escape,		// Escape for scancode emulation
    ti_alt_scancode_esc,	// Alternate escape for scancode emulation
};

enum ti_flg {			// pass this identifiers to tigetflg()
    ti_auto_left_margin = 0,	// cub1 wraps from column 0 to last column
    ti_auto_right_margin,	// Terminal has automatic margins
    ti_no_esc_ctlc,		// Beehive (f1=escape, f2=ctrl C)
    ti_ceol_standout_glitch,	// Standout not erased by overwriting (hp)
    ti_eat_newline_glitch,	// newline ignored after 80 cols (Concept)
    ti_erase_overstrike,	// Can erase overstrikes with a blank
    ti_generic_type,		// Generic line type (e.g. dialup, switch).
    ti_hard_copy,		// Hardcopy terminal
    ti_has_meta_key,		// Has a meta key (shift, sets parity bit)
    ti_has_status_line,		// Has extra "status line"
    ti_ins_null_glitch,		// Insert mode distinguishes nulls
    ti_mem_above,		// Display may be retained above the screen
    ti_mem_below,		// Display may be retained below the screen
    ti_move_insert_mode,	// Safe to move while in insert mode
    ti_move_standout_mode,	// Safe to move in standout modes
    ti_over_strike,		// Terminal overstrikes
    ti_status_line_esc_ok,	// Escape can be used on the status line
    ti_dest_tabs_magic_smso,	// Tabs destructive, magic so char (t1061)
    ti_tilde_glitch,		// Hazeltine; can't print ~'s
    ti_transparent_underline,	// underline character overstrikes
    ti_xon_xoff,		// Terminal uses xon/xoff handshaking
    ti_needs_xon_xoff,		// Padding won't work, xon/xoff required
    ti_prtr_silent,		// Printer won't echo on screen.
    ti_hard_cursor,		// Cursor is hard to see.
    ti_non_rev_rmcup,		// Smcup does not reverse rmcup.
    ti_no_pad_char,		// Pad character doesn't exist.
    ti_non_dest_scroll_region,	// Scrolling region is non-destructive.
    ti_can_change,		// Can re-define existing color
    ti_back_color_erase,	// Erases screen with current background
    ti_hue_lightness_saturation,// HLS color notation is used (Tek)
    ti_col_addr_glitch,		// Only positive motion for hpa/mhpa caps
    ti_cr_cancels_micro_mode,	// Using cr turns off micro mode
    ti_has_print_wheel,		// Printer needs operator to change char set
    ti_row_addr_glitch,		// Only positive motion for vpa/mvpa caps
    ti_semi_auto_right_margin,	// Printing in last column causes cr
    ti_cpi_changes_res,		// Changing char. pitch changes resolution
    ti_lpi_changes_res,		// Changing line pitch changes resolution
};

enum ti_num {			// pass this identifiers to tigetnum()
    ti_columns = 0,		// Number of columns in a line
    ti_init_tabs,		// Tabs initially every # spaces.
    ti_lines,			// Number of lines on screen or page
    ti_lines_of_memory,		// Lines of memory if > lines.  0 => varies
    ti_magic_cookie_glitch,	// Number blank chars left by smso or rmso
    ti_padding_baud_rate,	// Lowest baud rate where padding needed
    ti_virtual_terminal,	// Virtual terminal number (CB/Unix)
    ti_width_status_line,	// # columns in status line
    ti_num_labels,		// # of labels on screen (start at 1)
    ti_labl_height,		// # rows in each label
    ti_labl_width,		// # cols in each label
    ti_max_attributes,		// max combined video attr terminal can display
    ti_maximum_windows,		// Maximum number of defineable windows
    ti_max_colors,		// max # of color on the screen
    ti_max_pairs,		// max # of color pairs on the screen
    ti_no_color_video,		// Video attr that cannot be used with colors
    ti_buffer_capacity,		// Number of bytes buffered before printing
    ti_dot_vert_spacing,	// Spacing of pins vertically in pins per inch
    ti_dot_horz_spacing,	// Spacing of dots horiz. in dots per inch
    ti_max_micro_address,	// Maximum value in micro_..._address
    ti_max_micro_jump,		// Maximum value in parm_..._micro
    ti_micro_char_size,		// Character step size when in micro mode
    ti_micro_line_size,		// Line step size when in micro mode
    ti_number_of_pins,		// Number of pins in print-head
    ti_output_res_char,		// Horizontal resolution in units per character
    ti_output_res_line,		// Vertical resolution in units per line
    ti_output_res_horz_inch,	// Horizontal resolution in units per inch
    ti_output_res_vert_inch,	// Vertical resolution in units per inch
    ti_print_rate,		// Print rate in characters per second
    ti_wide_char_size,		// Character step size when in double wide mode
};


typedef void (*ti_out_t)(int ch, void *dat);

int ti_getent(struct tinfo *ti, char *term, char *terminfo);
int ti_getflg(struct tinfo *ti, enum ti_flg flag);
int ti_getnum(struct tinfo *ti, enum ti_num num);
char *ti_getstr(struct tinfo *ti, enum ti_str str);
char *ti_param(char *str, ti_out_t outfunc, void *outdat, ...);
void ti_puts(char *str, ti_out_t outfunc, void *outdat);

#endif /*TINFO_H*/
