#include "tinfo.h"

extern int open(), read(), close();

#if defined (i386)	/* little endian machines */
#define WORD(p)		(p)
#else			/* big endian machines */
#define WORD(p)		(((p >> 8) | (p << 8)) & 0xffff)
#endif

#ifdef NEED_STPCPY
static char *
stpcpy(to, from)
char *from, *to;
{
    while (*to++ = *from++)
	;
    return to-1;
}
#else
#include <string.h>
#endif



/*
 * Search for a terminal description in the terminfo database.
 *
 * Given is:
 *	t:	  buffer of type struct tinfo.
 *	term:	  the value of the TERM environment variable, or
 *		  NULL if not defined.
 *	terminfo: the value of the TERMINFO environment variable,
 *		  or NULL if not defined.
 *
 *	If term if NULL, terminal type 'dumb' is accessed.
 *	If terminfo is NULL or there's no entry for the given
 *	terminal in the specified directory, the default place
 *	'/usr/lib/terminfo' is searched.
 *
 *	Return value:
 *		-1 description not found
 *		 0 bad description
 *		else ok.
 */

int
ti_getent(struct tinfo *t, char *term, char *terminfo)
{
    char *x, *tmp = (char *)t;
    int n, tif = -1;

    if (t == 0)
	return -1;

    if (term == 0 || *term == '\0')
	term = "dumb";

    if (terminfo)
    {
	stpcpy(x = stpcpy(stpcpy(tmp, terminfo), "/./"), term);
	x[-2] = x[0];
	tif = open(tmp, 0);
	if (tif < 0)
	{
	    stpcpy(stpcpy(tmp, terminfo), "/");
	    tif = open(tmp, 0);
	}
    }
    if (tif < 0)
    {
	stpcpy(x = stpcpy(tmp, "/usr/lib/terminfo/./"), term);
	x[-2] = x[0];
	tif = open(tmp, 0);
    }

    if (tif >= 0)
    {
	n = read(tif, (void *)t, TICSIZE + 1);

	close(tif);

	if (n > 9 && n <= TICSIZE)
	{
	    #if WORD(0x1234) != 0x1234
	    t->magic = WORD(t->magic);
	    t->nname = WORD(t->nname);
	    t->nflgs = WORD(t->nflgs);
	    t->nnums = WORD(t->nnums);
	    t->nstrs = WORD(t->nstrs);
	    t->nchrs = WORD(t->nchrs);
	    #endif

	    if (t->magic == TIMAGIC)
	    {
		/* if there is padding, add a dummy false flag */
		if ((t->nname + t->nflgs) & 1)
		    t->data[t->nname + t->nflgs++] = 0;

		t->pflgs = t->data + t->nname;
		t->pnums = (ti_word *)(t->pflgs + t->nflgs);
		t->pstrs = t->pnums + t->nnums;
		t->pchrs = (ti_byte *)(t->pstrs + t->nstrs);

		if (t->pchrs + t->nchrs <= (ti_byte *)t + n)
		    return 1;
	    }
	}
	t->magic = ~TIMAGIC;
	return 0;
    }
    t->magic = ~TIMAGIC;
    return -1;
}



int
ti_getflg(struct tinfo *t, enum ti_flg flg)
{
    if (t == 0 || t->magic != TIMAGIC || flg < 0 || flg >= t->nflgs)
	return 0;

    if (t->pflgs[flg] == 0)
	return 0;

    return 1;
}



int
ti_getnum(struct tinfo *t, enum ti_num num)
{
    if (t == 0 || t->magic != TIMAGIC || num < 0 || num >= t->nnums)
	return -1;

    if (t->pnums[num] == 0xffff)
	return -1;

    return WORD(t->pnums[num]);
}



char *
ti_getstr(struct tinfo *t, enum ti_str _str)
{
    int str = _str - 256;

    if (t == 0 || t->magic != TIMAGIC || str < 0 || str >= t->nstrs)
	return 0;

    str = WORD(t->pstrs[str]);

    if (str < 0 || str >= t->nchrs)
	return 0;

    return (char *)(t->pchrs + str);
}



void
ti_puts(char *str, ti_out_t func, void *data)
{
    while (*str)
	func(*str++, data);
}
