/***** match *****
 *
 * look for a match between 'string' and 'pattern'
 * Pattern may be:  ?	    matches a single char
 *		    *	    matches any number of chars (even 0)
 *		    [xxx]   matches if char is any of xxx
 *		    [^xxx]  matches if chars is not in xxx
 *		    [x-y]   matches if chars is between x and y
 *		    The last three patterns may be combined (lmaa [0-9a-zA-Z_])
 * TRUE: if pattern matches string
 * FALSE: if not
 */

int
match(s,p)
char *s, *p;
{
    while (*p)
    {
	switch (*p)
	{
	    case '?':   if (*s++ == '\0')
			    return 0;
			p++;
			break;

	    case '[':   {
			    int reverse;
			    int last = 999;
			    int matched = 0;

			    if (*s == 0)
				return 0;

			    if (reverse = *++p == '^')
				p++;

			    while (*p && *p != ']')
			    {
				if (*p == '-' ? *s <= *++p && *s >= last : *s == *p)
				    matched = 1;
				if (last = *p)
				    p++;
			    }
			    if (matched == reverse)
				return 0;

			    if (*p)
				p++;
			    s++;
			}
			break;

	    case '*':   /* next 4 lines for speed only. only p++ necessary */
			while (*++p == '*')
			    ;
			if (*p == '\0')
			    return 1;

			if (*p != '?' && *p != '[' && *p != '\\')
			{
			    while (*s && *s != *p)
				++s;
			    if (*s == 0)
				return 0;
			}

			while (!match(s, p))
			    if (*s++ == '\0')
				return 0;
			return 1;

	    case '\\':  if (*++p == '\0')
			    break;

	    default:	if (*s++ != *p++)
			    return 0;
	}
    }
    return *s ? 0:1;
}
