/*
    slightly modified hashpjw function from the dragon book.

    returns a 32bit hash value != 0.
*/

unsigned long
hash_key(unsigned char *str)
{
    unsigned long h = 0;

    while (*str)
	h = (h << 4) ^ (h >> 28) ^ *str++;

    return h ? h : 1;
}





#ifdef 0

/* this is the original */

unsigned long
hash_key(unsigned char *str)
{
    unsigned long h = 0;
    unsigned long c;

    while (*str)
    {
	h = (h << 4) ^ *str++;
	if (c = (h & 0xf0000000))
	{
	    h ^= c >> 28;
	    h ^= c;
	}
    }
    return h;
}

#endif
