#ifndef ETLIB_ERROR_H
#define ETLIB_ERROR_H

#ifndef ETLIB_GENERIC_H
#include "generic.h"
#endif

NORETURN(fatal(const char *str, ...));
NORETURN(fatal_ioerror(const char *str));
void error(const char *str, ...);
void ioerror(const char *str);

#ifdef NODEBUG
#define error_if(x) (x)
#define fatal_if(x) (x)
#else
#define error_if(x) \
    do { if (x) error("%s", __FILE__ ":" __LINE__ ": " #x); } while (0)
#define fatal_if(x) \
    do { if (x) fatal("%s", __FILE__ ":" __LINE__ ": " #x); } while (0)
#endif

#endif /* ETLIB_ERROR_H */
