#include <stdio.h>
#include <stdarg.h>
#include "generic.h"
#include "prgname.h"
#include "error.h"

NORETURN(exit(int));


static void
print_prgname(void)
{
    if (prgname && *prgname)
	fprintf(stderr, "%s: ", prgname);
}

void
error(const char *str, ...)
{
    va_list args;

    va_start(args, str);
    print_prgname();
    vfprintf(stderr, str, args);
    fputc('\n', stderr);
}

void
ioerror(const char *str)
{
    print_prgname();
    perror(str);
//    fputc('\n', stderr);
}

void
fatal(const char *str, ...)
{
    va_list args;

    va_start(args, str);
    print_prgname();
    vfprintf(stderr, str, args);
    fputc('\n', stderr);
    exit(2);
}

void
fatal_ioerror(const char *str)
{
    print_prgname();
    perror(str);
//    fputc('\n', stderr);
    exit(2);
}
