


/*
 * Convert day (1-31), month (1-12), year (1970-2099) to days since 1.1.1970.
 */
unsigned
dmy2days(unsigned day, unsigned month, unsigned year)
{
    static short mdays[] = { 0,31,59,90,120,151,181,212,243,273,304,334 };

    year -= 1970;

    if (month < 2 || (year + 2) % 4)
	day--;
    return year * 365 + (year + 1) / 4 + mdays[month-1] + day;
}



/*
 * Convert days since 1.1.1970 to day (1-31), month (1-12), year (1970-2099).
 */
void
days2dmy(unsigned days, unsigned *day, unsigned *month, unsigned *year)
{
    unsigned y = (4 * days + 2) / 1461;		/* year since 1970 */
    unsigned j = (4 * days + 1226 ) % 1461 / 4;	/* days since 1. march */
    unsigned m = (32 * j + 12) / 979;		/* months since march */
    unsigned d = (32 * j + 12) % 979 / 32;	/* days since 1. of month */

    *day = 1 + d;
    *month = 1 + (m + 2) % 12;
    *year = 1970 + y;
}



#ifdef TEST
#include <stdio.h>

void
main(int argc, char **argv)
{
    unsigned i,j,d,m,y;

    for (i = 0; i < 130*365; ++i)
    {
	days2dmy(i, &d, &m, &y);
	j = dmy2days(d, m, y);

	if (i != j)
	    printf("ERROR: %d/%d %02d.%02d.%04d\n", i,j, d,m,y);
    }
    exit(0);
}
#endif
