/* iso latin-1 ctype like tables */
#ifndef ETLIB_CATTR_H
#define ETLIB_CATTR_H

#define _CATTR_LOWER	1	/* is lower case char */
#define _CATTR_UPPER	2	/* is upper case char */
#define _CATTR_ALPHA	4	/* any alpha (including _ and ) */
#define _CATTR_DIGIT	8	/* 0-9 */
#define _CATTR_XDIGIT	16	/* 0-9a-fA-F */
#define _CATTR_SPACE	32	/* space, tab, cr, 0xa0 */
#define _CATTR_CNTRL	64	/* 0x00-0x1f, 0x7f-0x9f */
#define _CATTR_PRINT	128	/* 0x20-0x7e, 0xa0-0xff */

/*
    Normally these macros get characters in the range
    0-255 or an EOF (-1).
    They will also return valid results for signed
    chars (range -128 to 127) with the exception
    for -1 (y umlaut) which will return attributes
    for EOF.

    note: is_space is 0x09,0x0d,0x20,0xa0 (tab,cr,sp,nbsp).
    	  is_alpha contains 0x5f (underscore).
    	  there are some chars which are lower case but without
    	  upper case counterpart (0xb5:micro, 0xdf:sharp s, 0xff:y umlaut).
    	  digitval(c) returns only valid data for c in [0-9a-zA-Z].

      These macros are save. That means, the argument is only evaluated once.
*/

#define is_lower(c)	(_ctype_attrib[128+(c)] & _CATTR_LOWER)
#define is_upper(c)	(_ctype_attrib[128+(c)] & _CATTR_UPPER)
#define is_digit(c)	(_ctype_attrib[128+(c)] & _CATTR_DIGIT)
#define is_xdigit(c)	(_ctype_attrib[128+(c)] & _CATTR_XDIGIT)
#define is_alpha(c)	(_ctype_attrib[128+(c)] & _CATTR_ALPHA)
#define is_alphanum(c)	(_ctype_attrib[128+(c)] & (_CATTR_ALPHA|_CATTR_DIGIT))
#define is_space(c)	(_ctype_attrib[128+(c)] & _CATTR_SPACE)
#define is_cntrl(c)	(_ctype_attrib[128+(c)] & _CATTR_CNTRL)
#define is_print(c)	(_ctype_attrib[128+(c)] & _CATTR_PRINT)
#define to_lower(c)	(_ctype_lower[128+(c)])
#define to_upper(c)	(_ctype_upper[128+(c)])
#define digitval(c)	(_ctype_digit[(c) - 0x30]) /* use is_[x]digit() first! */
#define to_digit(n)	(_ctype_to_digit[n])	/* 0<=n<=35 */

#define not_lower(c)	(!is_lower(c))
#define not_upper(c)	(!is_upper(c))
#define not_digit(c)	(!is_digit(c))
#define not_xdigit(c)	(!is_xdigit(c))
#define not_alpha(c)	(!is_alpha(c))
#define not_alphanum(c)	(!is_alphanum(c))
#define not_space(c)	(!is_space(c))
#define not_cntrl(c)	(!is_cntrl(c))
#define not_print(c)	(!is_print(c))

extern unsigned char _ctype_attrib[128+256];
extern unsigned char _ctype_lower[128+256];
extern unsigned char _ctype_upper[128+256];
extern unsigned char _ctype_digit[5*16];
extern unsigned char _ctype_to_digit[36+1];
extern unsigned char _ctype_to_Digit[36+1];

#endif /* ETLIB_CATTR_H */
