/* iso latin-1 ctype like tables */

#ifndef ETLIB_CATTR_H
#include "cattr.h"
#endif

#ifndef EOF
#define EOF -1
#endif

#define L _CATTR_LOWER|_CATTR_PRINT
#define U _CATTR_UPPER|_CATTR_PRINT
#define A _CATTR_ALPHA|_CATTR_PRINT
#define D _CATTR_DIGIT|_CATTR_PRINT|_CATTR_XDIGIT
#define X _CATTR_XDIGIT|_CATTR_PRINT
#define S _CATTR_SPACE
#define C _CATTR_CNTRL
#define P _CATTR_PRINT

#define sc S|C
#define la L|A
#define ua U|A
#define lx L|A|X
#define ux U|A|X
#define ps P|S


unsigned char _ctype_attrib[256+128] =
{
    /* first 8 lines when accessing with signed chars */
/* 80-8f */	 C, C, C, C, C, C, C, C, C, C, C, C, C, C, C, C,
/* 90-9f */	 C, C, C, C, C, C, C, C, C, C, C, C, C, C, C, C,
/* a0-af */	ps, P, P, P, P, P, P, P, P, P, P, P, P, P, P, P,
/* b0-bf */	 P, P, P, P, P, P, P, P, P, P, P, P, P, P, P, P,
/* c0-cf */	ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,
/* d0-df */	ua,ua,ua,ua,ua,ua,ua, P,ua,ua,ua,ua,ua,ua,ua,la, /* D7:times DF:sharp s */
/* e0-ef */	la,la,la,la,la,la,la,la,la,la,la,la,la,la,la,la,
/* f0-ff */	la,la,la,la,la,la,la, P,la,la,la,la,la,la,la,    /* F7:division FF:y umlaut */
/* EOF */	 0,
/* 00-0f */	 C, C, C, C, C, C, C, C, C,sc,sc, C, C,sc, C, C,
/* 10-1f */	 C, C, C, C, C, C, C, C, C, C, C, C, C, C, C, C,
/* 20-2f */	ps, P, P, P, P, P, P, P, P, P, P, P, P, P, P, P,
/* 30-3f */	 D, D, D, D, D, D, D, D, D, D, P, P, P, P, P, P,
/* 40-4f */	 P,ux,ux,ux,ux,ux,ux,ua,ua,ua,ua,ua,ua,ua,ua,ua,
/* 50-5f */	ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua, P, P, P, P, A,
/* 60-6f */	 P,lx,lx,lx,lx,lx,lx,la,la,la,la,la,la,la,la,la,
/* 70-7f */	la,la,la,la,la,la,la,la,la,la,la, P, P, P, P, C,
/* 80-8f */	 C, C, C, C, C, C, C, C, C, C, C, C, C, C, C, C,
/* 90-9f */	 C, C, C, C, C, C, C, C, C, C, C, C, C, C, C, C,
/* a0-af */	ps, P, P, P, P, P, P, P, P, P, P, P, P, P, P, P,
/* b0-bf */	 P, P, P, P, P,la, P, P, P, P, P, P, P, P, P, P, /* B5: micro */
/* c0-cf */	ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,ua,
/* d0-df */	ua,ua,ua,ua,ua,ua,ua, P,ua,ua,ua,ua,ua,ua,ua,la, /* D7:times DF:sharp s */
/* e0-ef */	la,la,la,la,la,la,la,la,la,la,la,la,la,la,la,la,
/* f0-ff */	la,la,la,la,la,la,la, P,la,la,la,la,la,la,la,la, /* F7:division FF:y umlaut */
};

unsigned char _ctype_digit[] = /* valid up to base 36 */
{
/* 30-3f */	 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0,
/* 40-4f */	 0,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
/* 50-5f */	25,26,27,28,29,30,31,32,33,34,35, 0, 0, 0, 0, 0,
/* 60-6f */	 0,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
/* 70-7f */	25,26,27,28,29,30,31,32,33,34,35, 0, 0, 0, 0, 0,
};

unsigned char _ctype_to_digit[] = "0123456789abcdefghijklmnopqrstuvwxyz";

unsigned char _ctype_lower[256+128] =
{
    /* first 8 lines when accessing with signed chars */
/* 80-8f */	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 90-9f */	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a0-af */	0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
/* b0-bf */	0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c0-cf */	0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* d0-df */	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xd7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xdf,
/* e0-ef */	0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* f0-ff */	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,
/* EOF */	EOF,
/* 00-0f */	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 10-1f */	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 20-2f */	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 30-3f */	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 40-4f */	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 50-5f */	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 60-6f */	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 70-7f */	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 80-8f */	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 90-9f */	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a0-af */	0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
/* b0-bf */	0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c0-cf */	0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* d0-df */	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xd7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xdf,
/* e0-ef */	0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* f0-ff */	0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff,
};

unsigned char _ctype_upper[256+128] =
{
    /* first 8 lines when accessing with signed chars */
/* 80-8f */	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 90-9f */	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a0-af */	0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
/* b0-bf */	0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c0-cf */	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* d0-df */	0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/* e0-ef */	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* f0-ff */	0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xf7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,
/* EOF */	EOF,
/* 00-0f */	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 10-1f */	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 20-2f */	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 30-3f */	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 40-4f */	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 50-5f */	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 60-6f */	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 70-7f */	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 80-8f */	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 90-9f */	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a0-af */	0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
/* b0-bf */	0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c0-cf */	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* d0-df */	0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/* e0-ef */	0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* f0-ff */	0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xf7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xff,
};
